/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response to a <code>ListHealthChecks</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListHealthChecksResponse extends Route53Response implements
        ToCopyableBuilder<ListHealthChecksResponse.Builder, ListHealthChecksResponse> {
    private static final SdkField<List<HealthCheck>> HEALTH_CHECKS_FIELD = SdkField
            .<List<HealthCheck>> builder(MarshallingType.LIST)
            .memberName("HealthChecks")
            .getter(getter(ListHealthChecksResponse::healthChecks))
            .setter(setter(Builder::healthChecks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthChecks")
                    .unmarshallLocationName("HealthChecks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("HealthCheck")
                            .memberFieldInfo(
                                    SdkField.<HealthCheck> builder(MarshallingType.SDK_POJO)
                                            .constructor(HealthCheck::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("HealthCheck").unmarshallLocationName("HealthCheck").build())
                                            .build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Marker")
            .getter(getter(ListHealthChecksResponse::marker))
            .setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker")
                    .unmarshallLocationName("Marker").build()).build();

    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsTruncated")
            .getter(getter(ListHealthChecksResponse::isTruncated))
            .setter(setter(Builder::isTruncated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated")
                    .unmarshallLocationName("IsTruncated").build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextMarker")
            .getter(getter(ListHealthChecksResponse::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker")
                    .unmarshallLocationName("NextMarker").build()).build();

    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MaxItems")
            .getter(getter(ListHealthChecksResponse::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems")
                    .unmarshallLocationName("MaxItems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEALTH_CHECKS_FIELD,
            MARKER_FIELD, IS_TRUNCATED_FIELD, NEXT_MARKER_FIELD, MAX_ITEMS_FIELD));

    private final List<HealthCheck> healthChecks;

    private final String marker;

    private final Boolean isTruncated;

    private final String nextMarker;

    private final String maxItems;

    private ListHealthChecksResponse(BuilderImpl builder) {
        super(builder);
        this.healthChecks = builder.healthChecks;
        this.marker = builder.marker;
        this.isTruncated = builder.isTruncated;
        this.nextMarker = builder.nextMarker;
        this.maxItems = builder.maxItems;
    }

    /**
     * For responses, this returns true if the service returned a value for the HealthChecks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHealthChecks() {
        return healthChecks != null && !(healthChecks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A complex type that contains one <code>HealthCheck</code> element for each health check that is associated with
     * the current Amazon Web Services account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHealthChecks} method.
     * </p>
     * 
     * @return A complex type that contains one <code>HealthCheck</code> element for each health check that is
     *         associated with the current Amazon Web Services account.
     */
    public final List<HealthCheck> healthChecks() {
        return healthChecks;
    }

    /**
     * <p>
     * For the second and subsequent calls to <code>ListHealthChecks</code>, <code>Marker</code> is the value that you
     * specified for the <code>marker</code> parameter in the previous request.
     * </p>
     * 
     * @return For the second and subsequent calls to <code>ListHealthChecks</code>, <code>Marker</code> is the value
     *         that you specified for the <code>marker</code> parameter in the previous request.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * A flag that indicates whether there are more health checks to be listed. If the response was truncated, you can
     * get the next group of health checks by submitting another <code>ListHealthChecks</code> request and specifying
     * the value of <code>NextMarker</code> in the <code>marker</code> parameter.
     * </p>
     * 
     * @return A flag that indicates whether there are more health checks to be listed. If the response was truncated,
     *         you can get the next group of health checks by submitting another <code>ListHealthChecks</code> request
     *         and specifying the value of <code>NextMarker</code> in the <code>marker</code> parameter.
     */
    public final Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the first
     * health check that Amazon Route 53 returns if you submit another <code>ListHealthChecks</code> request and specify
     * the value of <code>NextMarker</code> in the <code>marker</code> parameter.
     * </p>
     * 
     * @return If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the
     *         first health check that Amazon Route 53 returns if you submit another <code>ListHealthChecks</code>
     *         request and specify the value of <code>NextMarker</code> in the <code>marker</code> parameter.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    /**
     * <p>
     * The value that you specified for the <code>maxitems</code> parameter in the call to <code>ListHealthChecks</code>
     * that produced the current response.
     * </p>
     * 
     * @return The value that you specified for the <code>maxitems</code> parameter in the call to
     *         <code>ListHealthChecks</code> that produced the current response.
     */
    public final String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasHealthChecks() ? healthChecks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHealthChecksResponse)) {
            return false;
        }
        ListHealthChecksResponse other = (ListHealthChecksResponse) obj;
        return hasHealthChecks() == other.hasHealthChecks() && Objects.equals(healthChecks(), other.healthChecks())
                && Objects.equals(marker(), other.marker()) && Objects.equals(isTruncated(), other.isTruncated())
                && Objects.equals(nextMarker(), other.nextMarker()) && Objects.equals(maxItems(), other.maxItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListHealthChecksResponse").add("HealthChecks", hasHealthChecks() ? healthChecks() : null)
                .add("Marker", marker()).add("IsTruncated", isTruncated()).add("NextMarker", nextMarker())
                .add("MaxItems", maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HealthChecks":
            return Optional.ofNullable(clazz.cast(healthChecks()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "IsTruncated":
            return Optional.ofNullable(clazz.cast(isTruncated()));
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListHealthChecksResponse, T> g) {
        return obj -> g.apply((ListHealthChecksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo, CopyableBuilder<Builder, ListHealthChecksResponse> {
        /**
         * <p>
         * A complex type that contains one <code>HealthCheck</code> element for each health check that is associated
         * with the current Amazon Web Services account.
         * </p>
         * 
         * @param healthChecks
         *        A complex type that contains one <code>HealthCheck</code> element for each health check that is
         *        associated with the current Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthChecks(Collection<HealthCheck> healthChecks);

        /**
         * <p>
         * A complex type that contains one <code>HealthCheck</code> element for each health check that is associated
         * with the current Amazon Web Services account.
         * </p>
         * 
         * @param healthChecks
         *        A complex type that contains one <code>HealthCheck</code> element for each health check that is
         *        associated with the current Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthChecks(HealthCheck... healthChecks);

        /**
         * <p>
         * A complex type that contains one <code>HealthCheck</code> element for each health check that is associated
         * with the current Amazon Web Services account.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<HealthCheck>.Builder} avoiding the
         * need to create one manually via {@link List<HealthCheck>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HealthCheck>.Builder#build()} is called immediately and its
         * result is passed to {@link #healthChecks(List<HealthCheck>)}.
         * 
         * @param healthChecks
         *        a consumer that will call methods on {@link List<HealthCheck>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #healthChecks(List<HealthCheck>)
         */
        Builder healthChecks(Consumer<HealthCheck.Builder>... healthChecks);

        /**
         * <p>
         * For the second and subsequent calls to <code>ListHealthChecks</code>, <code>Marker</code> is the value that
         * you specified for the <code>marker</code> parameter in the previous request.
         * </p>
         * 
         * @param marker
         *        For the second and subsequent calls to <code>ListHealthChecks</code>, <code>Marker</code> is the value
         *        that you specified for the <code>marker</code> parameter in the previous request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A flag that indicates whether there are more health checks to be listed. If the response was truncated, you
         * can get the next group of health checks by submitting another <code>ListHealthChecks</code> request and
         * specifying the value of <code>NextMarker</code> in the <code>marker</code> parameter.
         * </p>
         * 
         * @param isTruncated
         *        A flag that indicates whether there are more health checks to be listed. If the response was
         *        truncated, you can get the next group of health checks by submitting another
         *        <code>ListHealthChecks</code> request and specifying the value of <code>NextMarker</code> in the
         *        <code>marker</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the first
         * health check that Amazon Route 53 returns if you submit another <code>ListHealthChecks</code> request and
         * specify the value of <code>NextMarker</code> in the <code>marker</code> parameter.
         * </p>
         * 
         * @param nextMarker
         *        If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the
         *        first health check that Amazon Route 53 returns if you submit another <code>ListHealthChecks</code>
         *        request and specify the value of <code>NextMarker</code> in the <code>marker</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * The value that you specified for the <code>maxitems</code> parameter in the call to
         * <code>ListHealthChecks</code> that produced the current response.
         * </p>
         * 
         * @param maxItems
         *        The value that you specified for the <code>maxitems</code> parameter in the call to
         *        <code>ListHealthChecks</code> that produced the current response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private List<HealthCheck> healthChecks = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private Boolean isTruncated;

        private String nextMarker;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHealthChecksResponse model) {
            super(model);
            healthChecks(model.healthChecks);
            marker(model.marker);
            isTruncated(model.isTruncated);
            nextMarker(model.nextMarker);
            maxItems(model.maxItems);
        }

        public final List<HealthCheck.Builder> getHealthChecks() {
            List<HealthCheck.Builder> result = HealthChecksCopier.copyToBuilder(this.healthChecks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHealthChecks(Collection<HealthCheck.BuilderImpl> healthChecks) {
            this.healthChecks = HealthChecksCopier.copyFromBuilder(healthChecks);
        }

        @Override
        @Transient
        public final Builder healthChecks(Collection<HealthCheck> healthChecks) {
            this.healthChecks = HealthChecksCopier.copy(healthChecks);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder healthChecks(HealthCheck... healthChecks) {
            healthChecks(Arrays.asList(healthChecks));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder healthChecks(Consumer<HealthCheck.Builder>... healthChecks) {
            healthChecks(Stream.of(healthChecks).map(c -> HealthCheck.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        @Override
        @Transient
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        @Transient
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        @Transient
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public ListHealthChecksResponse build() {
            return new ListHealthChecksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
