/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains change information for the resource record set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChangeResourceRecordSetsRequest extends Route53Request implements
        ToCopyableBuilder<ChangeResourceRecordSetsRequest.Builder, ChangeResourceRecordSetsRequest> {
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HostedZoneId")
            .getter(getter(ChangeResourceRecordSetsRequest::hostedZoneId))
            .setter(setter(Builder::hostedZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<ChangeBatch> CHANGE_BATCH_FIELD = SdkField
            .<ChangeBatch> builder(MarshallingType.SDK_POJO)
            .memberName("ChangeBatch")
            .getter(getter(ChangeResourceRecordSetsRequest::changeBatch))
            .setter(setter(Builder::changeBatch))
            .constructor(ChangeBatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeBatch")
                    .unmarshallLocationName("ChangeBatch").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONE_ID_FIELD,
            CHANGE_BATCH_FIELD));

    private final String hostedZoneId;

    private final ChangeBatch changeBatch;

    private ChangeResourceRecordSetsRequest(BuilderImpl builder) {
        super(builder);
        this.hostedZoneId = builder.hostedZoneId;
        this.changeBatch = builder.changeBatch;
    }

    /**
     * <p>
     * The ID of the hosted zone that contains the resource record sets that you want to change.
     * </p>
     * 
     * @return The ID of the hosted zone that contains the resource record sets that you want to change.
     */
    public final String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * A complex type that contains an optional comment and the <code>Changes</code> element.
     * </p>
     * 
     * @return A complex type that contains an optional comment and the <code>Changes</code> element.
     */
    public final ChangeBatch changeBatch() {
        return changeBatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(changeBatch());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeResourceRecordSetsRequest)) {
            return false;
        }
        ChangeResourceRecordSetsRequest other = (ChangeResourceRecordSetsRequest) obj;
        return Objects.equals(hostedZoneId(), other.hostedZoneId()) && Objects.equals(changeBatch(), other.changeBatch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChangeResourceRecordSetsRequest").add("HostedZoneId", hostedZoneId())
                .add("ChangeBatch", changeBatch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostedZoneId":
            return Optional.ofNullable(clazz.cast(hostedZoneId()));
        case "ChangeBatch":
            return Optional.ofNullable(clazz.cast(changeBatch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChangeResourceRecordSetsRequest, T> g) {
        return obj -> g.apply((ChangeResourceRecordSetsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Request.Builder, SdkPojo, CopyableBuilder<Builder, ChangeResourceRecordSetsRequest> {
        /**
         * <p>
         * The ID of the hosted zone that contains the resource record sets that you want to change.
         * </p>
         * 
         * @param hostedZoneId
         *        The ID of the hosted zone that contains the resource record sets that you want to change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * A complex type that contains an optional comment and the <code>Changes</code> element.
         * </p>
         * 
         * @param changeBatch
         *        A complex type that contains an optional comment and the <code>Changes</code> element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeBatch(ChangeBatch changeBatch);

        /**
         * <p>
         * A complex type that contains an optional comment and the <code>Changes</code> element.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChangeBatch.Builder} avoiding the need to
         * create one manually via {@link ChangeBatch#builder()}.
         *
         * When the {@link Consumer} completes, {@link ChangeBatch.Builder#build()} is called immediately and its result
         * is passed to {@link #changeBatch(ChangeBatch)}.
         * 
         * @param changeBatch
         *        a consumer that will call methods on {@link ChangeBatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #changeBatch(ChangeBatch)
         */
        default Builder changeBatch(Consumer<ChangeBatch.Builder> changeBatch) {
            return changeBatch(ChangeBatch.builder().applyMutation(changeBatch).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String hostedZoneId;

        private ChangeBatch changeBatch;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeResourceRecordSetsRequest model) {
            super(model);
            hostedZoneId(model.hostedZoneId);
            changeBatch(model.changeBatch);
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final ChangeBatch.Builder getChangeBatch() {
            return changeBatch != null ? changeBatch.toBuilder() : null;
        }

        public final void setChangeBatch(ChangeBatch.BuilderImpl changeBatch) {
            this.changeBatch = changeBatch != null ? changeBatch.build() : null;
        }

        @Override
        public final Builder changeBatch(ChangeBatch changeBatch) {
            this.changeBatch = changeBatch;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ChangeResourceRecordSetsRequest build() {
            return new ChangeResourceRecordSetsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
