/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateReusableDelegationSetResponse extends Route53Response implements
        ToCopyableBuilder<CreateReusableDelegationSetResponse.Builder, CreateReusableDelegationSetResponse> {
    private static final SdkField<DelegationSet> DELEGATION_SET_FIELD = SdkField
            .<DelegationSet> builder(MarshallingType.SDK_POJO)
            .memberName("DelegationSet")
            .getter(getter(CreateReusableDelegationSetResponse::delegationSet))
            .setter(setter(Builder::delegationSet))
            .constructor(DelegationSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DelegationSet")
                    .unmarshallLocationName("DelegationSet").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Location")
            .getter(getter(CreateReusableDelegationSetResponse::location))
            .setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Location")
                    .unmarshallLocationName("Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELEGATION_SET_FIELD,
            LOCATION_FIELD));

    private final DelegationSet delegationSet;

    private final String location;

    private CreateReusableDelegationSetResponse(BuilderImpl builder) {
        super(builder);
        this.delegationSet = builder.delegationSet;
        this.location = builder.location;
    }

    /**
     * <p>
     * A complex type that contains name server information.
     * </p>
     * 
     * @return A complex type that contains name server information.
     */
    public final DelegationSet delegationSet() {
        return delegationSet;
    }

    /**
     * <p>
     * The unique URL representing the new reusable delegation set.
     * </p>
     * 
     * @return The unique URL representing the new reusable delegation set.
     */
    public final String location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(delegationSet());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReusableDelegationSetResponse)) {
            return false;
        }
        CreateReusableDelegationSetResponse other = (CreateReusableDelegationSetResponse) obj;
        return Objects.equals(delegationSet(), other.delegationSet()) && Objects.equals(location(), other.location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateReusableDelegationSetResponse").add("DelegationSet", delegationSet())
                .add("Location", location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DelegationSet":
            return Optional.ofNullable(clazz.cast(delegationSet()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateReusableDelegationSetResponse, T> g) {
        return obj -> g.apply((CreateReusableDelegationSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateReusableDelegationSetResponse> {
        /**
         * <p>
         * A complex type that contains name server information.
         * </p>
         * 
         * @param delegationSet
         *        A complex type that contains name server information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegationSet(DelegationSet delegationSet);

        /**
         * <p>
         * A complex type that contains name server information.
         * </p>
         * This is a convenience method that creates an instance of the {@link DelegationSet.Builder} avoiding the need
         * to create one manually via {@link DelegationSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link DelegationSet.Builder#build()} is called immediately and its
         * result is passed to {@link #delegationSet(DelegationSet)}.
         * 
         * @param delegationSet
         *        a consumer that will call methods on {@link DelegationSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #delegationSet(DelegationSet)
         */
        default Builder delegationSet(Consumer<DelegationSet.Builder> delegationSet) {
            return delegationSet(DelegationSet.builder().applyMutation(delegationSet).build());
        }

        /**
         * <p>
         * The unique URL representing the new reusable delegation set.
         * </p>
         * 
         * @param location
         *        The unique URL representing the new reusable delegation set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private DelegationSet delegationSet;

        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReusableDelegationSetResponse model) {
            super(model);
            delegationSet(model.delegationSet);
            location(model.location);
        }

        public final DelegationSet.Builder getDelegationSet() {
            return delegationSet != null ? delegationSet.toBuilder() : null;
        }

        public final void setDelegationSet(DelegationSet.BuilderImpl delegationSet) {
            this.delegationSet = delegationSet != null ? delegationSet.build() : null;
        }

        @Override
        public final Builder delegationSet(DelegationSet delegationSet) {
            this.delegationSet = delegationSet;
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        @Override
        public CreateReusableDelegationSetResponse build() {
            return new CreateReusableDelegationSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
