/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response information from a <code>CreateVPCAssociationAuthorization</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVpcAssociationAuthorizationResponse extends Route53Response implements
        ToCopyableBuilder<CreateVpcAssociationAuthorizationResponse.Builder, CreateVpcAssociationAuthorizationResponse> {
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HostedZoneId")
            .getter(getter(CreateVpcAssociationAuthorizationResponse::hostedZoneId))
            .setter(setter(Builder::hostedZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneId")
                    .unmarshallLocationName("HostedZoneId").build()).build();

    private static final SdkField<VPC> VPC_FIELD = SdkField
            .<VPC> builder(MarshallingType.SDK_POJO)
            .memberName("VPC")
            .getter(getter(CreateVpcAssociationAuthorizationResponse::vpc))
            .setter(setter(Builder::vpc))
            .constructor(VPC::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPC").unmarshallLocationName("VPC")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONE_ID_FIELD,
            VPC_FIELD));

    private final String hostedZoneId;

    private final VPC vpc;

    private CreateVpcAssociationAuthorizationResponse(BuilderImpl builder) {
        super(builder);
        this.hostedZoneId = builder.hostedZoneId;
        this.vpc = builder.vpc;
    }

    /**
     * <p>
     * The ID of the hosted zone that you authorized associating a VPC with.
     * </p>
     * 
     * @return The ID of the hosted zone that you authorized associating a VPC with.
     */
    public final String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * The VPC that you authorized associating with a hosted zone.
     * </p>
     * 
     * @return The VPC that you authorized associating with a hosted zone.
     */
    public final VPC vpc() {
        return vpc;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(vpc());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcAssociationAuthorizationResponse)) {
            return false;
        }
        CreateVpcAssociationAuthorizationResponse other = (CreateVpcAssociationAuthorizationResponse) obj;
        return Objects.equals(hostedZoneId(), other.hostedZoneId()) && Objects.equals(vpc(), other.vpc());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateVpcAssociationAuthorizationResponse").add("HostedZoneId", hostedZoneId())
                .add("VPC", vpc()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostedZoneId":
            return Optional.ofNullable(clazz.cast(hostedZoneId()));
        case "VPC":
            return Optional.ofNullable(clazz.cast(vpc()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcAssociationAuthorizationResponse, T> g) {
        return obj -> g.apply((CreateVpcAssociationAuthorizationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateVpcAssociationAuthorizationResponse> {
        /**
         * <p>
         * The ID of the hosted zone that you authorized associating a VPC with.
         * </p>
         * 
         * @param hostedZoneId
         *        The ID of the hosted zone that you authorized associating a VPC with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * The VPC that you authorized associating with a hosted zone.
         * </p>
         * 
         * @param vpc
         *        The VPC that you authorized associating with a hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(VPC vpc);

        /**
         * <p>
         * The VPC that you authorized associating with a hosted zone.
         * </p>
         * This is a convenience method that creates an instance of the {@link VPC.Builder} avoiding the need to create
         * one manually via {@link VPC#builder()}.
         *
         * When the {@link Consumer} completes, {@link VPC.Builder#build()} is called immediately and its result is
         * passed to {@link #vpc(VPC)}.
         * 
         * @param vpc
         *        a consumer that will call methods on {@link VPC.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpc(VPC)
         */
        default Builder vpc(Consumer<VPC.Builder> vpc) {
            return vpc(VPC.builder().applyMutation(vpc).build());
        }
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private String hostedZoneId;

        private VPC vpc;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcAssociationAuthorizationResponse model) {
            super(model);
            hostedZoneId(model.hostedZoneId);
            vpc(model.vpc);
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final VPC.Builder getVpc() {
            return vpc != null ? vpc.toBuilder() : null;
        }

        public final void setVpc(VPC.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        @Override
        public final Builder vpc(VPC vpc) {
            this.vpc = vpc;
            return this;
        }

        @Override
        public CreateVpcAssociationAuthorizationResponse build() {
            return new CreateVpcAssociationAuthorizationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
