/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCidrCollectionsResponse extends Route53Response implements
        ToCopyableBuilder<ListCidrCollectionsResponse.Builder, ListCidrCollectionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(ListCidrCollectionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final SdkField<List<CollectionSummary>> CIDR_COLLECTIONS_FIELD = SdkField
            .<List<CollectionSummary>> builder(MarshallingType.LIST)
            .memberName("CidrCollections")
            .getter(getter(ListCidrCollectionsResponse::cidrCollections))
            .setter(setter(Builder::cidrCollections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrCollections")
                    .unmarshallLocationName("CidrCollections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CollectionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(CollectionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            CIDR_COLLECTIONS_FIELD));

    private final String nextToken;

    private final List<CollectionSummary> cidrCollections;

    private ListCidrCollectionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.cidrCollections = builder.cidrCollections;
    }

    /**
     * <p>
     * An opaque pagination token to indicate where the service is to begin enumerating results.
     * </p>
     * <p>
     * If no value is provided, the listing of results starts from the beginning.
     * </p>
     * 
     * @return An opaque pagination token to indicate where the service is to begin enumerating results.</p>
     *         <p>
     *         If no value is provided, the listing of results starts from the beginning.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CidrCollections property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCidrCollections() {
        return cidrCollections != null && !(cidrCollections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A complex type with information about the CIDR collection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCidrCollections} method.
     * </p>
     * 
     * @return A complex type with information about the CIDR collection.
     */
    public final List<CollectionSummary> cidrCollections() {
        return cidrCollections;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasCidrCollections() ? cidrCollections() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCidrCollectionsResponse)) {
            return false;
        }
        ListCidrCollectionsResponse other = (ListCidrCollectionsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasCidrCollections() == other.hasCidrCollections()
                && Objects.equals(cidrCollections(), other.cidrCollections());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCidrCollectionsResponse").add("NextToken", nextToken())
                .add("CidrCollections", hasCidrCollections() ? cidrCollections() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "CidrCollections":
            return Optional.ofNullable(clazz.cast(cidrCollections()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCidrCollectionsResponse, T> g) {
        return obj -> g.apply((ListCidrCollectionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo, CopyableBuilder<Builder, ListCidrCollectionsResponse> {
        /**
         * <p>
         * An opaque pagination token to indicate where the service is to begin enumerating results.
         * </p>
         * <p>
         * If no value is provided, the listing of results starts from the beginning.
         * </p>
         * 
         * @param nextToken
         *        An opaque pagination token to indicate where the service is to begin enumerating results.</p>
         *        <p>
         *        If no value is provided, the listing of results starts from the beginning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A complex type with information about the CIDR collection.
         * </p>
         * 
         * @param cidrCollections
         *        A complex type with information about the CIDR collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrCollections(Collection<CollectionSummary> cidrCollections);

        /**
         * <p>
         * A complex type with information about the CIDR collection.
         * </p>
         * 
         * @param cidrCollections
         *        A complex type with information about the CIDR collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrCollections(CollectionSummary... cidrCollections);

        /**
         * <p>
         * A complex type with information about the CIDR collection.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<CollectionSummary>.Builder} avoiding
         * the need to create one manually via {@link List<CollectionSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CollectionSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #cidrCollections(List<CollectionSummary>)}.
         * 
         * @param cidrCollections
         *        a consumer that will call methods on {@link List<CollectionSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cidrCollections(List<CollectionSummary>)
         */
        Builder cidrCollections(Consumer<CollectionSummary.Builder>... cidrCollections);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<CollectionSummary> cidrCollections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCidrCollectionsResponse model) {
            super(model);
            nextToken(model.nextToken);
            cidrCollections(model.cidrCollections);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CollectionSummary.Builder> getCidrCollections() {
            List<CollectionSummary.Builder> result = CollectionSummariesCopier.copyToBuilder(this.cidrCollections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCidrCollections(Collection<CollectionSummary.BuilderImpl> cidrCollections) {
            this.cidrCollections = CollectionSummariesCopier.copyFromBuilder(cidrCollections);
        }

        @Override
        public final Builder cidrCollections(Collection<CollectionSummary> cidrCollections) {
            this.cidrCollections = CollectionSummariesCopier.copy(cidrCollections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrCollections(CollectionSummary... cidrCollections) {
            cidrCollections(Arrays.asList(cidrCollections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrCollections(Consumer<CollectionSummary.Builder>... cidrCollections) {
            cidrCollections(Stream.of(cidrCollections).map(c -> CollectionSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCidrCollectionsResponse build() {
            return new ListCidrCollectionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
