/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * In the response to a <code>ListHostedZonesByVPC</code> request, the <code>HostedZoneSummaries</code> element contains
 * one <code>HostedZoneSummary</code> element for each hosted zone that the specified Amazon VPC is associated with.
 * Each <code>HostedZoneSummary</code> element contains the hosted zone name and ID, and information about who owns the
 * hosted zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HostedZoneSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<HostedZoneSummary.Builder, HostedZoneSummary> {
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HostedZoneId")
            .getter(getter(HostedZoneSummary::hostedZoneId))
            .setter(setter(Builder::hostedZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneId")
                    .unmarshallLocationName("HostedZoneId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(HostedZoneSummary::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<HostedZoneOwner> OWNER_FIELD = SdkField
            .<HostedZoneOwner> builder(MarshallingType.SDK_POJO)
            .memberName("Owner")
            .getter(getter(HostedZoneSummary::owner))
            .setter(setter(Builder::owner))
            .constructor(HostedZoneOwner::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner")
                    .unmarshallLocationName("Owner").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONE_ID_FIELD,
            NAME_FIELD, OWNER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String hostedZoneId;

    private final String name;

    private final HostedZoneOwner owner;

    private HostedZoneSummary(BuilderImpl builder) {
        this.hostedZoneId = builder.hostedZoneId;
        this.name = builder.name;
        this.owner = builder.owner;
    }

    /**
     * <p>
     * The Route 53 hosted zone ID of a private hosted zone that the specified VPC is associated with.
     * </p>
     * 
     * @return The Route 53 hosted zone ID of a private hosted zone that the specified VPC is associated with.
     */
    public final String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * The name of the private hosted zone, such as <code>example.com</code>.
     * </p>
     * 
     * @return The name of the private hosted zone, such as <code>example.com</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The owner of a private hosted zone that the specified VPC is associated with. The owner can be either an Amazon
     * Web Services account or an Amazon Web Services service.
     * </p>
     * 
     * @return The owner of a private hosted zone that the specified VPC is associated with. The owner can be either an
     *         Amazon Web Services account or an Amazon Web Services service.
     */
    public final HostedZoneOwner owner() {
        return owner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostedZoneSummary)) {
            return false;
        }
        HostedZoneSummary other = (HostedZoneSummary) obj;
        return Objects.equals(hostedZoneId(), other.hostedZoneId()) && Objects.equals(name(), other.name())
                && Objects.equals(owner(), other.owner());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HostedZoneSummary").add("HostedZoneId", hostedZoneId()).add("Name", name())
                .add("Owner", owner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostedZoneId":
            return Optional.ofNullable(clazz.cast(hostedZoneId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HostedZoneSummary, T> g) {
        return obj -> g.apply((HostedZoneSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HostedZoneSummary> {
        /**
         * <p>
         * The Route 53 hosted zone ID of a private hosted zone that the specified VPC is associated with.
         * </p>
         * 
         * @param hostedZoneId
         *        The Route 53 hosted zone ID of a private hosted zone that the specified VPC is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * The name of the private hosted zone, such as <code>example.com</code>.
         * </p>
         * 
         * @param name
         *        The name of the private hosted zone, such as <code>example.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The owner of a private hosted zone that the specified VPC is associated with. The owner can be either an
         * Amazon Web Services account or an Amazon Web Services service.
         * </p>
         * 
         * @param owner
         *        The owner of a private hosted zone that the specified VPC is associated with. The owner can be either
         *        an Amazon Web Services account or an Amazon Web Services service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(HostedZoneOwner owner);

        /**
         * <p>
         * The owner of a private hosted zone that the specified VPC is associated with. The owner can be either an
         * Amazon Web Services account or an Amazon Web Services service.
         * </p>
         * This is a convenience method that creates an instance of the {@link HostedZoneOwner.Builder} avoiding the
         * need to create one manually via {@link HostedZoneOwner#builder()}.
         *
         * When the {@link Consumer} completes, {@link HostedZoneOwner.Builder#build()} is called immediately and its
         * result is passed to {@link #owner(HostedZoneOwner)}.
         * 
         * @param owner
         *        a consumer that will call methods on {@link HostedZoneOwner.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #owner(HostedZoneOwner)
         */
        default Builder owner(Consumer<HostedZoneOwner.Builder> owner) {
            return owner(HostedZoneOwner.builder().applyMutation(owner).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String hostedZoneId;

        private String name;

        private HostedZoneOwner owner;

        private BuilderImpl() {
        }

        private BuilderImpl(HostedZoneSummary model) {
            hostedZoneId(model.hostedZoneId);
            name(model.name);
            owner(model.owner);
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final HostedZoneOwner.Builder getOwner() {
            return owner != null ? owner.toBuilder() : null;
        }

        public final void setOwner(HostedZoneOwner.BuilderImpl owner) {
            this.owner = owner != null ? owner.build() : null;
        }

        @Override
        public final Builder owner(HostedZoneOwner owner) {
            this.owner = owner;
            return this;
        }

        @Override
        public HostedZoneSummary build() {
            return new HostedZoneSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
