/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the information about the request to list the traffic policies that are associated with
 * the current Amazon Web Services account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTrafficPoliciesRequest extends Route53Request implements
        ToCopyableBuilder<ListTrafficPoliciesRequest.Builder, ListTrafficPoliciesRequest> {
    private static final SdkField<String> TRAFFIC_POLICY_ID_MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrafficPolicyIdMarker")
            .getter(getter(ListTrafficPoliciesRequest::trafficPolicyIdMarker))
            .setter(setter(Builder::trafficPolicyIdMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("trafficpolicyid")
                    .unmarshallLocationName("trafficpolicyid").build()).build();

    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MaxItems")
            .getter(getter(ListTrafficPoliciesRequest::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxitems")
                    .unmarshallLocationName("maxitems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRAFFIC_POLICY_ID_MARKER_FIELD, MAX_ITEMS_FIELD));

    private final String trafficPolicyIdMarker;

    private final String maxItems;

    private ListTrafficPoliciesRequest(BuilderImpl builder) {
        super(builder);
        this.trafficPolicyIdMarker = builder.trafficPolicyIdMarker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * (Conditional) For your first request to <code>ListTrafficPolicies</code>, don't include the
     * <code>TrafficPolicyIdMarker</code> parameter.
     * </p>
     * <p>
     * If you have more traffic policies than the value of <code>MaxItems</code>, <code>ListTrafficPolicies</code>
     * returns only the first <code>MaxItems</code> traffic policies. To get the next group of policies, submit another
     * request to <code>ListTrafficPolicies</code>. For the value of <code>TrafficPolicyIdMarker</code>, specify the
     * value of <code>TrafficPolicyIdMarker</code> that was returned in the previous response.
     * </p>
     * 
     * @return (Conditional) For your first request to <code>ListTrafficPolicies</code>, don't include the
     *         <code>TrafficPolicyIdMarker</code> parameter.</p>
     *         <p>
     *         If you have more traffic policies than the value of <code>MaxItems</code>,
     *         <code>ListTrafficPolicies</code> returns only the first <code>MaxItems</code> traffic policies. To get
     *         the next group of policies, submit another request to <code>ListTrafficPolicies</code>. For the value of
     *         <code>TrafficPolicyIdMarker</code>, specify the value of <code>TrafficPolicyIdMarker</code> that was
     *         returned in the previous response.
     */
    public final String trafficPolicyIdMarker() {
        return trafficPolicyIdMarker;
    }

    /**
     * <p>
     * (Optional) The maximum number of traffic policies that you want Amazon Route 53 to return in response to this
     * request. If you have more than <code>MaxItems</code> traffic policies, the value of <code>IsTruncated</code> in
     * the response is <code>true</code>, and the value of <code>TrafficPolicyIdMarker</code> is the ID of the first
     * traffic policy that Route 53 will return if you submit another request.
     * </p>
     * 
     * @return (Optional) The maximum number of traffic policies that you want Amazon Route 53 to return in response to
     *         this request. If you have more than <code>MaxItems</code> traffic policies, the value of
     *         <code>IsTruncated</code> in the response is <code>true</code>, and the value of
     *         <code>TrafficPolicyIdMarker</code> is the ID of the first traffic policy that Route 53 will return if you
     *         submit another request.
     */
    public final String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyIdMarker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrafficPoliciesRequest)) {
            return false;
        }
        ListTrafficPoliciesRequest other = (ListTrafficPoliciesRequest) obj;
        return Objects.equals(trafficPolicyIdMarker(), other.trafficPolicyIdMarker())
                && Objects.equals(maxItems(), other.maxItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTrafficPoliciesRequest").add("TrafficPolicyIdMarker", trafficPolicyIdMarker())
                .add("MaxItems", maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficPolicyIdMarker":
            return Optional.ofNullable(clazz.cast(trafficPolicyIdMarker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTrafficPoliciesRequest, T> g) {
        return obj -> g.apply((ListTrafficPoliciesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Request.Builder, SdkPojo, CopyableBuilder<Builder, ListTrafficPoliciesRequest> {
        /**
         * <p>
         * (Conditional) For your first request to <code>ListTrafficPolicies</code>, don't include the
         * <code>TrafficPolicyIdMarker</code> parameter.
         * </p>
         * <p>
         * If you have more traffic policies than the value of <code>MaxItems</code>, <code>ListTrafficPolicies</code>
         * returns only the first <code>MaxItems</code> traffic policies. To get the next group of policies, submit
         * another request to <code>ListTrafficPolicies</code>. For the value of <code>TrafficPolicyIdMarker</code>,
         * specify the value of <code>TrafficPolicyIdMarker</code> that was returned in the previous response.
         * </p>
         * 
         * @param trafficPolicyIdMarker
         *        (Conditional) For your first request to <code>ListTrafficPolicies</code>, don't include the
         *        <code>TrafficPolicyIdMarker</code> parameter.</p>
         *        <p>
         *        If you have more traffic policies than the value of <code>MaxItems</code>,
         *        <code>ListTrafficPolicies</code> returns only the first <code>MaxItems</code> traffic policies. To get
         *        the next group of policies, submit another request to <code>ListTrafficPolicies</code>. For the value
         *        of <code>TrafficPolicyIdMarker</code>, specify the value of <code>TrafficPolicyIdMarker</code> that
         *        was returned in the previous response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyIdMarker(String trafficPolicyIdMarker);

        /**
         * <p>
         * (Optional) The maximum number of traffic policies that you want Amazon Route 53 to return in response to this
         * request. If you have more than <code>MaxItems</code> traffic policies, the value of <code>IsTruncated</code>
         * in the response is <code>true</code>, and the value of <code>TrafficPolicyIdMarker</code> is the ID of the
         * first traffic policy that Route 53 will return if you submit another request.
         * </p>
         * 
         * @param maxItems
         *        (Optional) The maximum number of traffic policies that you want Amazon Route 53 to return in response
         *        to this request. If you have more than <code>MaxItems</code> traffic policies, the value of
         *        <code>IsTruncated</code> in the response is <code>true</code>, and the value of
         *        <code>TrafficPolicyIdMarker</code> is the ID of the first traffic policy that Route 53 will return if
         *        you submit another request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String trafficPolicyIdMarker;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrafficPoliciesRequest model) {
            super(model);
            trafficPolicyIdMarker(model.trafficPolicyIdMarker);
            maxItems(model.maxItems);
        }

        public final String getTrafficPolicyIdMarker() {
            return trafficPolicyIdMarker;
        }

        public final void setTrafficPolicyIdMarker(String trafficPolicyIdMarker) {
            this.trafficPolicyIdMarker = trafficPolicyIdMarker;
        }

        @Override
        public final Builder trafficPolicyIdMarker(String trafficPolicyIdMarker) {
            this.trafficPolicyIdMarker = trafficPolicyIdMarker;
            return this;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTrafficPoliciesRequest build() {
            return new ListTrafficPoliciesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
