/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response information for the traffic policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTrafficPolicyCommentResponse extends Route53Response implements
        ToCopyableBuilder<UpdateTrafficPolicyCommentResponse.Builder, UpdateTrafficPolicyCommentResponse> {
    private static final SdkField<TrafficPolicy> TRAFFIC_POLICY_FIELD = SdkField
            .<TrafficPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("TrafficPolicy")
            .getter(getter(UpdateTrafficPolicyCommentResponse::trafficPolicy))
            .setter(setter(Builder::trafficPolicy))
            .constructor(TrafficPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicy")
                    .unmarshallLocationName("TrafficPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_POLICY_FIELD));

    private final TrafficPolicy trafficPolicy;

    private UpdateTrafficPolicyCommentResponse(BuilderImpl builder) {
        super(builder);
        this.trafficPolicy = builder.trafficPolicy;
    }

    /**
     * <p>
     * A complex type that contains settings for the specified traffic policy.
     * </p>
     * 
     * @return A complex type that contains settings for the specified traffic policy.
     */
    public final TrafficPolicy trafficPolicy() {
        return trafficPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrafficPolicyCommentResponse)) {
            return false;
        }
        UpdateTrafficPolicyCommentResponse other = (UpdateTrafficPolicyCommentResponse) obj;
        return Objects.equals(trafficPolicy(), other.trafficPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTrafficPolicyCommentResponse").add("TrafficPolicy", trafficPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficPolicy":
            return Optional.ofNullable(clazz.cast(trafficPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTrafficPolicyCommentResponse, T> g) {
        return obj -> g.apply((UpdateTrafficPolicyCommentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateTrafficPolicyCommentResponse> {
        /**
         * <p>
         * A complex type that contains settings for the specified traffic policy.
         * </p>
         * 
         * @param trafficPolicy
         *        A complex type that contains settings for the specified traffic policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicy(TrafficPolicy trafficPolicy);

        /**
         * <p>
         * A complex type that contains settings for the specified traffic policy.
         * </p>
         * This is a convenience that creates an instance of the {@link TrafficPolicy.Builder} avoiding the need to
         * create one manually via {@link TrafficPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrafficPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #trafficPolicy(TrafficPolicy)}.
         * 
         * @param trafficPolicy
         *        a consumer that will call methods on {@link TrafficPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trafficPolicy(TrafficPolicy)
         */
        default Builder trafficPolicy(Consumer<TrafficPolicy.Builder> trafficPolicy) {
            return trafficPolicy(TrafficPolicy.builder().applyMutation(trafficPolicy).build());
        }
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private TrafficPolicy trafficPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrafficPolicyCommentResponse model) {
            super(model);
            trafficPolicy(model.trafficPolicy);
        }

        public final TrafficPolicy.Builder getTrafficPolicy() {
            return trafficPolicy != null ? trafficPolicy.toBuilder() : null;
        }

        public final void setTrafficPolicy(TrafficPolicy.BuilderImpl trafficPolicy) {
            this.trafficPolicy = trafficPolicy != null ? trafficPolicy.build() : null;
        }

        @Override
        @Transient
        public final Builder trafficPolicy(TrafficPolicy trafficPolicy) {
            this.trafficPolicy = trafficPolicy;
            return this;
        }

        @Override
        public UpdateTrafficPolicyCommentResponse build() {
            return new UpdateTrafficPolicyCommentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
