/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response to a <code>GetHostedZoneCount</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetHostedZoneCountResponse extends Route53Response implements
        ToCopyableBuilder<GetHostedZoneCountResponse.Builder, GetHostedZoneCountResponse> {
    private static final SdkField<Long> HOSTED_ZONE_COUNT_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("HostedZoneCount")
            .getter(getter(GetHostedZoneCountResponse::hostedZoneCount))
            .setter(setter(Builder::hostedZoneCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneCount")
                    .unmarshallLocationName("HostedZoneCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONE_COUNT_FIELD));

    private final Long hostedZoneCount;

    private GetHostedZoneCountResponse(BuilderImpl builder) {
        super(builder);
        this.hostedZoneCount = builder.hostedZoneCount;
    }

    /**
     * <p>
     * The total number of public and private hosted zones that are associated with the current account.
     * </p>
     * 
     * @return The total number of public and private hosted zones that are associated with the current account.
     */
    public final Long hostedZoneCount() {
        return hostedZoneCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHostedZoneCountResponse)) {
            return false;
        }
        GetHostedZoneCountResponse other = (GetHostedZoneCountResponse) obj;
        return Objects.equals(hostedZoneCount(), other.hostedZoneCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetHostedZoneCountResponse").add("HostedZoneCount", hostedZoneCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostedZoneCount":
            return Optional.ofNullable(clazz.cast(hostedZoneCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetHostedZoneCountResponse, T> g) {
        return obj -> g.apply((GetHostedZoneCountResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo, CopyableBuilder<Builder, GetHostedZoneCountResponse> {
        /**
         * <p>
         * The total number of public and private hosted zones that are associated with the current account.
         * </p>
         * 
         * @param hostedZoneCount
         *        The total number of public and private hosted zones that are associated with the current account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneCount(Long hostedZoneCount);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private Long hostedZoneCount;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHostedZoneCountResponse model) {
            super(model);
            hostedZoneCount(model.hostedZoneCount);
        }

        public final Long getHostedZoneCount() {
            return hostedZoneCount;
        }

        @Override
        public final Builder hostedZoneCount(Long hostedZoneCount) {
            this.hostedZoneCount = hostedZoneCount;
            return this;
        }

        public final void setHostedZoneCount(Long hostedZoneCount) {
            this.hostedZoneCount = hostedZoneCount;
        }

        @Override
        public GetHostedZoneCountResponse build() {
            return new GetHostedZoneCountResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
