/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The information for each resource record set that you want to change.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Change implements SdkPojo, Serializable, ToCopyableBuilder<Change.Builder, Change> {
    private static final SdkField<String> ACTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Action")
            .getter(getter(Change::actionAsString))
            .setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action")
                    .unmarshallLocationName("Action").build()).build();

    private static final SdkField<ResourceRecordSet> RESOURCE_RECORD_SET_FIELD = SdkField
            .<ResourceRecordSet> builder(MarshallingType.SDK_POJO)
            .memberName("ResourceRecordSet")
            .getter(getter(Change::resourceRecordSet))
            .setter(setter(Builder::resourceRecordSet))
            .constructor(ResourceRecordSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRecordSet")
                    .unmarshallLocationName("ResourceRecordSet").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            RESOURCE_RECORD_SET_FIELD));

    private static final long serialVersionUID = 1L;

    private final String action;

    private final ResourceRecordSet resourceRecordSet;

    private Change(BuilderImpl builder) {
        this.action = builder.action;
        this.resourceRecordSet = builder.resourceRecordSet;
    }

    /**
     * <p>
     * The action to perform:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE</code>: Creates a resource record set that has the specified values.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE</code>: Deletes a existing resource record set.
     * </p>
     * <important>
     * <p>
     * To delete the resource record set that is associated with a traffic policy instance, use <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicyInstance.html"
     * >DeleteTrafficPolicyInstance</a>. Amazon Route 53 will delete the resource record set automatically. If you
     * delete the resource record set by using <code>ChangeResourceRecordSets</code>, Route 53 doesn't automatically
     * delete the traffic policy instance, and you'll continue to be charged for it even though it's no longer in use.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <code>UPSERT</code>: If a resource record set doesn't already exist, Route 53 creates it. If a resource record
     * set does exist, Route 53 updates it with the values in the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action to perform:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE</code>: Creates a resource record set that has the specified values.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE</code>: Deletes a existing resource record set.
     *         </p>
     *         <important>
     *         <p>
     *         To delete the resource record set that is associated with a traffic policy instance, use <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicyInstance.html"
     *         >DeleteTrafficPolicyInstance</a>. Amazon Route 53 will delete the resource record set automatically. If
     *         you delete the resource record set by using <code>ChangeResourceRecordSets</code>, Route 53 doesn't
     *         automatically delete the traffic policy instance, and you'll continue to be charged for it even though
     *         it's no longer in use.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         <code>UPSERT</code>: If a resource record set doesn't already exist, Route 53 creates it. If a resource
     *         record set does exist, Route 53 updates it with the values in the request.
     *         </p>
     *         </li>
     * @see ChangeAction
     */
    public final ChangeAction action() {
        return ChangeAction.fromValue(action);
    }

    /**
     * <p>
     * The action to perform:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE</code>: Creates a resource record set that has the specified values.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE</code>: Deletes a existing resource record set.
     * </p>
     * <important>
     * <p>
     * To delete the resource record set that is associated with a traffic policy instance, use <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicyInstance.html"
     * >DeleteTrafficPolicyInstance</a>. Amazon Route 53 will delete the resource record set automatically. If you
     * delete the resource record set by using <code>ChangeResourceRecordSets</code>, Route 53 doesn't automatically
     * delete the traffic policy instance, and you'll continue to be charged for it even though it's no longer in use.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <code>UPSERT</code>: If a resource record set doesn't already exist, Route 53 creates it. If a resource record
     * set does exist, Route 53 updates it with the values in the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action to perform:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE</code>: Creates a resource record set that has the specified values.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE</code>: Deletes a existing resource record set.
     *         </p>
     *         <important>
     *         <p>
     *         To delete the resource record set that is associated with a traffic policy instance, use <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicyInstance.html"
     *         >DeleteTrafficPolicyInstance</a>. Amazon Route 53 will delete the resource record set automatically. If
     *         you delete the resource record set by using <code>ChangeResourceRecordSets</code>, Route 53 doesn't
     *         automatically delete the traffic policy instance, and you'll continue to be charged for it even though
     *         it's no longer in use.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         <code>UPSERT</code>: If a resource record set doesn't already exist, Route 53 creates it. If a resource
     *         record set does exist, Route 53 updates it with the values in the request.
     *         </p>
     *         </li>
     * @see ChangeAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * Information about the resource record set to create, delete, or update.
     * </p>
     * 
     * @return Information about the resource record set to create, delete, or update.
     */
    public final ResourceRecordSet resourceRecordSet() {
        return resourceRecordSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceRecordSet());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Change)) {
            return false;
        }
        Change other = (Change) obj;
        return Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(resourceRecordSet(), other.resourceRecordSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Change").add("Action", actionAsString()).add("ResourceRecordSet", resourceRecordSet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "ResourceRecordSet":
            return Optional.ofNullable(clazz.cast(resourceRecordSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Change, T> g) {
        return obj -> g.apply((Change) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Change> {
        /**
         * <p>
         * The action to perform:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE</code>: Creates a resource record set that has the specified values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE</code>: Deletes a existing resource record set.
         * </p>
         * <important>
         * <p>
         * To delete the resource record set that is associated with a traffic policy instance, use <a
         * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicyInstance.html"
         * >DeleteTrafficPolicyInstance</a>. Amazon Route 53 will delete the resource record set automatically. If you
         * delete the resource record set by using <code>ChangeResourceRecordSets</code>, Route 53 doesn't automatically
         * delete the traffic policy instance, and you'll continue to be charged for it even though it's no longer in
         * use.
         * </p>
         * </important></li>
         * <li>
         * <p>
         * <code>UPSERT</code>: If a resource record set doesn't already exist, Route 53 creates it. If a resource
         * record set does exist, Route 53 updates it with the values in the request.
         * </p>
         * </li>
         * </ul>
         * 
         * @param action
         *        The action to perform:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE</code>: Creates a resource record set that has the specified values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE</code>: Deletes a existing resource record set.
         *        </p>
         *        <important>
         *        <p>
         *        To delete the resource record set that is associated with a traffic policy instance, use <a
         *        href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicyInstance.html"
         *        >DeleteTrafficPolicyInstance</a>. Amazon Route 53 will delete the resource record set automatically.
         *        If you delete the resource record set by using <code>ChangeResourceRecordSets</code>, Route 53 doesn't
         *        automatically delete the traffic policy instance, and you'll continue to be charged for it even though
         *        it's no longer in use.
         *        </p>
         *        </important></li>
         *        <li>
         *        <p>
         *        <code>UPSERT</code>: If a resource record set doesn't already exist, Route 53 creates it. If a
         *        resource record set does exist, Route 53 updates it with the values in the request.
         *        </p>
         *        </li>
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action to perform:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE</code>: Creates a resource record set that has the specified values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE</code>: Deletes a existing resource record set.
         * </p>
         * <important>
         * <p>
         * To delete the resource record set that is associated with a traffic policy instance, use <a
         * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicyInstance.html"
         * >DeleteTrafficPolicyInstance</a>. Amazon Route 53 will delete the resource record set automatically. If you
         * delete the resource record set by using <code>ChangeResourceRecordSets</code>, Route 53 doesn't automatically
         * delete the traffic policy instance, and you'll continue to be charged for it even though it's no longer in
         * use.
         * </p>
         * </important></li>
         * <li>
         * <p>
         * <code>UPSERT</code>: If a resource record set doesn't already exist, Route 53 creates it. If a resource
         * record set does exist, Route 53 updates it with the values in the request.
         * </p>
         * </li>
         * </ul>
         * 
         * @param action
         *        The action to perform:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE</code>: Creates a resource record set that has the specified values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE</code>: Deletes a existing resource record set.
         *        </p>
         *        <important>
         *        <p>
         *        To delete the resource record set that is associated with a traffic policy instance, use <a
         *        href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicyInstance.html"
         *        >DeleteTrafficPolicyInstance</a>. Amazon Route 53 will delete the resource record set automatically.
         *        If you delete the resource record set by using <code>ChangeResourceRecordSets</code>, Route 53 doesn't
         *        automatically delete the traffic policy instance, and you'll continue to be charged for it even though
         *        it's no longer in use.
         *        </p>
         *        </important></li>
         *        <li>
         *        <p>
         *        <code>UPSERT</code>: If a resource record set doesn't already exist, Route 53 creates it. If a
         *        resource record set does exist, Route 53 updates it with the values in the request.
         *        </p>
         *        </li>
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(ChangeAction action);

        /**
         * <p>
         * Information about the resource record set to create, delete, or update.
         * </p>
         * 
         * @param resourceRecordSet
         *        Information about the resource record set to create, delete, or update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRecordSet(ResourceRecordSet resourceRecordSet);

        /**
         * <p>
         * Information about the resource record set to create, delete, or update.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceRecordSet.Builder} avoiding the
         * need to create one manually via {@link ResourceRecordSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceRecordSet.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceRecordSet(ResourceRecordSet)}.
         * 
         * @param resourceRecordSet
         *        a consumer that will call methods on {@link ResourceRecordSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceRecordSet(ResourceRecordSet)
         */
        default Builder resourceRecordSet(Consumer<ResourceRecordSet.Builder> resourceRecordSet) {
            return resourceRecordSet(ResourceRecordSet.builder().applyMutation(resourceRecordSet).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private ResourceRecordSet resourceRecordSet;

        private BuilderImpl() {
        }

        private BuilderImpl(Change model) {
            action(model.action);
            resourceRecordSet(model.resourceRecordSet);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final ResourceRecordSet.Builder getResourceRecordSet() {
            return resourceRecordSet != null ? resourceRecordSet.toBuilder() : null;
        }

        public final void setResourceRecordSet(ResourceRecordSet.BuilderImpl resourceRecordSet) {
            this.resourceRecordSet = resourceRecordSet != null ? resourceRecordSet.build() : null;
        }

        @Override
        public final Builder resourceRecordSet(ResourceRecordSet resourceRecordSet) {
            this.resourceRecordSet = resourceRecordSet;
            return this;
        }

        @Override
        public Change build() {
            return new Change(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
