/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.route53.model.ActivateKeySigningKeyRequest;
import software.amazon.awssdk.services.route53.model.ActivateKeySigningKeyResponse;
import software.amazon.awssdk.services.route53.model.AssociateVpcWithHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.AssociateVpcWithHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.ChangeCidrCollectionRequest;
import software.amazon.awssdk.services.route53.model.ChangeCidrCollectionResponse;
import software.amazon.awssdk.services.route53.model.ChangeResourceRecordSetsRequest;
import software.amazon.awssdk.services.route53.model.ChangeResourceRecordSetsResponse;
import software.amazon.awssdk.services.route53.model.ChangeTagsForResourceRequest;
import software.amazon.awssdk.services.route53.model.ChangeTagsForResourceResponse;
import software.amazon.awssdk.services.route53.model.CreateCidrCollectionRequest;
import software.amazon.awssdk.services.route53.model.CreateCidrCollectionResponse;
import software.amazon.awssdk.services.route53.model.CreateHealthCheckRequest;
import software.amazon.awssdk.services.route53.model.CreateHealthCheckResponse;
import software.amazon.awssdk.services.route53.model.CreateHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.CreateHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.CreateKeySigningKeyRequest;
import software.amazon.awssdk.services.route53.model.CreateKeySigningKeyResponse;
import software.amazon.awssdk.services.route53.model.CreateQueryLoggingConfigRequest;
import software.amazon.awssdk.services.route53.model.CreateQueryLoggingConfigResponse;
import software.amazon.awssdk.services.route53.model.CreateReusableDelegationSetRequest;
import software.amazon.awssdk.services.route53.model.CreateReusableDelegationSetResponse;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyInstanceRequest;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyInstanceResponse;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyRequest;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyResponse;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyVersionRequest;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyVersionResponse;
import software.amazon.awssdk.services.route53.model.CreateVpcAssociationAuthorizationRequest;
import software.amazon.awssdk.services.route53.model.CreateVpcAssociationAuthorizationResponse;
import software.amazon.awssdk.services.route53.model.DeactivateKeySigningKeyRequest;
import software.amazon.awssdk.services.route53.model.DeactivateKeySigningKeyResponse;
import software.amazon.awssdk.services.route53.model.DeleteCidrCollectionRequest;
import software.amazon.awssdk.services.route53.model.DeleteCidrCollectionResponse;
import software.amazon.awssdk.services.route53.model.DeleteHealthCheckRequest;
import software.amazon.awssdk.services.route53.model.DeleteHealthCheckResponse;
import software.amazon.awssdk.services.route53.model.DeleteHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.DeleteHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.DeleteKeySigningKeyRequest;
import software.amazon.awssdk.services.route53.model.DeleteKeySigningKeyResponse;
import software.amazon.awssdk.services.route53.model.DeleteQueryLoggingConfigRequest;
import software.amazon.awssdk.services.route53.model.DeleteQueryLoggingConfigResponse;
import software.amazon.awssdk.services.route53.model.DeleteReusableDelegationSetRequest;
import software.amazon.awssdk.services.route53.model.DeleteReusableDelegationSetResponse;
import software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyInstanceRequest;
import software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyInstanceResponse;
import software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyRequest;
import software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyResponse;
import software.amazon.awssdk.services.route53.model.DeleteVpcAssociationAuthorizationRequest;
import software.amazon.awssdk.services.route53.model.DeleteVpcAssociationAuthorizationResponse;
import software.amazon.awssdk.services.route53.model.DisableHostedZoneDnssecRequest;
import software.amazon.awssdk.services.route53.model.DisableHostedZoneDnssecResponse;
import software.amazon.awssdk.services.route53.model.DisassociateVpcFromHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.DisassociateVpcFromHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.EnableHostedZoneDnssecRequest;
import software.amazon.awssdk.services.route53.model.EnableHostedZoneDnssecResponse;
import software.amazon.awssdk.services.route53.model.GetAccountLimitRequest;
import software.amazon.awssdk.services.route53.model.GetAccountLimitResponse;
import software.amazon.awssdk.services.route53.model.GetChangeRequest;
import software.amazon.awssdk.services.route53.model.GetChangeResponse;
import software.amazon.awssdk.services.route53.model.GetCheckerIpRangesRequest;
import software.amazon.awssdk.services.route53.model.GetCheckerIpRangesResponse;
import software.amazon.awssdk.services.route53.model.GetDnssecRequest;
import software.amazon.awssdk.services.route53.model.GetDnssecResponse;
import software.amazon.awssdk.services.route53.model.GetGeoLocationRequest;
import software.amazon.awssdk.services.route53.model.GetGeoLocationResponse;
import software.amazon.awssdk.services.route53.model.GetHealthCheckCountRequest;
import software.amazon.awssdk.services.route53.model.GetHealthCheckCountResponse;
import software.amazon.awssdk.services.route53.model.GetHealthCheckLastFailureReasonRequest;
import software.amazon.awssdk.services.route53.model.GetHealthCheckLastFailureReasonResponse;
import software.amazon.awssdk.services.route53.model.GetHealthCheckRequest;
import software.amazon.awssdk.services.route53.model.GetHealthCheckResponse;
import software.amazon.awssdk.services.route53.model.GetHealthCheckStatusRequest;
import software.amazon.awssdk.services.route53.model.GetHealthCheckStatusResponse;
import software.amazon.awssdk.services.route53.model.GetHostedZoneCountRequest;
import software.amazon.awssdk.services.route53.model.GetHostedZoneCountResponse;
import software.amazon.awssdk.services.route53.model.GetHostedZoneLimitRequest;
import software.amazon.awssdk.services.route53.model.GetHostedZoneLimitResponse;
import software.amazon.awssdk.services.route53.model.GetHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.GetHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.GetQueryLoggingConfigRequest;
import software.amazon.awssdk.services.route53.model.GetQueryLoggingConfigResponse;
import software.amazon.awssdk.services.route53.model.GetReusableDelegationSetLimitRequest;
import software.amazon.awssdk.services.route53.model.GetReusableDelegationSetLimitResponse;
import software.amazon.awssdk.services.route53.model.GetReusableDelegationSetRequest;
import software.amazon.awssdk.services.route53.model.GetReusableDelegationSetResponse;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceCountRequest;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceCountResponse;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceRequest;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceResponse;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyRequest;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyResponse;
import software.amazon.awssdk.services.route53.model.ListCidrBlocksRequest;
import software.amazon.awssdk.services.route53.model.ListCidrBlocksResponse;
import software.amazon.awssdk.services.route53.model.ListCidrCollectionsRequest;
import software.amazon.awssdk.services.route53.model.ListCidrCollectionsResponse;
import software.amazon.awssdk.services.route53.model.ListCidrLocationsRequest;
import software.amazon.awssdk.services.route53.model.ListCidrLocationsResponse;
import software.amazon.awssdk.services.route53.model.ListGeoLocationsRequest;
import software.amazon.awssdk.services.route53.model.ListGeoLocationsResponse;
import software.amazon.awssdk.services.route53.model.ListHealthChecksRequest;
import software.amazon.awssdk.services.route53.model.ListHealthChecksResponse;
import software.amazon.awssdk.services.route53.model.ListHostedZonesByNameRequest;
import software.amazon.awssdk.services.route53.model.ListHostedZonesByNameResponse;
import software.amazon.awssdk.services.route53.model.ListHostedZonesByVpcRequest;
import software.amazon.awssdk.services.route53.model.ListHostedZonesByVpcResponse;
import software.amazon.awssdk.services.route53.model.ListHostedZonesRequest;
import software.amazon.awssdk.services.route53.model.ListHostedZonesResponse;
import software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsRequest;
import software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsResponse;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsResponse;
import software.amazon.awssdk.services.route53.model.ListReusableDelegationSetsRequest;
import software.amazon.awssdk.services.route53.model.ListReusableDelegationSetsResponse;
import software.amazon.awssdk.services.route53.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.route53.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.route53.model.ListTagsForResourcesRequest;
import software.amazon.awssdk.services.route53.model.ListTagsForResourcesResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPoliciesRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPoliciesResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByPolicyRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByPolicyResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyVersionsRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyVersionsResponse;
import software.amazon.awssdk.services.route53.model.ListVpcAssociationAuthorizationsRequest;
import software.amazon.awssdk.services.route53.model.ListVpcAssociationAuthorizationsResponse;
import software.amazon.awssdk.services.route53.model.TestDnsAnswerRequest;
import software.amazon.awssdk.services.route53.model.TestDnsAnswerResponse;
import software.amazon.awssdk.services.route53.model.UpdateHealthCheckRequest;
import software.amazon.awssdk.services.route53.model.UpdateHealthCheckResponse;
import software.amazon.awssdk.services.route53.model.UpdateHostedZoneCommentRequest;
import software.amazon.awssdk.services.route53.model.UpdateHostedZoneCommentResponse;
import software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyCommentRequest;
import software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyCommentResponse;
import software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyInstanceRequest;
import software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyInstanceResponse;
import software.amazon.awssdk.services.route53.paginators.ListCidrBlocksPublisher;
import software.amazon.awssdk.services.route53.paginators.ListCidrCollectionsPublisher;
import software.amazon.awssdk.services.route53.paginators.ListCidrLocationsPublisher;
import software.amazon.awssdk.services.route53.paginators.ListHealthChecksPublisher;
import software.amazon.awssdk.services.route53.paginators.ListHostedZonesPublisher;
import software.amazon.awssdk.services.route53.paginators.ListQueryLoggingConfigsPublisher;
import software.amazon.awssdk.services.route53.paginators.ListResourceRecordSetsPublisher;
import software.amazon.awssdk.services.route53.waiters.Route53AsyncWaiter;

/**
 * Service client for accessing Route 53 asynchronously. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Route 53 is a highly available and scalable Domain Name System (DNS) web service.
 * </p>
 * <p>
 * You can use Route 53 to:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Register domain names.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/welcome-domain-registration.html">How domain
 * registration works</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * Route internet traffic to the resources for your domain
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/welcome-dns-service.html">How internet traffic is
 * routed to your website or web application</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * Check the health of your resources.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/welcome-health-checks.html">How Route 53 checks the
 * health of your resources</a>.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface Route53AsyncClient extends AwsClient {
    String SERVICE_NAME = "route53";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "route53";

    /**
     * <p>
     * Activates a key-signing key (KSK) so that it can be used for signing by DNSSEC. This operation changes the KSK
     * status to <code>ACTIVE</code>.
     * </p>
     *
     * @param activateKeySigningKeyRequest
     * @return A Java Future containing the result of the ActivateKeySigningKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>NoSuchKeySigningKeyException The specified key-signing key (KSK) doesn't exist.</li>
     *         <li>InvalidKeySigningKeyStatusException The key-signing key (KSK) status isn't valid or another KSK has
     *         the status <code>INTERNAL_FAILURE</code>.</li>
     *         <li>InvalidSigningStatusException Your hosted zone status isn't valid for this operation. In the hosted
     *         zone, change the status to enable <code>DNSSEC</code> or disable <code>DNSSEC</code>.</li>
     *         <li>InvalidKmsArnException The KeyManagementServiceArn that you specified isn't valid to use with DNSSEC
     *         signing.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ActivateKeySigningKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ActivateKeySigningKey" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ActivateKeySigningKeyResponse> activateKeySigningKey(
            ActivateKeySigningKeyRequest activateKeySigningKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates a key-signing key (KSK) so that it can be used for signing by DNSSEC. This operation changes the KSK
     * status to <code>ACTIVE</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ActivateKeySigningKeyRequest.Builder} avoiding the
     * need to create one manually via {@link ActivateKeySigningKeyRequest#builder()}
     * </p>
     *
     * @param activateKeySigningKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.ActivateKeySigningKeyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ActivateKeySigningKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>NoSuchKeySigningKeyException The specified key-signing key (KSK) doesn't exist.</li>
     *         <li>InvalidKeySigningKeyStatusException The key-signing key (KSK) status isn't valid or another KSK has
     *         the status <code>INTERNAL_FAILURE</code>.</li>
     *         <li>InvalidSigningStatusException Your hosted zone status isn't valid for this operation. In the hosted
     *         zone, change the status to enable <code>DNSSEC</code> or disable <code>DNSSEC</code>.</li>
     *         <li>InvalidKmsArnException The KeyManagementServiceArn that you specified isn't valid to use with DNSSEC
     *         signing.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ActivateKeySigningKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ActivateKeySigningKey" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ActivateKeySigningKeyResponse> activateKeySigningKey(
            Consumer<ActivateKeySigningKeyRequest.Builder> activateKeySigningKeyRequest) {
        return activateKeySigningKey(ActivateKeySigningKeyRequest.builder().applyMutation(activateKeySigningKeyRequest).build());
    }

    /**
     * <p>
     * Associates an Amazon VPC with a private hosted zone.
     * </p>
     * <important>
     * <p>
     * To perform the association, the VPC and the private hosted zone must already exist. You can't convert a public
     * hosted zone into a private hosted zone.
     * </p>
     * </important> <note>
     * <p>
     * If you want to associate a VPC that was created by using one Amazon Web Services account with a private hosted
     * zone that was created by using a different account, the Amazon Web Services account that created the private
     * hosted zone must first submit a <code>CreateVPCAssociationAuthorization</code> request. Then the account that
     * created the VPC must submit an <code>AssociateVPCWithHostedZone</code> request.
     * </p>
     * </note> <note>
     * <p>
     * When granting access, the hosted zone and the Amazon VPC must belong to the same partition. A partition is a
     * group of Amazon Web Services Regions. Each Amazon Web Services account is scoped to one partition.
     * </p>
     * <p>
     * The following are the supported partitions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>aws</code> - Amazon Web Services Regions
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aws-cn</code> - China Regions
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aws-us-gov</code> - Amazon Web Services GovCloud (US) Region
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Access Management</a> in the
     * <i>Amazon Web Services General Reference</i>.
     * </p>
     * </note>
     *
     * @param associateVpcWithHostedZoneRequest
     *        A complex type that contains information about the request to associate a VPC with a private hosted zone.
     * @return A Java Future containing the result of the AssociateVPCWithHostedZone operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>NotAuthorizedException Associating the specified VPC with the specified hosted zone has not been
     *         authorized.</li>
     *         <li>InvalidVpcIdException The VPC ID that you specified either isn't a valid ID or the current account is
     *         not authorized to access this VPC.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>PublicZoneVpcAssociationException You're trying to associate a VPC with a public hosted zone. Amazon
     *         Route 53 doesn't support associating a VPC with a public hosted zone.</li>
     *         <li>ConflictingDomainExistsException The cause of this error depends on the operation that you're
     *         performing:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Create a public hosted zone:</b> Two hosted zones that have the same name or that have a parent/child
     *         relationship (example.com and test.example.com) can't have any common name servers. You tried to create a
     *         hosted zone that has the same name as an existing hosted zone or that's the parent or child of an
     *         existing hosted zone, and you specified a delegation set that shares one or more name servers with the
     *         existing hosted zone. For more information, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateReusableDelegationSet.html"
     *         >CreateReusableDelegationSet</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Create a private hosted zone:</b> A hosted zone with the specified name already exists and is already
     *         associated with the Amazon VPC that you specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Associate VPCs with a private hosted zone:</b> The VPC that you specified is already associated with
     *         another hosted zone that has the same name.
     *         </p>
     *         </li></li>
     *         <li>LimitsExceededException This operation can't be completed because the current account has reached the
     *         limit on the resource you are trying to create. To request a higher limit, <a
     *         href="http://aws.amazon.com/route53-request">create a case</a> with the Amazon Web Services Support
     *         Center.</li>
     *         <li>PriorRequestNotCompleteException If Amazon Route 53 can't process a request before the next request
     *         arrives, it will reject subsequent requests for the same hosted zone and return an
     *         <code>HTTP 400 error</code> (<code>Bad request</code>). If Route 53 returns this error repeatedly for the
     *         same request, we recommend that you wait, in intervals of increasing duration, before you try the request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.AssociateVPCWithHostedZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/AssociateVPCWithHostedZone"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateVpcWithHostedZoneResponse> associateVPCWithHostedZone(
            AssociateVpcWithHostedZoneRequest associateVpcWithHostedZoneRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an Amazon VPC with a private hosted zone.
     * </p>
     * <important>
     * <p>
     * To perform the association, the VPC and the private hosted zone must already exist. You can't convert a public
     * hosted zone into a private hosted zone.
     * </p>
     * </important> <note>
     * <p>
     * If you want to associate a VPC that was created by using one Amazon Web Services account with a private hosted
     * zone that was created by using a different account, the Amazon Web Services account that created the private
     * hosted zone must first submit a <code>CreateVPCAssociationAuthorization</code> request. Then the account that
     * created the VPC must submit an <code>AssociateVPCWithHostedZone</code> request.
     * </p>
     * </note> <note>
     * <p>
     * When granting access, the hosted zone and the Amazon VPC must belong to the same partition. A partition is a
     * group of Amazon Web Services Regions. Each Amazon Web Services account is scoped to one partition.
     * </p>
     * <p>
     * The following are the supported partitions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>aws</code> - Amazon Web Services Regions
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aws-cn</code> - China Regions
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aws-us-gov</code> - Amazon Web Services GovCloud (US) Region
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Access Management</a> in the
     * <i>Amazon Web Services General Reference</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateVpcWithHostedZoneRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateVpcWithHostedZoneRequest#builder()}
     * </p>
     *
     * @param associateVpcWithHostedZoneRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.AssociateVpcWithHostedZoneRequest.Builder} to create
     *        a request. A complex type that contains information about the request to associate a VPC with a private
     *        hosted zone.
     * @return A Java Future containing the result of the AssociateVPCWithHostedZone operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>NotAuthorizedException Associating the specified VPC with the specified hosted zone has not been
     *         authorized.</li>
     *         <li>InvalidVpcIdException The VPC ID that you specified either isn't a valid ID or the current account is
     *         not authorized to access this VPC.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>PublicZoneVpcAssociationException You're trying to associate a VPC with a public hosted zone. Amazon
     *         Route 53 doesn't support associating a VPC with a public hosted zone.</li>
     *         <li>ConflictingDomainExistsException The cause of this error depends on the operation that you're
     *         performing:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Create a public hosted zone:</b> Two hosted zones that have the same name or that have a parent/child
     *         relationship (example.com and test.example.com) can't have any common name servers. You tried to create a
     *         hosted zone that has the same name as an existing hosted zone or that's the parent or child of an
     *         existing hosted zone, and you specified a delegation set that shares one or more name servers with the
     *         existing hosted zone. For more information, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateReusableDelegationSet.html"
     *         >CreateReusableDelegationSet</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Create a private hosted zone:</b> A hosted zone with the specified name already exists and is already
     *         associated with the Amazon VPC that you specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Associate VPCs with a private hosted zone:</b> The VPC that you specified is already associated with
     *         another hosted zone that has the same name.
     *         </p>
     *         </li></li>
     *         <li>LimitsExceededException This operation can't be completed because the current account has reached the
     *         limit on the resource you are trying to create. To request a higher limit, <a
     *         href="http://aws.amazon.com/route53-request">create a case</a> with the Amazon Web Services Support
     *         Center.</li>
     *         <li>PriorRequestNotCompleteException If Amazon Route 53 can't process a request before the next request
     *         arrives, it will reject subsequent requests for the same hosted zone and return an
     *         <code>HTTP 400 error</code> (<code>Bad request</code>). If Route 53 returns this error repeatedly for the
     *         same request, we recommend that you wait, in intervals of increasing duration, before you try the request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.AssociateVPCWithHostedZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/AssociateVPCWithHostedZone"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateVpcWithHostedZoneResponse> associateVPCWithHostedZone(
            Consumer<AssociateVpcWithHostedZoneRequest.Builder> associateVpcWithHostedZoneRequest) {
        return associateVPCWithHostedZone(AssociateVpcWithHostedZoneRequest.builder()
                .applyMutation(associateVpcWithHostedZoneRequest).build());
    }

    /**
     * <p>
     * Creates, changes, or deletes CIDR blocks within a collection. Contains authoritative IP information mapping
     * blocks to one or multiple locations.
     * </p>
     * <p>
     * A change request can update multiple locations in a collection at a time, which is helpful if you want to move
     * one or more CIDR blocks from one location to another in one transaction, without downtime.
     * </p>
     * <p>
     * <b>Limits</b>
     * </p>
     * <p>
     * The max number of CIDR blocks included in the request is 1000. As a result, big updates require multiple API
     * calls.
     * </p>
     * <p>
     * <b> PUT and DELETE_IF_EXISTS</b>
     * </p>
     * <p>
     * Use <code>ChangeCidrCollection</code> to perform the following actions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PUT</code>: Create a CIDR block within the specified collection.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code> DELETE_IF_EXISTS</code>: Delete an existing CIDR block from the collection.
     * </p>
     * </li>
     * </ul>
     *
     * @param changeCidrCollectionRequest
     * @return A Java Future containing the result of the ChangeCidrCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchCidrCollectionException The CIDR collection you specified, doesn't exist.</li>
     *         <li>CidrCollectionVersionMismatchException The CIDR collection version you provided, doesn't match the
     *         one in the <code>ListCidrCollections</code> operation.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>CidrBlockInUseException This CIDR block is already in use.</li>
     *         <li>LimitsExceededException This operation can't be completed because the current account has reached the
     *         limit on the resource you are trying to create. To request a higher limit, <a
     *         href="http://aws.amazon.com/route53-request">create a case</a> with the Amazon Web Services Support
     *         Center.</li>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ChangeCidrCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ChangeCidrCollection" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ChangeCidrCollectionResponse> changeCidrCollection(
            ChangeCidrCollectionRequest changeCidrCollectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates, changes, or deletes CIDR blocks within a collection. Contains authoritative IP information mapping
     * blocks to one or multiple locations.
     * </p>
     * <p>
     * A change request can update multiple locations in a collection at a time, which is helpful if you want to move
     * one or more CIDR blocks from one location to another in one transaction, without downtime.
     * </p>
     * <p>
     * <b>Limits</b>
     * </p>
     * <p>
     * The max number of CIDR blocks included in the request is 1000. As a result, big updates require multiple API
     * calls.
     * </p>
     * <p>
     * <b> PUT and DELETE_IF_EXISTS</b>
     * </p>
     * <p>
     * Use <code>ChangeCidrCollection</code> to perform the following actions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PUT</code>: Create a CIDR block within the specified collection.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code> DELETE_IF_EXISTS</code>: Delete an existing CIDR block from the collection.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ChangeCidrCollectionRequest.Builder} avoiding the
     * need to create one manually via {@link ChangeCidrCollectionRequest#builder()}
     * </p>
     *
     * @param changeCidrCollectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.ChangeCidrCollectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ChangeCidrCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchCidrCollectionException The CIDR collection you specified, doesn't exist.</li>
     *         <li>CidrCollectionVersionMismatchException The CIDR collection version you provided, doesn't match the
     *         one in the <code>ListCidrCollections</code> operation.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>CidrBlockInUseException This CIDR block is already in use.</li>
     *         <li>LimitsExceededException This operation can't be completed because the current account has reached the
     *         limit on the resource you are trying to create. To request a higher limit, <a
     *         href="http://aws.amazon.com/route53-request">create a case</a> with the Amazon Web Services Support
     *         Center.</li>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ChangeCidrCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ChangeCidrCollection" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ChangeCidrCollectionResponse> changeCidrCollection(
            Consumer<ChangeCidrCollectionRequest.Builder> changeCidrCollectionRequest) {
        return changeCidrCollection(ChangeCidrCollectionRequest.builder().applyMutation(changeCidrCollectionRequest).build());
    }

    /**
     * <p>
     * Creates, changes, or deletes a resource record set, which contains authoritative DNS information for a specified
     * domain name or subdomain name. For example, you can use <code>ChangeResourceRecordSets</code> to create a
     * resource record set that routes traffic for test.example.com to a web server that has an IP address of
     * 192.0.2.44.
     * </p>
     * <p>
     * <b>Deleting Resource Record Sets</b>
     * </p>
     * <p>
     * To delete a resource record set, you must specify all the same values that you specified when you created it.
     * </p>
     * <p>
     * <b>Change Batches and Transactional Changes</b>
     * </p>
     * <p>
     * The request body must include a document with a <code>ChangeResourceRecordSetsRequest</code> element. The request
     * body contains a list of change items, known as a change batch. Change batches are considered transactional
     * changes. Route 53 validates the changes in the request and then either makes all or none of the changes in the
     * change batch request. This ensures that DNS routing isn't adversely affected by partial changes to the resource
     * record sets in a hosted zone.
     * </p>
     * <p>
     * For example, suppose a change batch request contains two changes: it deletes the <code>CNAME</code> resource
     * record set for www.example.com and creates an alias resource record set for www.example.com. If validation for
     * both records succeeds, Route 53 deletes the first resource record set and creates the second resource record set
     * in a single operation. If validation for either the <code>DELETE</code> or the <code>CREATE</code> action fails,
     * then the request is canceled, and the original <code>CNAME</code> record continues to exist.
     * </p>
     * <note>
     * <p>
     * If you try to delete the same resource record set more than once in a single change batch, Route 53 returns an
     * <code>InvalidChangeBatch</code> error.
     * </p>
     * </note>
     * <p>
     * <b>Traffic Flow</b>
     * </p>
     * <p>
     * To create resource record sets for complex routing configurations, use either the traffic flow visual editor in
     * the Route 53 console or the API actions for traffic policies and traffic policy instances. Save the configuration
     * as a traffic policy, then associate the traffic policy with one or more domain names (such as example.com) or
     * subdomain names (such as www.example.com), in the same hosted zone or in multiple hosted zones. You can roll back
     * the updates if the new configuration isn't performing as expected. For more information, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/traffic-flow.html">Using Traffic Flow to Route
     * DNS Traffic</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * <b>Create, Delete, and Upsert</b>
     * </p>
     * <p>
     * Use <code>ChangeResourceRecordsSetsRequest</code> to perform the following actions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE</code>: Creates a resource record set that has the specified values.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE</code>: Deletes an existing resource record set that has the specified values.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPSERT</code>: If a resource set doesn't exist, Route 53 creates it. If a resource set exists Route 53
     * updates it with the values in the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Syntaxes for Creating, Updating, and Deleting Resource Record Sets</b>
     * </p>
     * <p>
     * The syntax for a request depends on the type of resource record set that you want to create, delete, or update,
     * such as weighted, alias, or failover. The XML elements in your request must appear in the order listed in the
     * syntax.
     * </p>
     * <p>
     * For an example for each type of resource record set, see "Examples."
     * </p>
     * <p>
     * Don't refer to the syntax in the "Parameter Syntax" section, which includes all of the elements for every kind of
     * resource record set that you can create, delete, or update by using <code>ChangeResourceRecordSets</code>.
     * </p>
     * <p>
     * <b>Change Propagation to Route 53 DNS Servers</b>
     * </p>
     * <p>
     * When you submit a <code>ChangeResourceRecordSets</code> request, Route 53 propagates your changes to all of the
     * Route 53 authoritative DNS servers managing the hosted zone. While your changes are propagating,
     * <code>GetChange</code> returns a status of <code>PENDING</code>. When propagation is complete,
     * <code>GetChange</code> returns a status of <code>INSYNC</code>. Changes generally propagate to all Route 53 name
     * servers managing the hosted zone within 60 seconds. For more information, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetChange.html">GetChange</a>.
     * </p>
     * <p>
     * <b>Limits on ChangeResourceRecordSets Requests</b>
     * </p>
     * <p>
     * For information about the limits on a <code>ChangeResourceRecordSets</code> request, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the <i>Amazon
     * Route 53 Developer Guide</i>.
     * </p>
     *
     * @param changeResourceRecordSetsRequest
     *        A complex type that contains change information for the resource record set.
     * @return A Java Future containing the result of the ChangeResourceRecordSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>NoSuchHealthCheckException No health check exists with the specified ID.</li>
     *         <li>InvalidChangeBatchException This exception contains a list of messages that might contain one or more
     *         error messages. Each error message indicates one error in the change batch.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>PriorRequestNotCompleteException If Amazon Route 53 can't process a request before the next request
     *         arrives, it will reject subsequent requests for the same hosted zone and return an
     *         <code>HTTP 400 error</code> (<code>Bad request</code>). If Route 53 returns this error repeatedly for the
     *         same request, we recommend that you wait, in intervals of increasing duration, before you try the request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ChangeResourceRecordSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ChangeResourceRecordSets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ChangeResourceRecordSetsResponse> changeResourceRecordSets(
            ChangeResourceRecordSetsRequest changeResourceRecordSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates, changes, or deletes a resource record set, which contains authoritative DNS information for a specified
     * domain name or subdomain name. For example, you can use <code>ChangeResourceRecordSets</code> to create a
     * resource record set that routes traffic for test.example.com to a web server that has an IP address of
     * 192.0.2.44.
     * </p>
     * <p>
     * <b>Deleting Resource Record Sets</b>
     * </p>
     * <p>
     * To delete a resource record set, you must specify all the same values that you specified when you created it.
     * </p>
     * <p>
     * <b>Change Batches and Transactional Changes</b>
     * </p>
     * <p>
     * The request body must include a document with a <code>ChangeResourceRecordSetsRequest</code> element. The request
     * body contains a list of change items, known as a change batch. Change batches are considered transactional
     * changes. Route 53 validates the changes in the request and then either makes all or none of the changes in the
     * change batch request. This ensures that DNS routing isn't adversely affected by partial changes to the resource
     * record sets in a hosted zone.
     * </p>
     * <p>
     * For example, suppose a change batch request contains two changes: it deletes the <code>CNAME</code> resource
     * record set for www.example.com and creates an alias resource record set for www.example.com. If validation for
     * both records succeeds, Route 53 deletes the first resource record set and creates the second resource record set
     * in a single operation. If validation for either the <code>DELETE</code> or the <code>CREATE</code> action fails,
     * then the request is canceled, and the original <code>CNAME</code> record continues to exist.
     * </p>
     * <note>
     * <p>
     * If you try to delete the same resource record set more than once in a single change batch, Route 53 returns an
     * <code>InvalidChangeBatch</code> error.
     * </p>
     * </note>
     * <p>
     * <b>Traffic Flow</b>
     * </p>
     * <p>
     * To create resource record sets for complex routing configurations, use either the traffic flow visual editor in
     * the Route 53 console or the API actions for traffic policies and traffic policy instances. Save the configuration
     * as a traffic policy, then associate the traffic policy with one or more domain names (such as example.com) or
     * subdomain names (such as www.example.com), in the same hosted zone or in multiple hosted zones. You can roll back
     * the updates if the new configuration isn't performing as expected. For more information, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/traffic-flow.html">Using Traffic Flow to Route
     * DNS Traffic</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * <b>Create, Delete, and Upsert</b>
     * </p>
     * <p>
     * Use <code>ChangeResourceRecordsSetsRequest</code> to perform the following actions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE</code>: Creates a resource record set that has the specified values.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE</code>: Deletes an existing resource record set that has the specified values.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPSERT</code>: If a resource set doesn't exist, Route 53 creates it. If a resource set exists Route 53
     * updates it with the values in the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Syntaxes for Creating, Updating, and Deleting Resource Record Sets</b>
     * </p>
     * <p>
     * The syntax for a request depends on the type of resource record set that you want to create, delete, or update,
     * such as weighted, alias, or failover. The XML elements in your request must appear in the order listed in the
     * syntax.
     * </p>
     * <p>
     * For an example for each type of resource record set, see "Examples."
     * </p>
     * <p>
     * Don't refer to the syntax in the "Parameter Syntax" section, which includes all of the elements for every kind of
     * resource record set that you can create, delete, or update by using <code>ChangeResourceRecordSets</code>.
     * </p>
     * <p>
     * <b>Change Propagation to Route 53 DNS Servers</b>
     * </p>
     * <p>
     * When you submit a <code>ChangeResourceRecordSets</code> request, Route 53 propagates your changes to all of the
     * Route 53 authoritative DNS servers managing the hosted zone. While your changes are propagating,
     * <code>GetChange</code> returns a status of <code>PENDING</code>. When propagation is complete,
     * <code>GetChange</code> returns a status of <code>INSYNC</code>. Changes generally propagate to all Route 53 name
     * servers managing the hosted zone within 60 seconds. For more information, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetChange.html">GetChange</a>.
     * </p>
     * <p>
     * <b>Limits on ChangeResourceRecordSets Requests</b>
     * </p>
     * <p>
     * For information about the limits on a <code>ChangeResourceRecordSets</code> request, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the <i>Amazon
     * Route 53 Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ChangeResourceRecordSetsRequest.Builder} avoiding
     * the need to create one manually via {@link ChangeResourceRecordSetsRequest#builder()}
     * </p>
     *
     * @param changeResourceRecordSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.ChangeResourceRecordSetsRequest.Builder} to create a
     *        request. A complex type that contains change information for the resource record set.
     * @return A Java Future containing the result of the ChangeResourceRecordSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>NoSuchHealthCheckException No health check exists with the specified ID.</li>
     *         <li>InvalidChangeBatchException This exception contains a list of messages that might contain one or more
     *         error messages. Each error message indicates one error in the change batch.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>PriorRequestNotCompleteException If Amazon Route 53 can't process a request before the next request
     *         arrives, it will reject subsequent requests for the same hosted zone and return an
     *         <code>HTTP 400 error</code> (<code>Bad request</code>). If Route 53 returns this error repeatedly for the
     *         same request, we recommend that you wait, in intervals of increasing duration, before you try the request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ChangeResourceRecordSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ChangeResourceRecordSets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ChangeResourceRecordSetsResponse> changeResourceRecordSets(
            Consumer<ChangeResourceRecordSetsRequest.Builder> changeResourceRecordSetsRequest) {
        return changeResourceRecordSets(ChangeResourceRecordSetsRequest.builder().applyMutation(changeResourceRecordSetsRequest)
                .build());
    }

    /**
     * <p>
     * Adds, edits, or deletes tags for a health check or a hosted zone.
     * </p>
     * <p>
     * For information about using tags for cost allocation, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation
     * Tags</a> in the <i>Billing and Cost Management User Guide</i>.
     * </p>
     *
     * @param changeTagsForResourceRequest
     *        A complex type that contains information about the tags that you want to add, edit, or delete.
     * @return A Java Future containing the result of the ChangeTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchHealthCheckException No health check exists with the specified ID.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>PriorRequestNotCompleteException If Amazon Route 53 can't process a request before the next request
     *         arrives, it will reject subsequent requests for the same hosted zone and return an
     *         <code>HTTP 400 error</code> (<code>Bad request</code>). If Route 53 returns this error repeatedly for the
     *         same request, we recommend that you wait, in intervals of increasing duration, before you try the request
     *         again.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ChangeTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ChangeTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ChangeTagsForResourceResponse> changeTagsForResource(
            ChangeTagsForResourceRequest changeTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds, edits, or deletes tags for a health check or a hosted zone.
     * </p>
     * <p>
     * For information about using tags for cost allocation, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation
     * Tags</a> in the <i>Billing and Cost Management User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ChangeTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ChangeTagsForResourceRequest#builder()}
     * </p>
     *
     * @param changeTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.ChangeTagsForResourceRequest.Builder} to create a
     *        request. A complex type that contains information about the tags that you want to add, edit, or delete.
     * @return A Java Future containing the result of the ChangeTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchHealthCheckException No health check exists with the specified ID.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>PriorRequestNotCompleteException If Amazon Route 53 can't process a request before the next request
     *         arrives, it will reject subsequent requests for the same hosted zone and return an
     *         <code>HTTP 400 error</code> (<code>Bad request</code>). If Route 53 returns this error repeatedly for the
     *         same request, we recommend that you wait, in intervals of increasing duration, before you try the request
     *         again.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ChangeTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ChangeTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ChangeTagsForResourceResponse> changeTagsForResource(
            Consumer<ChangeTagsForResourceRequest.Builder> changeTagsForResourceRequest) {
        return changeTagsForResource(ChangeTagsForResourceRequest.builder().applyMutation(changeTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Creates a CIDR collection in the current Amazon Web Services account.
     * </p>
     *
     * @param createCidrCollectionRequest
     * @return A Java Future containing the result of the CreateCidrCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitsExceededException This operation can't be completed because the current account has reached the
     *         limit on the resource you are trying to create. To request a higher limit, <a
     *         href="http://aws.amazon.com/route53-request">create a case</a> with the Amazon Web Services Support
     *         Center.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>CidrCollectionAlreadyExistsException A CIDR collection with this name and a different caller
     *         reference already exists in this account.</li>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.CreateCidrCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateCidrCollection" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateCidrCollectionResponse> createCidrCollection(
            CreateCidrCollectionRequest createCidrCollectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a CIDR collection in the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCidrCollectionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCidrCollectionRequest#builder()}
     * </p>
     *
     * @param createCidrCollectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.CreateCidrCollectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateCidrCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitsExceededException This operation can't be completed because the current account has reached the
     *         limit on the resource you are trying to create. To request a higher limit, <a
     *         href="http://aws.amazon.com/route53-request">create a case</a> with the Amazon Web Services Support
     *         Center.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>CidrCollectionAlreadyExistsException A CIDR collection with this name and a different caller
     *         reference already exists in this account.</li>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.CreateCidrCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateCidrCollection" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateCidrCollectionResponse> createCidrCollection(
            Consumer<CreateCidrCollectionRequest.Builder> createCidrCollectionRequest) {
        return createCidrCollection(CreateCidrCollectionRequest.builder().applyMutation(createCidrCollectionRequest).build());
    }

    /**
     * <p>
     * Creates a new health check.
     * </p>
     * <p>
     * For information about adding health checks to resource record sets, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_ResourceRecordSet.html#Route53-Type-ResourceRecordSet-HealthCheckId"
     * >HealthCheckId</a> in <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ChangeResourceRecordSets.html"
     * >ChangeResourceRecordSets</a>.
     * </p>
     * <p>
     * <b>ELB Load Balancers</b>
     * </p>
     * <p>
     * If you're registering EC2 instances with an Elastic Load Balancing (ELB) load balancer, do not create Amazon
     * Route 53 health checks for the EC2 instances. When you register an EC2 instance with a load balancer, you
     * configure settings for an ELB health check, which performs a similar function to a Route 53 health check.
     * </p>
     * <p>
     * <b>Private Hosted Zones</b>
     * </p>
     * <p>
     * You can associate health checks with failover resource record sets in a private hosted zone. Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Route 53 health checkers are outside the VPC. To check the health of an endpoint within a VPC by IP address, you
     * must assign a public IP address to the instance in the VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can configure a health checker to check the health of an external resource that the instance relies on, such
     * as a database server.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can create a CloudWatch metric, associate an alarm with the metric, and then create a health check that is
     * based on the state of the alarm. For example, you might create a CloudWatch metric that checks the status of the
     * Amazon EC2 <code>StatusCheckFailed</code> metric, add an alarm to the metric, and then create a health check that
     * is based on the state of the alarm. For information about creating CloudWatch metrics and alarms by using the
     * CloudWatch console, see the <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/WhatIsCloudWatch.html">Amazon CloudWatch
     * User Guide</a>.
     * </p>
     * </li>
     * </ul>
     *
     * @param createHealthCheckRequest
     *        A complex type that contains the health check request information.
     * @return A Java Future containing the result of the CreateHealthCheck operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyHealthChecksException This health check can't be created because the current account has
     *         reached the limit on the number of active health checks.</p>
     *         <p>
     *         For information about default limits, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the
     *         <i>Amazon Route 53 Developer Guide</i>.
     *         </p>
     *         <p>
     *         For information about how to get the current limit for an account, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html"
     *         >GetAccountLimit</a>. To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a
     *         case</a> with the Amazon Web Services Support Center.
     *         </p>
     *         <p>
     *         You have reached the maximum number of active health checks for an Amazon Web Services account. To
     *         request a higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the Amazon
     *         Web Services Support Center.</li>
     *         <li>HealthCheckAlreadyExistsException The health check you're attempting to create already exists. Amazon
     *         Route 53 returns this error when you submit a request that has the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The same value for <code>CallerReference</code> as an existing health check, and one or more values that
     *         differ from the existing health check that has the same caller reference.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The same value for <code>CallerReference</code> as a health check that you created and later deleted,
     *         regardless of the other settings in the request.
     *         </p>
     *         </li></li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.CreateHealthCheck
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateHealthCheck" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateHealthCheckResponse> createHealthCheck(CreateHealthCheckRequest createHealthCheckRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new health check.
     * </p>
     * <p>
     * For information about adding health checks to resource record sets, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_ResourceRecordSet.html#Route53-Type-ResourceRecordSet-HealthCheckId"
     * >HealthCheckId</a> in <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ChangeResourceRecordSets.html"
     * >ChangeResourceRecordSets</a>.
     * </p>
     * <p>
     * <b>ELB Load Balancers</b>
     * </p>
     * <p>
     * If you're registering EC2 instances with an Elastic Load Balancing (ELB) load balancer, do not create Amazon
     * Route 53 health checks for the EC2 instances. When you register an EC2 instance with a load balancer, you
     * configure settings for an ELB health check, which performs a similar function to a Route 53 health check.
     * </p>
     * <p>
     * <b>Private Hosted Zones</b>
     * </p>
     * <p>
     * You can associate health checks with failover resource record sets in a private hosted zone. Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Route 53 health checkers are outside the VPC. To check the health of an endpoint within a VPC by IP address, you
     * must assign a public IP address to the instance in the VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can configure a health checker to check the health of an external resource that the instance relies on, such
     * as a database server.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can create a CloudWatch metric, associate an alarm with the metric, and then create a health check that is
     * based on the state of the alarm. For example, you might create a CloudWatch metric that checks the status of the
     * Amazon EC2 <code>StatusCheckFailed</code> metric, add an alarm to the metric, and then create a health check that
     * is based on the state of the alarm. For information about creating CloudWatch metrics and alarms by using the
     * CloudWatch console, see the <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/WhatIsCloudWatch.html">Amazon CloudWatch
     * User Guide</a>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateHealthCheckRequest.Builder} avoiding the need
     * to create one manually via {@link CreateHealthCheckRequest#builder()}
     * </p>
     *
     * @param createHealthCheckRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.CreateHealthCheckRequest.Builder} to create a
     *        request. A complex type that contains the health check request information.
     * @return A Java Future containing the result of the CreateHealthCheck operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyHealthChecksException This health check can't be created because the current account has
     *         reached the limit on the number of active health checks.</p>
     *         <p>
     *         For information about default limits, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the
     *         <i>Amazon Route 53 Developer Guide</i>.
     *         </p>
     *         <p>
     *         For information about how to get the current limit for an account, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html"
     *         >GetAccountLimit</a>. To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a
     *         case</a> with the Amazon Web Services Support Center.
     *         </p>
     *         <p>
     *         You have reached the maximum number of active health checks for an Amazon Web Services account. To
     *         request a higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the Amazon
     *         Web Services Support Center.</li>
     *         <li>HealthCheckAlreadyExistsException The health check you're attempting to create already exists. Amazon
     *         Route 53 returns this error when you submit a request that has the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The same value for <code>CallerReference</code> as an existing health check, and one or more values that
     *         differ from the existing health check that has the same caller reference.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The same value for <code>CallerReference</code> as a health check that you created and later deleted,
     *         regardless of the other settings in the request.
     *         </p>
     *         </li></li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.CreateHealthCheck
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateHealthCheck" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateHealthCheckResponse> createHealthCheck(
            Consumer<CreateHealthCheckRequest.Builder> createHealthCheckRequest) {
        return createHealthCheck(CreateHealthCheckRequest.builder().applyMutation(createHealthCheckRequest).build());
    }

    /**
     * <p>
     * Creates a new public or private hosted zone. You create records in a public hosted zone to define how you want to
     * route traffic on the internet for a domain, such as example.com, and its subdomains (apex.example.com,
     * acme.example.com). You create records in a private hosted zone to define how you want to route traffic for a
     * domain and its subdomains within one or more Amazon Virtual Private Clouds (Amazon VPCs).
     * </p>
     * <important>
     * <p>
     * You can't convert a public hosted zone to a private hosted zone or vice versa. Instead, you must create a new
     * hosted zone with the same name and create new resource record sets.
     * </p>
     * </important>
     * <p>
     * For more information about charges for hosted zones, see <a href="http://aws.amazon.com/route53/pricing/">Amazon
     * Route 53 Pricing</a>.
     * </p>
     * <p>
     * Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can't create a hosted zone for a top-level domain (TLD) such as .com.
     * </p>
     * </li>
     * <li>
     * <p>
     * For public hosted zones, Route 53 automatically creates a default SOA record and four NS records for the zone.
     * For more information about SOA and NS records, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/SOA-NSrecords.html">NS and SOA Records that
     * Route 53 Creates for a Hosted Zone</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * If you want to use the same name servers for multiple public hosted zones, you can optionally associate a
     * reusable delegation set with the hosted zone. See the <code>DelegationSetId</code> element.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your domain is registered with a registrar other than Route 53, you must update the name servers with your
     * registrar to make Route 53 the DNS service for the domain. For more information, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/MigratingDNS.html">Migrating DNS Service for an
     * Existing Domain to Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When you submit a <code>CreateHostedZone</code> request, the initial status of the hosted zone is
     * <code>PENDING</code>. For public hosted zones, this means that the NS and SOA records are not yet available on
     * all Route 53 DNS servers. When the NS and SOA records are available, the status of the zone changes to
     * <code>INSYNC</code>.
     * </p>
     * <p>
     * The <code>CreateHostedZone</code> request requires the caller to have an <code>ec2:DescribeVpcs</code>
     * permission.
     * </p>
     * <note>
     * <p>
     * When creating private hosted zones, the Amazon VPC must belong to the same partition where the hosted zone is
     * created. A partition is a group of Amazon Web Services Regions. Each Amazon Web Services account is scoped to one
     * partition.
     * </p>
     * <p>
     * The following are the supported partitions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>aws</code> - Amazon Web Services Regions
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aws-cn</code> - China Regions
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aws-us-gov</code> - Amazon Web Services GovCloud (US) Region
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Access Management</a> in the
     * <i>Amazon Web Services General Reference</i>.
     * </p>
     * </note>
     *
     * @param createHostedZoneRequest
     *        A complex type that contains information about the request to create a public or private hosted zone.
     * @return A Java Future containing the result of the CreateHostedZone operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDomainNameException The specified domain name is not valid.</li>
     *         <li>HostedZoneAlreadyExistsException The hosted zone you're trying to create already exists. Amazon Route
     *         53 returns this error when a hosted zone has already been created with the specified
     *         <code>CallerReference</code>.</li>
     *         <li>TooManyHostedZonesException This operation can't be completed either because the current account has
     *         reached the limit on the number of hosted zones or because you've reached the limit on the number of
     *         hosted zones that can be associated with a reusable delegation set.</p>
     *         <p>
     *         For information about default limits, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the
     *         <i>Amazon Route 53 Developer Guide</i>.
     *         </p>
     *         <p>
     *         To get the current limit on hosted zones that can be created by an account, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html"
     *         >GetAccountLimit</a>.
     *         </p>
     *         <p>
     *         To get the current limit on hosted zones that can be associated with a reusable delegation set, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetReusableDelegationSetLimit.html">
     *         GetReusableDelegationSetLimit</a>.
     *         </p>
     *         <p>
     *         To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the
     *         Amazon Web Services Support Center.</li>
     *         <li>InvalidVpcIdException The VPC ID that you specified either isn't a valid ID or the current account is
     *         not authorized to access this VPC.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>DelegationSetNotAvailableException You can create a hosted zone that has the same name as an existing
     *         hosted zone (example.com is common), but there is a limit to the number of hosted zones that have the
     *         same name. If you get this error, Amazon Route 53 has reached that limit. If you own the domain name and
     *         Route 53 generates this error, contact Customer Support.</li>
     *         <li>ConflictingDomainExistsException The cause of this error depends on the operation that you're
     *         performing:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Create a public hosted zone:</b> Two hosted zones that have the same name or that have a parent/child
     *         relationship (example.com and test.example.com) can't have any common name servers. You tried to create a
     *         hosted zone that has the same name as an existing hosted zone or that's the parent or child of an
     *         existing hosted zone, and you specified a delegation set that shares one or more name servers with the
     *         existing hosted zone. For more information, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateReusableDelegationSet.html"
     *         >CreateReusableDelegationSet</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Create a private hosted zone:</b> A hosted zone with the specified name already exists and is already
     *         associated with the Amazon VPC that you specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Associate VPCs with a private hosted zone:</b> The VPC that you specified is already associated with
     *         another hosted zone that has the same name.
     *         </p>
     *         </li></li>
     *         <li>NoSuchDelegationSetException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>DelegationSetNotReusableException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.CreateHostedZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateHostedZone" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateHostedZoneResponse> createHostedZone(CreateHostedZoneRequest createHostedZoneRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new public or private hosted zone. You create records in a public hosted zone to define how you want to
     * route traffic on the internet for a domain, such as example.com, and its subdomains (apex.example.com,
     * acme.example.com). You create records in a private hosted zone to define how you want to route traffic for a
     * domain and its subdomains within one or more Amazon Virtual Private Clouds (Amazon VPCs).
     * </p>
     * <important>
     * <p>
     * You can't convert a public hosted zone to a private hosted zone or vice versa. Instead, you must create a new
     * hosted zone with the same name and create new resource record sets.
     * </p>
     * </important>
     * <p>
     * For more information about charges for hosted zones, see <a href="http://aws.amazon.com/route53/pricing/">Amazon
     * Route 53 Pricing</a>.
     * </p>
     * <p>
     * Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can't create a hosted zone for a top-level domain (TLD) such as .com.
     * </p>
     * </li>
     * <li>
     * <p>
     * For public hosted zones, Route 53 automatically creates a default SOA record and four NS records for the zone.
     * For more information about SOA and NS records, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/SOA-NSrecords.html">NS and SOA Records that
     * Route 53 Creates for a Hosted Zone</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * If you want to use the same name servers for multiple public hosted zones, you can optionally associate a
     * reusable delegation set with the hosted zone. See the <code>DelegationSetId</code> element.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your domain is registered with a registrar other than Route 53, you must update the name servers with your
     * registrar to make Route 53 the DNS service for the domain. For more information, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/MigratingDNS.html">Migrating DNS Service for an
     * Existing Domain to Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When you submit a <code>CreateHostedZone</code> request, the initial status of the hosted zone is
     * <code>PENDING</code>. For public hosted zones, this means that the NS and SOA records are not yet available on
     * all Route 53 DNS servers. When the NS and SOA records are available, the status of the zone changes to
     * <code>INSYNC</code>.
     * </p>
     * <p>
     * The <code>CreateHostedZone</code> request requires the caller to have an <code>ec2:DescribeVpcs</code>
     * permission.
     * </p>
     * <note>
     * <p>
     * When creating private hosted zones, the Amazon VPC must belong to the same partition where the hosted zone is
     * created. A partition is a group of Amazon Web Services Regions. Each Amazon Web Services account is scoped to one
     * partition.
     * </p>
     * <p>
     * The following are the supported partitions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>aws</code> - Amazon Web Services Regions
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aws-cn</code> - China Regions
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aws-us-gov</code> - Amazon Web Services GovCloud (US) Region
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Access Management</a> in the
     * <i>Amazon Web Services General Reference</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateHostedZoneRequest.Builder} avoiding the need
     * to create one manually via {@link CreateHostedZoneRequest#builder()}
     * </p>
     *
     * @param createHostedZoneRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.CreateHostedZoneRequest.Builder} to create a request.
     *        A complex type that contains information about the request to create a public or private hosted zone.
     * @return A Java Future containing the result of the CreateHostedZone operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDomainNameException The specified domain name is not valid.</li>
     *         <li>HostedZoneAlreadyExistsException The hosted zone you're trying to create already exists. Amazon Route
     *         53 returns this error when a hosted zone has already been created with the specified
     *         <code>CallerReference</code>.</li>
     *         <li>TooManyHostedZonesException This operation can't be completed either because the current account has
     *         reached the limit on the number of hosted zones or because you've reached the limit on the number of
     *         hosted zones that can be associated with a reusable delegation set.</p>
     *         <p>
     *         For information about default limits, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the
     *         <i>Amazon Route 53 Developer Guide</i>.
     *         </p>
     *         <p>
     *         To get the current limit on hosted zones that can be created by an account, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html"
     *         >GetAccountLimit</a>.
     *         </p>
     *         <p>
     *         To get the current limit on hosted zones that can be associated with a reusable delegation set, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetReusableDelegationSetLimit.html">
     *         GetReusableDelegationSetLimit</a>.
     *         </p>
     *         <p>
     *         To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the
     *         Amazon Web Services Support Center.</li>
     *         <li>InvalidVpcIdException The VPC ID that you specified either isn't a valid ID or the current account is
     *         not authorized to access this VPC.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>DelegationSetNotAvailableException You can create a hosted zone that has the same name as an existing
     *         hosted zone (example.com is common), but there is a limit to the number of hosted zones that have the
     *         same name. If you get this error, Amazon Route 53 has reached that limit. If you own the domain name and
     *         Route 53 generates this error, contact Customer Support.</li>
     *         <li>ConflictingDomainExistsException The cause of this error depends on the operation that you're
     *         performing:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Create a public hosted zone:</b> Two hosted zones that have the same name or that have a parent/child
     *         relationship (example.com and test.example.com) can't have any common name servers. You tried to create a
     *         hosted zone that has the same name as an existing hosted zone or that's the parent or child of an
     *         existing hosted zone, and you specified a delegation set that shares one or more name servers with the
     *         existing hosted zone. For more information, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateReusableDelegationSet.html"
     *         >CreateReusableDelegationSet</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Create a private hosted zone:</b> A hosted zone with the specified name already exists and is already
     *         associated with the Amazon VPC that you specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Associate VPCs with a private hosted zone:</b> The VPC that you specified is already associated with
     *         another hosted zone that has the same name.
     *         </p>
     *         </li></li>
     *         <li>NoSuchDelegationSetException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>DelegationSetNotReusableException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.CreateHostedZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateHostedZone" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateHostedZoneResponse> createHostedZone(
            Consumer<CreateHostedZoneRequest.Builder> createHostedZoneRequest) {
        return createHostedZone(CreateHostedZoneRequest.builder().applyMutation(createHostedZoneRequest).build());
    }

    /**
     * <p>
     * Creates a new key-signing key (KSK) associated with a hosted zone. You can only have two KSKs per hosted zone.
     * </p>
     *
     * @param createKeySigningKeyRequest
     * @return A Java Future containing the result of the CreateKeySigningKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidArgumentException Parameter name is not valid.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>InvalidKmsArnException The KeyManagementServiceArn that you specified isn't valid to use with DNSSEC
     *         signing.</li>
     *         <li>InvalidKeySigningKeyStatusException The key-signing key (KSK) status isn't valid or another KSK has
     *         the status <code>INTERNAL_FAILURE</code>.</li>
     *         <li>InvalidSigningStatusException Your hosted zone status isn't valid for this operation. In the hosted
     *         zone, change the status to enable <code>DNSSEC</code> or disable <code>DNSSEC</code>.</li>
     *         <li>InvalidKeySigningKeyNameException The key-signing key (KSK) name that you specified isn't a valid
     *         name.</li>
     *         <li>KeySigningKeyAlreadyExistsException You've already created a key-signing key (KSK) with this name or
     *         with the same customer managed key ARN.</li>
     *         <li>TooManyKeySigningKeysException You've reached the limit for the number of key-signing keys (KSKs).
     *         Remove at least one KSK, and then try again.</li>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.CreateKeySigningKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateKeySigningKey" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateKeySigningKeyResponse> createKeySigningKey(
            CreateKeySigningKeyRequest createKeySigningKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new key-signing key (KSK) associated with a hosted zone. You can only have two KSKs per hosted zone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateKeySigningKeyRequest.Builder} avoiding the
     * need to create one manually via {@link CreateKeySigningKeyRequest#builder()}
     * </p>
     *
     * @param createKeySigningKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.CreateKeySigningKeyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateKeySigningKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidArgumentException Parameter name is not valid.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>InvalidKmsArnException The KeyManagementServiceArn that you specified isn't valid to use with DNSSEC
     *         signing.</li>
     *         <li>InvalidKeySigningKeyStatusException The key-signing key (KSK) status isn't valid or another KSK has
     *         the status <code>INTERNAL_FAILURE</code>.</li>
     *         <li>InvalidSigningStatusException Your hosted zone status isn't valid for this operation. In the hosted
     *         zone, change the status to enable <code>DNSSEC</code> or disable <code>DNSSEC</code>.</li>
     *         <li>InvalidKeySigningKeyNameException The key-signing key (KSK) name that you specified isn't a valid
     *         name.</li>
     *         <li>KeySigningKeyAlreadyExistsException You've already created a key-signing key (KSK) with this name or
     *         with the same customer managed key ARN.</li>
     *         <li>TooManyKeySigningKeysException You've reached the limit for the number of key-signing keys (KSKs).
     *         Remove at least one KSK, and then try again.</li>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.CreateKeySigningKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateKeySigningKey" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateKeySigningKeyResponse> createKeySigningKey(
            Consumer<CreateKeySigningKeyRequest.Builder> createKeySigningKeyRequest) {
        return createKeySigningKey(CreateKeySigningKeyRequest.builder().applyMutation(createKeySigningKeyRequest).build());
    }

    /**
     * <p>
     * Creates a configuration for DNS query logging. After you create a query logging configuration, Amazon Route 53
     * begins to publish log data to an Amazon CloudWatch Logs log group.
     * </p>
     * <p>
     * DNS query logs contain information about the queries that Route 53 receives for a specified public hosted zone,
     * such as the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Route 53 edge location that responded to the DNS query
     * </p>
     * </li>
     * <li>
     * <p>
     * Domain or subdomain that was requested
     * </p>
     * </li>
     * <li>
     * <p>
     * DNS record type, such as A or AAAA
     * </p>
     * </li>
     * <li>
     * <p>
     * DNS response code, such as <code>NoError</code> or <code>ServFail</code>
     * </p>
     * </li>
     * </ul>
     * <dl>
     * <dt>Log Group and Resource Policy</dt>
     * <dd>
     * <p>
     * Before you create a query logging configuration, perform the following operations.
     * </p>
     * <note>
     * <p>
     * If you create a query logging configuration using the Route 53 console, Route 53 performs these operations
     * automatically.
     * </p>
     * </note>
     * <ol>
     * <li>
     * <p>
     * Create a CloudWatch Logs log group, and make note of the ARN, which you specify when you create a query logging
     * configuration. Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must create the log group in the us-east-1 region.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must use the same Amazon Web Services account to create the log group and the hosted zone that you want to
     * configure query logging for.
     * </p>
     * </li>
     * <li>
     * <p>
     * When you create log groups for query logging, we recommend that you use a consistent prefix, for example:
     * </p>
     * <p>
     * <code>/aws/route53/<i>hosted zone name</i> </code>
     * </p>
     * <p>
     * In the next step, you'll create a resource policy, which controls access to one or more log groups and the
     * associated Amazon Web Services resources, such as Route 53 hosted zones. There's a limit on the number of
     * resource policies that you can create, so we recommend that you use a consistent prefix so you can use the same
     * resource policy for all the log groups that you create for query logging.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Create a CloudWatch Logs resource policy, and give it the permissions that Route 53 needs to create log streams
     * and to send query logs to log streams. For the value of <code>Resource</code>, specify the ARN for the log group
     * that you created in the previous step. To use the same resource policy for all the CloudWatch Logs log groups
     * that you created for query logging configurations, replace the hosted zone name with <code>*</code>, for example:
     * </p>
     * <p>
     * <code>arn:aws:logs:us-east-1:123412341234:log-group:/aws/route53/*</code>
     * </p>
     * <p>
     * To avoid the confused deputy problem, a security issue where an entity without a permission for an action can
     * coerce a more-privileged entity to perform it, you can optionally limit the permissions that a service has to a
     * resource in a resource-based policy by supplying the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <code>aws:SourceArn</code>, supply the hosted zone ARN used in creating the query logging configuration. For
     * example, <code>aws:SourceArn: arn:aws:route53:::hostedzone/hosted zone ID</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>aws:SourceAccount</code>, supply the account ID for the account that creates the query logging
     * configuration. For example, <code>aws:SourceAccount:111111111111</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/confused-deputy.html">The
     * confused deputy problem</a> in the <i>Amazon Web Services IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * You can't use the CloudWatch console to create or edit a resource policy. You must use the CloudWatch API, one of
     * the Amazon Web Services SDKs, or the CLI.
     * </p>
     * </note></li>
     * </ol>
     * </dd>
     * <dt>Log Streams and Edge Locations</dt>
     * <dd>
     * <p>
     * When Route 53 finishes creating the configuration for DNS query logging, it does the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Creates a log stream for an edge location the first time that the edge location responds to DNS queries for the
     * specified hosted zone. That log stream is used to log all queries that Route 53 responds to for that edge
     * location.
     * </p>
     * </li>
     * <li>
     * <p>
     * Begins to send query logs to the applicable log stream.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The name of each log stream is in the following format:
     * </p>
     * <p>
     * <code> <i>hosted zone ID</i>/<i>edge location code</i> </code>
     * </p>
     * <p>
     * The edge location code is a three-letter code and an arbitrarily assigned number, for example, DFW3. The
     * three-letter code typically corresponds with the International Air Transport Association airport code for an
     * airport near the edge location. (These abbreviations might change in the future.) For a list of edge locations,
     * see "The Route 53 Global Network" on the <a href="http://aws.amazon.com/route53/details/">Route 53 Product
     * Details</a> page.
     * </p>
     * </dd>
     * <dt>Queries That Are Logged</dt>
     * <dd>
     * <p>
     * Query logs contain only the queries that DNS resolvers forward to Route 53. If a DNS resolver has already cached
     * the response to a query (such as the IP address for a load balancer for example.com), the resolver will continue
     * to return the cached response. It doesn't forward another query to Route 53 until the TTL for the corresponding
     * resource record set expires. Depending on how many DNS queries are submitted for a resource record set, and
     * depending on the TTL for that resource record set, query logs might contain information about only one query out
     * of every several thousand queries that are submitted to DNS. For more information about how DNS works, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/welcome-dns-service.html">Routing Internet
     * Traffic to Your Website or Web Application</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * </dd>
     * <dt>Log File Format</dt>
     * <dd>
     * <p>
     * For a list of the values in each query log and the format of each value, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html">Logging DNS Queries</a> in the
     * <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * </dd>
     * <dt>Pricing</dt>
     * <dd>
     * <p>
     * For information about charges for query logs, see <a href="http://aws.amazon.com/cloudwatch/pricing/">Amazon
     * CloudWatch Pricing</a>.
     * </p>
     * </dd>
     * <dt>How to Stop Logging</dt>
     * <dd>
     * <p>
     * If you want Route 53 to stop sending query logs to CloudWatch Logs, delete the query logging configuration. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteQueryLoggingConfig.html"
     * >DeleteQueryLoggingConfig</a>.
     * </p>
     * </dd>
     * </dl>
     *
     * @param createQueryLoggingConfigRequest
     * @return A Java Future containing the result of the CreateQueryLoggingConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>NoSuchCloudWatchLogsLogGroupException There is no CloudWatch Logs log group with the specified ARN.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>QueryLoggingConfigAlreadyExistsException You can create only one query logging configuration for a
     *         hosted zone, and a query logging configuration already exists for this hosted zone.</li>
     *         <li>InsufficientCloudWatchLogsResourcePolicyException Amazon Route 53 doesn't have the permissions
     *         required to create log streams and send query logs to log streams. Possible causes include the
     *         following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         There is no resource policy that specifies the log group ARN in the value for <code>Resource</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The resource policy that includes the log group ARN in the value for <code>Resource</code> doesn't have
     *         the necessary permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The resource policy hasn't finished propagating yet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The Key management service (KMS) key you specified doesn’t exist or it can’t be used with the log group
     *         associated with query log. Update or provide a resource policy to grant permissions for the KMS key.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The Key management service (KMS) key you specified is marked as disabled for the log group associated
     *         with query log. Update or provide a resource policy to grant permissions for the KMS key.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.CreateQueryLoggingConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateQueryLoggingConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateQueryLoggingConfigResponse> createQueryLoggingConfig(
            CreateQueryLoggingConfigRequest createQueryLoggingConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a configuration for DNS query logging. After you create a query logging configuration, Amazon Route 53
     * begins to publish log data to an Amazon CloudWatch Logs log group.
     * </p>
     * <p>
     * DNS query logs contain information about the queries that Route 53 receives for a specified public hosted zone,
     * such as the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Route 53 edge location that responded to the DNS query
     * </p>
     * </li>
     * <li>
     * <p>
     * Domain or subdomain that was requested
     * </p>
     * </li>
     * <li>
     * <p>
     * DNS record type, such as A or AAAA
     * </p>
     * </li>
     * <li>
     * <p>
     * DNS response code, such as <code>NoError</code> or <code>ServFail</code>
     * </p>
     * </li>
     * </ul>
     * <dl>
     * <dt>Log Group and Resource Policy</dt>
     * <dd>
     * <p>
     * Before you create a query logging configuration, perform the following operations.
     * </p>
     * <note>
     * <p>
     * If you create a query logging configuration using the Route 53 console, Route 53 performs these operations
     * automatically.
     * </p>
     * </note>
     * <ol>
     * <li>
     * <p>
     * Create a CloudWatch Logs log group, and make note of the ARN, which you specify when you create a query logging
     * configuration. Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must create the log group in the us-east-1 region.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must use the same Amazon Web Services account to create the log group and the hosted zone that you want to
     * configure query logging for.
     * </p>
     * </li>
     * <li>
     * <p>
     * When you create log groups for query logging, we recommend that you use a consistent prefix, for example:
     * </p>
     * <p>
     * <code>/aws/route53/<i>hosted zone name</i> </code>
     * </p>
     * <p>
     * In the next step, you'll create a resource policy, which controls access to one or more log groups and the
     * associated Amazon Web Services resources, such as Route 53 hosted zones. There's a limit on the number of
     * resource policies that you can create, so we recommend that you use a consistent prefix so you can use the same
     * resource policy for all the log groups that you create for query logging.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Create a CloudWatch Logs resource policy, and give it the permissions that Route 53 needs to create log streams
     * and to send query logs to log streams. For the value of <code>Resource</code>, specify the ARN for the log group
     * that you created in the previous step. To use the same resource policy for all the CloudWatch Logs log groups
     * that you created for query logging configurations, replace the hosted zone name with <code>*</code>, for example:
     * </p>
     * <p>
     * <code>arn:aws:logs:us-east-1:123412341234:log-group:/aws/route53/*</code>
     * </p>
     * <p>
     * To avoid the confused deputy problem, a security issue where an entity without a permission for an action can
     * coerce a more-privileged entity to perform it, you can optionally limit the permissions that a service has to a
     * resource in a resource-based policy by supplying the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <code>aws:SourceArn</code>, supply the hosted zone ARN used in creating the query logging configuration. For
     * example, <code>aws:SourceArn: arn:aws:route53:::hostedzone/hosted zone ID</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>aws:SourceAccount</code>, supply the account ID for the account that creates the query logging
     * configuration. For example, <code>aws:SourceAccount:111111111111</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/confused-deputy.html">The
     * confused deputy problem</a> in the <i>Amazon Web Services IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * You can't use the CloudWatch console to create or edit a resource policy. You must use the CloudWatch API, one of
     * the Amazon Web Services SDKs, or the CLI.
     * </p>
     * </note></li>
     * </ol>
     * </dd>
     * <dt>Log Streams and Edge Locations</dt>
     * <dd>
     * <p>
     * When Route 53 finishes creating the configuration for DNS query logging, it does the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Creates a log stream for an edge location the first time that the edge location responds to DNS queries for the
     * specified hosted zone. That log stream is used to log all queries that Route 53 responds to for that edge
     * location.
     * </p>
     * </li>
     * <li>
     * <p>
     * Begins to send query logs to the applicable log stream.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The name of each log stream is in the following format:
     * </p>
     * <p>
     * <code> <i>hosted zone ID</i>/<i>edge location code</i> </code>
     * </p>
     * <p>
     * The edge location code is a three-letter code and an arbitrarily assigned number, for example, DFW3. The
     * three-letter code typically corresponds with the International Air Transport Association airport code for an
     * airport near the edge location. (These abbreviations might change in the future.) For a list of edge locations,
     * see "The Route 53 Global Network" on the <a href="http://aws.amazon.com/route53/details/">Route 53 Product
     * Details</a> page.
     * </p>
     * </dd>
     * <dt>Queries That Are Logged</dt>
     * <dd>
     * <p>
     * Query logs contain only the queries that DNS resolvers forward to Route 53. If a DNS resolver has already cached
     * the response to a query (such as the IP address for a load balancer for example.com), the resolver will continue
     * to return the cached response. It doesn't forward another query to Route 53 until the TTL for the corresponding
     * resource record set expires. Depending on how many DNS queries are submitted for a resource record set, and
     * depending on the TTL for that resource record set, query logs might contain information about only one query out
     * of every several thousand queries that are submitted to DNS. For more information about how DNS works, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/welcome-dns-service.html">Routing Internet
     * Traffic to Your Website or Web Application</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * </dd>
     * <dt>Log File Format</dt>
     * <dd>
     * <p>
     * For a list of the values in each query log and the format of each value, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html">Logging DNS Queries</a> in the
     * <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * </dd>
     * <dt>Pricing</dt>
     * <dd>
     * <p>
     * For information about charges for query logs, see <a href="http://aws.amazon.com/cloudwatch/pricing/">Amazon
     * CloudWatch Pricing</a>.
     * </p>
     * </dd>
     * <dt>How to Stop Logging</dt>
     * <dd>
     * <p>
     * If you want Route 53 to stop sending query logs to CloudWatch Logs, delete the query logging configuration. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteQueryLoggingConfig.html"
     * >DeleteQueryLoggingConfig</a>.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateQueryLoggingConfigRequest.Builder} avoiding
     * the need to create one manually via {@link CreateQueryLoggingConfigRequest#builder()}
     * </p>
     *
     * @param createQueryLoggingConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.CreateQueryLoggingConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateQueryLoggingConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>NoSuchCloudWatchLogsLogGroupException There is no CloudWatch Logs log group with the specified ARN.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>QueryLoggingConfigAlreadyExistsException You can create only one query logging configuration for a
     *         hosted zone, and a query logging configuration already exists for this hosted zone.</li>
     *         <li>InsufficientCloudWatchLogsResourcePolicyException Amazon Route 53 doesn't have the permissions
     *         required to create log streams and send query logs to log streams. Possible causes include the
     *         following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         There is no resource policy that specifies the log group ARN in the value for <code>Resource</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The resource policy that includes the log group ARN in the value for <code>Resource</code> doesn't have
     *         the necessary permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The resource policy hasn't finished propagating yet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The Key management service (KMS) key you specified doesn’t exist or it can’t be used with the log group
     *         associated with query log. Update or provide a resource policy to grant permissions for the KMS key.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The Key management service (KMS) key you specified is marked as disabled for the log group associated
     *         with query log. Update or provide a resource policy to grant permissions for the KMS key.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.CreateQueryLoggingConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateQueryLoggingConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateQueryLoggingConfigResponse> createQueryLoggingConfig(
            Consumer<CreateQueryLoggingConfigRequest.Builder> createQueryLoggingConfigRequest) {
        return createQueryLoggingConfig(CreateQueryLoggingConfigRequest.builder().applyMutation(createQueryLoggingConfigRequest)
                .build());
    }

    /**
     * <p>
     * Creates a delegation set (a group of four name servers) that can be reused by multiple hosted zones that were
     * created by the same Amazon Web Services account.
     * </p>
     * <p>
     * You can also create a reusable delegation set that uses the four name servers that are associated with an
     * existing hosted zone. Specify the hosted zone ID in the <code>CreateReusableDelegationSet</code> request.
     * </p>
     * <note>
     * <p>
     * You can't associate a reusable delegation set with a private hosted zone.
     * </p>
     * </note>
     * <p>
     * For information about using a reusable delegation set to configure white label name servers, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/white-label-name-servers.html">Configuring White
     * Label Name Servers</a>.
     * </p>
     * <p>
     * The process for migrating existing hosted zones to use a reusable delegation set is comparable to the process for
     * configuring white label name servers. You need to perform the following steps:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Create a reusable delegation set.
     * </p>
     * </li>
     * <li>
     * <p>
     * Recreate hosted zones, and reduce the TTL to 60 seconds or less.
     * </p>
     * </li>
     * <li>
     * <p>
     * Recreate resource record sets in the new hosted zones.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change the registrar's name servers to use the name servers for the new hosted zones.
     * </p>
     * </li>
     * <li>
     * <p>
     * Monitor traffic for the website or application.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change TTLs back to their original values.
     * </p>
     * </li>
     * </ol>
     * <p>
     * If you want to migrate existing hosted zones to use a reusable delegation set, the existing hosted zones can't
     * use any of the name servers that are assigned to the reusable delegation set. If one or more hosted zones do use
     * one or more name servers that are assigned to the reusable delegation set, you can do one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For small numbers of hosted zones—up to a few hundred—it's relatively easy to create reusable delegation sets
     * until you get one that has four name servers that don't overlap with any of the name servers in your hosted
     * zones.
     * </p>
     * </li>
     * <li>
     * <p>
     * For larger numbers of hosted zones, the easiest solution is to use more than one reusable delegation set.
     * </p>
     * </li>
     * <li>
     * <p>
     * For larger numbers of hosted zones, you can also migrate hosted zones that have overlapping name servers to
     * hosted zones that don't have overlapping name servers, then migrate the hosted zones again to use the reusable
     * delegation set.
     * </p>
     * </li>
     * </ul>
     *
     * @param createReusableDelegationSetRequest
     * @return A Java Future containing the result of the CreateReusableDelegationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DelegationSetAlreadyCreatedException A delegation set with the same owner and caller reference
     *         combination has already been created.</li>
     *         <li>LimitsExceededException This operation can't be completed because the current account has reached the
     *         limit on the resource you are trying to create. To request a higher limit, <a
     *         href="http://aws.amazon.com/route53-request">create a case</a> with the Amazon Web Services Support
     *         Center.</li>
     *         <li>HostedZoneNotFoundException The specified HostedZone can't be found.</li>
     *         <li>InvalidArgumentException Parameter name is not valid.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>DelegationSetNotAvailableException You can create a hosted zone that has the same name as an existing
     *         hosted zone (example.com is common), but there is a limit to the number of hosted zones that have the
     *         same name. If you get this error, Amazon Route 53 has reached that limit. If you own the domain name and
     *         Route 53 generates this error, contact Customer Support.</li>
     *         <li>DelegationSetAlreadyReusableException The specified delegation set has already been marked as
     *         reusable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.CreateReusableDelegationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateReusableDelegationSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateReusableDelegationSetResponse> createReusableDelegationSet(
            CreateReusableDelegationSetRequest createReusableDelegationSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a delegation set (a group of four name servers) that can be reused by multiple hosted zones that were
     * created by the same Amazon Web Services account.
     * </p>
     * <p>
     * You can also create a reusable delegation set that uses the four name servers that are associated with an
     * existing hosted zone. Specify the hosted zone ID in the <code>CreateReusableDelegationSet</code> request.
     * </p>
     * <note>
     * <p>
     * You can't associate a reusable delegation set with a private hosted zone.
     * </p>
     * </note>
     * <p>
     * For information about using a reusable delegation set to configure white label name servers, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/white-label-name-servers.html">Configuring White
     * Label Name Servers</a>.
     * </p>
     * <p>
     * The process for migrating existing hosted zones to use a reusable delegation set is comparable to the process for
     * configuring white label name servers. You need to perform the following steps:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Create a reusable delegation set.
     * </p>
     * </li>
     * <li>
     * <p>
     * Recreate hosted zones, and reduce the TTL to 60 seconds or less.
     * </p>
     * </li>
     * <li>
     * <p>
     * Recreate resource record sets in the new hosted zones.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change the registrar's name servers to use the name servers for the new hosted zones.
     * </p>
     * </li>
     * <li>
     * <p>
     * Monitor traffic for the website or application.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change TTLs back to their original values.
     * </p>
     * </li>
     * </ol>
     * <p>
     * If you want to migrate existing hosted zones to use a reusable delegation set, the existing hosted zones can't
     * use any of the name servers that are assigned to the reusable delegation set. If one or more hosted zones do use
     * one or more name servers that are assigned to the reusable delegation set, you can do one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For small numbers of hosted zones—up to a few hundred—it's relatively easy to create reusable delegation sets
     * until you get one that has four name servers that don't overlap with any of the name servers in your hosted
     * zones.
     * </p>
     * </li>
     * <li>
     * <p>
     * For larger numbers of hosted zones, the easiest solution is to use more than one reusable delegation set.
     * </p>
     * </li>
     * <li>
     * <p>
     * For larger numbers of hosted zones, you can also migrate hosted zones that have overlapping name servers to
     * hosted zones that don't have overlapping name servers, then migrate the hosted zones again to use the reusable
     * delegation set.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReusableDelegationSetRequest.Builder}
     * avoiding the need to create one manually via {@link CreateReusableDelegationSetRequest#builder()}
     * </p>
     *
     * @param createReusableDelegationSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.CreateReusableDelegationSetRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateReusableDelegationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DelegationSetAlreadyCreatedException A delegation set with the same owner and caller reference
     *         combination has already been created.</li>
     *         <li>LimitsExceededException This operation can't be completed because the current account has reached the
     *         limit on the resource you are trying to create. To request a higher limit, <a
     *         href="http://aws.amazon.com/route53-request">create a case</a> with the Amazon Web Services Support
     *         Center.</li>
     *         <li>HostedZoneNotFoundException The specified HostedZone can't be found.</li>
     *         <li>InvalidArgumentException Parameter name is not valid.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>DelegationSetNotAvailableException You can create a hosted zone that has the same name as an existing
     *         hosted zone (example.com is common), but there is a limit to the number of hosted zones that have the
     *         same name. If you get this error, Amazon Route 53 has reached that limit. If you own the domain name and
     *         Route 53 generates this error, contact Customer Support.</li>
     *         <li>DelegationSetAlreadyReusableException The specified delegation set has already been marked as
     *         reusable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.CreateReusableDelegationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateReusableDelegationSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateReusableDelegationSetResponse> createReusableDelegationSet(
            Consumer<CreateReusableDelegationSetRequest.Builder> createReusableDelegationSetRequest) {
        return createReusableDelegationSet(CreateReusableDelegationSetRequest.builder()
                .applyMutation(createReusableDelegationSetRequest).build());
    }

    /**
     * <p>
     * Creates a traffic policy, which you use to create multiple DNS resource record sets for one domain name (such as
     * example.com) or one subdomain name (such as www.example.com).
     * </p>
     *
     * @param createTrafficPolicyRequest
     *        A complex type that contains information about the traffic policy that you want to create.
     * @return A Java Future containing the result of the CreateTrafficPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>TooManyTrafficPoliciesException This traffic policy can't be created because the current account has
     *         reached the limit on the number of traffic policies.</p>
     *         <p>
     *         For information about default limits, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the
     *         <i>Amazon Route 53 Developer Guide</i>.
     *         </p>
     *         <p>
     *         To get the current limit for an account, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html"
     *         >GetAccountLimit</a>.
     *         </p>
     *         <p>
     *         To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the
     *         Amazon Web Services Support Center.</li>
     *         <li>TrafficPolicyAlreadyExistsException A traffic policy that has the same value for <code>Name</code>
     *         already exists.</li>
     *         <li>InvalidTrafficPolicyDocumentException The format of the traffic policy document that you specified in
     *         the <code>Document</code> element is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.CreateTrafficPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateTrafficPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateTrafficPolicyResponse> createTrafficPolicy(
            CreateTrafficPolicyRequest createTrafficPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a traffic policy, which you use to create multiple DNS resource record sets for one domain name (such as
     * example.com) or one subdomain name (such as www.example.com).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrafficPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link CreateTrafficPolicyRequest#builder()}
     * </p>
     *
     * @param createTrafficPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.CreateTrafficPolicyRequest.Builder} to create a
     *        request. A complex type that contains information about the traffic policy that you want to create.
     * @return A Java Future containing the result of the CreateTrafficPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>TooManyTrafficPoliciesException This traffic policy can't be created because the current account has
     *         reached the limit on the number of traffic policies.</p>
     *         <p>
     *         For information about default limits, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the
     *         <i>Amazon Route 53 Developer Guide</i>.
     *         </p>
     *         <p>
     *         To get the current limit for an account, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html"
     *         >GetAccountLimit</a>.
     *         </p>
     *         <p>
     *         To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the
     *         Amazon Web Services Support Center.</li>
     *         <li>TrafficPolicyAlreadyExistsException A traffic policy that has the same value for <code>Name</code>
     *         already exists.</li>
     *         <li>InvalidTrafficPolicyDocumentException The format of the traffic policy document that you specified in
     *         the <code>Document</code> element is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.CreateTrafficPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateTrafficPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateTrafficPolicyResponse> createTrafficPolicy(
            Consumer<CreateTrafficPolicyRequest.Builder> createTrafficPolicyRequest) {
        return createTrafficPolicy(CreateTrafficPolicyRequest.builder().applyMutation(createTrafficPolicyRequest).build());
    }

    /**
     * <p>
     * Creates resource record sets in a specified hosted zone based on the settings in a specified traffic policy
     * version. In addition, <code>CreateTrafficPolicyInstance</code> associates the resource record sets with a
     * specified domain name (such as example.com) or subdomain name (such as www.example.com). Amazon Route 53 responds
     * to DNS queries for the domain or subdomain name by using the resource record sets that
     * <code>CreateTrafficPolicyInstance</code> created.
     * </p>
     * <note>
     * <p>
     * After you submit an <code>CreateTrafficPolicyInstance</code> request, there's a brief delay while Amazon Route 53
     * creates the resource record sets that are specified in the traffic policy definition. Use
     * <code>GetTrafficPolicyInstance</code> with the <code>id</code> of new traffic policy instance to confirm that the
     * <code>CreateTrafficPolicyInstance</code> request completed successfully. For more information, see the
     * <code>State</code> response element.
     * </p>
     * </note>
     *
     * @param createTrafficPolicyInstanceRequest
     *        A complex type that contains information about the resource record sets that you want to create based on a
     *        specified traffic policy.
     * @return A Java Future containing the result of the CreateTrafficPolicyInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>TooManyTrafficPolicyInstancesException This traffic policy instance can't be created because the
     *         current account has reached the limit on the number of traffic policy instances.</p>
     *         <p>
     *         For information about default limits, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the
     *         <i>Amazon Route 53 Developer Guide</i>.
     *         </p>
     *         <p>
     *         For information about how to get the current limit for an account, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html"
     *         >GetAccountLimit</a>.
     *         </p>
     *         <p>
     *         To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the
     *         Amazon Web Services Support Center.</li>
     *         <li>NoSuchTrafficPolicyException No traffic policy exists with the specified ID.</li>
     *         <li>TrafficPolicyInstanceAlreadyExistsException There is already a traffic policy instance with the
     *         specified ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.CreateTrafficPolicyInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateTrafficPolicyInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTrafficPolicyInstanceResponse> createTrafficPolicyInstance(
            CreateTrafficPolicyInstanceRequest createTrafficPolicyInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates resource record sets in a specified hosted zone based on the settings in a specified traffic policy
     * version. In addition, <code>CreateTrafficPolicyInstance</code> associates the resource record sets with a
     * specified domain name (such as example.com) or subdomain name (such as www.example.com). Amazon Route 53 responds
     * to DNS queries for the domain or subdomain name by using the resource record sets that
     * <code>CreateTrafficPolicyInstance</code> created.
     * </p>
     * <note>
     * <p>
     * After you submit an <code>CreateTrafficPolicyInstance</code> request, there's a brief delay while Amazon Route 53
     * creates the resource record sets that are specified in the traffic policy definition. Use
     * <code>GetTrafficPolicyInstance</code> with the <code>id</code> of new traffic policy instance to confirm that the
     * <code>CreateTrafficPolicyInstance</code> request completed successfully. For more information, see the
     * <code>State</code> response element.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrafficPolicyInstanceRequest.Builder}
     * avoiding the need to create one manually via {@link CreateTrafficPolicyInstanceRequest#builder()}
     * </p>
     *
     * @param createTrafficPolicyInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.CreateTrafficPolicyInstanceRequest.Builder} to create
     *        a request. A complex type that contains information about the resource record sets that you want to create
     *        based on a specified traffic policy.
     * @return A Java Future containing the result of the CreateTrafficPolicyInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>TooManyTrafficPolicyInstancesException This traffic policy instance can't be created because the
     *         current account has reached the limit on the number of traffic policy instances.</p>
     *         <p>
     *         For information about default limits, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the
     *         <i>Amazon Route 53 Developer Guide</i>.
     *         </p>
     *         <p>
     *         For information about how to get the current limit for an account, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html"
     *         >GetAccountLimit</a>.
     *         </p>
     *         <p>
     *         To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the
     *         Amazon Web Services Support Center.</li>
     *         <li>NoSuchTrafficPolicyException No traffic policy exists with the specified ID.</li>
     *         <li>TrafficPolicyInstanceAlreadyExistsException There is already a traffic policy instance with the
     *         specified ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.CreateTrafficPolicyInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateTrafficPolicyInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTrafficPolicyInstanceResponse> createTrafficPolicyInstance(
            Consumer<CreateTrafficPolicyInstanceRequest.Builder> createTrafficPolicyInstanceRequest) {
        return createTrafficPolicyInstance(CreateTrafficPolicyInstanceRequest.builder()
                .applyMutation(createTrafficPolicyInstanceRequest).build());
    }

    /**
     * <p>
     * Creates a new version of an existing traffic policy. When you create a new version of a traffic policy, you
     * specify the ID of the traffic policy that you want to update and a JSON-formatted document that describes the new
     * version. You use traffic policies to create multiple DNS resource record sets for one domain name (such as
     * example.com) or one subdomain name (such as www.example.com). You can create a maximum of 1000 versions of a
     * traffic policy. If you reach the limit and need to create another version, you'll need to start a new traffic
     * policy.
     * </p>
     *
     * @param createTrafficPolicyVersionRequest
     *        A complex type that contains information about the traffic policy that you want to create a new version
     *        for.
     * @return A Java Future containing the result of the CreateTrafficPolicyVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchTrafficPolicyException No traffic policy exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>TooManyTrafficPolicyVersionsForCurrentPolicyException This traffic policy version can't be created
     *         because you've reached the limit of 1000 on the number of versions that you can create for the current
     *         traffic policy.</p>
     *         <p>
     *         To create more traffic policy versions, you can use <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetTrafficPolicy.html"
     *         >GetTrafficPolicy</a> to get the traffic policy document for a specified traffic policy version, and then
     *         use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateTrafficPolicy.html">
     *         CreateTrafficPolicy</a> to create a new traffic policy using the traffic policy document.</li>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>InvalidTrafficPolicyDocumentException The format of the traffic policy document that you specified in
     *         the <code>Document</code> element is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.CreateTrafficPolicyVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateTrafficPolicyVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTrafficPolicyVersionResponse> createTrafficPolicyVersion(
            CreateTrafficPolicyVersionRequest createTrafficPolicyVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new version of an existing traffic policy. When you create a new version of a traffic policy, you
     * specify the ID of the traffic policy that you want to update and a JSON-formatted document that describes the new
     * version. You use traffic policies to create multiple DNS resource record sets for one domain name (such as
     * example.com) or one subdomain name (such as www.example.com). You can create a maximum of 1000 versions of a
     * traffic policy. If you reach the limit and need to create another version, you'll need to start a new traffic
     * policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrafficPolicyVersionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateTrafficPolicyVersionRequest#builder()}
     * </p>
     *
     * @param createTrafficPolicyVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.CreateTrafficPolicyVersionRequest.Builder} to create
     *        a request. A complex type that contains information about the traffic policy that you want to create a new
     *        version for.
     * @return A Java Future containing the result of the CreateTrafficPolicyVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchTrafficPolicyException No traffic policy exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>TooManyTrafficPolicyVersionsForCurrentPolicyException This traffic policy version can't be created
     *         because you've reached the limit of 1000 on the number of versions that you can create for the current
     *         traffic policy.</p>
     *         <p>
     *         To create more traffic policy versions, you can use <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetTrafficPolicy.html"
     *         >GetTrafficPolicy</a> to get the traffic policy document for a specified traffic policy version, and then
     *         use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateTrafficPolicy.html">
     *         CreateTrafficPolicy</a> to create a new traffic policy using the traffic policy document.</li>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>InvalidTrafficPolicyDocumentException The format of the traffic policy document that you specified in
     *         the <code>Document</code> element is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.CreateTrafficPolicyVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateTrafficPolicyVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTrafficPolicyVersionResponse> createTrafficPolicyVersion(
            Consumer<CreateTrafficPolicyVersionRequest.Builder> createTrafficPolicyVersionRequest) {
        return createTrafficPolicyVersion(CreateTrafficPolicyVersionRequest.builder()
                .applyMutation(createTrafficPolicyVersionRequest).build());
    }

    /**
     * <p>
     * Authorizes the Amazon Web Services account that created a specified VPC to submit an
     * <code>AssociateVPCWithHostedZone</code> request to associate the VPC with a specified hosted zone that was
     * created by a different account. To submit a <code>CreateVPCAssociationAuthorization</code> request, you must use
     * the account that created the hosted zone. After you authorize the association, use the account that created the
     * VPC to submit an <code>AssociateVPCWithHostedZone</code> request.
     * </p>
     * <note>
     * <p>
     * If you want to associate multiple VPCs that you created by using one account with a hosted zone that you created
     * by using a different account, you must submit one authorization request for each VPC.
     * </p>
     * </note>
     *
     * @param createVpcAssociationAuthorizationRequest
     *        A complex type that contains information about the request to authorize associating a VPC with your
     *        private hosted zone. Authorization is only required when a private hosted zone and a VPC were created by
     *        using different accounts.
     * @return A Java Future containing the result of the CreateVPCAssociationAuthorization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>TooManyVpcAssociationAuthorizationsException You've created the maximum number of authorizations that
     *         can be created for the specified hosted zone. To authorize another VPC to be associated with the hosted
     *         zone, submit a <code>DeleteVPCAssociationAuthorization</code> request to remove an existing
     *         authorization. To get a list of existing authorizations, submit a
     *         <code>ListVPCAssociationAuthorizations</code> request.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidVpcIdException The VPC ID that you specified either isn't a valid ID or the current account is
     *         not authorized to access this VPC.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.CreateVPCAssociationAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateVPCAssociationAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVpcAssociationAuthorizationResponse> createVPCAssociationAuthorization(
            CreateVpcAssociationAuthorizationRequest createVpcAssociationAuthorizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Authorizes the Amazon Web Services account that created a specified VPC to submit an
     * <code>AssociateVPCWithHostedZone</code> request to associate the VPC with a specified hosted zone that was
     * created by a different account. To submit a <code>CreateVPCAssociationAuthorization</code> request, you must use
     * the account that created the hosted zone. After you authorize the association, use the account that created the
     * VPC to submit an <code>AssociateVPCWithHostedZone</code> request.
     * </p>
     * <note>
     * <p>
     * If you want to associate multiple VPCs that you created by using one account with a hosted zone that you created
     * by using a different account, you must submit one authorization request for each VPC.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVpcAssociationAuthorizationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateVpcAssociationAuthorizationRequest#builder()}
     * </p>
     *
     * @param createVpcAssociationAuthorizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.CreateVpcAssociationAuthorizationRequest.Builder} to
     *        create a request. A complex type that contains information about the request to authorize associating a
     *        VPC with your private hosted zone. Authorization is only required when a private hosted zone and a VPC
     *        were created by using different accounts.
     * @return A Java Future containing the result of the CreateVPCAssociationAuthorization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>TooManyVpcAssociationAuthorizationsException You've created the maximum number of authorizations that
     *         can be created for the specified hosted zone. To authorize another VPC to be associated with the hosted
     *         zone, submit a <code>DeleteVPCAssociationAuthorization</code> request to remove an existing
     *         authorization. To get a list of existing authorizations, submit a
     *         <code>ListVPCAssociationAuthorizations</code> request.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidVpcIdException The VPC ID that you specified either isn't a valid ID or the current account is
     *         not authorized to access this VPC.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.CreateVPCAssociationAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateVPCAssociationAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVpcAssociationAuthorizationResponse> createVPCAssociationAuthorization(
            Consumer<CreateVpcAssociationAuthorizationRequest.Builder> createVpcAssociationAuthorizationRequest) {
        return createVPCAssociationAuthorization(CreateVpcAssociationAuthorizationRequest.builder()
                .applyMutation(createVpcAssociationAuthorizationRequest).build());
    }

    /**
     * <p>
     * Deactivates a key-signing key (KSK) so that it will not be used for signing by DNSSEC. This operation changes the
     * KSK status to <code>INACTIVE</code>.
     * </p>
     *
     * @param deactivateKeySigningKeyRequest
     * @return A Java Future containing the result of the DeactivateKeySigningKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>NoSuchKeySigningKeyException The specified key-signing key (KSK) doesn't exist.</li>
     *         <li>InvalidKeySigningKeyStatusException The key-signing key (KSK) status isn't valid or another KSK has
     *         the status <code>INTERNAL_FAILURE</code>.</li>
     *         <li>InvalidSigningStatusException Your hosted zone status isn't valid for this operation. In the hosted
     *         zone, change the status to enable <code>DNSSEC</code> or disable <code>DNSSEC</code>.</li>
     *         <li>KeySigningKeyInUseException The key-signing key (KSK) that you specified can't be deactivated because
     *         it's the only KSK for a currently-enabled DNSSEC. Disable DNSSEC signing, or add or enable another KSK.</li>
     *         <li>KeySigningKeyInParentDsRecordException The key-signing key (KSK) is specified in a parent DS record.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.DeactivateKeySigningKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeactivateKeySigningKey"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeactivateKeySigningKeyResponse> deactivateKeySigningKey(
            DeactivateKeySigningKeyRequest deactivateKeySigningKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deactivates a key-signing key (KSK) so that it will not be used for signing by DNSSEC. This operation changes the
     * KSK status to <code>INACTIVE</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeactivateKeySigningKeyRequest.Builder} avoiding
     * the need to create one manually via {@link DeactivateKeySigningKeyRequest#builder()}
     * </p>
     *
     * @param deactivateKeySigningKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.DeactivateKeySigningKeyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeactivateKeySigningKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>NoSuchKeySigningKeyException The specified key-signing key (KSK) doesn't exist.</li>
     *         <li>InvalidKeySigningKeyStatusException The key-signing key (KSK) status isn't valid or another KSK has
     *         the status <code>INTERNAL_FAILURE</code>.</li>
     *         <li>InvalidSigningStatusException Your hosted zone status isn't valid for this operation. In the hosted
     *         zone, change the status to enable <code>DNSSEC</code> or disable <code>DNSSEC</code>.</li>
     *         <li>KeySigningKeyInUseException The key-signing key (KSK) that you specified can't be deactivated because
     *         it's the only KSK for a currently-enabled DNSSEC. Disable DNSSEC signing, or add or enable another KSK.</li>
     *         <li>KeySigningKeyInParentDsRecordException The key-signing key (KSK) is specified in a parent DS record.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.DeactivateKeySigningKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeactivateKeySigningKey"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeactivateKeySigningKeyResponse> deactivateKeySigningKey(
            Consumer<DeactivateKeySigningKeyRequest.Builder> deactivateKeySigningKeyRequest) {
        return deactivateKeySigningKey(DeactivateKeySigningKeyRequest.builder().applyMutation(deactivateKeySigningKeyRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a CIDR collection in the current Amazon Web Services account. The collection must be empty before it can
     * be deleted.
     * </p>
     *
     * @param deleteCidrCollectionRequest
     * @return A Java Future containing the result of the DeleteCidrCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchCidrCollectionException The CIDR collection you specified, doesn't exist.</li>
     *         <li>CidrCollectionInUseException This CIDR collection is in use, and isn't empty.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.DeleteCidrCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteCidrCollection" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteCidrCollectionResponse> deleteCidrCollection(
            DeleteCidrCollectionRequest deleteCidrCollectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a CIDR collection in the current Amazon Web Services account. The collection must be empty before it can
     * be deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCidrCollectionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCidrCollectionRequest#builder()}
     * </p>
     *
     * @param deleteCidrCollectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.DeleteCidrCollectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteCidrCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchCidrCollectionException The CIDR collection you specified, doesn't exist.</li>
     *         <li>CidrCollectionInUseException This CIDR collection is in use, and isn't empty.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.DeleteCidrCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteCidrCollection" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteCidrCollectionResponse> deleteCidrCollection(
            Consumer<DeleteCidrCollectionRequest.Builder> deleteCidrCollectionRequest) {
        return deleteCidrCollection(DeleteCidrCollectionRequest.builder().applyMutation(deleteCidrCollectionRequest).build());
    }

    /**
     * <p>
     * Deletes a health check.
     * </p>
     * <important>
     * <p>
     * Amazon Route 53 does not prevent you from deleting a health check even if the health check is associated with one
     * or more resource record sets. If you delete a health check and you don't update the associated resource record
     * sets, the future status of the health check can't be predicted and may change. This will affect the routing of
     * DNS queries for your DNS failover configuration. For more information, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/health-checks-creating-deleting.html#health-checks-deleting.html"
     * >Replacing and Deleting Health Checks</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * </important>
     * <p>
     * If you're using Cloud Map and you configured Cloud Map to create a Route 53 health check when you register an
     * instance, you can't use the Route 53 <code>DeleteHealthCheck</code> command to delete the health check. The
     * health check is deleted automatically when you deregister the instance; there can be a delay of several hours
     * before the health check is deleted from Route 53.
     * </p>
     *
     * @param deleteHealthCheckRequest
     *        This action deletes a health check.
     * @return A Java Future containing the result of the DeleteHealthCheck operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHealthCheckException No health check exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.DeleteHealthCheck
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteHealthCheck" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteHealthCheckResponse> deleteHealthCheck(DeleteHealthCheckRequest deleteHealthCheckRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a health check.
     * </p>
     * <important>
     * <p>
     * Amazon Route 53 does not prevent you from deleting a health check even if the health check is associated with one
     * or more resource record sets. If you delete a health check and you don't update the associated resource record
     * sets, the future status of the health check can't be predicted and may change. This will affect the routing of
     * DNS queries for your DNS failover configuration. For more information, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/health-checks-creating-deleting.html#health-checks-deleting.html"
     * >Replacing and Deleting Health Checks</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * </important>
     * <p>
     * If you're using Cloud Map and you configured Cloud Map to create a Route 53 health check when you register an
     * instance, you can't use the Route 53 <code>DeleteHealthCheck</code> command to delete the health check. The
     * health check is deleted automatically when you deregister the instance; there can be a delay of several hours
     * before the health check is deleted from Route 53.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHealthCheckRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteHealthCheckRequest#builder()}
     * </p>
     *
     * @param deleteHealthCheckRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.DeleteHealthCheckRequest.Builder} to create a
     *        request. This action deletes a health check.
     * @return A Java Future containing the result of the DeleteHealthCheck operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHealthCheckException No health check exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.DeleteHealthCheck
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteHealthCheck" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteHealthCheckResponse> deleteHealthCheck(
            Consumer<DeleteHealthCheckRequest.Builder> deleteHealthCheckRequest) {
        return deleteHealthCheck(DeleteHealthCheckRequest.builder().applyMutation(deleteHealthCheckRequest).build());
    }

    /**
     * <p>
     * Deletes a hosted zone.
     * </p>
     * <p>
     * If the hosted zone was created by another service, such as Cloud Map, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DeleteHostedZone.html#delete-public-hosted-zone-created-by-another-service"
     * >Deleting Public Hosted Zones That Were Created by Another Service</a> in the <i>Amazon Route 53 Developer
     * Guide</i> for information about how to delete it. (The process is the same for public and private hosted zones
     * that were created by another service.)
     * </p>
     * <p>
     * If you want to keep your domain registration but you want to stop routing internet traffic to your website or web
     * application, we recommend that you delete resource record sets in the hosted zone instead of deleting the hosted
     * zone.
     * </p>
     * <important>
     * <p>
     * If you delete a hosted zone, you can't undelete it. You must create a new hosted zone and update the name servers
     * for your domain registration, which can require up to 48 hours to take effect. (If you delegated responsibility
     * for a subdomain to a hosted zone and you delete the child hosted zone, you must update the name servers in the
     * parent hosted zone.) In addition, if you delete a hosted zone, someone could hijack the domain and route traffic
     * to their own resources using your domain name.
     * </p>
     * </important>
     * <p>
     * If you want to avoid the monthly charge for the hosted zone, you can transfer DNS service for the domain to a
     * free DNS service. When you transfer DNS service, you have to update the name servers for the domain registration.
     * If the domain is registered with Route 53, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainNameservers.html"
     * >UpdateDomainNameservers</a> for information about how to replace Route 53 name servers with name servers for the
     * new DNS service. If the domain is registered with another registrar, use the method provided by the registrar to
     * update name servers for the domain registration. For more information, perform an internet search on
     * "free DNS service."
     * </p>
     * <p>
     * You can delete a hosted zone only if it contains only the default SOA record and NS resource record sets. If the
     * hosted zone contains other resource record sets, you must delete them before you can delete the hosted zone. If
     * you try to delete a hosted zone that contains other resource record sets, the request fails, and Route 53 returns
     * a <code>HostedZoneNotEmpty</code> error. For information about deleting records from your hosted zone, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ChangeResourceRecordSets.html">
     * ChangeResourceRecordSets</a>.
     * </p>
     * <p>
     * To verify that the hosted zone has been deleted, do one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>GetHostedZone</code> action to request information about the hosted zone.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>ListHostedZones</code> action to get a list of the hosted zones associated with the current Amazon
     * Web Services account.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteHostedZoneRequest
     *        A request to delete a hosted zone.
     * @return A Java Future containing the result of the DeleteHostedZone operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>HostedZoneNotEmptyException The hosted zone contains resource records that are not SOA or NS records.
     *         </li>
     *         <li>PriorRequestNotCompleteException If Amazon Route 53 can't process a request before the next request
     *         arrives, it will reject subsequent requests for the same hosted zone and return an
     *         <code>HTTP 400 error</code> (<code>Bad request</code>). If Route 53 returns this error repeatedly for the
     *         same request, we recommend that you wait, in intervals of increasing duration, before you try the request
     *         again.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>InvalidDomainNameException The specified domain name is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.DeleteHostedZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteHostedZone" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteHostedZoneResponse> deleteHostedZone(DeleteHostedZoneRequest deleteHostedZoneRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a hosted zone.
     * </p>
     * <p>
     * If the hosted zone was created by another service, such as Cloud Map, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DeleteHostedZone.html#delete-public-hosted-zone-created-by-another-service"
     * >Deleting Public Hosted Zones That Were Created by Another Service</a> in the <i>Amazon Route 53 Developer
     * Guide</i> for information about how to delete it. (The process is the same for public and private hosted zones
     * that were created by another service.)
     * </p>
     * <p>
     * If you want to keep your domain registration but you want to stop routing internet traffic to your website or web
     * application, we recommend that you delete resource record sets in the hosted zone instead of deleting the hosted
     * zone.
     * </p>
     * <important>
     * <p>
     * If you delete a hosted zone, you can't undelete it. You must create a new hosted zone and update the name servers
     * for your domain registration, which can require up to 48 hours to take effect. (If you delegated responsibility
     * for a subdomain to a hosted zone and you delete the child hosted zone, you must update the name servers in the
     * parent hosted zone.) In addition, if you delete a hosted zone, someone could hijack the domain and route traffic
     * to their own resources using your domain name.
     * </p>
     * </important>
     * <p>
     * If you want to avoid the monthly charge for the hosted zone, you can transfer DNS service for the domain to a
     * free DNS service. When you transfer DNS service, you have to update the name servers for the domain registration.
     * If the domain is registered with Route 53, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainNameservers.html"
     * >UpdateDomainNameservers</a> for information about how to replace Route 53 name servers with name servers for the
     * new DNS service. If the domain is registered with another registrar, use the method provided by the registrar to
     * update name servers for the domain registration. For more information, perform an internet search on
     * "free DNS service."
     * </p>
     * <p>
     * You can delete a hosted zone only if it contains only the default SOA record and NS resource record sets. If the
     * hosted zone contains other resource record sets, you must delete them before you can delete the hosted zone. If
     * you try to delete a hosted zone that contains other resource record sets, the request fails, and Route 53 returns
     * a <code>HostedZoneNotEmpty</code> error. For information about deleting records from your hosted zone, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ChangeResourceRecordSets.html">
     * ChangeResourceRecordSets</a>.
     * </p>
     * <p>
     * To verify that the hosted zone has been deleted, do one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>GetHostedZone</code> action to request information about the hosted zone.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>ListHostedZones</code> action to get a list of the hosted zones associated with the current Amazon
     * Web Services account.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHostedZoneRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteHostedZoneRequest#builder()}
     * </p>
     *
     * @param deleteHostedZoneRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.DeleteHostedZoneRequest.Builder} to create a request.
     *        A request to delete a hosted zone.
     * @return A Java Future containing the result of the DeleteHostedZone operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>HostedZoneNotEmptyException The hosted zone contains resource records that are not SOA or NS records.
     *         </li>
     *         <li>PriorRequestNotCompleteException If Amazon Route 53 can't process a request before the next request
     *         arrives, it will reject subsequent requests for the same hosted zone and return an
     *         <code>HTTP 400 error</code> (<code>Bad request</code>). If Route 53 returns this error repeatedly for the
     *         same request, we recommend that you wait, in intervals of increasing duration, before you try the request
     *         again.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>InvalidDomainNameException The specified domain name is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.DeleteHostedZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteHostedZone" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteHostedZoneResponse> deleteHostedZone(
            Consumer<DeleteHostedZoneRequest.Builder> deleteHostedZoneRequest) {
        return deleteHostedZone(DeleteHostedZoneRequest.builder().applyMutation(deleteHostedZoneRequest).build());
    }

    /**
     * <p>
     * Deletes a key-signing key (KSK). Before you can delete a KSK, you must deactivate it. The KSK must be deactivated
     * before you can delete it regardless of whether the hosted zone is enabled for DNSSEC signing.
     * </p>
     * <p>
     * You can use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeactivateKeySigningKey.html">
     * DeactivateKeySigningKey</a> to deactivate the key before you delete it.
     * </p>
     * <p>
     * Use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetDNSSEC.html">GetDNSSEC</a> to verify
     * that the KSK is in an <code>INACTIVE</code> status.
     * </p>
     *
     * @param deleteKeySigningKeyRequest
     * @return A Java Future containing the result of the DeleteKeySigningKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>NoSuchKeySigningKeyException The specified key-signing key (KSK) doesn't exist.</li>
     *         <li>InvalidKeySigningKeyStatusException The key-signing key (KSK) status isn't valid or another KSK has
     *         the status <code>INTERNAL_FAILURE</code>.</li>
     *         <li>InvalidSigningStatusException Your hosted zone status isn't valid for this operation. In the hosted
     *         zone, change the status to enable <code>DNSSEC</code> or disable <code>DNSSEC</code>.</li>
     *         <li>InvalidKmsArnException The KeyManagementServiceArn that you specified isn't valid to use with DNSSEC
     *         signing.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.DeleteKeySigningKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteKeySigningKey" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteKeySigningKeyResponse> deleteKeySigningKey(
            DeleteKeySigningKeyRequest deleteKeySigningKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a key-signing key (KSK). Before you can delete a KSK, you must deactivate it. The KSK must be deactivated
     * before you can delete it regardless of whether the hosted zone is enabled for DNSSEC signing.
     * </p>
     * <p>
     * You can use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeactivateKeySigningKey.html">
     * DeactivateKeySigningKey</a> to deactivate the key before you delete it.
     * </p>
     * <p>
     * Use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetDNSSEC.html">GetDNSSEC</a> to verify
     * that the KSK is in an <code>INACTIVE</code> status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteKeySigningKeyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteKeySigningKeyRequest#builder()}
     * </p>
     *
     * @param deleteKeySigningKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.DeleteKeySigningKeyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteKeySigningKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>NoSuchKeySigningKeyException The specified key-signing key (KSK) doesn't exist.</li>
     *         <li>InvalidKeySigningKeyStatusException The key-signing key (KSK) status isn't valid or another KSK has
     *         the status <code>INTERNAL_FAILURE</code>.</li>
     *         <li>InvalidSigningStatusException Your hosted zone status isn't valid for this operation. In the hosted
     *         zone, change the status to enable <code>DNSSEC</code> or disable <code>DNSSEC</code>.</li>
     *         <li>InvalidKmsArnException The KeyManagementServiceArn that you specified isn't valid to use with DNSSEC
     *         signing.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.DeleteKeySigningKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteKeySigningKey" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteKeySigningKeyResponse> deleteKeySigningKey(
            Consumer<DeleteKeySigningKeyRequest.Builder> deleteKeySigningKeyRequest) {
        return deleteKeySigningKey(DeleteKeySigningKeyRequest.builder().applyMutation(deleteKeySigningKeyRequest).build());
    }

    /**
     * <p>
     * Deletes a configuration for DNS query logging. If you delete a configuration, Amazon Route 53 stops sending query
     * logs to CloudWatch Logs. Route 53 doesn't delete any logs that are already in CloudWatch Logs.
     * </p>
     * <p>
     * For more information about DNS query logs, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateQueryLoggingConfig.html"
     * >CreateQueryLoggingConfig</a>.
     * </p>
     *
     * @param deleteQueryLoggingConfigRequest
     * @return A Java Future containing the result of the DeleteQueryLoggingConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>NoSuchQueryLoggingConfigException There is no DNS query logging configuration with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.DeleteQueryLoggingConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteQueryLoggingConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteQueryLoggingConfigResponse> deleteQueryLoggingConfig(
            DeleteQueryLoggingConfigRequest deleteQueryLoggingConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a configuration for DNS query logging. If you delete a configuration, Amazon Route 53 stops sending query
     * logs to CloudWatch Logs. Route 53 doesn't delete any logs that are already in CloudWatch Logs.
     * </p>
     * <p>
     * For more information about DNS query logs, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateQueryLoggingConfig.html"
     * >CreateQueryLoggingConfig</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteQueryLoggingConfigRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteQueryLoggingConfigRequest#builder()}
     * </p>
     *
     * @param deleteQueryLoggingConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.DeleteQueryLoggingConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteQueryLoggingConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>NoSuchQueryLoggingConfigException There is no DNS query logging configuration with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.DeleteQueryLoggingConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteQueryLoggingConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteQueryLoggingConfigResponse> deleteQueryLoggingConfig(
            Consumer<DeleteQueryLoggingConfigRequest.Builder> deleteQueryLoggingConfigRequest) {
        return deleteQueryLoggingConfig(DeleteQueryLoggingConfigRequest.builder().applyMutation(deleteQueryLoggingConfigRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a reusable delegation set.
     * </p>
     * <important>
     * <p>
     * You can delete a reusable delegation set only if it isn't associated with any hosted zones.
     * </p>
     * </important>
     * <p>
     * To verify that the reusable delegation set is not associated with any hosted zones, submit a <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetReusableDelegationSet.html"
     * >GetReusableDelegationSet</a> request and specify the ID of the reusable delegation set that you want to delete.
     * </p>
     *
     * @param deleteReusableDelegationSetRequest
     *        A request to delete a reusable delegation set.
     * @return A Java Future containing the result of the DeleteReusableDelegationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchDelegationSetException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>DelegationSetInUseException The specified delegation contains associated hosted zones which must be
     *         deleted before the reusable delegation set can be deleted.</li>
     *         <li>DelegationSetNotReusableException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.DeleteReusableDelegationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteReusableDelegationSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteReusableDelegationSetResponse> deleteReusableDelegationSet(
            DeleteReusableDelegationSetRequest deleteReusableDelegationSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a reusable delegation set.
     * </p>
     * <important>
     * <p>
     * You can delete a reusable delegation set only if it isn't associated with any hosted zones.
     * </p>
     * </important>
     * <p>
     * To verify that the reusable delegation set is not associated with any hosted zones, submit a <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetReusableDelegationSet.html"
     * >GetReusableDelegationSet</a> request and specify the ID of the reusable delegation set that you want to delete.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReusableDelegationSetRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteReusableDelegationSetRequest#builder()}
     * </p>
     *
     * @param deleteReusableDelegationSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.DeleteReusableDelegationSetRequest.Builder} to create
     *        a request. A request to delete a reusable delegation set.
     * @return A Java Future containing the result of the DeleteReusableDelegationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchDelegationSetException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>DelegationSetInUseException The specified delegation contains associated hosted zones which must be
     *         deleted before the reusable delegation set can be deleted.</li>
     *         <li>DelegationSetNotReusableException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.DeleteReusableDelegationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteReusableDelegationSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteReusableDelegationSetResponse> deleteReusableDelegationSet(
            Consumer<DeleteReusableDelegationSetRequest.Builder> deleteReusableDelegationSetRequest) {
        return deleteReusableDelegationSet(DeleteReusableDelegationSetRequest.builder()
                .applyMutation(deleteReusableDelegationSetRequest).build());
    }

    /**
     * <p>
     * Deletes a traffic policy.
     * </p>
     * <p>
     * When you delete a traffic policy, Route 53 sets a flag on the policy to indicate that it has been deleted.
     * However, Route 53 never fully deletes the traffic policy. Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Deleted traffic policies aren't listed if you run <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListTrafficPolicies.html"
     * >ListTrafficPolicies</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * There's no way to get a list of deleted policies.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you retain the ID of the policy, you can get information about the policy, including the traffic policy
     * document, by running <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetTrafficPolicy.html">GetTrafficPolicy</a>.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteTrafficPolicyRequest
     *        A request to delete a specified traffic policy version.
     * @return A Java Future containing the result of the DeleteTrafficPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchTrafficPolicyException No traffic policy exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>TrafficPolicyInUseException One or more traffic policy instances were created by using the specified
     *         traffic policy.</li>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.DeleteTrafficPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteTrafficPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteTrafficPolicyResponse> deleteTrafficPolicy(
            DeleteTrafficPolicyRequest deleteTrafficPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a traffic policy.
     * </p>
     * <p>
     * When you delete a traffic policy, Route 53 sets a flag on the policy to indicate that it has been deleted.
     * However, Route 53 never fully deletes the traffic policy. Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Deleted traffic policies aren't listed if you run <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListTrafficPolicies.html"
     * >ListTrafficPolicies</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * There's no way to get a list of deleted policies.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you retain the ID of the policy, you can get information about the policy, including the traffic policy
     * document, by running <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetTrafficPolicy.html">GetTrafficPolicy</a>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrafficPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteTrafficPolicyRequest#builder()}
     * </p>
     *
     * @param deleteTrafficPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyRequest.Builder} to create a
     *        request. A request to delete a specified traffic policy version.
     * @return A Java Future containing the result of the DeleteTrafficPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchTrafficPolicyException No traffic policy exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>TrafficPolicyInUseException One or more traffic policy instances were created by using the specified
     *         traffic policy.</li>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.DeleteTrafficPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteTrafficPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteTrafficPolicyResponse> deleteTrafficPolicy(
            Consumer<DeleteTrafficPolicyRequest.Builder> deleteTrafficPolicyRequest) {
        return deleteTrafficPolicy(DeleteTrafficPolicyRequest.builder().applyMutation(deleteTrafficPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes a traffic policy instance and all of the resource record sets that Amazon Route 53 created when you
     * created the instance.
     * </p>
     * <note>
     * <p>
     * In the Route 53 console, traffic policy instances are known as policy records.
     * </p>
     * </note>
     *
     * @param deleteTrafficPolicyInstanceRequest
     *        A request to delete a specified traffic policy instance.
     * @return A Java Future containing the result of the DeleteTrafficPolicyInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchTrafficPolicyInstanceException No traffic policy instance exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>PriorRequestNotCompleteException If Amazon Route 53 can't process a request before the next request
     *         arrives, it will reject subsequent requests for the same hosted zone and return an
     *         <code>HTTP 400 error</code> (<code>Bad request</code>). If Route 53 returns this error repeatedly for the
     *         same request, we recommend that you wait, in intervals of increasing duration, before you try the request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.DeleteTrafficPolicyInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteTrafficPolicyInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTrafficPolicyInstanceResponse> deleteTrafficPolicyInstance(
            DeleteTrafficPolicyInstanceRequest deleteTrafficPolicyInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a traffic policy instance and all of the resource record sets that Amazon Route 53 created when you
     * created the instance.
     * </p>
     * <note>
     * <p>
     * In the Route 53 console, traffic policy instances are known as policy records.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrafficPolicyInstanceRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteTrafficPolicyInstanceRequest#builder()}
     * </p>
     *
     * @param deleteTrafficPolicyInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyInstanceRequest.Builder} to create
     *        a request. A request to delete a specified traffic policy instance.
     * @return A Java Future containing the result of the DeleteTrafficPolicyInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchTrafficPolicyInstanceException No traffic policy instance exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>PriorRequestNotCompleteException If Amazon Route 53 can't process a request before the next request
     *         arrives, it will reject subsequent requests for the same hosted zone and return an
     *         <code>HTTP 400 error</code> (<code>Bad request</code>). If Route 53 returns this error repeatedly for the
     *         same request, we recommend that you wait, in intervals of increasing duration, before you try the request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.DeleteTrafficPolicyInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteTrafficPolicyInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTrafficPolicyInstanceResponse> deleteTrafficPolicyInstance(
            Consumer<DeleteTrafficPolicyInstanceRequest.Builder> deleteTrafficPolicyInstanceRequest) {
        return deleteTrafficPolicyInstance(DeleteTrafficPolicyInstanceRequest.builder()
                .applyMutation(deleteTrafficPolicyInstanceRequest).build());
    }

    /**
     * <p>
     * Removes authorization to submit an <code>AssociateVPCWithHostedZone</code> request to associate a specified VPC
     * with a hosted zone that was created by a different account. You must use the account that created the hosted zone
     * to submit a <code>DeleteVPCAssociationAuthorization</code> request.
     * </p>
     * <important>
     * <p>
     * Sending this request only prevents the Amazon Web Services account that created the VPC from associating the VPC
     * with the Amazon Route 53 hosted zone in the future. If the VPC is already associated with the hosted zone,
     * <code>DeleteVPCAssociationAuthorization</code> won't disassociate the VPC from the hosted zone. If you want to
     * delete an existing association, use <code>DisassociateVPCFromHostedZone</code>.
     * </p>
     * </important>
     *
     * @param deleteVpcAssociationAuthorizationRequest
     *        A complex type that contains information about the request to remove authorization to associate a VPC that
     *        was created by one Amazon Web Services account with a hosted zone that was created with a different Amazon
     *        Web Services account.
     * @return A Java Future containing the result of the DeleteVPCAssociationAuthorization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>VpcAssociationAuthorizationNotFoundException The VPC that you specified is not authorized to be
     *         associated with the hosted zone.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidVpcIdException The VPC ID that you specified either isn't a valid ID or the current account is
     *         not authorized to access this VPC.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.DeleteVPCAssociationAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteVPCAssociationAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVpcAssociationAuthorizationResponse> deleteVPCAssociationAuthorization(
            DeleteVpcAssociationAuthorizationRequest deleteVpcAssociationAuthorizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes authorization to submit an <code>AssociateVPCWithHostedZone</code> request to associate a specified VPC
     * with a hosted zone that was created by a different account. You must use the account that created the hosted zone
     * to submit a <code>DeleteVPCAssociationAuthorization</code> request.
     * </p>
     * <important>
     * <p>
     * Sending this request only prevents the Amazon Web Services account that created the VPC from associating the VPC
     * with the Amazon Route 53 hosted zone in the future. If the VPC is already associated with the hosted zone,
     * <code>DeleteVPCAssociationAuthorization</code> won't disassociate the VPC from the hosted zone. If you want to
     * delete an existing association, use <code>DisassociateVPCFromHostedZone</code>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVpcAssociationAuthorizationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteVpcAssociationAuthorizationRequest#builder()}
     * </p>
     *
     * @param deleteVpcAssociationAuthorizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.DeleteVpcAssociationAuthorizationRequest.Builder} to
     *        create a request. A complex type that contains information about the request to remove authorization to
     *        associate a VPC that was created by one Amazon Web Services account with a hosted zone that was created
     *        with a different Amazon Web Services account.
     * @return A Java Future containing the result of the DeleteVPCAssociationAuthorization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>VpcAssociationAuthorizationNotFoundException The VPC that you specified is not authorized to be
     *         associated with the hosted zone.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidVpcIdException The VPC ID that you specified either isn't a valid ID or the current account is
     *         not authorized to access this VPC.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.DeleteVPCAssociationAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteVPCAssociationAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVpcAssociationAuthorizationResponse> deleteVPCAssociationAuthorization(
            Consumer<DeleteVpcAssociationAuthorizationRequest.Builder> deleteVpcAssociationAuthorizationRequest) {
        return deleteVPCAssociationAuthorization(DeleteVpcAssociationAuthorizationRequest.builder()
                .applyMutation(deleteVpcAssociationAuthorizationRequest).build());
    }

    /**
     * <p>
     * Disables DNSSEC signing in a specific hosted zone. This action does not deactivate any key-signing keys (KSKs)
     * that are active in the hosted zone.
     * </p>
     *
     * @param disableHostedZoneDnssecRequest
     * @return A Java Future containing the result of the DisableHostedZoneDNSSEC operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidArgumentException Parameter name is not valid.</li>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>KeySigningKeyInParentDsRecordException The key-signing key (KSK) is specified in a parent DS record.</li>
     *         <li>DnssecNotFoundException The hosted zone doesn't have any DNSSEC resources.</li>
     *         <li>InvalidKeySigningKeyStatusException The key-signing key (KSK) status isn't valid or another KSK has
     *         the status <code>INTERNAL_FAILURE</code>.</li>
     *         <li>InvalidKmsArnException The KeyManagementServiceArn that you specified isn't valid to use with DNSSEC
     *         signing.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.DisableHostedZoneDNSSEC
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DisableHostedZoneDNSSEC"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableHostedZoneDnssecResponse> disableHostedZoneDNSSEC(
            DisableHostedZoneDnssecRequest disableHostedZoneDnssecRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables DNSSEC signing in a specific hosted zone. This action does not deactivate any key-signing keys (KSKs)
     * that are active in the hosted zone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableHostedZoneDnssecRequest.Builder} avoiding
     * the need to create one manually via {@link DisableHostedZoneDnssecRequest#builder()}
     * </p>
     *
     * @param disableHostedZoneDnssecRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.DisableHostedZoneDnssecRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisableHostedZoneDNSSEC operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidArgumentException Parameter name is not valid.</li>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>KeySigningKeyInParentDsRecordException The key-signing key (KSK) is specified in a parent DS record.</li>
     *         <li>DnssecNotFoundException The hosted zone doesn't have any DNSSEC resources.</li>
     *         <li>InvalidKeySigningKeyStatusException The key-signing key (KSK) status isn't valid or another KSK has
     *         the status <code>INTERNAL_FAILURE</code>.</li>
     *         <li>InvalidKmsArnException The KeyManagementServiceArn that you specified isn't valid to use with DNSSEC
     *         signing.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.DisableHostedZoneDNSSEC
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DisableHostedZoneDNSSEC"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableHostedZoneDnssecResponse> disableHostedZoneDNSSEC(
            Consumer<DisableHostedZoneDnssecRequest.Builder> disableHostedZoneDnssecRequest) {
        return disableHostedZoneDNSSEC(DisableHostedZoneDnssecRequest.builder().applyMutation(disableHostedZoneDnssecRequest)
                .build());
    }

    /**
     * <p>
     * Disassociates an Amazon Virtual Private Cloud (Amazon VPC) from an Amazon Route 53 private hosted zone. Note the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can't disassociate the last Amazon VPC from a private hosted zone.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't convert a private hosted zone into a public hosted zone.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can submit a <code>DisassociateVPCFromHostedZone</code> request using either the account that created the
     * hosted zone or the account that created the Amazon VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * Some services, such as Cloud Map and Amazon Elastic File System (Amazon EFS) automatically create hosted zones
     * and associate VPCs with the hosted zones. A service can create a hosted zone using your account or using its own
     * account. You can disassociate a VPC from a hosted zone only if the service created the hosted zone using your
     * account.
     * </p>
     * <p>
     * When you run <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListHostedZonesByVPC.html">
     * DisassociateVPCFromHostedZone</a>, if the hosted zone has a value for <code>OwningAccount</code>, you can use
     * <code>DisassociateVPCFromHostedZone</code>. If the hosted zone has a value for <code>OwningService</code>, you
     * can't use <code>DisassociateVPCFromHostedZone</code>.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * When revoking access, the hosted zone and the Amazon VPC must belong to the same partition. A partition is a
     * group of Amazon Web Services Regions. Each Amazon Web Services account is scoped to one partition.
     * </p>
     * <p>
     * The following are the supported partitions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>aws</code> - Amazon Web Services Regions
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aws-cn</code> - China Regions
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aws-us-gov</code> - Amazon Web Services GovCloud (US) Region
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Access Management</a> in the
     * <i>Amazon Web Services General Reference</i>.
     * </p>
     * </note>
     *
     * @param disassociateVpcFromHostedZoneRequest
     *        A complex type that contains information about the VPC that you want to disassociate from a specified
     *        private hosted zone.
     * @return A Java Future containing the result of the DisassociateVPCFromHostedZone operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidVpcIdException The VPC ID that you specified either isn't a valid ID or the current account is
     *         not authorized to access this VPC.</li>
     *         <li>VpcAssociationNotFoundException The specified VPC and hosted zone are not currently associated.</li>
     *         <li>LastVpcAssociationException The VPC that you're trying to disassociate from the private hosted zone
     *         is the last VPC that is associated with the hosted zone. Amazon Route 53 doesn't support disassociating
     *         the last VPC from a hosted zone.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.DisassociateVPCFromHostedZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DisassociateVPCFromHostedZone"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateVpcFromHostedZoneResponse> disassociateVPCFromHostedZone(
            DisassociateVpcFromHostedZoneRequest disassociateVpcFromHostedZoneRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates an Amazon Virtual Private Cloud (Amazon VPC) from an Amazon Route 53 private hosted zone. Note the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can't disassociate the last Amazon VPC from a private hosted zone.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't convert a private hosted zone into a public hosted zone.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can submit a <code>DisassociateVPCFromHostedZone</code> request using either the account that created the
     * hosted zone or the account that created the Amazon VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * Some services, such as Cloud Map and Amazon Elastic File System (Amazon EFS) automatically create hosted zones
     * and associate VPCs with the hosted zones. A service can create a hosted zone using your account or using its own
     * account. You can disassociate a VPC from a hosted zone only if the service created the hosted zone using your
     * account.
     * </p>
     * <p>
     * When you run <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListHostedZonesByVPC.html">
     * DisassociateVPCFromHostedZone</a>, if the hosted zone has a value for <code>OwningAccount</code>, you can use
     * <code>DisassociateVPCFromHostedZone</code>. If the hosted zone has a value for <code>OwningService</code>, you
     * can't use <code>DisassociateVPCFromHostedZone</code>.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * When revoking access, the hosted zone and the Amazon VPC must belong to the same partition. A partition is a
     * group of Amazon Web Services Regions. Each Amazon Web Services account is scoped to one partition.
     * </p>
     * <p>
     * The following are the supported partitions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>aws</code> - Amazon Web Services Regions
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aws-cn</code> - China Regions
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aws-us-gov</code> - Amazon Web Services GovCloud (US) Region
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Access Management</a> in the
     * <i>Amazon Web Services General Reference</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateVpcFromHostedZoneRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateVpcFromHostedZoneRequest#builder()}
     * </p>
     *
     * @param disassociateVpcFromHostedZoneRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.DisassociateVpcFromHostedZoneRequest.Builder} to
     *        create a request. A complex type that contains information about the VPC that you want to disassociate
     *        from a specified private hosted zone.
     * @return A Java Future containing the result of the DisassociateVPCFromHostedZone operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidVpcIdException The VPC ID that you specified either isn't a valid ID or the current account is
     *         not authorized to access this VPC.</li>
     *         <li>VpcAssociationNotFoundException The specified VPC and hosted zone are not currently associated.</li>
     *         <li>LastVpcAssociationException The VPC that you're trying to disassociate from the private hosted zone
     *         is the last VPC that is associated with the hosted zone. Amazon Route 53 doesn't support disassociating
     *         the last VPC from a hosted zone.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.DisassociateVPCFromHostedZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DisassociateVPCFromHostedZone"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateVpcFromHostedZoneResponse> disassociateVPCFromHostedZone(
            Consumer<DisassociateVpcFromHostedZoneRequest.Builder> disassociateVpcFromHostedZoneRequest) {
        return disassociateVPCFromHostedZone(DisassociateVpcFromHostedZoneRequest.builder()
                .applyMutation(disassociateVpcFromHostedZoneRequest).build());
    }

    /**
     * <p>
     * Enables DNSSEC signing in a specific hosted zone.
     * </p>
     *
     * @param enableHostedZoneDnssecRequest
     * @return A Java Future containing the result of the EnableHostedZoneDNSSEC operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidArgumentException Parameter name is not valid.</li>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>KeySigningKeyWithActiveStatusNotFoundException A key-signing key (KSK) with <code>ACTIVE</code>
     *         status wasn't found.</li>
     *         <li>InvalidKmsArnException The KeyManagementServiceArn that you specified isn't valid to use with DNSSEC
     *         signing.</li>
     *         <li>HostedZonePartiallyDelegatedException The hosted zone nameservers don't match the parent nameservers.
     *         The hosted zone and parent must have the same nameservers.</li>
     *         <li>DnssecNotFoundException The hosted zone doesn't have any DNSSEC resources.</li>
     *         <li>InvalidKeySigningKeyStatusException The key-signing key (KSK) status isn't valid or another KSK has
     *         the status <code>INTERNAL_FAILURE</code>.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.EnableHostedZoneDNSSEC
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/EnableHostedZoneDNSSEC"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableHostedZoneDnssecResponse> enableHostedZoneDNSSEC(
            EnableHostedZoneDnssecRequest enableHostedZoneDnssecRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables DNSSEC signing in a specific hosted zone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableHostedZoneDnssecRequest.Builder} avoiding the
     * need to create one manually via {@link EnableHostedZoneDnssecRequest#builder()}
     * </p>
     *
     * @param enableHostedZoneDnssecRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.EnableHostedZoneDnssecRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the EnableHostedZoneDNSSEC operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidArgumentException Parameter name is not valid.</li>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>KeySigningKeyWithActiveStatusNotFoundException A key-signing key (KSK) with <code>ACTIVE</code>
     *         status wasn't found.</li>
     *         <li>InvalidKmsArnException The KeyManagementServiceArn that you specified isn't valid to use with DNSSEC
     *         signing.</li>
     *         <li>HostedZonePartiallyDelegatedException The hosted zone nameservers don't match the parent nameservers.
     *         The hosted zone and parent must have the same nameservers.</li>
     *         <li>DnssecNotFoundException The hosted zone doesn't have any DNSSEC resources.</li>
     *         <li>InvalidKeySigningKeyStatusException The key-signing key (KSK) status isn't valid or another KSK has
     *         the status <code>INTERNAL_FAILURE</code>.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.EnableHostedZoneDNSSEC
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/EnableHostedZoneDNSSEC"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableHostedZoneDnssecResponse> enableHostedZoneDNSSEC(
            Consumer<EnableHostedZoneDnssecRequest.Builder> enableHostedZoneDnssecRequest) {
        return enableHostedZoneDNSSEC(EnableHostedZoneDnssecRequest.builder().applyMutation(enableHostedZoneDnssecRequest)
                .build());
    }

    /**
     * <p>
     * Gets the specified limit for the current account, for example, the maximum number of health checks that you can
     * create using the account.
     * </p>
     * <p>
     * For the default limit, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the <i>Amazon
     * Route 53 Developer Guide</i>. To request a higher limit, <a href=
     * "https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&amp;limitType=service-code-route53"
     * >open a case</a>.
     * </p>
     * <note>
     * <p>
     * You can also view account limits in Amazon Web Services Trusted Advisor. Sign in to the Amazon Web Services
     * Management Console and open the Trusted Advisor console at <a
     * href="https://console.aws.amazon.com/trustedadvisor">https://console.aws.amazon.com/trustedadvisor/</a>. Then
     * choose <b>Service limits</b> in the navigation pane.
     * </p>
     * </note>
     *
     * @param getAccountLimitRequest
     *        A complex type that contains information about the request to create a hosted zone.
     * @return A Java Future containing the result of the GetAccountLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetAccountLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetAccountLimit" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAccountLimitResponse> getAccountLimit(GetAccountLimitRequest getAccountLimitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the specified limit for the current account, for example, the maximum number of health checks that you can
     * create using the account.
     * </p>
     * <p>
     * For the default limit, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the <i>Amazon
     * Route 53 Developer Guide</i>. To request a higher limit, <a href=
     * "https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&amp;limitType=service-code-route53"
     * >open a case</a>.
     * </p>
     * <note>
     * <p>
     * You can also view account limits in Amazon Web Services Trusted Advisor. Sign in to the Amazon Web Services
     * Management Console and open the Trusted Advisor console at <a
     * href="https://console.aws.amazon.com/trustedadvisor">https://console.aws.amazon.com/trustedadvisor/</a>. Then
     * choose <b>Service limits</b> in the navigation pane.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountLimitRequest.Builder} avoiding the need
     * to create one manually via {@link GetAccountLimitRequest#builder()}
     * </p>
     *
     * @param getAccountLimitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.GetAccountLimitRequest.Builder} to create a request.
     *        A complex type that contains information about the request to create a hosted zone.
     * @return A Java Future containing the result of the GetAccountLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetAccountLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetAccountLimit" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAccountLimitResponse> getAccountLimit(
            Consumer<GetAccountLimitRequest.Builder> getAccountLimitRequest) {
        return getAccountLimit(GetAccountLimitRequest.builder().applyMutation(getAccountLimitRequest).build());
    }

    /**
     * <p>
     * Returns the current status of a change batch request. The status is one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> indicates that the changes in this request have not propagated to all Amazon Route 53 DNS
     * servers managing the hosted zone. This is the initial status of all change batch requests.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSYNC</code> indicates that the changes have propagated to all Route 53 DNS servers managing the hosted
     * zone.
     * </p>
     * </li>
     * </ul>
     *
     * @param getChangeRequest
     *        The input for a GetChange request.
     * @return A Java Future containing the result of the GetChange operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchChangeException A change with the specified change ID does not exist.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetChange
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetChange" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetChangeResponse> getChange(GetChangeRequest getChangeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current status of a change batch request. The status is one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> indicates that the changes in this request have not propagated to all Amazon Route 53 DNS
     * servers managing the hosted zone. This is the initial status of all change batch requests.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSYNC</code> indicates that the changes have propagated to all Route 53 DNS servers managing the hosted
     * zone.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetChangeRequest.Builder} avoiding the need to
     * create one manually via {@link GetChangeRequest#builder()}
     * </p>
     *
     * @param getChangeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.GetChangeRequest.Builder} to create a request. The
     *        input for a GetChange request.
     * @return A Java Future containing the result of the GetChange operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchChangeException A change with the specified change ID does not exist.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetChange
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetChange" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetChangeResponse> getChange(Consumer<GetChangeRequest.Builder> getChangeRequest) {
        return getChange(GetChangeRequest.builder().applyMutation(getChangeRequest).build());
    }

    /**
     * <p>
     * Route 53 does not perform authorization for this API because it retrieves information that is already available
     * to the public.
     * </p>
     * <important>
     * <p>
     * <code>GetCheckerIpRanges</code> still works, but we recommend that you download ip-ranges.json, which includes IP
     * address ranges for all Amazon Web Services services. For more information, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/route-53-ip-addresses.html">IP Address Ranges of
     * Amazon Route 53 Servers</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * </important>
     *
     * @param getCheckerIpRangesRequest
     *        Empty request.
     * @return A Java Future containing the result of the GetCheckerIpRanges operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetCheckerIpRanges
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetCheckerIpRanges" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCheckerIpRangesResponse> getCheckerIpRanges(GetCheckerIpRangesRequest getCheckerIpRangesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Route 53 does not perform authorization for this API because it retrieves information that is already available
     * to the public.
     * </p>
     * <important>
     * <p>
     * <code>GetCheckerIpRanges</code> still works, but we recommend that you download ip-ranges.json, which includes IP
     * address ranges for all Amazon Web Services services. For more information, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/route-53-ip-addresses.html">IP Address Ranges of
     * Amazon Route 53 Servers</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCheckerIpRangesRequest.Builder} avoiding the
     * need to create one manually via {@link GetCheckerIpRangesRequest#builder()}
     * </p>
     *
     * @param getCheckerIpRangesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.GetCheckerIpRangesRequest.Builder} to create a
     *        request. Empty request.
     * @return A Java Future containing the result of the GetCheckerIpRanges operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetCheckerIpRanges
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetCheckerIpRanges" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCheckerIpRangesResponse> getCheckerIpRanges(
            Consumer<GetCheckerIpRangesRequest.Builder> getCheckerIpRangesRequest) {
        return getCheckerIpRanges(GetCheckerIpRangesRequest.builder().applyMutation(getCheckerIpRangesRequest).build());
    }

    /**
     * <p>
     * Route 53 does not perform authorization for this API because it retrieves information that is already available
     * to the public.
     * </p>
     * <important>
     * <p>
     * <code>GetCheckerIpRanges</code> still works, but we recommend that you download ip-ranges.json, which includes IP
     * address ranges for all Amazon Web Services services. For more information, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/route-53-ip-addresses.html">IP Address Ranges of
     * Amazon Route 53 Servers</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * </important>
     *
     * @return A Java Future containing the result of the GetCheckerIpRanges operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetCheckerIpRanges
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetCheckerIpRanges" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCheckerIpRangesResponse> getCheckerIpRanges() {
        return getCheckerIpRanges(GetCheckerIpRangesRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about DNSSEC for a specific hosted zone, including the key-signing keys (KSKs) in the hosted
     * zone.
     * </p>
     *
     * @param getDnssecRequest
     * @return A Java Future containing the result of the GetDNSSEC operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidArgumentException Parameter name is not valid.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetDNSSEC
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetDNSSEC" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDnssecResponse> getDNSSEC(GetDnssecRequest getDnssecRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about DNSSEC for a specific hosted zone, including the key-signing keys (KSKs) in the hosted
     * zone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDnssecRequest.Builder} avoiding the need to
     * create one manually via {@link GetDnssecRequest#builder()}
     * </p>
     *
     * @param getDnssecRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.GetDnssecRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDNSSEC operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidArgumentException Parameter name is not valid.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetDNSSEC
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetDNSSEC" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDnssecResponse> getDNSSEC(Consumer<GetDnssecRequest.Builder> getDnssecRequest) {
        return getDNSSEC(GetDnssecRequest.builder().applyMutation(getDnssecRequest).build());
    }

    /**
     * <p>
     * Gets information about whether a specified geographic location is supported for Amazon Route 53 geolocation
     * resource record sets.
     * </p>
     * <p>
     * Route 53 does not perform authorization for this API because it retrieves information that is already available
     * to the public.
     * </p>
     * <p>
     * Use the following syntax to determine whether a continent is supported for geolocation:
     * </p>
     * <p>
     * <code>GET /2013-04-01/geolocation?continentcode=<i>two-letter abbreviation for a continent</i> </code>
     * </p>
     * <p>
     * Use the following syntax to determine whether a country is supported for geolocation:
     * </p>
     * <p>
     * <code>GET /2013-04-01/geolocation?countrycode=<i>two-character country code</i> </code>
     * </p>
     * <p>
     * Use the following syntax to determine whether a subdivision of a country is supported for geolocation:
     * </p>
     * <p>
     * <code>GET /2013-04-01/geolocation?countrycode=<i>two-character country code</i>&amp;subdivisioncode=<i>subdivision code</i> </code>
     * </p>
     *
     * @param getGeoLocationRequest
     *        A request for information about whether a specified geographic location is supported for Amazon Route 53
     *        geolocation resource record sets.
     * @return A Java Future containing the result of the GetGeoLocation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchGeoLocationException Amazon Route 53 doesn't support the specified geographic location. For a
     *         list of supported geolocation codes, see the <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GeoLocation.html">GeoLocation</a> data
     *         type.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetGeoLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetGeoLocation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGeoLocationResponse> getGeoLocation(GetGeoLocationRequest getGeoLocationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about whether a specified geographic location is supported for Amazon Route 53 geolocation
     * resource record sets.
     * </p>
     * <p>
     * Route 53 does not perform authorization for this API because it retrieves information that is already available
     * to the public.
     * </p>
     * <p>
     * Use the following syntax to determine whether a continent is supported for geolocation:
     * </p>
     * <p>
     * <code>GET /2013-04-01/geolocation?continentcode=<i>two-letter abbreviation for a continent</i> </code>
     * </p>
     * <p>
     * Use the following syntax to determine whether a country is supported for geolocation:
     * </p>
     * <p>
     * <code>GET /2013-04-01/geolocation?countrycode=<i>two-character country code</i> </code>
     * </p>
     * <p>
     * Use the following syntax to determine whether a subdivision of a country is supported for geolocation:
     * </p>
     * <p>
     * <code>GET /2013-04-01/geolocation?countrycode=<i>two-character country code</i>&amp;subdivisioncode=<i>subdivision code</i> </code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGeoLocationRequest.Builder} avoiding the need to
     * create one manually via {@link GetGeoLocationRequest#builder()}
     * </p>
     *
     * @param getGeoLocationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.GetGeoLocationRequest.Builder} to create a request. A
     *        request for information about whether a specified geographic location is supported for Amazon Route 53
     *        geolocation resource record sets.
     * @return A Java Future containing the result of the GetGeoLocation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchGeoLocationException Amazon Route 53 doesn't support the specified geographic location. For a
     *         list of supported geolocation codes, see the <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GeoLocation.html">GeoLocation</a> data
     *         type.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetGeoLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetGeoLocation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGeoLocationResponse> getGeoLocation(Consumer<GetGeoLocationRequest.Builder> getGeoLocationRequest) {
        return getGeoLocation(GetGeoLocationRequest.builder().applyMutation(getGeoLocationRequest).build());
    }

    /**
     * <p>
     * Gets information about whether a specified geographic location is supported for Amazon Route 53 geolocation
     * resource record sets.
     * </p>
     * <p>
     * Route 53 does not perform authorization for this API because it retrieves information that is already available
     * to the public.
     * </p>
     * <p>
     * Use the following syntax to determine whether a continent is supported for geolocation:
     * </p>
     * <p>
     * <code>GET /2013-04-01/geolocation?continentcode=<i>two-letter abbreviation for a continent</i> </code>
     * </p>
     * <p>
     * Use the following syntax to determine whether a country is supported for geolocation:
     * </p>
     * <p>
     * <code>GET /2013-04-01/geolocation?countrycode=<i>two-character country code</i> </code>
     * </p>
     * <p>
     * Use the following syntax to determine whether a subdivision of a country is supported for geolocation:
     * </p>
     * <p>
     * <code>GET /2013-04-01/geolocation?countrycode=<i>two-character country code</i>&amp;subdivisioncode=<i>subdivision code</i> </code>
     * </p>
     *
     * @return A Java Future containing the result of the GetGeoLocation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchGeoLocationException Amazon Route 53 doesn't support the specified geographic location. For a
     *         list of supported geolocation codes, see the <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GeoLocation.html">GeoLocation</a> data
     *         type.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetGeoLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetGeoLocation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGeoLocationResponse> getGeoLocation() {
        return getGeoLocation(GetGeoLocationRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about a specified health check.
     * </p>
     *
     * @param getHealthCheckRequest
     *        A request to get information about a specified health check.
     * @return A Java Future containing the result of the GetHealthCheck operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHealthCheckException No health check exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>IncompatibleVersionException The resource you're trying to access is unsupported on this Amazon Route
     *         53 endpoint.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetHealthCheck
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHealthCheck" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetHealthCheckResponse> getHealthCheck(GetHealthCheckRequest getHealthCheckRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specified health check.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetHealthCheckRequest.Builder} avoiding the need to
     * create one manually via {@link GetHealthCheckRequest#builder()}
     * </p>
     *
     * @param getHealthCheckRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.GetHealthCheckRequest.Builder} to create a request. A
     *        request to get information about a specified health check.
     * @return A Java Future containing the result of the GetHealthCheck operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHealthCheckException No health check exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>IncompatibleVersionException The resource you're trying to access is unsupported on this Amazon Route
     *         53 endpoint.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetHealthCheck
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHealthCheck" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetHealthCheckResponse> getHealthCheck(Consumer<GetHealthCheckRequest.Builder> getHealthCheckRequest) {
        return getHealthCheck(GetHealthCheckRequest.builder().applyMutation(getHealthCheckRequest).build());
    }

    /**
     * <p>
     * Retrieves the number of health checks that are associated with the current Amazon Web Services account.
     * </p>
     *
     * @param getHealthCheckCountRequest
     *        A request for the number of health checks that are associated with the current Amazon Web Services
     *        account.
     * @return A Java Future containing the result of the GetHealthCheckCount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetHealthCheckCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHealthCheckCount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetHealthCheckCountResponse> getHealthCheckCount(
            GetHealthCheckCountRequest getHealthCheckCountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the number of health checks that are associated with the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetHealthCheckCountRequest.Builder} avoiding the
     * need to create one manually via {@link GetHealthCheckCountRequest#builder()}
     * </p>
     *
     * @param getHealthCheckCountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.GetHealthCheckCountRequest.Builder} to create a
     *        request. A request for the number of health checks that are associated with the current Amazon Web
     *        Services account.
     * @return A Java Future containing the result of the GetHealthCheckCount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetHealthCheckCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHealthCheckCount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetHealthCheckCountResponse> getHealthCheckCount(
            Consumer<GetHealthCheckCountRequest.Builder> getHealthCheckCountRequest) {
        return getHealthCheckCount(GetHealthCheckCountRequest.builder().applyMutation(getHealthCheckCountRequest).build());
    }

    /**
     * <p>
     * Retrieves the number of health checks that are associated with the current Amazon Web Services account.
     * </p>
     *
     * @return A Java Future containing the result of the GetHealthCheckCount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetHealthCheckCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHealthCheckCount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetHealthCheckCountResponse> getHealthCheckCount() {
        return getHealthCheckCount(GetHealthCheckCountRequest.builder().build());
    }

    /**
     * <p>
     * Gets the reason that a specified health check failed most recently.
     * </p>
     *
     * @param getHealthCheckLastFailureReasonRequest
     *        A request for the reason that a health check failed most recently.
     * @return A Java Future containing the result of the GetHealthCheckLastFailureReason operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHealthCheckException No health check exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetHealthCheckLastFailureReason
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHealthCheckLastFailureReason"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetHealthCheckLastFailureReasonResponse> getHealthCheckLastFailureReason(
            GetHealthCheckLastFailureReasonRequest getHealthCheckLastFailureReasonRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the reason that a specified health check failed most recently.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetHealthCheckLastFailureReasonRequest.Builder}
     * avoiding the need to create one manually via {@link GetHealthCheckLastFailureReasonRequest#builder()}
     * </p>
     *
     * @param getHealthCheckLastFailureReasonRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.GetHealthCheckLastFailureReasonRequest.Builder} to
     *        create a request. A request for the reason that a health check failed most recently.
     * @return A Java Future containing the result of the GetHealthCheckLastFailureReason operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHealthCheckException No health check exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetHealthCheckLastFailureReason
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHealthCheckLastFailureReason"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetHealthCheckLastFailureReasonResponse> getHealthCheckLastFailureReason(
            Consumer<GetHealthCheckLastFailureReasonRequest.Builder> getHealthCheckLastFailureReasonRequest) {
        return getHealthCheckLastFailureReason(GetHealthCheckLastFailureReasonRequest.builder()
                .applyMutation(getHealthCheckLastFailureReasonRequest).build());
    }

    /**
     * <p>
     * Gets status of a specified health check.
     * </p>
     * <important>
     * <p>
     * This API is intended for use during development to diagnose behavior. It doesn’t support production use-cases
     * with high query rates that require immediate and actionable responses.
     * </p>
     * </important>
     *
     * @param getHealthCheckStatusRequest
     *        A request to get the status for a health check.
     * @return A Java Future containing the result of the GetHealthCheckStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHealthCheckException No health check exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetHealthCheckStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHealthCheckStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetHealthCheckStatusResponse> getHealthCheckStatus(
            GetHealthCheckStatusRequest getHealthCheckStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets status of a specified health check.
     * </p>
     * <important>
     * <p>
     * This API is intended for use during development to diagnose behavior. It doesn’t support production use-cases
     * with high query rates that require immediate and actionable responses.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetHealthCheckStatusRequest.Builder} avoiding the
     * need to create one manually via {@link GetHealthCheckStatusRequest#builder()}
     * </p>
     *
     * @param getHealthCheckStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.GetHealthCheckStatusRequest.Builder} to create a
     *        request. A request to get the status for a health check.
     * @return A Java Future containing the result of the GetHealthCheckStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHealthCheckException No health check exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetHealthCheckStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHealthCheckStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetHealthCheckStatusResponse> getHealthCheckStatus(
            Consumer<GetHealthCheckStatusRequest.Builder> getHealthCheckStatusRequest) {
        return getHealthCheckStatus(GetHealthCheckStatusRequest.builder().applyMutation(getHealthCheckStatusRequest).build());
    }

    /**
     * <p>
     * Gets information about a specified hosted zone including the four name servers assigned to the hosted zone.
     * </p>
     *
     * @param getHostedZoneRequest
     *        A request to get information about a specified hosted zone.
     * @return A Java Future containing the result of the GetHostedZone operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetHostedZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHostedZone" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetHostedZoneResponse> getHostedZone(GetHostedZoneRequest getHostedZoneRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specified hosted zone including the four name servers assigned to the hosted zone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetHostedZoneRequest.Builder} avoiding the need to
     * create one manually via {@link GetHostedZoneRequest#builder()}
     * </p>
     *
     * @param getHostedZoneRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.GetHostedZoneRequest.Builder} to create a request. A
     *        request to get information about a specified hosted zone.
     * @return A Java Future containing the result of the GetHostedZone operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetHostedZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHostedZone" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetHostedZoneResponse> getHostedZone(Consumer<GetHostedZoneRequest.Builder> getHostedZoneRequest) {
        return getHostedZone(GetHostedZoneRequest.builder().applyMutation(getHostedZoneRequest).build());
    }

    /**
     * <p>
     * Retrieves the number of hosted zones that are associated with the current Amazon Web Services account.
     * </p>
     *
     * @param getHostedZoneCountRequest
     *        A request to retrieve a count of all the hosted zones that are associated with the current Amazon Web
     *        Services account.
     * @return A Java Future containing the result of the GetHostedZoneCount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetHostedZoneCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHostedZoneCount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetHostedZoneCountResponse> getHostedZoneCount(GetHostedZoneCountRequest getHostedZoneCountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the number of hosted zones that are associated with the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetHostedZoneCountRequest.Builder} avoiding the
     * need to create one manually via {@link GetHostedZoneCountRequest#builder()}
     * </p>
     *
     * @param getHostedZoneCountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.GetHostedZoneCountRequest.Builder} to create a
     *        request. A request to retrieve a count of all the hosted zones that are associated with the current Amazon
     *        Web Services account.
     * @return A Java Future containing the result of the GetHostedZoneCount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetHostedZoneCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHostedZoneCount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetHostedZoneCountResponse> getHostedZoneCount(
            Consumer<GetHostedZoneCountRequest.Builder> getHostedZoneCountRequest) {
        return getHostedZoneCount(GetHostedZoneCountRequest.builder().applyMutation(getHostedZoneCountRequest).build());
    }

    /**
     * <p>
     * Retrieves the number of hosted zones that are associated with the current Amazon Web Services account.
     * </p>
     *
     * @return A Java Future containing the result of the GetHostedZoneCount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetHostedZoneCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHostedZoneCount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetHostedZoneCountResponse> getHostedZoneCount() {
        return getHostedZoneCount(GetHostedZoneCountRequest.builder().build());
    }

    /**
     * <p>
     * Gets the specified limit for a specified hosted zone, for example, the maximum number of records that you can
     * create in the hosted zone.
     * </p>
     * <p>
     * For the default limit, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the <i>Amazon
     * Route 53 Developer Guide</i>. To request a higher limit, <a href=
     * "https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&amp;limitType=service-code-route53"
     * >open a case</a>.
     * </p>
     *
     * @param getHostedZoneLimitRequest
     *        A complex type that contains information about the request to create a hosted zone.
     * @return A Java Future containing the result of the GetHostedZoneLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>HostedZoneNotPrivateException The specified hosted zone is a public hosted zone, not a private hosted
     *         zone.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetHostedZoneLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHostedZoneLimit" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetHostedZoneLimitResponse> getHostedZoneLimit(GetHostedZoneLimitRequest getHostedZoneLimitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the specified limit for a specified hosted zone, for example, the maximum number of records that you can
     * create in the hosted zone.
     * </p>
     * <p>
     * For the default limit, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the <i>Amazon
     * Route 53 Developer Guide</i>. To request a higher limit, <a href=
     * "https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&amp;limitType=service-code-route53"
     * >open a case</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetHostedZoneLimitRequest.Builder} avoiding the
     * need to create one manually via {@link GetHostedZoneLimitRequest#builder()}
     * </p>
     *
     * @param getHostedZoneLimitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.GetHostedZoneLimitRequest.Builder} to create a
     *        request. A complex type that contains information about the request to create a hosted zone.
     * @return A Java Future containing the result of the GetHostedZoneLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>HostedZoneNotPrivateException The specified hosted zone is a public hosted zone, not a private hosted
     *         zone.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetHostedZoneLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHostedZoneLimit" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetHostedZoneLimitResponse> getHostedZoneLimit(
            Consumer<GetHostedZoneLimitRequest.Builder> getHostedZoneLimitRequest) {
        return getHostedZoneLimit(GetHostedZoneLimitRequest.builder().applyMutation(getHostedZoneLimitRequest).build());
    }

    /**
     * <p>
     * Gets information about a specified configuration for DNS query logging.
     * </p>
     * <p>
     * For more information about DNS query logs, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateQueryLoggingConfig.html"
     * >CreateQueryLoggingConfig</a> and <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html">Logging DNS Queries</a>.
     * </p>
     *
     * @param getQueryLoggingConfigRequest
     * @return A Java Future containing the result of the GetQueryLoggingConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchQueryLoggingConfigException There is no DNS query logging configuration with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetQueryLoggingConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetQueryLoggingConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetQueryLoggingConfigResponse> getQueryLoggingConfig(
            GetQueryLoggingConfigRequest getQueryLoggingConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specified configuration for DNS query logging.
     * </p>
     * <p>
     * For more information about DNS query logs, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateQueryLoggingConfig.html"
     * >CreateQueryLoggingConfig</a> and <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html">Logging DNS Queries</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQueryLoggingConfigRequest.Builder} avoiding the
     * need to create one manually via {@link GetQueryLoggingConfigRequest#builder()}
     * </p>
     *
     * @param getQueryLoggingConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.GetQueryLoggingConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetQueryLoggingConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchQueryLoggingConfigException There is no DNS query logging configuration with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetQueryLoggingConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetQueryLoggingConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetQueryLoggingConfigResponse> getQueryLoggingConfig(
            Consumer<GetQueryLoggingConfigRequest.Builder> getQueryLoggingConfigRequest) {
        return getQueryLoggingConfig(GetQueryLoggingConfigRequest.builder().applyMutation(getQueryLoggingConfigRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a specified reusable delegation set, including the four name servers that are
     * assigned to the delegation set.
     * </p>
     *
     * @param getReusableDelegationSetRequest
     *        A request to get information about a specified reusable delegation set.
     * @return A Java Future containing the result of the GetReusableDelegationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchDelegationSetException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>DelegationSetNotReusableException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetReusableDelegationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetReusableDelegationSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetReusableDelegationSetResponse> getReusableDelegationSet(
            GetReusableDelegationSetRequest getReusableDelegationSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a specified reusable delegation set, including the four name servers that are
     * assigned to the delegation set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReusableDelegationSetRequest.Builder} avoiding
     * the need to create one manually via {@link GetReusableDelegationSetRequest#builder()}
     * </p>
     *
     * @param getReusableDelegationSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.GetReusableDelegationSetRequest.Builder} to create a
     *        request. A request to get information about a specified reusable delegation set.
     * @return A Java Future containing the result of the GetReusableDelegationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchDelegationSetException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>DelegationSetNotReusableException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetReusableDelegationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetReusableDelegationSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetReusableDelegationSetResponse> getReusableDelegationSet(
            Consumer<GetReusableDelegationSetRequest.Builder> getReusableDelegationSetRequest) {
        return getReusableDelegationSet(GetReusableDelegationSetRequest.builder().applyMutation(getReusableDelegationSetRequest)
                .build());
    }

    /**
     * <p>
     * Gets the maximum number of hosted zones that you can associate with the specified reusable delegation set.
     * </p>
     * <p>
     * For the default limit, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the <i>Amazon
     * Route 53 Developer Guide</i>. To request a higher limit, <a href=
     * "https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&amp;limitType=service-code-route53"
     * >open a case</a>.
     * </p>
     *
     * @param getReusableDelegationSetLimitRequest
     *        A complex type that contains information about the request to create a hosted zone.
     * @return A Java Future containing the result of the GetReusableDelegationSetLimit operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchDelegationSetException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetReusableDelegationSetLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetReusableDelegationSetLimit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetReusableDelegationSetLimitResponse> getReusableDelegationSetLimit(
            GetReusableDelegationSetLimitRequest getReusableDelegationSetLimitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the maximum number of hosted zones that you can associate with the specified reusable delegation set.
     * </p>
     * <p>
     * For the default limit, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the <i>Amazon
     * Route 53 Developer Guide</i>. To request a higher limit, <a href=
     * "https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&amp;limitType=service-code-route53"
     * >open a case</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReusableDelegationSetLimitRequest.Builder}
     * avoiding the need to create one manually via {@link GetReusableDelegationSetLimitRequest#builder()}
     * </p>
     *
     * @param getReusableDelegationSetLimitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.GetReusableDelegationSetLimitRequest.Builder} to
     *        create a request. A complex type that contains information about the request to create a hosted zone.
     * @return A Java Future containing the result of the GetReusableDelegationSetLimit operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchDelegationSetException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetReusableDelegationSetLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetReusableDelegationSetLimit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetReusableDelegationSetLimitResponse> getReusableDelegationSetLimit(
            Consumer<GetReusableDelegationSetLimitRequest.Builder> getReusableDelegationSetLimitRequest) {
        return getReusableDelegationSetLimit(GetReusableDelegationSetLimitRequest.builder()
                .applyMutation(getReusableDelegationSetLimitRequest).build());
    }

    /**
     * <p>
     * Gets information about a specific traffic policy version.
     * </p>
     * <p>
     * For information about how of deleting a traffic policy affects the response from <code>GetTrafficPolicy</code>,
     * see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicy.html">DeleteTrafficPolicy
     * </a>.
     * </p>
     *
     * @param getTrafficPolicyRequest
     *        Gets information about a specific traffic policy version.
     * @return A Java Future containing the result of the GetTrafficPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchTrafficPolicyException No traffic policy exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetTrafficPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetTrafficPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTrafficPolicyResponse> getTrafficPolicy(GetTrafficPolicyRequest getTrafficPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specific traffic policy version.
     * </p>
     * <p>
     * For information about how of deleting a traffic policy affects the response from <code>GetTrafficPolicy</code>,
     * see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicy.html">DeleteTrafficPolicy
     * </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTrafficPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetTrafficPolicyRequest#builder()}
     * </p>
     *
     * @param getTrafficPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.GetTrafficPolicyRequest.Builder} to create a request.
     *        Gets information about a specific traffic policy version.
     * @return A Java Future containing the result of the GetTrafficPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchTrafficPolicyException No traffic policy exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetTrafficPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetTrafficPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTrafficPolicyResponse> getTrafficPolicy(
            Consumer<GetTrafficPolicyRequest.Builder> getTrafficPolicyRequest) {
        return getTrafficPolicy(GetTrafficPolicyRequest.builder().applyMutation(getTrafficPolicyRequest).build());
    }

    /**
     * <p>
     * Gets information about a specified traffic policy instance.
     * </p>
     * <note>
     * <p>
     * Use <code>GetTrafficPolicyInstance</code> with the <code>id</code> of new traffic policy instance to confirm that
     * the <code>CreateTrafficPolicyInstance</code> or an <code>UpdateTrafficPolicyInstance</code> request completed
     * successfully. For more information, see the <code>State</code> response element.
     * </p>
     * </note> <note>
     * <p>
     * In the Route 53 console, traffic policy instances are known as policy records.
     * </p>
     * </note>
     *
     * @param getTrafficPolicyInstanceRequest
     *        Gets information about a specified traffic policy instance.
     * @return A Java Future containing the result of the GetTrafficPolicyInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchTrafficPolicyInstanceException No traffic policy instance exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetTrafficPolicyInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetTrafficPolicyInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTrafficPolicyInstanceResponse> getTrafficPolicyInstance(
            GetTrafficPolicyInstanceRequest getTrafficPolicyInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specified traffic policy instance.
     * </p>
     * <note>
     * <p>
     * Use <code>GetTrafficPolicyInstance</code> with the <code>id</code> of new traffic policy instance to confirm that
     * the <code>CreateTrafficPolicyInstance</code> or an <code>UpdateTrafficPolicyInstance</code> request completed
     * successfully. For more information, see the <code>State</code> response element.
     * </p>
     * </note> <note>
     * <p>
     * In the Route 53 console, traffic policy instances are known as policy records.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTrafficPolicyInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link GetTrafficPolicyInstanceRequest#builder()}
     * </p>
     *
     * @param getTrafficPolicyInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceRequest.Builder} to create a
     *        request. Gets information about a specified traffic policy instance.
     * @return A Java Future containing the result of the GetTrafficPolicyInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchTrafficPolicyInstanceException No traffic policy instance exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetTrafficPolicyInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetTrafficPolicyInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTrafficPolicyInstanceResponse> getTrafficPolicyInstance(
            Consumer<GetTrafficPolicyInstanceRequest.Builder> getTrafficPolicyInstanceRequest) {
        return getTrafficPolicyInstance(GetTrafficPolicyInstanceRequest.builder().applyMutation(getTrafficPolicyInstanceRequest)
                .build());
    }

    /**
     * <p>
     * Gets the number of traffic policy instances that are associated with the current Amazon Web Services account.
     * </p>
     *
     * @param getTrafficPolicyInstanceCountRequest
     *        Request to get the number of traffic policy instances that are associated with the current Amazon Web
     *        Services account.
     * @return A Java Future containing the result of the GetTrafficPolicyInstanceCount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetTrafficPolicyInstanceCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetTrafficPolicyInstanceCount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTrafficPolicyInstanceCountResponse> getTrafficPolicyInstanceCount(
            GetTrafficPolicyInstanceCountRequest getTrafficPolicyInstanceCountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the number of traffic policy instances that are associated with the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTrafficPolicyInstanceCountRequest.Builder}
     * avoiding the need to create one manually via {@link GetTrafficPolicyInstanceCountRequest#builder()}
     * </p>
     *
     * @param getTrafficPolicyInstanceCountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceCountRequest.Builder} to
     *        create a request. Request to get the number of traffic policy instances that are associated with the
     *        current Amazon Web Services account.
     * @return A Java Future containing the result of the GetTrafficPolicyInstanceCount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetTrafficPolicyInstanceCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetTrafficPolicyInstanceCount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTrafficPolicyInstanceCountResponse> getTrafficPolicyInstanceCount(
            Consumer<GetTrafficPolicyInstanceCountRequest.Builder> getTrafficPolicyInstanceCountRequest) {
        return getTrafficPolicyInstanceCount(GetTrafficPolicyInstanceCountRequest.builder()
                .applyMutation(getTrafficPolicyInstanceCountRequest).build());
    }

    /**
     * <p>
     * Gets the number of traffic policy instances that are associated with the current Amazon Web Services account.
     * </p>
     *
     * @return A Java Future containing the result of the GetTrafficPolicyInstanceCount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetTrafficPolicyInstanceCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetTrafficPolicyInstanceCount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTrafficPolicyInstanceCountResponse> getTrafficPolicyInstanceCount() {
        return getTrafficPolicyInstanceCount(GetTrafficPolicyInstanceCountRequest.builder().build());
    }

    /**
     * <p>
     * Returns a paginated list of location objects and their CIDR blocks.
     * </p>
     *
     * @param listCidrBlocksRequest
     * @return A Java Future containing the result of the ListCidrBlocks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchCidrCollectionException The CIDR collection you specified, doesn't exist.</li>
     *         <li>NoSuchCidrLocationException The CIDR collection location doesn't match any locations in your account.
     *         </li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListCidrBlocks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListCidrBlocks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCidrBlocksResponse> listCidrBlocks(ListCidrBlocksRequest listCidrBlocksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of location objects and their CIDR blocks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCidrBlocksRequest.Builder} avoiding the need to
     * create one manually via {@link ListCidrBlocksRequest#builder()}
     * </p>
     *
     * @param listCidrBlocksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.ListCidrBlocksRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListCidrBlocks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchCidrCollectionException The CIDR collection you specified, doesn't exist.</li>
     *         <li>NoSuchCidrLocationException The CIDR collection location doesn't match any locations in your account.
     *         </li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListCidrBlocks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListCidrBlocks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCidrBlocksResponse> listCidrBlocks(Consumer<ListCidrBlocksRequest.Builder> listCidrBlocksRequest) {
        return listCidrBlocks(ListCidrBlocksRequest.builder().applyMutation(listCidrBlocksRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of location objects and their CIDR blocks.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listCidrBlocks(software.amazon.awssdk.services.route53.model.ListCidrBlocksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListCidrBlocksPublisher publisher = client.listCidrBlocksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListCidrBlocksPublisher publisher = client.listCidrBlocksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53.model.ListCidrBlocksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53.model.ListCidrBlocksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCidrBlocks(software.amazon.awssdk.services.route53.model.ListCidrBlocksRequest)} operation.</b>
     * </p>
     *
     * @param listCidrBlocksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchCidrCollectionException The CIDR collection you specified, doesn't exist.</li>
     *         <li>NoSuchCidrLocationException The CIDR collection location doesn't match any locations in your account.
     *         </li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListCidrBlocks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListCidrBlocks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCidrBlocksPublisher listCidrBlocksPaginator(ListCidrBlocksRequest listCidrBlocksRequest) {
        return new ListCidrBlocksPublisher(this, listCidrBlocksRequest);
    }

    /**
     * <p>
     * Returns a paginated list of location objects and their CIDR blocks.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listCidrBlocks(software.amazon.awssdk.services.route53.model.ListCidrBlocksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListCidrBlocksPublisher publisher = client.listCidrBlocksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListCidrBlocksPublisher publisher = client.listCidrBlocksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53.model.ListCidrBlocksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53.model.ListCidrBlocksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCidrBlocks(software.amazon.awssdk.services.route53.model.ListCidrBlocksRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCidrBlocksRequest.Builder} avoiding the need to
     * create one manually via {@link ListCidrBlocksRequest#builder()}
     * </p>
     *
     * @param listCidrBlocksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.ListCidrBlocksRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchCidrCollectionException The CIDR collection you specified, doesn't exist.</li>
     *         <li>NoSuchCidrLocationException The CIDR collection location doesn't match any locations in your account.
     *         </li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListCidrBlocks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListCidrBlocks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCidrBlocksPublisher listCidrBlocksPaginator(Consumer<ListCidrBlocksRequest.Builder> listCidrBlocksRequest) {
        return listCidrBlocksPaginator(ListCidrBlocksRequest.builder().applyMutation(listCidrBlocksRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of CIDR collections in the Amazon Web Services account (metadata only).
     * </p>
     *
     * @param listCidrCollectionsRequest
     * @return A Java Future containing the result of the ListCidrCollections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListCidrCollections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListCidrCollections" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListCidrCollectionsResponse> listCidrCollections(
            ListCidrCollectionsRequest listCidrCollectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of CIDR collections in the Amazon Web Services account (metadata only).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCidrCollectionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCidrCollectionsRequest#builder()}
     * </p>
     *
     * @param listCidrCollectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.ListCidrCollectionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListCidrCollections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListCidrCollections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListCidrCollections" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListCidrCollectionsResponse> listCidrCollections(
            Consumer<ListCidrCollectionsRequest.Builder> listCidrCollectionsRequest) {
        return listCidrCollections(ListCidrCollectionsRequest.builder().applyMutation(listCidrCollectionsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of CIDR collections in the Amazon Web Services account (metadata only).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCidrCollections(software.amazon.awssdk.services.route53.model.ListCidrCollectionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListCidrCollectionsPublisher publisher = client.listCidrCollectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListCidrCollectionsPublisher publisher = client.listCidrCollectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53.model.ListCidrCollectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53.model.ListCidrCollectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCidrCollections(software.amazon.awssdk.services.route53.model.ListCidrCollectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCidrCollectionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListCidrCollections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListCidrCollections" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCidrCollectionsPublisher listCidrCollectionsPaginator(ListCidrCollectionsRequest listCidrCollectionsRequest) {
        return new ListCidrCollectionsPublisher(this, listCidrCollectionsRequest);
    }

    /**
     * <p>
     * Returns a paginated list of CIDR collections in the Amazon Web Services account (metadata only).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCidrCollections(software.amazon.awssdk.services.route53.model.ListCidrCollectionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListCidrCollectionsPublisher publisher = client.listCidrCollectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListCidrCollectionsPublisher publisher = client.listCidrCollectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53.model.ListCidrCollectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53.model.ListCidrCollectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCidrCollections(software.amazon.awssdk.services.route53.model.ListCidrCollectionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCidrCollectionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCidrCollectionsRequest#builder()}
     * </p>
     *
     * @param listCidrCollectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.ListCidrCollectionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListCidrCollections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListCidrCollections" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCidrCollectionsPublisher listCidrCollectionsPaginator(
            Consumer<ListCidrCollectionsRequest.Builder> listCidrCollectionsRequest) {
        return listCidrCollectionsPaginator(ListCidrCollectionsRequest.builder().applyMutation(listCidrCollectionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a paginated list of CIDR locations for the given collection (metadata only, does not include CIDR
     * blocks).
     * </p>
     *
     * @param listCidrLocationsRequest
     * @return A Java Future containing the result of the ListCidrLocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchCidrCollectionException The CIDR collection you specified, doesn't exist.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListCidrLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListCidrLocations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCidrLocationsResponse> listCidrLocations(ListCidrLocationsRequest listCidrLocationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of CIDR locations for the given collection (metadata only, does not include CIDR
     * blocks).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCidrLocationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListCidrLocationsRequest#builder()}
     * </p>
     *
     * @param listCidrLocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.ListCidrLocationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListCidrLocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchCidrCollectionException The CIDR collection you specified, doesn't exist.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListCidrLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListCidrLocations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCidrLocationsResponse> listCidrLocations(
            Consumer<ListCidrLocationsRequest.Builder> listCidrLocationsRequest) {
        return listCidrLocations(ListCidrLocationsRequest.builder().applyMutation(listCidrLocationsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of CIDR locations for the given collection (metadata only, does not include CIDR
     * blocks).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCidrLocations(software.amazon.awssdk.services.route53.model.ListCidrLocationsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListCidrLocationsPublisher publisher = client.listCidrLocationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListCidrLocationsPublisher publisher = client.listCidrLocationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53.model.ListCidrLocationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53.model.ListCidrLocationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCidrLocations(software.amazon.awssdk.services.route53.model.ListCidrLocationsRequest)} operation.</b>
     * </p>
     *
     * @param listCidrLocationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchCidrCollectionException The CIDR collection you specified, doesn't exist.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListCidrLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListCidrLocations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCidrLocationsPublisher listCidrLocationsPaginator(ListCidrLocationsRequest listCidrLocationsRequest) {
        return new ListCidrLocationsPublisher(this, listCidrLocationsRequest);
    }

    /**
     * <p>
     * Returns a paginated list of CIDR locations for the given collection (metadata only, does not include CIDR
     * blocks).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCidrLocations(software.amazon.awssdk.services.route53.model.ListCidrLocationsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListCidrLocationsPublisher publisher = client.listCidrLocationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListCidrLocationsPublisher publisher = client.listCidrLocationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53.model.ListCidrLocationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53.model.ListCidrLocationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCidrLocations(software.amazon.awssdk.services.route53.model.ListCidrLocationsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCidrLocationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListCidrLocationsRequest#builder()}
     * </p>
     *
     * @param listCidrLocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.ListCidrLocationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchCidrCollectionException The CIDR collection you specified, doesn't exist.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListCidrLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListCidrLocations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCidrLocationsPublisher listCidrLocationsPaginator(
            Consumer<ListCidrLocationsRequest.Builder> listCidrLocationsRequest) {
        return listCidrLocationsPaginator(ListCidrLocationsRequest.builder().applyMutation(listCidrLocationsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of supported geographic locations.
     * </p>
     * <p>
     * Countries are listed first, and continents are listed last. If Amazon Route 53 supports subdivisions for a
     * country (for example, states or provinces), the subdivisions for that country are listed in alphabetical order
     * immediately after the corresponding country.
     * </p>
     * <p>
     * Route 53 does not perform authorization for this API because it retrieves information that is already available
     * to the public.
     * </p>
     * <p>
     * For a list of supported geolocation codes, see the <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GeoLocation.html">GeoLocation</a> data type.
     * </p>
     *
     * @param listGeoLocationsRequest
     *        A request to get a list of geographic locations that Amazon Route 53 supports for geolocation resource
     *        record sets.
     * @return A Java Future containing the result of the ListGeoLocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListGeoLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListGeoLocations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGeoLocationsResponse> listGeoLocations(ListGeoLocationsRequest listGeoLocationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of supported geographic locations.
     * </p>
     * <p>
     * Countries are listed first, and continents are listed last. If Amazon Route 53 supports subdivisions for a
     * country (for example, states or provinces), the subdivisions for that country are listed in alphabetical order
     * immediately after the corresponding country.
     * </p>
     * <p>
     * Route 53 does not perform authorization for this API because it retrieves information that is already available
     * to the public.
     * </p>
     * <p>
     * For a list of supported geolocation codes, see the <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GeoLocation.html">GeoLocation</a> data type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGeoLocationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListGeoLocationsRequest#builder()}
     * </p>
     *
     * @param listGeoLocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.ListGeoLocationsRequest.Builder} to create a request.
     *        A request to get a list of geographic locations that Amazon Route 53 supports for geolocation resource
     *        record sets.
     * @return A Java Future containing the result of the ListGeoLocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListGeoLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListGeoLocations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGeoLocationsResponse> listGeoLocations(
            Consumer<ListGeoLocationsRequest.Builder> listGeoLocationsRequest) {
        return listGeoLocations(ListGeoLocationsRequest.builder().applyMutation(listGeoLocationsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of supported geographic locations.
     * </p>
     * <p>
     * Countries are listed first, and continents are listed last. If Amazon Route 53 supports subdivisions for a
     * country (for example, states or provinces), the subdivisions for that country are listed in alphabetical order
     * immediately after the corresponding country.
     * </p>
     * <p>
     * Route 53 does not perform authorization for this API because it retrieves information that is already available
     * to the public.
     * </p>
     * <p>
     * For a list of supported geolocation codes, see the <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GeoLocation.html">GeoLocation</a> data type.
     * </p>
     *
     * @return A Java Future containing the result of the ListGeoLocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListGeoLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListGeoLocations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGeoLocationsResponse> listGeoLocations() {
        return listGeoLocations(ListGeoLocationsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieve a list of the health checks that are associated with the current Amazon Web Services account.
     * </p>
     *
     * @param listHealthChecksRequest
     *        A request to retrieve a list of the health checks that are associated with the current Amazon Web Services
     *        account.
     * @return A Java Future containing the result of the ListHealthChecks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>IncompatibleVersionException The resource you're trying to access is unsupported on this Amazon Route
     *         53 endpoint.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListHealthChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHealthChecks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListHealthChecksResponse> listHealthChecks(ListHealthChecksRequest listHealthChecksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve a list of the health checks that are associated with the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHealthChecksRequest.Builder} avoiding the need
     * to create one manually via {@link ListHealthChecksRequest#builder()}
     * </p>
     *
     * @param listHealthChecksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.ListHealthChecksRequest.Builder} to create a request.
     *        A request to retrieve a list of the health checks that are associated with the current Amazon Web Services
     *        account.
     * @return A Java Future containing the result of the ListHealthChecks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>IncompatibleVersionException The resource you're trying to access is unsupported on this Amazon Route
     *         53 endpoint.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListHealthChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHealthChecks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListHealthChecksResponse> listHealthChecks(
            Consumer<ListHealthChecksRequest.Builder> listHealthChecksRequest) {
        return listHealthChecks(ListHealthChecksRequest.builder().applyMutation(listHealthChecksRequest).build());
    }

    /**
     * <p>
     * Retrieve a list of the health checks that are associated with the current Amazon Web Services account.
     * </p>
     *
     * @return A Java Future containing the result of the ListHealthChecks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>IncompatibleVersionException The resource you're trying to access is unsupported on this Amazon Route
     *         53 endpoint.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListHealthChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHealthChecks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListHealthChecksResponse> listHealthChecks() {
        return listHealthChecks(ListHealthChecksRequest.builder().build());
    }

    /**
     * <p>
     * Retrieve a list of the health checks that are associated with the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listHealthChecks(software.amazon.awssdk.services.route53.model.ListHealthChecksRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListHealthChecksPublisher publisher = client.listHealthChecksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListHealthChecksPublisher publisher = client.listHealthChecksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53.model.ListHealthChecksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53.model.ListHealthChecksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHealthChecks(software.amazon.awssdk.services.route53.model.ListHealthChecksRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>IncompatibleVersionException The resource you're trying to access is unsupported on this Amazon Route
     *         53 endpoint.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListHealthChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHealthChecks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListHealthChecksPublisher listHealthChecksPaginator() {
        return listHealthChecksPaginator(ListHealthChecksRequest.builder().build());
    }

    /**
     * <p>
     * Retrieve a list of the health checks that are associated with the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listHealthChecks(software.amazon.awssdk.services.route53.model.ListHealthChecksRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListHealthChecksPublisher publisher = client.listHealthChecksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListHealthChecksPublisher publisher = client.listHealthChecksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53.model.ListHealthChecksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53.model.ListHealthChecksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHealthChecks(software.amazon.awssdk.services.route53.model.ListHealthChecksRequest)} operation.</b>
     * </p>
     *
     * @param listHealthChecksRequest
     *        A request to retrieve a list of the health checks that are associated with the current Amazon Web Services
     *        account.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>IncompatibleVersionException The resource you're trying to access is unsupported on this Amazon Route
     *         53 endpoint.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListHealthChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHealthChecks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListHealthChecksPublisher listHealthChecksPaginator(ListHealthChecksRequest listHealthChecksRequest) {
        return new ListHealthChecksPublisher(this, listHealthChecksRequest);
    }

    /**
     * <p>
     * Retrieve a list of the health checks that are associated with the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listHealthChecks(software.amazon.awssdk.services.route53.model.ListHealthChecksRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListHealthChecksPublisher publisher = client.listHealthChecksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListHealthChecksPublisher publisher = client.listHealthChecksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53.model.ListHealthChecksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53.model.ListHealthChecksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHealthChecks(software.amazon.awssdk.services.route53.model.ListHealthChecksRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHealthChecksRequest.Builder} avoiding the need
     * to create one manually via {@link ListHealthChecksRequest#builder()}
     * </p>
     *
     * @param listHealthChecksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.ListHealthChecksRequest.Builder} to create a request.
     *        A request to retrieve a list of the health checks that are associated with the current Amazon Web Services
     *        account.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>IncompatibleVersionException The resource you're trying to access is unsupported on this Amazon Route
     *         53 endpoint.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListHealthChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHealthChecks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListHealthChecksPublisher listHealthChecksPaginator(Consumer<ListHealthChecksRequest.Builder> listHealthChecksRequest) {
        return listHealthChecksPaginator(ListHealthChecksRequest.builder().applyMutation(listHealthChecksRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of the public and private hosted zones that are associated with the current Amazon Web Services
     * account. The response includes a <code>HostedZones</code> child element for each hosted zone.
     * </p>
     * <p>
     * Amazon Route 53 returns a maximum of 100 items in each response. If you have a lot of hosted zones, you can use
     * the <code>maxitems</code> parameter to list them in groups of up to 100.
     * </p>
     *
     * @param listHostedZonesRequest
     *        A request to retrieve a list of the public and private hosted zones that are associated with the current
     *        Amazon Web Services account.
     * @return A Java Future containing the result of the ListHostedZones operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchDelegationSetException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>DelegationSetNotReusableException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListHostedZones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHostedZones" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListHostedZonesResponse> listHostedZones(ListHostedZonesRequest listHostedZonesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of the public and private hosted zones that are associated with the current Amazon Web Services
     * account. The response includes a <code>HostedZones</code> child element for each hosted zone.
     * </p>
     * <p>
     * Amazon Route 53 returns a maximum of 100 items in each response. If you have a lot of hosted zones, you can use
     * the <code>maxitems</code> parameter to list them in groups of up to 100.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHostedZonesRequest.Builder} avoiding the need
     * to create one manually via {@link ListHostedZonesRequest#builder()}
     * </p>
     *
     * @param listHostedZonesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.ListHostedZonesRequest.Builder} to create a request.
     *        A request to retrieve a list of the public and private hosted zones that are associated with the current
     *        Amazon Web Services account.
     * @return A Java Future containing the result of the ListHostedZones operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchDelegationSetException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>DelegationSetNotReusableException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListHostedZones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHostedZones" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListHostedZonesResponse> listHostedZones(
            Consumer<ListHostedZonesRequest.Builder> listHostedZonesRequest) {
        return listHostedZones(ListHostedZonesRequest.builder().applyMutation(listHostedZonesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of the public and private hosted zones that are associated with the current Amazon Web Services
     * account. The response includes a <code>HostedZones</code> child element for each hosted zone.
     * </p>
     * <p>
     * Amazon Route 53 returns a maximum of 100 items in each response. If you have a lot of hosted zones, you can use
     * the <code>maxitems</code> parameter to list them in groups of up to 100.
     * </p>
     *
     * @return A Java Future containing the result of the ListHostedZones operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchDelegationSetException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>DelegationSetNotReusableException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListHostedZones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHostedZones" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListHostedZonesResponse> listHostedZones() {
        return listHostedZones(ListHostedZonesRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves a list of your hosted zones in lexicographic order. The response includes a <code>HostedZones</code>
     * child element for each hosted zone created by the current Amazon Web Services account.
     * </p>
     * <p>
     * <code>ListHostedZonesByName</code> sorts hosted zones by name with the labels reversed. For example:
     * </p>
     * <p>
     * <code>com.example.www.</code>
     * </p>
     * <p>
     * Note the trailing dot, which can change the sort order in some circumstances.
     * </p>
     * <p>
     * If the domain name includes escape characters or Punycode, <code>ListHostedZonesByName</code> alphabetizes the
     * domain name using the escaped or Punycoded value, which is the format that Amazon Route 53 saves in its database.
     * For example, to create a hosted zone for exämple.com, you specify ex\344mple.com for the domain name.
     * <code>ListHostedZonesByName</code> alphabetizes it as:
     * </p>
     * <p>
     * <code>com.ex\344mple.</code>
     * </p>
     * <p>
     * The labels are reversed and alphabetized using the escaped value. For more information about valid domain name
     * formats, including internationalized domain names, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html">DNS Domain Name Format</a>
     * in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * Route 53 returns up to 100 items in each response. If you have a lot of hosted zones, use the
     * <code>MaxItems</code> parameter to list them in groups of up to 100. The response includes values that help
     * navigate from one group of <code>MaxItems</code> hosted zones to the next:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>DNSName</code> and <code>HostedZoneId</code> elements in the response contain the values, if any,
     * specified for the <code>dnsname</code> and <code>hostedzoneid</code> parameters in the request that produced the
     * current response.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>MaxItems</code> element in the response contains the value, if any, that you specified for the
     * <code>maxitems</code> parameter in the request that produced the current response.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the value of <code>IsTruncated</code> in the response is true, there are more hosted zones associated with the
     * current Amazon Web Services account.
     * </p>
     * <p>
     * If <code>IsTruncated</code> is false, this response includes the last hosted zone that is associated with the
     * current account. The <code>NextDNSName</code> element and <code>NextHostedZoneId</code> elements are omitted from
     * the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>NextDNSName</code> and <code>NextHostedZoneId</code> elements in the response contain the domain name
     * and the hosted zone ID of the next hosted zone that is associated with the current Amazon Web Services account.
     * If you want to list more hosted zones, make another call to <code>ListHostedZonesByName</code>, and specify the
     * value of <code>NextDNSName</code> and <code>NextHostedZoneId</code> in the <code>dnsname</code> and
     * <code>hostedzoneid</code> parameters, respectively.
     * </p>
     * </li>
     * </ul>
     *
     * @param listHostedZonesByNameRequest
     *        Retrieves a list of the public and private hosted zones that are associated with the current Amazon Web
     *        Services account in ASCII order by domain name.
     * @return A Java Future containing the result of the ListHostedZonesByName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>InvalidDomainNameException The specified domain name is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListHostedZonesByName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHostedZonesByName" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListHostedZonesByNameResponse> listHostedZonesByName(
            ListHostedZonesByNameRequest listHostedZonesByNameRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of your hosted zones in lexicographic order. The response includes a <code>HostedZones</code>
     * child element for each hosted zone created by the current Amazon Web Services account.
     * </p>
     * <p>
     * <code>ListHostedZonesByName</code> sorts hosted zones by name with the labels reversed. For example:
     * </p>
     * <p>
     * <code>com.example.www.</code>
     * </p>
     * <p>
     * Note the trailing dot, which can change the sort order in some circumstances.
     * </p>
     * <p>
     * If the domain name includes escape characters or Punycode, <code>ListHostedZonesByName</code> alphabetizes the
     * domain name using the escaped or Punycoded value, which is the format that Amazon Route 53 saves in its database.
     * For example, to create a hosted zone for exämple.com, you specify ex\344mple.com for the domain name.
     * <code>ListHostedZonesByName</code> alphabetizes it as:
     * </p>
     * <p>
     * <code>com.ex\344mple.</code>
     * </p>
     * <p>
     * The labels are reversed and alphabetized using the escaped value. For more information about valid domain name
     * formats, including internationalized domain names, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html">DNS Domain Name Format</a>
     * in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * Route 53 returns up to 100 items in each response. If you have a lot of hosted zones, use the
     * <code>MaxItems</code> parameter to list them in groups of up to 100. The response includes values that help
     * navigate from one group of <code>MaxItems</code> hosted zones to the next:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>DNSName</code> and <code>HostedZoneId</code> elements in the response contain the values, if any,
     * specified for the <code>dnsname</code> and <code>hostedzoneid</code> parameters in the request that produced the
     * current response.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>MaxItems</code> element in the response contains the value, if any, that you specified for the
     * <code>maxitems</code> parameter in the request that produced the current response.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the value of <code>IsTruncated</code> in the response is true, there are more hosted zones associated with the
     * current Amazon Web Services account.
     * </p>
     * <p>
     * If <code>IsTruncated</code> is false, this response includes the last hosted zone that is associated with the
     * current account. The <code>NextDNSName</code> element and <code>NextHostedZoneId</code> elements are omitted from
     * the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>NextDNSName</code> and <code>NextHostedZoneId</code> elements in the response contain the domain name
     * and the hosted zone ID of the next hosted zone that is associated with the current Amazon Web Services account.
     * If you want to list more hosted zones, make another call to <code>ListHostedZonesByName</code>, and specify the
     * value of <code>NextDNSName</code> and <code>NextHostedZoneId</code> in the <code>dnsname</code> and
     * <code>hostedzoneid</code> parameters, respectively.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHostedZonesByNameRequest.Builder} avoiding the
     * need to create one manually via {@link ListHostedZonesByNameRequest#builder()}
     * </p>
     *
     * @param listHostedZonesByNameRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.ListHostedZonesByNameRequest.Builder} to create a
     *        request. Retrieves a list of the public and private hosted zones that are associated with the current
     *        Amazon Web Services account in ASCII order by domain name.
     * @return A Java Future containing the result of the ListHostedZonesByName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>InvalidDomainNameException The specified domain name is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListHostedZonesByName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHostedZonesByName" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListHostedZonesByNameResponse> listHostedZonesByName(
            Consumer<ListHostedZonesByNameRequest.Builder> listHostedZonesByNameRequest) {
        return listHostedZonesByName(ListHostedZonesByNameRequest.builder().applyMutation(listHostedZonesByNameRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of your hosted zones in lexicographic order. The response includes a <code>HostedZones</code>
     * child element for each hosted zone created by the current Amazon Web Services account.
     * </p>
     * <p>
     * <code>ListHostedZonesByName</code> sorts hosted zones by name with the labels reversed. For example:
     * </p>
     * <p>
     * <code>com.example.www.</code>
     * </p>
     * <p>
     * Note the trailing dot, which can change the sort order in some circumstances.
     * </p>
     * <p>
     * If the domain name includes escape characters or Punycode, <code>ListHostedZonesByName</code> alphabetizes the
     * domain name using the escaped or Punycoded value, which is the format that Amazon Route 53 saves in its database.
     * For example, to create a hosted zone for exämple.com, you specify ex\344mple.com for the domain name.
     * <code>ListHostedZonesByName</code> alphabetizes it as:
     * </p>
     * <p>
     * <code>com.ex\344mple.</code>
     * </p>
     * <p>
     * The labels are reversed and alphabetized using the escaped value. For more information about valid domain name
     * formats, including internationalized domain names, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html">DNS Domain Name Format</a>
     * in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * Route 53 returns up to 100 items in each response. If you have a lot of hosted zones, use the
     * <code>MaxItems</code> parameter to list them in groups of up to 100. The response includes values that help
     * navigate from one group of <code>MaxItems</code> hosted zones to the next:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>DNSName</code> and <code>HostedZoneId</code> elements in the response contain the values, if any,
     * specified for the <code>dnsname</code> and <code>hostedzoneid</code> parameters in the request that produced the
     * current response.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>MaxItems</code> element in the response contains the value, if any, that you specified for the
     * <code>maxitems</code> parameter in the request that produced the current response.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the value of <code>IsTruncated</code> in the response is true, there are more hosted zones associated with the
     * current Amazon Web Services account.
     * </p>
     * <p>
     * If <code>IsTruncated</code> is false, this response includes the last hosted zone that is associated with the
     * current account. The <code>NextDNSName</code> element and <code>NextHostedZoneId</code> elements are omitted from
     * the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>NextDNSName</code> and <code>NextHostedZoneId</code> elements in the response contain the domain name
     * and the hosted zone ID of the next hosted zone that is associated with the current Amazon Web Services account.
     * If you want to list more hosted zones, make another call to <code>ListHostedZonesByName</code>, and specify the
     * value of <code>NextDNSName</code> and <code>NextHostedZoneId</code> in the <code>dnsname</code> and
     * <code>hostedzoneid</code> parameters, respectively.
     * </p>
     * </li>
     * </ul>
     *
     * @return A Java Future containing the result of the ListHostedZonesByName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>InvalidDomainNameException The specified domain name is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListHostedZonesByName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHostedZonesByName" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListHostedZonesByNameResponse> listHostedZonesByName() {
        return listHostedZonesByName(ListHostedZonesByNameRequest.builder().build());
    }

    /**
     * <p>
     * Lists all the private hosted zones that a specified VPC is associated with, regardless of which Amazon Web
     * Services account or Amazon Web Services service owns the hosted zones. The <code>HostedZoneOwner</code> structure
     * in the response contains one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An <code>OwningAccount</code> element, which contains the account number of either the current Amazon Web
     * Services account or another Amazon Web Services account. Some services, such as Cloud Map, create hosted zones
     * using the current account.
     * </p>
     * </li>
     * <li>
     * <p>
     * An <code>OwningService</code> element, which identifies the Amazon Web Services service that created and owns the
     * hosted zone. For example, if a hosted zone was created by Amazon Elastic File System (Amazon EFS), the value of
     * <code>Owner</code> is <code>efs.amazonaws.com</code>.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * When listing private hosted zones, the hosted zone and the Amazon VPC must belong to the same partition where the
     * hosted zones were created. A partition is a group of Amazon Web Services Regions. Each Amazon Web Services
     * account is scoped to one partition.
     * </p>
     * <p>
     * The following are the supported partitions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>aws</code> - Amazon Web Services Regions
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aws-cn</code> - China Regions
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aws-us-gov</code> - Amazon Web Services GovCloud (US) Region
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Access Management</a> in the
     * <i>Amazon Web Services General Reference</i>.
     * </p>
     * </note>
     *
     * @param listHostedZonesByVpcRequest
     *        Lists all the private hosted zones that a specified VPC is associated with, regardless of which Amazon Web
     *        Services account created the hosted zones.
     * @return A Java Future containing the result of the ListHostedZonesByVPC operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>InvalidPaginationTokenException The value that you specified to get the second or subsequent page of
     *         results is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListHostedZonesByVPC
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHostedZonesByVPC" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListHostedZonesByVpcResponse> listHostedZonesByVPC(
            ListHostedZonesByVpcRequest listHostedZonesByVpcRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the private hosted zones that a specified VPC is associated with, regardless of which Amazon Web
     * Services account or Amazon Web Services service owns the hosted zones. The <code>HostedZoneOwner</code> structure
     * in the response contains one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An <code>OwningAccount</code> element, which contains the account number of either the current Amazon Web
     * Services account or another Amazon Web Services account. Some services, such as Cloud Map, create hosted zones
     * using the current account.
     * </p>
     * </li>
     * <li>
     * <p>
     * An <code>OwningService</code> element, which identifies the Amazon Web Services service that created and owns the
     * hosted zone. For example, if a hosted zone was created by Amazon Elastic File System (Amazon EFS), the value of
     * <code>Owner</code> is <code>efs.amazonaws.com</code>.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * When listing private hosted zones, the hosted zone and the Amazon VPC must belong to the same partition where the
     * hosted zones were created. A partition is a group of Amazon Web Services Regions. Each Amazon Web Services
     * account is scoped to one partition.
     * </p>
     * <p>
     * The following are the supported partitions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>aws</code> - Amazon Web Services Regions
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aws-cn</code> - China Regions
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aws-us-gov</code> - Amazon Web Services GovCloud (US) Region
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Access Management</a> in the
     * <i>Amazon Web Services General Reference</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHostedZonesByVpcRequest.Builder} avoiding the
     * need to create one manually via {@link ListHostedZonesByVpcRequest#builder()}
     * </p>
     *
     * @param listHostedZonesByVpcRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.ListHostedZonesByVpcRequest.Builder} to create a
     *        request. Lists all the private hosted zones that a specified VPC is associated with, regardless of which
     *        Amazon Web Services account created the hosted zones.
     * @return A Java Future containing the result of the ListHostedZonesByVPC operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>InvalidPaginationTokenException The value that you specified to get the second or subsequent page of
     *         results is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListHostedZonesByVPC
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHostedZonesByVPC" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListHostedZonesByVpcResponse> listHostedZonesByVPC(
            Consumer<ListHostedZonesByVpcRequest.Builder> listHostedZonesByVpcRequest) {
        return listHostedZonesByVPC(ListHostedZonesByVpcRequest.builder().applyMutation(listHostedZonesByVpcRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of the public and private hosted zones that are associated with the current Amazon Web Services
     * account. The response includes a <code>HostedZones</code> child element for each hosted zone.
     * </p>
     * <p>
     * Amazon Route 53 returns a maximum of 100 items in each response. If you have a lot of hosted zones, you can use
     * the <code>maxitems</code> parameter to list them in groups of up to 100.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listHostedZones(software.amazon.awssdk.services.route53.model.ListHostedZonesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListHostedZonesPublisher publisher = client.listHostedZonesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListHostedZonesPublisher publisher = client.listHostedZonesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53.model.ListHostedZonesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53.model.ListHostedZonesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHostedZones(software.amazon.awssdk.services.route53.model.ListHostedZonesRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchDelegationSetException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>DelegationSetNotReusableException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListHostedZones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHostedZones" target="_top">AWS API
     *      Documentation</a>
     */
    default ListHostedZonesPublisher listHostedZonesPaginator() {
        return listHostedZonesPaginator(ListHostedZonesRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves a list of the public and private hosted zones that are associated with the current Amazon Web Services
     * account. The response includes a <code>HostedZones</code> child element for each hosted zone.
     * </p>
     * <p>
     * Amazon Route 53 returns a maximum of 100 items in each response. If you have a lot of hosted zones, you can use
     * the <code>maxitems</code> parameter to list them in groups of up to 100.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listHostedZones(software.amazon.awssdk.services.route53.model.ListHostedZonesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListHostedZonesPublisher publisher = client.listHostedZonesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListHostedZonesPublisher publisher = client.listHostedZonesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53.model.ListHostedZonesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53.model.ListHostedZonesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHostedZones(software.amazon.awssdk.services.route53.model.ListHostedZonesRequest)} operation.</b>
     * </p>
     *
     * @param listHostedZonesRequest
     *        A request to retrieve a list of the public and private hosted zones that are associated with the current
     *        Amazon Web Services account.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchDelegationSetException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>DelegationSetNotReusableException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListHostedZones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHostedZones" target="_top">AWS API
     *      Documentation</a>
     */
    default ListHostedZonesPublisher listHostedZonesPaginator(ListHostedZonesRequest listHostedZonesRequest) {
        return new ListHostedZonesPublisher(this, listHostedZonesRequest);
    }

    /**
     * <p>
     * Retrieves a list of the public and private hosted zones that are associated with the current Amazon Web Services
     * account. The response includes a <code>HostedZones</code> child element for each hosted zone.
     * </p>
     * <p>
     * Amazon Route 53 returns a maximum of 100 items in each response. If you have a lot of hosted zones, you can use
     * the <code>maxitems</code> parameter to list them in groups of up to 100.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listHostedZones(software.amazon.awssdk.services.route53.model.ListHostedZonesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListHostedZonesPublisher publisher = client.listHostedZonesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListHostedZonesPublisher publisher = client.listHostedZonesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53.model.ListHostedZonesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53.model.ListHostedZonesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHostedZones(software.amazon.awssdk.services.route53.model.ListHostedZonesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHostedZonesRequest.Builder} avoiding the need
     * to create one manually via {@link ListHostedZonesRequest#builder()}
     * </p>
     *
     * @param listHostedZonesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.ListHostedZonesRequest.Builder} to create a request.
     *        A request to retrieve a list of the public and private hosted zones that are associated with the current
     *        Amazon Web Services account.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchDelegationSetException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>DelegationSetNotReusableException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListHostedZones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHostedZones" target="_top">AWS API
     *      Documentation</a>
     */
    default ListHostedZonesPublisher listHostedZonesPaginator(Consumer<ListHostedZonesRequest.Builder> listHostedZonesRequest) {
        return listHostedZonesPaginator(ListHostedZonesRequest.builder().applyMutation(listHostedZonesRequest).build());
    }

    /**
     * <p>
     * Lists the configurations for DNS query logging that are associated with the current Amazon Web Services account
     * or the configuration that is associated with a specified hosted zone.
     * </p>
     * <p>
     * For more information about DNS query logs, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateQueryLoggingConfig.html"
     * >CreateQueryLoggingConfig</a>. Additional information, including the format of DNS query logs, appears in <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html">Logging DNS Queries</a> in the
     * <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     *
     * @param listQueryLoggingConfigsRequest
     * @return A Java Future containing the result of the ListQueryLoggingConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>InvalidPaginationTokenException The value that you specified to get the second or subsequent page of
     *         results is invalid.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListQueryLoggingConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListQueryLoggingConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListQueryLoggingConfigsResponse> listQueryLoggingConfigs(
            ListQueryLoggingConfigsRequest listQueryLoggingConfigsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the configurations for DNS query logging that are associated with the current Amazon Web Services account
     * or the configuration that is associated with a specified hosted zone.
     * </p>
     * <p>
     * For more information about DNS query logs, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateQueryLoggingConfig.html"
     * >CreateQueryLoggingConfig</a>. Additional information, including the format of DNS query logs, appears in <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html">Logging DNS Queries</a> in the
     * <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueryLoggingConfigsRequest.Builder} avoiding
     * the need to create one manually via {@link ListQueryLoggingConfigsRequest#builder()}
     * </p>
     *
     * @param listQueryLoggingConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListQueryLoggingConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>InvalidPaginationTokenException The value that you specified to get the second or subsequent page of
     *         results is invalid.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListQueryLoggingConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListQueryLoggingConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListQueryLoggingConfigsResponse> listQueryLoggingConfigs(
            Consumer<ListQueryLoggingConfigsRequest.Builder> listQueryLoggingConfigsRequest) {
        return listQueryLoggingConfigs(ListQueryLoggingConfigsRequest.builder().applyMutation(listQueryLoggingConfigsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the configurations for DNS query logging that are associated with the current Amazon Web Services account
     * or the configuration that is associated with a specified hosted zone.
     * </p>
     * <p>
     * For more information about DNS query logs, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateQueryLoggingConfig.html"
     * >CreateQueryLoggingConfig</a>. Additional information, including the format of DNS query logs, appears in <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html">Logging DNS Queries</a> in the
     * <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     *
     * @return A Java Future containing the result of the ListQueryLoggingConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>InvalidPaginationTokenException The value that you specified to get the second or subsequent page of
     *         results is invalid.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListQueryLoggingConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListQueryLoggingConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListQueryLoggingConfigsResponse> listQueryLoggingConfigs() {
        return listQueryLoggingConfigs(ListQueryLoggingConfigsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the configurations for DNS query logging that are associated with the current Amazon Web Services account
     * or the configuration that is associated with a specified hosted zone.
     * </p>
     * <p>
     * For more information about DNS query logs, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateQueryLoggingConfig.html"
     * >CreateQueryLoggingConfig</a>. Additional information, including the format of DNS query logs, appears in <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html">Logging DNS Queries</a> in the
     * <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listQueryLoggingConfigs(software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListQueryLoggingConfigsPublisher publisher = client.listQueryLoggingConfigsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListQueryLoggingConfigsPublisher publisher = client.listQueryLoggingConfigsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueryLoggingConfigs(software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>InvalidPaginationTokenException The value that you specified to get the second or subsequent page of
     *         results is invalid.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListQueryLoggingConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListQueryLoggingConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQueryLoggingConfigsPublisher listQueryLoggingConfigsPaginator() {
        return listQueryLoggingConfigsPaginator(ListQueryLoggingConfigsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the configurations for DNS query logging that are associated with the current Amazon Web Services account
     * or the configuration that is associated with a specified hosted zone.
     * </p>
     * <p>
     * For more information about DNS query logs, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateQueryLoggingConfig.html"
     * >CreateQueryLoggingConfig</a>. Additional information, including the format of DNS query logs, appears in <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html">Logging DNS Queries</a> in the
     * <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listQueryLoggingConfigs(software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListQueryLoggingConfigsPublisher publisher = client.listQueryLoggingConfigsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListQueryLoggingConfigsPublisher publisher = client.listQueryLoggingConfigsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueryLoggingConfigs(software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listQueryLoggingConfigsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>InvalidPaginationTokenException The value that you specified to get the second or subsequent page of
     *         results is invalid.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListQueryLoggingConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListQueryLoggingConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQueryLoggingConfigsPublisher listQueryLoggingConfigsPaginator(
            ListQueryLoggingConfigsRequest listQueryLoggingConfigsRequest) {
        return new ListQueryLoggingConfigsPublisher(this, listQueryLoggingConfigsRequest);
    }

    /**
     * <p>
     * Lists the configurations for DNS query logging that are associated with the current Amazon Web Services account
     * or the configuration that is associated with a specified hosted zone.
     * </p>
     * <p>
     * For more information about DNS query logs, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateQueryLoggingConfig.html"
     * >CreateQueryLoggingConfig</a>. Additional information, including the format of DNS query logs, appears in <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html">Logging DNS Queries</a> in the
     * <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listQueryLoggingConfigs(software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListQueryLoggingConfigsPublisher publisher = client.listQueryLoggingConfigsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListQueryLoggingConfigsPublisher publisher = client.listQueryLoggingConfigsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueryLoggingConfigs(software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueryLoggingConfigsRequest.Builder} avoiding
     * the need to create one manually via {@link ListQueryLoggingConfigsRequest#builder()}
     * </p>
     *
     * @param listQueryLoggingConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>InvalidPaginationTokenException The value that you specified to get the second or subsequent page of
     *         results is invalid.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListQueryLoggingConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListQueryLoggingConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQueryLoggingConfigsPublisher listQueryLoggingConfigsPaginator(
            Consumer<ListQueryLoggingConfigsRequest.Builder> listQueryLoggingConfigsRequest) {
        return listQueryLoggingConfigsPaginator(ListQueryLoggingConfigsRequest.builder()
                .applyMutation(listQueryLoggingConfigsRequest).build());
    }

    /**
     * <p>
     * Lists the resource record sets in a specified hosted zone.
     * </p>
     * <p>
     * <code>ListResourceRecordSets</code> returns up to 300 resource record sets at a time in ASCII order, beginning at
     * a position specified by the <code>name</code> and <code>type</code> elements.
     * </p>
     * <p>
     * <b>Sort order</b>
     * </p>
     * <p>
     * <code>ListResourceRecordSets</code> sorts results first by DNS name with the labels reversed, for example:
     * </p>
     * <p>
     * <code>com.example.www.</code>
     * </p>
     * <p>
     * Note the trailing dot, which can change the sort order when the record name contains characters that appear
     * before <code>.</code> (decimal 46) in the ASCII table. These characters include the following:
     * <code>! " # &#36 % &amp; ' ( ) * + , -</code>
     * </p>
     * <p>
     * When multiple records have the same DNS name, <code>ListResourceRecordSets</code> sorts results by the record
     * type.
     * </p>
     * <p>
     * <b>Specifying where to start listing records</b>
     * </p>
     * <p>
     * You can use the name and type elements to specify the resource record set that the list begins with:
     * </p>
     * <dl>
     * <dt>If you do not specify Name or Type</dt>
     * <dd>
     * <p>
     * The results begin with the first resource record set that the hosted zone contains.
     * </p>
     * </dd>
     * <dt>If you specify Name but not Type</dt>
     * <dd>
     * <p>
     * The results begin with the first resource record set in the list whose name is greater than or equal to
     * <code>Name</code>.
     * </p>
     * </dd>
     * <dt>If you specify Type but not Name</dt>
     * <dd>
     * <p>
     * Amazon Route 53 returns the <code>InvalidInput</code> error.
     * </p>
     * </dd>
     * <dt>If you specify both Name and Type</dt>
     * <dd>
     * <p>
     * The results begin with the first resource record set in the list whose name is greater than or equal to
     * <code>Name</code>, and whose type is greater than or equal to <code>Type</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * <b>Resource record sets that are PENDING</b>
     * </p>
     * <p>
     * This action returns the most current version of the records. This includes records that are <code>PENDING</code>,
     * and that are not yet available on all Route 53 DNS servers.
     * </p>
     * <p>
     * <b>Changing resource record sets</b>
     * </p>
     * <p>
     * To ensure that you get an accurate listing of the resource record sets for a hosted zone at a point in time, do
     * not submit a <code>ChangeResourceRecordSets</code> request while you're paging through the results of a
     * <code>ListResourceRecordSets</code> request. If you do, some pages may display results without the latest changes
     * while other pages display results with the latest changes.
     * </p>
     * <p>
     * <b>Displaying the next page of results</b>
     * </p>
     * <p>
     * If a <code>ListResourceRecordSets</code> command returns more than one page of results, the value of
     * <code>IsTruncated</code> is <code>true</code>. To display the next page of results, get the values of
     * <code>NextRecordName</code>, <code>NextRecordType</code>, and <code>NextRecordIdentifier</code> (if any) from the
     * response. Then submit another <code>ListResourceRecordSets</code> request, and specify those values for
     * <code>StartRecordName</code>, <code>StartRecordType</code>, and <code>StartRecordIdentifier</code>.
     * </p>
     *
     * @param listResourceRecordSetsRequest
     *        A request for the resource record sets that are associated with a specified hosted zone.
     * @return A Java Future containing the result of the ListResourceRecordSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListResourceRecordSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListResourceRecordSets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceRecordSetsResponse> listResourceRecordSets(
            ListResourceRecordSetsRequest listResourceRecordSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resource record sets in a specified hosted zone.
     * </p>
     * <p>
     * <code>ListResourceRecordSets</code> returns up to 300 resource record sets at a time in ASCII order, beginning at
     * a position specified by the <code>name</code> and <code>type</code> elements.
     * </p>
     * <p>
     * <b>Sort order</b>
     * </p>
     * <p>
     * <code>ListResourceRecordSets</code> sorts results first by DNS name with the labels reversed, for example:
     * </p>
     * <p>
     * <code>com.example.www.</code>
     * </p>
     * <p>
     * Note the trailing dot, which can change the sort order when the record name contains characters that appear
     * before <code>.</code> (decimal 46) in the ASCII table. These characters include the following:
     * <code>! " # &#36 % &amp; ' ( ) * + , -</code>
     * </p>
     * <p>
     * When multiple records have the same DNS name, <code>ListResourceRecordSets</code> sorts results by the record
     * type.
     * </p>
     * <p>
     * <b>Specifying where to start listing records</b>
     * </p>
     * <p>
     * You can use the name and type elements to specify the resource record set that the list begins with:
     * </p>
     * <dl>
     * <dt>If you do not specify Name or Type</dt>
     * <dd>
     * <p>
     * The results begin with the first resource record set that the hosted zone contains.
     * </p>
     * </dd>
     * <dt>If you specify Name but not Type</dt>
     * <dd>
     * <p>
     * The results begin with the first resource record set in the list whose name is greater than or equal to
     * <code>Name</code>.
     * </p>
     * </dd>
     * <dt>If you specify Type but not Name</dt>
     * <dd>
     * <p>
     * Amazon Route 53 returns the <code>InvalidInput</code> error.
     * </p>
     * </dd>
     * <dt>If you specify both Name and Type</dt>
     * <dd>
     * <p>
     * The results begin with the first resource record set in the list whose name is greater than or equal to
     * <code>Name</code>, and whose type is greater than or equal to <code>Type</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * <b>Resource record sets that are PENDING</b>
     * </p>
     * <p>
     * This action returns the most current version of the records. This includes records that are <code>PENDING</code>,
     * and that are not yet available on all Route 53 DNS servers.
     * </p>
     * <p>
     * <b>Changing resource record sets</b>
     * </p>
     * <p>
     * To ensure that you get an accurate listing of the resource record sets for a hosted zone at a point in time, do
     * not submit a <code>ChangeResourceRecordSets</code> request while you're paging through the results of a
     * <code>ListResourceRecordSets</code> request. If you do, some pages may display results without the latest changes
     * while other pages display results with the latest changes.
     * </p>
     * <p>
     * <b>Displaying the next page of results</b>
     * </p>
     * <p>
     * If a <code>ListResourceRecordSets</code> command returns more than one page of results, the value of
     * <code>IsTruncated</code> is <code>true</code>. To display the next page of results, get the values of
     * <code>NextRecordName</code>, <code>NextRecordType</code>, and <code>NextRecordIdentifier</code> (if any) from the
     * response. Then submit another <code>ListResourceRecordSets</code> request, and specify those values for
     * <code>StartRecordName</code>, <code>StartRecordType</code>, and <code>StartRecordIdentifier</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceRecordSetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListResourceRecordSetsRequest#builder()}
     * </p>
     *
     * @param listResourceRecordSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest.Builder} to create a
     *        request. A request for the resource record sets that are associated with a specified hosted zone.
     * @return A Java Future containing the result of the ListResourceRecordSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListResourceRecordSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListResourceRecordSets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceRecordSetsResponse> listResourceRecordSets(
            Consumer<ListResourceRecordSetsRequest.Builder> listResourceRecordSetsRequest) {
        return listResourceRecordSets(ListResourceRecordSetsRequest.builder().applyMutation(listResourceRecordSetsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the resource record sets in a specified hosted zone.
     * </p>
     * <p>
     * <code>ListResourceRecordSets</code> returns up to 300 resource record sets at a time in ASCII order, beginning at
     * a position specified by the <code>name</code> and <code>type</code> elements.
     * </p>
     * <p>
     * <b>Sort order</b>
     * </p>
     * <p>
     * <code>ListResourceRecordSets</code> sorts results first by DNS name with the labels reversed, for example:
     * </p>
     * <p>
     * <code>com.example.www.</code>
     * </p>
     * <p>
     * Note the trailing dot, which can change the sort order when the record name contains characters that appear
     * before <code>.</code> (decimal 46) in the ASCII table. These characters include the following:
     * <code>! " # &#36 % &amp; ' ( ) * + , -</code>
     * </p>
     * <p>
     * When multiple records have the same DNS name, <code>ListResourceRecordSets</code> sorts results by the record
     * type.
     * </p>
     * <p>
     * <b>Specifying where to start listing records</b>
     * </p>
     * <p>
     * You can use the name and type elements to specify the resource record set that the list begins with:
     * </p>
     * <dl>
     * <dt>If you do not specify Name or Type</dt>
     * <dd>
     * <p>
     * The results begin with the first resource record set that the hosted zone contains.
     * </p>
     * </dd>
     * <dt>If you specify Name but not Type</dt>
     * <dd>
     * <p>
     * The results begin with the first resource record set in the list whose name is greater than or equal to
     * <code>Name</code>.
     * </p>
     * </dd>
     * <dt>If you specify Type but not Name</dt>
     * <dd>
     * <p>
     * Amazon Route 53 returns the <code>InvalidInput</code> error.
     * </p>
     * </dd>
     * <dt>If you specify both Name and Type</dt>
     * <dd>
     * <p>
     * The results begin with the first resource record set in the list whose name is greater than or equal to
     * <code>Name</code>, and whose type is greater than or equal to <code>Type</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * <b>Resource record sets that are PENDING</b>
     * </p>
     * <p>
     * This action returns the most current version of the records. This includes records that are <code>PENDING</code>,
     * and that are not yet available on all Route 53 DNS servers.
     * </p>
     * <p>
     * <b>Changing resource record sets</b>
     * </p>
     * <p>
     * To ensure that you get an accurate listing of the resource record sets for a hosted zone at a point in time, do
     * not submit a <code>ChangeResourceRecordSets</code> request while you're paging through the results of a
     * <code>ListResourceRecordSets</code> request. If you do, some pages may display results without the latest changes
     * while other pages display results with the latest changes.
     * </p>
     * <p>
     * <b>Displaying the next page of results</b>
     * </p>
     * <p>
     * If a <code>ListResourceRecordSets</code> command returns more than one page of results, the value of
     * <code>IsTruncated</code> is <code>true</code>. To display the next page of results, get the values of
     * <code>NextRecordName</code>, <code>NextRecordType</code>, and <code>NextRecordIdentifier</code> (if any) from the
     * response. Then submit another <code>ListResourceRecordSets</code> request, and specify those values for
     * <code>StartRecordName</code>, <code>StartRecordType</code>, and <code>StartRecordIdentifier</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceRecordSets(software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListResourceRecordSetsPublisher publisher = client.listResourceRecordSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListResourceRecordSetsPublisher publisher = client.listResourceRecordSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53.model.ListResourceRecordSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53.model.ListResourceRecordSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceRecordSets(software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceRecordSetsRequest
     *        A request for the resource record sets that are associated with a specified hosted zone.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListResourceRecordSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListResourceRecordSets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceRecordSetsPublisher listResourceRecordSetsPaginator(
            ListResourceRecordSetsRequest listResourceRecordSetsRequest) {
        return new ListResourceRecordSetsPublisher(this, listResourceRecordSetsRequest);
    }

    /**
     * <p>
     * Lists the resource record sets in a specified hosted zone.
     * </p>
     * <p>
     * <code>ListResourceRecordSets</code> returns up to 300 resource record sets at a time in ASCII order, beginning at
     * a position specified by the <code>name</code> and <code>type</code> elements.
     * </p>
     * <p>
     * <b>Sort order</b>
     * </p>
     * <p>
     * <code>ListResourceRecordSets</code> sorts results first by DNS name with the labels reversed, for example:
     * </p>
     * <p>
     * <code>com.example.www.</code>
     * </p>
     * <p>
     * Note the trailing dot, which can change the sort order when the record name contains characters that appear
     * before <code>.</code> (decimal 46) in the ASCII table. These characters include the following:
     * <code>! " # &#36 % &amp; ' ( ) * + , -</code>
     * </p>
     * <p>
     * When multiple records have the same DNS name, <code>ListResourceRecordSets</code> sorts results by the record
     * type.
     * </p>
     * <p>
     * <b>Specifying where to start listing records</b>
     * </p>
     * <p>
     * You can use the name and type elements to specify the resource record set that the list begins with:
     * </p>
     * <dl>
     * <dt>If you do not specify Name or Type</dt>
     * <dd>
     * <p>
     * The results begin with the first resource record set that the hosted zone contains.
     * </p>
     * </dd>
     * <dt>If you specify Name but not Type</dt>
     * <dd>
     * <p>
     * The results begin with the first resource record set in the list whose name is greater than or equal to
     * <code>Name</code>.
     * </p>
     * </dd>
     * <dt>If you specify Type but not Name</dt>
     * <dd>
     * <p>
     * Amazon Route 53 returns the <code>InvalidInput</code> error.
     * </p>
     * </dd>
     * <dt>If you specify both Name and Type</dt>
     * <dd>
     * <p>
     * The results begin with the first resource record set in the list whose name is greater than or equal to
     * <code>Name</code>, and whose type is greater than or equal to <code>Type</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * <b>Resource record sets that are PENDING</b>
     * </p>
     * <p>
     * This action returns the most current version of the records. This includes records that are <code>PENDING</code>,
     * and that are not yet available on all Route 53 DNS servers.
     * </p>
     * <p>
     * <b>Changing resource record sets</b>
     * </p>
     * <p>
     * To ensure that you get an accurate listing of the resource record sets for a hosted zone at a point in time, do
     * not submit a <code>ChangeResourceRecordSets</code> request while you're paging through the results of a
     * <code>ListResourceRecordSets</code> request. If you do, some pages may display results without the latest changes
     * while other pages display results with the latest changes.
     * </p>
     * <p>
     * <b>Displaying the next page of results</b>
     * </p>
     * <p>
     * If a <code>ListResourceRecordSets</code> command returns more than one page of results, the value of
     * <code>IsTruncated</code> is <code>true</code>. To display the next page of results, get the values of
     * <code>NextRecordName</code>, <code>NextRecordType</code>, and <code>NextRecordIdentifier</code> (if any) from the
     * response. Then submit another <code>ListResourceRecordSets</code> request, and specify those values for
     * <code>StartRecordName</code>, <code>StartRecordType</code>, and <code>StartRecordIdentifier</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceRecordSets(software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListResourceRecordSetsPublisher publisher = client.listResourceRecordSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListResourceRecordSetsPublisher publisher = client.listResourceRecordSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53.model.ListResourceRecordSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53.model.ListResourceRecordSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceRecordSets(software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceRecordSetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListResourceRecordSetsRequest#builder()}
     * </p>
     *
     * @param listResourceRecordSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest.Builder} to create a
     *        request. A request for the resource record sets that are associated with a specified hosted zone.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListResourceRecordSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListResourceRecordSets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceRecordSetsPublisher listResourceRecordSetsPaginator(
            Consumer<ListResourceRecordSetsRequest.Builder> listResourceRecordSetsRequest) {
        return listResourceRecordSetsPaginator(ListResourceRecordSetsRequest.builder()
                .applyMutation(listResourceRecordSetsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of the reusable delegation sets that are associated with the current Amazon Web Services
     * account.
     * </p>
     *
     * @param listReusableDelegationSetsRequest
     *        A request to get a list of the reusable delegation sets that are associated with the current Amazon Web
     *        Services account.
     * @return A Java Future containing the result of the ListReusableDelegationSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListReusableDelegationSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListReusableDelegationSets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListReusableDelegationSetsResponse> listReusableDelegationSets(
            ListReusableDelegationSetsRequest listReusableDelegationSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of the reusable delegation sets that are associated with the current Amazon Web Services
     * account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReusableDelegationSetsRequest.Builder} avoiding
     * the need to create one manually via {@link ListReusableDelegationSetsRequest#builder()}
     * </p>
     *
     * @param listReusableDelegationSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.ListReusableDelegationSetsRequest.Builder} to create
     *        a request. A request to get a list of the reusable delegation sets that are associated with the current
     *        Amazon Web Services account.
     * @return A Java Future containing the result of the ListReusableDelegationSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListReusableDelegationSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListReusableDelegationSets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListReusableDelegationSetsResponse> listReusableDelegationSets(
            Consumer<ListReusableDelegationSetsRequest.Builder> listReusableDelegationSetsRequest) {
        return listReusableDelegationSets(ListReusableDelegationSetsRequest.builder()
                .applyMutation(listReusableDelegationSetsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of the reusable delegation sets that are associated with the current Amazon Web Services
     * account.
     * </p>
     *
     * @return A Java Future containing the result of the ListReusableDelegationSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListReusableDelegationSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListReusableDelegationSets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListReusableDelegationSetsResponse> listReusableDelegationSets() {
        return listReusableDelegationSets(ListReusableDelegationSetsRequest.builder().build());
    }

    /**
     * <p>
     * Lists tags for one health check or hosted zone.
     * </p>
     * <p>
     * For information about using tags for cost allocation, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation
     * Tags</a> in the <i>Billing and Cost Management User Guide</i>.
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A complex type containing information about a request for a list of the tags that are associated with an
     *        individual resource.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchHealthCheckException No health check exists with the specified ID.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>PriorRequestNotCompleteException If Amazon Route 53 can't process a request before the next request
     *         arrives, it will reject subsequent requests for the same hosted zone and return an
     *         <code>HTTP 400 error</code> (<code>Bad request</code>). If Route 53 returns this error repeatedly for the
     *         same request, we recommend that you wait, in intervals of increasing duration, before you try the request
     *         again.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists tags for one health check or hosted zone.
     * </p>
     * <p>
     * For information about using tags for cost allocation, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation
     * Tags</a> in the <i>Billing and Cost Management User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.ListTagsForResourceRequest.Builder} to create a
     *        request. A complex type containing information about a request for a list of the tags that are associated
     *        with an individual resource.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchHealthCheckException No health check exists with the specified ID.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>PriorRequestNotCompleteException If Amazon Route 53 can't process a request before the next request
     *         arrives, it will reject subsequent requests for the same hosted zone and return an
     *         <code>HTTP 400 error</code> (<code>Bad request</code>). If Route 53 returns this error repeatedly for the
     *         same request, we recommend that you wait, in intervals of increasing duration, before you try the request
     *         again.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists tags for up to 10 health checks or hosted zones.
     * </p>
     * <p>
     * For information about using tags for cost allocation, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation
     * Tags</a> in the <i>Billing and Cost Management User Guide</i>.
     * </p>
     *
     * @param listTagsForResourcesRequest
     *        A complex type that contains information about the health checks or hosted zones for which you want to
     *        list tags.
     * @return A Java Future containing the result of the ListTagsForResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchHealthCheckException No health check exists with the specified ID.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>PriorRequestNotCompleteException If Amazon Route 53 can't process a request before the next request
     *         arrives, it will reject subsequent requests for the same hosted zone and return an
     *         <code>HTTP 400 error</code> (<code>Bad request</code>). If Route 53 returns this error repeatedly for the
     *         same request, we recommend that you wait, in intervals of increasing duration, before you try the request
     *         again.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListTagsForResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTagsForResources" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourcesResponse> listTagsForResources(
            ListTagsForResourcesRequest listTagsForResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists tags for up to 10 health checks or hosted zones.
     * </p>
     * <p>
     * For information about using tags for cost allocation, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation
     * Tags</a> in the <i>Billing and Cost Management User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourcesRequest#builder()}
     * </p>
     *
     * @param listTagsForResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.ListTagsForResourcesRequest.Builder} to create a
     *        request. A complex type that contains information about the health checks or hosted zones for which you
     *        want to list tags.
     * @return A Java Future containing the result of the ListTagsForResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchHealthCheckException No health check exists with the specified ID.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>PriorRequestNotCompleteException If Amazon Route 53 can't process a request before the next request
     *         arrives, it will reject subsequent requests for the same hosted zone and return an
     *         <code>HTTP 400 error</code> (<code>Bad request</code>). If Route 53 returns this error repeatedly for the
     *         same request, we recommend that you wait, in intervals of increasing duration, before you try the request
     *         again.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListTagsForResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTagsForResources" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourcesResponse> listTagsForResources(
            Consumer<ListTagsForResourcesRequest.Builder> listTagsForResourcesRequest) {
        return listTagsForResources(ListTagsForResourcesRequest.builder().applyMutation(listTagsForResourcesRequest).build());
    }

    /**
     * <p>
     * Gets information about the latest version for every traffic policy that is associated with the current Amazon Web
     * Services account. Policies are listed in the order that they were created in.
     * </p>
     * <p>
     * For information about how of deleting a traffic policy affects the response from <code>ListTrafficPolicies</code>
     * , see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicy.html">DeleteTrafficPolicy
     * </a>.
     * </p>
     *
     * @param listTrafficPoliciesRequest
     *        A complex type that contains the information about the request to list the traffic policies that are
     *        associated with the current Amazon Web Services account.
     * @return A Java Future containing the result of the ListTrafficPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListTrafficPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTrafficPoliciesResponse> listTrafficPolicies(
            ListTrafficPoliciesRequest listTrafficPoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the latest version for every traffic policy that is associated with the current Amazon Web
     * Services account. Policies are listed in the order that they were created in.
     * </p>
     * <p>
     * For information about how of deleting a traffic policy affects the response from <code>ListTrafficPolicies</code>
     * , see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicy.html">DeleteTrafficPolicy
     * </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrafficPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListTrafficPoliciesRequest#builder()}
     * </p>
     *
     * @param listTrafficPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.ListTrafficPoliciesRequest.Builder} to create a
     *        request. A complex type that contains the information about the request to list the traffic policies that
     *        are associated with the current Amazon Web Services account.
     * @return A Java Future containing the result of the ListTrafficPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListTrafficPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTrafficPoliciesResponse> listTrafficPolicies(
            Consumer<ListTrafficPoliciesRequest.Builder> listTrafficPoliciesRequest) {
        return listTrafficPolicies(ListTrafficPoliciesRequest.builder().applyMutation(listTrafficPoliciesRequest).build());
    }

    /**
     * <p>
     * Gets information about the latest version for every traffic policy that is associated with the current Amazon Web
     * Services account. Policies are listed in the order that they were created in.
     * </p>
     * <p>
     * For information about how of deleting a traffic policy affects the response from <code>ListTrafficPolicies</code>
     * , see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicy.html">DeleteTrafficPolicy
     * </a>.
     * </p>
     *
     * @return A Java Future containing the result of the ListTrafficPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListTrafficPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTrafficPoliciesResponse> listTrafficPolicies() {
        return listTrafficPolicies(ListTrafficPoliciesRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the traffic policy instances that you created by using the current Amazon Web Services
     * account.
     * </p>
     * <note>
     * <p>
     * After you submit an <code>UpdateTrafficPolicyInstance</code> request, there's a brief delay while Amazon Route 53
     * creates the resource record sets that are specified in the traffic policy definition. For more information, see
     * the <code>State</code> response element.
     * </p>
     * </note>
     * <p>
     * Route 53 returns a maximum of 100 items in each response. If you have a lot of traffic policy instances, you can
     * use the <code>MaxItems</code> parameter to list them in groups of up to 100.
     * </p>
     *
     * @param listTrafficPolicyInstancesRequest
     *        A request to get information about the traffic policy instances that you created by using the current
     *        Amazon Web Services account.
     * @return A Java Future containing the result of the ListTrafficPolicyInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchTrafficPolicyInstanceException No traffic policy instance exists with the specified ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListTrafficPolicyInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicyInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTrafficPolicyInstancesResponse> listTrafficPolicyInstances(
            ListTrafficPolicyInstancesRequest listTrafficPolicyInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the traffic policy instances that you created by using the current Amazon Web Services
     * account.
     * </p>
     * <note>
     * <p>
     * After you submit an <code>UpdateTrafficPolicyInstance</code> request, there's a brief delay while Amazon Route 53
     * creates the resource record sets that are specified in the traffic policy definition. For more information, see
     * the <code>State</code> response element.
     * </p>
     * </note>
     * <p>
     * Route 53 returns a maximum of 100 items in each response. If you have a lot of traffic policy instances, you can
     * use the <code>MaxItems</code> parameter to list them in groups of up to 100.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrafficPolicyInstancesRequest.Builder} avoiding
     * the need to create one manually via {@link ListTrafficPolicyInstancesRequest#builder()}
     * </p>
     *
     * @param listTrafficPolicyInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesRequest.Builder} to create
     *        a request. A request to get information about the traffic policy instances that you created by using the
     *        current Amazon Web Services account.
     * @return A Java Future containing the result of the ListTrafficPolicyInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchTrafficPolicyInstanceException No traffic policy instance exists with the specified ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListTrafficPolicyInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicyInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTrafficPolicyInstancesResponse> listTrafficPolicyInstances(
            Consumer<ListTrafficPolicyInstancesRequest.Builder> listTrafficPolicyInstancesRequest) {
        return listTrafficPolicyInstances(ListTrafficPolicyInstancesRequest.builder()
                .applyMutation(listTrafficPolicyInstancesRequest).build());
    }

    /**
     * <p>
     * Gets information about the traffic policy instances that you created by using the current Amazon Web Services
     * account.
     * </p>
     * <note>
     * <p>
     * After you submit an <code>UpdateTrafficPolicyInstance</code> request, there's a brief delay while Amazon Route 53
     * creates the resource record sets that are specified in the traffic policy definition. For more information, see
     * the <code>State</code> response element.
     * </p>
     * </note>
     * <p>
     * Route 53 returns a maximum of 100 items in each response. If you have a lot of traffic policy instances, you can
     * use the <code>MaxItems</code> parameter to list them in groups of up to 100.
     * </p>
     *
     * @return A Java Future containing the result of the ListTrafficPolicyInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchTrafficPolicyInstanceException No traffic policy instance exists with the specified ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListTrafficPolicyInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicyInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTrafficPolicyInstancesResponse> listTrafficPolicyInstances() {
        return listTrafficPolicyInstances(ListTrafficPolicyInstancesRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the traffic policy instances that you created in a specified hosted zone.
     * </p>
     * <note>
     * <p>
     * After you submit a <code>CreateTrafficPolicyInstance</code> or an <code>UpdateTrafficPolicyInstance</code>
     * request, there's a brief delay while Amazon Route 53 creates the resource record sets that are specified in the
     * traffic policy definition. For more information, see the <code>State</code> response element.
     * </p>
     * </note>
     * <p>
     * Route 53 returns a maximum of 100 items in each response. If you have a lot of traffic policy instances, you can
     * use the <code>MaxItems</code> parameter to list them in groups of up to 100.
     * </p>
     *
     * @param listTrafficPolicyInstancesByHostedZoneRequest
     *        A request for the traffic policy instances that you created in a specified hosted zone.
     * @return A Java Future containing the result of the ListTrafficPolicyInstancesByHostedZone operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchTrafficPolicyInstanceException No traffic policy instance exists with the specified ID.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListTrafficPolicyInstancesByHostedZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicyInstancesByHostedZone"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTrafficPolicyInstancesByHostedZoneResponse> listTrafficPolicyInstancesByHostedZone(
            ListTrafficPolicyInstancesByHostedZoneRequest listTrafficPolicyInstancesByHostedZoneRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the traffic policy instances that you created in a specified hosted zone.
     * </p>
     * <note>
     * <p>
     * After you submit a <code>CreateTrafficPolicyInstance</code> or an <code>UpdateTrafficPolicyInstance</code>
     * request, there's a brief delay while Amazon Route 53 creates the resource record sets that are specified in the
     * traffic policy definition. For more information, see the <code>State</code> response element.
     * </p>
     * </note>
     * <p>
     * Route 53 returns a maximum of 100 items in each response. If you have a lot of traffic policy instances, you can
     * use the <code>MaxItems</code> parameter to list them in groups of up to 100.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListTrafficPolicyInstancesByHostedZoneRequest.Builder} avoiding the need to create one manually via
     * {@link ListTrafficPolicyInstancesByHostedZoneRequest#builder()}
     * </p>
     *
     * @param listTrafficPolicyInstancesByHostedZoneRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest.Builder}
     *        to create a request. A request for the traffic policy instances that you created in a specified hosted
     *        zone.
     * @return A Java Future containing the result of the ListTrafficPolicyInstancesByHostedZone operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchTrafficPolicyInstanceException No traffic policy instance exists with the specified ID.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListTrafficPolicyInstancesByHostedZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicyInstancesByHostedZone"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTrafficPolicyInstancesByHostedZoneResponse> listTrafficPolicyInstancesByHostedZone(
            Consumer<ListTrafficPolicyInstancesByHostedZoneRequest.Builder> listTrafficPolicyInstancesByHostedZoneRequest) {
        return listTrafficPolicyInstancesByHostedZone(ListTrafficPolicyInstancesByHostedZoneRequest.builder()
                .applyMutation(listTrafficPolicyInstancesByHostedZoneRequest).build());
    }

    /**
     * <p>
     * Gets information about the traffic policy instances that you created by using a specify traffic policy version.
     * </p>
     * <note>
     * <p>
     * After you submit a <code>CreateTrafficPolicyInstance</code> or an <code>UpdateTrafficPolicyInstance</code>
     * request, there's a brief delay while Amazon Route 53 creates the resource record sets that are specified in the
     * traffic policy definition. For more information, see the <code>State</code> response element.
     * </p>
     * </note>
     * <p>
     * Route 53 returns a maximum of 100 items in each response. If you have a lot of traffic policy instances, you can
     * use the <code>MaxItems</code> parameter to list them in groups of up to 100.
     * </p>
     *
     * @param listTrafficPolicyInstancesByPolicyRequest
     *        A complex type that contains the information about the request to list your traffic policy instances.
     * @return A Java Future containing the result of the ListTrafficPolicyInstancesByPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchTrafficPolicyInstanceException No traffic policy instance exists with the specified ID.</li>
     *         <li>NoSuchTrafficPolicyException No traffic policy exists with the specified ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListTrafficPolicyInstancesByPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicyInstancesByPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTrafficPolicyInstancesByPolicyResponse> listTrafficPolicyInstancesByPolicy(
            ListTrafficPolicyInstancesByPolicyRequest listTrafficPolicyInstancesByPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the traffic policy instances that you created by using a specify traffic policy version.
     * </p>
     * <note>
     * <p>
     * After you submit a <code>CreateTrafficPolicyInstance</code> or an <code>UpdateTrafficPolicyInstance</code>
     * request, there's a brief delay while Amazon Route 53 creates the resource record sets that are specified in the
     * traffic policy definition. For more information, see the <code>State</code> response element.
     * </p>
     * </note>
     * <p>
     * Route 53 returns a maximum of 100 items in each response. If you have a lot of traffic policy instances, you can
     * use the <code>MaxItems</code> parameter to list them in groups of up to 100.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrafficPolicyInstancesByPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link ListTrafficPolicyInstancesByPolicyRequest#builder()}
     * </p>
     *
     * @param listTrafficPolicyInstancesByPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByPolicyRequest.Builder} to
     *        create a request. A complex type that contains the information about the request to list your traffic
     *        policy instances.
     * @return A Java Future containing the result of the ListTrafficPolicyInstancesByPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchTrafficPolicyInstanceException No traffic policy instance exists with the specified ID.</li>
     *         <li>NoSuchTrafficPolicyException No traffic policy exists with the specified ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListTrafficPolicyInstancesByPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicyInstancesByPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTrafficPolicyInstancesByPolicyResponse> listTrafficPolicyInstancesByPolicy(
            Consumer<ListTrafficPolicyInstancesByPolicyRequest.Builder> listTrafficPolicyInstancesByPolicyRequest) {
        return listTrafficPolicyInstancesByPolicy(ListTrafficPolicyInstancesByPolicyRequest.builder()
                .applyMutation(listTrafficPolicyInstancesByPolicyRequest).build());
    }

    /**
     * <p>
     * Gets information about all of the versions for a specified traffic policy.
     * </p>
     * <p>
     * Traffic policy versions are listed in numerical order by <code>VersionNumber</code>.
     * </p>
     *
     * @param listTrafficPolicyVersionsRequest
     *        A complex type that contains the information about the request to list your traffic policies.
     * @return A Java Future containing the result of the ListTrafficPolicyVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchTrafficPolicyException No traffic policy exists with the specified ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListTrafficPolicyVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicyVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTrafficPolicyVersionsResponse> listTrafficPolicyVersions(
            ListTrafficPolicyVersionsRequest listTrafficPolicyVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about all of the versions for a specified traffic policy.
     * </p>
     * <p>
     * Traffic policy versions are listed in numerical order by <code>VersionNumber</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrafficPolicyVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListTrafficPolicyVersionsRequest#builder()}
     * </p>
     *
     * @param listTrafficPolicyVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.ListTrafficPolicyVersionsRequest.Builder} to create a
     *        request. A complex type that contains the information about the request to list your traffic policies.
     * @return A Java Future containing the result of the ListTrafficPolicyVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchTrafficPolicyException No traffic policy exists with the specified ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListTrafficPolicyVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicyVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTrafficPolicyVersionsResponse> listTrafficPolicyVersions(
            Consumer<ListTrafficPolicyVersionsRequest.Builder> listTrafficPolicyVersionsRequest) {
        return listTrafficPolicyVersions(ListTrafficPolicyVersionsRequest.builder()
                .applyMutation(listTrafficPolicyVersionsRequest).build());
    }

    /**
     * <p>
     * Gets a list of the VPCs that were created by other accounts and that can be associated with a specified hosted
     * zone because you've submitted one or more <code>CreateVPCAssociationAuthorization</code> requests.
     * </p>
     * <p>
     * The response includes a <code>VPCs</code> element with a <code>VPC</code> child element for each VPC that can be
     * associated with the hosted zone.
     * </p>
     *
     * @param listVpcAssociationAuthorizationsRequest
     *        A complex type that contains information about that can be associated with your hosted zone.
     * @return A Java Future containing the result of the ListVPCAssociationAuthorizations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>InvalidPaginationTokenException The value that you specified to get the second or subsequent page of
     *         results is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListVPCAssociationAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListVPCAssociationAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListVpcAssociationAuthorizationsResponse> listVPCAssociationAuthorizations(
            ListVpcAssociationAuthorizationsRequest listVpcAssociationAuthorizationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the VPCs that were created by other accounts and that can be associated with a specified hosted
     * zone because you've submitted one or more <code>CreateVPCAssociationAuthorization</code> requests.
     * </p>
     * <p>
     * The response includes a <code>VPCs</code> element with a <code>VPC</code> child element for each VPC that can be
     * associated with the hosted zone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVpcAssociationAuthorizationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListVpcAssociationAuthorizationsRequest#builder()}
     * </p>
     *
     * @param listVpcAssociationAuthorizationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.ListVpcAssociationAuthorizationsRequest.Builder} to
     *        create a request. A complex type that contains information about that can be associated with your hosted
     *        zone.
     * @return A Java Future containing the result of the ListVPCAssociationAuthorizations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>InvalidPaginationTokenException The value that you specified to get the second or subsequent page of
     *         results is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListVPCAssociationAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListVPCAssociationAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListVpcAssociationAuthorizationsResponse> listVPCAssociationAuthorizations(
            Consumer<ListVpcAssociationAuthorizationsRequest.Builder> listVpcAssociationAuthorizationsRequest) {
        return listVPCAssociationAuthorizations(ListVpcAssociationAuthorizationsRequest.builder()
                .applyMutation(listVpcAssociationAuthorizationsRequest).build());
    }

    /**
     * <p>
     * Gets the value that Amazon Route 53 returns in response to a DNS request for a specified record name and type.
     * You can optionally specify the IP address of a DNS resolver, an EDNS0 client subnet IP address, and a subnet
     * mask.
     * </p>
     * <p>
     * This call only supports querying public hosted zones.
     * </p>
     * <note>
     * <p>
     * The <code>TestDnsAnswer </code> returns information similar to what you would expect from the answer section of
     * the <code>dig</code> command. Therefore, if you query for the name servers of a subdomain that point to the
     * parent name servers, those will not be returned.
     * </p>
     * </note>
     *
     * @param testDnsAnswerRequest
     *        Gets the value that Amazon Route 53 returns in response to a DNS request for a specified record name and
     *        type. You can optionally specify the IP address of a DNS resolver, an EDNS0 client subnet IP address, and
     *        a subnet mask.
     * @return A Java Future containing the result of the TestDNSAnswer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.TestDNSAnswer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/TestDNSAnswer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TestDnsAnswerResponse> testDNSAnswer(TestDnsAnswerRequest testDnsAnswerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the value that Amazon Route 53 returns in response to a DNS request for a specified record name and type.
     * You can optionally specify the IP address of a DNS resolver, an EDNS0 client subnet IP address, and a subnet
     * mask.
     * </p>
     * <p>
     * This call only supports querying public hosted zones.
     * </p>
     * <note>
     * <p>
     * The <code>TestDnsAnswer </code> returns information similar to what you would expect from the answer section of
     * the <code>dig</code> command. Therefore, if you query for the name servers of a subdomain that point to the
     * parent name servers, those will not be returned.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestDnsAnswerRequest.Builder} avoiding the need to
     * create one manually via {@link TestDnsAnswerRequest#builder()}
     * </p>
     *
     * @param testDnsAnswerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.TestDnsAnswerRequest.Builder} to create a request.
     *        Gets the value that Amazon Route 53 returns in response to a DNS request for a specified record name and
     *        type. You can optionally specify the IP address of a DNS resolver, an EDNS0 client subnet IP address, and
     *        a subnet mask.
     * @return A Java Future containing the result of the TestDNSAnswer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.TestDNSAnswer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/TestDNSAnswer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TestDnsAnswerResponse> testDNSAnswer(Consumer<TestDnsAnswerRequest.Builder> testDnsAnswerRequest) {
        return testDNSAnswer(TestDnsAnswerRequest.builder().applyMutation(testDnsAnswerRequest).build());
    }

    /**
     * <p>
     * Updates an existing health check. Note that some values can't be updated.
     * </p>
     * <p>
     * For more information about updating health checks, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/health-checks-creating-deleting.html">Creating,
     * Updating, and Deleting Health Checks</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     *
     * @param updateHealthCheckRequest
     *        A complex type that contains information about a request to update a health check.
     * @return A Java Future containing the result of the UpdateHealthCheck operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHealthCheckException No health check exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>HealthCheckVersionMismatchException The value of <code>HealthCheckVersion</code> in the request
     *         doesn't match the value of <code>HealthCheckVersion</code> in the health check.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.UpdateHealthCheck
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/UpdateHealthCheck" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateHealthCheckResponse> updateHealthCheck(UpdateHealthCheckRequest updateHealthCheckRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing health check. Note that some values can't be updated.
     * </p>
     * <p>
     * For more information about updating health checks, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/health-checks-creating-deleting.html">Creating,
     * Updating, and Deleting Health Checks</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateHealthCheckRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateHealthCheckRequest#builder()}
     * </p>
     *
     * @param updateHealthCheckRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.UpdateHealthCheckRequest.Builder} to create a
     *        request. A complex type that contains information about a request to update a health check.
     * @return A Java Future containing the result of the UpdateHealthCheck operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHealthCheckException No health check exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>HealthCheckVersionMismatchException The value of <code>HealthCheckVersion</code> in the request
     *         doesn't match the value of <code>HealthCheckVersion</code> in the health check.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.UpdateHealthCheck
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/UpdateHealthCheck" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateHealthCheckResponse> updateHealthCheck(
            Consumer<UpdateHealthCheckRequest.Builder> updateHealthCheckRequest) {
        return updateHealthCheck(UpdateHealthCheckRequest.builder().applyMutation(updateHealthCheckRequest).build());
    }

    /**
     * <p>
     * Updates the comment for a specified hosted zone.
     * </p>
     *
     * @param updateHostedZoneCommentRequest
     *        A request to update the comment for a hosted zone.
     * @return A Java Future containing the result of the UpdateHostedZoneComment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>PriorRequestNotCompleteException If Amazon Route 53 can't process a request before the next request
     *         arrives, it will reject subsequent requests for the same hosted zone and return an
     *         <code>HTTP 400 error</code> (<code>Bad request</code>). If Route 53 returns this error repeatedly for the
     *         same request, we recommend that you wait, in intervals of increasing duration, before you try the request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.UpdateHostedZoneComment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/UpdateHostedZoneComment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateHostedZoneCommentResponse> updateHostedZoneComment(
            UpdateHostedZoneCommentRequest updateHostedZoneCommentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the comment for a specified hosted zone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateHostedZoneCommentRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateHostedZoneCommentRequest#builder()}
     * </p>
     *
     * @param updateHostedZoneCommentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.UpdateHostedZoneCommentRequest.Builder} to create a
     *        request. A request to update the comment for a hosted zone.
     * @return A Java Future containing the result of the UpdateHostedZoneComment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>PriorRequestNotCompleteException If Amazon Route 53 can't process a request before the next request
     *         arrives, it will reject subsequent requests for the same hosted zone and return an
     *         <code>HTTP 400 error</code> (<code>Bad request</code>). If Route 53 returns this error repeatedly for the
     *         same request, we recommend that you wait, in intervals of increasing duration, before you try the request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.UpdateHostedZoneComment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/UpdateHostedZoneComment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateHostedZoneCommentResponse> updateHostedZoneComment(
            Consumer<UpdateHostedZoneCommentRequest.Builder> updateHostedZoneCommentRequest) {
        return updateHostedZoneComment(UpdateHostedZoneCommentRequest.builder().applyMutation(updateHostedZoneCommentRequest)
                .build());
    }

    /**
     * <p>
     * Updates the comment for a specified traffic policy version.
     * </p>
     *
     * @param updateTrafficPolicyCommentRequest
     *        A complex type that contains information about the traffic policy that you want to update the comment for.
     * @return A Java Future containing the result of the UpdateTrafficPolicyComment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchTrafficPolicyException No traffic policy exists with the specified ID.</li>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.UpdateTrafficPolicyComment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/UpdateTrafficPolicyComment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTrafficPolicyCommentResponse> updateTrafficPolicyComment(
            UpdateTrafficPolicyCommentRequest updateTrafficPolicyCommentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the comment for a specified traffic policy version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTrafficPolicyCommentRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateTrafficPolicyCommentRequest#builder()}
     * </p>
     *
     * @param updateTrafficPolicyCommentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyCommentRequest.Builder} to create
     *        a request. A complex type that contains information about the traffic policy that you want to update the
     *        comment for.
     * @return A Java Future containing the result of the UpdateTrafficPolicyComment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchTrafficPolicyException No traffic policy exists with the specified ID.</li>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.UpdateTrafficPolicyComment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/UpdateTrafficPolicyComment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTrafficPolicyCommentResponse> updateTrafficPolicyComment(
            Consumer<UpdateTrafficPolicyCommentRequest.Builder> updateTrafficPolicyCommentRequest) {
        return updateTrafficPolicyComment(UpdateTrafficPolicyCommentRequest.builder()
                .applyMutation(updateTrafficPolicyCommentRequest).build());
    }

    /**
     * <note>
     * <p>
     * After you submit a <code>UpdateTrafficPolicyInstance</code> request, there's a brief delay while Route 53 creates
     * the resource record sets that are specified in the traffic policy definition. Use
     * <code>GetTrafficPolicyInstance</code> with the <code>id</code> of updated traffic policy instance confirm that
     * the <code>UpdateTrafficPolicyInstance</code> request completed successfully. For more information, see the
     * <code>State</code> response element.
     * </p>
     * </note>
     * <p>
     * Updates the resource record sets in a specified hosted zone that were created based on the settings in a
     * specified traffic policy version.
     * </p>
     * <p>
     * When you update a traffic policy instance, Amazon Route 53 continues to respond to DNS queries for the root
     * resource record set name (such as example.com) while it replaces one group of resource record sets with another.
     * Route 53 performs the following operations:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Route 53 creates a new group of resource record sets based on the specified traffic policy. This is true
     * regardless of how significant the differences are between the existing resource record sets and the new resource
     * record sets.
     * </p>
     * </li>
     * <li>
     * <p>
     * When all of the new resource record sets have been created, Route 53 starts to respond to DNS queries for the
     * root resource record set name (such as example.com) by using the new resource record sets.
     * </p>
     * </li>
     * <li>
     * <p>
     * Route 53 deletes the old group of resource record sets that are associated with the root resource record set
     * name.
     * </p>
     * </li>
     * </ol>
     *
     * @param updateTrafficPolicyInstanceRequest
     *        A complex type that contains information about the resource record sets that you want to update based on a
     *        specified traffic policy instance.
     * @return A Java Future containing the result of the UpdateTrafficPolicyInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchTrafficPolicyException No traffic policy exists with the specified ID.</li>
     *         <li>NoSuchTrafficPolicyInstanceException No traffic policy instance exists with the specified ID.</li>
     *         <li>PriorRequestNotCompleteException If Amazon Route 53 can't process a request before the next request
     *         arrives, it will reject subsequent requests for the same hosted zone and return an
     *         <code>HTTP 400 error</code> (<code>Bad request</code>). If Route 53 returns this error repeatedly for the
     *         same request, we recommend that you wait, in intervals of increasing duration, before you try the request
     *         again.</li>
     *         <li>ConflictingTypesException You tried to update a traffic policy instance by using a traffic policy
     *         version that has a different DNS type than the current type for the instance. You specified the type in
     *         the JSON document in the <code>CreateTrafficPolicy</code> or <code>CreateTrafficPolicyVersion</code>
     *         request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.UpdateTrafficPolicyInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/UpdateTrafficPolicyInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTrafficPolicyInstanceResponse> updateTrafficPolicyInstance(
            UpdateTrafficPolicyInstanceRequest updateTrafficPolicyInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * After you submit a <code>UpdateTrafficPolicyInstance</code> request, there's a brief delay while Route 53 creates
     * the resource record sets that are specified in the traffic policy definition. Use
     * <code>GetTrafficPolicyInstance</code> with the <code>id</code> of updated traffic policy instance confirm that
     * the <code>UpdateTrafficPolicyInstance</code> request completed successfully. For more information, see the
     * <code>State</code> response element.
     * </p>
     * </note>
     * <p>
     * Updates the resource record sets in a specified hosted zone that were created based on the settings in a
     * specified traffic policy version.
     * </p>
     * <p>
     * When you update a traffic policy instance, Amazon Route 53 continues to respond to DNS queries for the root
     * resource record set name (such as example.com) while it replaces one group of resource record sets with another.
     * Route 53 performs the following operations:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Route 53 creates a new group of resource record sets based on the specified traffic policy. This is true
     * regardless of how significant the differences are between the existing resource record sets and the new resource
     * record sets.
     * </p>
     * </li>
     * <li>
     * <p>
     * When all of the new resource record sets have been created, Route 53 starts to respond to DNS queries for the
     * root resource record set name (such as example.com) by using the new resource record sets.
     * </p>
     * </li>
     * <li>
     * <p>
     * Route 53 deletes the old group of resource record sets that are associated with the root resource record set
     * name.
     * </p>
     * </li>
     * </ol>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTrafficPolicyInstanceRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateTrafficPolicyInstanceRequest#builder()}
     * </p>
     *
     * @param updateTrafficPolicyInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyInstanceRequest.Builder} to create
     *        a request. A complex type that contains information about the resource record sets that you want to update
     *        based on a specified traffic policy instance.
     * @return A Java Future containing the result of the UpdateTrafficPolicyInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchTrafficPolicyException No traffic policy exists with the specified ID.</li>
     *         <li>NoSuchTrafficPolicyInstanceException No traffic policy instance exists with the specified ID.</li>
     *         <li>PriorRequestNotCompleteException If Amazon Route 53 can't process a request before the next request
     *         arrives, it will reject subsequent requests for the same hosted zone and return an
     *         <code>HTTP 400 error</code> (<code>Bad request</code>). If Route 53 returns this error repeatedly for the
     *         same request, we recommend that you wait, in intervals of increasing duration, before you try the request
     *         again.</li>
     *         <li>ConflictingTypesException You tried to update a traffic policy instance by using a traffic policy
     *         version that has a different DNS type than the current type for the instance. You specified the type in
     *         the JSON document in the <code>CreateTrafficPolicy</code> or <code>CreateTrafficPolicyVersion</code>
     *         request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.UpdateTrafficPolicyInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/UpdateTrafficPolicyInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTrafficPolicyInstanceResponse> updateTrafficPolicyInstance(
            Consumer<UpdateTrafficPolicyInstanceRequest.Builder> updateTrafficPolicyInstanceRequest) {
        return updateTrafficPolicyInstance(UpdateTrafficPolicyInstanceRequest.builder()
                .applyMutation(updateTrafficPolicyInstanceRequest).build());
    }

    /**
     * Create an instance of {@link Route53AsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link Route53AsyncWaiter}
     */
    default Route53AsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    @Override
    default Route53ServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link Route53AsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static Route53AsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link Route53AsyncClient}.
     */
    static Route53AsyncClientBuilder builder() {
        return new DefaultRoute53AsyncClientBuilder();
    }
}
