/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * (Resource record sets only): A complex type that lets you specify where your resources are located. Only one of
 * <code>LocalZoneGroup</code>, <code>Coordinates</code>, or <code>Amazon Web ServicesRegion</code> is allowed per
 * request at a time.
 * </p>
 * <p>
 * For more information about geoproximity routing, see <a
 * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy-geoproximity.html">Geoproximity
 * routing</a> in the <i>Amazon Route 53 Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeoProximityLocation implements SdkPojo, Serializable,
        ToCopyableBuilder<GeoProximityLocation.Builder, GeoProximityLocation> {
    private static final SdkField<String> AWS_REGION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AWSRegion")
            .getter(getter(GeoProximityLocation::awsRegion))
            .setter(setter(Builder::awsRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AWSRegion")
                    .unmarshallLocationName("AWSRegion").build()).build();

    private static final SdkField<String> LOCAL_ZONE_GROUP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalZoneGroup")
            .getter(getter(GeoProximityLocation::localZoneGroup))
            .setter(setter(Builder::localZoneGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalZoneGroup")
                    .unmarshallLocationName("LocalZoneGroup").build()).build();

    private static final SdkField<Coordinates> COORDINATES_FIELD = SdkField
            .<Coordinates> builder(MarshallingType.SDK_POJO)
            .memberName("Coordinates")
            .getter(getter(GeoProximityLocation::coordinates))
            .setter(setter(Builder::coordinates))
            .constructor(Coordinates::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Coordinates")
                    .unmarshallLocationName("Coordinates").build()).build();

    private static final SdkField<Integer> BIAS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Bias")
            .getter(getter(GeoProximityLocation::bias))
            .setter(setter(Builder::bias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bias")
                    .unmarshallLocationName("Bias").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_REGION_FIELD,
            LOCAL_ZONE_GROUP_FIELD, COORDINATES_FIELD, BIAS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String awsRegion;

    private final String localZoneGroup;

    private final Coordinates coordinates;

    private final Integer bias;

    private GeoProximityLocation(BuilderImpl builder) {
        this.awsRegion = builder.awsRegion;
        this.localZoneGroup = builder.localZoneGroup;
        this.coordinates = builder.coordinates;
        this.bias = builder.bias;
    }

    /**
     * <p>
     * The Amazon Web Services Region the resource you are directing DNS traffic to, is in.
     * </p>
     * 
     * @return The Amazon Web Services Region the resource you are directing DNS traffic to, is in.
     */
    public final String awsRegion() {
        return awsRegion;
    }

    /**
     * <p>
     * Specifies an Amazon Web Services Local Zone Group.
     * </p>
     * <p>
     * A local Zone Group is usually the Local Zone code without the ending character. For example, if the Local Zone is
     * <code>us-east-1-bue-1a</code> the Local Zone Group is <code>us-east-1-bue-1</code>.
     * </p>
     * <p>
     * You can identify the Local Zones Group for a specific Local Zone by using the <a
     * href="https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-availability-zones.html"
     * >describe-availability-zones</a> CLI command:
     * </p>
     * <p>
     * This command returns: <code>"GroupName": "us-west-2-den-1"</code>, specifying that the Local Zone
     * <code>us-west-2-den-1a</code> belongs to the Local Zone Group <code>us-west-2-den-1</code>.
     * </p>
     * 
     * @return Specifies an Amazon Web Services Local Zone Group. </p>
     *         <p>
     *         A local Zone Group is usually the Local Zone code without the ending character. For example, if the Local
     *         Zone is <code>us-east-1-bue-1a</code> the Local Zone Group is <code>us-east-1-bue-1</code>.
     *         </p>
     *         <p>
     *         You can identify the Local Zones Group for a specific Local Zone by using the <a
     *         href="https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-availability-zones.html"
     *         >describe-availability-zones</a> CLI command:
     *         </p>
     *         <p>
     *         This command returns: <code>"GroupName": "us-west-2-den-1"</code>, specifying that the Local Zone
     *         <code>us-west-2-den-1a</code> belongs to the Local Zone Group <code>us-west-2-den-1</code>.
     */
    public final String localZoneGroup() {
        return localZoneGroup;
    }

    /**
     * <p>
     * Contains the longitude and latitude for a geographic region.
     * </p>
     * 
     * @return Contains the longitude and latitude for a geographic region.
     */
    public final Coordinates coordinates() {
        return coordinates;
    }

    /**
     * <p>
     * The bias increases or decreases the size of the geographic region from which Route 53 routes traffic to a
     * resource.
     * </p>
     * <p>
     * To use <code>Bias</code> to change the size of the geographic region, specify the applicable value for the bias:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To expand the size of the geographic region from which Route 53 routes traffic to a resource, specify a positive
     * integer from 1 to 99 for the bias. Route 53 shrinks the size of adjacent regions.
     * </p>
     * </li>
     * <li>
     * <p>
     * To shrink the size of the geographic region from which Route 53 routes traffic to a resource, specify a negative
     * bias of -1 to -99. Route 53 expands the size of adjacent regions.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The bias increases or decreases the size of the geographic region from which Route 53 routes traffic to a
     *         resource. </p>
     *         <p>
     *         To use <code>Bias</code> to change the size of the geographic region, specify the applicable value for
     *         the bias:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To expand the size of the geographic region from which Route 53 routes traffic to a resource, specify a
     *         positive integer from 1 to 99 for the bias. Route 53 shrinks the size of adjacent regions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To shrink the size of the geographic region from which Route 53 routes traffic to a resource, specify a
     *         negative bias of -1 to -99. Route 53 expands the size of adjacent regions.
     *         </p>
     *         </li>
     */
    public final Integer bias() {
        return bias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(localZoneGroup());
        hashCode = 31 * hashCode + Objects.hashCode(coordinates());
        hashCode = 31 * hashCode + Objects.hashCode(bias());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoProximityLocation)) {
            return false;
        }
        GeoProximityLocation other = (GeoProximityLocation) obj;
        return Objects.equals(awsRegion(), other.awsRegion()) && Objects.equals(localZoneGroup(), other.localZoneGroup())
                && Objects.equals(coordinates(), other.coordinates()) && Objects.equals(bias(), other.bias());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeoProximityLocation").add("AWSRegion", awsRegion()).add("LocalZoneGroup", localZoneGroup())
                .add("Coordinates", coordinates()).add("Bias", bias()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AWSRegion":
            return Optional.ofNullable(clazz.cast(awsRegion()));
        case "LocalZoneGroup":
            return Optional.ofNullable(clazz.cast(localZoneGroup()));
        case "Coordinates":
            return Optional.ofNullable(clazz.cast(coordinates()));
        case "Bias":
            return Optional.ofNullable(clazz.cast(bias()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GeoProximityLocation, T> g) {
        return obj -> g.apply((GeoProximityLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeoProximityLocation> {
        /**
         * <p>
         * The Amazon Web Services Region the resource you are directing DNS traffic to, is in.
         * </p>
         * 
         * @param awsRegion
         *        The Amazon Web Services Region the resource you are directing DNS traffic to, is in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegion(String awsRegion);

        /**
         * <p>
         * Specifies an Amazon Web Services Local Zone Group.
         * </p>
         * <p>
         * A local Zone Group is usually the Local Zone code without the ending character. For example, if the Local
         * Zone is <code>us-east-1-bue-1a</code> the Local Zone Group is <code>us-east-1-bue-1</code>.
         * </p>
         * <p>
         * You can identify the Local Zones Group for a specific Local Zone by using the <a
         * href="https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-availability-zones.html"
         * >describe-availability-zones</a> CLI command:
         * </p>
         * <p>
         * This command returns: <code>"GroupName": "us-west-2-den-1"</code>, specifying that the Local Zone
         * <code>us-west-2-den-1a</code> belongs to the Local Zone Group <code>us-west-2-den-1</code>.
         * </p>
         * 
         * @param localZoneGroup
         *        Specifies an Amazon Web Services Local Zone Group. </p>
         *        <p>
         *        A local Zone Group is usually the Local Zone code without the ending character. For example, if the
         *        Local Zone is <code>us-east-1-bue-1a</code> the Local Zone Group is <code>us-east-1-bue-1</code>.
         *        </p>
         *        <p>
         *        You can identify the Local Zones Group for a specific Local Zone by using the <a
         *        href="https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-availability-zones.html"
         *        >describe-availability-zones</a> CLI command:
         *        </p>
         *        <p>
         *        This command returns: <code>"GroupName": "us-west-2-den-1"</code>, specifying that the Local Zone
         *        <code>us-west-2-den-1a</code> belongs to the Local Zone Group <code>us-west-2-den-1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localZoneGroup(String localZoneGroup);

        /**
         * <p>
         * Contains the longitude and latitude for a geographic region.
         * </p>
         * 
         * @param coordinates
         *        Contains the longitude and latitude for a geographic region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coordinates(Coordinates coordinates);

        /**
         * <p>
         * Contains the longitude and latitude for a geographic region.
         * </p>
         * This is a convenience method that creates an instance of the {@link Coordinates.Builder} avoiding the need to
         * create one manually via {@link Coordinates#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Coordinates.Builder#build()} is called immediately and its result
         * is passed to {@link #coordinates(Coordinates)}.
         * 
         * @param coordinates
         *        a consumer that will call methods on {@link Coordinates.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #coordinates(Coordinates)
         */
        default Builder coordinates(Consumer<Coordinates.Builder> coordinates) {
            return coordinates(Coordinates.builder().applyMutation(coordinates).build());
        }

        /**
         * <p>
         * The bias increases or decreases the size of the geographic region from which Route 53 routes traffic to a
         * resource.
         * </p>
         * <p>
         * To use <code>Bias</code> to change the size of the geographic region, specify the applicable value for the
         * bias:
         * </p>
         * <ul>
         * <li>
         * <p>
         * To expand the size of the geographic region from which Route 53 routes traffic to a resource, specify a
         * positive integer from 1 to 99 for the bias. Route 53 shrinks the size of adjacent regions.
         * </p>
         * </li>
         * <li>
         * <p>
         * To shrink the size of the geographic region from which Route 53 routes traffic to a resource, specify a
         * negative bias of -1 to -99. Route 53 expands the size of adjacent regions.
         * </p>
         * </li>
         * </ul>
         * 
         * @param bias
         *        The bias increases or decreases the size of the geographic region from which Route 53 routes traffic
         *        to a resource. </p>
         *        <p>
         *        To use <code>Bias</code> to change the size of the geographic region, specify the applicable value for
         *        the bias:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        To expand the size of the geographic region from which Route 53 routes traffic to a resource, specify
         *        a positive integer from 1 to 99 for the bias. Route 53 shrinks the size of adjacent regions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To shrink the size of the geographic region from which Route 53 routes traffic to a resource, specify
         *        a negative bias of -1 to -99. Route 53 expands the size of adjacent regions.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bias(Integer bias);
    }

    static final class BuilderImpl implements Builder {
        private String awsRegion;

        private String localZoneGroup;

        private Coordinates coordinates;

        private Integer bias;

        private BuilderImpl() {
        }

        private BuilderImpl(GeoProximityLocation model) {
            awsRegion(model.awsRegion);
            localZoneGroup(model.localZoneGroup);
            coordinates(model.coordinates);
            bias(model.bias);
        }

        public final String getAwsRegion() {
            return awsRegion;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final String getLocalZoneGroup() {
            return localZoneGroup;
        }

        public final void setLocalZoneGroup(String localZoneGroup) {
            this.localZoneGroup = localZoneGroup;
        }

        @Override
        public final Builder localZoneGroup(String localZoneGroup) {
            this.localZoneGroup = localZoneGroup;
            return this;
        }

        public final Coordinates.Builder getCoordinates() {
            return coordinates != null ? coordinates.toBuilder() : null;
        }

        public final void setCoordinates(Coordinates.BuilderImpl coordinates) {
            this.coordinates = coordinates != null ? coordinates.build() : null;
        }

        @Override
        public final Builder coordinates(Coordinates coordinates) {
            this.coordinates = coordinates;
            return this;
        }

        public final Integer getBias() {
            return bias;
        }

        public final void setBias(Integer bias) {
            this.bias = bias;
        }

        @Override
        public final Builder bias(Integer bias) {
            this.bias = bias;
            return this;
        }

        @Override
        public GeoProximityLocation build() {
            return new GeoProximityLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
