/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that lists the coordinates for a geoproximity resource record.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Coordinates implements SdkPojo, Serializable, ToCopyableBuilder<Coordinates.Builder, Coordinates> {
    private static final SdkField<String> LATITUDE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Latitude")
            .getter(getter(Coordinates::latitude))
            .setter(setter(Builder::latitude))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Latitude")
                    .unmarshallLocationName("Latitude").build()).build();

    private static final SdkField<String> LONGITUDE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Longitude")
            .getter(getter(Coordinates::longitude))
            .setter(setter(Builder::longitude))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Longitude")
                    .unmarshallLocationName("Longitude").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LATITUDE_FIELD,
            LONGITUDE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Latitude", LATITUDE_FIELD);
                    put("Longitude", LONGITUDE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String latitude;

    private final String longitude;

    private Coordinates(BuilderImpl builder) {
        this.latitude = builder.latitude;
        this.longitude = builder.longitude;
    }

    /**
     * <p>
     * Specifies a coordinate of the north–south position of a geographic point on the surface of the Earth (-90 - 90).
     * </p>
     * 
     * @return Specifies a coordinate of the north–south position of a geographic point on the surface of the Earth (-90
     *         - 90).
     */
    public final String latitude() {
        return latitude;
    }

    /**
     * <p>
     * Specifies a coordinate of the east–west position of a geographic point on the surface of the Earth (-180 - 180).
     * </p>
     * 
     * @return Specifies a coordinate of the east–west position of a geographic point on the surface of the Earth (-180
     *         - 180).
     */
    public final String longitude() {
        return longitude;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(latitude());
        hashCode = 31 * hashCode + Objects.hashCode(longitude());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Coordinates)) {
            return false;
        }
        Coordinates other = (Coordinates) obj;
        return Objects.equals(latitude(), other.latitude()) && Objects.equals(longitude(), other.longitude());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Coordinates").add("Latitude", latitude()).add("Longitude", longitude()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Latitude":
            return Optional.ofNullable(clazz.cast(latitude()));
        case "Longitude":
            return Optional.ofNullable(clazz.cast(longitude()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Coordinates, T> g) {
        return obj -> g.apply((Coordinates) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Coordinates> {
        /**
         * <p>
         * Specifies a coordinate of the north–south position of a geographic point on the surface of the Earth (-90 -
         * 90).
         * </p>
         * 
         * @param latitude
         *        Specifies a coordinate of the north–south position of a geographic point on the surface of the Earth
         *        (-90 - 90).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latitude(String latitude);

        /**
         * <p>
         * Specifies a coordinate of the east–west position of a geographic point on the surface of the Earth (-180 -
         * 180).
         * </p>
         * 
         * @param longitude
         *        Specifies a coordinate of the east–west position of a geographic point on the surface of the Earth
         *        (-180 - 180).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longitude(String longitude);
    }

    static final class BuilderImpl implements Builder {
        private String latitude;

        private String longitude;

        private BuilderImpl() {
        }

        private BuilderImpl(Coordinates model) {
            latitude(model.latitude);
            longitude(model.longitude);
        }

        public final String getLatitude() {
            return latitude;
        }

        public final void setLatitude(String latitude) {
            this.latitude = latitude;
        }

        @Override
        public final Builder latitude(String latitude) {
            this.latitude = latitude;
            return this;
        }

        public final String getLongitude() {
            return longitude;
        }

        public final void setLongitude(String longitude) {
            this.longitude = longitude;
        }

        @Override
        public final Builder longitude(String longitude) {
            this.longitude = longitude;
            return this;
        }

        @Override
        public Coordinates build() {
            return new Coordinates(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
