/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Lists all the private hosted zones that a specified VPC is associated with, regardless of which Amazon Web Services
 * account created the hosted zones.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListHostedZonesByVpcRequest extends Route53Request implements
        ToCopyableBuilder<ListHostedZonesByVpcRequest.Builder, ListHostedZonesByVpcRequest> {
    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VPCId")
            .getter(getter(ListHostedZonesByVpcRequest::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("vpcid")
                    .unmarshallLocationName("vpcid").build()).build();

    private static final SdkField<String> VPC_REGION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VPCRegion")
            .getter(getter(ListHostedZonesByVpcRequest::vpcRegionAsString))
            .setter(setter(Builder::vpcRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("vpcregion")
                    .unmarshallLocationName("vpcregion").build()).build();

    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MaxItems")
            .getter(getter(ListHostedZonesByVpcRequest::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxitems")
                    .unmarshallLocationName("maxitems").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(ListHostedZonesByVpcRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nexttoken")
                    .unmarshallLocationName("nexttoken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ID_FIELD,
            VPC_REGION_FIELD, MAX_ITEMS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("vpcid", VPC_ID_FIELD);
                    put("vpcregion", VPC_REGION_FIELD);
                    put("maxitems", MAX_ITEMS_FIELD);
                    put("nexttoken", NEXT_TOKEN_FIELD);
                }
            });

    private final String vpcId;

    private final String vpcRegion;

    private final String maxItems;

    private final String nextToken;

    private ListHostedZonesByVpcRequest(BuilderImpl builder) {
        super(builder);
        this.vpcId = builder.vpcId;
        this.vpcRegion = builder.vpcRegion;
        this.maxItems = builder.maxItems;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ID of the Amazon VPC that you want to list hosted zones for.
     * </p>
     * 
     * @return The ID of the Amazon VPC that you want to list hosted zones for.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * For the Amazon VPC that you specified for <code>VPCId</code>, the Amazon Web Services Region that you created the
     * VPC in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vpcRegion} will
     * return {@link VPCRegion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vpcRegionAsString}.
     * </p>
     * 
     * @return For the Amazon VPC that you specified for <code>VPCId</code>, the Amazon Web Services Region that you
     *         created the VPC in.
     * @see VPCRegion
     */
    public final VPCRegion vpcRegion() {
        return VPCRegion.fromValue(vpcRegion);
    }

    /**
     * <p>
     * For the Amazon VPC that you specified for <code>VPCId</code>, the Amazon Web Services Region that you created the
     * VPC in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vpcRegion} will
     * return {@link VPCRegion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vpcRegionAsString}.
     * </p>
     * 
     * @return For the Amazon VPC that you specified for <code>VPCId</code>, the Amazon Web Services Region that you
     *         created the VPC in.
     * @see VPCRegion
     */
    public final String vpcRegionAsString() {
        return vpcRegion;
    }

    /**
     * <p>
     * (Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If the specified VPC is
     * associated with more than <code>MaxItems</code> hosted zones, the response includes a <code>NextToken</code>
     * element. <code>NextToken</code> contains an encrypted token that identifies the first hosted zone that Route 53
     * will return if you submit another request.
     * </p>
     * 
     * @return (Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If the specified
     *         VPC is associated with more than <code>MaxItems</code> hosted zones, the response includes a
     *         <code>NextToken</code> element. <code>NextToken</code> contains an encrypted token that identifies the
     *         first hosted zone that Route 53 will return if you submit another request.
     */
    public final String maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * If the previous response included a <code>NextToken</code> element, the specified VPC is associated with more
     * hosted zones. To get more hosted zones, submit another <code>ListHostedZonesByVPC</code> request.
     * </p>
     * <p>
     * For the value of <code>NextToken</code>, specify the value of <code>NextToken</code> from the previous response.
     * </p>
     * <p>
     * If the previous response didn't include a <code>NextToken</code> element, there are no more hosted zones to get.
     * </p>
     * 
     * @return If the previous response included a <code>NextToken</code> element, the specified VPC is associated with
     *         more hosted zones. To get more hosted zones, submit another <code>ListHostedZonesByVPC</code> request.
     *         </p>
     *         <p>
     *         For the value of <code>NextToken</code>, specify the value of <code>NextToken</code> from the previous
     *         response.
     *         </p>
     *         <p>
     *         If the previous response didn't include a <code>NextToken</code> element, there are no more hosted zones
     *         to get.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcRegionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHostedZonesByVpcRequest)) {
            return false;
        }
        ListHostedZonesByVpcRequest other = (ListHostedZonesByVpcRequest) obj;
        return Objects.equals(vpcId(), other.vpcId()) && Objects.equals(vpcRegionAsString(), other.vpcRegionAsString())
                && Objects.equals(maxItems(), other.maxItems()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListHostedZonesByVpcRequest").add("VPCId", vpcId()).add("VPCRegion", vpcRegionAsString())
                .add("MaxItems", maxItems()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VPCId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "VPCRegion":
            return Optional.ofNullable(clazz.cast(vpcRegionAsString()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListHostedZonesByVpcRequest, T> g) {
        return obj -> g.apply((ListHostedZonesByVpcRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Request.Builder, SdkPojo, CopyableBuilder<Builder, ListHostedZonesByVpcRequest> {
        /**
         * <p>
         * The ID of the Amazon VPC that you want to list hosted zones for.
         * </p>
         * 
         * @param vpcId
         *        The ID of the Amazon VPC that you want to list hosted zones for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * For the Amazon VPC that you specified for <code>VPCId</code>, the Amazon Web Services Region that you created
         * the VPC in.
         * </p>
         * 
         * @param vpcRegion
         *        For the Amazon VPC that you specified for <code>VPCId</code>, the Amazon Web Services Region that you
         *        created the VPC in.
         * @see VPCRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VPCRegion
         */
        Builder vpcRegion(String vpcRegion);

        /**
         * <p>
         * For the Amazon VPC that you specified for <code>VPCId</code>, the Amazon Web Services Region that you created
         * the VPC in.
         * </p>
         * 
         * @param vpcRegion
         *        For the Amazon VPC that you specified for <code>VPCId</code>, the Amazon Web Services Region that you
         *        created the VPC in.
         * @see VPCRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VPCRegion
         */
        Builder vpcRegion(VPCRegion vpcRegion);

        /**
         * <p>
         * (Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If the specified VPC
         * is associated with more than <code>MaxItems</code> hosted zones, the response includes a
         * <code>NextToken</code> element. <code>NextToken</code> contains an encrypted token that identifies the first
         * hosted zone that Route 53 will return if you submit another request.
         * </p>
         * 
         * @param maxItems
         *        (Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If the
         *        specified VPC is associated with more than <code>MaxItems</code> hosted zones, the response includes a
         *        <code>NextToken</code> element. <code>NextToken</code> contains an encrypted token that identifies the
         *        first hosted zone that Route 53 will return if you submit another request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);

        /**
         * <p>
         * If the previous response included a <code>NextToken</code> element, the specified VPC is associated with more
         * hosted zones. To get more hosted zones, submit another <code>ListHostedZonesByVPC</code> request.
         * </p>
         * <p>
         * For the value of <code>NextToken</code>, specify the value of <code>NextToken</code> from the previous
         * response.
         * </p>
         * <p>
         * If the previous response didn't include a <code>NextToken</code> element, there are no more hosted zones to
         * get.
         * </p>
         * 
         * @param nextToken
         *        If the previous response included a <code>NextToken</code> element, the specified VPC is associated
         *        with more hosted zones. To get more hosted zones, submit another <code>ListHostedZonesByVPC</code>
         *        request. </p>
         *        <p>
         *        For the value of <code>NextToken</code>, specify the value of <code>NextToken</code> from the previous
         *        response.
         *        </p>
         *        <p>
         *        If the previous response didn't include a <code>NextToken</code> element, there are no more hosted
         *        zones to get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String vpcId;

        private String vpcRegion;

        private String maxItems;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHostedZonesByVpcRequest model) {
            super(model);
            vpcId(model.vpcId);
            vpcRegion(model.vpcRegion);
            maxItems(model.maxItems);
            nextToken(model.nextToken);
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getVpcRegion() {
            return vpcRegion;
        }

        public final void setVpcRegion(String vpcRegion) {
            this.vpcRegion = vpcRegion;
        }

        @Override
        public final Builder vpcRegion(String vpcRegion) {
            this.vpcRegion = vpcRegion;
            return this;
        }

        @Override
        public final Builder vpcRegion(VPCRegion vpcRegion) {
            this.vpcRegion(vpcRegion == null ? null : vpcRegion.toString());
            return this;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListHostedZonesByVpcRequest build() {
            return new ListHostedZonesByVpcRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
