/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateKeySigningKeyRequest extends Route53Request implements
        ToCopyableBuilder<CreateKeySigningKeyRequest.Builder, CreateKeySigningKeyRequest> {
    private static final SdkField<String> CALLER_REFERENCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CallerReference")
            .getter(getter(CreateKeySigningKeyRequest::callerReference))
            .setter(setter(Builder::callerReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallerReference")
                    .unmarshallLocationName("CallerReference").build()).build();

    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HostedZoneId")
            .getter(getter(CreateKeySigningKeyRequest::hostedZoneId))
            .setter(setter(Builder::hostedZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneId")
                    .unmarshallLocationName("HostedZoneId").build()).build();

    private static final SdkField<String> KEY_MANAGEMENT_SERVICE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KeyManagementServiceArn")
            .getter(getter(CreateKeySigningKeyRequest::keyManagementServiceArn))
            .setter(setter(Builder::keyManagementServiceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyManagementServiceArn")
                    .unmarshallLocationName("KeyManagementServiceArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(CreateKeySigningKeyRequest::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(CreateKeySigningKeyRequest::status))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALLER_REFERENCE_FIELD,
            HOSTED_ZONE_ID_FIELD, KEY_MANAGEMENT_SERVICE_ARN_FIELD, NAME_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("CallerReference", CALLER_REFERENCE_FIELD);
                    put("HostedZoneId", HOSTED_ZONE_ID_FIELD);
                    put("KeyManagementServiceArn", KEY_MANAGEMENT_SERVICE_ARN_FIELD);
                    put("Name", NAME_FIELD);
                    put("Status", STATUS_FIELD);
                }
            });

    private final String callerReference;

    private final String hostedZoneId;

    private final String keyManagementServiceArn;

    private final String name;

    private final String status;

    private CreateKeySigningKeyRequest(BuilderImpl builder) {
        super(builder);
        this.callerReference = builder.callerReference;
        this.hostedZoneId = builder.hostedZoneId;
        this.keyManagementServiceArn = builder.keyManagementServiceArn;
        this.name = builder.name;
        this.status = builder.status;
    }

    /**
     * <p>
     * A unique string that identifies the request.
     * </p>
     * 
     * @return A unique string that identifies the request.
     */
    public final String callerReference() {
        return callerReference;
    }

    /**
     * <p>
     * The unique string (ID) used to identify a hosted zone.
     * </p>
     * 
     * @return The unique string (ID) used to identify a hosted zone.
     */
    public final String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * The Amazon resource name (ARN) for a customer managed key in Key Management Service (KMS). The
     * <code>KeyManagementServiceArn</code> must be unique for each key-signing key (KSK) in a single hosted zone. To
     * see an example of <code>KeyManagementServiceArn</code> that grants the correct permissions for DNSSEC, scroll
     * down to <b>Example</b>.
     * </p>
     * <p>
     * You must configure the customer managed customer managed key as follows:
     * </p>
     * <dl>
     * <dt>Status</dt>
     * <dd>
     * <p>
     * Enabled
     * </p>
     * </dd>
     * <dt>Key spec</dt>
     * <dd>
     * <p>
     * ECC_NIST_P256
     * </p>
     * </dd>
     * <dt>Key usage</dt>
     * <dd>
     * <p>
     * Sign and verify
     * </p>
     * </dd>
     * <dt>Key policy</dt>
     * <dd>
     * <p>
     * The key policy must give permission for the following actions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * DescribeKey
     * </p>
     * </li>
     * <li>
     * <p>
     * GetPublicKey
     * </p>
     * </li>
     * <li>
     * <p>
     * Sign
     * </p>
     * </li>
     * </ul>
     * <p>
     * The key policy must also include the Amazon Route 53 service in the principal for your account. Specify the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>"Service": "dnssec-route53.amazonaws.com"</code>
     * </p>
     * </li>
     * </ul>
     * </dd>
     * </dl>
     * <p>
     * For more information about working with a customer managed key in KMS, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html">Key Management Service concepts</a>.
     * </p>
     * 
     * @return The Amazon resource name (ARN) for a customer managed key in Key Management Service (KMS). The
     *         <code>KeyManagementServiceArn</code> must be unique for each key-signing key (KSK) in a single hosted
     *         zone. To see an example of <code>KeyManagementServiceArn</code> that grants the correct permissions for
     *         DNSSEC, scroll down to <b>Example</b>. </p>
     *         <p>
     *         You must configure the customer managed customer managed key as follows:
     *         </p>
     *         <dl>
     *         <dt>Status</dt>
     *         <dd>
     *         <p>
     *         Enabled
     *         </p>
     *         </dd>
     *         <dt>Key spec</dt>
     *         <dd>
     *         <p>
     *         ECC_NIST_P256
     *         </p>
     *         </dd>
     *         <dt>Key usage</dt>
     *         <dd>
     *         <p>
     *         Sign and verify
     *         </p>
     *         </dd>
     *         <dt>Key policy</dt>
     *         <dd>
     *         <p>
     *         The key policy must give permission for the following actions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         DescribeKey
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GetPublicKey
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Sign
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The key policy must also include the Amazon Route 53 service in the principal for your account. Specify
     *         the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>"Service": "dnssec-route53.amazonaws.com"</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         </dl>
     *         <p>
     *         For more information about working with a customer managed key in KMS, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html">Key Management Service
     *         concepts</a>.
     */
    public final String keyManagementServiceArn() {
        return keyManagementServiceArn;
    }

    /**
     * <p>
     * A string used to identify a key-signing key (KSK). <code>Name</code> can include numbers, letters, and
     * underscores (_). <code>Name</code> must be unique for each key-signing key in the same hosted zone.
     * </p>
     * 
     * @return A string used to identify a key-signing key (KSK). <code>Name</code> can include numbers, letters, and
     *         underscores (_). <code>Name</code> must be unique for each key-signing key in the same hosted zone.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A string specifying the initial status of the key-signing key (KSK). You can set the value to <code>ACTIVE</code>
     * or <code>INACTIVE</code>.
     * </p>
     * 
     * @return A string specifying the initial status of the key-signing key (KSK). You can set the value to
     *         <code>ACTIVE</code> or <code>INACTIVE</code>.
     */
    public final String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(keyManagementServiceArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKeySigningKeyRequest)) {
            return false;
        }
        CreateKeySigningKeyRequest other = (CreateKeySigningKeyRequest) obj;
        return Objects.equals(callerReference(), other.callerReference()) && Objects.equals(hostedZoneId(), other.hostedZoneId())
                && Objects.equals(keyManagementServiceArn(), other.keyManagementServiceArn())
                && Objects.equals(name(), other.name()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateKeySigningKeyRequest").add("CallerReference", callerReference())
                .add("HostedZoneId", hostedZoneId()).add("KeyManagementServiceArn", keyManagementServiceArn())
                .add("Name", name()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CallerReference":
            return Optional.ofNullable(clazz.cast(callerReference()));
        case "HostedZoneId":
            return Optional.ofNullable(clazz.cast(hostedZoneId()));
        case "KeyManagementServiceArn":
            return Optional.ofNullable(clazz.cast(keyManagementServiceArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateKeySigningKeyRequest, T> g) {
        return obj -> g.apply((CreateKeySigningKeyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateKeySigningKeyRequest> {
        /**
         * <p>
         * A unique string that identifies the request.
         * </p>
         * 
         * @param callerReference
         *        A unique string that identifies the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerReference(String callerReference);

        /**
         * <p>
         * The unique string (ID) used to identify a hosted zone.
         * </p>
         * 
         * @param hostedZoneId
         *        The unique string (ID) used to identify a hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * The Amazon resource name (ARN) for a customer managed key in Key Management Service (KMS). The
         * <code>KeyManagementServiceArn</code> must be unique for each key-signing key (KSK) in a single hosted zone.
         * To see an example of <code>KeyManagementServiceArn</code> that grants the correct permissions for DNSSEC,
         * scroll down to <b>Example</b>.
         * </p>
         * <p>
         * You must configure the customer managed customer managed key as follows:
         * </p>
         * <dl>
         * <dt>Status</dt>
         * <dd>
         * <p>
         * Enabled
         * </p>
         * </dd>
         * <dt>Key spec</dt>
         * <dd>
         * <p>
         * ECC_NIST_P256
         * </p>
         * </dd>
         * <dt>Key usage</dt>
         * <dd>
         * <p>
         * Sign and verify
         * </p>
         * </dd>
         * <dt>Key policy</dt>
         * <dd>
         * <p>
         * The key policy must give permission for the following actions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * DescribeKey
         * </p>
         * </li>
         * <li>
         * <p>
         * GetPublicKey
         * </p>
         * </li>
         * <li>
         * <p>
         * Sign
         * </p>
         * </li>
         * </ul>
         * <p>
         * The key policy must also include the Amazon Route 53 service in the principal for your account. Specify the
         * following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>"Service": "dnssec-route53.amazonaws.com"</code>
         * </p>
         * </li>
         * </ul>
         * </dd>
         * </dl>
         * <p>
         * For more information about working with a customer managed key in KMS, see <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html">Key Management Service
         * concepts</a>.
         * </p>
         * 
         * @param keyManagementServiceArn
         *        The Amazon resource name (ARN) for a customer managed key in Key Management Service (KMS). The
         *        <code>KeyManagementServiceArn</code> must be unique for each key-signing key (KSK) in a single hosted
         *        zone. To see an example of <code>KeyManagementServiceArn</code> that grants the correct permissions
         *        for DNSSEC, scroll down to <b>Example</b>. </p>
         *        <p>
         *        You must configure the customer managed customer managed key as follows:
         *        </p>
         *        <dl>
         *        <dt>Status</dt>
         *        <dd>
         *        <p>
         *        Enabled
         *        </p>
         *        </dd>
         *        <dt>Key spec</dt>
         *        <dd>
         *        <p>
         *        ECC_NIST_P256
         *        </p>
         *        </dd>
         *        <dt>Key usage</dt>
         *        <dd>
         *        <p>
         *        Sign and verify
         *        </p>
         *        </dd>
         *        <dt>Key policy</dt>
         *        <dd>
         *        <p>
         *        The key policy must give permission for the following actions:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        DescribeKey
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GetPublicKey
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Sign
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The key policy must also include the Amazon Route 53 service in the principal for your account.
         *        Specify the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>"Service": "dnssec-route53.amazonaws.com"</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        </dl>
         *        <p>
         *        For more information about working with a customer managed key in KMS, see <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html">Key Management Service
         *        concepts</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyManagementServiceArn(String keyManagementServiceArn);

        /**
         * <p>
         * A string used to identify a key-signing key (KSK). <code>Name</code> can include numbers, letters, and
         * underscores (_). <code>Name</code> must be unique for each key-signing key in the same hosted zone.
         * </p>
         * 
         * @param name
         *        A string used to identify a key-signing key (KSK). <code>Name</code> can include numbers, letters, and
         *        underscores (_). <code>Name</code> must be unique for each key-signing key in the same hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A string specifying the initial status of the key-signing key (KSK). You can set the value to
         * <code>ACTIVE</code> or <code>INACTIVE</code>.
         * </p>
         * 
         * @param status
         *        A string specifying the initial status of the key-signing key (KSK). You can set the value to
         *        <code>ACTIVE</code> or <code>INACTIVE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String callerReference;

        private String hostedZoneId;

        private String keyManagementServiceArn;

        private String name;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKeySigningKeyRequest model) {
            super(model);
            callerReference(model.callerReference);
            hostedZoneId(model.hostedZoneId);
            keyManagementServiceArn(model.keyManagementServiceArn);
            name(model.name);
            status(model.status);
        }

        public final String getCallerReference() {
            return callerReference;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final String getKeyManagementServiceArn() {
            return keyManagementServiceArn;
        }

        public final void setKeyManagementServiceArn(String keyManagementServiceArn) {
            this.keyManagementServiceArn = keyManagementServiceArn;
        }

        @Override
        public final Builder keyManagementServiceArn(String keyManagementServiceArn) {
            this.keyManagementServiceArn = keyManagementServiceArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateKeySigningKeyRequest build() {
            return new CreateKeySigningKeyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
