/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response to the <code>GetReusableDelegationSet</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetReusableDelegationSetResponse extends Route53Response implements
        ToCopyableBuilder<GetReusableDelegationSetResponse.Builder, GetReusableDelegationSetResponse> {
    private static final SdkField<DelegationSet> DELEGATION_SET_FIELD = SdkField
            .<DelegationSet> builder(MarshallingType.SDK_POJO)
            .memberName("DelegationSet")
            .getter(getter(GetReusableDelegationSetResponse::delegationSet))
            .setter(setter(Builder::delegationSet))
            .constructor(DelegationSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DelegationSet")
                    .unmarshallLocationName("DelegationSet").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELEGATION_SET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DelegationSet", DELEGATION_SET_FIELD);
                }
            });

    private final DelegationSet delegationSet;

    private GetReusableDelegationSetResponse(BuilderImpl builder) {
        super(builder);
        this.delegationSet = builder.delegationSet;
    }

    /**
     * <p>
     * A complex type that contains information about the reusable delegation set.
     * </p>
     * 
     * @return A complex type that contains information about the reusable delegation set.
     */
    public final DelegationSet delegationSet() {
        return delegationSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(delegationSet());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReusableDelegationSetResponse)) {
            return false;
        }
        GetReusableDelegationSetResponse other = (GetReusableDelegationSetResponse) obj;
        return Objects.equals(delegationSet(), other.delegationSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetReusableDelegationSetResponse").add("DelegationSet", delegationSet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DelegationSet":
            return Optional.ofNullable(clazz.cast(delegationSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetReusableDelegationSetResponse, T> g) {
        return obj -> g.apply((GetReusableDelegationSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo, CopyableBuilder<Builder, GetReusableDelegationSetResponse> {
        /**
         * <p>
         * A complex type that contains information about the reusable delegation set.
         * </p>
         * 
         * @param delegationSet
         *        A complex type that contains information about the reusable delegation set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegationSet(DelegationSet delegationSet);

        /**
         * <p>
         * A complex type that contains information about the reusable delegation set.
         * </p>
         * This is a convenience method that creates an instance of the {@link DelegationSet.Builder} avoiding the need
         * to create one manually via {@link DelegationSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DelegationSet.Builder#build()} is called immediately and its
         * result is passed to {@link #delegationSet(DelegationSet)}.
         * 
         * @param delegationSet
         *        a consumer that will call methods on {@link DelegationSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #delegationSet(DelegationSet)
         */
        default Builder delegationSet(Consumer<DelegationSet.Builder> delegationSet) {
            return delegationSet(DelegationSet.builder().applyMutation(delegationSet).build());
        }
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private DelegationSet delegationSet;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReusableDelegationSetResponse model) {
            super(model);
            delegationSet(model.delegationSet);
        }

        public final DelegationSet.Builder getDelegationSet() {
            return delegationSet != null ? delegationSet.toBuilder() : null;
        }

        public final void setDelegationSet(DelegationSet.BuilderImpl delegationSet) {
            this.delegationSet = delegationSet != null ? delegationSet.build() : null;
        }

        @Override
        public final Builder delegationSet(DelegationSet delegationSet) {
            this.delegationSet = delegationSet;
            return this;
        }

        @Override
        public GetReusableDelegationSetResponse build() {
            return new GetReusableDelegationSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
