/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the traffic policy that you want to update the comment for.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTrafficPolicyCommentRequest extends Route53Request implements
        ToCopyableBuilder<UpdateTrafficPolicyCommentRequest.Builder, UpdateTrafficPolicyCommentRequest> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(UpdateTrafficPolicyCommentRequest::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<Integer> VERSION_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Version")
            .getter(getter(UpdateTrafficPolicyCommentRequest::version))
            .setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Version")
                    .unmarshallLocationName("Version").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Comment")
            .getter(getter(UpdateTrafficPolicyCommentRequest::comment))
            .setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment")
                    .unmarshallLocationName("Comment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, VERSION_FIELD,
            COMMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Id", ID_FIELD);
                    put("Version", VERSION_FIELD);
                    put("Comment", COMMENT_FIELD);
                }
            });

    private final String id;

    private final Integer version;

    private final String comment;

    private UpdateTrafficPolicyCommentRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.version = builder.version;
        this.comment = builder.comment;
    }

    /**
     * <p>
     * The value of <code>Id</code> for the traffic policy that you want to update the comment for.
     * </p>
     * 
     * @return The value of <code>Id</code> for the traffic policy that you want to update the comment for.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The value of <code>Version</code> for the traffic policy that you want to update the comment for.
     * </p>
     * 
     * @return The value of <code>Version</code> for the traffic policy that you want to update the comment for.
     */
    public final Integer version() {
        return version;
    }

    /**
     * <p>
     * The new comment for the specified traffic policy and version.
     * </p>
     * 
     * @return The new comment for the specified traffic policy and version.
     */
    public final String comment() {
        return comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrafficPolicyCommentRequest)) {
            return false;
        }
        UpdateTrafficPolicyCommentRequest other = (UpdateTrafficPolicyCommentRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(version(), other.version())
                && Objects.equals(comment(), other.comment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTrafficPolicyCommentRequest").add("Id", id()).add("Version", version())
                .add("Comment", comment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTrafficPolicyCommentRequest, T> g) {
        return obj -> g.apply((UpdateTrafficPolicyCommentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Request.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTrafficPolicyCommentRequest> {
        /**
         * <p>
         * The value of <code>Id</code> for the traffic policy that you want to update the comment for.
         * </p>
         * 
         * @param id
         *        The value of <code>Id</code> for the traffic policy that you want to update the comment for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The value of <code>Version</code> for the traffic policy that you want to update the comment for.
         * </p>
         * 
         * @param version
         *        The value of <code>Version</code> for the traffic policy that you want to update the comment for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Integer version);

        /**
         * <p>
         * The new comment for the specified traffic policy and version.
         * </p>
         * 
         * @param comment
         *        The new comment for the specified traffic policy and version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String id;

        private Integer version;

        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrafficPolicyCommentRequest model) {
            super(model);
            id(model.id);
            version(model.version);
            comment(model.comment);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Integer getVersion() {
            return version;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTrafficPolicyCommentRequest build() {
            return new UpdateTrafficPolicyCommentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
