/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Gets the value that Amazon Route 53 returns in response to a DNS request for a specified record name and type. You
 * can optionally specify the IP address of a DNS resolver, an EDNS0 client subnet IP address, and a subnet mask.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestDnsAnswerRequest extends Route53Request implements
        ToCopyableBuilder<TestDnsAnswerRequest.Builder, TestDnsAnswerRequest> {
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HostedZoneId")
            .getter(getter(TestDnsAnswerRequest::hostedZoneId))
            .setter(setter(Builder::hostedZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("hostedzoneid")
                    .unmarshallLocationName("hostedzoneid").build()).build();

    private static final SdkField<String> RECORD_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RecordName")
            .getter(getter(TestDnsAnswerRequest::recordName))
            .setter(setter(Builder::recordName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("recordname")
                    .unmarshallLocationName("recordname").build()).build();

    private static final SdkField<String> RECORD_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RecordType")
            .getter(getter(TestDnsAnswerRequest::recordTypeAsString))
            .setter(setter(Builder::recordType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("recordtype")
                    .unmarshallLocationName("recordtype").build()).build();

    private static final SdkField<String> RESOLVER_IP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResolverIP")
            .getter(getter(TestDnsAnswerRequest::resolverIP))
            .setter(setter(Builder::resolverIP))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resolverip")
                    .unmarshallLocationName("resolverip").build()).build();

    private static final SdkField<String> EDNS0_CLIENT_SUBNET_IP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EDNS0ClientSubnetIP")
            .getter(getter(TestDnsAnswerRequest::edns0ClientSubnetIP))
            .setter(setter(Builder::edns0ClientSubnetIP))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("edns0clientsubnetip")
                    .unmarshallLocationName("edns0clientsubnetip").build()).build();

    private static final SdkField<String> EDNS0_CLIENT_SUBNET_MASK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EDNS0ClientSubnetMask")
            .getter(getter(TestDnsAnswerRequest::edns0ClientSubnetMask))
            .setter(setter(Builder::edns0ClientSubnetMask))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("edns0clientsubnetmask")
                    .unmarshallLocationName("edns0clientsubnetmask").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(HOSTED_ZONE_ID_FIELD, RECORD_NAME_FIELD, RECORD_TYPE_FIELD, RESOLVER_IP_FIELD, EDNS0_CLIENT_SUBNET_IP_FIELD,
                    EDNS0_CLIENT_SUBNET_MASK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("hostedzoneid", HOSTED_ZONE_ID_FIELD);
                    put("recordname", RECORD_NAME_FIELD);
                    put("recordtype", RECORD_TYPE_FIELD);
                    put("resolverip", RESOLVER_IP_FIELD);
                    put("edns0clientsubnetip", EDNS0_CLIENT_SUBNET_IP_FIELD);
                    put("edns0clientsubnetmask", EDNS0_CLIENT_SUBNET_MASK_FIELD);
                }
            });

    private final String hostedZoneId;

    private final String recordName;

    private final String recordType;

    private final String resolverIP;

    private final String edns0ClientSubnetIP;

    private final String edns0ClientSubnetMask;

    private TestDnsAnswerRequest(BuilderImpl builder) {
        super(builder);
        this.hostedZoneId = builder.hostedZoneId;
        this.recordName = builder.recordName;
        this.recordType = builder.recordType;
        this.resolverIP = builder.resolverIP;
        this.edns0ClientSubnetIP = builder.edns0ClientSubnetIP;
        this.edns0ClientSubnetMask = builder.edns0ClientSubnetMask;
    }

    /**
     * <p>
     * The ID of the hosted zone that you want Amazon Route 53 to simulate a query for.
     * </p>
     * 
     * @return The ID of the hosted zone that you want Amazon Route 53 to simulate a query for.
     */
    public final String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * The name of the resource record set that you want Amazon Route 53 to simulate a query for.
     * </p>
     * 
     * @return The name of the resource record set that you want Amazon Route 53 to simulate a query for.
     */
    public final String recordName() {
        return recordName;
    }

    /**
     * <p>
     * The type of the resource record set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recordType} will
     * return {@link RRType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #recordTypeAsString}.
     * </p>
     * 
     * @return The type of the resource record set.
     * @see RRType
     */
    public final RRType recordType() {
        return RRType.fromValue(recordType);
    }

    /**
     * <p>
     * The type of the resource record set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recordType} will
     * return {@link RRType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #recordTypeAsString}.
     * </p>
     * 
     * @return The type of the resource record set.
     * @see RRType
     */
    public final String recordTypeAsString() {
        return recordType;
    }

    /**
     * <p>
     * If you want to simulate a request from a specific DNS resolver, specify the IP address for that resolver. If you
     * omit this value, <code>TestDnsAnswer</code> uses the IP address of a DNS resolver in the Amazon Web Services US
     * East (N. Virginia) Region (<code>us-east-1</code>).
     * </p>
     * 
     * @return If you want to simulate a request from a specific DNS resolver, specify the IP address for that resolver.
     *         If you omit this value, <code>TestDnsAnswer</code> uses the IP address of a DNS resolver in the Amazon
     *         Web Services US East (N. Virginia) Region (<code>us-east-1</code>).
     */
    public final String resolverIP() {
        return resolverIP;
    }

    /**
     * <p>
     * If the resolver that you specified for resolverip supports EDNS0, specify the IPv4 or IPv6 address of a client in
     * the applicable location, for example, <code>192.0.2.44</code> or <code>2001:db8:85a3::8a2e:370:7334</code>.
     * </p>
     * 
     * @return If the resolver that you specified for resolverip supports EDNS0, specify the IPv4 or IPv6 address of a
     *         client in the applicable location, for example, <code>192.0.2.44</code> or
     *         <code>2001:db8:85a3::8a2e:370:7334</code>.
     */
    public final String edns0ClientSubnetIP() {
        return edns0ClientSubnetIP;
    }

    /**
     * <p>
     * If you specify an IP address for <code>edns0clientsubnetip</code>, you can optionally specify the number of bits
     * of the IP address that you want the checking tool to include in the DNS query. For example, if you specify
     * <code>192.0.2.44</code> for <code>edns0clientsubnetip</code> and <code>24</code> for
     * <code>edns0clientsubnetmask</code>, the checking tool will simulate a request from 192.0.2.0/24. The default
     * value is 24 bits for IPv4 addresses and 64 bits for IPv6 addresses.
     * </p>
     * <p>
     * The range of valid values depends on whether <code>edns0clientsubnetip</code> is an IPv4 or an IPv6 address:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>IPv4</b>: Specify a value between 0 and 32
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>IPv6</b>: Specify a value between 0 and 128
     * </p>
     * </li>
     * </ul>
     * 
     * @return If you specify an IP address for <code>edns0clientsubnetip</code>, you can optionally specify the number
     *         of bits of the IP address that you want the checking tool to include in the DNS query. For example, if
     *         you specify <code>192.0.2.44</code> for <code>edns0clientsubnetip</code> and <code>24</code> for
     *         <code>edns0clientsubnetmask</code>, the checking tool will simulate a request from 192.0.2.0/24. The
     *         default value is 24 bits for IPv4 addresses and 64 bits for IPv6 addresses.</p>
     *         <p>
     *         The range of valid values depends on whether <code>edns0clientsubnetip</code> is an IPv4 or an IPv6
     *         address:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>IPv4</b>: Specify a value between 0 and 32
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>IPv6</b>: Specify a value between 0 and 128
     *         </p>
     *         </li>
     */
    public final String edns0ClientSubnetMask() {
        return edns0ClientSubnetMask;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(recordName());
        hashCode = 31 * hashCode + Objects.hashCode(recordTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resolverIP());
        hashCode = 31 * hashCode + Objects.hashCode(edns0ClientSubnetIP());
        hashCode = 31 * hashCode + Objects.hashCode(edns0ClientSubnetMask());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestDnsAnswerRequest)) {
            return false;
        }
        TestDnsAnswerRequest other = (TestDnsAnswerRequest) obj;
        return Objects.equals(hostedZoneId(), other.hostedZoneId()) && Objects.equals(recordName(), other.recordName())
                && Objects.equals(recordTypeAsString(), other.recordTypeAsString())
                && Objects.equals(resolverIP(), other.resolverIP())
                && Objects.equals(edns0ClientSubnetIP(), other.edns0ClientSubnetIP())
                && Objects.equals(edns0ClientSubnetMask(), other.edns0ClientSubnetMask());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestDnsAnswerRequest").add("HostedZoneId", hostedZoneId()).add("RecordName", recordName())
                .add("RecordType", recordTypeAsString()).add("ResolverIP", resolverIP())
                .add("EDNS0ClientSubnetIP", edns0ClientSubnetIP()).add("EDNS0ClientSubnetMask", edns0ClientSubnetMask()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostedZoneId":
            return Optional.ofNullable(clazz.cast(hostedZoneId()));
        case "RecordName":
            return Optional.ofNullable(clazz.cast(recordName()));
        case "RecordType":
            return Optional.ofNullable(clazz.cast(recordTypeAsString()));
        case "ResolverIP":
            return Optional.ofNullable(clazz.cast(resolverIP()));
        case "EDNS0ClientSubnetIP":
            return Optional.ofNullable(clazz.cast(edns0ClientSubnetIP()));
        case "EDNS0ClientSubnetMask":
            return Optional.ofNullable(clazz.cast(edns0ClientSubnetMask()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TestDnsAnswerRequest, T> g) {
        return obj -> g.apply((TestDnsAnswerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Request.Builder, SdkPojo, CopyableBuilder<Builder, TestDnsAnswerRequest> {
        /**
         * <p>
         * The ID of the hosted zone that you want Amazon Route 53 to simulate a query for.
         * </p>
         * 
         * @param hostedZoneId
         *        The ID of the hosted zone that you want Amazon Route 53 to simulate a query for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * The name of the resource record set that you want Amazon Route 53 to simulate a query for.
         * </p>
         * 
         * @param recordName
         *        The name of the resource record set that you want Amazon Route 53 to simulate a query for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordName(String recordName);

        /**
         * <p>
         * The type of the resource record set.
         * </p>
         * 
         * @param recordType
         *        The type of the resource record set.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder recordType(String recordType);

        /**
         * <p>
         * The type of the resource record set.
         * </p>
         * 
         * @param recordType
         *        The type of the resource record set.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder recordType(RRType recordType);

        /**
         * <p>
         * If you want to simulate a request from a specific DNS resolver, specify the IP address for that resolver. If
         * you omit this value, <code>TestDnsAnswer</code> uses the IP address of a DNS resolver in the Amazon Web
         * Services US East (N. Virginia) Region (<code>us-east-1</code>).
         * </p>
         * 
         * @param resolverIP
         *        If you want to simulate a request from a specific DNS resolver, specify the IP address for that
         *        resolver. If you omit this value, <code>TestDnsAnswer</code> uses the IP address of a DNS resolver in
         *        the Amazon Web Services US East (N. Virginia) Region (<code>us-east-1</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverIP(String resolverIP);

        /**
         * <p>
         * If the resolver that you specified for resolverip supports EDNS0, specify the IPv4 or IPv6 address of a
         * client in the applicable location, for example, <code>192.0.2.44</code> or
         * <code>2001:db8:85a3::8a2e:370:7334</code>.
         * </p>
         * 
         * @param edns0ClientSubnetIP
         *        If the resolver that you specified for resolverip supports EDNS0, specify the IPv4 or IPv6 address of
         *        a client in the applicable location, for example, <code>192.0.2.44</code> or
         *        <code>2001:db8:85a3::8a2e:370:7334</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edns0ClientSubnetIP(String edns0ClientSubnetIP);

        /**
         * <p>
         * If you specify an IP address for <code>edns0clientsubnetip</code>, you can optionally specify the number of
         * bits of the IP address that you want the checking tool to include in the DNS query. For example, if you
         * specify <code>192.0.2.44</code> for <code>edns0clientsubnetip</code> and <code>24</code> for
         * <code>edns0clientsubnetmask</code>, the checking tool will simulate a request from 192.0.2.0/24. The default
         * value is 24 bits for IPv4 addresses and 64 bits for IPv6 addresses.
         * </p>
         * <p>
         * The range of valid values depends on whether <code>edns0clientsubnetip</code> is an IPv4 or an IPv6 address:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>IPv4</b>: Specify a value between 0 and 32
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>IPv6</b>: Specify a value between 0 and 128
         * </p>
         * </li>
         * </ul>
         * 
         * @param edns0ClientSubnetMask
         *        If you specify an IP address for <code>edns0clientsubnetip</code>, you can optionally specify the
         *        number of bits of the IP address that you want the checking tool to include in the DNS query. For
         *        example, if you specify <code>192.0.2.44</code> for <code>edns0clientsubnetip</code> and
         *        <code>24</code> for <code>edns0clientsubnetmask</code>, the checking tool will simulate a request from
         *        192.0.2.0/24. The default value is 24 bits for IPv4 addresses and 64 bits for IPv6 addresses.</p>
         *        <p>
         *        The range of valid values depends on whether <code>edns0clientsubnetip</code> is an IPv4 or an IPv6
         *        address:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>IPv4</b>: Specify a value between 0 and 32
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>IPv6</b>: Specify a value between 0 and 128
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edns0ClientSubnetMask(String edns0ClientSubnetMask);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String hostedZoneId;

        private String recordName;

        private String recordType;

        private String resolverIP;

        private String edns0ClientSubnetIP;

        private String edns0ClientSubnetMask;

        private BuilderImpl() {
        }

        private BuilderImpl(TestDnsAnswerRequest model) {
            super(model);
            hostedZoneId(model.hostedZoneId);
            recordName(model.recordName);
            recordType(model.recordType);
            resolverIP(model.resolverIP);
            edns0ClientSubnetIP(model.edns0ClientSubnetIP);
            edns0ClientSubnetMask(model.edns0ClientSubnetMask);
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final String getRecordName() {
            return recordName;
        }

        public final void setRecordName(String recordName) {
            this.recordName = recordName;
        }

        @Override
        public final Builder recordName(String recordName) {
            this.recordName = recordName;
            return this;
        }

        public final String getRecordType() {
            return recordType;
        }

        public final void setRecordType(String recordType) {
            this.recordType = recordType;
        }

        @Override
        public final Builder recordType(String recordType) {
            this.recordType = recordType;
            return this;
        }

        @Override
        public final Builder recordType(RRType recordType) {
            this.recordType(recordType == null ? null : recordType.toString());
            return this;
        }

        public final String getResolverIP() {
            return resolverIP;
        }

        public final void setResolverIP(String resolverIP) {
            this.resolverIP = resolverIP;
        }

        @Override
        public final Builder resolverIP(String resolverIP) {
            this.resolverIP = resolverIP;
            return this;
        }

        public final String getEdns0ClientSubnetIP() {
            return edns0ClientSubnetIP;
        }

        public final void setEdns0ClientSubnetIP(String edns0ClientSubnetIP) {
            this.edns0ClientSubnetIP = edns0ClientSubnetIP;
        }

        @Override
        public final Builder edns0ClientSubnetIP(String edns0ClientSubnetIP) {
            this.edns0ClientSubnetIP = edns0ClientSubnetIP;
            return this;
        }

        public final String getEdns0ClientSubnetMask() {
            return edns0ClientSubnetMask;
        }

        public final void setEdns0ClientSubnetMask(String edns0ClientSubnetMask) {
            this.edns0ClientSubnetMask = edns0ClientSubnetMask;
        }

        @Override
        public final Builder edns0ClientSubnetMask(String edns0ClientSubnetMask) {
            this.edns0ClientSubnetMask = edns0ClientSubnetMask;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestDnsAnswerRequest build() {
            return new TestDnsAnswerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
