/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateQueryLoggingConfigRequest extends Route53Request implements
        ToCopyableBuilder<CreateQueryLoggingConfigRequest.Builder, CreateQueryLoggingConfigRequest> {
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HostedZoneId")
            .getter(getter(CreateQueryLoggingConfigRequest::hostedZoneId))
            .setter(setter(Builder::hostedZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneId")
                    .unmarshallLocationName("HostedZoneId").build()).build();

    private static final SdkField<String> CLOUD_WATCH_LOGS_LOG_GROUP_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CloudWatchLogsLogGroupArn")
            .getter(getter(CreateQueryLoggingConfigRequest::cloudWatchLogsLogGroupArn))
            .setter(setter(Builder::cloudWatchLogsLogGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogsLogGroupArn")
                    .unmarshallLocationName("CloudWatchLogsLogGroupArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONE_ID_FIELD,
            CLOUD_WATCH_LOGS_LOG_GROUP_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("HostedZoneId", HOSTED_ZONE_ID_FIELD);
                    put("CloudWatchLogsLogGroupArn", CLOUD_WATCH_LOGS_LOG_GROUP_ARN_FIELD);
                }
            });

    private final String hostedZoneId;

    private final String cloudWatchLogsLogGroupArn;

    private CreateQueryLoggingConfigRequest(BuilderImpl builder) {
        super(builder);
        this.hostedZoneId = builder.hostedZoneId;
        this.cloudWatchLogsLogGroupArn = builder.cloudWatchLogsLogGroupArn;
    }

    /**
     * <p>
     * The ID of the hosted zone that you want to log queries for. You can log queries only for public hosted zones.
     * </p>
     * 
     * @return The ID of the hosted zone that you want to log queries for. You can log queries only for public hosted
     *         zones.
     */
    public final String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the log group that you want to Amazon Route 53 to send query logs to. This is
     * the format of the ARN:
     * </p>
     * <p>
     * arn:aws:logs:<i>region</i>:<i>account-id</i>:log-group:<i>log_group_name</i>
     * </p>
     * <p>
     * To get the ARN for a log group, you can use the CloudWatch console, the <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeLogGroups.html"
     * >DescribeLogGroups</a> API action, the <a
     * href="https://docs.aws.amazon.com/cli/latest/reference/logs/describe-log-groups.html">describe-log-groups</a>
     * command, or the applicable command in one of the Amazon Web Services SDKs.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the log group that you want to Amazon Route 53 to send query logs to.
     *         This is the format of the ARN:</p>
     *         <p>
     *         arn:aws:logs:<i>region</i>:<i>account-id</i>:log-group:<i>log_group_name</i>
     *         </p>
     *         <p>
     *         To get the ARN for a log group, you can use the CloudWatch console, the <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeLogGroups.html"
     *         >DescribeLogGroups</a> API action, the <a
     *         href="https://docs.aws.amazon.com/cli/latest/reference/logs/describe-log-groups.html"
     *         >describe-log-groups</a> command, or the applicable command in one of the Amazon Web Services SDKs.
     */
    public final String cloudWatchLogsLogGroupArn() {
        return cloudWatchLogsLogGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogsLogGroupArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateQueryLoggingConfigRequest)) {
            return false;
        }
        CreateQueryLoggingConfigRequest other = (CreateQueryLoggingConfigRequest) obj;
        return Objects.equals(hostedZoneId(), other.hostedZoneId())
                && Objects.equals(cloudWatchLogsLogGroupArn(), other.cloudWatchLogsLogGroupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateQueryLoggingConfigRequest").add("HostedZoneId", hostedZoneId())
                .add("CloudWatchLogsLogGroupArn", cloudWatchLogsLogGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostedZoneId":
            return Optional.ofNullable(clazz.cast(hostedZoneId()));
        case "CloudWatchLogsLogGroupArn":
            return Optional.ofNullable(clazz.cast(cloudWatchLogsLogGroupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateQueryLoggingConfigRequest, T> g) {
        return obj -> g.apply((CreateQueryLoggingConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateQueryLoggingConfigRequest> {
        /**
         * <p>
         * The ID of the hosted zone that you want to log queries for. You can log queries only for public hosted zones.
         * </p>
         * 
         * @param hostedZoneId
         *        The ID of the hosted zone that you want to log queries for. You can log queries only for public hosted
         *        zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the log group that you want to Amazon Route 53 to send query logs to. This
         * is the format of the ARN:
         * </p>
         * <p>
         * arn:aws:logs:<i>region</i>:<i>account-id</i>:log-group:<i>log_group_name</i>
         * </p>
         * <p>
         * To get the ARN for a log group, you can use the CloudWatch console, the <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeLogGroups.html"
         * >DescribeLogGroups</a> API action, the <a
         * href="https://docs.aws.amazon.com/cli/latest/reference/logs/describe-log-groups.html">describe-log-groups</a>
         * command, or the applicable command in one of the Amazon Web Services SDKs.
         * </p>
         * 
         * @param cloudWatchLogsLogGroupArn
         *        The Amazon Resource Name (ARN) for the log group that you want to Amazon Route 53 to send query logs
         *        to. This is the format of the ARN:</p>
         *        <p>
         *        arn:aws:logs:<i>region</i>:<i>account-id</i>:log-group:<i>log_group_name</i>
         *        </p>
         *        <p>
         *        To get the ARN for a log group, you can use the CloudWatch console, the <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeLogGroups.html"
         *        >DescribeLogGroups</a> API action, the <a
         *        href="https://docs.aws.amazon.com/cli/latest/reference/logs/describe-log-groups.html"
         *        >describe-log-groups</a> command, or the applicable command in one of the Amazon Web Services SDKs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String hostedZoneId;

        private String cloudWatchLogsLogGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateQueryLoggingConfigRequest model) {
            super(model);
            hostedZoneId(model.hostedZoneId);
            cloudWatchLogsLogGroupArn(model.cloudWatchLogsLogGroupArn);
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final String getCloudWatchLogsLogGroupArn() {
            return cloudWatchLogsLogGroupArn;
        }

        public final void setCloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn) {
            this.cloudWatchLogsLogGroupArn = cloudWatchLogsLogGroupArn;
        }

        @Override
        public final Builder cloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn) {
            this.cloudWatchLogsLogGroupArn = cloudWatchLogsLogGroupArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateQueryLoggingConfigRequest build() {
            return new CreateQueryLoggingConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
