/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListHostedZonesByVpcResponse extends Route53Response implements
        ToCopyableBuilder<ListHostedZonesByVpcResponse.Builder, ListHostedZonesByVpcResponse> {
    private static final SdkField<List<HostedZoneSummary>> HOSTED_ZONE_SUMMARIES_FIELD = SdkField
            .<List<HostedZoneSummary>> builder(MarshallingType.LIST)
            .memberName("HostedZoneSummaries")
            .getter(getter(ListHostedZonesByVpcResponse::hostedZoneSummaries))
            .setter(setter(Builder::hostedZoneSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneSummaries")
                    .unmarshallLocationName("HostedZoneSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("HostedZoneSummary")
                            .memberFieldInfo(
                                    SdkField.<HostedZoneSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(HostedZoneSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("HostedZoneSummary")
                                                    .unmarshallLocationName("HostedZoneSummary").build()).build()).build())
            .build();

    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MaxItems")
            .getter(getter(ListHostedZonesByVpcResponse::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems")
                    .unmarshallLocationName("MaxItems").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(ListHostedZonesByVpcResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONE_SUMMARIES_FIELD,
            MAX_ITEMS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("HostedZoneSummaries", HOSTED_ZONE_SUMMARIES_FIELD);
                    put("MaxItems", MAX_ITEMS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<HostedZoneSummary> hostedZoneSummaries;

    private final String maxItems;

    private final String nextToken;

    private ListHostedZonesByVpcResponse(BuilderImpl builder) {
        super(builder);
        this.hostedZoneSummaries = builder.hostedZoneSummaries;
        this.maxItems = builder.maxItems;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the HostedZoneSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHostedZoneSummaries() {
        return hostedZoneSummaries != null && !(hostedZoneSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that contains one <code>HostedZoneSummary</code> element for each hosted zone that the specified Amazon
     * VPC is associated with. Each <code>HostedZoneSummary</code> element contains the hosted zone name and ID, and
     * information about who owns the hosted zone.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHostedZoneSummaries} method.
     * </p>
     * 
     * @return A list that contains one <code>HostedZoneSummary</code> element for each hosted zone that the specified
     *         Amazon VPC is associated with. Each <code>HostedZoneSummary</code> element contains the hosted zone name
     *         and ID, and information about who owns the hosted zone.
     */
    public final List<HostedZoneSummary> hostedZoneSummaries() {
        return hostedZoneSummaries;
    }

    /**
     * <p>
     * The value that you specified for <code>MaxItems</code> in the most recent <code>ListHostedZonesByVPC</code>
     * request.
     * </p>
     * 
     * @return The value that you specified for <code>MaxItems</code> in the most recent
     *         <code>ListHostedZonesByVPC</code> request.
     */
    public final String maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * The value that you will use for <code>NextToken</code> in the next <code>ListHostedZonesByVPC</code> request.
     * </p>
     * 
     * @return The value that you will use for <code>NextToken</code> in the next <code>ListHostedZonesByVPC</code>
     *         request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasHostedZoneSummaries() ? hostedZoneSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHostedZonesByVpcResponse)) {
            return false;
        }
        ListHostedZonesByVpcResponse other = (ListHostedZonesByVpcResponse) obj;
        return hasHostedZoneSummaries() == other.hasHostedZoneSummaries()
                && Objects.equals(hostedZoneSummaries(), other.hostedZoneSummaries())
                && Objects.equals(maxItems(), other.maxItems()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListHostedZonesByVpcResponse")
                .add("HostedZoneSummaries", hasHostedZoneSummaries() ? hostedZoneSummaries() : null).add("MaxItems", maxItems())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostedZoneSummaries":
            return Optional.ofNullable(clazz.cast(hostedZoneSummaries()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListHostedZonesByVpcResponse, T> g) {
        return obj -> g.apply((ListHostedZonesByVpcResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo, CopyableBuilder<Builder, ListHostedZonesByVpcResponse> {
        /**
         * <p>
         * A list that contains one <code>HostedZoneSummary</code> element for each hosted zone that the specified
         * Amazon VPC is associated with. Each <code>HostedZoneSummary</code> element contains the hosted zone name and
         * ID, and information about who owns the hosted zone.
         * </p>
         * 
         * @param hostedZoneSummaries
         *        A list that contains one <code>HostedZoneSummary</code> element for each hosted zone that the
         *        specified Amazon VPC is associated with. Each <code>HostedZoneSummary</code> element contains the
         *        hosted zone name and ID, and information about who owns the hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneSummaries(Collection<HostedZoneSummary> hostedZoneSummaries);

        /**
         * <p>
         * A list that contains one <code>HostedZoneSummary</code> element for each hosted zone that the specified
         * Amazon VPC is associated with. Each <code>HostedZoneSummary</code> element contains the hosted zone name and
         * ID, and information about who owns the hosted zone.
         * </p>
         * 
         * @param hostedZoneSummaries
         *        A list that contains one <code>HostedZoneSummary</code> element for each hosted zone that the
         *        specified Amazon VPC is associated with. Each <code>HostedZoneSummary</code> element contains the
         *        hosted zone name and ID, and information about who owns the hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneSummaries(HostedZoneSummary... hostedZoneSummaries);

        /**
         * <p>
         * A list that contains one <code>HostedZoneSummary</code> element for each hosted zone that the specified
         * Amazon VPC is associated with. Each <code>HostedZoneSummary</code> element contains the hosted zone name and
         * ID, and information about who owns the hosted zone.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.route53.model.HostedZoneSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.route53.model.HostedZoneSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.route53.model.HostedZoneSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #hostedZoneSummaries(List<HostedZoneSummary>)}.
         * 
         * @param hostedZoneSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.route53.model.HostedZoneSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hostedZoneSummaries(java.util.Collection<HostedZoneSummary>)
         */
        Builder hostedZoneSummaries(Consumer<HostedZoneSummary.Builder>... hostedZoneSummaries);

        /**
         * <p>
         * The value that you specified for <code>MaxItems</code> in the most recent <code>ListHostedZonesByVPC</code>
         * request.
         * </p>
         * 
         * @param maxItems
         *        The value that you specified for <code>MaxItems</code> in the most recent
         *        <code>ListHostedZonesByVPC</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);

        /**
         * <p>
         * The value that you will use for <code>NextToken</code> in the next <code>ListHostedZonesByVPC</code> request.
         * </p>
         * 
         * @param nextToken
         *        The value that you will use for <code>NextToken</code> in the next <code>ListHostedZonesByVPC</code>
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private List<HostedZoneSummary> hostedZoneSummaries = DefaultSdkAutoConstructList.getInstance();

        private String maxItems;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHostedZonesByVpcResponse model) {
            super(model);
            hostedZoneSummaries(model.hostedZoneSummaries);
            maxItems(model.maxItems);
            nextToken(model.nextToken);
        }

        public final List<HostedZoneSummary.Builder> getHostedZoneSummaries() {
            List<HostedZoneSummary.Builder> result = HostedZoneSummariesCopier.copyToBuilder(this.hostedZoneSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHostedZoneSummaries(Collection<HostedZoneSummary.BuilderImpl> hostedZoneSummaries) {
            this.hostedZoneSummaries = HostedZoneSummariesCopier.copyFromBuilder(hostedZoneSummaries);
        }

        @Override
        public final Builder hostedZoneSummaries(Collection<HostedZoneSummary> hostedZoneSummaries) {
            this.hostedZoneSummaries = HostedZoneSummariesCopier.copy(hostedZoneSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostedZoneSummaries(HostedZoneSummary... hostedZoneSummaries) {
            hostedZoneSummaries(Arrays.asList(hostedZoneSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostedZoneSummaries(Consumer<HostedZoneSummary.Builder>... hostedZoneSummaries) {
            hostedZoneSummaries(Stream.of(hostedZoneSummaries).map(c -> HostedZoneSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListHostedZonesByVpcResponse build() {
            return new ListHostedZonesByVpcResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
