/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.ChangeInfo;
import software.amazon.awssdk.services.route53.model.KeySigningKey;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateKeySigningKeyResponse
extends Route53Response
implements ToCopyableBuilder<Builder, CreateKeySigningKeyResponse> {
    private static final SdkField<ChangeInfo> CHANGE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChangeInfo").getter(CreateKeySigningKeyResponse.getter(CreateKeySigningKeyResponse::changeInfo)).setter(CreateKeySigningKeyResponse.setter(Builder::changeInfo)).constructor(ChangeInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeInfo").unmarshallLocationName("ChangeInfo").build()}).build();
    private static final SdkField<KeySigningKey> KEY_SIGNING_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KeySigningKey").getter(CreateKeySigningKeyResponse.getter(CreateKeySigningKeyResponse::keySigningKey)).setter(CreateKeySigningKeyResponse.setter(Builder::keySigningKey)).constructor(KeySigningKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySigningKey").unmarshallLocationName("KeySigningKey").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Location").getter(CreateKeySigningKeyResponse.getter(CreateKeySigningKeyResponse::location)).setter(CreateKeySigningKeyResponse.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Location").unmarshallLocationName("Location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGE_INFO_FIELD, KEY_SIGNING_KEY_FIELD, LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ChangeInfo", CHANGE_INFO_FIELD);
            this.put("KeySigningKey", KEY_SIGNING_KEY_FIELD);
            this.put("Location", LOCATION_FIELD);
        }
    });
    private final ChangeInfo changeInfo;
    private final KeySigningKey keySigningKey;
    private final String location;

    private CreateKeySigningKeyResponse(BuilderImpl builder) {
        super(builder);
        this.changeInfo = builder.changeInfo;
        this.keySigningKey = builder.keySigningKey;
        this.location = builder.location;
    }

    public final ChangeInfo changeInfo() {
        return this.changeInfo;
    }

    public final KeySigningKey keySigningKey() {
        return this.keySigningKey;
    }

    public final String location() {
        return this.location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.changeInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.keySigningKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKeySigningKeyResponse)) {
            return false;
        }
        CreateKeySigningKeyResponse other = (CreateKeySigningKeyResponse)((Object)obj);
        return Objects.equals(this.changeInfo(), other.changeInfo()) && Objects.equals(this.keySigningKey(), other.keySigningKey()) && Objects.equals(this.location(), other.location());
    }

    public final String toString() {
        return ToString.builder((String)"CreateKeySigningKeyResponse").add("ChangeInfo", (Object)this.changeInfo()).add("KeySigningKey", (Object)this.keySigningKey()).add("Location", (Object)this.location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChangeInfo": {
                return Optional.ofNullable(clazz.cast(this.changeInfo()));
            }
            case "KeySigningKey": {
                return Optional.ofNullable(clazz.cast(this.keySigningKey()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateKeySigningKeyResponse, T> g) {
        return obj -> g.apply((CreateKeySigningKeyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private ChangeInfo changeInfo;
        private KeySigningKey keySigningKey;
        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKeySigningKeyResponse model) {
            super(model);
            this.changeInfo(model.changeInfo);
            this.keySigningKey(model.keySigningKey);
            this.location(model.location);
        }

        public final ChangeInfo.Builder getChangeInfo() {
            return this.changeInfo != null ? this.changeInfo.toBuilder() : null;
        }

        public final void setChangeInfo(ChangeInfo.BuilderImpl changeInfo) {
            this.changeInfo = changeInfo != null ? changeInfo.build() : null;
        }

        @Override
        public final Builder changeInfo(ChangeInfo changeInfo) {
            this.changeInfo = changeInfo;
            return this;
        }

        public final KeySigningKey.Builder getKeySigningKey() {
            return this.keySigningKey != null ? this.keySigningKey.toBuilder() : null;
        }

        public final void setKeySigningKey(KeySigningKey.BuilderImpl keySigningKey) {
            this.keySigningKey = keySigningKey != null ? keySigningKey.build() : null;
        }

        @Override
        public final Builder keySigningKey(KeySigningKey keySigningKey) {
            this.keySigningKey = keySigningKey;
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        @Override
        public CreateKeySigningKeyResponse build() {
            return new CreateKeySigningKeyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateKeySigningKeyResponse> {
        public Builder changeInfo(ChangeInfo var1);

        default public Builder changeInfo(Consumer<ChangeInfo.Builder> changeInfo) {
            return this.changeInfo((ChangeInfo)((ChangeInfo.Builder)ChangeInfo.builder().applyMutation(changeInfo)).build());
        }

        public Builder keySigningKey(KeySigningKey var1);

        default public Builder keySigningKey(Consumer<KeySigningKey.Builder> keySigningKey) {
            return this.keySigningKey((KeySigningKey)((KeySigningKey.Builder)KeySigningKey.builder().applyMutation(keySigningKey)).build());
        }

        public Builder location(String var1);
    }
}

