/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that describes change information about changes made to your hosted zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChangeInfo implements SdkPojo, Serializable, ToCopyableBuilder<ChangeInfo.Builder, ChangeInfo> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(ChangeInfo::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(ChangeInfo::statusAsString))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("Status").build()).build();

    private static final SdkField<Instant> SUBMITTED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("SubmittedAt")
            .getter(getter(ChangeInfo::submittedAt))
            .setter(setter(Builder::submittedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmittedAt")
                    .unmarshallLocationName("SubmittedAt").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Comment")
            .getter(getter(ChangeInfo::comment))
            .setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment")
                    .unmarshallLocationName("Comment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, STATUS_FIELD,
            SUBMITTED_AT_FIELD, COMMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Id", ID_FIELD);
                    put("Status", STATUS_FIELD);
                    put("SubmittedAt", SUBMITTED_AT_FIELD);
                    put("Comment", COMMENT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String status;

    private final Instant submittedAt;

    private final String comment;

    private ChangeInfo(BuilderImpl builder) {
        this.id = builder.id;
        this.status = builder.status;
        this.submittedAt = builder.submittedAt;
        this.comment = builder.comment;
    }

    /**
     * <p>
     * This element contains an ID that you use when performing a <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetChange.html">GetChange</a> action to get
     * detailed information about the change.
     * </p>
     * 
     * @return This element contains an ID that you use when performing a <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetChange.html">GetChange</a> action to
     *         get detailed information about the change.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The current state of the request. <code>PENDING</code> indicates that this request has not yet been applied to
     * all Amazon Route 53 DNS servers.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChangeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the request. <code>PENDING</code> indicates that this request has not yet been
     *         applied to all Amazon Route 53 DNS servers.
     * @see ChangeStatus
     */
    public final ChangeStatus status() {
        return ChangeStatus.fromValue(status);
    }

    /**
     * <p>
     * The current state of the request. <code>PENDING</code> indicates that this request has not yet been applied to
     * all Amazon Route 53 DNS servers.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChangeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the request. <code>PENDING</code> indicates that this request has not yet been
     *         applied to all Amazon Route 53 DNS servers.
     * @see ChangeStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time that the change request was submitted in <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO
     * 8601 format</a> and Coordinated Universal Time (UTC). For example, the value
     * <code>2017-03-27T17:48:16.751Z</code> represents March 27, 2017 at 17:48:16.751 UTC.
     * </p>
     * 
     * @return The date and time that the change request was submitted in <a
     *         href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601 format</a> and Coordinated Universal Time (UTC).
     *         For example, the value <code>2017-03-27T17:48:16.751Z</code> represents March 27, 2017 at 17:48:16.751
     *         UTC.
     */
    public final Instant submittedAt() {
        return submittedAt;
    }

    /**
     * <p>
     * A comment you can provide.
     * </p>
     * 
     * @return A comment you can provide.
     */
    public final String comment() {
        return comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(submittedAt());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeInfo)) {
            return false;
        }
        ChangeInfo other = (ChangeInfo) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(submittedAt(), other.submittedAt()) && Objects.equals(comment(), other.comment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChangeInfo").add("Id", id()).add("Status", statusAsString()).add("SubmittedAt", submittedAt())
                .add("Comment", comment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "SubmittedAt":
            return Optional.ofNullable(clazz.cast(submittedAt()));
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ChangeInfo, T> g) {
        return obj -> g.apply((ChangeInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChangeInfo> {
        /**
         * <p>
         * This element contains an ID that you use when performing a <a
         * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetChange.html">GetChange</a> action to get
         * detailed information about the change.
         * </p>
         * 
         * @param id
         *        This element contains an ID that you use when performing a <a
         *        href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetChange.html">GetChange</a> action
         *        to get detailed information about the change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The current state of the request. <code>PENDING</code> indicates that this request has not yet been applied
         * to all Amazon Route 53 DNS servers.
         * </p>
         * 
         * @param status
         *        The current state of the request. <code>PENDING</code> indicates that this request has not yet been
         *        applied to all Amazon Route 53 DNS servers.
         * @see ChangeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current state of the request. <code>PENDING</code> indicates that this request has not yet been applied
         * to all Amazon Route 53 DNS servers.
         * </p>
         * 
         * @param status
         *        The current state of the request. <code>PENDING</code> indicates that this request has not yet been
         *        applied to all Amazon Route 53 DNS servers.
         * @see ChangeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeStatus
         */
        Builder status(ChangeStatus status);

        /**
         * <p>
         * The date and time that the change request was submitted in <a
         * href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601 format</a> and Coordinated Universal Time (UTC). For
         * example, the value <code>2017-03-27T17:48:16.751Z</code> represents March 27, 2017 at 17:48:16.751 UTC.
         * </p>
         * 
         * @param submittedAt
         *        The date and time that the change request was submitted in <a
         *        href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601 format</a> and Coordinated Universal Time
         *        (UTC). For example, the value <code>2017-03-27T17:48:16.751Z</code> represents March 27, 2017 at
         *        17:48:16.751 UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submittedAt(Instant submittedAt);

        /**
         * <p>
         * A comment you can provide.
         * </p>
         * 
         * @param comment
         *        A comment you can provide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String status;

        private Instant submittedAt;

        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeInfo model) {
            id(model.id);
            status(model.status);
            submittedAt(model.submittedAt);
            comment(model.comment);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChangeStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getSubmittedAt() {
            return submittedAt;
        }

        public final void setSubmittedAt(Instant submittedAt) {
            this.submittedAt = submittedAt;
        }

        @Override
        public final Builder submittedAt(Instant submittedAt) {
            this.submittedAt = submittedAt;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public ChangeInfo build() {
            return new ChangeInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
