/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about one health check that is associated with the current Amazon Web
 * Services account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HealthCheck implements SdkPojo, Serializable, ToCopyableBuilder<HealthCheck.Builder, HealthCheck> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(HealthCheck::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> CALLER_REFERENCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CallerReference")
            .getter(getter(HealthCheck::callerReference))
            .setter(setter(Builder::callerReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallerReference")
                    .unmarshallLocationName("CallerReference").build()).build();

    private static final SdkField<LinkedService> LINKED_SERVICE_FIELD = SdkField
            .<LinkedService> builder(MarshallingType.SDK_POJO)
            .memberName("LinkedService")
            .getter(getter(HealthCheck::linkedService))
            .setter(setter(Builder::linkedService))
            .constructor(LinkedService::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkedService")
                    .unmarshallLocationName("LinkedService").build()).build();

    private static final SdkField<HealthCheckConfig> HEALTH_CHECK_CONFIG_FIELD = SdkField
            .<HealthCheckConfig> builder(MarshallingType.SDK_POJO)
            .memberName("HealthCheckConfig")
            .getter(getter(HealthCheck::healthCheckConfig))
            .setter(setter(Builder::healthCheckConfig))
            .constructor(HealthCheckConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckConfig")
                    .unmarshallLocationName("HealthCheckConfig").build()).build();

    private static final SdkField<Long> HEALTH_CHECK_VERSION_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("HealthCheckVersion")
            .getter(getter(HealthCheck::healthCheckVersion))
            .setter(setter(Builder::healthCheckVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckVersion")
                    .unmarshallLocationName("HealthCheckVersion").build()).build();

    private static final SdkField<CloudWatchAlarmConfiguration> CLOUD_WATCH_ALARM_CONFIGURATION_FIELD = SdkField
            .<CloudWatchAlarmConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("CloudWatchAlarmConfiguration")
            .getter(getter(HealthCheck::cloudWatchAlarmConfiguration))
            .setter(setter(Builder::cloudWatchAlarmConfiguration))
            .constructor(CloudWatchAlarmConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchAlarmConfiguration")
                    .unmarshallLocationName("CloudWatchAlarmConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            CALLER_REFERENCE_FIELD, LINKED_SERVICE_FIELD, HEALTH_CHECK_CONFIG_FIELD, HEALTH_CHECK_VERSION_FIELD,
            CLOUD_WATCH_ALARM_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Id", ID_FIELD);
                    put("CallerReference", CALLER_REFERENCE_FIELD);
                    put("LinkedService", LINKED_SERVICE_FIELD);
                    put("HealthCheckConfig", HEALTH_CHECK_CONFIG_FIELD);
                    put("HealthCheckVersion", HEALTH_CHECK_VERSION_FIELD);
                    put("CloudWatchAlarmConfiguration", CLOUD_WATCH_ALARM_CONFIGURATION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String callerReference;

    private final LinkedService linkedService;

    private final HealthCheckConfig healthCheckConfig;

    private final Long healthCheckVersion;

    private final CloudWatchAlarmConfiguration cloudWatchAlarmConfiguration;

    private HealthCheck(BuilderImpl builder) {
        this.id = builder.id;
        this.callerReference = builder.callerReference;
        this.linkedService = builder.linkedService;
        this.healthCheckConfig = builder.healthCheckConfig;
        this.healthCheckVersion = builder.healthCheckVersion;
        this.cloudWatchAlarmConfiguration = builder.cloudWatchAlarmConfiguration;
    }

    /**
     * <p>
     * The identifier that Amazon Route 53 assigned to the health check when you created it. When you add or update a
     * resource record set, you use this value to specify which health check to use. The value can be up to 64
     * characters long.
     * </p>
     * 
     * @return The identifier that Amazon Route 53 assigned to the health check when you created it. When you add or
     *         update a resource record set, you use this value to specify which health check to use. The value can be
     *         up to 64 characters long.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A unique string that you specified when you created the health check.
     * </p>
     * 
     * @return A unique string that you specified when you created the health check.
     */
    public final String callerReference() {
        return callerReference;
    }

    /**
     * <p>
     * If the health check was created by another service, the service that created the health check. When a health
     * check is created by another service, you can't edit or delete it using Amazon Route 53.
     * </p>
     * 
     * @return If the health check was created by another service, the service that created the health check. When a
     *         health check is created by another service, you can't edit or delete it using Amazon Route 53.
     */
    public final LinkedService linkedService() {
        return linkedService;
    }

    /**
     * <p>
     * A complex type that contains detailed information about one health check.
     * </p>
     * 
     * @return A complex type that contains detailed information about one health check.
     */
    public final HealthCheckConfig healthCheckConfig() {
        return healthCheckConfig;
    }

    /**
     * <p>
     * The version of the health check. You can optionally pass this value in a call to <code>UpdateHealthCheck</code>
     * to prevent overwriting another change to the health check.
     * </p>
     * 
     * @return The version of the health check. You can optionally pass this value in a call to
     *         <code>UpdateHealthCheck</code> to prevent overwriting another change to the health check.
     */
    public final Long healthCheckVersion() {
        return healthCheckVersion;
    }

    /**
     * <p>
     * A complex type that contains information about the CloudWatch alarm that Amazon Route 53 is monitoring for this
     * health check.
     * </p>
     * 
     * @return A complex type that contains information about the CloudWatch alarm that Amazon Route 53 is monitoring
     *         for this health check.
     */
    public final CloudWatchAlarmConfiguration cloudWatchAlarmConfiguration() {
        return cloudWatchAlarmConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(linkedService());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckConfig());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckVersion());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchAlarmConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheck)) {
            return false;
        }
        HealthCheck other = (HealthCheck) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(callerReference(), other.callerReference())
                && Objects.equals(linkedService(), other.linkedService())
                && Objects.equals(healthCheckConfig(), other.healthCheckConfig())
                && Objects.equals(healthCheckVersion(), other.healthCheckVersion())
                && Objects.equals(cloudWatchAlarmConfiguration(), other.cloudWatchAlarmConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HealthCheck").add("Id", id()).add("CallerReference", callerReference())
                .add("LinkedService", linkedService()).add("HealthCheckConfig", healthCheckConfig())
                .add("HealthCheckVersion", healthCheckVersion())
                .add("CloudWatchAlarmConfiguration", cloudWatchAlarmConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "CallerReference":
            return Optional.ofNullable(clazz.cast(callerReference()));
        case "LinkedService":
            return Optional.ofNullable(clazz.cast(linkedService()));
        case "HealthCheckConfig":
            return Optional.ofNullable(clazz.cast(healthCheckConfig()));
        case "HealthCheckVersion":
            return Optional.ofNullable(clazz.cast(healthCheckVersion()));
        case "CloudWatchAlarmConfiguration":
            return Optional.ofNullable(clazz.cast(cloudWatchAlarmConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<HealthCheck, T> g) {
        return obj -> g.apply((HealthCheck) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HealthCheck> {
        /**
         * <p>
         * The identifier that Amazon Route 53 assigned to the health check when you created it. When you add or update
         * a resource record set, you use this value to specify which health check to use. The value can be up to 64
         * characters long.
         * </p>
         * 
         * @param id
         *        The identifier that Amazon Route 53 assigned to the health check when you created it. When you add or
         *        update a resource record set, you use this value to specify which health check to use. The value can
         *        be up to 64 characters long.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A unique string that you specified when you created the health check.
         * </p>
         * 
         * @param callerReference
         *        A unique string that you specified when you created the health check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerReference(String callerReference);

        /**
         * <p>
         * If the health check was created by another service, the service that created the health check. When a health
         * check is created by another service, you can't edit or delete it using Amazon Route 53.
         * </p>
         * 
         * @param linkedService
         *        If the health check was created by another service, the service that created the health check. When a
         *        health check is created by another service, you can't edit or delete it using Amazon Route 53.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkedService(LinkedService linkedService);

        /**
         * <p>
         * If the health check was created by another service, the service that created the health check. When a health
         * check is created by another service, you can't edit or delete it using Amazon Route 53.
         * </p>
         * This is a convenience method that creates an instance of the {@link LinkedService.Builder} avoiding the need
         * to create one manually via {@link LinkedService#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LinkedService.Builder#build()} is called immediately and its
         * result is passed to {@link #linkedService(LinkedService)}.
         * 
         * @param linkedService
         *        a consumer that will call methods on {@link LinkedService.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #linkedService(LinkedService)
         */
        default Builder linkedService(Consumer<LinkedService.Builder> linkedService) {
            return linkedService(LinkedService.builder().applyMutation(linkedService).build());
        }

        /**
         * <p>
         * A complex type that contains detailed information about one health check.
         * </p>
         * 
         * @param healthCheckConfig
         *        A complex type that contains detailed information about one health check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckConfig(HealthCheckConfig healthCheckConfig);

        /**
         * <p>
         * A complex type that contains detailed information about one health check.
         * </p>
         * This is a convenience method that creates an instance of the {@link HealthCheckConfig.Builder} avoiding the
         * need to create one manually via {@link HealthCheckConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HealthCheckConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #healthCheckConfig(HealthCheckConfig)}.
         * 
         * @param healthCheckConfig
         *        a consumer that will call methods on {@link HealthCheckConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #healthCheckConfig(HealthCheckConfig)
         */
        default Builder healthCheckConfig(Consumer<HealthCheckConfig.Builder> healthCheckConfig) {
            return healthCheckConfig(HealthCheckConfig.builder().applyMutation(healthCheckConfig).build());
        }

        /**
         * <p>
         * The version of the health check. You can optionally pass this value in a call to
         * <code>UpdateHealthCheck</code> to prevent overwriting another change to the health check.
         * </p>
         * 
         * @param healthCheckVersion
         *        The version of the health check. You can optionally pass this value in a call to
         *        <code>UpdateHealthCheck</code> to prevent overwriting another change to the health check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckVersion(Long healthCheckVersion);

        /**
         * <p>
         * A complex type that contains information about the CloudWatch alarm that Amazon Route 53 is monitoring for
         * this health check.
         * </p>
         * 
         * @param cloudWatchAlarmConfiguration
         *        A complex type that contains information about the CloudWatch alarm that Amazon Route 53 is monitoring
         *        for this health check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchAlarmConfiguration(CloudWatchAlarmConfiguration cloudWatchAlarmConfiguration);

        /**
         * <p>
         * A complex type that contains information about the CloudWatch alarm that Amazon Route 53 is monitoring for
         * this health check.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudWatchAlarmConfiguration.Builder}
         * avoiding the need to create one manually via {@link CloudWatchAlarmConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchAlarmConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #cloudWatchAlarmConfiguration(CloudWatchAlarmConfiguration)}.
         * 
         * @param cloudWatchAlarmConfiguration
         *        a consumer that will call methods on {@link CloudWatchAlarmConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchAlarmConfiguration(CloudWatchAlarmConfiguration)
         */
        default Builder cloudWatchAlarmConfiguration(Consumer<CloudWatchAlarmConfiguration.Builder> cloudWatchAlarmConfiguration) {
            return cloudWatchAlarmConfiguration(CloudWatchAlarmConfiguration.builder()
                    .applyMutation(cloudWatchAlarmConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String callerReference;

        private LinkedService linkedService;

        private HealthCheckConfig healthCheckConfig;

        private Long healthCheckVersion;

        private CloudWatchAlarmConfiguration cloudWatchAlarmConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheck model) {
            id(model.id);
            callerReference(model.callerReference);
            linkedService(model.linkedService);
            healthCheckConfig(model.healthCheckConfig);
            healthCheckVersion(model.healthCheckVersion);
            cloudWatchAlarmConfiguration(model.cloudWatchAlarmConfiguration);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getCallerReference() {
            return callerReference;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final LinkedService.Builder getLinkedService() {
            return linkedService != null ? linkedService.toBuilder() : null;
        }

        public final void setLinkedService(LinkedService.BuilderImpl linkedService) {
            this.linkedService = linkedService != null ? linkedService.build() : null;
        }

        @Override
        public final Builder linkedService(LinkedService linkedService) {
            this.linkedService = linkedService;
            return this;
        }

        public final HealthCheckConfig.Builder getHealthCheckConfig() {
            return healthCheckConfig != null ? healthCheckConfig.toBuilder() : null;
        }

        public final void setHealthCheckConfig(HealthCheckConfig.BuilderImpl healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig != null ? healthCheckConfig.build() : null;
        }

        @Override
        public final Builder healthCheckConfig(HealthCheckConfig healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig;
            return this;
        }

        public final Long getHealthCheckVersion() {
            return healthCheckVersion;
        }

        public final void setHealthCheckVersion(Long healthCheckVersion) {
            this.healthCheckVersion = healthCheckVersion;
        }

        @Override
        public final Builder healthCheckVersion(Long healthCheckVersion) {
            this.healthCheckVersion = healthCheckVersion;
            return this;
        }

        public final CloudWatchAlarmConfiguration.Builder getCloudWatchAlarmConfiguration() {
            return cloudWatchAlarmConfiguration != null ? cloudWatchAlarmConfiguration.toBuilder() : null;
        }

        public final void setCloudWatchAlarmConfiguration(CloudWatchAlarmConfiguration.BuilderImpl cloudWatchAlarmConfiguration) {
            this.cloudWatchAlarmConfiguration = cloudWatchAlarmConfiguration != null ? cloudWatchAlarmConfiguration.build()
                    : null;
        }

        @Override
        public final Builder cloudWatchAlarmConfiguration(CloudWatchAlarmConfiguration cloudWatchAlarmConfiguration) {
            this.cloudWatchAlarmConfiguration = cloudWatchAlarmConfiguration;
            return this;
        }

        @Override
        public HealthCheck build() {
            return new HealthCheck(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
