/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response information for the <code>CreateTrafficPolicyVersion</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTrafficPolicyVersionResponse extends Route53Response implements
        ToCopyableBuilder<CreateTrafficPolicyVersionResponse.Builder, CreateTrafficPolicyVersionResponse> {
    private static final SdkField<TrafficPolicy> TRAFFIC_POLICY_FIELD = SdkField
            .<TrafficPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("TrafficPolicy")
            .getter(getter(CreateTrafficPolicyVersionResponse::trafficPolicy))
            .setter(setter(Builder::trafficPolicy))
            .constructor(TrafficPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicy")
                    .unmarshallLocationName("TrafficPolicy").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Location")
            .getter(getter(CreateTrafficPolicyVersionResponse::location))
            .setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Location")
                    .unmarshallLocationName("Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_POLICY_FIELD,
            LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final TrafficPolicy trafficPolicy;

    private final String location;

    private CreateTrafficPolicyVersionResponse(BuilderImpl builder) {
        super(builder);
        this.trafficPolicy = builder.trafficPolicy;
        this.location = builder.location;
    }

    /**
     * <p>
     * A complex type that contains settings for the new version of the traffic policy.
     * </p>
     * 
     * @return A complex type that contains settings for the new version of the traffic policy.
     */
    public final TrafficPolicy trafficPolicy() {
        return trafficPolicy;
    }

    /**
     * <p>
     * A unique URL that represents a new traffic policy version.
     * </p>
     * 
     * @return A unique URL that represents a new traffic policy version.
     */
    public final String location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrafficPolicyVersionResponse)) {
            return false;
        }
        CreateTrafficPolicyVersionResponse other = (CreateTrafficPolicyVersionResponse) obj;
        return Objects.equals(trafficPolicy(), other.trafficPolicy()) && Objects.equals(location(), other.location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTrafficPolicyVersionResponse").add("TrafficPolicy", trafficPolicy())
                .add("Location", location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficPolicy":
            return Optional.ofNullable(clazz.cast(trafficPolicy()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrafficPolicy", TRAFFIC_POLICY_FIELD);
        map.put("Location", LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTrafficPolicyVersionResponse, T> g) {
        return obj -> g.apply((CreateTrafficPolicyVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateTrafficPolicyVersionResponse> {
        /**
         * <p>
         * A complex type that contains settings for the new version of the traffic policy.
         * </p>
         * 
         * @param trafficPolicy
         *        A complex type that contains settings for the new version of the traffic policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicy(TrafficPolicy trafficPolicy);

        /**
         * <p>
         * A complex type that contains settings for the new version of the traffic policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrafficPolicy.Builder} avoiding the need
         * to create one manually via {@link TrafficPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrafficPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #trafficPolicy(TrafficPolicy)}.
         * 
         * @param trafficPolicy
         *        a consumer that will call methods on {@link TrafficPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trafficPolicy(TrafficPolicy)
         */
        default Builder trafficPolicy(Consumer<TrafficPolicy.Builder> trafficPolicy) {
            return trafficPolicy(TrafficPolicy.builder().applyMutation(trafficPolicy).build());
        }

        /**
         * <p>
         * A unique URL that represents a new traffic policy version.
         * </p>
         * 
         * @param location
         *        A unique URL that represents a new traffic policy version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private TrafficPolicy trafficPolicy;

        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrafficPolicyVersionResponse model) {
            super(model);
            trafficPolicy(model.trafficPolicy);
            location(model.location);
        }

        public final TrafficPolicy.Builder getTrafficPolicy() {
            return trafficPolicy != null ? trafficPolicy.toBuilder() : null;
        }

        public final void setTrafficPolicy(TrafficPolicy.BuilderImpl trafficPolicy) {
            this.trafficPolicy = trafficPolicy != null ? trafficPolicy.build() : null;
        }

        @Override
        public final Builder trafficPolicy(TrafficPolicy trafficPolicy) {
            this.trafficPolicy = trafficPolicy;
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        @Override
        public CreateTrafficPolicyVersionResponse build() {
            return new CreateTrafficPolicyVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
