/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the request to create a public or private hosted zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateHostedZoneRequest extends Route53Request implements
        ToCopyableBuilder<CreateHostedZoneRequest.Builder, CreateHostedZoneRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(CreateHostedZoneRequest::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<VPC> VPC_FIELD = SdkField
            .<VPC> builder(MarshallingType.SDK_POJO)
            .memberName("VPC")
            .getter(getter(CreateHostedZoneRequest::vpc))
            .setter(setter(Builder::vpc))
            .constructor(VPC::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPC").unmarshallLocationName("VPC")
                    .build()).build();

    private static final SdkField<String> CALLER_REFERENCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CallerReference")
            .getter(getter(CreateHostedZoneRequest::callerReference))
            .setter(setter(Builder::callerReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallerReference")
                    .unmarshallLocationName("CallerReference").build()).build();

    private static final SdkField<HostedZoneConfig> HOSTED_ZONE_CONFIG_FIELD = SdkField
            .<HostedZoneConfig> builder(MarshallingType.SDK_POJO)
            .memberName("HostedZoneConfig")
            .getter(getter(CreateHostedZoneRequest::hostedZoneConfig))
            .setter(setter(Builder::hostedZoneConfig))
            .constructor(HostedZoneConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneConfig")
                    .unmarshallLocationName("HostedZoneConfig").build()).build();

    private static final SdkField<String> DELEGATION_SET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DelegationSetId")
            .getter(getter(CreateHostedZoneRequest::delegationSetId))
            .setter(setter(Builder::delegationSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DelegationSetId")
                    .unmarshallLocationName("DelegationSetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VPC_FIELD,
            CALLER_REFERENCE_FIELD, HOSTED_ZONE_CONFIG_FIELD, DELEGATION_SET_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Name", NAME_FIELD);
                    put("VPC", VPC_FIELD);
                    put("CallerReference", CALLER_REFERENCE_FIELD);
                    put("HostedZoneConfig", HOSTED_ZONE_CONFIG_FIELD);
                    put("DelegationSetId", DELEGATION_SET_ID_FIELD);
                }
            });

    private final String name;

    private final VPC vpc;

    private final String callerReference;

    private final HostedZoneConfig hostedZoneConfig;

    private final String delegationSetId;

    private CreateHostedZoneRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.vpc = builder.vpc;
        this.callerReference = builder.callerReference;
        this.hostedZoneConfig = builder.hostedZoneConfig;
        this.delegationSetId = builder.delegationSetId;
    }

    /**
     * <p>
     * The name of the domain. Specify a fully qualified domain name, for example, <i>www.example.com</i>. The trailing
     * dot is optional; Amazon Route 53 assumes that the domain name is fully qualified. This means that Route 53 treats
     * <i>www.example.com</i> (without a trailing dot) and <i>www.example.com.</i> (with a trailing dot) as identical.
     * </p>
     * <p>
     * If you're creating a public hosted zone, this is the name you have registered with your DNS registrar. If your
     * domain name is registered with a registrar other than Route 53, change the name servers for your domain to the
     * set of <code>NameServers</code> that <code>CreateHostedZone</code> returns in <code>DelegationSet</code>.
     * </p>
     * 
     * @return The name of the domain. Specify a fully qualified domain name, for example, <i>www.example.com</i>. The
     *         trailing dot is optional; Amazon Route 53 assumes that the domain name is fully qualified. This means
     *         that Route 53 treats <i>www.example.com</i> (without a trailing dot) and <i>www.example.com.</i> (with a
     *         trailing dot) as identical.</p>
     *         <p>
     *         If you're creating a public hosted zone, this is the name you have registered with your DNS registrar. If
     *         your domain name is registered with a registrar other than Route 53, change the name servers for your
     *         domain to the set of <code>NameServers</code> that <code>CreateHostedZone</code> returns in
     *         <code>DelegationSet</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * (Private hosted zones only) A complex type that contains information about the Amazon VPC that you're associating
     * with this hosted zone.
     * </p>
     * <p>
     * You can specify only one Amazon VPC when you create a private hosted zone. If you are associating a VPC with a
     * hosted zone with this request, the paramaters <code>VPCId</code> and <code>VPCRegion</code> are also required.
     * </p>
     * <p>
     * To associate additional Amazon VPCs with the hosted zone, use <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_AssociateVPCWithHostedZone.html"
     * >AssociateVPCWithHostedZone</a> after you create a hosted zone.
     * </p>
     * 
     * @return (Private hosted zones only) A complex type that contains information about the Amazon VPC that you're
     *         associating with this hosted zone.</p>
     *         <p>
     *         You can specify only one Amazon VPC when you create a private hosted zone. If you are associating a VPC
     *         with a hosted zone with this request, the paramaters <code>VPCId</code> and <code>VPCRegion</code> are
     *         also required.
     *         </p>
     *         <p>
     *         To associate additional Amazon VPCs with the hosted zone, use <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_AssociateVPCWithHostedZone.html"
     *         >AssociateVPCWithHostedZone</a> after you create a hosted zone.
     */
    public final VPC vpc() {
        return vpc;
    }

    /**
     * <p>
     * A unique string that identifies the request and that allows failed <code>CreateHostedZone</code> requests to be
     * retried without the risk of executing the operation twice. You must use a unique <code>CallerReference</code>
     * string every time you submit a <code>CreateHostedZone</code> request. <code>CallerReference</code> can be any
     * unique string, for example, a date/time stamp.
     * </p>
     * 
     * @return A unique string that identifies the request and that allows failed <code>CreateHostedZone</code> requests
     *         to be retried without the risk of executing the operation twice. You must use a unique
     *         <code>CallerReference</code> string every time you submit a <code>CreateHostedZone</code> request.
     *         <code>CallerReference</code> can be any unique string, for example, a date/time stamp.
     */
    public final String callerReference() {
        return callerReference;
    }

    /**
     * <p>
     * (Optional) A complex type that contains the following optional values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For public and private hosted zones, an optional comment
     * </p>
     * </li>
     * <li>
     * <p>
     * For private hosted zones, an optional <code>PrivateZone</code> element
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you don't specify a comment or the <code>PrivateZone</code> element, omit <code>HostedZoneConfig</code> and
     * the other elements.
     * </p>
     * 
     * @return (Optional) A complex type that contains the following optional values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For public and private hosted zones, an optional comment
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For private hosted zones, an optional <code>PrivateZone</code> element
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you don't specify a comment or the <code>PrivateZone</code> element, omit
     *         <code>HostedZoneConfig</code> and the other elements.
     */
    public final HostedZoneConfig hostedZoneConfig() {
        return hostedZoneConfig;
    }

    /**
     * <p>
     * If you want to associate a reusable delegation set with this hosted zone, the ID that Amazon Route 53 assigned to
     * the reusable delegation set when you created it. For more information about reusable delegation sets, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateReusableDelegationSet.html">
     * CreateReusableDelegationSet</a>.
     * </p>
     * <p>
     * If you are using a reusable delegation set to create a public hosted zone for a subdomain, make sure that the
     * parent hosted zone doesn't use one or more of the same name servers. If you have overlapping nameservers, the
     * operation will cause a <code>ConflictingDomainsExist</code> error.
     * </p>
     * 
     * @return If you want to associate a reusable delegation set with this hosted zone, the ID that Amazon Route 53
     *         assigned to the reusable delegation set when you created it. For more information about reusable
     *         delegation sets, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateReusableDelegationSet.html"
     *         >CreateReusableDelegationSet</a>.</p>
     *         <p>
     *         If you are using a reusable delegation set to create a public hosted zone for a subdomain, make sure that
     *         the parent hosted zone doesn't use one or more of the same name servers. If you have overlapping
     *         nameservers, the operation will cause a <code>ConflictingDomainsExist</code> error.
     */
    public final String delegationSetId() {
        return delegationSetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(vpc());
        hashCode = 31 * hashCode + Objects.hashCode(callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneConfig());
        hashCode = 31 * hashCode + Objects.hashCode(delegationSetId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHostedZoneRequest)) {
            return false;
        }
        CreateHostedZoneRequest other = (CreateHostedZoneRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(vpc(), other.vpc())
                && Objects.equals(callerReference(), other.callerReference())
                && Objects.equals(hostedZoneConfig(), other.hostedZoneConfig())
                && Objects.equals(delegationSetId(), other.delegationSetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateHostedZoneRequest").add("Name", name()).add("VPC", vpc())
                .add("CallerReference", callerReference()).add("HostedZoneConfig", hostedZoneConfig())
                .add("DelegationSetId", delegationSetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "VPC":
            return Optional.ofNullable(clazz.cast(vpc()));
        case "CallerReference":
            return Optional.ofNullable(clazz.cast(callerReference()));
        case "HostedZoneConfig":
            return Optional.ofNullable(clazz.cast(hostedZoneConfig()));
        case "DelegationSetId":
            return Optional.ofNullable(clazz.cast(delegationSetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateHostedZoneRequest, T> g) {
        return obj -> g.apply((CreateHostedZoneRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateHostedZoneRequest> {
        /**
         * <p>
         * The name of the domain. Specify a fully qualified domain name, for example, <i>www.example.com</i>. The
         * trailing dot is optional; Amazon Route 53 assumes that the domain name is fully qualified. This means that
         * Route 53 treats <i>www.example.com</i> (without a trailing dot) and <i>www.example.com.</i> (with a trailing
         * dot) as identical.
         * </p>
         * <p>
         * If you're creating a public hosted zone, this is the name you have registered with your DNS registrar. If
         * your domain name is registered with a registrar other than Route 53, change the name servers for your domain
         * to the set of <code>NameServers</code> that <code>CreateHostedZone</code> returns in
         * <code>DelegationSet</code>.
         * </p>
         * 
         * @param name
         *        The name of the domain. Specify a fully qualified domain name, for example, <i>www.example.com</i>.
         *        The trailing dot is optional; Amazon Route 53 assumes that the domain name is fully qualified. This
         *        means that Route 53 treats <i>www.example.com</i> (without a trailing dot) and <i>www.example.com.</i>
         *        (with a trailing dot) as identical.</p>
         *        <p>
         *        If you're creating a public hosted zone, this is the name you have registered with your DNS registrar.
         *        If your domain name is registered with a registrar other than Route 53, change the name servers for
         *        your domain to the set of <code>NameServers</code> that <code>CreateHostedZone</code> returns in
         *        <code>DelegationSet</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * (Private hosted zones only) A complex type that contains information about the Amazon VPC that you're
         * associating with this hosted zone.
         * </p>
         * <p>
         * You can specify only one Amazon VPC when you create a private hosted zone. If you are associating a VPC with
         * a hosted zone with this request, the paramaters <code>VPCId</code> and <code>VPCRegion</code> are also
         * required.
         * </p>
         * <p>
         * To associate additional Amazon VPCs with the hosted zone, use <a
         * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_AssociateVPCWithHostedZone.html"
         * >AssociateVPCWithHostedZone</a> after you create a hosted zone.
         * </p>
         * 
         * @param vpc
         *        (Private hosted zones only) A complex type that contains information about the Amazon VPC that you're
         *        associating with this hosted zone.</p>
         *        <p>
         *        You can specify only one Amazon VPC when you create a private hosted zone. If you are associating a
         *        VPC with a hosted zone with this request, the paramaters <code>VPCId</code> and <code>VPCRegion</code>
         *        are also required.
         *        </p>
         *        <p>
         *        To associate additional Amazon VPCs with the hosted zone, use <a
         *        href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_AssociateVPCWithHostedZone.html"
         *        >AssociateVPCWithHostedZone</a> after you create a hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(VPC vpc);

        /**
         * <p>
         * (Private hosted zones only) A complex type that contains information about the Amazon VPC that you're
         * associating with this hosted zone.
         * </p>
         * <p>
         * You can specify only one Amazon VPC when you create a private hosted zone. If you are associating a VPC with
         * a hosted zone with this request, the paramaters <code>VPCId</code> and <code>VPCRegion</code> are also
         * required.
         * </p>
         * <p>
         * To associate additional Amazon VPCs with the hosted zone, use <a
         * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_AssociateVPCWithHostedZone.html"
         * >AssociateVPCWithHostedZone</a> after you create a hosted zone.
         * </p>
         * This is a convenience method that creates an instance of the {@link VPC.Builder} avoiding the need to create
         * one manually via {@link VPC#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VPC.Builder#build()} is called immediately and its result is
         * passed to {@link #vpc(VPC)}.
         * 
         * @param vpc
         *        a consumer that will call methods on {@link VPC.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpc(VPC)
         */
        default Builder vpc(Consumer<VPC.Builder> vpc) {
            return vpc(VPC.builder().applyMutation(vpc).build());
        }

        /**
         * <p>
         * A unique string that identifies the request and that allows failed <code>CreateHostedZone</code> requests to
         * be retried without the risk of executing the operation twice. You must use a unique
         * <code>CallerReference</code> string every time you submit a <code>CreateHostedZone</code> request.
         * <code>CallerReference</code> can be any unique string, for example, a date/time stamp.
         * </p>
         * 
         * @param callerReference
         *        A unique string that identifies the request and that allows failed <code>CreateHostedZone</code>
         *        requests to be retried without the risk of executing the operation twice. You must use a unique
         *        <code>CallerReference</code> string every time you submit a <code>CreateHostedZone</code> request.
         *        <code>CallerReference</code> can be any unique string, for example, a date/time stamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerReference(String callerReference);

        /**
         * <p>
         * (Optional) A complex type that contains the following optional values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For public and private hosted zones, an optional comment
         * </p>
         * </li>
         * <li>
         * <p>
         * For private hosted zones, an optional <code>PrivateZone</code> element
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you don't specify a comment or the <code>PrivateZone</code> element, omit <code>HostedZoneConfig</code>
         * and the other elements.
         * </p>
         * 
         * @param hostedZoneConfig
         *        (Optional) A complex type that contains the following optional values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For public and private hosted zones, an optional comment
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For private hosted zones, an optional <code>PrivateZone</code> element
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you don't specify a comment or the <code>PrivateZone</code> element, omit
         *        <code>HostedZoneConfig</code> and the other elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneConfig(HostedZoneConfig hostedZoneConfig);

        /**
         * <p>
         * (Optional) A complex type that contains the following optional values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For public and private hosted zones, an optional comment
         * </p>
         * </li>
         * <li>
         * <p>
         * For private hosted zones, an optional <code>PrivateZone</code> element
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you don't specify a comment or the <code>PrivateZone</code> element, omit <code>HostedZoneConfig</code>
         * and the other elements.
         * </p>
         * This is a convenience method that creates an instance of the {@link HostedZoneConfig.Builder} avoiding the
         * need to create one manually via {@link HostedZoneConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HostedZoneConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #hostedZoneConfig(HostedZoneConfig)}.
         * 
         * @param hostedZoneConfig
         *        a consumer that will call methods on {@link HostedZoneConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hostedZoneConfig(HostedZoneConfig)
         */
        default Builder hostedZoneConfig(Consumer<HostedZoneConfig.Builder> hostedZoneConfig) {
            return hostedZoneConfig(HostedZoneConfig.builder().applyMutation(hostedZoneConfig).build());
        }

        /**
         * <p>
         * If you want to associate a reusable delegation set with this hosted zone, the ID that Amazon Route 53
         * assigned to the reusable delegation set when you created it. For more information about reusable delegation
         * sets, see <a
         * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateReusableDelegationSet.html"
         * >CreateReusableDelegationSet</a>.
         * </p>
         * <p>
         * If you are using a reusable delegation set to create a public hosted zone for a subdomain, make sure that the
         * parent hosted zone doesn't use one or more of the same name servers. If you have overlapping nameservers, the
         * operation will cause a <code>ConflictingDomainsExist</code> error.
         * </p>
         * 
         * @param delegationSetId
         *        If you want to associate a reusable delegation set with this hosted zone, the ID that Amazon Route 53
         *        assigned to the reusable delegation set when you created it. For more information about reusable
         *        delegation sets, see <a
         *        href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateReusableDelegationSet.html"
         *        >CreateReusableDelegationSet</a>.</p>
         *        <p>
         *        If you are using a reusable delegation set to create a public hosted zone for a subdomain, make sure
         *        that the parent hosted zone doesn't use one or more of the same name servers. If you have overlapping
         *        nameservers, the operation will cause a <code>ConflictingDomainsExist</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegationSetId(String delegationSetId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String name;

        private VPC vpc;

        private String callerReference;

        private HostedZoneConfig hostedZoneConfig;

        private String delegationSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHostedZoneRequest model) {
            super(model);
            name(model.name);
            vpc(model.vpc);
            callerReference(model.callerReference);
            hostedZoneConfig(model.hostedZoneConfig);
            delegationSetId(model.delegationSetId);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final VPC.Builder getVpc() {
            return vpc != null ? vpc.toBuilder() : null;
        }

        public final void setVpc(VPC.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        @Override
        public final Builder vpc(VPC vpc) {
            this.vpc = vpc;
            return this;
        }

        public final String getCallerReference() {
            return callerReference;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final HostedZoneConfig.Builder getHostedZoneConfig() {
            return hostedZoneConfig != null ? hostedZoneConfig.toBuilder() : null;
        }

        public final void setHostedZoneConfig(HostedZoneConfig.BuilderImpl hostedZoneConfig) {
            this.hostedZoneConfig = hostedZoneConfig != null ? hostedZoneConfig.build() : null;
        }

        @Override
        public final Builder hostedZoneConfig(HostedZoneConfig hostedZoneConfig) {
            this.hostedZoneConfig = hostedZoneConfig;
            return this;
        }

        public final String getDelegationSetId() {
            return delegationSetId;
        }

        public final void setDelegationSetId(String delegationSetId) {
            this.delegationSetId = delegationSetId;
        }

        @Override
        public final Builder delegationSetId(String delegationSetId) {
            this.delegationSetId = delegationSetId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateHostedZoneRequest build() {
            return new CreateHostedZoneRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
