/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the request to authorize associating a VPC with your private hosted
 * zone. Authorization is only required when a private hosted zone and a VPC were created by using different accounts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVpcAssociationAuthorizationRequest extends Route53Request implements
        ToCopyableBuilder<CreateVpcAssociationAuthorizationRequest.Builder, CreateVpcAssociationAuthorizationRequest> {
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateVpcAssociationAuthorizationRequest::hostedZoneId))
            .setter(setter(Builder::hostedZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<VPC> VPC_FIELD = SdkField
            .<VPC> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateVpcAssociationAuthorizationRequest::vpc))
            .setter(setter(Builder::vpc))
            .constructor(VPC::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPC").unmarshallLocationName("VPC")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONE_ID_FIELD,
            VPC_FIELD));

    private final String hostedZoneId;

    private final VPC vpc;

    private CreateVpcAssociationAuthorizationRequest(BuilderImpl builder) {
        super(builder);
        this.hostedZoneId = builder.hostedZoneId;
        this.vpc = builder.vpc;
    }

    /**
     * <p>
     * The ID of the private hosted zone that you want to authorize associating a VPC with.
     * </p>
     * 
     * @return The ID of the private hosted zone that you want to authorize associating a VPC with.
     */
    public String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * A complex type that contains the VPC ID and region for the VPC that you want to authorize associating with your
     * hosted zone.
     * </p>
     * 
     * @return A complex type that contains the VPC ID and region for the VPC that you want to authorize associating
     *         with your hosted zone.
     */
    public VPC vpc() {
        return vpc;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(vpc());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcAssociationAuthorizationRequest)) {
            return false;
        }
        CreateVpcAssociationAuthorizationRequest other = (CreateVpcAssociationAuthorizationRequest) obj;
        return Objects.equals(hostedZoneId(), other.hostedZoneId()) && Objects.equals(vpc(), other.vpc());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateVpcAssociationAuthorizationRequest").add("HostedZoneId", hostedZoneId()).add("VPC", vpc())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostedZoneId":
            return Optional.ofNullable(clazz.cast(hostedZoneId()));
        case "VPC":
            return Optional.ofNullable(clazz.cast(vpc()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcAssociationAuthorizationRequest, T> g) {
        return obj -> g.apply((CreateVpcAssociationAuthorizationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Request.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateVpcAssociationAuthorizationRequest> {
        /**
         * <p>
         * The ID of the private hosted zone that you want to authorize associating a VPC with.
         * </p>
         * 
         * @param hostedZoneId
         *        The ID of the private hosted zone that you want to authorize associating a VPC with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * A complex type that contains the VPC ID and region for the VPC that you want to authorize associating with
         * your hosted zone.
         * </p>
         * 
         * @param vpc
         *        A complex type that contains the VPC ID and region for the VPC that you want to authorize associating
         *        with your hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(VPC vpc);

        /**
         * <p>
         * A complex type that contains the VPC ID and region for the VPC that you want to authorize associating with
         * your hosted zone.
         * </p>
         * This is a convenience that creates an instance of the {@link VPC.Builder} avoiding the need to create one
         * manually via {@link VPC#builder()}.
         *
         * When the {@link Consumer} completes, {@link VPC.Builder#build()} is called immediately and its result is
         * passed to {@link #vpc(VPC)}.
         * 
         * @param vpc
         *        a consumer that will call methods on {@link VPC.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpc(VPC)
         */
        default Builder vpc(Consumer<VPC.Builder> vpc) {
            return vpc(VPC.builder().applyMutation(vpc).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String hostedZoneId;

        private VPC vpc;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcAssociationAuthorizationRequest model) {
            super(model);
            hostedZoneId(model.hostedZoneId);
            vpc(model.vpc);
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final VPC.Builder getVpc() {
            return vpc != null ? vpc.toBuilder() : null;
        }

        @Override
        public final Builder vpc(VPC vpc) {
            this.vpc = vpc;
            return this;
        }

        public final void setVpc(VPC.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcAssociationAuthorizationRequest build() {
            return new CreateVpcAssociationAuthorizationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
