/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the resource record sets that Amazon Route 53 created based on a
 * specified traffic policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTrafficPolicyInstanceCountResponse extends Route53Response implements
        ToCopyableBuilder<GetTrafficPolicyInstanceCountResponse.Builder, GetTrafficPolicyInstanceCountResponse> {
    private static final SdkField<Integer> TRAFFIC_POLICY_INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetTrafficPolicyInstanceCountResponse::trafficPolicyInstanceCount))
            .setter(setter(Builder::trafficPolicyInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyInstanceCount")
                    .unmarshallLocationName("TrafficPolicyInstanceCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TRAFFIC_POLICY_INSTANCE_COUNT_FIELD));

    private final Integer trafficPolicyInstanceCount;

    private GetTrafficPolicyInstanceCountResponse(BuilderImpl builder) {
        super(builder);
        this.trafficPolicyInstanceCount = builder.trafficPolicyInstanceCount;
    }

    /**
     * <p>
     * The number of traffic policy instances that are associated with the current AWS account.
     * </p>
     * 
     * @return The number of traffic policy instances that are associated with the current AWS account.
     */
    public Integer trafficPolicyInstanceCount() {
        return trafficPolicyInstanceCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyInstanceCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTrafficPolicyInstanceCountResponse)) {
            return false;
        }
        GetTrafficPolicyInstanceCountResponse other = (GetTrafficPolicyInstanceCountResponse) obj;
        return Objects.equals(trafficPolicyInstanceCount(), other.trafficPolicyInstanceCount());
    }

    @Override
    public String toString() {
        return ToString.builder("GetTrafficPolicyInstanceCountResponse")
                .add("TrafficPolicyInstanceCount", trafficPolicyInstanceCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficPolicyInstanceCount":
            return Optional.ofNullable(clazz.cast(trafficPolicyInstanceCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTrafficPolicyInstanceCountResponse, T> g) {
        return obj -> g.apply((GetTrafficPolicyInstanceCountResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTrafficPolicyInstanceCountResponse> {
        /**
         * <p>
         * The number of traffic policy instances that are associated with the current AWS account.
         * </p>
         * 
         * @param trafficPolicyInstanceCount
         *        The number of traffic policy instances that are associated with the current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyInstanceCount(Integer trafficPolicyInstanceCount);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private Integer trafficPolicyInstanceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTrafficPolicyInstanceCountResponse model) {
            super(model);
            trafficPolicyInstanceCount(model.trafficPolicyInstanceCount);
        }

        public final Integer getTrafficPolicyInstanceCount() {
            return trafficPolicyInstanceCount;
        }

        @Override
        public final Builder trafficPolicyInstanceCount(Integer trafficPolicyInstanceCount) {
            this.trafficPolicyInstanceCount = trafficPolicyInstanceCount;
            return this;
        }

        public final void setTrafficPolicyInstanceCount(Integer trafficPolicyInstanceCount) {
            this.trafficPolicyInstanceCount = trafficPolicyInstanceCount;
        }

        @Override
        public GetTrafficPolicyInstanceCountResponse build() {
            return new GetTrafficPolicyInstanceCountResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
