/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about that can be associated with your hosted zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVpcAssociationAuthorizationsRequest extends Route53Request implements
        ToCopyableBuilder<ListVpcAssociationAuthorizationsRequest.Builder, ListVpcAssociationAuthorizationsRequest> {
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ListVpcAssociationAuthorizationsRequest::hostedZoneId))
            .setter(setter(Builder::hostedZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ListVpcAssociationAuthorizationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nexttoken")
                    .unmarshallLocationName("nexttoken").build()).build();

    private static final SdkField<String> MAX_RESULTS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ListVpcAssociationAuthorizationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxresults")
                    .unmarshallLocationName("maxresults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONE_ID_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String hostedZoneId;

    private final String nextToken;

    private final String maxResults;

    private ListVpcAssociationAuthorizationsRequest(BuilderImpl builder) {
        super(builder);
        this.hostedZoneId = builder.hostedZoneId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The ID of the hosted zone for which you want a list of VPCs that can be associated with the hosted zone.
     * </p>
     * 
     * @return The ID of the hosted zone for which you want a list of VPCs that can be associated with the hosted zone.
     */
    public String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * <i>Optional</i>: If a response includes a <code>NextToken</code> element, there are more VPCs that can be
     * associated with the specified hosted zone. To get the next page of results, submit another request, and include
     * the value of <code>NextToken</code> from the response in the <code>nexttoken</code> parameter in another
     * <code>ListVPCAssociationAuthorizations</code> request.
     * </p>
     * 
     * @return <i>Optional</i>: If a response includes a <code>NextToken</code> element, there are more VPCs that can be
     *         associated with the specified hosted zone. To get the next page of results, submit another request, and
     *         include the value of <code>NextToken</code> from the response in the <code>nexttoken</code> parameter in
     *         another <code>ListVPCAssociationAuthorizations</code> request.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * <i>Optional</i>: An integer that specifies the maximum number of VPCs that you want Amazon Route 53 to return. If
     * you don't specify a value for <code>MaxResults</code>, Route 53 returns up to 50 VPCs per page.
     * </p>
     * 
     * @return <i>Optional</i>: An integer that specifies the maximum number of VPCs that you want Amazon Route 53 to
     *         return. If you don't specify a value for <code>MaxResults</code>, Route 53 returns up to 50 VPCs per
     *         page.
     */
    public String maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVpcAssociationAuthorizationsRequest)) {
            return false;
        }
        ListVpcAssociationAuthorizationsRequest other = (ListVpcAssociationAuthorizationsRequest) obj;
        return Objects.equals(hostedZoneId(), other.hostedZoneId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    @Override
    public String toString() {
        return ToString.builder("ListVpcAssociationAuthorizationsRequest").add("HostedZoneId", hostedZoneId())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostedZoneId":
            return Optional.ofNullable(clazz.cast(hostedZoneId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVpcAssociationAuthorizationsRequest, T> g) {
        return obj -> g.apply((ListVpcAssociationAuthorizationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ListVpcAssociationAuthorizationsRequest> {
        /**
         * <p>
         * The ID of the hosted zone for which you want a list of VPCs that can be associated with the hosted zone.
         * </p>
         * 
         * @param hostedZoneId
         *        The ID of the hosted zone for which you want a list of VPCs that can be associated with the hosted
         *        zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * <i>Optional</i>: If a response includes a <code>NextToken</code> element, there are more VPCs that can be
         * associated with the specified hosted zone. To get the next page of results, submit another request, and
         * include the value of <code>NextToken</code> from the response in the <code>nexttoken</code> parameter in
         * another <code>ListVPCAssociationAuthorizations</code> request.
         * </p>
         * 
         * @param nextToken
         *        <i>Optional</i>: If a response includes a <code>NextToken</code> element, there are more VPCs that can
         *        be associated with the specified hosted zone. To get the next page of results, submit another request,
         *        and include the value of <code>NextToken</code> from the response in the <code>nexttoken</code>
         *        parameter in another <code>ListVPCAssociationAuthorizations</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * <i>Optional</i>: An integer that specifies the maximum number of VPCs that you want Amazon Route 53 to
         * return. If you don't specify a value for <code>MaxResults</code>, Route 53 returns up to 50 VPCs per page.
         * </p>
         * 
         * @param maxResults
         *        <i>Optional</i>: An integer that specifies the maximum number of VPCs that you want Amazon Route 53 to
         *        return. If you don't specify a value for <code>MaxResults</code>, Route 53 returns up to 50 VPCs per
         *        page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(String maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String hostedZoneId;

        private String nextToken;

        private String maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVpcAssociationAuthorizationsRequest model) {
            super(model);
            hostedZoneId(model.hostedZoneId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(String maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(String maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListVpcAssociationAuthorizationsRequest build() {
            return new ListVpcAssociationAuthorizationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
