/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response information for the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVpcAssociationAuthorizationsResponse extends Route53Response implements
        ToCopyableBuilder<ListVpcAssociationAuthorizationsResponse.Builder, ListVpcAssociationAuthorizationsResponse> {
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ListVpcAssociationAuthorizationsResponse::hostedZoneId))
            .setter(setter(Builder::hostedZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneId")
                    .unmarshallLocationName("HostedZoneId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ListVpcAssociationAuthorizationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final SdkField<List<VPC>> VP_CS_FIELD = SdkField
            .<List<VPC>> builder(MarshallingType.LIST)
            .getter(getter(ListVpcAssociationAuthorizationsResponse::vpCs))
            .setter(setter(Builder::vpCs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCs")
                    .unmarshallLocationName("VPCs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VPC")
                            .memberFieldInfo(
                                    SdkField.<VPC> builder(MarshallingType.SDK_POJO)
                                            .constructor(VPC::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VPC").unmarshallLocationName("VPC").build()).build()).build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONE_ID_FIELD,
            NEXT_TOKEN_FIELD, VP_CS_FIELD));

    private final String hostedZoneId;

    private final String nextToken;

    private final List<VPC> vpCs;

    private ListVpcAssociationAuthorizationsResponse(BuilderImpl builder) {
        super(builder);
        this.hostedZoneId = builder.hostedZoneId;
        this.nextToken = builder.nextToken;
        this.vpCs = builder.vpCs;
    }

    /**
     * <p>
     * The ID of the hosted zone that you can associate the listed VPCs with.
     * </p>
     * 
     * @return The ID of the hosted zone that you can associate the listed VPCs with.
     */
    public String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * When the response includes a <code>NextToken</code> element, there are more VPCs that can be associated with the
     * specified hosted zone. To get the next page of VPCs, submit another <code>ListVPCAssociationAuthorizations</code>
     * request, and include the value of the <code>NextToken</code> element from the response in the
     * <code>nexttoken</code> request parameter.
     * </p>
     * 
     * @return When the response includes a <code>NextToken</code> element, there are more VPCs that can be associated
     *         with the specified hosted zone. To get the next page of VPCs, submit another
     *         <code>ListVPCAssociationAuthorizations</code> request, and include the value of the
     *         <code>NextToken</code> element from the response in the <code>nexttoken</code> request parameter.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The list of VPCs that are authorized to be associated with the specified hosted zone.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of VPCs that are authorized to be associated with the specified hosted zone.
     */
    public List<VPC> vpCs() {
        return vpCs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(vpCs());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVpcAssociationAuthorizationsResponse)) {
            return false;
        }
        ListVpcAssociationAuthorizationsResponse other = (ListVpcAssociationAuthorizationsResponse) obj;
        return Objects.equals(hostedZoneId(), other.hostedZoneId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(vpCs(), other.vpCs());
    }

    @Override
    public String toString() {
        return ToString.builder("ListVpcAssociationAuthorizationsResponse").add("HostedZoneId", hostedZoneId())
                .add("NextToken", nextToken()).add("VPCs", vpCs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostedZoneId":
            return Optional.ofNullable(clazz.cast(hostedZoneId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "VPCs":
            return Optional.ofNullable(clazz.cast(vpCs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVpcAssociationAuthorizationsResponse, T> g) {
        return obj -> g.apply((ListVpcAssociationAuthorizationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ListVpcAssociationAuthorizationsResponse> {
        /**
         * <p>
         * The ID of the hosted zone that you can associate the listed VPCs with.
         * </p>
         * 
         * @param hostedZoneId
         *        The ID of the hosted zone that you can associate the listed VPCs with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * When the response includes a <code>NextToken</code> element, there are more VPCs that can be associated with
         * the specified hosted zone. To get the next page of VPCs, submit another
         * <code>ListVPCAssociationAuthorizations</code> request, and include the value of the <code>NextToken</code>
         * element from the response in the <code>nexttoken</code> request parameter.
         * </p>
         * 
         * @param nextToken
         *        When the response includes a <code>NextToken</code> element, there are more VPCs that can be
         *        associated with the specified hosted zone. To get the next page of VPCs, submit another
         *        <code>ListVPCAssociationAuthorizations</code> request, and include the value of the
         *        <code>NextToken</code> element from the response in the <code>nexttoken</code> request parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of VPCs that are authorized to be associated with the specified hosted zone.
         * </p>
         * 
         * @param vpCs
         *        The list of VPCs that are authorized to be associated with the specified hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpCs(Collection<VPC> vpCs);

        /**
         * <p>
         * The list of VPCs that are authorized to be associated with the specified hosted zone.
         * </p>
         * 
         * @param vpCs
         *        The list of VPCs that are authorized to be associated with the specified hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpCs(VPC... vpCs);

        /**
         * <p>
         * The list of VPCs that are authorized to be associated with the specified hosted zone.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VPC>.Builder} avoiding the need to create
         * one manually via {@link List<VPC>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VPC>.Builder#build()} is called immediately and its result
         * is passed to {@link #vpCs(List<VPC>)}.
         * 
         * @param vpCs
         *        a consumer that will call methods on {@link List<VPC>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpCs(List<VPC>)
         */
        Builder vpCs(Consumer<VPC.Builder>... vpCs);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private String hostedZoneId;

        private String nextToken;

        private List<VPC> vpCs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVpcAssociationAuthorizationsResponse model) {
            super(model);
            hostedZoneId(model.hostedZoneId);
            nextToken(model.nextToken);
            vpCs(model.vpCs);
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<VPC.Builder> getVpCs() {
            return vpCs != null ? vpCs.stream().map(VPC::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpCs(Collection<VPC> vpCs) {
            this.vpCs = VPCsCopier.copy(vpCs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpCs(VPC... vpCs) {
            vpCs(Arrays.asList(vpCs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpCs(Consumer<VPC.Builder>... vpCs) {
            vpCs(Stream.of(vpCs).map(c -> VPC.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVpCs(Collection<VPC.BuilderImpl> vpCs) {
            this.vpCs = VPCsCopier.copyFromBuilder(vpCs);
        }

        @Override
        public ListVpcAssociationAuthorizationsResponse build() {
            return new ListVpcAssociationAuthorizationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
