/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the status that one Amazon Route 53 health checker reports and the time of the health
 * check.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StatusReport implements SdkPojo, Serializable, ToCopyableBuilder<StatusReport.Builder, StatusReport> {
    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(StatusReport::status))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("Status").build()).build();

    private static final SdkField<Instant> CHECKED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(StatusReport::checkedTime))
            .setter(setter(Builder::checkedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckedTime")
                    .unmarshallLocationName("CheckedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            CHECKED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final Instant checkedTime;

    private StatusReport(BuilderImpl builder) {
        this.status = builder.status;
        this.checkedTime = builder.checkedTime;
    }

    /**
     * <p>
     * A description of the status of the health check endpoint as reported by one of the Amazon Route 53 health
     * checkers.
     * </p>
     * 
     * @return A description of the status of the health check endpoint as reported by one of the Amazon Route 53 health
     *         checkers.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The date and time that the health checker performed the health check in <a
     * href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601 format</a> and Coordinated Universal Time (UTC). For
     * example, the value <code>2017-03-27T17:48:16.751Z</code> represents March 27, 2017 at 17:48:16.751 UTC.
     * </p>
     * 
     * @return The date and time that the health checker performed the health check in <a
     *         href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601 format</a> and Coordinated Universal Time (UTC).
     *         For example, the value <code>2017-03-27T17:48:16.751Z</code> represents March 27, 2017 at 17:48:16.751
     *         UTC.
     */
    public Instant checkedTime() {
        return checkedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(checkedTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatusReport)) {
            return false;
        }
        StatusReport other = (StatusReport) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(checkedTime(), other.checkedTime());
    }

    @Override
    public String toString() {
        return ToString.builder("StatusReport").add("Status", status()).add("CheckedTime", checkedTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "CheckedTime":
            return Optional.ofNullable(clazz.cast(checkedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StatusReport, T> g) {
        return obj -> g.apply((StatusReport) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StatusReport> {
        /**
         * <p>
         * A description of the status of the health check endpoint as reported by one of the Amazon Route 53 health
         * checkers.
         * </p>
         * 
         * @param status
         *        A description of the status of the health check endpoint as reported by one of the Amazon Route 53
         *        health checkers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The date and time that the health checker performed the health check in <a
         * href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601 format</a> and Coordinated Universal Time (UTC). For
         * example, the value <code>2017-03-27T17:48:16.751Z</code> represents March 27, 2017 at 17:48:16.751 UTC.
         * </p>
         * 
         * @param checkedTime
         *        The date and time that the health checker performed the health check in <a
         *        href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601 format</a> and Coordinated Universal Time
         *        (UTC). For example, the value <code>2017-03-27T17:48:16.751Z</code> represents March 27, 2017 at
         *        17:48:16.751 UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkedTime(Instant checkedTime);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private Instant checkedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(StatusReport model) {
            status(model.status);
            checkedTime(model.checkedTime);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCheckedTime() {
            return checkedTime;
        }

        @Override
        public final Builder checkedTime(Instant checkedTime) {
            this.checkedTime = checkedTime;
            return this;
        }

        public final void setCheckedTime(Instant checkedTime) {
            this.checkedTime = checkedTime;
        }

        @Override
        public StatusReport build() {
            return new StatusReport(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
