/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the health check request information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateHealthCheckRequest extends Route53Request implements
        ToCopyableBuilder<CreateHealthCheckRequest.Builder, CreateHealthCheckRequest> {
    private static final SdkField<String> CALLER_REFERENCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateHealthCheckRequest::callerReference))
            .setter(setter(Builder::callerReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallerReference")
                    .unmarshallLocationName("CallerReference").build()).build();

    private static final SdkField<HealthCheckConfig> HEALTH_CHECK_CONFIG_FIELD = SdkField
            .<HealthCheckConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateHealthCheckRequest::healthCheckConfig))
            .setter(setter(Builder::healthCheckConfig))
            .constructor(HealthCheckConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckConfig")
                    .unmarshallLocationName("HealthCheckConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALLER_REFERENCE_FIELD,
            HEALTH_CHECK_CONFIG_FIELD));

    private final String callerReference;

    private final HealthCheckConfig healthCheckConfig;

    private CreateHealthCheckRequest(BuilderImpl builder) {
        super(builder);
        this.callerReference = builder.callerReference;
        this.healthCheckConfig = builder.healthCheckConfig;
    }

    /**
     * <p>
     * A unique string that identifies the request and that allows you to retry a failed <code>CreateHealthCheck</code>
     * request without the risk of creating two identical health checks:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> and settings as a
     * previous request, and if the health check doesn't exist, Amazon Route 53 creates the health check. If the health
     * check does exist, Route 53 returns the settings for the existing health check.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> as a deleted
     * health check, regardless of the settings, Route 53 returns a <code>HealthCheckAlreadyExists</code> error.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> as an existing
     * health check but with different settings, Route 53 returns a <code>HealthCheckAlreadyExists</code> error.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you send a <code>CreateHealthCheck</code> request with a unique <code>CallerReference</code> but settings
     * identical to an existing health check, Route 53 creates the health check.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A unique string that identifies the request and that allows you to retry a failed
     *         <code>CreateHealthCheck</code> request without the risk of creating two identical health checks:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> and
     *         settings as a previous request, and if the health check doesn't exist, Amazon Route 53 creates the health
     *         check. If the health check does exist, Route 53 returns the settings for the existing health check.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> as a
     *         deleted health check, regardless of the settings, Route 53 returns a
     *         <code>HealthCheckAlreadyExists</code> error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> as an
     *         existing health check but with different settings, Route 53 returns a
     *         <code>HealthCheckAlreadyExists</code> error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you send a <code>CreateHealthCheck</code> request with a unique <code>CallerReference</code> but
     *         settings identical to an existing health check, Route 53 creates the health check.
     *         </p>
     *         </li>
     */
    public String callerReference() {
        return callerReference;
    }

    /**
     * <p>
     * A complex type that contains settings for a new health check.
     * </p>
     * 
     * @return A complex type that contains settings for a new health check.
     */
    public HealthCheckConfig healthCheckConfig() {
        return healthCheckConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHealthCheckRequest)) {
            return false;
        }
        CreateHealthCheckRequest other = (CreateHealthCheckRequest) obj;
        return Objects.equals(callerReference(), other.callerReference())
                && Objects.equals(healthCheckConfig(), other.healthCheckConfig());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateHealthCheckRequest").add("CallerReference", callerReference())
                .add("HealthCheckConfig", healthCheckConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CallerReference":
            return Optional.ofNullable(clazz.cast(callerReference()));
        case "HealthCheckConfig":
            return Optional.ofNullable(clazz.cast(healthCheckConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateHealthCheckRequest, T> g) {
        return obj -> g.apply((CreateHealthCheckRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateHealthCheckRequest> {
        /**
         * <p>
         * A unique string that identifies the request and that allows you to retry a failed
         * <code>CreateHealthCheck</code> request without the risk of creating two identical health checks:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> and settings
         * as a previous request, and if the health check doesn't exist, Amazon Route 53 creates the health check. If
         * the health check does exist, Route 53 returns the settings for the existing health check.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> as a deleted
         * health check, regardless of the settings, Route 53 returns a <code>HealthCheckAlreadyExists</code> error.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> as an
         * existing health check but with different settings, Route 53 returns a <code>HealthCheckAlreadyExists</code>
         * error.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you send a <code>CreateHealthCheck</code> request with a unique <code>CallerReference</code> but settings
         * identical to an existing health check, Route 53 creates the health check.
         * </p>
         * </li>
         * </ul>
         * 
         * @param callerReference
         *        A unique string that identifies the request and that allows you to retry a failed
         *        <code>CreateHealthCheck</code> request without the risk of creating two identical health checks:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> and
         *        settings as a previous request, and if the health check doesn't exist, Amazon Route 53 creates the
         *        health check. If the health check does exist, Route 53 returns the settings for the existing health
         *        check.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> as a
         *        deleted health check, regardless of the settings, Route 53 returns a
         *        <code>HealthCheckAlreadyExists</code> error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> as an
         *        existing health check but with different settings, Route 53 returns a
         *        <code>HealthCheckAlreadyExists</code> error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you send a <code>CreateHealthCheck</code> request with a unique <code>CallerReference</code> but
         *        settings identical to an existing health check, Route 53 creates the health check.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerReference(String callerReference);

        /**
         * <p>
         * A complex type that contains settings for a new health check.
         * </p>
         * 
         * @param healthCheckConfig
         *        A complex type that contains settings for a new health check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckConfig(HealthCheckConfig healthCheckConfig);

        /**
         * <p>
         * A complex type that contains settings for a new health check.
         * </p>
         * This is a convenience that creates an instance of the {@link HealthCheckConfig.Builder} avoiding the need to
         * create one manually via {@link HealthCheckConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link HealthCheckConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #healthCheckConfig(HealthCheckConfig)}.
         * 
         * @param healthCheckConfig
         *        a consumer that will call methods on {@link HealthCheckConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #healthCheckConfig(HealthCheckConfig)
         */
        default Builder healthCheckConfig(Consumer<HealthCheckConfig.Builder> healthCheckConfig) {
            return healthCheckConfig(HealthCheckConfig.builder().applyMutation(healthCheckConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String callerReference;

        private HealthCheckConfig healthCheckConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHealthCheckRequest model) {
            super(model);
            callerReference(model.callerReference);
            healthCheckConfig(model.healthCheckConfig);
        }

        public final String getCallerReference() {
            return callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final HealthCheckConfig.Builder getHealthCheckConfig() {
            return healthCheckConfig != null ? healthCheckConfig.toBuilder() : null;
        }

        @Override
        public final Builder healthCheckConfig(HealthCheckConfig healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig;
            return this;
        }

        public final void setHealthCheckConfig(HealthCheckConfig.BuilderImpl healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig != null ? healthCheckConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateHealthCheckRequest build() {
            return new CreateHealthCheckRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
