/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request for information about whether a specified geographic location is supported for Amazon Route 53 geolocation
 * resource record sets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetGeoLocationRequest extends Route53Request implements
        ToCopyableBuilder<GetGeoLocationRequest.Builder, GetGeoLocationRequest> {
    private static final SdkField<String> CONTINENT_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(GetGeoLocationRequest::continentCode))
            .setter(setter(Builder::continentCode))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("continentcode")
                    .unmarshallLocationName("continentcode").build()).build();

    private static final SdkField<String> COUNTRY_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(GetGeoLocationRequest::countryCode))
            .setter(setter(Builder::countryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("countrycode")
                    .unmarshallLocationName("countrycode").build()).build();

    private static final SdkField<String> SUBDIVISION_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(GetGeoLocationRequest::subdivisionCode))
            .setter(setter(Builder::subdivisionCode))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("subdivisioncode")
                    .unmarshallLocationName("subdivisioncode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTINENT_CODE_FIELD,
            COUNTRY_CODE_FIELD, SUBDIVISION_CODE_FIELD));

    private final String continentCode;

    private final String countryCode;

    private final String subdivisionCode;

    private GetGeoLocationRequest(BuilderImpl builder) {
        super(builder);
        this.continentCode = builder.continentCode;
        this.countryCode = builder.countryCode;
        this.subdivisionCode = builder.subdivisionCode;
    }

    /**
     * <p>
     * Amazon Route 53 supports the following continent codes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>AF</b>: Africa
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>AN</b>: Antarctica
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>AS</b>: Asia
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>EU</b>: Europe
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>OC</b>: Oceania
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>NA</b>: North America
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>SA</b>: South America
     * </p>
     * </li>
     * </ul>
     * 
     * @return Amazon Route 53 supports the following continent codes:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>AF</b>: Africa
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>AN</b>: Antarctica
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>AS</b>: Asia
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>EU</b>: Europe
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>OC</b>: Oceania
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>NA</b>: North America
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>SA</b>: South America
     *         </p>
     *         </li>
     */
    public String continentCode() {
        return continentCode;
    }

    /**
     * <p>
     * Amazon Route 53 uses the two-letter country codes that are specified in <a
     * href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>.
     * </p>
     * 
     * @return Amazon Route 53 uses the two-letter country codes that are specified in <a
     *         href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>.
     */
    public String countryCode() {
        return countryCode;
    }

    /**
     * <p>
     * Amazon Route 53 uses the one- to three-letter subdivision codes that are specified in <a
     * href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>. Route 53 doesn't support
     * subdivision codes for all countries. If you specify <code>subdivisioncode</code>, you must also specify
     * <code>countrycode</code>.
     * </p>
     * 
     * @return Amazon Route 53 uses the one- to three-letter subdivision codes that are specified in <a
     *         href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>. Route 53 doesn't
     *         support subdivision codes for all countries. If you specify <code>subdivisioncode</code>, you must also
     *         specify <code>countrycode</code>.
     */
    public String subdivisionCode() {
        return subdivisionCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(continentCode());
        hashCode = 31 * hashCode + Objects.hashCode(countryCode());
        hashCode = 31 * hashCode + Objects.hashCode(subdivisionCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGeoLocationRequest)) {
            return false;
        }
        GetGeoLocationRequest other = (GetGeoLocationRequest) obj;
        return Objects.equals(continentCode(), other.continentCode()) && Objects.equals(countryCode(), other.countryCode())
                && Objects.equals(subdivisionCode(), other.subdivisionCode());
    }

    @Override
    public String toString() {
        return ToString.builder("GetGeoLocationRequest").add("ContinentCode", continentCode()).add("CountryCode", countryCode())
                .add("SubdivisionCode", subdivisionCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContinentCode":
            return Optional.ofNullable(clazz.cast(continentCode()));
        case "CountryCode":
            return Optional.ofNullable(clazz.cast(countryCode()));
        case "SubdivisionCode":
            return Optional.ofNullable(clazz.cast(subdivisionCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetGeoLocationRequest, T> g) {
        return obj -> g.apply((GetGeoLocationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Request.Builder, SdkPojo, CopyableBuilder<Builder, GetGeoLocationRequest> {
        /**
         * <p>
         * Amazon Route 53 supports the following continent codes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>AF</b>: Africa
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>AN</b>: Antarctica
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>AS</b>: Asia
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>EU</b>: Europe
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>OC</b>: Oceania
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>NA</b>: North America
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SA</b>: South America
         * </p>
         * </li>
         * </ul>
         * 
         * @param continentCode
         *        Amazon Route 53 supports the following continent codes:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>AF</b>: Africa
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>AN</b>: Antarctica
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>AS</b>: Asia
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>EU</b>: Europe
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>OC</b>: Oceania
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>NA</b>: North America
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SA</b>: South America
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continentCode(String continentCode);

        /**
         * <p>
         * Amazon Route 53 uses the two-letter country codes that are specified in <a
         * href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>.
         * </p>
         * 
         * @param countryCode
         *        Amazon Route 53 uses the two-letter country codes that are specified in <a
         *        href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countryCode(String countryCode);

        /**
         * <p>
         * Amazon Route 53 uses the one- to three-letter subdivision codes that are specified in <a
         * href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>. Route 53 doesn't
         * support subdivision codes for all countries. If you specify <code>subdivisioncode</code>, you must also
         * specify <code>countrycode</code>.
         * </p>
         * 
         * @param subdivisionCode
         *        Amazon Route 53 uses the one- to three-letter subdivision codes that are specified in <a
         *        href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>. Route 53
         *        doesn't support subdivision codes for all countries. If you specify <code>subdivisioncode</code>, you
         *        must also specify <code>countrycode</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subdivisionCode(String subdivisionCode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String continentCode;

        private String countryCode;

        private String subdivisionCode;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGeoLocationRequest model) {
            super(model);
            continentCode(model.continentCode);
            countryCode(model.countryCode);
            subdivisionCode(model.subdivisionCode);
        }

        public final String getContinentCode() {
            return continentCode;
        }

        @Override
        public final Builder continentCode(String continentCode) {
            this.continentCode = continentCode;
            return this;
        }

        public final void setContinentCode(String continentCode) {
            this.continentCode = continentCode;
        }

        public final String getCountryCode() {
            return countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        public final String getSubdivisionCode() {
            return subdivisionCode;
        }

        @Override
        public final Builder subdivisionCode(String subdivisionCode) {
            this.subdivisionCode = subdivisionCode;
            return this;
        }

        public final void setSubdivisionCode(String subdivisionCode) {
            this.subdivisionCode = subdivisionCode;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetGeoLocationRequest build() {
            return new GetGeoLocationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
