/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains list information for the resource record set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResourceRecordSetsResponse extends Route53Response implements
        ToCopyableBuilder<ListResourceRecordSetsResponse.Builder, ListResourceRecordSetsResponse> {
    private static final SdkField<List<ResourceRecordSet>> RESOURCE_RECORD_SETS_FIELD = SdkField
            .<List<ResourceRecordSet>> builder(MarshallingType.LIST)
            .getter(getter(ListResourceRecordSetsResponse::resourceRecordSets))
            .setter(setter(Builder::resourceRecordSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRecordSets")
                    .unmarshallLocationName("ResourceRecordSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ResourceRecordSet")
                            .memberFieldInfo(
                                    SdkField.<ResourceRecordSet> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceRecordSet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ResourceRecordSet")
                                                    .unmarshallLocationName("ResourceRecordSet").build()).build()).build())
            .build();

    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ListResourceRecordSetsResponse::isTruncated))
            .setter(setter(Builder::isTruncated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated")
                    .unmarshallLocationName("IsTruncated").build()).build();

    private static final SdkField<String> NEXT_RECORD_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ListResourceRecordSetsResponse::nextRecordName))
            .setter(setter(Builder::nextRecordName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextRecordName")
                    .unmarshallLocationName("NextRecordName").build()).build();

    private static final SdkField<String> NEXT_RECORD_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ListResourceRecordSetsResponse::nextRecordTypeAsString))
            .setter(setter(Builder::nextRecordType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextRecordType")
                    .unmarshallLocationName("NextRecordType").build()).build();

    private static final SdkField<String> NEXT_RECORD_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ListResourceRecordSetsResponse::nextRecordIdentifier))
            .setter(setter(Builder::nextRecordIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextRecordIdentifier")
                    .unmarshallLocationName("NextRecordIdentifier").build()).build();

    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ListResourceRecordSetsResponse::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems")
                    .unmarshallLocationName("MaxItems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_RECORD_SETS_FIELD,
            IS_TRUNCATED_FIELD, NEXT_RECORD_NAME_FIELD, NEXT_RECORD_TYPE_FIELD, NEXT_RECORD_IDENTIFIER_FIELD, MAX_ITEMS_FIELD));

    private final List<ResourceRecordSet> resourceRecordSets;

    private final Boolean isTruncated;

    private final String nextRecordName;

    private final String nextRecordType;

    private final String nextRecordIdentifier;

    private final String maxItems;

    private ListResourceRecordSetsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceRecordSets = builder.resourceRecordSets;
        this.isTruncated = builder.isTruncated;
        this.nextRecordName = builder.nextRecordName;
        this.nextRecordType = builder.nextRecordType;
        this.nextRecordIdentifier = builder.nextRecordIdentifier;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * Information about multiple resource record sets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about multiple resource record sets.
     */
    public List<ResourceRecordSet> resourceRecordSets() {
        return resourceRecordSets;
    }

    /**
     * <p>
     * A flag that indicates whether more resource record sets remain to be listed. If your results were truncated, you
     * can make a follow-up pagination request by using the <code>NextRecordName</code> element.
     * </p>
     * 
     * @return A flag that indicates whether more resource record sets remain to be listed. If your results were
     *         truncated, you can make a follow-up pagination request by using the <code>NextRecordName</code> element.
     */
    public Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * If the results were truncated, the name of the next record in the list.
     * </p>
     * <p>
     * This element is present only if <code>IsTruncated</code> is true.
     * </p>
     * 
     * @return If the results were truncated, the name of the next record in the list.</p>
     *         <p>
     *         This element is present only if <code>IsTruncated</code> is true.
     */
    public String nextRecordName() {
        return nextRecordName;
    }

    /**
     * <p>
     * If the results were truncated, the type of the next record in the list.
     * </p>
     * <p>
     * This element is present only if <code>IsTruncated</code> is true.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nextRecordType}
     * will return {@link RRType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nextRecordTypeAsString}.
     * </p>
     * 
     * @return If the results were truncated, the type of the next record in the list.</p>
     *         <p>
     *         This element is present only if <code>IsTruncated</code> is true.
     * @see RRType
     */
    public RRType nextRecordType() {
        return RRType.fromValue(nextRecordType);
    }

    /**
     * <p>
     * If the results were truncated, the type of the next record in the list.
     * </p>
     * <p>
     * This element is present only if <code>IsTruncated</code> is true.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nextRecordType}
     * will return {@link RRType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nextRecordTypeAsString}.
     * </p>
     * 
     * @return If the results were truncated, the type of the next record in the list.</p>
     *         <p>
     *         This element is present only if <code>IsTruncated</code> is true.
     * @see RRType
     */
    public String nextRecordTypeAsString() {
        return nextRecordType;
    }

    /**
     * <p>
     * <i>Resource record sets that have a routing policy other than simple:</i> If results were truncated for a given
     * DNS name and type, the value of <code>SetIdentifier</code> for the next resource record set that has the current
     * DNS name and type.
     * </p>
     * <p>
     * For information about routing policies, see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html">Choosing a Routing Policy</a>
     * in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * 
     * @return <i>Resource record sets that have a routing policy other than simple:</i> If results were truncated for a
     *         given DNS name and type, the value of <code>SetIdentifier</code> for the next resource record set that
     *         has the current DNS name and type.</p>
     *         <p>
     *         For information about routing policies, see <a
     *         href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html">Choosing a Routing
     *         Policy</a> in the <i>Amazon Route 53 Developer Guide</i>.
     */
    public String nextRecordIdentifier() {
        return nextRecordIdentifier;
    }

    /**
     * <p>
     * The maximum number of records you requested.
     * </p>
     * 
     * @return The maximum number of records you requested.
     */
    public String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceRecordSets());
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(nextRecordName());
        hashCode = 31 * hashCode + Objects.hashCode(nextRecordTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextRecordIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceRecordSetsResponse)) {
            return false;
        }
        ListResourceRecordSetsResponse other = (ListResourceRecordSetsResponse) obj;
        return Objects.equals(resourceRecordSets(), other.resourceRecordSets())
                && Objects.equals(isTruncated(), other.isTruncated()) && Objects.equals(nextRecordName(), other.nextRecordName())
                && Objects.equals(nextRecordTypeAsString(), other.nextRecordTypeAsString())
                && Objects.equals(nextRecordIdentifier(), other.nextRecordIdentifier())
                && Objects.equals(maxItems(), other.maxItems());
    }

    @Override
    public String toString() {
        return ToString.builder("ListResourceRecordSetsResponse").add("ResourceRecordSets", resourceRecordSets())
                .add("IsTruncated", isTruncated()).add("NextRecordName", nextRecordName())
                .add("NextRecordType", nextRecordTypeAsString()).add("NextRecordIdentifier", nextRecordIdentifier())
                .add("MaxItems", maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceRecordSets":
            return Optional.ofNullable(clazz.cast(resourceRecordSets()));
        case "IsTruncated":
            return Optional.ofNullable(clazz.cast(isTruncated()));
        case "NextRecordName":
            return Optional.ofNullable(clazz.cast(nextRecordName()));
        case "NextRecordType":
            return Optional.ofNullable(clazz.cast(nextRecordTypeAsString()));
        case "NextRecordIdentifier":
            return Optional.ofNullable(clazz.cast(nextRecordIdentifier()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResourceRecordSetsResponse, T> g) {
        return obj -> g.apply((ListResourceRecordSetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo, CopyableBuilder<Builder, ListResourceRecordSetsResponse> {
        /**
         * <p>
         * Information about multiple resource record sets.
         * </p>
         * 
         * @param resourceRecordSets
         *        Information about multiple resource record sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRecordSets(Collection<ResourceRecordSet> resourceRecordSets);

        /**
         * <p>
         * Information about multiple resource record sets.
         * </p>
         * 
         * @param resourceRecordSets
         *        Information about multiple resource record sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRecordSets(ResourceRecordSet... resourceRecordSets);

        /**
         * <p>
         * Information about multiple resource record sets.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourceRecordSet>.Builder} avoiding the
         * need to create one manually via {@link List<ResourceRecordSet>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceRecordSet>.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceRecordSets(List<ResourceRecordSet>)}.
         * 
         * @param resourceRecordSets
         *        a consumer that will call methods on {@link List<ResourceRecordSet>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceRecordSets(List<ResourceRecordSet>)
         */
        Builder resourceRecordSets(Consumer<ResourceRecordSet.Builder>... resourceRecordSets);

        /**
         * <p>
         * A flag that indicates whether more resource record sets remain to be listed. If your results were truncated,
         * you can make a follow-up pagination request by using the <code>NextRecordName</code> element.
         * </p>
         * 
         * @param isTruncated
         *        A flag that indicates whether more resource record sets remain to be listed. If your results were
         *        truncated, you can make a follow-up pagination request by using the <code>NextRecordName</code>
         *        element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * If the results were truncated, the name of the next record in the list.
         * </p>
         * <p>
         * This element is present only if <code>IsTruncated</code> is true.
         * </p>
         * 
         * @param nextRecordName
         *        If the results were truncated, the name of the next record in the list.</p>
         *        <p>
         *        This element is present only if <code>IsTruncated</code> is true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextRecordName(String nextRecordName);

        /**
         * <p>
         * If the results were truncated, the type of the next record in the list.
         * </p>
         * <p>
         * This element is present only if <code>IsTruncated</code> is true.
         * </p>
         * 
         * @param nextRecordType
         *        If the results were truncated, the type of the next record in the list.</p>
         *        <p>
         *        This element is present only if <code>IsTruncated</code> is true.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder nextRecordType(String nextRecordType);

        /**
         * <p>
         * If the results were truncated, the type of the next record in the list.
         * </p>
         * <p>
         * This element is present only if <code>IsTruncated</code> is true.
         * </p>
         * 
         * @param nextRecordType
         *        If the results were truncated, the type of the next record in the list.</p>
         *        <p>
         *        This element is present only if <code>IsTruncated</code> is true.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder nextRecordType(RRType nextRecordType);

        /**
         * <p>
         * <i>Resource record sets that have a routing policy other than simple:</i> If results were truncated for a
         * given DNS name and type, the value of <code>SetIdentifier</code> for the next resource record set that has
         * the current DNS name and type.
         * </p>
         * <p>
         * For information about routing policies, see <a
         * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html">Choosing a Routing
         * Policy</a> in the <i>Amazon Route 53 Developer Guide</i>.
         * </p>
         * 
         * @param nextRecordIdentifier
         *        <i>Resource record sets that have a routing policy other than simple:</i> If results were truncated
         *        for a given DNS name and type, the value of <code>SetIdentifier</code> for the next resource record
         *        set that has the current DNS name and type.</p>
         *        <p>
         *        For information about routing policies, see <a
         *        href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html">Choosing a Routing
         *        Policy</a> in the <i>Amazon Route 53 Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextRecordIdentifier(String nextRecordIdentifier);

        /**
         * <p>
         * The maximum number of records you requested.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of records you requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private List<ResourceRecordSet> resourceRecordSets = DefaultSdkAutoConstructList.getInstance();

        private Boolean isTruncated;

        private String nextRecordName;

        private String nextRecordType;

        private String nextRecordIdentifier;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceRecordSetsResponse model) {
            super(model);
            resourceRecordSets(model.resourceRecordSets);
            isTruncated(model.isTruncated);
            nextRecordName(model.nextRecordName);
            nextRecordType(model.nextRecordType);
            nextRecordIdentifier(model.nextRecordIdentifier);
            maxItems(model.maxItems);
        }

        public final Collection<ResourceRecordSet.Builder> getResourceRecordSets() {
            return resourceRecordSets != null ? resourceRecordSets.stream().map(ResourceRecordSet::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceRecordSets(Collection<ResourceRecordSet> resourceRecordSets) {
            this.resourceRecordSets = ResourceRecordSetsCopier.copy(resourceRecordSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRecordSets(ResourceRecordSet... resourceRecordSets) {
            resourceRecordSets(Arrays.asList(resourceRecordSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRecordSets(Consumer<ResourceRecordSet.Builder>... resourceRecordSets) {
            resourceRecordSets(Stream.of(resourceRecordSets).map(c -> ResourceRecordSet.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResourceRecordSets(Collection<ResourceRecordSet.BuilderImpl> resourceRecordSets) {
            this.resourceRecordSets = ResourceRecordSetsCopier.copyFromBuilder(resourceRecordSets);
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getNextRecordName() {
            return nextRecordName;
        }

        @Override
        public final Builder nextRecordName(String nextRecordName) {
            this.nextRecordName = nextRecordName;
            return this;
        }

        public final void setNextRecordName(String nextRecordName) {
            this.nextRecordName = nextRecordName;
        }

        public final String getNextRecordTypeAsString() {
            return nextRecordType;
        }

        @Override
        public final Builder nextRecordType(String nextRecordType) {
            this.nextRecordType = nextRecordType;
            return this;
        }

        @Override
        public final Builder nextRecordType(RRType nextRecordType) {
            this.nextRecordType(nextRecordType.toString());
            return this;
        }

        public final void setNextRecordType(String nextRecordType) {
            this.nextRecordType = nextRecordType;
        }

        public final String getNextRecordIdentifier() {
            return nextRecordIdentifier;
        }

        @Override
        public final Builder nextRecordIdentifier(String nextRecordIdentifier) {
            this.nextRecordIdentifier = nextRecordIdentifier;
            return this;
        }

        public final void setNextRecordIdentifier(String nextRecordIdentifier) {
            this.nextRecordIdentifier = nextRecordIdentifier;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ListResourceRecordSetsResponse build() {
            return new ListResourceRecordSetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
