/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains an optional comment about your hosted zone. If you don't want to specify a comment, omit
 * both the <code>HostedZoneConfig</code> and <code>Comment</code> elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HostedZoneConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<HostedZoneConfig.Builder, HostedZoneConfig> {
    private static final SdkField<String> COMMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(HostedZoneConfig::comment))
            .setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment")
                    .unmarshallLocationName("Comment").build()).build();

    private static final SdkField<Boolean> PRIVATE_ZONE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(HostedZoneConfig::privateZone))
            .setter(setter(Builder::privateZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateZone")
                    .unmarshallLocationName("PrivateZone").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_FIELD,
            PRIVATE_ZONE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String comment;

    private final Boolean privateZone;

    private HostedZoneConfig(BuilderImpl builder) {
        this.comment = builder.comment;
        this.privateZone = builder.privateZone;
    }

    /**
     * <p>
     * Any comments that you want to include about the hosted zone.
     * </p>
     * 
     * @return Any comments that you want to include about the hosted zone.
     */
    public String comment() {
        return comment;
    }

    /**
     * <p>
     * A value that indicates whether this is a private hosted zone.
     * </p>
     * 
     * @return A value that indicates whether this is a private hosted zone.
     */
    public Boolean privateZone() {
        return privateZone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(privateZone());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostedZoneConfig)) {
            return false;
        }
        HostedZoneConfig other = (HostedZoneConfig) obj;
        return Objects.equals(comment(), other.comment()) && Objects.equals(privateZone(), other.privateZone());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HostedZoneConfig").add("Comment", comment()).add("PrivateZone", privateZone()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "PrivateZone":
            return Optional.ofNullable(clazz.cast(privateZone()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HostedZoneConfig, T> g) {
        return obj -> g.apply((HostedZoneConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HostedZoneConfig> {
        /**
         * <p>
         * Any comments that you want to include about the hosted zone.
         * </p>
         * 
         * @param comment
         *        Any comments that you want to include about the hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * A value that indicates whether this is a private hosted zone.
         * </p>
         * 
         * @param privateZone
         *        A value that indicates whether this is a private hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateZone(Boolean privateZone);
    }

    static final class BuilderImpl implements Builder {
        private String comment;

        private Boolean privateZone;

        private BuilderImpl() {
        }

        private BuilderImpl(HostedZoneConfig model) {
            comment(model.comment);
            privateZone(model.privateZone);
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final Boolean getPrivateZone() {
            return privateZone;
        }

        @Override
        public final Builder privateZone(Boolean privateZone) {
            this.privateZone = privateZone;
            return this;
        }

        public final void setPrivateZone(Boolean privateZone) {
            this.privateZone = privateZone;
        }

        @Override
        public HostedZoneConfig build() {
            return new HostedZoneConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
