/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53.Route53AsyncClient;
import software.amazon.awssdk.services.route53.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53.model.CidrBlockSummary;
import software.amazon.awssdk.services.route53.model.ListCidrBlocksRequest;
import software.amazon.awssdk.services.route53.model.ListCidrBlocksResponse;

public class ListCidrBlocksPublisher
implements SdkPublisher<ListCidrBlocksResponse> {
    private final Route53AsyncClient client;
    private final ListCidrBlocksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCidrBlocksPublisher(Route53AsyncClient client, ListCidrBlocksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCidrBlocksPublisher(Route53AsyncClient client, ListCidrBlocksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCidrBlocksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCidrBlocksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CidrBlockSummary> cidrBlocks() {
        Function<ListCidrBlocksResponse, Iterator> getIterator = response -> {
            if (response != null && response.cidrBlocks() != null) {
                return response.cidrBlocks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCidrBlocksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCidrBlocksResponseFetcher
    implements AsyncPageFetcher<ListCidrBlocksResponse> {
        private ListCidrBlocksResponseFetcher() {
        }

        public boolean hasNextPage(ListCidrBlocksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCidrBlocksResponse> nextPage(ListCidrBlocksResponse previousPage) {
            if (previousPage == null) {
                return ListCidrBlocksPublisher.this.client.listCidrBlocks(ListCidrBlocksPublisher.this.firstRequest);
            }
            return ListCidrBlocksPublisher.this.client.listCidrBlocks((ListCidrBlocksRequest)((Object)ListCidrBlocksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

