/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.route53.Route53AsyncClient;
import software.amazon.awssdk.services.route53.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsResponse;
import software.amazon.awssdk.services.route53.model.ResourceRecordSet;

public class ListResourceRecordSetsPublisher
implements SdkPublisher<ListResourceRecordSetsResponse> {
    private final Route53AsyncClient client;
    private final ListResourceRecordSetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResourceRecordSetsPublisher(Route53AsyncClient client, ListResourceRecordSetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResourceRecordSetsPublisher(Route53AsyncClient client, ListResourceRecordSetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResourceRecordSetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResourceRecordSetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResourceRecordSet> resourceRecordSets() {
        Function<ListResourceRecordSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceRecordSets() != null) {
                return response.resourceRecordSets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListResourceRecordSetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListResourceRecordSetsResponseFetcher
    implements AsyncPageFetcher<ListResourceRecordSetsResponse> {
        private ListResourceRecordSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceRecordSetsResponse previousPage) {
            return previousPage.isTruncated() != null && previousPage.isTruncated() != false;
        }

        public CompletableFuture<ListResourceRecordSetsResponse> nextPage(ListResourceRecordSetsResponse previousPage) {
            if (previousPage == null) {
                return ListResourceRecordSetsPublisher.this.client.listResourceRecordSets(ListResourceRecordSetsPublisher.this.firstRequest);
            }
            return ListResourceRecordSetsPublisher.this.client.listResourceRecordSets((ListResourceRecordSetsRequest)((Object)ListResourceRecordSetsPublisher.this.firstRequest.toBuilder().startRecordName(previousPage.nextRecordName()).startRecordType(previousPage.nextRecordTypeAsString()).startRecordIdentifier(previousPage.nextRecordIdentifier()).build()));
        }
    }
}

