/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCidrBlocksResponse extends Route53Response implements
        ToCopyableBuilder<ListCidrBlocksResponse.Builder, ListCidrBlocksResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(ListCidrBlocksResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final SdkField<List<CidrBlockSummary>> CIDR_BLOCKS_FIELD = SdkField
            .<List<CidrBlockSummary>> builder(MarshallingType.LIST)
            .memberName("CidrBlocks")
            .getter(getter(ListCidrBlocksResponse::cidrBlocks))
            .setter(setter(Builder::cidrBlocks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlocks")
                    .unmarshallLocationName("CidrBlocks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CidrBlockSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(CidrBlockSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            CIDR_BLOCKS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<CidrBlockSummary> cidrBlocks;

    private ListCidrBlocksResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.cidrBlocks = builder.cidrBlocks;
    }

    /**
     * <p>
     * An opaque pagination token to indicate where the service is to begin enumerating results.
     * </p>
     * <p>
     * If no value is provided, the listing of results starts from the beginning.
     * </p>
     * 
     * @return An opaque pagination token to indicate where the service is to begin enumerating results. </p>
     *         <p>
     *         If no value is provided, the listing of results starts from the beginning.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CidrBlocks property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCidrBlocks() {
        return cidrBlocks != null && !(cidrBlocks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A complex type that contains information about the CIDR blocks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCidrBlocks} method.
     * </p>
     * 
     * @return A complex type that contains information about the CIDR blocks.
     */
    public final List<CidrBlockSummary> cidrBlocks() {
        return cidrBlocks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasCidrBlocks() ? cidrBlocks() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCidrBlocksResponse)) {
            return false;
        }
        ListCidrBlocksResponse other = (ListCidrBlocksResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasCidrBlocks() == other.hasCidrBlocks()
                && Objects.equals(cidrBlocks(), other.cidrBlocks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCidrBlocksResponse").add("NextToken", nextToken())
                .add("CidrBlocks", hasCidrBlocks() ? cidrBlocks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "CidrBlocks":
            return Optional.ofNullable(clazz.cast(cidrBlocks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("CidrBlocks", CIDR_BLOCKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCidrBlocksResponse, T> g) {
        return obj -> g.apply((ListCidrBlocksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Route53Response.Builder, SdkPojo, CopyableBuilder<Builder, ListCidrBlocksResponse> {
        /**
         * <p>
         * An opaque pagination token to indicate where the service is to begin enumerating results.
         * </p>
         * <p>
         * If no value is provided, the listing of results starts from the beginning.
         * </p>
         * 
         * @param nextToken
         *        An opaque pagination token to indicate where the service is to begin enumerating results. </p>
         *        <p>
         *        If no value is provided, the listing of results starts from the beginning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A complex type that contains information about the CIDR blocks.
         * </p>
         * 
         * @param cidrBlocks
         *        A complex type that contains information about the CIDR blocks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlocks(Collection<CidrBlockSummary> cidrBlocks);

        /**
         * <p>
         * A complex type that contains information about the CIDR blocks.
         * </p>
         * 
         * @param cidrBlocks
         *        A complex type that contains information about the CIDR blocks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlocks(CidrBlockSummary... cidrBlocks);

        /**
         * <p>
         * A complex type that contains information about the CIDR blocks.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.route53.model.CidrBlockSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.route53.model.CidrBlockSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.route53.model.CidrBlockSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #cidrBlocks(List<CidrBlockSummary>)}.
         * 
         * @param cidrBlocks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.route53.model.CidrBlockSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cidrBlocks(java.util.Collection<CidrBlockSummary>)
         */
        Builder cidrBlocks(Consumer<CidrBlockSummary.Builder>... cidrBlocks);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<CidrBlockSummary> cidrBlocks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCidrBlocksResponse model) {
            super(model);
            nextToken(model.nextToken);
            cidrBlocks(model.cidrBlocks);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CidrBlockSummary.Builder> getCidrBlocks() {
            List<CidrBlockSummary.Builder> result = CidrBlockSummariesCopier.copyToBuilder(this.cidrBlocks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCidrBlocks(Collection<CidrBlockSummary.BuilderImpl> cidrBlocks) {
            this.cidrBlocks = CidrBlockSummariesCopier.copyFromBuilder(cidrBlocks);
        }

        @Override
        public final Builder cidrBlocks(Collection<CidrBlockSummary> cidrBlocks) {
            this.cidrBlocks = CidrBlockSummariesCopier.copy(cidrBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrBlocks(CidrBlockSummary... cidrBlocks) {
            cidrBlocks(Arrays.asList(cidrBlocks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrBlocks(Consumer<CidrBlockSummary.Builder>... cidrBlocks) {
            cidrBlocks(Stream.of(cidrBlocks).map(c -> CidrBlockSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCidrBlocksResponse build() {
            return new ListCidrBlocksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
