/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.Coordinates;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeoProximityLocation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeoProximityLocation> {
    private static final SdkField<String> AWS_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AWSRegion").getter(GeoProximityLocation.getter(GeoProximityLocation::awsRegion)).setter(GeoProximityLocation.setter(Builder::awsRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AWSRegion").unmarshallLocationName("AWSRegion").build()}).build();
    private static final SdkField<String> LOCAL_ZONE_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalZoneGroup").getter(GeoProximityLocation.getter(GeoProximityLocation::localZoneGroup)).setter(GeoProximityLocation.setter(Builder::localZoneGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalZoneGroup").unmarshallLocationName("LocalZoneGroup").build()}).build();
    private static final SdkField<Coordinates> COORDINATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Coordinates").getter(GeoProximityLocation.getter(GeoProximityLocation::coordinates)).setter(GeoProximityLocation.setter(Builder::coordinates)).constructor(Coordinates::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Coordinates").unmarshallLocationName("Coordinates").build()}).build();
    private static final SdkField<Integer> BIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Bias").getter(GeoProximityLocation.getter(GeoProximityLocation::bias)).setter(GeoProximityLocation.setter(Builder::bias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bias").unmarshallLocationName("Bias").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_REGION_FIELD, LOCAL_ZONE_GROUP_FIELD, COORDINATES_FIELD, BIAS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GeoProximityLocation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String awsRegion;
    private final String localZoneGroup;
    private final Coordinates coordinates;
    private final Integer bias;

    private GeoProximityLocation(BuilderImpl builder) {
        this.awsRegion = builder.awsRegion;
        this.localZoneGroup = builder.localZoneGroup;
        this.coordinates = builder.coordinates;
        this.bias = builder.bias;
    }

    public final String awsRegion() {
        return this.awsRegion;
    }

    public final String localZoneGroup() {
        return this.localZoneGroup;
    }

    public final Coordinates coordinates() {
        return this.coordinates;
    }

    public final Integer bias() {
        return this.bias;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.localZoneGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.coordinates());
        hashCode = 31 * hashCode + Objects.hashCode(this.bias());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoProximityLocation)) {
            return false;
        }
        GeoProximityLocation other = (GeoProximityLocation)obj;
        return Objects.equals(this.awsRegion(), other.awsRegion()) && Objects.equals(this.localZoneGroup(), other.localZoneGroup()) && Objects.equals(this.coordinates(), other.coordinates()) && Objects.equals(this.bias(), other.bias());
    }

    public final String toString() {
        return ToString.builder((String)"GeoProximityLocation").add("AWSRegion", (Object)this.awsRegion()).add("LocalZoneGroup", (Object)this.localZoneGroup()).add("Coordinates", (Object)this.coordinates()).add("Bias", (Object)this.bias()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AWSRegion": {
                return Optional.ofNullable(clazz.cast(this.awsRegion()));
            }
            case "LocalZoneGroup": {
                return Optional.ofNullable(clazz.cast(this.localZoneGroup()));
            }
            case "Coordinates": {
                return Optional.ofNullable(clazz.cast(this.coordinates()));
            }
            case "Bias": {
                return Optional.ofNullable(clazz.cast(this.bias()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AWSRegion", AWS_REGION_FIELD);
        map.put("LocalZoneGroup", LOCAL_ZONE_GROUP_FIELD);
        map.put("Coordinates", COORDINATES_FIELD);
        map.put("Bias", BIAS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeoProximityLocation, T> g) {
        return obj -> g.apply((GeoProximityLocation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String awsRegion;
        private String localZoneGroup;
        private Coordinates coordinates;
        private Integer bias;

        private BuilderImpl() {
        }

        private BuilderImpl(GeoProximityLocation model) {
            this.awsRegion(model.awsRegion);
            this.localZoneGroup(model.localZoneGroup);
            this.coordinates(model.coordinates);
            this.bias(model.bias);
        }

        public final String getAwsRegion() {
            return this.awsRegion;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final String getLocalZoneGroup() {
            return this.localZoneGroup;
        }

        public final void setLocalZoneGroup(String localZoneGroup) {
            this.localZoneGroup = localZoneGroup;
        }

        @Override
        public final Builder localZoneGroup(String localZoneGroup) {
            this.localZoneGroup = localZoneGroup;
            return this;
        }

        public final Coordinates.Builder getCoordinates() {
            return this.coordinates != null ? this.coordinates.toBuilder() : null;
        }

        public final void setCoordinates(Coordinates.BuilderImpl coordinates) {
            this.coordinates = coordinates != null ? coordinates.build() : null;
        }

        @Override
        public final Builder coordinates(Coordinates coordinates) {
            this.coordinates = coordinates;
            return this;
        }

        public final Integer getBias() {
            return this.bias;
        }

        public final void setBias(Integer bias) {
            this.bias = bias;
        }

        @Override
        public final Builder bias(Integer bias) {
            this.bias = bias;
            return this;
        }

        public GeoProximityLocation build() {
            return new GeoProximityLocation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeoProximityLocation> {
        public Builder awsRegion(String var1);

        public Builder localZoneGroup(String var1);

        public Builder coordinates(Coordinates var1);

        default public Builder coordinates(Consumer<Coordinates.Builder> coordinates) {
            return this.coordinates((Coordinates)((Coordinates.Builder)Coordinates.builder().applyMutation(coordinates)).build());
        }

        public Builder bias(Integer var1);
    }
}

