/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the information about the request to list your traffic policy instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTrafficPolicyInstancesByPolicyRequest extends Route53Request implements
        ToCopyableBuilder<ListTrafficPolicyInstancesByPolicyRequest.Builder, ListTrafficPolicyInstancesByPolicyRequest> {
    private static final SdkField<String> TRAFFIC_POLICY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrafficPolicyId")
            .getter(getter(ListTrafficPolicyInstancesByPolicyRequest::trafficPolicyId))
            .setter(setter(Builder::trafficPolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("id")
                    .unmarshallLocationName("id").build()).build();

    private static final SdkField<Integer> TRAFFIC_POLICY_VERSION_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TrafficPolicyVersion")
            .getter(getter(ListTrafficPolicyInstancesByPolicyRequest::trafficPolicyVersion))
            .setter(setter(Builder::trafficPolicyVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("version")
                    .unmarshallLocationName("version").build()).build();

    private static final SdkField<String> HOSTED_ZONE_ID_MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HostedZoneIdMarker")
            .getter(getter(ListTrafficPolicyInstancesByPolicyRequest::hostedZoneIdMarker))
            .setter(setter(Builder::hostedZoneIdMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("hostedzoneid")
                    .unmarshallLocationName("hostedzoneid").build()).build();

    private static final SdkField<String> TRAFFIC_POLICY_INSTANCE_NAME_MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrafficPolicyInstanceNameMarker")
            .getter(getter(ListTrafficPolicyInstancesByPolicyRequest::trafficPolicyInstanceNameMarker))
            .setter(setter(Builder::trafficPolicyInstanceNameMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("trafficpolicyinstancename")
                    .unmarshallLocationName("trafficpolicyinstancename").build()).build();

    private static final SdkField<String> TRAFFIC_POLICY_INSTANCE_TYPE_MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrafficPolicyInstanceTypeMarker")
            .getter(getter(ListTrafficPolicyInstancesByPolicyRequest::trafficPolicyInstanceTypeMarkerAsString))
            .setter(setter(Builder::trafficPolicyInstanceTypeMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("trafficpolicyinstancetype")
                    .unmarshallLocationName("trafficpolicyinstancetype").build()).build();

    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MaxItems")
            .getter(getter(ListTrafficPolicyInstancesByPolicyRequest::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxitems")
                    .unmarshallLocationName("maxitems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_POLICY_ID_FIELD,
            TRAFFIC_POLICY_VERSION_FIELD, HOSTED_ZONE_ID_MARKER_FIELD, TRAFFIC_POLICY_INSTANCE_NAME_MARKER_FIELD,
            TRAFFIC_POLICY_INSTANCE_TYPE_MARKER_FIELD, MAX_ITEMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String trafficPolicyId;

    private final Integer trafficPolicyVersion;

    private final String hostedZoneIdMarker;

    private final String trafficPolicyInstanceNameMarker;

    private final String trafficPolicyInstanceTypeMarker;

    private final String maxItems;

    private ListTrafficPolicyInstancesByPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.trafficPolicyId = builder.trafficPolicyId;
        this.trafficPolicyVersion = builder.trafficPolicyVersion;
        this.hostedZoneIdMarker = builder.hostedZoneIdMarker;
        this.trafficPolicyInstanceNameMarker = builder.trafficPolicyInstanceNameMarker;
        this.trafficPolicyInstanceTypeMarker = builder.trafficPolicyInstanceTypeMarker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * The ID of the traffic policy for which you want to list traffic policy instances.
     * </p>
     * 
     * @return The ID of the traffic policy for which you want to list traffic policy instances.
     */
    public final String trafficPolicyId() {
        return trafficPolicyId;
    }

    /**
     * <p>
     * The version of the traffic policy for which you want to list traffic policy instances. The version must be
     * associated with the traffic policy that is specified by <code>TrafficPolicyId</code>.
     * </p>
     * 
     * @return The version of the traffic policy for which you want to list traffic policy instances. The version must
     *         be associated with the traffic policy that is specified by <code>TrafficPolicyId</code>.
     */
    public final Integer trafficPolicyVersion() {
        return trafficPolicyVersion;
    }

    /**
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic
     * policy instances. To get more traffic policy instances, submit another
     * <code>ListTrafficPolicyInstancesByPolicy</code> request.
     * </p>
     * <p>
     * For the value of <code>hostedzoneid</code>, specify the value of <code>HostedZoneIdMarker</code> from the
     * previous response, which is the hosted zone ID of the first traffic policy instance that Amazon Route 53 will
     * return if you submit another request.
     * </p>
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
     * traffic policy instances to get.
     * </p>
     * 
     * @return If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
     *         traffic policy instances. To get more traffic policy instances, submit another
     *         <code>ListTrafficPolicyInstancesByPolicy</code> request. </p>
     *         <p>
     *         For the value of <code>hostedzoneid</code>, specify the value of <code>HostedZoneIdMarker</code> from the
     *         previous response, which is the hosted zone ID of the first traffic policy instance that Amazon Route 53
     *         will return if you submit another request.
     *         </p>
     *         <p>
     *         If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
     *         more traffic policy instances to get.
     */
    public final String hostedZoneIdMarker() {
        return hostedZoneIdMarker;
    }

    /**
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic
     * policy instances. To get more traffic policy instances, submit another
     * <code>ListTrafficPolicyInstancesByPolicy</code> request.
     * </p>
     * <p>
     * For the value of <code>trafficpolicyinstancename</code>, specify the value of
     * <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first traffic
     * policy instance that Amazon Route 53 will return if you submit another request.
     * </p>
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
     * traffic policy instances to get.
     * </p>
     * 
     * @return If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
     *         traffic policy instances. To get more traffic policy instances, submit another
     *         <code>ListTrafficPolicyInstancesByPolicy</code> request.</p>
     *         <p>
     *         For the value of <code>trafficpolicyinstancename</code>, specify the value of
     *         <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first
     *         traffic policy instance that Amazon Route 53 will return if you submit another request.
     *         </p>
     *         <p>
     *         If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
     *         more traffic policy instances to get.
     */
    public final String trafficPolicyInstanceNameMarker() {
        return trafficPolicyInstanceNameMarker;
    }

    /**
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic
     * policy instances. To get more traffic policy instances, submit another
     * <code>ListTrafficPolicyInstancesByPolicy</code> request.
     * </p>
     * <p>
     * For the value of <code>trafficpolicyinstancetype</code>, specify the value of
     * <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the name of the first traffic
     * policy instance that Amazon Route 53 will return if you submit another request.
     * </p>
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
     * traffic policy instances to get.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trafficPolicyInstanceTypeMarker} will return {@link RRType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #trafficPolicyInstanceTypeMarkerAsString}.
     * </p>
     * 
     * @return If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
     *         traffic policy instances. To get more traffic policy instances, submit another
     *         <code>ListTrafficPolicyInstancesByPolicy</code> request.</p>
     *         <p>
     *         For the value of <code>trafficpolicyinstancetype</code>, specify the value of
     *         <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the name of the first
     *         traffic policy instance that Amazon Route 53 will return if you submit another request.
     *         </p>
     *         <p>
     *         If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
     *         more traffic policy instances to get.
     * @see RRType
     */
    public final RRType trafficPolicyInstanceTypeMarker() {
        return RRType.fromValue(trafficPolicyInstanceTypeMarker);
    }

    /**
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic
     * policy instances. To get more traffic policy instances, submit another
     * <code>ListTrafficPolicyInstancesByPolicy</code> request.
     * </p>
     * <p>
     * For the value of <code>trafficpolicyinstancetype</code>, specify the value of
     * <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the name of the first traffic
     * policy instance that Amazon Route 53 will return if you submit another request.
     * </p>
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
     * traffic policy instances to get.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trafficPolicyInstanceTypeMarker} will return {@link RRType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #trafficPolicyInstanceTypeMarkerAsString}.
     * </p>
     * 
     * @return If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
     *         traffic policy instances. To get more traffic policy instances, submit another
     *         <code>ListTrafficPolicyInstancesByPolicy</code> request.</p>
     *         <p>
     *         For the value of <code>trafficpolicyinstancetype</code>, specify the value of
     *         <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the name of the first
     *         traffic policy instance that Amazon Route 53 will return if you submit another request.
     *         </p>
     *         <p>
     *         If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
     *         more traffic policy instances to get.
     * @see RRType
     */
    public final String trafficPolicyInstanceTypeMarkerAsString() {
        return trafficPolicyInstanceTypeMarker;
    }

    /**
     * <p>
     * The maximum number of traffic policy instances to be included in the response body for this request. If you have
     * more than <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code> element in
     * the response is <code>true</code>, and the values of <code>HostedZoneIdMarker</code>,
     * <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> represent the
     * first traffic policy instance that Amazon Route 53 will return if you submit another request.
     * </p>
     * 
     * @return The maximum number of traffic policy instances to be included in the response body for this request. If
     *         you have more than <code>MaxItems</code> traffic policy instances, the value of the
     *         <code>IsTruncated</code> element in the response is <code>true</code>, and the values of
     *         <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and
     *         <code>TrafficPolicyInstanceTypeMarker</code> represent the first traffic policy instance that Amazon
     *         Route 53 will return if you submit another request.
     */
    public final String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneIdMarker());
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyInstanceNameMarker());
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyInstanceTypeMarkerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrafficPolicyInstancesByPolicyRequest)) {
            return false;
        }
        ListTrafficPolicyInstancesByPolicyRequest other = (ListTrafficPolicyInstancesByPolicyRequest) obj;
        return Objects.equals(trafficPolicyId(), other.trafficPolicyId())
                && Objects.equals(trafficPolicyVersion(), other.trafficPolicyVersion())
                && Objects.equals(hostedZoneIdMarker(), other.hostedZoneIdMarker())
                && Objects.equals(trafficPolicyInstanceNameMarker(), other.trafficPolicyInstanceNameMarker())
                && Objects.equals(trafficPolicyInstanceTypeMarkerAsString(), other.trafficPolicyInstanceTypeMarkerAsString())
                && Objects.equals(maxItems(), other.maxItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTrafficPolicyInstancesByPolicyRequest").add("TrafficPolicyId", trafficPolicyId())
                .add("TrafficPolicyVersion", trafficPolicyVersion()).add("HostedZoneIdMarker", hostedZoneIdMarker())
                .add("TrafficPolicyInstanceNameMarker", trafficPolicyInstanceNameMarker())
                .add("TrafficPolicyInstanceTypeMarker", trafficPolicyInstanceTypeMarkerAsString()).add("MaxItems", maxItems())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficPolicyId":
            return Optional.ofNullable(clazz.cast(trafficPolicyId()));
        case "TrafficPolicyVersion":
            return Optional.ofNullable(clazz.cast(trafficPolicyVersion()));
        case "HostedZoneIdMarker":
            return Optional.ofNullable(clazz.cast(hostedZoneIdMarker()));
        case "TrafficPolicyInstanceNameMarker":
            return Optional.ofNullable(clazz.cast(trafficPolicyInstanceNameMarker()));
        case "TrafficPolicyInstanceTypeMarker":
            return Optional.ofNullable(clazz.cast(trafficPolicyInstanceTypeMarkerAsString()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", TRAFFIC_POLICY_ID_FIELD);
        map.put("version", TRAFFIC_POLICY_VERSION_FIELD);
        map.put("hostedzoneid", HOSTED_ZONE_ID_MARKER_FIELD);
        map.put("trafficpolicyinstancename", TRAFFIC_POLICY_INSTANCE_NAME_MARKER_FIELD);
        map.put("trafficpolicyinstancetype", TRAFFIC_POLICY_INSTANCE_TYPE_MARKER_FIELD);
        map.put("maxitems", MAX_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTrafficPolicyInstancesByPolicyRequest, T> g) {
        return obj -> g.apply((ListTrafficPolicyInstancesByPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Route53Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ListTrafficPolicyInstancesByPolicyRequest> {
        /**
         * <p>
         * The ID of the traffic policy for which you want to list traffic policy instances.
         * </p>
         * 
         * @param trafficPolicyId
         *        The ID of the traffic policy for which you want to list traffic policy instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyId(String trafficPolicyId);

        /**
         * <p>
         * The version of the traffic policy for which you want to list traffic policy instances. The version must be
         * associated with the traffic policy that is specified by <code>TrafficPolicyId</code>.
         * </p>
         * 
         * @param trafficPolicyVersion
         *        The version of the traffic policy for which you want to list traffic policy instances. The version
         *        must be associated with the traffic policy that is specified by <code>TrafficPolicyId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyVersion(Integer trafficPolicyVersion);

        /**
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         * traffic policy instances. To get more traffic policy instances, submit another
         * <code>ListTrafficPolicyInstancesByPolicy</code> request.
         * </p>
         * <p>
         * For the value of <code>hostedzoneid</code>, specify the value of <code>HostedZoneIdMarker</code> from the
         * previous response, which is the hosted zone ID of the first traffic policy instance that Amazon Route 53 will
         * return if you submit another request.
         * </p>
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
         * traffic policy instances to get.
         * </p>
         * 
         * @param hostedZoneIdMarker
         *        If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         *        traffic policy instances. To get more traffic policy instances, submit another
         *        <code>ListTrafficPolicyInstancesByPolicy</code> request. </p>
         *        <p>
         *        For the value of <code>hostedzoneid</code>, specify the value of <code>HostedZoneIdMarker</code> from
         *        the previous response, which is the hosted zone ID of the first traffic policy instance that Amazon
         *        Route 53 will return if you submit another request.
         *        </p>
         *        <p>
         *        If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
         *        more traffic policy instances to get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneIdMarker(String hostedZoneIdMarker);

        /**
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         * traffic policy instances. To get more traffic policy instances, submit another
         * <code>ListTrafficPolicyInstancesByPolicy</code> request.
         * </p>
         * <p>
         * For the value of <code>trafficpolicyinstancename</code>, specify the value of
         * <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first
         * traffic policy instance that Amazon Route 53 will return if you submit another request.
         * </p>
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
         * traffic policy instances to get.
         * </p>
         * 
         * @param trafficPolicyInstanceNameMarker
         *        If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         *        traffic policy instances. To get more traffic policy instances, submit another
         *        <code>ListTrafficPolicyInstancesByPolicy</code> request.</p>
         *        <p>
         *        For the value of <code>trafficpolicyinstancename</code>, specify the value of
         *        <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the
         *        first traffic policy instance that Amazon Route 53 will return if you submit another request.
         *        </p>
         *        <p>
         *        If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
         *        more traffic policy instances to get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyInstanceNameMarker(String trafficPolicyInstanceNameMarker);

        /**
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         * traffic policy instances. To get more traffic policy instances, submit another
         * <code>ListTrafficPolicyInstancesByPolicy</code> request.
         * </p>
         * <p>
         * For the value of <code>trafficpolicyinstancetype</code>, specify the value of
         * <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the name of the first
         * traffic policy instance that Amazon Route 53 will return if you submit another request.
         * </p>
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
         * traffic policy instances to get.
         * </p>
         * 
         * @param trafficPolicyInstanceTypeMarker
         *        If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         *        traffic policy instances. To get more traffic policy instances, submit another
         *        <code>ListTrafficPolicyInstancesByPolicy</code> request.</p>
         *        <p>
         *        For the value of <code>trafficpolicyinstancetype</code>, specify the value of
         *        <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the name of the
         *        first traffic policy instance that Amazon Route 53 will return if you submit another request.
         *        </p>
         *        <p>
         *        If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
         *        more traffic policy instances to get.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder trafficPolicyInstanceTypeMarker(String trafficPolicyInstanceTypeMarker);

        /**
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         * traffic policy instances. To get more traffic policy instances, submit another
         * <code>ListTrafficPolicyInstancesByPolicy</code> request.
         * </p>
         * <p>
         * For the value of <code>trafficpolicyinstancetype</code>, specify the value of
         * <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the name of the first
         * traffic policy instance that Amazon Route 53 will return if you submit another request.
         * </p>
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
         * traffic policy instances to get.
         * </p>
         * 
         * @param trafficPolicyInstanceTypeMarker
         *        If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         *        traffic policy instances. To get more traffic policy instances, submit another
         *        <code>ListTrafficPolicyInstancesByPolicy</code> request.</p>
         *        <p>
         *        For the value of <code>trafficpolicyinstancetype</code>, specify the value of
         *        <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the name of the
         *        first traffic policy instance that Amazon Route 53 will return if you submit another request.
         *        </p>
         *        <p>
         *        If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
         *        more traffic policy instances to get.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder trafficPolicyInstanceTypeMarker(RRType trafficPolicyInstanceTypeMarker);

        /**
         * <p>
         * The maximum number of traffic policy instances to be included in the response body for this request. If you
         * have more than <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code>
         * element in the response is <code>true</code>, and the values of <code>HostedZoneIdMarker</code>,
         * <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> represent the
         * first traffic policy instance that Amazon Route 53 will return if you submit another request.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of traffic policy instances to be included in the response body for this request.
         *        If you have more than <code>MaxItems</code> traffic policy instances, the value of the
         *        <code>IsTruncated</code> element in the response is <code>true</code>, and the values of
         *        <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and
         *        <code>TrafficPolicyInstanceTypeMarker</code> represent the first traffic policy instance that Amazon
         *        Route 53 will return if you submit another request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String trafficPolicyId;

        private Integer trafficPolicyVersion;

        private String hostedZoneIdMarker;

        private String trafficPolicyInstanceNameMarker;

        private String trafficPolicyInstanceTypeMarker;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrafficPolicyInstancesByPolicyRequest model) {
            super(model);
            trafficPolicyId(model.trafficPolicyId);
            trafficPolicyVersion(model.trafficPolicyVersion);
            hostedZoneIdMarker(model.hostedZoneIdMarker);
            trafficPolicyInstanceNameMarker(model.trafficPolicyInstanceNameMarker);
            trafficPolicyInstanceTypeMarker(model.trafficPolicyInstanceTypeMarker);
            maxItems(model.maxItems);
        }

        public final String getTrafficPolicyId() {
            return trafficPolicyId;
        }

        public final void setTrafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
        }

        @Override
        public final Builder trafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
            return this;
        }

        public final Integer getTrafficPolicyVersion() {
            return trafficPolicyVersion;
        }

        public final void setTrafficPolicyVersion(Integer trafficPolicyVersion) {
            this.trafficPolicyVersion = trafficPolicyVersion;
        }

        @Override
        public final Builder trafficPolicyVersion(Integer trafficPolicyVersion) {
            this.trafficPolicyVersion = trafficPolicyVersion;
            return this;
        }

        public final String getHostedZoneIdMarker() {
            return hostedZoneIdMarker;
        }

        public final void setHostedZoneIdMarker(String hostedZoneIdMarker) {
            this.hostedZoneIdMarker = hostedZoneIdMarker;
        }

        @Override
        public final Builder hostedZoneIdMarker(String hostedZoneIdMarker) {
            this.hostedZoneIdMarker = hostedZoneIdMarker;
            return this;
        }

        public final String getTrafficPolicyInstanceNameMarker() {
            return trafficPolicyInstanceNameMarker;
        }

        public final void setTrafficPolicyInstanceNameMarker(String trafficPolicyInstanceNameMarker) {
            this.trafficPolicyInstanceNameMarker = trafficPolicyInstanceNameMarker;
        }

        @Override
        public final Builder trafficPolicyInstanceNameMarker(String trafficPolicyInstanceNameMarker) {
            this.trafficPolicyInstanceNameMarker = trafficPolicyInstanceNameMarker;
            return this;
        }

        public final String getTrafficPolicyInstanceTypeMarker() {
            return trafficPolicyInstanceTypeMarker;
        }

        public final void setTrafficPolicyInstanceTypeMarker(String trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker = trafficPolicyInstanceTypeMarker;
        }

        @Override
        public final Builder trafficPolicyInstanceTypeMarker(String trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker = trafficPolicyInstanceTypeMarker;
            return this;
        }

        @Override
        public final Builder trafficPolicyInstanceTypeMarker(RRType trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker(trafficPolicyInstanceTypeMarker == null ? null : trafficPolicyInstanceTypeMarker
                    .toString());
            return this;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTrafficPolicyInstancesByPolicyRequest build() {
            return new ListTrafficPolicyInstancesByPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
