/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.Response;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.xml.AwsXmlProtocolFactory;
import software.amazon.awssdk.protocols.xml.XmlOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.route53.internal.Route53ServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.route53.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.route53.model.ActivateKeySigningKeyRequest;
import software.amazon.awssdk.services.route53.model.ActivateKeySigningKeyResponse;
import software.amazon.awssdk.services.route53.model.AssociateVpcWithHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.AssociateVpcWithHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.ChangeCidrCollectionRequest;
import software.amazon.awssdk.services.route53.model.ChangeCidrCollectionResponse;
import software.amazon.awssdk.services.route53.model.ChangeResourceRecordSetsRequest;
import software.amazon.awssdk.services.route53.model.ChangeResourceRecordSetsResponse;
import software.amazon.awssdk.services.route53.model.ChangeTagsForResourceRequest;
import software.amazon.awssdk.services.route53.model.ChangeTagsForResourceResponse;
import software.amazon.awssdk.services.route53.model.CidrBlockInUseException;
import software.amazon.awssdk.services.route53.model.CidrCollectionAlreadyExistsException;
import software.amazon.awssdk.services.route53.model.CidrCollectionInUseException;
import software.amazon.awssdk.services.route53.model.CidrCollectionVersionMismatchException;
import software.amazon.awssdk.services.route53.model.ConcurrentModificationException;
import software.amazon.awssdk.services.route53.model.ConflictingDomainExistsException;
import software.amazon.awssdk.services.route53.model.ConflictingTypesException;
import software.amazon.awssdk.services.route53.model.CreateCidrCollectionRequest;
import software.amazon.awssdk.services.route53.model.CreateCidrCollectionResponse;
import software.amazon.awssdk.services.route53.model.CreateHealthCheckRequest;
import software.amazon.awssdk.services.route53.model.CreateHealthCheckResponse;
import software.amazon.awssdk.services.route53.model.CreateHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.CreateHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.CreateKeySigningKeyRequest;
import software.amazon.awssdk.services.route53.model.CreateKeySigningKeyResponse;
import software.amazon.awssdk.services.route53.model.CreateQueryLoggingConfigRequest;
import software.amazon.awssdk.services.route53.model.CreateQueryLoggingConfigResponse;
import software.amazon.awssdk.services.route53.model.CreateReusableDelegationSetRequest;
import software.amazon.awssdk.services.route53.model.CreateReusableDelegationSetResponse;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyInstanceRequest;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyInstanceResponse;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyRequest;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyResponse;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyVersionRequest;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyVersionResponse;
import software.amazon.awssdk.services.route53.model.CreateVpcAssociationAuthorizationRequest;
import software.amazon.awssdk.services.route53.model.CreateVpcAssociationAuthorizationResponse;
import software.amazon.awssdk.services.route53.model.DeactivateKeySigningKeyRequest;
import software.amazon.awssdk.services.route53.model.DeactivateKeySigningKeyResponse;
import software.amazon.awssdk.services.route53.model.DelegationSetAlreadyCreatedException;
import software.amazon.awssdk.services.route53.model.DelegationSetAlreadyReusableException;
import software.amazon.awssdk.services.route53.model.DelegationSetInUseException;
import software.amazon.awssdk.services.route53.model.DelegationSetNotAvailableException;
import software.amazon.awssdk.services.route53.model.DelegationSetNotReusableException;
import software.amazon.awssdk.services.route53.model.DeleteCidrCollectionRequest;
import software.amazon.awssdk.services.route53.model.DeleteCidrCollectionResponse;
import software.amazon.awssdk.services.route53.model.DeleteHealthCheckRequest;
import software.amazon.awssdk.services.route53.model.DeleteHealthCheckResponse;
import software.amazon.awssdk.services.route53.model.DeleteHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.DeleteHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.DeleteKeySigningKeyRequest;
import software.amazon.awssdk.services.route53.model.DeleteKeySigningKeyResponse;
import software.amazon.awssdk.services.route53.model.DeleteQueryLoggingConfigRequest;
import software.amazon.awssdk.services.route53.model.DeleteQueryLoggingConfigResponse;
import software.amazon.awssdk.services.route53.model.DeleteReusableDelegationSetRequest;
import software.amazon.awssdk.services.route53.model.DeleteReusableDelegationSetResponse;
import software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyInstanceRequest;
import software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyInstanceResponse;
import software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyRequest;
import software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyResponse;
import software.amazon.awssdk.services.route53.model.DeleteVpcAssociationAuthorizationRequest;
import software.amazon.awssdk.services.route53.model.DeleteVpcAssociationAuthorizationResponse;
import software.amazon.awssdk.services.route53.model.DisableHostedZoneDnssecRequest;
import software.amazon.awssdk.services.route53.model.DisableHostedZoneDnssecResponse;
import software.amazon.awssdk.services.route53.model.DisassociateVpcFromHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.DisassociateVpcFromHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.DnssecNotFoundException;
import software.amazon.awssdk.services.route53.model.EnableHostedZoneDnssecRequest;
import software.amazon.awssdk.services.route53.model.EnableHostedZoneDnssecResponse;
import software.amazon.awssdk.services.route53.model.GetAccountLimitRequest;
import software.amazon.awssdk.services.route53.model.GetAccountLimitResponse;
import software.amazon.awssdk.services.route53.model.GetChangeRequest;
import software.amazon.awssdk.services.route53.model.GetChangeResponse;
import software.amazon.awssdk.services.route53.model.GetCheckerIpRangesRequest;
import software.amazon.awssdk.services.route53.model.GetCheckerIpRangesResponse;
import software.amazon.awssdk.services.route53.model.GetDnssecRequest;
import software.amazon.awssdk.services.route53.model.GetDnssecResponse;
import software.amazon.awssdk.services.route53.model.GetGeoLocationRequest;
import software.amazon.awssdk.services.route53.model.GetGeoLocationResponse;
import software.amazon.awssdk.services.route53.model.GetHealthCheckCountRequest;
import software.amazon.awssdk.services.route53.model.GetHealthCheckCountResponse;
import software.amazon.awssdk.services.route53.model.GetHealthCheckLastFailureReasonRequest;
import software.amazon.awssdk.services.route53.model.GetHealthCheckLastFailureReasonResponse;
import software.amazon.awssdk.services.route53.model.GetHealthCheckRequest;
import software.amazon.awssdk.services.route53.model.GetHealthCheckResponse;
import software.amazon.awssdk.services.route53.model.GetHealthCheckStatusRequest;
import software.amazon.awssdk.services.route53.model.GetHealthCheckStatusResponse;
import software.amazon.awssdk.services.route53.model.GetHostedZoneCountRequest;
import software.amazon.awssdk.services.route53.model.GetHostedZoneCountResponse;
import software.amazon.awssdk.services.route53.model.GetHostedZoneLimitRequest;
import software.amazon.awssdk.services.route53.model.GetHostedZoneLimitResponse;
import software.amazon.awssdk.services.route53.model.GetHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.GetHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.GetQueryLoggingConfigRequest;
import software.amazon.awssdk.services.route53.model.GetQueryLoggingConfigResponse;
import software.amazon.awssdk.services.route53.model.GetReusableDelegationSetLimitRequest;
import software.amazon.awssdk.services.route53.model.GetReusableDelegationSetLimitResponse;
import software.amazon.awssdk.services.route53.model.GetReusableDelegationSetRequest;
import software.amazon.awssdk.services.route53.model.GetReusableDelegationSetResponse;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceCountRequest;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceCountResponse;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceRequest;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceResponse;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyRequest;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyResponse;
import software.amazon.awssdk.services.route53.model.HealthCheckAlreadyExistsException;
import software.amazon.awssdk.services.route53.model.HealthCheckVersionMismatchException;
import software.amazon.awssdk.services.route53.model.HostedZoneAlreadyExistsException;
import software.amazon.awssdk.services.route53.model.HostedZoneNotEmptyException;
import software.amazon.awssdk.services.route53.model.HostedZoneNotFoundException;
import software.amazon.awssdk.services.route53.model.HostedZoneNotPrivateException;
import software.amazon.awssdk.services.route53.model.HostedZonePartiallyDelegatedException;
import software.amazon.awssdk.services.route53.model.IncompatibleVersionException;
import software.amazon.awssdk.services.route53.model.InsufficientCloudWatchLogsResourcePolicyException;
import software.amazon.awssdk.services.route53.model.InvalidArgumentException;
import software.amazon.awssdk.services.route53.model.InvalidChangeBatchException;
import software.amazon.awssdk.services.route53.model.InvalidDomainNameException;
import software.amazon.awssdk.services.route53.model.InvalidInputException;
import software.amazon.awssdk.services.route53.model.InvalidKeySigningKeyNameException;
import software.amazon.awssdk.services.route53.model.InvalidKeySigningKeyStatusException;
import software.amazon.awssdk.services.route53.model.InvalidKmsArnException;
import software.amazon.awssdk.services.route53.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.route53.model.InvalidSigningStatusException;
import software.amazon.awssdk.services.route53.model.InvalidTrafficPolicyDocumentException;
import software.amazon.awssdk.services.route53.model.InvalidVpcIdException;
import software.amazon.awssdk.services.route53.model.KeySigningKeyAlreadyExistsException;
import software.amazon.awssdk.services.route53.model.KeySigningKeyInParentDsRecordException;
import software.amazon.awssdk.services.route53.model.KeySigningKeyInUseException;
import software.amazon.awssdk.services.route53.model.KeySigningKeyWithActiveStatusNotFoundException;
import software.amazon.awssdk.services.route53.model.LastVpcAssociationException;
import software.amazon.awssdk.services.route53.model.LimitsExceededException;
import software.amazon.awssdk.services.route53.model.ListCidrBlocksRequest;
import software.amazon.awssdk.services.route53.model.ListCidrBlocksResponse;
import software.amazon.awssdk.services.route53.model.ListCidrCollectionsRequest;
import software.amazon.awssdk.services.route53.model.ListCidrCollectionsResponse;
import software.amazon.awssdk.services.route53.model.ListCidrLocationsRequest;
import software.amazon.awssdk.services.route53.model.ListCidrLocationsResponse;
import software.amazon.awssdk.services.route53.model.ListGeoLocationsRequest;
import software.amazon.awssdk.services.route53.model.ListGeoLocationsResponse;
import software.amazon.awssdk.services.route53.model.ListHealthChecksRequest;
import software.amazon.awssdk.services.route53.model.ListHealthChecksResponse;
import software.amazon.awssdk.services.route53.model.ListHostedZonesByNameRequest;
import software.amazon.awssdk.services.route53.model.ListHostedZonesByNameResponse;
import software.amazon.awssdk.services.route53.model.ListHostedZonesByVpcRequest;
import software.amazon.awssdk.services.route53.model.ListHostedZonesByVpcResponse;
import software.amazon.awssdk.services.route53.model.ListHostedZonesRequest;
import software.amazon.awssdk.services.route53.model.ListHostedZonesResponse;
import software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsRequest;
import software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsResponse;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsResponse;
import software.amazon.awssdk.services.route53.model.ListReusableDelegationSetsRequest;
import software.amazon.awssdk.services.route53.model.ListReusableDelegationSetsResponse;
import software.amazon.awssdk.services.route53.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.route53.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.route53.model.ListTagsForResourcesRequest;
import software.amazon.awssdk.services.route53.model.ListTagsForResourcesResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPoliciesRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPoliciesResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByPolicyRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByPolicyResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyVersionsRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyVersionsResponse;
import software.amazon.awssdk.services.route53.model.ListVpcAssociationAuthorizationsRequest;
import software.amazon.awssdk.services.route53.model.ListVpcAssociationAuthorizationsResponse;
import software.amazon.awssdk.services.route53.model.NoSuchChangeException;
import software.amazon.awssdk.services.route53.model.NoSuchCidrCollectionException;
import software.amazon.awssdk.services.route53.model.NoSuchCidrLocationException;
import software.amazon.awssdk.services.route53.model.NoSuchCloudWatchLogsLogGroupException;
import software.amazon.awssdk.services.route53.model.NoSuchDelegationSetException;
import software.amazon.awssdk.services.route53.model.NoSuchGeoLocationException;
import software.amazon.awssdk.services.route53.model.NoSuchHealthCheckException;
import software.amazon.awssdk.services.route53.model.NoSuchHostedZoneException;
import software.amazon.awssdk.services.route53.model.NoSuchKeySigningKeyException;
import software.amazon.awssdk.services.route53.model.NoSuchQueryLoggingConfigException;
import software.amazon.awssdk.services.route53.model.NoSuchTrafficPolicyException;
import software.amazon.awssdk.services.route53.model.NoSuchTrafficPolicyInstanceException;
import software.amazon.awssdk.services.route53.model.NotAuthorizedException;
import software.amazon.awssdk.services.route53.model.PriorRequestNotCompleteException;
import software.amazon.awssdk.services.route53.model.PublicZoneVpcAssociationException;
import software.amazon.awssdk.services.route53.model.QueryLoggingConfigAlreadyExistsException;
import software.amazon.awssdk.services.route53.model.Route53Exception;
import software.amazon.awssdk.services.route53.model.TestDnsAnswerRequest;
import software.amazon.awssdk.services.route53.model.TestDnsAnswerResponse;
import software.amazon.awssdk.services.route53.model.ThrottlingException;
import software.amazon.awssdk.services.route53.model.TooManyHealthChecksException;
import software.amazon.awssdk.services.route53.model.TooManyHostedZonesException;
import software.amazon.awssdk.services.route53.model.TooManyKeySigningKeysException;
import software.amazon.awssdk.services.route53.model.TooManyTrafficPoliciesException;
import software.amazon.awssdk.services.route53.model.TooManyTrafficPolicyInstancesException;
import software.amazon.awssdk.services.route53.model.TooManyTrafficPolicyVersionsForCurrentPolicyException;
import software.amazon.awssdk.services.route53.model.TooManyVpcAssociationAuthorizationsException;
import software.amazon.awssdk.services.route53.model.TrafficPolicyAlreadyExistsException;
import software.amazon.awssdk.services.route53.model.TrafficPolicyInUseException;
import software.amazon.awssdk.services.route53.model.TrafficPolicyInstanceAlreadyExistsException;
import software.amazon.awssdk.services.route53.model.UpdateHealthCheckRequest;
import software.amazon.awssdk.services.route53.model.UpdateHealthCheckResponse;
import software.amazon.awssdk.services.route53.model.UpdateHostedZoneCommentRequest;
import software.amazon.awssdk.services.route53.model.UpdateHostedZoneCommentResponse;
import software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyCommentRequest;
import software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyCommentResponse;
import software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyInstanceRequest;
import software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyInstanceResponse;
import software.amazon.awssdk.services.route53.model.VpcAssociationAuthorizationNotFoundException;
import software.amazon.awssdk.services.route53.model.VpcAssociationNotFoundException;
import software.amazon.awssdk.services.route53.transform.ActivateKeySigningKeyRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.AssociateVpcWithHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ChangeCidrCollectionRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ChangeResourceRecordSetsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ChangeTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateCidrCollectionRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateHealthCheckRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateKeySigningKeyRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateQueryLoggingConfigRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateReusableDelegationSetRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateTrafficPolicyInstanceRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateTrafficPolicyRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateTrafficPolicyVersionRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateVpcAssociationAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeactivateKeySigningKeyRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteCidrCollectionRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteHealthCheckRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteKeySigningKeyRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteQueryLoggingConfigRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteReusableDelegationSetRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteTrafficPolicyInstanceRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteTrafficPolicyRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteVpcAssociationAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DisableHostedZoneDnssecRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DisassociateVpcFromHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.EnableHostedZoneDnssecRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetAccountLimitRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetChangeRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetCheckerIpRangesRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetDnssecRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetGeoLocationRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHealthCheckCountRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHealthCheckLastFailureReasonRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHealthCheckRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHealthCheckStatusRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHostedZoneCountRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHostedZoneLimitRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetQueryLoggingConfigRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetReusableDelegationSetLimitRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetReusableDelegationSetRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetTrafficPolicyInstanceCountRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetTrafficPolicyInstanceRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetTrafficPolicyRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListCidrBlocksRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListCidrCollectionsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListCidrLocationsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListGeoLocationsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListHealthChecksRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListHostedZonesByNameRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListHostedZonesByVpcRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListHostedZonesRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListQueryLoggingConfigsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListResourceRecordSetsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListReusableDelegationSetsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTagsForResourcesRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPoliciesRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPolicyInstancesByHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPolicyInstancesByPolicyRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPolicyInstancesRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPolicyVersionsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListVpcAssociationAuthorizationsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.TestDnsAnswerRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.UpdateHealthCheckRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.UpdateHostedZoneCommentRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.UpdateTrafficPolicyCommentRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.UpdateTrafficPolicyInstanceRequestMarshaller;
import software.amazon.awssdk.services.route53.waiters.Route53Waiter;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link Route53Client}.
 *
 * @see Route53Client#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultRoute53Client implements Route53Client {
    private static final Logger log = Logger.loggerFor(DefaultRoute53Client.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_XML).build();

    private final SyncClientHandler clientHandler;

    private final AwsXmlProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultRoute53Client(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "Route_53" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init();
    }

    /**
     * <p>
     * Activates a key-signing key (KSK) so that it can be used for signing by DNSSEC. This operation changes the KSK
     * status to <code>ACTIVE</code>.
     * </p>
     *
     * @param activateKeySigningKeyRequest
     * @return Result of the ActivateKeySigningKey operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another user submitted a request to create, update, or delete the object at the same time that you did.
     *         Retry the request.
     * @throws NoSuchKeySigningKeyException
     *         The specified key-signing key (KSK) doesn't exist.
     * @throws InvalidKeySigningKeyStatusException
     *         The key-signing key (KSK) status isn't valid or another KSK has the status <code>INTERNAL_FAILURE</code>.
     * @throws InvalidSigningStatusException
     *         Your hosted zone status isn't valid for this operation. In the hosted zone, change the status to enable
     *         <code>DNSSEC</code> or disable <code>DNSSEC</code>.
     * @throws InvalidKmsArnException
     *         The KeyManagementServiceArn that you specified isn't valid to use with DNSSEC signing.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.ActivateKeySigningKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ActivateKeySigningKey" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ActivateKeySigningKeyResponse activateKeySigningKey(ActivateKeySigningKeyRequest activateKeySigningKeyRequest)
            throws ConcurrentModificationException, NoSuchKeySigningKeyException, InvalidKeySigningKeyStatusException,
            InvalidSigningStatusException, InvalidKmsArnException, InvalidInputException, AwsServiceException,
            SdkClientException, Route53Exception {

        HttpResponseHandler<Response<ActivateKeySigningKeyResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ActivateKeySigningKeyResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(activateKeySigningKeyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, activateKeySigningKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ActivateKeySigningKey");

            return clientHandler.execute(new ClientExecutionParams<ActivateKeySigningKeyRequest, ActivateKeySigningKeyResponse>()
                    .withOperationName("ActivateKeySigningKey").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(activateKeySigningKeyRequest)
                    .withMarshaller(new ActivateKeySigningKeyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates an Amazon VPC with a private hosted zone.
     * </p>
     * <important>
     * <p>
     * To perform the association, the VPC and the private hosted zone must already exist. You can't convert a public
     * hosted zone into a private hosted zone.
     * </p>
     * </important> <note>
     * <p>
     * If you want to associate a VPC that was created by using one Amazon Web Services account with a private hosted
     * zone that was created by using a different account, the Amazon Web Services account that created the private
     * hosted zone must first submit a <code>CreateVPCAssociationAuthorization</code> request. Then the account that
     * created the VPC must submit an <code>AssociateVPCWithHostedZone</code> request.
     * </p>
     * </note> <note>
     * <p>
     * When granting access, the hosted zone and the Amazon VPC must belong to the same partition. A partition is a
     * group of Amazon Web Services Regions. Each Amazon Web Services account is scoped to one partition.
     * </p>
     * <p>
     * The following are the supported partitions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>aws</code> - Amazon Web Services Regions
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aws-cn</code> - China Regions
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aws-us-gov</code> - Amazon Web Services GovCloud (US) Region
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Access Management</a> in the
     * <i>Amazon Web Services General Reference</i>.
     * </p>
     * </note>
     *
     * @param associateVpcWithHostedZoneRequest
     *        A complex type that contains information about the request to associate a VPC with a private hosted zone.
     * @return Result of the AssociateVPCWithHostedZone operation returned by the service.
     * @throws NoSuchHostedZoneException
     *         No hosted zone exists with the ID that you specified.
     * @throws NotAuthorizedException
     *         Associating the specified VPC with the specified hosted zone has not been authorized.
     * @throws InvalidVpcIdException
     *         The VPC ID that you specified either isn't a valid ID or the current account is not authorized to access
     *         this VPC.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws PublicZoneVpcAssociationException
     *         You're trying to associate a VPC with a public hosted zone. Amazon Route 53 doesn't support associating a
     *         VPC with a public hosted zone.
     * @throws ConflictingDomainExistsException
     *         The cause of this error depends on the operation that you're performing:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Create a public hosted zone:</b> Two hosted zones that have the same name or that have a parent/child
     *         relationship (example.com and test.example.com) can't have any common name servers. You tried to create a
     *         hosted zone that has the same name as an existing hosted zone or that's the parent or child of an
     *         existing hosted zone, and you specified a delegation set that shares one or more name servers with the
     *         existing hosted zone. For more information, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateReusableDelegationSet.html"
     *         >CreateReusableDelegationSet</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Create a private hosted zone:</b> A hosted zone with the specified name already exists and is already
     *         associated with the Amazon VPC that you specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Associate VPCs with a private hosted zone:</b> The VPC that you specified is already associated with
     *         another hosted zone that has the same name.
     *         </p>
     *         </li>
     * @throws LimitsExceededException
     *         This operation can't be completed because the current account has reached the limit on the resource you
     *         are trying to create. To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a
     *         case</a> with the Amazon Web Services Support Center.
     * @throws PriorRequestNotCompleteException
     *         If Amazon Route 53 can't process a request before the next request arrives, it will reject subsequent
     *         requests for the same hosted zone and return an <code>HTTP 400 error</code> (<code>Bad request</code>).
     *         If Route 53 returns this error repeatedly for the same request, we recommend that you wait, in intervals
     *         of increasing duration, before you try the request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.AssociateVPCWithHostedZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/AssociateVPCWithHostedZone"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateVpcWithHostedZoneResponse associateVPCWithHostedZone(
            AssociateVpcWithHostedZoneRequest associateVpcWithHostedZoneRequest) throws NoSuchHostedZoneException,
            NotAuthorizedException, InvalidVpcIdException, InvalidInputException, PublicZoneVpcAssociationException,
            ConflictingDomainExistsException, LimitsExceededException, PriorRequestNotCompleteException, AwsServiceException,
            SdkClientException, Route53Exception {

        HttpResponseHandler<Response<AssociateVpcWithHostedZoneResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(AssociateVpcWithHostedZoneResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateVpcWithHostedZoneRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateVpcWithHostedZoneRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateVPCWithHostedZone");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateVpcWithHostedZoneRequest, AssociateVpcWithHostedZoneResponse>()
                            .withOperationName("AssociateVPCWithHostedZone").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(associateVpcWithHostedZoneRequest)
                            .withMarshaller(new AssociateVpcWithHostedZoneRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates, changes, or deletes CIDR blocks within a collection. Contains authoritative IP information mapping
     * blocks to one or multiple locations.
     * </p>
     * <p>
     * A change request can update multiple locations in a collection at a time, which is helpful if you want to move
     * one or more CIDR blocks from one location to another in one transaction, without downtime.
     * </p>
     * <p>
     * <b>Limits</b>
     * </p>
     * <p>
     * The max number of CIDR blocks included in the request is 1000. As a result, big updates require multiple API
     * calls.
     * </p>
     * <p>
     * <b> PUT and DELETE_IF_EXISTS</b>
     * </p>
     * <p>
     * Use <code>ChangeCidrCollection</code> to perform the following actions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PUT</code>: Create a CIDR block within the specified collection.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code> DELETE_IF_EXISTS</code>: Delete an existing CIDR block from the collection.
     * </p>
     * </li>
     * </ul>
     *
     * @param changeCidrCollectionRequest
     * @return Result of the ChangeCidrCollection operation returned by the service.
     * @throws NoSuchCidrCollectionException
     *         The CIDR collection you specified, doesn't exist.
     * @throws CidrCollectionVersionMismatchException
     *         The CIDR collection version you provided, doesn't match the one in the <code>ListCidrCollections</code>
     *         operation.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws CidrBlockInUseException
     *         This CIDR block is already in use.
     * @throws LimitsExceededException
     *         This operation can't be completed because the current account has reached the limit on the resource you
     *         are trying to create. To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a
     *         case</a> with the Amazon Web Services Support Center.
     * @throws ConcurrentModificationException
     *         Another user submitted a request to create, update, or delete the object at the same time that you did.
     *         Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.ChangeCidrCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ChangeCidrCollection" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ChangeCidrCollectionResponse changeCidrCollection(ChangeCidrCollectionRequest changeCidrCollectionRequest)
            throws NoSuchCidrCollectionException, CidrCollectionVersionMismatchException, InvalidInputException,
            CidrBlockInUseException, LimitsExceededException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, Route53Exception {

        HttpResponseHandler<Response<ChangeCidrCollectionResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ChangeCidrCollectionResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(changeCidrCollectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, changeCidrCollectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ChangeCidrCollection");

            return clientHandler.execute(new ClientExecutionParams<ChangeCidrCollectionRequest, ChangeCidrCollectionResponse>()
                    .withOperationName("ChangeCidrCollection").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(changeCidrCollectionRequest)
                    .withMarshaller(new ChangeCidrCollectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates, changes, or deletes a resource record set, which contains authoritative DNS information for a specified
     * domain name or subdomain name. For example, you can use <code>ChangeResourceRecordSets</code> to create a
     * resource record set that routes traffic for test.example.com to a web server that has an IP address of
     * 192.0.2.44.
     * </p>
     * <p>
     * <b>Deleting Resource Record Sets</b>
     * </p>
     * <p>
     * To delete a resource record set, you must specify all the same values that you specified when you created it.
     * </p>
     * <p>
     * <b>Change Batches and Transactional Changes</b>
     * </p>
     * <p>
     * The request body must include a document with a <code>ChangeResourceRecordSetsRequest</code> element. The request
     * body contains a list of change items, known as a change batch. Change batches are considered transactional
     * changes. Route 53 validates the changes in the request and then either makes all or none of the changes in the
     * change batch request. This ensures that DNS routing isn't adversely affected by partial changes to the resource
     * record sets in a hosted zone.
     * </p>
     * <p>
     * For example, suppose a change batch request contains two changes: it deletes the <code>CNAME</code> resource
     * record set for www.example.com and creates an alias resource record set for www.example.com. If validation for
     * both records succeeds, Route 53 deletes the first resource record set and creates the second resource record set
     * in a single operation. If validation for either the <code>DELETE</code> or the <code>CREATE</code> action fails,
     * then the request is canceled, and the original <code>CNAME</code> record continues to exist.
     * </p>
     * <note>
     * <p>
     * If you try to delete the same resource record set more than once in a single change batch, Route 53 returns an
     * <code>InvalidChangeBatch</code> error.
     * </p>
     * </note>
     * <p>
     * <b>Traffic Flow</b>
     * </p>
     * <p>
     * To create resource record sets for complex routing configurations, use either the traffic flow visual editor in
     * the Route 53 console or the API actions for traffic policies and traffic policy instances. Save the configuration
     * as a traffic policy, then associate the traffic policy with one or more domain names (such as example.com) or
     * subdomain names (such as www.example.com), in the same hosted zone or in multiple hosted zones. You can roll back
     * the updates if the new configuration isn't performing as expected. For more information, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/traffic-flow.html">Using Traffic Flow to Route
     * DNS Traffic</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * <b>Create, Delete, and Upsert</b>
     * </p>
     * <p>
     * Use <code>ChangeResourceRecordsSetsRequest</code> to perform the following actions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE</code>: Creates a resource record set that has the specified values.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE</code>: Deletes an existing resource record set that has the specified values.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPSERT</code>: If a resource set doesn't exist, Route 53 creates it. If a resource set exists Route 53
     * updates it with the values in the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Syntaxes for Creating, Updating, and Deleting Resource Record Sets</b>
     * </p>
     * <p>
     * The syntax for a request depends on the type of resource record set that you want to create, delete, or update,
     * such as weighted, alias, or failover. The XML elements in your request must appear in the order listed in the
     * syntax.
     * </p>
     * <p>
     * For an example for each type of resource record set, see "Examples."
     * </p>
     * <p>
     * Don't refer to the syntax in the "Parameter Syntax" section, which includes all of the elements for every kind of
     * resource record set that you can create, delete, or update by using <code>ChangeResourceRecordSets</code>.
     * </p>
     * <p>
     * <b>Change Propagation to Route 53 DNS Servers</b>
     * </p>
     * <p>
     * When you submit a <code>ChangeResourceRecordSets</code> request, Route 53 propagates your changes to all of the
     * Route 53 authoritative DNS servers managing the hosted zone. While your changes are propagating,
     * <code>GetChange</code> returns a status of <code>PENDING</code>. When propagation is complete,
     * <code>GetChange</code> returns a status of <code>INSYNC</code>. Changes generally propagate to all Route 53 name
     * servers managing the hosted zone within 60 seconds. For more information, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetChange.html">GetChange</a>.
     * </p>
     * <p>
     * <b>Limits on ChangeResourceRecordSets Requests</b>
     * </p>
     * <p>
     * For information about the limits on a <code>ChangeResourceRecordSets</code> request, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the <i>Amazon
     * Route 53 Developer Guide</i>.
     * </p>
     *
     * @param changeResourceRecordSetsRequest
     *        A complex type that contains change information for the resource record set.
     * @return Result of the ChangeResourceRecordSets operation returned by the service.
     * @throws NoSuchHostedZoneException
     *         No hosted zone exists with the ID that you specified.
     * @throws NoSuchHealthCheckException
     *         No health check exists with the specified ID.
     * @throws InvalidChangeBatchException
     *         This exception contains a list of messages that might contain one or more error messages. Each error
     *         message indicates one error in the change batch.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws PriorRequestNotCompleteException
     *         If Amazon Route 53 can't process a request before the next request arrives, it will reject subsequent
     *         requests for the same hosted zone and return an <code>HTTP 400 error</code> (<code>Bad request</code>).
     *         If Route 53 returns this error repeatedly for the same request, we recommend that you wait, in intervals
     *         of increasing duration, before you try the request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.ChangeResourceRecordSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ChangeResourceRecordSets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ChangeResourceRecordSetsResponse changeResourceRecordSets(
            ChangeResourceRecordSetsRequest changeResourceRecordSetsRequest) throws NoSuchHostedZoneException,
            NoSuchHealthCheckException, InvalidChangeBatchException, InvalidInputException, PriorRequestNotCompleteException,
            AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<ChangeResourceRecordSetsResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ChangeResourceRecordSetsResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(changeResourceRecordSetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, changeResourceRecordSetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ChangeResourceRecordSets");

            return clientHandler
                    .execute(new ClientExecutionParams<ChangeResourceRecordSetsRequest, ChangeResourceRecordSetsResponse>()
                            .withOperationName("ChangeResourceRecordSets").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(changeResourceRecordSetsRequest)
                            .withMarshaller(new ChangeResourceRecordSetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds, edits, or deletes tags for a health check or a hosted zone.
     * </p>
     * <p>
     * For information about using tags for cost allocation, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation
     * Tags</a> in the <i>Billing and Cost Management User Guide</i>.
     * </p>
     *
     * @param changeTagsForResourceRequest
     *        A complex type that contains information about the tags that you want to add, edit, or delete.
     * @return Result of the ChangeTagsForResource operation returned by the service.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws NoSuchHealthCheckException
     *         No health check exists with the specified ID.
     * @throws NoSuchHostedZoneException
     *         No hosted zone exists with the ID that you specified.
     * @throws PriorRequestNotCompleteException
     *         If Amazon Route 53 can't process a request before the next request arrives, it will reject subsequent
     *         requests for the same hosted zone and return an <code>HTTP 400 error</code> (<code>Bad request</code>).
     *         If Route 53 returns this error repeatedly for the same request, we recommend that you wait, in intervals
     *         of increasing duration, before you try the request again.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.ChangeTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ChangeTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ChangeTagsForResourceResponse changeTagsForResource(ChangeTagsForResourceRequest changeTagsForResourceRequest)
            throws InvalidInputException, NoSuchHealthCheckException, NoSuchHostedZoneException,
            PriorRequestNotCompleteException, ThrottlingException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<ChangeTagsForResourceResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ChangeTagsForResourceResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(changeTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, changeTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ChangeTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ChangeTagsForResourceRequest, ChangeTagsForResourceResponse>()
                    .withOperationName("ChangeTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(changeTagsForResourceRequest)
                    .withMarshaller(new ChangeTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a CIDR collection in the current Amazon Web Services account.
     * </p>
     *
     * @param createCidrCollectionRequest
     * @return Result of the CreateCidrCollection operation returned by the service.
     * @throws LimitsExceededException
     *         This operation can't be completed because the current account has reached the limit on the resource you
     *         are trying to create. To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a
     *         case</a> with the Amazon Web Services Support Center.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws CidrCollectionAlreadyExistsException
     *         A CIDR collection with this name and a different caller reference already exists in this account.
     * @throws ConcurrentModificationException
     *         Another user submitted a request to create, update, or delete the object at the same time that you did.
     *         Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.CreateCidrCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateCidrCollection" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateCidrCollectionResponse createCidrCollection(CreateCidrCollectionRequest createCidrCollectionRequest)
            throws LimitsExceededException, InvalidInputException, CidrCollectionAlreadyExistsException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<CreateCidrCollectionResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(CreateCidrCollectionResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCidrCollectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCidrCollectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCidrCollection");

            return clientHandler.execute(new ClientExecutionParams<CreateCidrCollectionRequest, CreateCidrCollectionResponse>()
                    .withOperationName("CreateCidrCollection").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(createCidrCollectionRequest)
                    .withMarshaller(new CreateCidrCollectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new health check.
     * </p>
     * <p>
     * For information about adding health checks to resource record sets, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_ResourceRecordSet.html#Route53-Type-ResourceRecordSet-HealthCheckId"
     * >HealthCheckId</a> in <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ChangeResourceRecordSets.html"
     * >ChangeResourceRecordSets</a>.
     * </p>
     * <p>
     * <b>ELB Load Balancers</b>
     * </p>
     * <p>
     * If you're registering EC2 instances with an Elastic Load Balancing (ELB) load balancer, do not create Amazon
     * Route 53 health checks for the EC2 instances. When you register an EC2 instance with a load balancer, you
     * configure settings for an ELB health check, which performs a similar function to a Route 53 health check.
     * </p>
     * <p>
     * <b>Private Hosted Zones</b>
     * </p>
     * <p>
     * You can associate health checks with failover resource record sets in a private hosted zone. Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Route 53 health checkers are outside the VPC. To check the health of an endpoint within a VPC by IP address, you
     * must assign a public IP address to the instance in the VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can configure a health checker to check the health of an external resource that the instance relies on, such
     * as a database server.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can create a CloudWatch metric, associate an alarm with the metric, and then create a health check that is
     * based on the state of the alarm. For example, you might create a CloudWatch metric that checks the status of the
     * Amazon EC2 <code>StatusCheckFailed</code> metric, add an alarm to the metric, and then create a health check that
     * is based on the state of the alarm. For information about creating CloudWatch metrics and alarms by using the
     * CloudWatch console, see the <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/WhatIsCloudWatch.html">Amazon CloudWatch
     * User Guide</a>.
     * </p>
     * </li>
     * </ul>
     *
     * @param createHealthCheckRequest
     *        A complex type that contains the health check request information.
     * @return Result of the CreateHealthCheck operation returned by the service.
     * @throws TooManyHealthChecksException
     *         This health check can't be created because the current account has reached the limit on the number of
     *         active health checks.</p>
     *         <p>
     *         For information about default limits, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the
     *         <i>Amazon Route 53 Developer Guide</i>.
     *         </p>
     *         <p>
     *         For information about how to get the current limit for an account, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html"
     *         >GetAccountLimit</a>. To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a
     *         case</a> with the Amazon Web Services Support Center.
     *         </p>
     *         <p>
     *         You have reached the maximum number of active health checks for an Amazon Web Services account. To
     *         request a higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the Amazon
     *         Web Services Support Center.
     * @throws HealthCheckAlreadyExistsException
     *         The health check you're attempting to create already exists. Amazon Route 53 returns this error when you
     *         submit a request that has the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The same value for <code>CallerReference</code> as an existing health check, and one or more values that
     *         differ from the existing health check that has the same caller reference.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The same value for <code>CallerReference</code> as a health check that you created and later deleted,
     *         regardless of the other settings in the request.
     *         </p>
     *         </li>
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.CreateHealthCheck
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateHealthCheck" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateHealthCheckResponse createHealthCheck(CreateHealthCheckRequest createHealthCheckRequest)
            throws TooManyHealthChecksException, HealthCheckAlreadyExistsException, InvalidInputException, AwsServiceException,
            SdkClientException, Route53Exception {

        HttpResponseHandler<Response<CreateHealthCheckResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                CreateHealthCheckResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createHealthCheckRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createHealthCheckRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateHealthCheck");

            return clientHandler.execute(new ClientExecutionParams<CreateHealthCheckRequest, CreateHealthCheckResponse>()
                    .withOperationName("CreateHealthCheck").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(createHealthCheckRequest)
                    .withMarshaller(new CreateHealthCheckRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new public or private hosted zone. You create records in a public hosted zone to define how you want to
     * route traffic on the internet for a domain, such as example.com, and its subdomains (apex.example.com,
     * acme.example.com). You create records in a private hosted zone to define how you want to route traffic for a
     * domain and its subdomains within one or more Amazon Virtual Private Clouds (Amazon VPCs).
     * </p>
     * <important>
     * <p>
     * You can't convert a public hosted zone to a private hosted zone or vice versa. Instead, you must create a new
     * hosted zone with the same name and create new resource record sets.
     * </p>
     * </important>
     * <p>
     * For more information about charges for hosted zones, see <a href="http://aws.amazon.com/route53/pricing/">Amazon
     * Route 53 Pricing</a>.
     * </p>
     * <p>
     * Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can't create a hosted zone for a top-level domain (TLD) such as .com.
     * </p>
     * </li>
     * <li>
     * <p>
     * For public hosted zones, Route 53 automatically creates a default SOA record and four NS records for the zone.
     * For more information about SOA and NS records, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/SOA-NSrecords.html">NS and SOA Records that
     * Route 53 Creates for a Hosted Zone</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * If you want to use the same name servers for multiple public hosted zones, you can optionally associate a
     * reusable delegation set with the hosted zone. See the <code>DelegationSetId</code> element.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your domain is registered with a registrar other than Route 53, you must update the name servers with your
     * registrar to make Route 53 the DNS service for the domain. For more information, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/MigratingDNS.html">Migrating DNS Service for an
     * Existing Domain to Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When you submit a <code>CreateHostedZone</code> request, the initial status of the hosted zone is
     * <code>PENDING</code>. For public hosted zones, this means that the NS and SOA records are not yet available on
     * all Route 53 DNS servers. When the NS and SOA records are available, the status of the zone changes to
     * <code>INSYNC</code>.
     * </p>
     * <p>
     * The <code>CreateHostedZone</code> request requires the caller to have an <code>ec2:DescribeVpcs</code>
     * permission.
     * </p>
     * <note>
     * <p>
     * When creating private hosted zones, the Amazon VPC must belong to the same partition where the hosted zone is
     * created. A partition is a group of Amazon Web Services Regions. Each Amazon Web Services account is scoped to one
     * partition.
     * </p>
     * <p>
     * The following are the supported partitions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>aws</code> - Amazon Web Services Regions
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aws-cn</code> - China Regions
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aws-us-gov</code> - Amazon Web Services GovCloud (US) Region
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Access Management</a> in the
     * <i>Amazon Web Services General Reference</i>.
     * </p>
     * </note>
     *
     * @param createHostedZoneRequest
     *        A complex type that contains information about the request to create a public or private hosted zone.
     * @return Result of the CreateHostedZone operation returned by the service.
     * @throws InvalidDomainNameException
     *         The specified domain name is not valid.
     * @throws HostedZoneAlreadyExistsException
     *         The hosted zone you're trying to create already exists. Amazon Route 53 returns this error when a hosted
     *         zone has already been created with the specified <code>CallerReference</code>.
     * @throws TooManyHostedZonesException
     *         This operation can't be completed either because the current account has reached the limit on the number
     *         of hosted zones or because you've reached the limit on the number of hosted zones that can be associated
     *         with a reusable delegation set.</p>
     *         <p>
     *         For information about default limits, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the
     *         <i>Amazon Route 53 Developer Guide</i>.
     *         </p>
     *         <p>
     *         To get the current limit on hosted zones that can be created by an account, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html"
     *         >GetAccountLimit</a>.
     *         </p>
     *         <p>
     *         To get the current limit on hosted zones that can be associated with a reusable delegation set, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetReusableDelegationSetLimit.html">
     *         GetReusableDelegationSetLimit</a>.
     *         </p>
     *         <p>
     *         To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the
     *         Amazon Web Services Support Center.
     * @throws InvalidVpcIdException
     *         The VPC ID that you specified either isn't a valid ID or the current account is not authorized to access
     *         this VPC.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws DelegationSetNotAvailableException
     *         You can create a hosted zone that has the same name as an existing hosted zone (example.com is common),
     *         but there is a limit to the number of hosted zones that have the same name. If you get this error, Amazon
     *         Route 53 has reached that limit. If you own the domain name and Route 53 generates this error, contact
     *         Customer Support.
     * @throws ConflictingDomainExistsException
     *         The cause of this error depends on the operation that you're performing:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Create a public hosted zone:</b> Two hosted zones that have the same name or that have a parent/child
     *         relationship (example.com and test.example.com) can't have any common name servers. You tried to create a
     *         hosted zone that has the same name as an existing hosted zone or that's the parent or child of an
     *         existing hosted zone, and you specified a delegation set that shares one or more name servers with the
     *         existing hosted zone. For more information, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateReusableDelegationSet.html"
     *         >CreateReusableDelegationSet</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Create a private hosted zone:</b> A hosted zone with the specified name already exists and is already
     *         associated with the Amazon VPC that you specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Associate VPCs with a private hosted zone:</b> The VPC that you specified is already associated with
     *         another hosted zone that has the same name.
     *         </p>
     *         </li>
     * @throws NoSuchDelegationSetException
     *         A reusable delegation set with the specified ID does not exist.
     * @throws DelegationSetNotReusableException
     *         A reusable delegation set with the specified ID does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.CreateHostedZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateHostedZone" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateHostedZoneResponse createHostedZone(CreateHostedZoneRequest createHostedZoneRequest)
            throws InvalidDomainNameException, HostedZoneAlreadyExistsException, TooManyHostedZonesException,
            InvalidVpcIdException, InvalidInputException, DelegationSetNotAvailableException, ConflictingDomainExistsException,
            NoSuchDelegationSetException, DelegationSetNotReusableException, AwsServiceException, SdkClientException,
            Route53Exception {

        HttpResponseHandler<Response<CreateHostedZoneResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                CreateHostedZoneResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createHostedZoneRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createHostedZoneRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateHostedZone");

            return clientHandler.execute(new ClientExecutionParams<CreateHostedZoneRequest, CreateHostedZoneResponse>()
                    .withOperationName("CreateHostedZone").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(createHostedZoneRequest)
                    .withMarshaller(new CreateHostedZoneRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new key-signing key (KSK) associated with a hosted zone. You can only have two KSKs per hosted zone.
     * </p>
     *
     * @param createKeySigningKeyRequest
     * @return Result of the CreateKeySigningKey operation returned by the service.
     * @throws NoSuchHostedZoneException
     *         No hosted zone exists with the ID that you specified.
     * @throws InvalidArgumentException
     *         Parameter name is not valid.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws InvalidKmsArnException
     *         The KeyManagementServiceArn that you specified isn't valid to use with DNSSEC signing.
     * @throws InvalidKeySigningKeyStatusException
     *         The key-signing key (KSK) status isn't valid or another KSK has the status <code>INTERNAL_FAILURE</code>.
     * @throws InvalidSigningStatusException
     *         Your hosted zone status isn't valid for this operation. In the hosted zone, change the status to enable
     *         <code>DNSSEC</code> or disable <code>DNSSEC</code>.
     * @throws InvalidKeySigningKeyNameException
     *         The key-signing key (KSK) name that you specified isn't a valid name.
     * @throws KeySigningKeyAlreadyExistsException
     *         You've already created a key-signing key (KSK) with this name or with the same customer managed key ARN.
     * @throws TooManyKeySigningKeysException
     *         You've reached the limit for the number of key-signing keys (KSKs). Remove at least one KSK, and then try
     *         again.
     * @throws ConcurrentModificationException
     *         Another user submitted a request to create, update, or delete the object at the same time that you did.
     *         Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.CreateKeySigningKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateKeySigningKey" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateKeySigningKeyResponse createKeySigningKey(CreateKeySigningKeyRequest createKeySigningKeyRequest)
            throws NoSuchHostedZoneException, InvalidArgumentException, InvalidInputException, InvalidKmsArnException,
            InvalidKeySigningKeyStatusException, InvalidSigningStatusException, InvalidKeySigningKeyNameException,
            KeySigningKeyAlreadyExistsException, TooManyKeySigningKeysException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<CreateKeySigningKeyResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(CreateKeySigningKeyResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createKeySigningKeyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createKeySigningKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateKeySigningKey");

            return clientHandler.execute(new ClientExecutionParams<CreateKeySigningKeyRequest, CreateKeySigningKeyResponse>()
                    .withOperationName("CreateKeySigningKey").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(createKeySigningKeyRequest)
                    .withMarshaller(new CreateKeySigningKeyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a configuration for DNS query logging. After you create a query logging configuration, Amazon Route 53
     * begins to publish log data to an Amazon CloudWatch Logs log group.
     * </p>
     * <p>
     * DNS query logs contain information about the queries that Route 53 receives for a specified public hosted zone,
     * such as the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Route 53 edge location that responded to the DNS query
     * </p>
     * </li>
     * <li>
     * <p>
     * Domain or subdomain that was requested
     * </p>
     * </li>
     * <li>
     * <p>
     * DNS record type, such as A or AAAA
     * </p>
     * </li>
     * <li>
     * <p>
     * DNS response code, such as <code>NoError</code> or <code>ServFail</code>
     * </p>
     * </li>
     * </ul>
     * <dl>
     * <dt>Log Group and Resource Policy</dt>
     * <dd>
     * <p>
     * Before you create a query logging configuration, perform the following operations.
     * </p>
     * <note>
     * <p>
     * If you create a query logging configuration using the Route 53 console, Route 53 performs these operations
     * automatically.
     * </p>
     * </note>
     * <ol>
     * <li>
     * <p>
     * Create a CloudWatch Logs log group, and make note of the ARN, which you specify when you create a query logging
     * configuration. Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must create the log group in the us-east-1 region.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must use the same Amazon Web Services account to create the log group and the hosted zone that you want to
     * configure query logging for.
     * </p>
     * </li>
     * <li>
     * <p>
     * When you create log groups for query logging, we recommend that you use a consistent prefix, for example:
     * </p>
     * <p>
     * <code>/aws/route53/<i>hosted zone name</i> </code>
     * </p>
     * <p>
     * In the next step, you'll create a resource policy, which controls access to one or more log groups and the
     * associated Amazon Web Services resources, such as Route 53 hosted zones. There's a limit on the number of
     * resource policies that you can create, so we recommend that you use a consistent prefix so you can use the same
     * resource policy for all the log groups that you create for query logging.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Create a CloudWatch Logs resource policy, and give it the permissions that Route 53 needs to create log streams
     * and to send query logs to log streams. You must create the CloudWatch Logs resource policy in the us-east-1
     * region. For the value of <code>Resource</code>, specify the ARN for the log group that you created in the
     * previous step. To use the same resource policy for all the CloudWatch Logs log groups that you created for query
     * logging configurations, replace the hosted zone name with <code>*</code>, for example:
     * </p>
     * <p>
     * <code>arn:aws:logs:us-east-1:123412341234:log-group:/aws/route53/*</code>
     * </p>
     * <p>
     * To avoid the confused deputy problem, a security issue where an entity without a permission for an action can
     * coerce a more-privileged entity to perform it, you can optionally limit the permissions that a service has to a
     * resource in a resource-based policy by supplying the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <code>aws:SourceArn</code>, supply the hosted zone ARN used in creating the query logging configuration. For
     * example, <code>aws:SourceArn: arn:aws:route53:::hostedzone/hosted zone ID</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>aws:SourceAccount</code>, supply the account ID for the account that creates the query logging
     * configuration. For example, <code>aws:SourceAccount:111111111111</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/confused-deputy.html">The
     * confused deputy problem</a> in the <i>Amazon Web Services IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * You can't use the CloudWatch console to create or edit a resource policy. You must use the CloudWatch API, one of
     * the Amazon Web Services SDKs, or the CLI.
     * </p>
     * </note></li>
     * </ol>
     * </dd>
     * <dt>Log Streams and Edge Locations</dt>
     * <dd>
     * <p>
     * When Route 53 finishes creating the configuration for DNS query logging, it does the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Creates a log stream for an edge location the first time that the edge location responds to DNS queries for the
     * specified hosted zone. That log stream is used to log all queries that Route 53 responds to for that edge
     * location.
     * </p>
     * </li>
     * <li>
     * <p>
     * Begins to send query logs to the applicable log stream.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The name of each log stream is in the following format:
     * </p>
     * <p>
     * <code> <i>hosted zone ID</i>/<i>edge location code</i> </code>
     * </p>
     * <p>
     * The edge location code is a three-letter code and an arbitrarily assigned number, for example, DFW3. The
     * three-letter code typically corresponds with the International Air Transport Association airport code for an
     * airport near the edge location. (These abbreviations might change in the future.) For a list of edge locations,
     * see "The Route 53 Global Network" on the <a href="http://aws.amazon.com/route53/details/">Route 53 Product
     * Details</a> page.
     * </p>
     * </dd>
     * <dt>Queries That Are Logged</dt>
     * <dd>
     * <p>
     * Query logs contain only the queries that DNS resolvers forward to Route 53. If a DNS resolver has already cached
     * the response to a query (such as the IP address for a load balancer for example.com), the resolver will continue
     * to return the cached response. It doesn't forward another query to Route 53 until the TTL for the corresponding
     * resource record set expires. Depending on how many DNS queries are submitted for a resource record set, and
     * depending on the TTL for that resource record set, query logs might contain information about only one query out
     * of every several thousand queries that are submitted to DNS. For more information about how DNS works, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/welcome-dns-service.html">Routing Internet
     * Traffic to Your Website or Web Application</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * </dd>
     * <dt>Log File Format</dt>
     * <dd>
     * <p>
     * For a list of the values in each query log and the format of each value, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html">Logging DNS Queries</a> in the
     * <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * </dd>
     * <dt>Pricing</dt>
     * <dd>
     * <p>
     * For information about charges for query logs, see <a href="http://aws.amazon.com/cloudwatch/pricing/">Amazon
     * CloudWatch Pricing</a>.
     * </p>
     * </dd>
     * <dt>How to Stop Logging</dt>
     * <dd>
     * <p>
     * If you want Route 53 to stop sending query logs to CloudWatch Logs, delete the query logging configuration. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteQueryLoggingConfig.html"
     * >DeleteQueryLoggingConfig</a>.
     * </p>
     * </dd>
     * </dl>
     *
     * @param createQueryLoggingConfigRequest
     * @return Result of the CreateQueryLoggingConfig operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another user submitted a request to create, update, or delete the object at the same time that you did.
     *         Retry the request.
     * @throws NoSuchHostedZoneException
     *         No hosted zone exists with the ID that you specified.
     * @throws NoSuchCloudWatchLogsLogGroupException
     *         There is no CloudWatch Logs log group with the specified ARN.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws QueryLoggingConfigAlreadyExistsException
     *         You can create only one query logging configuration for a hosted zone, and a query logging configuration
     *         already exists for this hosted zone.
     * @throws InsufficientCloudWatchLogsResourcePolicyException
     *         Amazon Route 53 doesn't have the permissions required to create log streams and send query logs to log
     *         streams. Possible causes include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         There is no resource policy that specifies the log group ARN in the value for <code>Resource</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The resource policy that includes the log group ARN in the value for <code>Resource</code> doesn't have
     *         the necessary permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The resource policy hasn't finished propagating yet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The Key management service (KMS) key you specified doesn’t exist or it can’t be used with the log group
     *         associated with query log. Update or provide a resource policy to grant permissions for the KMS key.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The Key management service (KMS) key you specified is marked as disabled for the log group associated
     *         with query log. Update or provide a resource policy to grant permissions for the KMS key.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.CreateQueryLoggingConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateQueryLoggingConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateQueryLoggingConfigResponse createQueryLoggingConfig(
            CreateQueryLoggingConfigRequest createQueryLoggingConfigRequest) throws ConcurrentModificationException,
            NoSuchHostedZoneException, NoSuchCloudWatchLogsLogGroupException, InvalidInputException,
            QueryLoggingConfigAlreadyExistsException, InsufficientCloudWatchLogsResourcePolicyException, AwsServiceException,
            SdkClientException, Route53Exception {

        HttpResponseHandler<Response<CreateQueryLoggingConfigResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(CreateQueryLoggingConfigResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createQueryLoggingConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createQueryLoggingConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateQueryLoggingConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateQueryLoggingConfigRequest, CreateQueryLoggingConfigResponse>()
                            .withOperationName("CreateQueryLoggingConfig").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(createQueryLoggingConfigRequest)
                            .withMarshaller(new CreateQueryLoggingConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a delegation set (a group of four name servers) that can be reused by multiple hosted zones that were
     * created by the same Amazon Web Services account.
     * </p>
     * <p>
     * You can also create a reusable delegation set that uses the four name servers that are associated with an
     * existing hosted zone. Specify the hosted zone ID in the <code>CreateReusableDelegationSet</code> request.
     * </p>
     * <note>
     * <p>
     * You can't associate a reusable delegation set with a private hosted zone.
     * </p>
     * </note>
     * <p>
     * For information about using a reusable delegation set to configure white label name servers, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/white-label-name-servers.html">Configuring White
     * Label Name Servers</a>.
     * </p>
     * <p>
     * The process for migrating existing hosted zones to use a reusable delegation set is comparable to the process for
     * configuring white label name servers. You need to perform the following steps:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Create a reusable delegation set.
     * </p>
     * </li>
     * <li>
     * <p>
     * Recreate hosted zones, and reduce the TTL to 60 seconds or less.
     * </p>
     * </li>
     * <li>
     * <p>
     * Recreate resource record sets in the new hosted zones.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change the registrar's name servers to use the name servers for the new hosted zones.
     * </p>
     * </li>
     * <li>
     * <p>
     * Monitor traffic for the website or application.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change TTLs back to their original values.
     * </p>
     * </li>
     * </ol>
     * <p>
     * If you want to migrate existing hosted zones to use a reusable delegation set, the existing hosted zones can't
     * use any of the name servers that are assigned to the reusable delegation set. If one or more hosted zones do use
     * one or more name servers that are assigned to the reusable delegation set, you can do one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For small numbers of hosted zones—up to a few hundred—it's relatively easy to create reusable delegation sets
     * until you get one that has four name servers that don't overlap with any of the name servers in your hosted
     * zones.
     * </p>
     * </li>
     * <li>
     * <p>
     * For larger numbers of hosted zones, the easiest solution is to use more than one reusable delegation set.
     * </p>
     * </li>
     * <li>
     * <p>
     * For larger numbers of hosted zones, you can also migrate hosted zones that have overlapping name servers to
     * hosted zones that don't have overlapping name servers, then migrate the hosted zones again to use the reusable
     * delegation set.
     * </p>
     * </li>
     * </ul>
     *
     * @param createReusableDelegationSetRequest
     * @return Result of the CreateReusableDelegationSet operation returned by the service.
     * @throws DelegationSetAlreadyCreatedException
     *         A delegation set with the same owner and caller reference combination has already been created.
     * @throws LimitsExceededException
     *         This operation can't be completed because the current account has reached the limit on the resource you
     *         are trying to create. To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a
     *         case</a> with the Amazon Web Services Support Center.
     * @throws HostedZoneNotFoundException
     *         The specified HostedZone can't be found.
     * @throws InvalidArgumentException
     *         Parameter name is not valid.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws DelegationSetNotAvailableException
     *         You can create a hosted zone that has the same name as an existing hosted zone (example.com is common),
     *         but there is a limit to the number of hosted zones that have the same name. If you get this error, Amazon
     *         Route 53 has reached that limit. If you own the domain name and Route 53 generates this error, contact
     *         Customer Support.
     * @throws DelegationSetAlreadyReusableException
     *         The specified delegation set has already been marked as reusable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.CreateReusableDelegationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateReusableDelegationSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateReusableDelegationSetResponse createReusableDelegationSet(
            CreateReusableDelegationSetRequest createReusableDelegationSetRequest) throws DelegationSetAlreadyCreatedException,
            LimitsExceededException, HostedZoneNotFoundException, InvalidArgumentException, InvalidInputException,
            DelegationSetNotAvailableException, DelegationSetAlreadyReusableException, AwsServiceException, SdkClientException,
            Route53Exception {

        HttpResponseHandler<Response<CreateReusableDelegationSetResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(CreateReusableDelegationSetResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createReusableDelegationSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createReusableDelegationSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateReusableDelegationSet");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateReusableDelegationSetRequest, CreateReusableDelegationSetResponse>()
                            .withOperationName("CreateReusableDelegationSet").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(createReusableDelegationSetRequest)
                            .withMarshaller(new CreateReusableDelegationSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a traffic policy, which you use to create multiple DNS resource record sets for one domain name (such as
     * example.com) or one subdomain name (such as www.example.com).
     * </p>
     *
     * @param createTrafficPolicyRequest
     *        A complex type that contains information about the traffic policy that you want to create.
     * @return Result of the CreateTrafficPolicy operation returned by the service.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws TooManyTrafficPoliciesException
     *         This traffic policy can't be created because the current account has reached the limit on the number of
     *         traffic policies.</p>
     *         <p>
     *         For information about default limits, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the
     *         <i>Amazon Route 53 Developer Guide</i>.
     *         </p>
     *         <p>
     *         To get the current limit for an account, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html"
     *         >GetAccountLimit</a>.
     *         </p>
     *         <p>
     *         To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the
     *         Amazon Web Services Support Center.
     * @throws TrafficPolicyAlreadyExistsException
     *         A traffic policy that has the same value for <code>Name</code> already exists.
     * @throws InvalidTrafficPolicyDocumentException
     *         The format of the traffic policy document that you specified in the <code>Document</code> element is not
     *         valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.CreateTrafficPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateTrafficPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateTrafficPolicyResponse createTrafficPolicy(CreateTrafficPolicyRequest createTrafficPolicyRequest)
            throws InvalidInputException, TooManyTrafficPoliciesException, TrafficPolicyAlreadyExistsException,
            InvalidTrafficPolicyDocumentException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<CreateTrafficPolicyResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(CreateTrafficPolicyResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTrafficPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTrafficPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrafficPolicy");

            return clientHandler.execute(new ClientExecutionParams<CreateTrafficPolicyRequest, CreateTrafficPolicyResponse>()
                    .withOperationName("CreateTrafficPolicy").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(createTrafficPolicyRequest)
                    .withMarshaller(new CreateTrafficPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates resource record sets in a specified hosted zone based on the settings in a specified traffic policy
     * version. In addition, <code>CreateTrafficPolicyInstance</code> associates the resource record sets with a
     * specified domain name (such as example.com) or subdomain name (such as www.example.com). Amazon Route 53 responds
     * to DNS queries for the domain or subdomain name by using the resource record sets that
     * <code>CreateTrafficPolicyInstance</code> created.
     * </p>
     * <note>
     * <p>
     * After you submit an <code>CreateTrafficPolicyInstance</code> request, there's a brief delay while Amazon Route 53
     * creates the resource record sets that are specified in the traffic policy definition. Use
     * <code>GetTrafficPolicyInstance</code> with the <code>id</code> of new traffic policy instance to confirm that the
     * <code>CreateTrafficPolicyInstance</code> request completed successfully. For more information, see the
     * <code>State</code> response element.
     * </p>
     * </note>
     *
     * @param createTrafficPolicyInstanceRequest
     *        A complex type that contains information about the resource record sets that you want to create based on a
     *        specified traffic policy.
     * @return Result of the CreateTrafficPolicyInstance operation returned by the service.
     * @throws NoSuchHostedZoneException
     *         No hosted zone exists with the ID that you specified.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws TooManyTrafficPolicyInstancesException
     *         This traffic policy instance can't be created because the current account has reached the limit on the
     *         number of traffic policy instances.</p>
     *         <p>
     *         For information about default limits, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the
     *         <i>Amazon Route 53 Developer Guide</i>.
     *         </p>
     *         <p>
     *         For information about how to get the current limit for an account, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html"
     *         >GetAccountLimit</a>.
     *         </p>
     *         <p>
     *         To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the
     *         Amazon Web Services Support Center.
     * @throws NoSuchTrafficPolicyException
     *         No traffic policy exists with the specified ID.
     * @throws TrafficPolicyInstanceAlreadyExistsException
     *         There is already a traffic policy instance with the specified ID.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.CreateTrafficPolicyInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateTrafficPolicyInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateTrafficPolicyInstanceResponse createTrafficPolicyInstance(
            CreateTrafficPolicyInstanceRequest createTrafficPolicyInstanceRequest) throws NoSuchHostedZoneException,
            InvalidInputException, TooManyTrafficPolicyInstancesException, NoSuchTrafficPolicyException,
            TrafficPolicyInstanceAlreadyExistsException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<CreateTrafficPolicyInstanceResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(CreateTrafficPolicyInstanceResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTrafficPolicyInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTrafficPolicyInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrafficPolicyInstance");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateTrafficPolicyInstanceRequest, CreateTrafficPolicyInstanceResponse>()
                            .withOperationName("CreateTrafficPolicyInstance").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(createTrafficPolicyInstanceRequest)
                            .withMarshaller(new CreateTrafficPolicyInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new version of an existing traffic policy. When you create a new version of a traffic policy, you
     * specify the ID of the traffic policy that you want to update and a JSON-formatted document that describes the new
     * version. You use traffic policies to create multiple DNS resource record sets for one domain name (such as
     * example.com) or one subdomain name (such as www.example.com). You can create a maximum of 1000 versions of a
     * traffic policy. If you reach the limit and need to create another version, you'll need to start a new traffic
     * policy.
     * </p>
     *
     * @param createTrafficPolicyVersionRequest
     *        A complex type that contains information about the traffic policy that you want to create a new version
     *        for.
     * @return Result of the CreateTrafficPolicyVersion operation returned by the service.
     * @throws NoSuchTrafficPolicyException
     *         No traffic policy exists with the specified ID.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws TooManyTrafficPolicyVersionsForCurrentPolicyException
     *         This traffic policy version can't be created because you've reached the limit of 1000 on the number of
     *         versions that you can create for the current traffic policy.</p>
     *         <p>
     *         To create more traffic policy versions, you can use <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetTrafficPolicy.html"
     *         >GetTrafficPolicy</a> to get the traffic policy document for a specified traffic policy version, and then
     *         use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateTrafficPolicy.html">
     *         CreateTrafficPolicy</a> to create a new traffic policy using the traffic policy document.
     * @throws ConcurrentModificationException
     *         Another user submitted a request to create, update, or delete the object at the same time that you did.
     *         Retry the request.
     * @throws InvalidTrafficPolicyDocumentException
     *         The format of the traffic policy document that you specified in the <code>Document</code> element is not
     *         valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.CreateTrafficPolicyVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateTrafficPolicyVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateTrafficPolicyVersionResponse createTrafficPolicyVersion(
            CreateTrafficPolicyVersionRequest createTrafficPolicyVersionRequest) throws NoSuchTrafficPolicyException,
            InvalidInputException, TooManyTrafficPolicyVersionsForCurrentPolicyException, ConcurrentModificationException,
            InvalidTrafficPolicyDocumentException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<CreateTrafficPolicyVersionResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(CreateTrafficPolicyVersionResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTrafficPolicyVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTrafficPolicyVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrafficPolicyVersion");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateTrafficPolicyVersionRequest, CreateTrafficPolicyVersionResponse>()
                            .withOperationName("CreateTrafficPolicyVersion").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(createTrafficPolicyVersionRequest)
                            .withMarshaller(new CreateTrafficPolicyVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Authorizes the Amazon Web Services account that created a specified VPC to submit an
     * <code>AssociateVPCWithHostedZone</code> request to associate the VPC with a specified hosted zone that was
     * created by a different account. To submit a <code>CreateVPCAssociationAuthorization</code> request, you must use
     * the account that created the hosted zone. After you authorize the association, use the account that created the
     * VPC to submit an <code>AssociateVPCWithHostedZone</code> request.
     * </p>
     * <note>
     * <p>
     * If you want to associate multiple VPCs that you created by using one account with a hosted zone that you created
     * by using a different account, you must submit one authorization request for each VPC.
     * </p>
     * </note>
     *
     * @param createVpcAssociationAuthorizationRequest
     *        A complex type that contains information about the request to authorize associating a VPC with your
     *        private hosted zone. Authorization is only required when a private hosted zone and a VPC were created by
     *        using different accounts.
     * @return Result of the CreateVPCAssociationAuthorization operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another user submitted a request to create, update, or delete the object at the same time that you did.
     *         Retry the request.
     * @throws TooManyVpcAssociationAuthorizationsException
     *         You've created the maximum number of authorizations that can be created for the specified hosted zone. To
     *         authorize another VPC to be associated with the hosted zone, submit a
     *         <code>DeleteVPCAssociationAuthorization</code> request to remove an existing authorization. To get a list
     *         of existing authorizations, submit a <code>ListVPCAssociationAuthorizations</code> request.
     * @throws NoSuchHostedZoneException
     *         No hosted zone exists with the ID that you specified.
     * @throws InvalidVpcIdException
     *         The VPC ID that you specified either isn't a valid ID or the current account is not authorized to access
     *         this VPC.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.CreateVPCAssociationAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateVPCAssociationAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateVpcAssociationAuthorizationResponse createVPCAssociationAuthorization(
            CreateVpcAssociationAuthorizationRequest createVpcAssociationAuthorizationRequest)
            throws ConcurrentModificationException, TooManyVpcAssociationAuthorizationsException, NoSuchHostedZoneException,
            InvalidVpcIdException, InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<CreateVpcAssociationAuthorizationResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(CreateVpcAssociationAuthorizationResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVpcAssociationAuthorizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createVpcAssociationAuthorizationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVPCAssociationAuthorization");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateVpcAssociationAuthorizationRequest, CreateVpcAssociationAuthorizationResponse>()
                            .withOperationName("CreateVPCAssociationAuthorization").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(createVpcAssociationAuthorizationRequest)
                            .withMarshaller(new CreateVpcAssociationAuthorizationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deactivates a key-signing key (KSK) so that it will not be used for signing by DNSSEC. This operation changes the
     * KSK status to <code>INACTIVE</code>.
     * </p>
     *
     * @param deactivateKeySigningKeyRequest
     * @return Result of the DeactivateKeySigningKey operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another user submitted a request to create, update, or delete the object at the same time that you did.
     *         Retry the request.
     * @throws NoSuchKeySigningKeyException
     *         The specified key-signing key (KSK) doesn't exist.
     * @throws InvalidKeySigningKeyStatusException
     *         The key-signing key (KSK) status isn't valid or another KSK has the status <code>INTERNAL_FAILURE</code>.
     * @throws InvalidSigningStatusException
     *         Your hosted zone status isn't valid for this operation. In the hosted zone, change the status to enable
     *         <code>DNSSEC</code> or disable <code>DNSSEC</code>.
     * @throws KeySigningKeyInUseException
     *         The key-signing key (KSK) that you specified can't be deactivated because it's the only KSK for a
     *         currently-enabled DNSSEC. Disable DNSSEC signing, or add or enable another KSK.
     * @throws KeySigningKeyInParentDsRecordException
     *         The key-signing key (KSK) is specified in a parent DS record.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.DeactivateKeySigningKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeactivateKeySigningKey"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeactivateKeySigningKeyResponse deactivateKeySigningKey(DeactivateKeySigningKeyRequest deactivateKeySigningKeyRequest)
            throws ConcurrentModificationException, NoSuchKeySigningKeyException, InvalidKeySigningKeyStatusException,
            InvalidSigningStatusException, KeySigningKeyInUseException, KeySigningKeyInParentDsRecordException,
            InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<DeactivateKeySigningKeyResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(DeactivateKeySigningKeyResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deactivateKeySigningKeyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deactivateKeySigningKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeactivateKeySigningKey");

            return clientHandler
                    .execute(new ClientExecutionParams<DeactivateKeySigningKeyRequest, DeactivateKeySigningKeyResponse>()
                            .withOperationName("DeactivateKeySigningKey").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(deactivateKeySigningKeyRequest)
                            .withMarshaller(new DeactivateKeySigningKeyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a CIDR collection in the current Amazon Web Services account. The collection must be empty before it can
     * be deleted.
     * </p>
     *
     * @param deleteCidrCollectionRequest
     * @return Result of the DeleteCidrCollection operation returned by the service.
     * @throws NoSuchCidrCollectionException
     *         The CIDR collection you specified, doesn't exist.
     * @throws CidrCollectionInUseException
     *         This CIDR collection is in use, and isn't empty.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws ConcurrentModificationException
     *         Another user submitted a request to create, update, or delete the object at the same time that you did.
     *         Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.DeleteCidrCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteCidrCollection" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteCidrCollectionResponse deleteCidrCollection(DeleteCidrCollectionRequest deleteCidrCollectionRequest)
            throws NoSuchCidrCollectionException, CidrCollectionInUseException, InvalidInputException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<DeleteCidrCollectionResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(DeleteCidrCollectionResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCidrCollectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCidrCollectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCidrCollection");

            return clientHandler.execute(new ClientExecutionParams<DeleteCidrCollectionRequest, DeleteCidrCollectionResponse>()
                    .withOperationName("DeleteCidrCollection").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteCidrCollectionRequest)
                    .withMarshaller(new DeleteCidrCollectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a health check.
     * </p>
     * <important>
     * <p>
     * Amazon Route 53 does not prevent you from deleting a health check even if the health check is associated with one
     * or more resource record sets. If you delete a health check and you don't update the associated resource record
     * sets, the future status of the health check can't be predicted and may change. This will affect the routing of
     * DNS queries for your DNS failover configuration. For more information, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/health-checks-creating-deleting.html#health-checks-deleting.html"
     * >Replacing and Deleting Health Checks</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * </important>
     * <p>
     * If you're using Cloud Map and you configured Cloud Map to create a Route 53 health check when you register an
     * instance, you can't use the Route 53 <code>DeleteHealthCheck</code> command to delete the health check. The
     * health check is deleted automatically when you deregister the instance; there can be a delay of several hours
     * before the health check is deleted from Route 53.
     * </p>
     *
     * @param deleteHealthCheckRequest
     *        This action deletes a health check.
     * @return Result of the DeleteHealthCheck operation returned by the service.
     * @throws NoSuchHealthCheckException
     *         No health check exists with the specified ID.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.DeleteHealthCheck
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteHealthCheck" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteHealthCheckResponse deleteHealthCheck(DeleteHealthCheckRequest deleteHealthCheckRequest)
            throws NoSuchHealthCheckException, InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<DeleteHealthCheckResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                DeleteHealthCheckResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteHealthCheckRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteHealthCheckRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteHealthCheck");

            return clientHandler.execute(new ClientExecutionParams<DeleteHealthCheckRequest, DeleteHealthCheckResponse>()
                    .withOperationName("DeleteHealthCheck").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteHealthCheckRequest)
                    .withMarshaller(new DeleteHealthCheckRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a hosted zone.
     * </p>
     * <p>
     * If the hosted zone was created by another service, such as Cloud Map, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DeleteHostedZone.html#delete-public-hosted-zone-created-by-another-service"
     * >Deleting Public Hosted Zones That Were Created by Another Service</a> in the <i>Amazon Route 53 Developer
     * Guide</i> for information about how to delete it. (The process is the same for public and private hosted zones
     * that were created by another service.)
     * </p>
     * <p>
     * If you want to keep your domain registration but you want to stop routing internet traffic to your website or web
     * application, we recommend that you delete resource record sets in the hosted zone instead of deleting the hosted
     * zone.
     * </p>
     * <important>
     * <p>
     * If you delete a hosted zone, you can't undelete it. You must create a new hosted zone and update the name servers
     * for your domain registration, which can require up to 48 hours to take effect. (If you delegated responsibility
     * for a subdomain to a hosted zone and you delete the child hosted zone, you must update the name servers in the
     * parent hosted zone.) In addition, if you delete a hosted zone, someone could hijack the domain and route traffic
     * to their own resources using your domain name.
     * </p>
     * </important>
     * <p>
     * If you want to avoid the monthly charge for the hosted zone, you can transfer DNS service for the domain to a
     * free DNS service. When you transfer DNS service, you have to update the name servers for the domain registration.
     * If the domain is registered with Route 53, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainNameservers.html"
     * >UpdateDomainNameservers</a> for information about how to replace Route 53 name servers with name servers for the
     * new DNS service. If the domain is registered with another registrar, use the method provided by the registrar to
     * update name servers for the domain registration. For more information, perform an internet search on
     * "free DNS service."
     * </p>
     * <p>
     * You can delete a hosted zone only if it contains only the default SOA and NS records and has DNSSEC signing
     * disabled. If the hosted zone contains other records or has DNSSEC enabled, you must delete the records and
     * disable DNSSEC before deletion. Attempting to delete a hosted zone with additional records or DNSSEC enabled
     * returns a <code>HostedZoneNotEmpty</code> error. For information about deleting records, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ChangeResourceRecordSets.html"
     * >ChangeResourceRecordSets</a>.
     * </p>
     * <p>
     * To verify that the hosted zone has been deleted, do one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>GetHostedZone</code> action to request information about the hosted zone.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>ListHostedZones</code> action to get a list of the hosted zones associated with the current Amazon
     * Web Services account.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteHostedZoneRequest
     *        A request to delete a hosted zone.
     * @return Result of the DeleteHostedZone operation returned by the service.
     * @throws NoSuchHostedZoneException
     *         No hosted zone exists with the ID that you specified.
     * @throws HostedZoneNotEmptyException
     *         The hosted zone contains resource records that are not SOA or NS records.
     * @throws PriorRequestNotCompleteException
     *         If Amazon Route 53 can't process a request before the next request arrives, it will reject subsequent
     *         requests for the same hosted zone and return an <code>HTTP 400 error</code> (<code>Bad request</code>).
     *         If Route 53 returns this error repeatedly for the same request, we recommend that you wait, in intervals
     *         of increasing duration, before you try the request again.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws InvalidDomainNameException
     *         The specified domain name is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.DeleteHostedZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteHostedZone" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteHostedZoneResponse deleteHostedZone(DeleteHostedZoneRequest deleteHostedZoneRequest)
            throws NoSuchHostedZoneException, HostedZoneNotEmptyException, PriorRequestNotCompleteException,
            InvalidInputException, InvalidDomainNameException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<DeleteHostedZoneResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                DeleteHostedZoneResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteHostedZoneRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteHostedZoneRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteHostedZone");

            return clientHandler.execute(new ClientExecutionParams<DeleteHostedZoneRequest, DeleteHostedZoneResponse>()
                    .withOperationName("DeleteHostedZone").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteHostedZoneRequest)
                    .withMarshaller(new DeleteHostedZoneRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a key-signing key (KSK). Before you can delete a KSK, you must deactivate it. The KSK must be deactivated
     * before you can delete it regardless of whether the hosted zone is enabled for DNSSEC signing.
     * </p>
     * <p>
     * You can use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeactivateKeySigningKey.html">
     * DeactivateKeySigningKey</a> to deactivate the key before you delete it.
     * </p>
     * <p>
     * Use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetDNSSEC.html">GetDNSSEC</a> to verify
     * that the KSK is in an <code>INACTIVE</code> status.
     * </p>
     *
     * @param deleteKeySigningKeyRequest
     * @return Result of the DeleteKeySigningKey operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another user submitted a request to create, update, or delete the object at the same time that you did.
     *         Retry the request.
     * @throws NoSuchKeySigningKeyException
     *         The specified key-signing key (KSK) doesn't exist.
     * @throws InvalidKeySigningKeyStatusException
     *         The key-signing key (KSK) status isn't valid or another KSK has the status <code>INTERNAL_FAILURE</code>.
     * @throws InvalidSigningStatusException
     *         Your hosted zone status isn't valid for this operation. In the hosted zone, change the status to enable
     *         <code>DNSSEC</code> or disable <code>DNSSEC</code>.
     * @throws InvalidKmsArnException
     *         The KeyManagementServiceArn that you specified isn't valid to use with DNSSEC signing.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.DeleteKeySigningKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteKeySigningKey" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteKeySigningKeyResponse deleteKeySigningKey(DeleteKeySigningKeyRequest deleteKeySigningKeyRequest)
            throws ConcurrentModificationException, NoSuchKeySigningKeyException, InvalidKeySigningKeyStatusException,
            InvalidSigningStatusException, InvalidKmsArnException, InvalidInputException, AwsServiceException,
            SdkClientException, Route53Exception {

        HttpResponseHandler<Response<DeleteKeySigningKeyResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(DeleteKeySigningKeyResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteKeySigningKeyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteKeySigningKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteKeySigningKey");

            return clientHandler.execute(new ClientExecutionParams<DeleteKeySigningKeyRequest, DeleteKeySigningKeyResponse>()
                    .withOperationName("DeleteKeySigningKey").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteKeySigningKeyRequest)
                    .withMarshaller(new DeleteKeySigningKeyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a configuration for DNS query logging. If you delete a configuration, Amazon Route 53 stops sending query
     * logs to CloudWatch Logs. Route 53 doesn't delete any logs that are already in CloudWatch Logs.
     * </p>
     * <p>
     * For more information about DNS query logs, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateQueryLoggingConfig.html"
     * >CreateQueryLoggingConfig</a>.
     * </p>
     *
     * @param deleteQueryLoggingConfigRequest
     * @return Result of the DeleteQueryLoggingConfig operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another user submitted a request to create, update, or delete the object at the same time that you did.
     *         Retry the request.
     * @throws NoSuchQueryLoggingConfigException
     *         There is no DNS query logging configuration with the specified ID.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.DeleteQueryLoggingConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteQueryLoggingConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteQueryLoggingConfigResponse deleteQueryLoggingConfig(
            DeleteQueryLoggingConfigRequest deleteQueryLoggingConfigRequest) throws ConcurrentModificationException,
            NoSuchQueryLoggingConfigException, InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<DeleteQueryLoggingConfigResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(DeleteQueryLoggingConfigResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteQueryLoggingConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteQueryLoggingConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteQueryLoggingConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteQueryLoggingConfigRequest, DeleteQueryLoggingConfigResponse>()
                            .withOperationName("DeleteQueryLoggingConfig").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteQueryLoggingConfigRequest)
                            .withMarshaller(new DeleteQueryLoggingConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a reusable delegation set.
     * </p>
     * <important>
     * <p>
     * You can delete a reusable delegation set only if it isn't associated with any hosted zones.
     * </p>
     * </important>
     * <p>
     * To verify that the reusable delegation set is not associated with any hosted zones, submit a <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetReusableDelegationSet.html"
     * >GetReusableDelegationSet</a> request and specify the ID of the reusable delegation set that you want to delete.
     * </p>
     *
     * @param deleteReusableDelegationSetRequest
     *        A request to delete a reusable delegation set.
     * @return Result of the DeleteReusableDelegationSet operation returned by the service.
     * @throws NoSuchDelegationSetException
     *         A reusable delegation set with the specified ID does not exist.
     * @throws DelegationSetInUseException
     *         The specified delegation contains associated hosted zones which must be deleted before the reusable
     *         delegation set can be deleted.
     * @throws DelegationSetNotReusableException
     *         A reusable delegation set with the specified ID does not exist.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.DeleteReusableDelegationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteReusableDelegationSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteReusableDelegationSetResponse deleteReusableDelegationSet(
            DeleteReusableDelegationSetRequest deleteReusableDelegationSetRequest) throws NoSuchDelegationSetException,
            DelegationSetInUseException, DelegationSetNotReusableException, InvalidInputException, AwsServiceException,
            SdkClientException, Route53Exception {

        HttpResponseHandler<Response<DeleteReusableDelegationSetResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(DeleteReusableDelegationSetResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteReusableDelegationSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteReusableDelegationSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteReusableDelegationSet");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteReusableDelegationSetRequest, DeleteReusableDelegationSetResponse>()
                            .withOperationName("DeleteReusableDelegationSet").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteReusableDelegationSetRequest)
                            .withMarshaller(new DeleteReusableDelegationSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a traffic policy.
     * </p>
     * <p>
     * When you delete a traffic policy, Route 53 sets a flag on the policy to indicate that it has been deleted.
     * However, Route 53 never fully deletes the traffic policy. Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Deleted traffic policies aren't listed if you run <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListTrafficPolicies.html"
     * >ListTrafficPolicies</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * There's no way to get a list of deleted policies.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you retain the ID of the policy, you can get information about the policy, including the traffic policy
     * document, by running <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetTrafficPolicy.html">GetTrafficPolicy</a>.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteTrafficPolicyRequest
     *        A request to delete a specified traffic policy version.
     * @return Result of the DeleteTrafficPolicy operation returned by the service.
     * @throws NoSuchTrafficPolicyException
     *         No traffic policy exists with the specified ID.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws TrafficPolicyInUseException
     *         One or more traffic policy instances were created by using the specified traffic policy.
     * @throws ConcurrentModificationException
     *         Another user submitted a request to create, update, or delete the object at the same time that you did.
     *         Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.DeleteTrafficPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteTrafficPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteTrafficPolicyResponse deleteTrafficPolicy(DeleteTrafficPolicyRequest deleteTrafficPolicyRequest)
            throws NoSuchTrafficPolicyException, InvalidInputException, TrafficPolicyInUseException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<DeleteTrafficPolicyResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(DeleteTrafficPolicyResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTrafficPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTrafficPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTrafficPolicy");

            return clientHandler.execute(new ClientExecutionParams<DeleteTrafficPolicyRequest, DeleteTrafficPolicyResponse>()
                    .withOperationName("DeleteTrafficPolicy").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteTrafficPolicyRequest)
                    .withMarshaller(new DeleteTrafficPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a traffic policy instance and all of the resource record sets that Amazon Route 53 created when you
     * created the instance.
     * </p>
     * <note>
     * <p>
     * In the Route 53 console, traffic policy instances are known as policy records.
     * </p>
     * </note>
     *
     * @param deleteTrafficPolicyInstanceRequest
     *        A request to delete a specified traffic policy instance.
     * @return Result of the DeleteTrafficPolicyInstance operation returned by the service.
     * @throws NoSuchTrafficPolicyInstanceException
     *         No traffic policy instance exists with the specified ID.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws PriorRequestNotCompleteException
     *         If Amazon Route 53 can't process a request before the next request arrives, it will reject subsequent
     *         requests for the same hosted zone and return an <code>HTTP 400 error</code> (<code>Bad request</code>).
     *         If Route 53 returns this error repeatedly for the same request, we recommend that you wait, in intervals
     *         of increasing duration, before you try the request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.DeleteTrafficPolicyInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteTrafficPolicyInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteTrafficPolicyInstanceResponse deleteTrafficPolicyInstance(
            DeleteTrafficPolicyInstanceRequest deleteTrafficPolicyInstanceRequest) throws NoSuchTrafficPolicyInstanceException,
            InvalidInputException, PriorRequestNotCompleteException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<DeleteTrafficPolicyInstanceResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(DeleteTrafficPolicyInstanceResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTrafficPolicyInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTrafficPolicyInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTrafficPolicyInstance");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteTrafficPolicyInstanceRequest, DeleteTrafficPolicyInstanceResponse>()
                            .withOperationName("DeleteTrafficPolicyInstance").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteTrafficPolicyInstanceRequest)
                            .withMarshaller(new DeleteTrafficPolicyInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes authorization to submit an <code>AssociateVPCWithHostedZone</code> request to associate a specified VPC
     * with a hosted zone that was created by a different account. You must use the account that created the hosted zone
     * to submit a <code>DeleteVPCAssociationAuthorization</code> request.
     * </p>
     * <important>
     * <p>
     * Sending this request only prevents the Amazon Web Services account that created the VPC from associating the VPC
     * with the Amazon Route 53 hosted zone in the future. If the VPC is already associated with the hosted zone,
     * <code>DeleteVPCAssociationAuthorization</code> won't disassociate the VPC from the hosted zone. If you want to
     * delete an existing association, use <code>DisassociateVPCFromHostedZone</code>.
     * </p>
     * </important>
     *
     * @param deleteVpcAssociationAuthorizationRequest
     *        A complex type that contains information about the request to remove authorization to associate a VPC that
     *        was created by one Amazon Web Services account with a hosted zone that was created with a different Amazon
     *        Web Services account.
     * @return Result of the DeleteVPCAssociationAuthorization operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another user submitted a request to create, update, or delete the object at the same time that you did.
     *         Retry the request.
     * @throws VpcAssociationAuthorizationNotFoundException
     *         The VPC that you specified is not authorized to be associated with the hosted zone.
     * @throws NoSuchHostedZoneException
     *         No hosted zone exists with the ID that you specified.
     * @throws InvalidVpcIdException
     *         The VPC ID that you specified either isn't a valid ID or the current account is not authorized to access
     *         this VPC.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.DeleteVPCAssociationAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteVPCAssociationAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteVpcAssociationAuthorizationResponse deleteVPCAssociationAuthorization(
            DeleteVpcAssociationAuthorizationRequest deleteVpcAssociationAuthorizationRequest)
            throws ConcurrentModificationException, VpcAssociationAuthorizationNotFoundException, NoSuchHostedZoneException,
            InvalidVpcIdException, InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<DeleteVpcAssociationAuthorizationResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(DeleteVpcAssociationAuthorizationResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVpcAssociationAuthorizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteVpcAssociationAuthorizationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVPCAssociationAuthorization");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteVpcAssociationAuthorizationRequest, DeleteVpcAssociationAuthorizationResponse>()
                            .withOperationName("DeleteVPCAssociationAuthorization").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteVpcAssociationAuthorizationRequest)
                            .withMarshaller(new DeleteVpcAssociationAuthorizationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disables DNSSEC signing in a specific hosted zone. This action does not deactivate any key-signing keys (KSKs)
     * that are active in the hosted zone.
     * </p>
     *
     * @param disableHostedZoneDnssecRequest
     * @return Result of the DisableHostedZoneDNSSEC operation returned by the service.
     * @throws NoSuchHostedZoneException
     *         No hosted zone exists with the ID that you specified.
     * @throws InvalidArgumentException
     *         Parameter name is not valid.
     * @throws ConcurrentModificationException
     *         Another user submitted a request to create, update, or delete the object at the same time that you did.
     *         Retry the request.
     * @throws KeySigningKeyInParentDsRecordException
     *         The key-signing key (KSK) is specified in a parent DS record.
     * @throws DnssecNotFoundException
     *         The hosted zone doesn't have any DNSSEC resources.
     * @throws InvalidKeySigningKeyStatusException
     *         The key-signing key (KSK) status isn't valid or another KSK has the status <code>INTERNAL_FAILURE</code>.
     * @throws InvalidKmsArnException
     *         The KeyManagementServiceArn that you specified isn't valid to use with DNSSEC signing.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.DisableHostedZoneDNSSEC
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DisableHostedZoneDNSSEC"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisableHostedZoneDnssecResponse disableHostedZoneDNSSEC(DisableHostedZoneDnssecRequest disableHostedZoneDnssecRequest)
            throws NoSuchHostedZoneException, InvalidArgumentException, ConcurrentModificationException,
            KeySigningKeyInParentDsRecordException, DnssecNotFoundException, InvalidKeySigningKeyStatusException,
            InvalidKmsArnException, InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<DisableHostedZoneDnssecResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(DisableHostedZoneDnssecResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disableHostedZoneDnssecRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disableHostedZoneDnssecRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableHostedZoneDNSSEC");

            return clientHandler
                    .execute(new ClientExecutionParams<DisableHostedZoneDnssecRequest, DisableHostedZoneDnssecResponse>()
                            .withOperationName("DisableHostedZoneDNSSEC").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(disableHostedZoneDnssecRequest)
                            .withMarshaller(new DisableHostedZoneDnssecRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates an Amazon Virtual Private Cloud (Amazon VPC) from an Amazon Route 53 private hosted zone. Note the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can't disassociate the last Amazon VPC from a private hosted zone.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't convert a private hosted zone into a public hosted zone.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can submit a <code>DisassociateVPCFromHostedZone</code> request using either the account that created the
     * hosted zone or the account that created the Amazon VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * Some services, such as Cloud Map and Amazon Elastic File System (Amazon EFS) automatically create hosted zones
     * and associate VPCs with the hosted zones. A service can create a hosted zone using your account or using its own
     * account. You can disassociate a VPC from a hosted zone only if the service created the hosted zone using your
     * account.
     * </p>
     * <p>
     * When you run <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListHostedZonesByVPC.html">
     * DisassociateVPCFromHostedZone</a>, if the hosted zone has a value for <code>OwningAccount</code>, you can use
     * <code>DisassociateVPCFromHostedZone</code>. If the hosted zone has a value for <code>OwningService</code>, you
     * can't use <code>DisassociateVPCFromHostedZone</code>.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * When revoking access, the hosted zone and the Amazon VPC must belong to the same partition. A partition is a
     * group of Amazon Web Services Regions. Each Amazon Web Services account is scoped to one partition.
     * </p>
     * <p>
     * The following are the supported partitions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>aws</code> - Amazon Web Services Regions
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aws-cn</code> - China Regions
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aws-us-gov</code> - Amazon Web Services GovCloud (US) Region
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Access Management</a> in the
     * <i>Amazon Web Services General Reference</i>.
     * </p>
     * </note>
     *
     * @param disassociateVpcFromHostedZoneRequest
     *        A complex type that contains information about the VPC that you want to disassociate from a specified
     *        private hosted zone.
     * @return Result of the DisassociateVPCFromHostedZone operation returned by the service.
     * @throws NoSuchHostedZoneException
     *         No hosted zone exists with the ID that you specified.
     * @throws InvalidVpcIdException
     *         The VPC ID that you specified either isn't a valid ID or the current account is not authorized to access
     *         this VPC.
     * @throws VpcAssociationNotFoundException
     *         The specified VPC and hosted zone are not currently associated.
     * @throws LastVpcAssociationException
     *         The VPC that you're trying to disassociate from the private hosted zone is the last VPC that is
     *         associated with the hosted zone. Amazon Route 53 doesn't support disassociating the last VPC from a
     *         hosted zone.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.DisassociateVPCFromHostedZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DisassociateVPCFromHostedZone"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateVpcFromHostedZoneResponse disassociateVPCFromHostedZone(
            DisassociateVpcFromHostedZoneRequest disassociateVpcFromHostedZoneRequest) throws NoSuchHostedZoneException,
            InvalidVpcIdException, VpcAssociationNotFoundException, LastVpcAssociationException, InvalidInputException,
            AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<DisassociateVpcFromHostedZoneResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(DisassociateVpcFromHostedZoneResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateVpcFromHostedZoneRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateVpcFromHostedZoneRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateVPCFromHostedZone");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateVpcFromHostedZoneRequest, DisassociateVpcFromHostedZoneResponse>()
                            .withOperationName("DisassociateVPCFromHostedZone").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(disassociateVpcFromHostedZoneRequest)
                            .withMarshaller(new DisassociateVpcFromHostedZoneRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables DNSSEC signing in a specific hosted zone.
     * </p>
     *
     * @param enableHostedZoneDnssecRequest
     * @return Result of the EnableHostedZoneDNSSEC operation returned by the service.
     * @throws NoSuchHostedZoneException
     *         No hosted zone exists with the ID that you specified.
     * @throws InvalidArgumentException
     *         Parameter name is not valid.
     * @throws ConcurrentModificationException
     *         Another user submitted a request to create, update, or delete the object at the same time that you did.
     *         Retry the request.
     * @throws KeySigningKeyWithActiveStatusNotFoundException
     *         A key-signing key (KSK) with <code>ACTIVE</code> status wasn't found.
     * @throws InvalidKmsArnException
     *         The KeyManagementServiceArn that you specified isn't valid to use with DNSSEC signing.
     * @throws HostedZonePartiallyDelegatedException
     *         The hosted zone nameservers don't match the parent nameservers. The hosted zone and parent must have the
     *         same nameservers.
     * @throws DnssecNotFoundException
     *         The hosted zone doesn't have any DNSSEC resources.
     * @throws InvalidKeySigningKeyStatusException
     *         The key-signing key (KSK) status isn't valid or another KSK has the status <code>INTERNAL_FAILURE</code>.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.EnableHostedZoneDNSSEC
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/EnableHostedZoneDNSSEC"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public EnableHostedZoneDnssecResponse enableHostedZoneDNSSEC(EnableHostedZoneDnssecRequest enableHostedZoneDnssecRequest)
            throws NoSuchHostedZoneException, InvalidArgumentException, ConcurrentModificationException,
            KeySigningKeyWithActiveStatusNotFoundException, InvalidKmsArnException, HostedZonePartiallyDelegatedException,
            DnssecNotFoundException, InvalidKeySigningKeyStatusException, InvalidInputException, AwsServiceException,
            SdkClientException, Route53Exception {

        HttpResponseHandler<Response<EnableHostedZoneDnssecResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(EnableHostedZoneDnssecResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(enableHostedZoneDnssecRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableHostedZoneDnssecRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableHostedZoneDNSSEC");

            return clientHandler
                    .execute(new ClientExecutionParams<EnableHostedZoneDnssecRequest, EnableHostedZoneDnssecResponse>()
                            .withOperationName("EnableHostedZoneDNSSEC").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(enableHostedZoneDnssecRequest)
                            .withMarshaller(new EnableHostedZoneDnssecRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the specified limit for the current account, for example, the maximum number of health checks that you can
     * create using the account.
     * </p>
     * <p>
     * For the default limit, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the <i>Amazon
     * Route 53 Developer Guide</i>. To request a higher limit, <a href=
     * "https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&amp;limitType=service-code-route53"
     * >open a case</a>.
     * </p>
     * <note>
     * <p>
     * You can also view account limits in Amazon Web Services Trusted Advisor. Sign in to the Amazon Web Services
     * Management Console and open the Trusted Advisor console at <a
     * href="https://console.aws.amazon.com/trustedadvisor">https://console.aws.amazon.com/trustedadvisor/</a>. Then
     * choose <b>Service limits</b> in the navigation pane.
     * </p>
     * </note>
     *
     * @param getAccountLimitRequest
     *        A complex type that contains information about the request to create a hosted zone.
     * @return Result of the GetAccountLimit operation returned by the service.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.GetAccountLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetAccountLimit" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetAccountLimitResponse getAccountLimit(GetAccountLimitRequest getAccountLimitRequest) throws InvalidInputException,
            AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<GetAccountLimitResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                GetAccountLimitResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAccountLimitRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAccountLimitRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccountLimit");

            return clientHandler.execute(new ClientExecutionParams<GetAccountLimitRequest, GetAccountLimitResponse>()
                    .withOperationName("GetAccountLimit").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(getAccountLimitRequest)
                    .withMarshaller(new GetAccountLimitRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the current status of a change batch request. The status is one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> indicates that the changes in this request have not propagated to all Amazon Route 53 DNS
     * servers managing the hosted zone. This is the initial status of all change batch requests.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSYNC</code> indicates that the changes have propagated to all Route 53 DNS servers managing the hosted
     * zone.
     * </p>
     * </li>
     * </ul>
     *
     * @param getChangeRequest
     *        The input for a GetChange request.
     * @return Result of the GetChange operation returned by the service.
     * @throws NoSuchChangeException
     *         A change with the specified change ID does not exist.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.GetChange
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetChange" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetChangeResponse getChange(GetChangeRequest getChangeRequest) throws NoSuchChangeException, InvalidInputException,
            AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<GetChangeResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                GetChangeResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getChangeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getChangeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetChange");

            return clientHandler.execute(new ClientExecutionParams<GetChangeRequest, GetChangeResponse>()
                    .withOperationName("GetChange").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(getChangeRequest)
                    .withMarshaller(new GetChangeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Route 53 does not perform authorization for this API because it retrieves information that is already available
     * to the public.
     * </p>
     * <important>
     * <p>
     * <code>GetCheckerIpRanges</code> still works, but we recommend that you download ip-ranges.json, which includes IP
     * address ranges for all Amazon Web Services services. For more information, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/route-53-ip-addresses.html">IP Address Ranges of
     * Amazon Route 53 Servers</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * </important>
     *
     * @param getCheckerIpRangesRequest
     *        Empty request.
     * @return Result of the GetCheckerIpRanges operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.GetCheckerIpRanges
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetCheckerIpRanges" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetCheckerIpRangesResponse getCheckerIpRanges(GetCheckerIpRangesRequest getCheckerIpRangesRequest)
            throws AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<GetCheckerIpRangesResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetCheckerIpRangesResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCheckerIpRangesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCheckerIpRangesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCheckerIpRanges");

            return clientHandler.execute(new ClientExecutionParams<GetCheckerIpRangesRequest, GetCheckerIpRangesResponse>()
                    .withOperationName("GetCheckerIpRanges").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(getCheckerIpRangesRequest)
                    .withMarshaller(new GetCheckerIpRangesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about DNSSEC for a specific hosted zone, including the key-signing keys (KSKs) in the hosted
     * zone.
     * </p>
     *
     * @param getDnssecRequest
     * @return Result of the GetDNSSEC operation returned by the service.
     * @throws NoSuchHostedZoneException
     *         No hosted zone exists with the ID that you specified.
     * @throws InvalidArgumentException
     *         Parameter name is not valid.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.GetDNSSEC
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetDNSSEC" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDnssecResponse getDNSSEC(GetDnssecRequest getDnssecRequest) throws NoSuchHostedZoneException,
            InvalidArgumentException, InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<GetDnssecResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                GetDnssecResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDnssecRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDnssecRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDNSSEC");

            return clientHandler.execute(new ClientExecutionParams<GetDnssecRequest, GetDnssecResponse>()
                    .withOperationName("GetDNSSEC").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(getDnssecRequest)
                    .withMarshaller(new GetDnssecRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about whether a specified geographic location is supported for Amazon Route 53 geolocation
     * resource record sets.
     * </p>
     * <p>
     * Route 53 does not perform authorization for this API because it retrieves information that is already available
     * to the public.
     * </p>
     * <p>
     * Use the following syntax to determine whether a continent is supported for geolocation:
     * </p>
     * <p>
     * <code>GET /2013-04-01/geolocation?continentcode=<i>two-letter abbreviation for a continent</i> </code>
     * </p>
     * <p>
     * Use the following syntax to determine whether a country is supported for geolocation:
     * </p>
     * <p>
     * <code>GET /2013-04-01/geolocation?countrycode=<i>two-character country code</i> </code>
     * </p>
     * <p>
     * Use the following syntax to determine whether a subdivision of a country is supported for geolocation:
     * </p>
     * <p>
     * <code>GET /2013-04-01/geolocation?countrycode=<i>two-character country code</i>&amp;subdivisioncode=<i>subdivision code</i> </code>
     * </p>
     *
     * @param getGeoLocationRequest
     *        A request for information about whether a specified geographic location is supported for Amazon Route 53
     *        geolocation resource record sets.
     * @return Result of the GetGeoLocation operation returned by the service.
     * @throws NoSuchGeoLocationException
     *         Amazon Route 53 doesn't support the specified geographic location. For a list of supported geolocation
     *         codes, see the <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GeoLocation.html">GeoLocation</a> data
     *         type.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.GetGeoLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetGeoLocation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetGeoLocationResponse getGeoLocation(GetGeoLocationRequest getGeoLocationRequest) throws NoSuchGeoLocationException,
            InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<GetGeoLocationResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                GetGeoLocationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getGeoLocationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getGeoLocationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGeoLocation");

            return clientHandler.execute(new ClientExecutionParams<GetGeoLocationRequest, GetGeoLocationResponse>()
                    .withOperationName("GetGeoLocation").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(getGeoLocationRequest)
                    .withMarshaller(new GetGeoLocationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a specified health check.
     * </p>
     *
     * @param getHealthCheckRequest
     *        A request to get information about a specified health check.
     * @return Result of the GetHealthCheck operation returned by the service.
     * @throws NoSuchHealthCheckException
     *         No health check exists with the specified ID.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws IncompatibleVersionException
     *         The resource you're trying to access is unsupported on this Amazon Route 53 endpoint.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.GetHealthCheck
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHealthCheck" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetHealthCheckResponse getHealthCheck(GetHealthCheckRequest getHealthCheckRequest) throws NoSuchHealthCheckException,
            InvalidInputException, IncompatibleVersionException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<GetHealthCheckResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                GetHealthCheckResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getHealthCheckRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getHealthCheckRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetHealthCheck");

            return clientHandler.execute(new ClientExecutionParams<GetHealthCheckRequest, GetHealthCheckResponse>()
                    .withOperationName("GetHealthCheck").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(getHealthCheckRequest)
                    .withMarshaller(new GetHealthCheckRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the number of health checks that are associated with the current Amazon Web Services account.
     * </p>
     *
     * @param getHealthCheckCountRequest
     *        A request for the number of health checks that are associated with the current Amazon Web Services
     *        account.
     * @return Result of the GetHealthCheckCount operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.GetHealthCheckCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHealthCheckCount" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetHealthCheckCountResponse getHealthCheckCount(GetHealthCheckCountRequest getHealthCheckCountRequest)
            throws AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<GetHealthCheckCountResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetHealthCheckCountResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getHealthCheckCountRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getHealthCheckCountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetHealthCheckCount");

            return clientHandler.execute(new ClientExecutionParams<GetHealthCheckCountRequest, GetHealthCheckCountResponse>()
                    .withOperationName("GetHealthCheckCount").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(getHealthCheckCountRequest)
                    .withMarshaller(new GetHealthCheckCountRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the reason that a specified health check failed most recently.
     * </p>
     *
     * @param getHealthCheckLastFailureReasonRequest
     *        A request for the reason that a health check failed most recently.
     * @return Result of the GetHealthCheckLastFailureReason operation returned by the service.
     * @throws NoSuchHealthCheckException
     *         No health check exists with the specified ID.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.GetHealthCheckLastFailureReason
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHealthCheckLastFailureReason"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetHealthCheckLastFailureReasonResponse getHealthCheckLastFailureReason(
            GetHealthCheckLastFailureReasonRequest getHealthCheckLastFailureReasonRequest) throws NoSuchHealthCheckException,
            InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<GetHealthCheckLastFailureReasonResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetHealthCheckLastFailureReasonResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getHealthCheckLastFailureReasonRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getHealthCheckLastFailureReasonRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetHealthCheckLastFailureReason");

            return clientHandler
                    .execute(new ClientExecutionParams<GetHealthCheckLastFailureReasonRequest, GetHealthCheckLastFailureReasonResponse>()
                            .withOperationName("GetHealthCheckLastFailureReason").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(getHealthCheckLastFailureReasonRequest)
                            .withMarshaller(new GetHealthCheckLastFailureReasonRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets status of a specified health check.
     * </p>
     * <important>
     * <p>
     * This API is intended for use during development to diagnose behavior. It doesn’t support production use-cases
     * with high query rates that require immediate and actionable responses.
     * </p>
     * </important>
     *
     * @param getHealthCheckStatusRequest
     *        A request to get the status for a health check.
     * @return Result of the GetHealthCheckStatus operation returned by the service.
     * @throws NoSuchHealthCheckException
     *         No health check exists with the specified ID.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.GetHealthCheckStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHealthCheckStatus" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetHealthCheckStatusResponse getHealthCheckStatus(GetHealthCheckStatusRequest getHealthCheckStatusRequest)
            throws NoSuchHealthCheckException, InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<GetHealthCheckStatusResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetHealthCheckStatusResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getHealthCheckStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getHealthCheckStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetHealthCheckStatus");

            return clientHandler.execute(new ClientExecutionParams<GetHealthCheckStatusRequest, GetHealthCheckStatusResponse>()
                    .withOperationName("GetHealthCheckStatus").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(getHealthCheckStatusRequest)
                    .withMarshaller(new GetHealthCheckStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a specified hosted zone including the four name servers assigned to the hosted zone.
     * </p>
     * <p>
     * <code/> returns the VPCs associated with the specified hosted zone and does not reflect the VPC associations by Route 53 Profiles. To get the associations to a Profile, call the <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53profiles_ListProfileAssociations.html">ListProfileAssociations</a> API.
     * </p>
     *
     * @param getHostedZoneRequest
     *        A request to get information about a specified hosted zone.
     * @return Result of the GetHostedZone operation returned by the service.
     * @throws NoSuchHostedZoneException
     *         No hosted zone exists with the ID that you specified.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.GetHostedZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHostedZone" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetHostedZoneResponse getHostedZone(GetHostedZoneRequest getHostedZoneRequest) throws NoSuchHostedZoneException,
            InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<GetHostedZoneResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                GetHostedZoneResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getHostedZoneRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getHostedZoneRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetHostedZone");

            return clientHandler.execute(new ClientExecutionParams<GetHostedZoneRequest, GetHostedZoneResponse>()
                    .withOperationName("GetHostedZone").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(getHostedZoneRequest)
                    .withMarshaller(new GetHostedZoneRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the number of hosted zones that are associated with the current Amazon Web Services account.
     * </p>
     *
     * @param getHostedZoneCountRequest
     *        A request to retrieve a count of all the hosted zones that are associated with the current Amazon Web
     *        Services account.
     * @return Result of the GetHostedZoneCount operation returned by the service.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.GetHostedZoneCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHostedZoneCount" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetHostedZoneCountResponse getHostedZoneCount(GetHostedZoneCountRequest getHostedZoneCountRequest)
            throws InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<GetHostedZoneCountResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetHostedZoneCountResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getHostedZoneCountRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getHostedZoneCountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetHostedZoneCount");

            return clientHandler.execute(new ClientExecutionParams<GetHostedZoneCountRequest, GetHostedZoneCountResponse>()
                    .withOperationName("GetHostedZoneCount").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(getHostedZoneCountRequest)
                    .withMarshaller(new GetHostedZoneCountRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the specified limit for a specified hosted zone, for example, the maximum number of records that you can
     * create in the hosted zone.
     * </p>
     * <p>
     * For the default limit, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the <i>Amazon
     * Route 53 Developer Guide</i>. To request a higher limit, <a href=
     * "https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&amp;limitType=service-code-route53"
     * >open a case</a>.
     * </p>
     *
     * @param getHostedZoneLimitRequest
     *        A complex type that contains information about the request to create a hosted zone.
     * @return Result of the GetHostedZoneLimit operation returned by the service.
     * @throws NoSuchHostedZoneException
     *         No hosted zone exists with the ID that you specified.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws HostedZoneNotPrivateException
     *         The specified hosted zone is a public hosted zone, not a private hosted zone.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.GetHostedZoneLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHostedZoneLimit" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetHostedZoneLimitResponse getHostedZoneLimit(GetHostedZoneLimitRequest getHostedZoneLimitRequest)
            throws NoSuchHostedZoneException, InvalidInputException, HostedZoneNotPrivateException, AwsServiceException,
            SdkClientException, Route53Exception {

        HttpResponseHandler<Response<GetHostedZoneLimitResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetHostedZoneLimitResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getHostedZoneLimitRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getHostedZoneLimitRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetHostedZoneLimit");

            return clientHandler.execute(new ClientExecutionParams<GetHostedZoneLimitRequest, GetHostedZoneLimitResponse>()
                    .withOperationName("GetHostedZoneLimit").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(getHostedZoneLimitRequest)
                    .withMarshaller(new GetHostedZoneLimitRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a specified configuration for DNS query logging.
     * </p>
     * <p>
     * For more information about DNS query logs, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateQueryLoggingConfig.html"
     * >CreateQueryLoggingConfig</a> and <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html">Logging DNS Queries</a>.
     * </p>
     *
     * @param getQueryLoggingConfigRequest
     * @return Result of the GetQueryLoggingConfig operation returned by the service.
     * @throws NoSuchQueryLoggingConfigException
     *         There is no DNS query logging configuration with the specified ID.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.GetQueryLoggingConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetQueryLoggingConfig" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetQueryLoggingConfigResponse getQueryLoggingConfig(GetQueryLoggingConfigRequest getQueryLoggingConfigRequest)
            throws NoSuchQueryLoggingConfigException, InvalidInputException, AwsServiceException, SdkClientException,
            Route53Exception {

        HttpResponseHandler<Response<GetQueryLoggingConfigResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetQueryLoggingConfigResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getQueryLoggingConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getQueryLoggingConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetQueryLoggingConfig");

            return clientHandler.execute(new ClientExecutionParams<GetQueryLoggingConfigRequest, GetQueryLoggingConfigResponse>()
                    .withOperationName("GetQueryLoggingConfig").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(getQueryLoggingConfigRequest)
                    .withMarshaller(new GetQueryLoggingConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a specified reusable delegation set, including the four name servers that are
     * assigned to the delegation set.
     * </p>
     *
     * @param getReusableDelegationSetRequest
     *        A request to get information about a specified reusable delegation set.
     * @return Result of the GetReusableDelegationSet operation returned by the service.
     * @throws NoSuchDelegationSetException
     *         A reusable delegation set with the specified ID does not exist.
     * @throws DelegationSetNotReusableException
     *         A reusable delegation set with the specified ID does not exist.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.GetReusableDelegationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetReusableDelegationSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetReusableDelegationSetResponse getReusableDelegationSet(
            GetReusableDelegationSetRequest getReusableDelegationSetRequest) throws NoSuchDelegationSetException,
            DelegationSetNotReusableException, InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<GetReusableDelegationSetResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetReusableDelegationSetResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReusableDelegationSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getReusableDelegationSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReusableDelegationSet");

            return clientHandler
                    .execute(new ClientExecutionParams<GetReusableDelegationSetRequest, GetReusableDelegationSetResponse>()
                            .withOperationName("GetReusableDelegationSet").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(getReusableDelegationSetRequest)
                            .withMarshaller(new GetReusableDelegationSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the maximum number of hosted zones that you can associate with the specified reusable delegation set.
     * </p>
     * <p>
     * For the default limit, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the <i>Amazon
     * Route 53 Developer Guide</i>. To request a higher limit, <a href=
     * "https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&amp;limitType=service-code-route53"
     * >open a case</a>.
     * </p>
     *
     * @param getReusableDelegationSetLimitRequest
     *        A complex type that contains information about the request to create a hosted zone.
     * @return Result of the GetReusableDelegationSetLimit operation returned by the service.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws NoSuchDelegationSetException
     *         A reusable delegation set with the specified ID does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.GetReusableDelegationSetLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetReusableDelegationSetLimit"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetReusableDelegationSetLimitResponse getReusableDelegationSetLimit(
            GetReusableDelegationSetLimitRequest getReusableDelegationSetLimitRequest) throws InvalidInputException,
            NoSuchDelegationSetException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<GetReusableDelegationSetLimitResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetReusableDelegationSetLimitResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReusableDelegationSetLimitRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getReusableDelegationSetLimitRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReusableDelegationSetLimit");

            return clientHandler
                    .execute(new ClientExecutionParams<GetReusableDelegationSetLimitRequest, GetReusableDelegationSetLimitResponse>()
                            .withOperationName("GetReusableDelegationSetLimit").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(getReusableDelegationSetLimitRequest)
                            .withMarshaller(new GetReusableDelegationSetLimitRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a specific traffic policy version.
     * </p>
     * <p>
     * For information about how of deleting a traffic policy affects the response from <code>GetTrafficPolicy</code>,
     * see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicy.html">DeleteTrafficPolicy
     * </a>.
     * </p>
     *
     * @param getTrafficPolicyRequest
     *        Gets information about a specific traffic policy version.
     * @return Result of the GetTrafficPolicy operation returned by the service.
     * @throws NoSuchTrafficPolicyException
     *         No traffic policy exists with the specified ID.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.GetTrafficPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetTrafficPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetTrafficPolicyResponse getTrafficPolicy(GetTrafficPolicyRequest getTrafficPolicyRequest)
            throws NoSuchTrafficPolicyException, InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<GetTrafficPolicyResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                GetTrafficPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTrafficPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTrafficPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTrafficPolicy");

            return clientHandler.execute(new ClientExecutionParams<GetTrafficPolicyRequest, GetTrafficPolicyResponse>()
                    .withOperationName("GetTrafficPolicy").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(getTrafficPolicyRequest)
                    .withMarshaller(new GetTrafficPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a specified traffic policy instance.
     * </p>
     * <note>
     * <p>
     * Use <code>GetTrafficPolicyInstance</code> with the <code>id</code> of new traffic policy instance to confirm that
     * the <code>CreateTrafficPolicyInstance</code> or an <code>UpdateTrafficPolicyInstance</code> request completed
     * successfully. For more information, see the <code>State</code> response element.
     * </p>
     * </note> <note>
     * <p>
     * In the Route 53 console, traffic policy instances are known as policy records.
     * </p>
     * </note>
     *
     * @param getTrafficPolicyInstanceRequest
     *        Gets information about a specified traffic policy instance.
     * @return Result of the GetTrafficPolicyInstance operation returned by the service.
     * @throws NoSuchTrafficPolicyInstanceException
     *         No traffic policy instance exists with the specified ID.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.GetTrafficPolicyInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetTrafficPolicyInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetTrafficPolicyInstanceResponse getTrafficPolicyInstance(
            GetTrafficPolicyInstanceRequest getTrafficPolicyInstanceRequest) throws NoSuchTrafficPolicyInstanceException,
            InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<GetTrafficPolicyInstanceResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetTrafficPolicyInstanceResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTrafficPolicyInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTrafficPolicyInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTrafficPolicyInstance");

            return clientHandler
                    .execute(new ClientExecutionParams<GetTrafficPolicyInstanceRequest, GetTrafficPolicyInstanceResponse>()
                            .withOperationName("GetTrafficPolicyInstance").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(getTrafficPolicyInstanceRequest)
                            .withMarshaller(new GetTrafficPolicyInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the number of traffic policy instances that are associated with the current Amazon Web Services account.
     * </p>
     *
     * @param getTrafficPolicyInstanceCountRequest
     *        Request to get the number of traffic policy instances that are associated with the current Amazon Web
     *        Services account.
     * @return Result of the GetTrafficPolicyInstanceCount operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.GetTrafficPolicyInstanceCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetTrafficPolicyInstanceCount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetTrafficPolicyInstanceCountResponse getTrafficPolicyInstanceCount(
            GetTrafficPolicyInstanceCountRequest getTrafficPolicyInstanceCountRequest) throws AwsServiceException,
            SdkClientException, Route53Exception {

        HttpResponseHandler<Response<GetTrafficPolicyInstanceCountResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetTrafficPolicyInstanceCountResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTrafficPolicyInstanceCountRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getTrafficPolicyInstanceCountRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTrafficPolicyInstanceCount");

            return clientHandler
                    .execute(new ClientExecutionParams<GetTrafficPolicyInstanceCountRequest, GetTrafficPolicyInstanceCountResponse>()
                            .withOperationName("GetTrafficPolicyInstanceCount").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(getTrafficPolicyInstanceCountRequest)
                            .withMarshaller(new GetTrafficPolicyInstanceCountRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a paginated list of location objects and their CIDR blocks.
     * </p>
     *
     * @param listCidrBlocksRequest
     * @return Result of the ListCidrBlocks operation returned by the service.
     * @throws NoSuchCidrCollectionException
     *         The CIDR collection you specified, doesn't exist.
     * @throws NoSuchCidrLocationException
     *         The CIDR collection location doesn't match any locations in your account.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.ListCidrBlocks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListCidrBlocks" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListCidrBlocksResponse listCidrBlocks(ListCidrBlocksRequest listCidrBlocksRequest)
            throws NoSuchCidrCollectionException, NoSuchCidrLocationException, InvalidInputException, AwsServiceException,
            SdkClientException, Route53Exception {

        HttpResponseHandler<Response<ListCidrBlocksResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                ListCidrBlocksResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCidrBlocksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCidrBlocksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCidrBlocks");

            return clientHandler.execute(new ClientExecutionParams<ListCidrBlocksRequest, ListCidrBlocksResponse>()
                    .withOperationName("ListCidrBlocks").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(listCidrBlocksRequest)
                    .withMarshaller(new ListCidrBlocksRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a paginated list of CIDR collections in the Amazon Web Services account (metadata only).
     * </p>
     *
     * @param listCidrCollectionsRequest
     * @return Result of the ListCidrCollections operation returned by the service.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.ListCidrCollections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListCidrCollections" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListCidrCollectionsResponse listCidrCollections(ListCidrCollectionsRequest listCidrCollectionsRequest)
            throws InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<ListCidrCollectionsResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListCidrCollectionsResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCidrCollectionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCidrCollectionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCidrCollections");

            return clientHandler.execute(new ClientExecutionParams<ListCidrCollectionsRequest, ListCidrCollectionsResponse>()
                    .withOperationName("ListCidrCollections").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(listCidrCollectionsRequest)
                    .withMarshaller(new ListCidrCollectionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a paginated list of CIDR locations for the given collection (metadata only, does not include CIDR
     * blocks).
     * </p>
     *
     * @param listCidrLocationsRequest
     * @return Result of the ListCidrLocations operation returned by the service.
     * @throws NoSuchCidrCollectionException
     *         The CIDR collection you specified, doesn't exist.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.ListCidrLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListCidrLocations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListCidrLocationsResponse listCidrLocations(ListCidrLocationsRequest listCidrLocationsRequest)
            throws NoSuchCidrCollectionException, InvalidInputException, AwsServiceException, SdkClientException,
            Route53Exception {

        HttpResponseHandler<Response<ListCidrLocationsResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                ListCidrLocationsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCidrLocationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCidrLocationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCidrLocations");

            return clientHandler.execute(new ClientExecutionParams<ListCidrLocationsRequest, ListCidrLocationsResponse>()
                    .withOperationName("ListCidrLocations").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(listCidrLocationsRequest)
                    .withMarshaller(new ListCidrLocationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of supported geographic locations.
     * </p>
     * <p>
     * Countries are listed first, and continents are listed last. If Amazon Route 53 supports subdivisions for a
     * country (for example, states or provinces), the subdivisions for that country are listed in alphabetical order
     * immediately after the corresponding country.
     * </p>
     * <p>
     * Route 53 does not perform authorization for this API because it retrieves information that is already available
     * to the public.
     * </p>
     * <p>
     * For a list of supported geolocation codes, see the <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GeoLocation.html">GeoLocation</a> data type.
     * </p>
     *
     * @param listGeoLocationsRequest
     *        A request to get a list of geographic locations that Amazon Route 53 supports for geolocation resource
     *        record sets.
     * @return Result of the ListGeoLocations operation returned by the service.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.ListGeoLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListGeoLocations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListGeoLocationsResponse listGeoLocations(ListGeoLocationsRequest listGeoLocationsRequest)
            throws InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<ListGeoLocationsResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                ListGeoLocationsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listGeoLocationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGeoLocationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGeoLocations");

            return clientHandler.execute(new ClientExecutionParams<ListGeoLocationsRequest, ListGeoLocationsResponse>()
                    .withOperationName("ListGeoLocations").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(listGeoLocationsRequest)
                    .withMarshaller(new ListGeoLocationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieve a list of the health checks that are associated with the current Amazon Web Services account.
     * </p>
     *
     * @param listHealthChecksRequest
     *        A request to retrieve a list of the health checks that are associated with the current Amazon Web Services
     *        account.
     * @return Result of the ListHealthChecks operation returned by the service.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws IncompatibleVersionException
     *         The resource you're trying to access is unsupported on this Amazon Route 53 endpoint.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.ListHealthChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHealthChecks" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListHealthChecksResponse listHealthChecks(ListHealthChecksRequest listHealthChecksRequest)
            throws InvalidInputException, IncompatibleVersionException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<ListHealthChecksResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                ListHealthChecksResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listHealthChecksRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listHealthChecksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListHealthChecks");

            return clientHandler.execute(new ClientExecutionParams<ListHealthChecksRequest, ListHealthChecksResponse>()
                    .withOperationName("ListHealthChecks").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(listHealthChecksRequest)
                    .withMarshaller(new ListHealthChecksRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of the public and private hosted zones that are associated with the current Amazon Web Services
     * account. The response includes a <code>HostedZones</code> child element for each hosted zone.
     * </p>
     * <p>
     * Amazon Route 53 returns a maximum of 100 items in each response. If you have a lot of hosted zones, you can use
     * the <code>maxitems</code> parameter to list them in groups of up to 100.
     * </p>
     *
     * @param listHostedZonesRequest
     *        A request to retrieve a list of the public and private hosted zones that are associated with the current
     *        Amazon Web Services account.
     * @return Result of the ListHostedZones operation returned by the service.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws NoSuchDelegationSetException
     *         A reusable delegation set with the specified ID does not exist.
     * @throws DelegationSetNotReusableException
     *         A reusable delegation set with the specified ID does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.ListHostedZones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHostedZones" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListHostedZonesResponse listHostedZones(ListHostedZonesRequest listHostedZonesRequest) throws InvalidInputException,
            NoSuchDelegationSetException, DelegationSetNotReusableException, AwsServiceException, SdkClientException,
            Route53Exception {

        HttpResponseHandler<Response<ListHostedZonesResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                ListHostedZonesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listHostedZonesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listHostedZonesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListHostedZones");

            return clientHandler.execute(new ClientExecutionParams<ListHostedZonesRequest, ListHostedZonesResponse>()
                    .withOperationName("ListHostedZones").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(listHostedZonesRequest)
                    .withMarshaller(new ListHostedZonesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of your hosted zones in lexicographic order. The response includes a <code>HostedZones</code>
     * child element for each hosted zone created by the current Amazon Web Services account.
     * </p>
     * <p>
     * <code>ListHostedZonesByName</code> sorts hosted zones by name with the labels reversed. For example:
     * </p>
     * <p>
     * <code>com.example.www.</code>
     * </p>
     * <p>
     * Note the trailing dot, which can change the sort order in some circumstances.
     * </p>
     * <p>
     * If the domain name includes escape characters or Punycode, <code>ListHostedZonesByName</code> alphabetizes the
     * domain name using the escaped or Punycoded value, which is the format that Amazon Route 53 saves in its database.
     * For example, to create a hosted zone for exämple.com, you specify ex\344mple.com for the domain name.
     * <code>ListHostedZonesByName</code> alphabetizes it as:
     * </p>
     * <p>
     * <code>com.ex\344mple.</code>
     * </p>
     * <p>
     * The labels are reversed and alphabetized using the escaped value. For more information about valid domain name
     * formats, including internationalized domain names, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html">DNS Domain Name Format</a>
     * in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * Route 53 returns up to 100 items in each response. If you have a lot of hosted zones, use the
     * <code>MaxItems</code> parameter to list them in groups of up to 100. The response includes values that help
     * navigate from one group of <code>MaxItems</code> hosted zones to the next:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>DNSName</code> and <code>HostedZoneId</code> elements in the response contain the values, if any,
     * specified for the <code>dnsname</code> and <code>hostedzoneid</code> parameters in the request that produced the
     * current response.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>MaxItems</code> element in the response contains the value, if any, that you specified for the
     * <code>maxitems</code> parameter in the request that produced the current response.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the value of <code>IsTruncated</code> in the response is true, there are more hosted zones associated with the
     * current Amazon Web Services account.
     * </p>
     * <p>
     * If <code>IsTruncated</code> is false, this response includes the last hosted zone that is associated with the
     * current account. The <code>NextDNSName</code> element and <code>NextHostedZoneId</code> elements are omitted from
     * the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>NextDNSName</code> and <code>NextHostedZoneId</code> elements in the response contain the domain name
     * and the hosted zone ID of the next hosted zone that is associated with the current Amazon Web Services account.
     * If you want to list more hosted zones, make another call to <code>ListHostedZonesByName</code>, and specify the
     * value of <code>NextDNSName</code> and <code>NextHostedZoneId</code> in the <code>dnsname</code> and
     * <code>hostedzoneid</code> parameters, respectively.
     * </p>
     * </li>
     * </ul>
     *
     * @param listHostedZonesByNameRequest
     *        Retrieves a list of the public and private hosted zones that are associated with the current Amazon Web
     *        Services account in ASCII order by domain name.
     * @return Result of the ListHostedZonesByName operation returned by the service.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws InvalidDomainNameException
     *         The specified domain name is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.ListHostedZonesByName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHostedZonesByName" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListHostedZonesByNameResponse listHostedZonesByName(ListHostedZonesByNameRequest listHostedZonesByNameRequest)
            throws InvalidInputException, InvalidDomainNameException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<ListHostedZonesByNameResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListHostedZonesByNameResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listHostedZonesByNameRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listHostedZonesByNameRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListHostedZonesByName");

            return clientHandler.execute(new ClientExecutionParams<ListHostedZonesByNameRequest, ListHostedZonesByNameResponse>()
                    .withOperationName("ListHostedZonesByName").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(listHostedZonesByNameRequest)
                    .withMarshaller(new ListHostedZonesByNameRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all the private hosted zones that a specified VPC is associated with, regardless of which Amazon Web
     * Services account or Amazon Web Services service owns the hosted zones. The <code>HostedZoneOwner</code> structure
     * in the response contains one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An <code>OwningAccount</code> element, which contains the account number of either the current Amazon Web
     * Services account or another Amazon Web Services account. Some services, such as Cloud Map, create hosted zones
     * using the current account.
     * </p>
     * </li>
     * <li>
     * <p>
     * An <code>OwningService</code> element, which identifies the Amazon Web Services service that created and owns the
     * hosted zone. For example, if a hosted zone was created by Amazon Elastic File System (Amazon EFS), the value of
     * <code>Owner</code> is <code>efs.amazonaws.com</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>ListHostedZonesByVPC</code> returns the hosted zones associated with the specified VPC and does not reflect
     * the hosted zone associations to VPCs via Route 53 Profiles. To get the associations to a Profile, call the <a
     * href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53profiles_ListProfileResourceAssociations.html"
     * >ListProfileResourceAssociations</a> API.
     * </p>
     * <note>
     * <p>
     * When listing private hosted zones, the hosted zone and the Amazon VPC must belong to the same partition where the
     * hosted zones were created. A partition is a group of Amazon Web Services Regions. Each Amazon Web Services
     * account is scoped to one partition.
     * </p>
     * <p>
     * The following are the supported partitions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>aws</code> - Amazon Web Services Regions
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aws-cn</code> - China Regions
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aws-us-gov</code> - Amazon Web Services GovCloud (US) Region
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Access Management</a> in the
     * <i>Amazon Web Services General Reference</i>.
     * </p>
     * </note>
     *
     * @param listHostedZonesByVpcRequest
     *        Lists all the private hosted zones that a specified VPC is associated with, regardless of which Amazon Web
     *        Services account created the hosted zones.
     * @return Result of the ListHostedZonesByVPC operation returned by the service.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws InvalidPaginationTokenException
     *         The value that you specified to get the second or subsequent page of results is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.ListHostedZonesByVPC
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHostedZonesByVPC" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListHostedZonesByVpcResponse listHostedZonesByVPC(ListHostedZonesByVpcRequest listHostedZonesByVpcRequest)
            throws InvalidInputException, InvalidPaginationTokenException, AwsServiceException, SdkClientException,
            Route53Exception {

        HttpResponseHandler<Response<ListHostedZonesByVpcResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListHostedZonesByVpcResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listHostedZonesByVpcRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listHostedZonesByVpcRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListHostedZonesByVPC");

            return clientHandler.execute(new ClientExecutionParams<ListHostedZonesByVpcRequest, ListHostedZonesByVpcResponse>()
                    .withOperationName("ListHostedZonesByVPC").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(listHostedZonesByVpcRequest)
                    .withMarshaller(new ListHostedZonesByVpcRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the configurations for DNS query logging that are associated with the current Amazon Web Services account
     * or the configuration that is associated with a specified hosted zone.
     * </p>
     * <p>
     * For more information about DNS query logs, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateQueryLoggingConfig.html"
     * >CreateQueryLoggingConfig</a>. Additional information, including the format of DNS query logs, appears in <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html">Logging DNS Queries</a> in the
     * <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     *
     * @param listQueryLoggingConfigsRequest
     * @return Result of the ListQueryLoggingConfigs operation returned by the service.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws InvalidPaginationTokenException
     *         The value that you specified to get the second or subsequent page of results is invalid.
     * @throws NoSuchHostedZoneException
     *         No hosted zone exists with the ID that you specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.ListQueryLoggingConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListQueryLoggingConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListQueryLoggingConfigsResponse listQueryLoggingConfigs(ListQueryLoggingConfigsRequest listQueryLoggingConfigsRequest)
            throws InvalidInputException, InvalidPaginationTokenException, NoSuchHostedZoneException, AwsServiceException,
            SdkClientException, Route53Exception {

        HttpResponseHandler<Response<ListQueryLoggingConfigsResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListQueryLoggingConfigsResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listQueryLoggingConfigsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listQueryLoggingConfigsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListQueryLoggingConfigs");

            return clientHandler
                    .execute(new ClientExecutionParams<ListQueryLoggingConfigsRequest, ListQueryLoggingConfigsResponse>()
                            .withOperationName("ListQueryLoggingConfigs").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(listQueryLoggingConfigsRequest)
                            .withMarshaller(new ListQueryLoggingConfigsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the resource record sets in a specified hosted zone.
     * </p>
     * <p>
     * <code>ListResourceRecordSets</code> returns up to 300 resource record sets at a time in ASCII order, beginning at
     * a position specified by the <code>name</code> and <code>type</code> elements.
     * </p>
     * <p>
     * <b>Sort order</b>
     * </p>
     * <p>
     * <code>ListResourceRecordSets</code> sorts results first by DNS name with the labels reversed, for example:
     * </p>
     * <p>
     * <code>com.example.www.</code>
     * </p>
     * <p>
     * Note the trailing dot, which can change the sort order when the record name contains characters that appear
     * before <code>.</code> (decimal 46) in the ASCII table. These characters include the following:
     * <code>! " # &#36 % &amp; ' ( ) * + , -</code>
     * </p>
     * <p>
     * When multiple records have the same DNS name, <code>ListResourceRecordSets</code> sorts results by the record
     * type.
     * </p>
     * <p>
     * <b>Specifying where to start listing records</b>
     * </p>
     * <p>
     * You can use the name and type elements to specify the resource record set that the list begins with:
     * </p>
     * <dl>
     * <dt>If you do not specify Name or Type</dt>
     * <dd>
     * <p>
     * The results begin with the first resource record set that the hosted zone contains.
     * </p>
     * </dd>
     * <dt>If you specify Name but not Type</dt>
     * <dd>
     * <p>
     * The results begin with the first resource record set in the list whose name is greater than or equal to
     * <code>Name</code>.
     * </p>
     * </dd>
     * <dt>If you specify Type but not Name</dt>
     * <dd>
     * <p>
     * Amazon Route 53 returns the <code>InvalidInput</code> error.
     * </p>
     * </dd>
     * <dt>If you specify both Name and Type</dt>
     * <dd>
     * <p>
     * The results begin with the first resource record set in the list whose name is greater than or equal to
     * <code>Name</code>, and whose type is greater than or equal to <code>Type</code>.
     * </p>
     * <note>
     * <p>
     * Type is only used to sort between records with the same record Name.
     * </p>
     * </note></dd>
     * </dl>
     * <p>
     * <b>Resource record sets that are PENDING</b>
     * </p>
     * <p>
     * This action returns the most current version of the records. This includes records that are <code>PENDING</code>,
     * and that are not yet available on all Route 53 DNS servers.
     * </p>
     * <p>
     * <b>Changing resource record sets</b>
     * </p>
     * <p>
     * To ensure that you get an accurate listing of the resource record sets for a hosted zone at a point in time, do
     * not submit a <code>ChangeResourceRecordSets</code> request while you're paging through the results of a
     * <code>ListResourceRecordSets</code> request. If you do, some pages may display results without the latest changes
     * while other pages display results with the latest changes.
     * </p>
     * <p>
     * <b>Displaying the next page of results</b>
     * </p>
     * <p>
     * If a <code>ListResourceRecordSets</code> command returns more than one page of results, the value of
     * <code>IsTruncated</code> is <code>true</code>. To display the next page of results, get the values of
     * <code>NextRecordName</code>, <code>NextRecordType</code>, and <code>NextRecordIdentifier</code> (if any) from the
     * response. Then submit another <code>ListResourceRecordSets</code> request, and specify those values for
     * <code>StartRecordName</code>, <code>StartRecordType</code>, and <code>StartRecordIdentifier</code>.
     * </p>
     *
     * @param listResourceRecordSetsRequest
     *        A request for the resource record sets that are associated with a specified hosted zone.
     * @return Result of the ListResourceRecordSets operation returned by the service.
     * @throws NoSuchHostedZoneException
     *         No hosted zone exists with the ID that you specified.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.ListResourceRecordSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListResourceRecordSets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListResourceRecordSetsResponse listResourceRecordSets(ListResourceRecordSetsRequest listResourceRecordSetsRequest)
            throws NoSuchHostedZoneException, InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<ListResourceRecordSetsResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListResourceRecordSetsResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listResourceRecordSetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResourceRecordSetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResourceRecordSets");

            return clientHandler
                    .execute(new ClientExecutionParams<ListResourceRecordSetsRequest, ListResourceRecordSetsResponse>()
                            .withOperationName("ListResourceRecordSets").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(listResourceRecordSetsRequest)
                            .withMarshaller(new ListResourceRecordSetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of the reusable delegation sets that are associated with the current Amazon Web Services
     * account.
     * </p>
     *
     * @param listReusableDelegationSetsRequest
     *        A request to get a list of the reusable delegation sets that are associated with the current Amazon Web
     *        Services account.
     * @return Result of the ListReusableDelegationSets operation returned by the service.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.ListReusableDelegationSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListReusableDelegationSets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListReusableDelegationSetsResponse listReusableDelegationSets(
            ListReusableDelegationSetsRequest listReusableDelegationSetsRequest) throws InvalidInputException,
            AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<ListReusableDelegationSetsResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListReusableDelegationSetsResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReusableDelegationSetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReusableDelegationSetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReusableDelegationSets");

            return clientHandler
                    .execute(new ClientExecutionParams<ListReusableDelegationSetsRequest, ListReusableDelegationSetsResponse>()
                            .withOperationName("ListReusableDelegationSets").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(listReusableDelegationSetsRequest)
                            .withMarshaller(new ListReusableDelegationSetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists tags for one health check or hosted zone.
     * </p>
     * <p>
     * For information about using tags for cost allocation, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation
     * Tags</a> in the <i>Billing and Cost Management User Guide</i>.
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A complex type containing information about a request for a list of the tags that are associated with an
     *        individual resource.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws NoSuchHealthCheckException
     *         No health check exists with the specified ID.
     * @throws NoSuchHostedZoneException
     *         No hosted zone exists with the ID that you specified.
     * @throws PriorRequestNotCompleteException
     *         If Amazon Route 53 can't process a request before the next request arrives, it will reject subsequent
     *         requests for the same hosted zone and return an <code>HTTP 400 error</code> (<code>Bad request</code>).
     *         If Route 53 returns this error repeatedly for the same request, we recommend that you wait, in intervals
     *         of increasing duration, before you try the request again.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InvalidInputException, NoSuchHealthCheckException, NoSuchHostedZoneException,
            PriorRequestNotCompleteException, ThrottlingException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<ListTagsForResourceResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListTagsForResourceResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists tags for up to 10 health checks or hosted zones.
     * </p>
     * <p>
     * For information about using tags for cost allocation, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation
     * Tags</a> in the <i>Billing and Cost Management User Guide</i>.
     * </p>
     *
     * @param listTagsForResourcesRequest
     *        A complex type that contains information about the health checks or hosted zones for which you want to
     *        list tags.
     * @return Result of the ListTagsForResources operation returned by the service.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws NoSuchHealthCheckException
     *         No health check exists with the specified ID.
     * @throws NoSuchHostedZoneException
     *         No hosted zone exists with the ID that you specified.
     * @throws PriorRequestNotCompleteException
     *         If Amazon Route 53 can't process a request before the next request arrives, it will reject subsequent
     *         requests for the same hosted zone and return an <code>HTTP 400 error</code> (<code>Bad request</code>).
     *         If Route 53 returns this error repeatedly for the same request, we recommend that you wait, in intervals
     *         of increasing duration, before you try the request again.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.ListTagsForResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTagsForResources" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTagsForResourcesResponse listTagsForResources(ListTagsForResourcesRequest listTagsForResourcesRequest)
            throws InvalidInputException, NoSuchHealthCheckException, NoSuchHostedZoneException,
            PriorRequestNotCompleteException, ThrottlingException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<ListTagsForResourcesResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListTagsForResourcesResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourcesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResources");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourcesRequest, ListTagsForResourcesResponse>()
                    .withOperationName("ListTagsForResources").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourcesRequest)
                    .withMarshaller(new ListTagsForResourcesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the latest version for every traffic policy that is associated with the current Amazon Web
     * Services account. Policies are listed in the order that they were created in.
     * </p>
     * <p>
     * For information about how of deleting a traffic policy affects the response from <code>ListTrafficPolicies</code>
     * , see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicy.html">DeleteTrafficPolicy
     * </a>.
     * </p>
     *
     * @param listTrafficPoliciesRequest
     *        A complex type that contains the information about the request to list the traffic policies that are
     *        associated with the current Amazon Web Services account.
     * @return Result of the ListTrafficPolicies operation returned by the service.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.ListTrafficPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTrafficPoliciesResponse listTrafficPolicies(ListTrafficPoliciesRequest listTrafficPoliciesRequest)
            throws InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<ListTrafficPoliciesResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListTrafficPoliciesResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTrafficPoliciesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTrafficPoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTrafficPolicies");

            return clientHandler.execute(new ClientExecutionParams<ListTrafficPoliciesRequest, ListTrafficPoliciesResponse>()
                    .withOperationName("ListTrafficPolicies").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(listTrafficPoliciesRequest)
                    .withMarshaller(new ListTrafficPoliciesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the traffic policy instances that you created by using the current Amazon Web Services
     * account.
     * </p>
     * <note>
     * <p>
     * After you submit an <code>UpdateTrafficPolicyInstance</code> request, there's a brief delay while Amazon Route 53
     * creates the resource record sets that are specified in the traffic policy definition. For more information, see
     * the <code>State</code> response element.
     * </p>
     * </note>
     * <p>
     * Route 53 returns a maximum of 100 items in each response. If you have a lot of traffic policy instances, you can
     * use the <code>MaxItems</code> parameter to list them in groups of up to 100.
     * </p>
     *
     * @param listTrafficPolicyInstancesRequest
     *        A request to get information about the traffic policy instances that you created by using the current
     *        Amazon Web Services account.
     * @return Result of the ListTrafficPolicyInstances operation returned by the service.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws NoSuchTrafficPolicyInstanceException
     *         No traffic policy instance exists with the specified ID.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.ListTrafficPolicyInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicyInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTrafficPolicyInstancesResponse listTrafficPolicyInstances(
            ListTrafficPolicyInstancesRequest listTrafficPolicyInstancesRequest) throws InvalidInputException,
            NoSuchTrafficPolicyInstanceException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<ListTrafficPolicyInstancesResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListTrafficPolicyInstancesResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTrafficPolicyInstancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTrafficPolicyInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTrafficPolicyInstances");

            return clientHandler
                    .execute(new ClientExecutionParams<ListTrafficPolicyInstancesRequest, ListTrafficPolicyInstancesResponse>()
                            .withOperationName("ListTrafficPolicyInstances").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(listTrafficPolicyInstancesRequest)
                            .withMarshaller(new ListTrafficPolicyInstancesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the traffic policy instances that you created in a specified hosted zone.
     * </p>
     * <note>
     * <p>
     * After you submit a <code>CreateTrafficPolicyInstance</code> or an <code>UpdateTrafficPolicyInstance</code>
     * request, there's a brief delay while Amazon Route 53 creates the resource record sets that are specified in the
     * traffic policy definition. For more information, see the <code>State</code> response element.
     * </p>
     * </note>
     * <p>
     * Route 53 returns a maximum of 100 items in each response. If you have a lot of traffic policy instances, you can
     * use the <code>MaxItems</code> parameter to list them in groups of up to 100.
     * </p>
     *
     * @param listTrafficPolicyInstancesByHostedZoneRequest
     *        A request for the traffic policy instances that you created in a specified hosted zone.
     * @return Result of the ListTrafficPolicyInstancesByHostedZone operation returned by the service.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws NoSuchTrafficPolicyInstanceException
     *         No traffic policy instance exists with the specified ID.
     * @throws NoSuchHostedZoneException
     *         No hosted zone exists with the ID that you specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.ListTrafficPolicyInstancesByHostedZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicyInstancesByHostedZone"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTrafficPolicyInstancesByHostedZoneResponse listTrafficPolicyInstancesByHostedZone(
            ListTrafficPolicyInstancesByHostedZoneRequest listTrafficPolicyInstancesByHostedZoneRequest)
            throws InvalidInputException, NoSuchTrafficPolicyInstanceException, NoSuchHostedZoneException, AwsServiceException,
            SdkClientException, Route53Exception {

        HttpResponseHandler<Response<ListTrafficPolicyInstancesByHostedZoneResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListTrafficPolicyInstancesByHostedZoneResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTrafficPolicyInstancesByHostedZoneRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listTrafficPolicyInstancesByHostedZoneRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTrafficPolicyInstancesByHostedZone");

            return clientHandler
                    .execute(new ClientExecutionParams<ListTrafficPolicyInstancesByHostedZoneRequest, ListTrafficPolicyInstancesByHostedZoneResponse>()
                            .withOperationName("ListTrafficPolicyInstancesByHostedZone").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(listTrafficPolicyInstancesByHostedZoneRequest)
                            .withMarshaller(new ListTrafficPolicyInstancesByHostedZoneRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the traffic policy instances that you created by using a specify traffic policy version.
     * </p>
     * <note>
     * <p>
     * After you submit a <code>CreateTrafficPolicyInstance</code> or an <code>UpdateTrafficPolicyInstance</code>
     * request, there's a brief delay while Amazon Route 53 creates the resource record sets that are specified in the
     * traffic policy definition. For more information, see the <code>State</code> response element.
     * </p>
     * </note>
     * <p>
     * Route 53 returns a maximum of 100 items in each response. If you have a lot of traffic policy instances, you can
     * use the <code>MaxItems</code> parameter to list them in groups of up to 100.
     * </p>
     *
     * @param listTrafficPolicyInstancesByPolicyRequest
     *        A complex type that contains the information about the request to list your traffic policy instances.
     * @return Result of the ListTrafficPolicyInstancesByPolicy operation returned by the service.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws NoSuchTrafficPolicyInstanceException
     *         No traffic policy instance exists with the specified ID.
     * @throws NoSuchTrafficPolicyException
     *         No traffic policy exists with the specified ID.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.ListTrafficPolicyInstancesByPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicyInstancesByPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTrafficPolicyInstancesByPolicyResponse listTrafficPolicyInstancesByPolicy(
            ListTrafficPolicyInstancesByPolicyRequest listTrafficPolicyInstancesByPolicyRequest) throws InvalidInputException,
            NoSuchTrafficPolicyInstanceException, NoSuchTrafficPolicyException, AwsServiceException, SdkClientException,
            Route53Exception {

        HttpResponseHandler<Response<ListTrafficPolicyInstancesByPolicyResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListTrafficPolicyInstancesByPolicyResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTrafficPolicyInstancesByPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listTrafficPolicyInstancesByPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTrafficPolicyInstancesByPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<ListTrafficPolicyInstancesByPolicyRequest, ListTrafficPolicyInstancesByPolicyResponse>()
                            .withOperationName("ListTrafficPolicyInstancesByPolicy").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(listTrafficPolicyInstancesByPolicyRequest)
                            .withMarshaller(new ListTrafficPolicyInstancesByPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about all of the versions for a specified traffic policy.
     * </p>
     * <p>
     * Traffic policy versions are listed in numerical order by <code>VersionNumber</code>.
     * </p>
     *
     * @param listTrafficPolicyVersionsRequest
     *        A complex type that contains the information about the request to list your traffic policies.
     * @return Result of the ListTrafficPolicyVersions operation returned by the service.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws NoSuchTrafficPolicyException
     *         No traffic policy exists with the specified ID.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.ListTrafficPolicyVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicyVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTrafficPolicyVersionsResponse listTrafficPolicyVersions(
            ListTrafficPolicyVersionsRequest listTrafficPolicyVersionsRequest) throws InvalidInputException,
            NoSuchTrafficPolicyException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<ListTrafficPolicyVersionsResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListTrafficPolicyVersionsResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTrafficPolicyVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTrafficPolicyVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTrafficPolicyVersions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListTrafficPolicyVersionsRequest, ListTrafficPolicyVersionsResponse>()
                            .withOperationName("ListTrafficPolicyVersions").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(listTrafficPolicyVersionsRequest)
                            .withMarshaller(new ListTrafficPolicyVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of the VPCs that were created by other accounts and that can be associated with a specified hosted
     * zone because you've submitted one or more <code>CreateVPCAssociationAuthorization</code> requests.
     * </p>
     * <p>
     * The response includes a <code>VPCs</code> element with a <code>VPC</code> child element for each VPC that can be
     * associated with the hosted zone.
     * </p>
     *
     * @param listVpcAssociationAuthorizationsRequest
     *        A complex type that contains information about that can be associated with your hosted zone.
     * @return Result of the ListVPCAssociationAuthorizations operation returned by the service.
     * @throws NoSuchHostedZoneException
     *         No hosted zone exists with the ID that you specified.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws InvalidPaginationTokenException
     *         The value that you specified to get the second or subsequent page of results is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.ListVPCAssociationAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListVPCAssociationAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListVpcAssociationAuthorizationsResponse listVPCAssociationAuthorizations(
            ListVpcAssociationAuthorizationsRequest listVpcAssociationAuthorizationsRequest) throws NoSuchHostedZoneException,
            InvalidInputException, InvalidPaginationTokenException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<ListVpcAssociationAuthorizationsResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListVpcAssociationAuthorizationsResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listVpcAssociationAuthorizationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listVpcAssociationAuthorizationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVPCAssociationAuthorizations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListVpcAssociationAuthorizationsRequest, ListVpcAssociationAuthorizationsResponse>()
                            .withOperationName("ListVPCAssociationAuthorizations").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(listVpcAssociationAuthorizationsRequest)
                            .withMarshaller(new ListVpcAssociationAuthorizationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the value that Amazon Route 53 returns in response to a DNS request for a specified record name and type.
     * You can optionally specify the IP address of a DNS resolver, an EDNS0 client subnet IP address, and a subnet
     * mask.
     * </p>
     * <p>
     * This call only supports querying public hosted zones.
     * </p>
     * <note>
     * <p>
     * The <code>TestDnsAnswer </code> returns information similar to what you would expect from the answer section of
     * the <code>dig</code> command. Therefore, if you query for the name servers of a subdomain that point to the
     * parent name servers, those will not be returned.
     * </p>
     * </note>
     *
     * @param testDnsAnswerRequest
     *        Gets the value that Amazon Route 53 returns in response to a DNS request for a specified record name and
     *        type. You can optionally specify the IP address of a DNS resolver, an EDNS0 client subnet IP address, and
     *        a subnet mask.
     * @return Result of the TestDNSAnswer operation returned by the service.
     * @throws NoSuchHostedZoneException
     *         No hosted zone exists with the ID that you specified.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.TestDNSAnswer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/TestDNSAnswer" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TestDnsAnswerResponse testDNSAnswer(TestDnsAnswerRequest testDnsAnswerRequest) throws NoSuchHostedZoneException,
            InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<TestDnsAnswerResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                TestDnsAnswerResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(testDnsAnswerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, testDnsAnswerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TestDNSAnswer");

            return clientHandler.execute(new ClientExecutionParams<TestDnsAnswerRequest, TestDnsAnswerResponse>()
                    .withOperationName("TestDNSAnswer").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(testDnsAnswerRequest)
                    .withMarshaller(new TestDnsAnswerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing health check. Note that some values can't be updated.
     * </p>
     * <p>
     * For more information about updating health checks, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/health-checks-creating-deleting.html">Creating,
     * Updating, and Deleting Health Checks</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     *
     * @param updateHealthCheckRequest
     *        A complex type that contains information about a request to update a health check.
     * @return Result of the UpdateHealthCheck operation returned by the service.
     * @throws NoSuchHealthCheckException
     *         No health check exists with the specified ID.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws HealthCheckVersionMismatchException
     *         The value of <code>HealthCheckVersion</code> in the request doesn't match the value of
     *         <code>HealthCheckVersion</code> in the health check.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.UpdateHealthCheck
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/UpdateHealthCheck" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateHealthCheckResponse updateHealthCheck(UpdateHealthCheckRequest updateHealthCheckRequest)
            throws NoSuchHealthCheckException, InvalidInputException, HealthCheckVersionMismatchException, AwsServiceException,
            SdkClientException, Route53Exception {

        HttpResponseHandler<Response<UpdateHealthCheckResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                UpdateHealthCheckResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateHealthCheckRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateHealthCheckRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateHealthCheck");

            return clientHandler.execute(new ClientExecutionParams<UpdateHealthCheckRequest, UpdateHealthCheckResponse>()
                    .withOperationName("UpdateHealthCheck").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(updateHealthCheckRequest)
                    .withMarshaller(new UpdateHealthCheckRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the comment for a specified hosted zone.
     * </p>
     *
     * @param updateHostedZoneCommentRequest
     *        A request to update the comment for a hosted zone.
     * @return Result of the UpdateHostedZoneComment operation returned by the service.
     * @throws NoSuchHostedZoneException
     *         No hosted zone exists with the ID that you specified.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws PriorRequestNotCompleteException
     *         If Amazon Route 53 can't process a request before the next request arrives, it will reject subsequent
     *         requests for the same hosted zone and return an <code>HTTP 400 error</code> (<code>Bad request</code>).
     *         If Route 53 returns this error repeatedly for the same request, we recommend that you wait, in intervals
     *         of increasing duration, before you try the request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.UpdateHostedZoneComment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/UpdateHostedZoneComment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateHostedZoneCommentResponse updateHostedZoneComment(UpdateHostedZoneCommentRequest updateHostedZoneCommentRequest)
            throws NoSuchHostedZoneException, InvalidInputException, PriorRequestNotCompleteException, AwsServiceException,
            SdkClientException, Route53Exception {

        HttpResponseHandler<Response<UpdateHostedZoneCommentResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(UpdateHostedZoneCommentResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateHostedZoneCommentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateHostedZoneCommentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateHostedZoneComment");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateHostedZoneCommentRequest, UpdateHostedZoneCommentResponse>()
                            .withOperationName("UpdateHostedZoneComment").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(updateHostedZoneCommentRequest)
                            .withMarshaller(new UpdateHostedZoneCommentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the comment for a specified traffic policy version.
     * </p>
     *
     * @param updateTrafficPolicyCommentRequest
     *        A complex type that contains information about the traffic policy that you want to update the comment for.
     * @return Result of the UpdateTrafficPolicyComment operation returned by the service.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws NoSuchTrafficPolicyException
     *         No traffic policy exists with the specified ID.
     * @throws ConcurrentModificationException
     *         Another user submitted a request to create, update, or delete the object at the same time that you did.
     *         Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.UpdateTrafficPolicyComment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/UpdateTrafficPolicyComment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateTrafficPolicyCommentResponse updateTrafficPolicyComment(
            UpdateTrafficPolicyCommentRequest updateTrafficPolicyCommentRequest) throws InvalidInputException,
            NoSuchTrafficPolicyException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            Route53Exception {

        HttpResponseHandler<Response<UpdateTrafficPolicyCommentResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(UpdateTrafficPolicyCommentResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateTrafficPolicyCommentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateTrafficPolicyCommentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTrafficPolicyComment");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateTrafficPolicyCommentRequest, UpdateTrafficPolicyCommentResponse>()
                            .withOperationName("UpdateTrafficPolicyComment").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(updateTrafficPolicyCommentRequest)
                            .withMarshaller(new UpdateTrafficPolicyCommentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <note>
     * <p>
     * After you submit a <code>UpdateTrafficPolicyInstance</code> request, there's a brief delay while Route 53 creates
     * the resource record sets that are specified in the traffic policy definition. Use
     * <code>GetTrafficPolicyInstance</code> with the <code>id</code> of updated traffic policy instance confirm that
     * the <code>UpdateTrafficPolicyInstance</code> request completed successfully. For more information, see the
     * <code>State</code> response element.
     * </p>
     * </note>
     * <p>
     * Updates the resource record sets in a specified hosted zone that were created based on the settings in a
     * specified traffic policy version.
     * </p>
     * <p>
     * When you update a traffic policy instance, Amazon Route 53 continues to respond to DNS queries for the root
     * resource record set name (such as example.com) while it replaces one group of resource record sets with another.
     * Route 53 performs the following operations:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Route 53 creates a new group of resource record sets based on the specified traffic policy. This is true
     * regardless of how significant the differences are between the existing resource record sets and the new resource
     * record sets.
     * </p>
     * </li>
     * <li>
     * <p>
     * When all of the new resource record sets have been created, Route 53 starts to respond to DNS queries for the
     * root resource record set name (such as example.com) by using the new resource record sets.
     * </p>
     * </li>
     * <li>
     * <p>
     * Route 53 deletes the old group of resource record sets that are associated with the root resource record set
     * name.
     * </p>
     * </li>
     * </ol>
     *
     * @param updateTrafficPolicyInstanceRequest
     *        A complex type that contains information about the resource record sets that you want to update based on a
     *        specified traffic policy instance.
     * @return Result of the UpdateTrafficPolicyInstance operation returned by the service.
     * @throws InvalidInputException
     *         The input is not valid.
     * @throws NoSuchTrafficPolicyException
     *         No traffic policy exists with the specified ID.
     * @throws NoSuchTrafficPolicyInstanceException
     *         No traffic policy instance exists with the specified ID.
     * @throws PriorRequestNotCompleteException
     *         If Amazon Route 53 can't process a request before the next request arrives, it will reject subsequent
     *         requests for the same hosted zone and return an <code>HTTP 400 error</code> (<code>Bad request</code>).
     *         If Route 53 returns this error repeatedly for the same request, we recommend that you wait, in intervals
     *         of increasing duration, before you try the request again.
     * @throws ConflictingTypesException
     *         You tried to update a traffic policy instance by using a traffic policy version that has a different DNS
     *         type than the current type for the instance. You specified the type in the JSON document in the
     *         <code>CreateTrafficPolicy</code> or <code>CreateTrafficPolicyVersion</code>request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53Client.UpdateTrafficPolicyInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/UpdateTrafficPolicyInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateTrafficPolicyInstanceResponse updateTrafficPolicyInstance(
            UpdateTrafficPolicyInstanceRequest updateTrafficPolicyInstanceRequest) throws InvalidInputException,
            NoSuchTrafficPolicyException, NoSuchTrafficPolicyInstanceException, PriorRequestNotCompleteException,
            ConflictingTypesException, AwsServiceException, SdkClientException, Route53Exception {

        HttpResponseHandler<Response<UpdateTrafficPolicyInstanceResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(UpdateTrafficPolicyInstanceResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateTrafficPolicyInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateTrafficPolicyInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTrafficPolicyInstance");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateTrafficPolicyInstanceRequest, UpdateTrafficPolicyInstanceResponse>()
                            .withOperationName("UpdateTrafficPolicyInstance").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(updateTrafficPolicyInstanceRequest)
                            .withMarshaller(new UpdateTrafficPolicyInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Create an instance of {@link Route53Waiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link Route53Waiter}
     */
    @Override
    public Route53Waiter waiter() {
        return Route53Waiter.builder().client(this).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        Route53ServiceClientConfigurationBuilder serviceConfigBuilder = new Route53ServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private AwsXmlProtocolFactory init() {
        return AwsXmlProtocolFactory
                .builder()
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConcurrentModification")
                                .exceptionBuilderSupplier(ConcurrentModificationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidKeySigningKeyName")
                                .exceptionBuilderSupplier(InvalidKeySigningKeyNameException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTrafficPolicyVersionsForCurrentPolicy")
                                .exceptionBuilderSupplier(TooManyTrafficPolicyVersionsForCurrentPolicyException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchCidrLocationException")
                                .exceptionBuilderSupplier(NoSuchCidrLocationException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IncompatibleVersion")
                                .exceptionBuilderSupplier(IncompatibleVersionException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("VPCAssociationAuthorizationNotFound")
                                .exceptionBuilderSupplier(VpcAssociationAuthorizationNotFoundException::builder)
                                .httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchTrafficPolicy")
                                .exceptionBuilderSupplier(NoSuchTrafficPolicyException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTrafficPolicies")
                                .exceptionBuilderSupplier(TooManyTrafficPoliciesException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DelegationSetAlreadyCreated")
                                .exceptionBuilderSupplier(DelegationSetAlreadyCreatedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchHostedZone")
                                .exceptionBuilderSupplier(NoSuchHostedZoneException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("QueryLoggingConfigAlreadyExists")
                                .exceptionBuilderSupplier(QueryLoggingConfigAlreadyExistsException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("HostedZoneNotPrivate")
                                .exceptionBuilderSupplier(HostedZoneNotPrivateException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchGeoLocation")
                                .exceptionBuilderSupplier(NoSuchGeoLocationException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KeySigningKeyInUse")
                                .exceptionBuilderSupplier(KeySigningKeyInUseException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KeySigningKeyAlreadyExists")
                                .exceptionBuilderSupplier(KeySigningKeyAlreadyExistsException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KeySigningKeyWithActiveStatusNotFound")
                                .exceptionBuilderSupplier(KeySigningKeyWithActiveStatusNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CidrCollectionInUseException")
                                .exceptionBuilderSupplier(CidrCollectionInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientCloudWatchLogsResourcePolicy")
                                .exceptionBuilderSupplier(InsufficientCloudWatchLogsResourcePolicyException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidKMSArn")
                                .exceptionBuilderSupplier(InvalidKmsArnException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("HealthCheckVersionMismatch")
                                .exceptionBuilderSupplier(HealthCheckVersionMismatchException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PublicZoneVPCAssociation")
                                .exceptionBuilderSupplier(PublicZoneVpcAssociationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("HealthCheckAlreadyExists")
                                .exceptionBuilderSupplier(HealthCheckAlreadyExistsException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchDelegationSet")
                                .exceptionBuilderSupplier(NoSuchDelegationSetException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotAuthorizedException")
                                .exceptionBuilderSupplier(NotAuthorizedException::builder).httpStatusCode(401).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("VPCAssociationNotFound")
                                .exceptionBuilderSupplier(VpcAssociationNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyVPCAssociationAuthorizations")
                                .exceptionBuilderSupplier(TooManyVpcAssociationAuthorizationsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidVPCId")
                                .exceptionBuilderSupplier(InvalidVpcIdException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CidrBlockInUseException")
                                .exceptionBuilderSupplier(CidrBlockInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTrafficPolicyInstances")
                                .exceptionBuilderSupplier(TooManyTrafficPolicyInstancesException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CidrCollectionVersionMismatchException")
                                .exceptionBuilderSupplier(CidrCollectionVersionMismatchException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPaginationToken")
                                .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DelegationSetNotAvailable")
                                .exceptionBuilderSupplier(DelegationSetNotAvailableException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchTrafficPolicyInstance")
                                .exceptionBuilderSupplier(NoSuchTrafficPolicyInstanceException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("HostedZoneNotEmpty")
                                .exceptionBuilderSupplier(HostedZoneNotEmptyException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDomainName")
                                .exceptionBuilderSupplier(InvalidDomainNameException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyHealthChecks")
                                .exceptionBuilderSupplier(TooManyHealthChecksException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidChangeBatch")
                                .exceptionBuilderSupplier(InvalidChangeBatchException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("HostedZoneAlreadyExists")
                                .exceptionBuilderSupplier(HostedZoneAlreadyExistsException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTrafficPolicyDocument")
                                .exceptionBuilderSupplier(InvalidTrafficPolicyDocumentException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TrafficPolicyAlreadyExists")
                                .exceptionBuilderSupplier(TrafficPolicyAlreadyExistsException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DelegationSetAlreadyReusable")
                                .exceptionBuilderSupplier(DelegationSetAlreadyReusableException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TrafficPolicyInUse")
                                .exceptionBuilderSupplier(TrafficPolicyInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyHostedZones")
                                .exceptionBuilderSupplier(TooManyHostedZonesException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("HostedZonePartiallyDelegated")
                                .exceptionBuilderSupplier(HostedZonePartiallyDelegatedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TrafficPolicyInstanceAlreadyExists")
                                .exceptionBuilderSupplier(TrafficPolicyInstanceAlreadyExistsException::builder)
                                .httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchChange")
                                .exceptionBuilderSupplier(NoSuchChangeException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KeySigningKeyInParentDSRecord")
                                .exceptionBuilderSupplier(KeySigningKeyInParentDsRecordException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidKeySigningKeyStatus")
                                .exceptionBuilderSupplier(InvalidKeySigningKeyStatusException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictingTypes")
                                .exceptionBuilderSupplier(ConflictingTypesException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DelegationSetNotReusable")
                                .exceptionBuilderSupplier(DelegationSetNotReusableException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PriorRequestNotComplete")
                                .exceptionBuilderSupplier(PriorRequestNotCompleteException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("HostedZoneNotFound")
                                .exceptionBuilderSupplier(HostedZoneNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidArgument")
                                .exceptionBuilderSupplier(InvalidArgumentException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DNSSECNotFound")
                                .exceptionBuilderSupplier(DnssecNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchKeySigningKey")
                                .exceptionBuilderSupplier(NoSuchKeySigningKeyException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidInput")
                                .exceptionBuilderSupplier(InvalidInputException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictingDomainExists")
                                .exceptionBuilderSupplier(ConflictingDomainExistsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CidrCollectionAlreadyExistsException")
                                .exceptionBuilderSupplier(CidrCollectionAlreadyExistsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSigningStatus")
                                .exceptionBuilderSupplier(InvalidSigningStatusException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DelegationSetInUse")
                                .exceptionBuilderSupplier(DelegationSetInUseException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchQueryLoggingConfig")
                                .exceptionBuilderSupplier(NoSuchQueryLoggingConfigException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchHealthCheck")
                                .exceptionBuilderSupplier(NoSuchHealthCheckException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LastVPCAssociation")
                                .exceptionBuilderSupplier(LastVpcAssociationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchCloudWatchLogsLogGroup")
                                .exceptionBuilderSupplier(NoSuchCloudWatchLogsLogGroupException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyKeySigningKeys")
                                .exceptionBuilderSupplier(TooManyKeySigningKeysException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitsExceeded")
                                .exceptionBuilderSupplier(LimitsExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchCidrCollectionException")
                                .exceptionBuilderSupplier(NoSuchCidrCollectionException::builder).httpStatusCode(404).build())
                .clientConfiguration(clientConfiguration).defaultServiceExceptionSupplier(Route53Exception::builder).build();
    }

    @Override
    public final Route53ServiceClientConfiguration serviceClientConfiguration() {
        return new Route53ServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
