/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the features configuration for a hosted zone, including the status of various features and any associated
 * failure reasons.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HostedZoneFeatures implements SdkPojo, Serializable,
        ToCopyableBuilder<HostedZoneFeatures.Builder, HostedZoneFeatures> {
    private static final SdkField<String> ACCELERATED_RECOVERY_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AcceleratedRecoveryStatus")
            .getter(getter(HostedZoneFeatures::acceleratedRecoveryStatusAsString))
            .setter(setter(Builder::acceleratedRecoveryStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratedRecoveryStatus")
                    .unmarshallLocationName("AcceleratedRecoveryStatus").build()).build();

    private static final SdkField<HostedZoneFailureReasons> FAILURE_REASONS_FIELD = SdkField
            .<HostedZoneFailureReasons> builder(MarshallingType.SDK_POJO)
            .memberName("FailureReasons")
            .getter(getter(HostedZoneFeatures::failureReasons))
            .setter(setter(Builder::failureReasons))
            .constructor(HostedZoneFailureReasons::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReasons")
                    .unmarshallLocationName("FailureReasons").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ACCELERATED_RECOVERY_STATUS_FIELD, FAILURE_REASONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String acceleratedRecoveryStatus;

    private final HostedZoneFailureReasons failureReasons;

    private HostedZoneFeatures(BuilderImpl builder) {
        this.acceleratedRecoveryStatus = builder.acceleratedRecoveryStatus;
        this.failureReasons = builder.failureReasons;
    }

    /**
     * <p>
     * The current status of accelerated recovery for the hosted zone.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #acceleratedRecoveryStatus} will return {@link AcceleratedRecoveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #acceleratedRecoveryStatusAsString}.
     * </p>
     * 
     * @return The current status of accelerated recovery for the hosted zone.
     * @see AcceleratedRecoveryStatus
     */
    public final AcceleratedRecoveryStatus acceleratedRecoveryStatus() {
        return AcceleratedRecoveryStatus.fromValue(acceleratedRecoveryStatus);
    }

    /**
     * <p>
     * The current status of accelerated recovery for the hosted zone.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #acceleratedRecoveryStatus} will return {@link AcceleratedRecoveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #acceleratedRecoveryStatusAsString}.
     * </p>
     * 
     * @return The current status of accelerated recovery for the hosted zone.
     * @see AcceleratedRecoveryStatus
     */
    public final String acceleratedRecoveryStatusAsString() {
        return acceleratedRecoveryStatus;
    }

    /**
     * <p>
     * Information about any failures that occurred when attempting to enable or configure features for the hosted zone.
     * </p>
     * 
     * @return Information about any failures that occurred when attempting to enable or configure features for the
     *         hosted zone.
     */
    public final HostedZoneFailureReasons failureReasons() {
        return failureReasons;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(acceleratedRecoveryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReasons());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostedZoneFeatures)) {
            return false;
        }
        HostedZoneFeatures other = (HostedZoneFeatures) obj;
        return Objects.equals(acceleratedRecoveryStatusAsString(), other.acceleratedRecoveryStatusAsString())
                && Objects.equals(failureReasons(), other.failureReasons());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HostedZoneFeatures").add("AcceleratedRecoveryStatus", acceleratedRecoveryStatusAsString())
                .add("FailureReasons", failureReasons()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceleratedRecoveryStatus":
            return Optional.ofNullable(clazz.cast(acceleratedRecoveryStatusAsString()));
        case "FailureReasons":
            return Optional.ofNullable(clazz.cast(failureReasons()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AcceleratedRecoveryStatus", ACCELERATED_RECOVERY_STATUS_FIELD);
        map.put("FailureReasons", FAILURE_REASONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HostedZoneFeatures, T> g) {
        return obj -> g.apply((HostedZoneFeatures) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HostedZoneFeatures> {
        /**
         * <p>
         * The current status of accelerated recovery for the hosted zone.
         * </p>
         * 
         * @param acceleratedRecoveryStatus
         *        The current status of accelerated recovery for the hosted zone.
         * @see AcceleratedRecoveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AcceleratedRecoveryStatus
         */
        Builder acceleratedRecoveryStatus(String acceleratedRecoveryStatus);

        /**
         * <p>
         * The current status of accelerated recovery for the hosted zone.
         * </p>
         * 
         * @param acceleratedRecoveryStatus
         *        The current status of accelerated recovery for the hosted zone.
         * @see AcceleratedRecoveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AcceleratedRecoveryStatus
         */
        Builder acceleratedRecoveryStatus(AcceleratedRecoveryStatus acceleratedRecoveryStatus);

        /**
         * <p>
         * Information about any failures that occurred when attempting to enable or configure features for the hosted
         * zone.
         * </p>
         * 
         * @param failureReasons
         *        Information about any failures that occurred when attempting to enable or configure features for the
         *        hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasons(HostedZoneFailureReasons failureReasons);

        /**
         * <p>
         * Information about any failures that occurred when attempting to enable or configure features for the hosted
         * zone.
         * </p>
         * This is a convenience method that creates an instance of the {@link HostedZoneFailureReasons.Builder}
         * avoiding the need to create one manually via {@link HostedZoneFailureReasons#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HostedZoneFailureReasons.Builder#build()} is called immediately
         * and its result is passed to {@link #failureReasons(HostedZoneFailureReasons)}.
         * 
         * @param failureReasons
         *        a consumer that will call methods on {@link HostedZoneFailureReasons.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failureReasons(HostedZoneFailureReasons)
         */
        default Builder failureReasons(Consumer<HostedZoneFailureReasons.Builder> failureReasons) {
            return failureReasons(HostedZoneFailureReasons.builder().applyMutation(failureReasons).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String acceleratedRecoveryStatus;

        private HostedZoneFailureReasons failureReasons;

        private BuilderImpl() {
        }

        private BuilderImpl(HostedZoneFeatures model) {
            acceleratedRecoveryStatus(model.acceleratedRecoveryStatus);
            failureReasons(model.failureReasons);
        }

        public final String getAcceleratedRecoveryStatus() {
            return acceleratedRecoveryStatus;
        }

        public final void setAcceleratedRecoveryStatus(String acceleratedRecoveryStatus) {
            this.acceleratedRecoveryStatus = acceleratedRecoveryStatus;
        }

        @Override
        public final Builder acceleratedRecoveryStatus(String acceleratedRecoveryStatus) {
            this.acceleratedRecoveryStatus = acceleratedRecoveryStatus;
            return this;
        }

        @Override
        public final Builder acceleratedRecoveryStatus(AcceleratedRecoveryStatus acceleratedRecoveryStatus) {
            this.acceleratedRecoveryStatus(acceleratedRecoveryStatus == null ? null : acceleratedRecoveryStatus.toString());
            return this;
        }

        public final HostedZoneFailureReasons.Builder getFailureReasons() {
            return failureReasons != null ? failureReasons.toBuilder() : null;
        }

        public final void setFailureReasons(HostedZoneFailureReasons.BuilderImpl failureReasons) {
            this.failureReasons = failureReasons != null ? failureReasons.build() : null;
        }

        @Override
        public final Builder failureReasons(HostedZoneFailureReasons failureReasons) {
            this.failureReasons = failureReasons;
            return this;
        }

        @Override
        public HostedZoneFeatures build() {
            return new HostedZoneFeatures(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
