/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type containing the response information for the hosted zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateHostedZoneResponse extends Route53Response implements
        ToCopyableBuilder<CreateHostedZoneResponse.Builder, CreateHostedZoneResponse> {
    private static final SdkField<HostedZone> HOSTED_ZONE_FIELD = SdkField
            .<HostedZone> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateHostedZoneResponse::hostedZone))
            .setter(setter(Builder::hostedZone))
            .constructor(HostedZone::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZone")
                    .unmarshallLocationName("HostedZone").build()).build();

    private static final SdkField<ChangeInfo> CHANGE_INFO_FIELD = SdkField
            .<ChangeInfo> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateHostedZoneResponse::changeInfo))
            .setter(setter(Builder::changeInfo))
            .constructor(ChangeInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeInfo")
                    .unmarshallLocationName("ChangeInfo").build()).build();

    private static final SdkField<DelegationSet> DELEGATION_SET_FIELD = SdkField
            .<DelegationSet> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateHostedZoneResponse::delegationSet))
            .setter(setter(Builder::delegationSet))
            .constructor(DelegationSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DelegationSet")
                    .unmarshallLocationName("DelegationSet").build()).build();

    private static final SdkField<VPC> VPC_FIELD = SdkField
            .<VPC> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateHostedZoneResponse::vpc))
            .setter(setter(Builder::vpc))
            .constructor(VPC::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPC").unmarshallLocationName("VPC")
                    .build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateHostedZoneResponse::location))
            .setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Location")
                    .unmarshallLocationName("Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONE_FIELD,
            CHANGE_INFO_FIELD, DELEGATION_SET_FIELD, VPC_FIELD, LOCATION_FIELD));

    private final HostedZone hostedZone;

    private final ChangeInfo changeInfo;

    private final DelegationSet delegationSet;

    private final VPC vpc;

    private final String location;

    private CreateHostedZoneResponse(BuilderImpl builder) {
        super(builder);
        this.hostedZone = builder.hostedZone;
        this.changeInfo = builder.changeInfo;
        this.delegationSet = builder.delegationSet;
        this.vpc = builder.vpc;
        this.location = builder.location;
    }

    /**
     * <p>
     * A complex type that contains general information about the hosted zone.
     * </p>
     * 
     * @return A complex type that contains general information about the hosted zone.
     */
    public HostedZone hostedZone() {
        return hostedZone;
    }

    /**
     * <p>
     * A complex type that contains information about the <code>CreateHostedZone</code> request.
     * </p>
     * 
     * @return A complex type that contains information about the <code>CreateHostedZone</code> request.
     */
    public ChangeInfo changeInfo() {
        return changeInfo;
    }

    /**
     * <p>
     * A complex type that describes the name servers for this hosted zone.
     * </p>
     * 
     * @return A complex type that describes the name servers for this hosted zone.
     */
    public DelegationSet delegationSet() {
        return delegationSet;
    }

    /**
     * <p>
     * A complex type that contains information about an Amazon VPC that you associated with this hosted zone.
     * </p>
     * 
     * @return A complex type that contains information about an Amazon VPC that you associated with this hosted zone.
     */
    public VPC vpc() {
        return vpc;
    }

    /**
     * <p>
     * The unique URL representing the new hosted zone.
     * </p>
     * 
     * @return The unique URL representing the new hosted zone.
     */
    public String location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostedZone());
        hashCode = 31 * hashCode + Objects.hashCode(changeInfo());
        hashCode = 31 * hashCode + Objects.hashCode(delegationSet());
        hashCode = 31 * hashCode + Objects.hashCode(vpc());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHostedZoneResponse)) {
            return false;
        }
        CreateHostedZoneResponse other = (CreateHostedZoneResponse) obj;
        return Objects.equals(hostedZone(), other.hostedZone()) && Objects.equals(changeInfo(), other.changeInfo())
                && Objects.equals(delegationSet(), other.delegationSet()) && Objects.equals(vpc(), other.vpc())
                && Objects.equals(location(), other.location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateHostedZoneResponse").add("HostedZone", hostedZone()).add("ChangeInfo", changeInfo())
                .add("DelegationSet", delegationSet()).add("VPC", vpc()).add("Location", location()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostedZone":
            return Optional.ofNullable(clazz.cast(hostedZone()));
        case "ChangeInfo":
            return Optional.ofNullable(clazz.cast(changeInfo()));
        case "DelegationSet":
            return Optional.ofNullable(clazz.cast(delegationSet()));
        case "VPC":
            return Optional.ofNullable(clazz.cast(vpc()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateHostedZoneResponse, T> g) {
        return obj -> g.apply((CreateHostedZoneResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateHostedZoneResponse> {
        /**
         * <p>
         * A complex type that contains general information about the hosted zone.
         * </p>
         * 
         * @param hostedZone
         *        A complex type that contains general information about the hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZone(HostedZone hostedZone);

        /**
         * <p>
         * A complex type that contains general information about the hosted zone.
         * </p>
         * This is a convenience that creates an instance of the {@link HostedZone.Builder} avoiding the need to create
         * one manually via {@link HostedZone#builder()}.
         *
         * When the {@link Consumer} completes, {@link HostedZone.Builder#build()} is called immediately and its result
         * is passed to {@link #hostedZone(HostedZone)}.
         * 
         * @param hostedZone
         *        a consumer that will call methods on {@link HostedZone.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hostedZone(HostedZone)
         */
        default Builder hostedZone(Consumer<HostedZone.Builder> hostedZone) {
            return hostedZone(HostedZone.builder().applyMutation(hostedZone).build());
        }

        /**
         * <p>
         * A complex type that contains information about the <code>CreateHostedZone</code> request.
         * </p>
         * 
         * @param changeInfo
         *        A complex type that contains information about the <code>CreateHostedZone</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeInfo(ChangeInfo changeInfo);

        /**
         * <p>
         * A complex type that contains information about the <code>CreateHostedZone</code> request.
         * </p>
         * This is a convenience that creates an instance of the {@link ChangeInfo.Builder} avoiding the need to create
         * one manually via {@link ChangeInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link ChangeInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #changeInfo(ChangeInfo)}.
         * 
         * @param changeInfo
         *        a consumer that will call methods on {@link ChangeInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #changeInfo(ChangeInfo)
         */
        default Builder changeInfo(Consumer<ChangeInfo.Builder> changeInfo) {
            return changeInfo(ChangeInfo.builder().applyMutation(changeInfo).build());
        }

        /**
         * <p>
         * A complex type that describes the name servers for this hosted zone.
         * </p>
         * 
         * @param delegationSet
         *        A complex type that describes the name servers for this hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegationSet(DelegationSet delegationSet);

        /**
         * <p>
         * A complex type that describes the name servers for this hosted zone.
         * </p>
         * This is a convenience that creates an instance of the {@link DelegationSet.Builder} avoiding the need to
         * create one manually via {@link DelegationSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link DelegationSet.Builder#build()} is called immediately and its
         * result is passed to {@link #delegationSet(DelegationSet)}.
         * 
         * @param delegationSet
         *        a consumer that will call methods on {@link DelegationSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #delegationSet(DelegationSet)
         */
        default Builder delegationSet(Consumer<DelegationSet.Builder> delegationSet) {
            return delegationSet(DelegationSet.builder().applyMutation(delegationSet).build());
        }

        /**
         * <p>
         * A complex type that contains information about an Amazon VPC that you associated with this hosted zone.
         * </p>
         * 
         * @param vpc
         *        A complex type that contains information about an Amazon VPC that you associated with this hosted
         *        zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(VPC vpc);

        /**
         * <p>
         * A complex type that contains information about an Amazon VPC that you associated with this hosted zone.
         * </p>
         * This is a convenience that creates an instance of the {@link VPC.Builder} avoiding the need to create one
         * manually via {@link VPC#builder()}.
         *
         * When the {@link Consumer} completes, {@link VPC.Builder#build()} is called immediately and its result is
         * passed to {@link #vpc(VPC)}.
         * 
         * @param vpc
         *        a consumer that will call methods on {@link VPC.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpc(VPC)
         */
        default Builder vpc(Consumer<VPC.Builder> vpc) {
            return vpc(VPC.builder().applyMutation(vpc).build());
        }

        /**
         * <p>
         * The unique URL representing the new hosted zone.
         * </p>
         * 
         * @param location
         *        The unique URL representing the new hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private HostedZone hostedZone;

        private ChangeInfo changeInfo;

        private DelegationSet delegationSet;

        private VPC vpc;

        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHostedZoneResponse model) {
            super(model);
            hostedZone(model.hostedZone);
            changeInfo(model.changeInfo);
            delegationSet(model.delegationSet);
            vpc(model.vpc);
            location(model.location);
        }

        public final HostedZone.Builder getHostedZone() {
            return hostedZone != null ? hostedZone.toBuilder() : null;
        }

        @Override
        public final Builder hostedZone(HostedZone hostedZone) {
            this.hostedZone = hostedZone;
            return this;
        }

        public final void setHostedZone(HostedZone.BuilderImpl hostedZone) {
            this.hostedZone = hostedZone != null ? hostedZone.build() : null;
        }

        public final ChangeInfo.Builder getChangeInfo() {
            return changeInfo != null ? changeInfo.toBuilder() : null;
        }

        @Override
        public final Builder changeInfo(ChangeInfo changeInfo) {
            this.changeInfo = changeInfo;
            return this;
        }

        public final void setChangeInfo(ChangeInfo.BuilderImpl changeInfo) {
            this.changeInfo = changeInfo != null ? changeInfo.build() : null;
        }

        public final DelegationSet.Builder getDelegationSet() {
            return delegationSet != null ? delegationSet.toBuilder() : null;
        }

        @Override
        public final Builder delegationSet(DelegationSet delegationSet) {
            this.delegationSet = delegationSet;
            return this;
        }

        public final void setDelegationSet(DelegationSet.BuilderImpl delegationSet) {
            this.delegationSet = delegationSet != null ? delegationSet.build() : null;
        }

        public final VPC.Builder getVpc() {
            return vpc != null ? vpc.toBuilder() : null;
        }

        @Override
        public final Builder vpc(VPC vpc) {
            this.vpc = vpc;
            return this;
        }

        public final void setVpc(VPC.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        public final String getLocation() {
            return location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public CreateHostedZoneResponse build() {
            return new CreateHostedZoneResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
