/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetQueryLoggingConfigResponse extends Route53Response implements
        ToCopyableBuilder<GetQueryLoggingConfigResponse.Builder, GetQueryLoggingConfigResponse> {
    private static final SdkField<QueryLoggingConfig> QUERY_LOGGING_CONFIG_FIELD = SdkField
            .<QueryLoggingConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetQueryLoggingConfigResponse::queryLoggingConfig))
            .setter(setter(Builder::queryLoggingConfig))
            .constructor(QueryLoggingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryLoggingConfig")
                    .unmarshallLocationName("QueryLoggingConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_LOGGING_CONFIG_FIELD));

    private final QueryLoggingConfig queryLoggingConfig;

    private GetQueryLoggingConfigResponse(BuilderImpl builder) {
        super(builder);
        this.queryLoggingConfig = builder.queryLoggingConfig;
    }

    /**
     * <p>
     * A complex type that contains information about the query logging configuration that you specified in a <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetQueryLoggingConfig.html"
     * >GetQueryLoggingConfig</a> request.
     * </p>
     * 
     * @return A complex type that contains information about the query logging configuration that you specified in a <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetQueryLoggingConfig.html">
     *         GetQueryLoggingConfig</a> request.
     */
    public QueryLoggingConfig queryLoggingConfig() {
        return queryLoggingConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queryLoggingConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueryLoggingConfigResponse)) {
            return false;
        }
        GetQueryLoggingConfigResponse other = (GetQueryLoggingConfigResponse) obj;
        return Objects.equals(queryLoggingConfig(), other.queryLoggingConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetQueryLoggingConfigResponse").add("QueryLoggingConfig", queryLoggingConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryLoggingConfig":
            return Optional.ofNullable(clazz.cast(queryLoggingConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetQueryLoggingConfigResponse, T> g) {
        return obj -> g.apply((GetQueryLoggingConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo, CopyableBuilder<Builder, GetQueryLoggingConfigResponse> {
        /**
         * <p>
         * A complex type that contains information about the query logging configuration that you specified in a <a
         * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetQueryLoggingConfig.html">
         * GetQueryLoggingConfig</a> request.
         * </p>
         * 
         * @param queryLoggingConfig
         *        A complex type that contains information about the query logging configuration that you specified in a
         *        <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetQueryLoggingConfig.html">
         *        GetQueryLoggingConfig</a> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryLoggingConfig(QueryLoggingConfig queryLoggingConfig);

        /**
         * <p>
         * A complex type that contains information about the query logging configuration that you specified in a <a
         * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetQueryLoggingConfig.html">
         * GetQueryLoggingConfig</a> request.
         * </p>
         * This is a convenience that creates an instance of the {@link QueryLoggingConfig.Builder} avoiding the need to
         * create one manually via {@link QueryLoggingConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link QueryLoggingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #queryLoggingConfig(QueryLoggingConfig)}.
         * 
         * @param queryLoggingConfig
         *        a consumer that will call methods on {@link QueryLoggingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryLoggingConfig(QueryLoggingConfig)
         */
        default Builder queryLoggingConfig(Consumer<QueryLoggingConfig.Builder> queryLoggingConfig) {
            return queryLoggingConfig(QueryLoggingConfig.builder().applyMutation(queryLoggingConfig).build());
        }
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private QueryLoggingConfig queryLoggingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueryLoggingConfigResponse model) {
            super(model);
            queryLoggingConfig(model.queryLoggingConfig);
        }

        public final QueryLoggingConfig.Builder getQueryLoggingConfig() {
            return queryLoggingConfig != null ? queryLoggingConfig.toBuilder() : null;
        }

        @Override
        public final Builder queryLoggingConfig(QueryLoggingConfig queryLoggingConfig) {
            this.queryLoggingConfig = queryLoggingConfig;
            return this;
        }

        public final void setQueryLoggingConfig(QueryLoggingConfig.BuilderImpl queryLoggingConfig) {
            this.queryLoggingConfig = queryLoggingConfig != null ? queryLoggingConfig.build() : null;
        }

        @Override
        public GetQueryLoggingConfigResponse build() {
            return new GetQueryLoggingConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
