/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.xml.AwsXmlProtocolFactory;
import software.amazon.awssdk.protocols.xml.XmlOperationMetadata;
import software.amazon.awssdk.services.route53.model.AssociateVpcWithHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.AssociateVpcWithHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.ChangeResourceRecordSetsRequest;
import software.amazon.awssdk.services.route53.model.ChangeResourceRecordSetsResponse;
import software.amazon.awssdk.services.route53.model.ChangeTagsForResourceRequest;
import software.amazon.awssdk.services.route53.model.ChangeTagsForResourceResponse;
import software.amazon.awssdk.services.route53.model.ConcurrentModificationException;
import software.amazon.awssdk.services.route53.model.ConflictingDomainExistsException;
import software.amazon.awssdk.services.route53.model.ConflictingTypesException;
import software.amazon.awssdk.services.route53.model.CreateHealthCheckRequest;
import software.amazon.awssdk.services.route53.model.CreateHealthCheckResponse;
import software.amazon.awssdk.services.route53.model.CreateHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.CreateHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.CreateQueryLoggingConfigRequest;
import software.amazon.awssdk.services.route53.model.CreateQueryLoggingConfigResponse;
import software.amazon.awssdk.services.route53.model.CreateReusableDelegationSetRequest;
import software.amazon.awssdk.services.route53.model.CreateReusableDelegationSetResponse;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyInstanceRequest;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyInstanceResponse;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyRequest;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyResponse;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyVersionRequest;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyVersionResponse;
import software.amazon.awssdk.services.route53.model.CreateVpcAssociationAuthorizationRequest;
import software.amazon.awssdk.services.route53.model.CreateVpcAssociationAuthorizationResponse;
import software.amazon.awssdk.services.route53.model.DelegationSetAlreadyCreatedException;
import software.amazon.awssdk.services.route53.model.DelegationSetAlreadyReusableException;
import software.amazon.awssdk.services.route53.model.DelegationSetInUseException;
import software.amazon.awssdk.services.route53.model.DelegationSetNotAvailableException;
import software.amazon.awssdk.services.route53.model.DelegationSetNotReusableException;
import software.amazon.awssdk.services.route53.model.DeleteHealthCheckRequest;
import software.amazon.awssdk.services.route53.model.DeleteHealthCheckResponse;
import software.amazon.awssdk.services.route53.model.DeleteHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.DeleteHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.DeleteQueryLoggingConfigRequest;
import software.amazon.awssdk.services.route53.model.DeleteQueryLoggingConfigResponse;
import software.amazon.awssdk.services.route53.model.DeleteReusableDelegationSetRequest;
import software.amazon.awssdk.services.route53.model.DeleteReusableDelegationSetResponse;
import software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyInstanceRequest;
import software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyInstanceResponse;
import software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyRequest;
import software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyResponse;
import software.amazon.awssdk.services.route53.model.DeleteVpcAssociationAuthorizationRequest;
import software.amazon.awssdk.services.route53.model.DeleteVpcAssociationAuthorizationResponse;
import software.amazon.awssdk.services.route53.model.DisassociateVpcFromHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.DisassociateVpcFromHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.GetAccountLimitRequest;
import software.amazon.awssdk.services.route53.model.GetAccountLimitResponse;
import software.amazon.awssdk.services.route53.model.GetChangeRequest;
import software.amazon.awssdk.services.route53.model.GetChangeResponse;
import software.amazon.awssdk.services.route53.model.GetCheckerIpRangesRequest;
import software.amazon.awssdk.services.route53.model.GetCheckerIpRangesResponse;
import software.amazon.awssdk.services.route53.model.GetGeoLocationRequest;
import software.amazon.awssdk.services.route53.model.GetGeoLocationResponse;
import software.amazon.awssdk.services.route53.model.GetHealthCheckCountRequest;
import software.amazon.awssdk.services.route53.model.GetHealthCheckCountResponse;
import software.amazon.awssdk.services.route53.model.GetHealthCheckLastFailureReasonRequest;
import software.amazon.awssdk.services.route53.model.GetHealthCheckLastFailureReasonResponse;
import software.amazon.awssdk.services.route53.model.GetHealthCheckRequest;
import software.amazon.awssdk.services.route53.model.GetHealthCheckResponse;
import software.amazon.awssdk.services.route53.model.GetHealthCheckStatusRequest;
import software.amazon.awssdk.services.route53.model.GetHealthCheckStatusResponse;
import software.amazon.awssdk.services.route53.model.GetHostedZoneCountRequest;
import software.amazon.awssdk.services.route53.model.GetHostedZoneCountResponse;
import software.amazon.awssdk.services.route53.model.GetHostedZoneLimitRequest;
import software.amazon.awssdk.services.route53.model.GetHostedZoneLimitResponse;
import software.amazon.awssdk.services.route53.model.GetHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.GetHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.GetQueryLoggingConfigRequest;
import software.amazon.awssdk.services.route53.model.GetQueryLoggingConfigResponse;
import software.amazon.awssdk.services.route53.model.GetReusableDelegationSetLimitRequest;
import software.amazon.awssdk.services.route53.model.GetReusableDelegationSetLimitResponse;
import software.amazon.awssdk.services.route53.model.GetReusableDelegationSetRequest;
import software.amazon.awssdk.services.route53.model.GetReusableDelegationSetResponse;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceCountRequest;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceCountResponse;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceRequest;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceResponse;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyRequest;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyResponse;
import software.amazon.awssdk.services.route53.model.HealthCheckAlreadyExistsException;
import software.amazon.awssdk.services.route53.model.HealthCheckVersionMismatchException;
import software.amazon.awssdk.services.route53.model.HostedZoneAlreadyExistsException;
import software.amazon.awssdk.services.route53.model.HostedZoneNotEmptyException;
import software.amazon.awssdk.services.route53.model.HostedZoneNotFoundException;
import software.amazon.awssdk.services.route53.model.HostedZoneNotPrivateException;
import software.amazon.awssdk.services.route53.model.IncompatibleVersionException;
import software.amazon.awssdk.services.route53.model.InsufficientCloudWatchLogsResourcePolicyException;
import software.amazon.awssdk.services.route53.model.InvalidArgumentException;
import software.amazon.awssdk.services.route53.model.InvalidChangeBatchException;
import software.amazon.awssdk.services.route53.model.InvalidDomainNameException;
import software.amazon.awssdk.services.route53.model.InvalidInputException;
import software.amazon.awssdk.services.route53.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.route53.model.InvalidTrafficPolicyDocumentException;
import software.amazon.awssdk.services.route53.model.InvalidVpcIdException;
import software.amazon.awssdk.services.route53.model.LastVpcAssociationException;
import software.amazon.awssdk.services.route53.model.LimitsExceededException;
import software.amazon.awssdk.services.route53.model.ListGeoLocationsRequest;
import software.amazon.awssdk.services.route53.model.ListGeoLocationsResponse;
import software.amazon.awssdk.services.route53.model.ListHealthChecksRequest;
import software.amazon.awssdk.services.route53.model.ListHealthChecksResponse;
import software.amazon.awssdk.services.route53.model.ListHostedZonesByNameRequest;
import software.amazon.awssdk.services.route53.model.ListHostedZonesByNameResponse;
import software.amazon.awssdk.services.route53.model.ListHostedZonesRequest;
import software.amazon.awssdk.services.route53.model.ListHostedZonesResponse;
import software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsRequest;
import software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsResponse;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsResponse;
import software.amazon.awssdk.services.route53.model.ListReusableDelegationSetsRequest;
import software.amazon.awssdk.services.route53.model.ListReusableDelegationSetsResponse;
import software.amazon.awssdk.services.route53.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.route53.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.route53.model.ListTagsForResourcesRequest;
import software.amazon.awssdk.services.route53.model.ListTagsForResourcesResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPoliciesRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPoliciesResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByPolicyRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByPolicyResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyVersionsRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyVersionsResponse;
import software.amazon.awssdk.services.route53.model.ListVpcAssociationAuthorizationsRequest;
import software.amazon.awssdk.services.route53.model.ListVpcAssociationAuthorizationsResponse;
import software.amazon.awssdk.services.route53.model.NoSuchChangeException;
import software.amazon.awssdk.services.route53.model.NoSuchCloudWatchLogsLogGroupException;
import software.amazon.awssdk.services.route53.model.NoSuchDelegationSetException;
import software.amazon.awssdk.services.route53.model.NoSuchGeoLocationException;
import software.amazon.awssdk.services.route53.model.NoSuchHealthCheckException;
import software.amazon.awssdk.services.route53.model.NoSuchHostedZoneException;
import software.amazon.awssdk.services.route53.model.NoSuchQueryLoggingConfigException;
import software.amazon.awssdk.services.route53.model.NoSuchTrafficPolicyException;
import software.amazon.awssdk.services.route53.model.NoSuchTrafficPolicyInstanceException;
import software.amazon.awssdk.services.route53.model.NotAuthorizedException;
import software.amazon.awssdk.services.route53.model.PriorRequestNotCompleteException;
import software.amazon.awssdk.services.route53.model.PublicZoneVpcAssociationException;
import software.amazon.awssdk.services.route53.model.QueryLoggingConfigAlreadyExistsException;
import software.amazon.awssdk.services.route53.model.Route53Exception;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.services.route53.model.TestDnsAnswerRequest;
import software.amazon.awssdk.services.route53.model.TestDnsAnswerResponse;
import software.amazon.awssdk.services.route53.model.ThrottlingException;
import software.amazon.awssdk.services.route53.model.TooManyHealthChecksException;
import software.amazon.awssdk.services.route53.model.TooManyHostedZonesException;
import software.amazon.awssdk.services.route53.model.TooManyTrafficPoliciesException;
import software.amazon.awssdk.services.route53.model.TooManyTrafficPolicyInstancesException;
import software.amazon.awssdk.services.route53.model.TooManyTrafficPolicyVersionsForCurrentPolicyException;
import software.amazon.awssdk.services.route53.model.TooManyVpcAssociationAuthorizationsException;
import software.amazon.awssdk.services.route53.model.TrafficPolicyAlreadyExistsException;
import software.amazon.awssdk.services.route53.model.TrafficPolicyInUseException;
import software.amazon.awssdk.services.route53.model.TrafficPolicyInstanceAlreadyExistsException;
import software.amazon.awssdk.services.route53.model.UpdateHealthCheckRequest;
import software.amazon.awssdk.services.route53.model.UpdateHealthCheckResponse;
import software.amazon.awssdk.services.route53.model.UpdateHostedZoneCommentRequest;
import software.amazon.awssdk.services.route53.model.UpdateHostedZoneCommentResponse;
import software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyCommentRequest;
import software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyCommentResponse;
import software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyInstanceRequest;
import software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyInstanceResponse;
import software.amazon.awssdk.services.route53.model.VpcAssociationAuthorizationNotFoundException;
import software.amazon.awssdk.services.route53.model.VpcAssociationNotFoundException;
import software.amazon.awssdk.services.route53.paginators.ListHealthChecksPublisher;
import software.amazon.awssdk.services.route53.paginators.ListHostedZonesPublisher;
import software.amazon.awssdk.services.route53.paginators.ListResourceRecordSetsPublisher;
import software.amazon.awssdk.services.route53.transform.AssociateVpcWithHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ChangeResourceRecordSetsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ChangeTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateHealthCheckRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateQueryLoggingConfigRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateReusableDelegationSetRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateTrafficPolicyInstanceRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateTrafficPolicyRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateTrafficPolicyVersionRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateVpcAssociationAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteHealthCheckRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteQueryLoggingConfigRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteReusableDelegationSetRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteTrafficPolicyInstanceRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteTrafficPolicyRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteVpcAssociationAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DisassociateVpcFromHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetAccountLimitRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetChangeRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetCheckerIpRangesRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetGeoLocationRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHealthCheckCountRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHealthCheckLastFailureReasonRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHealthCheckRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHealthCheckStatusRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHostedZoneCountRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHostedZoneLimitRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetQueryLoggingConfigRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetReusableDelegationSetLimitRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetReusableDelegationSetRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetTrafficPolicyInstanceCountRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetTrafficPolicyInstanceRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetTrafficPolicyRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListGeoLocationsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListHealthChecksRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListHostedZonesByNameRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListHostedZonesRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListQueryLoggingConfigsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListResourceRecordSetsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListReusableDelegationSetsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTagsForResourcesRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPoliciesRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPolicyInstancesByHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPolicyInstancesByPolicyRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPolicyInstancesRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPolicyVersionsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListVpcAssociationAuthorizationsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.TestDnsAnswerRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.UpdateHealthCheckRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.UpdateHostedZoneCommentRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.UpdateTrafficPolicyCommentRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.UpdateTrafficPolicyInstanceRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link Route53AsyncClient}.
 *
 * @see Route53AsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultRoute53AsyncClient implements Route53AsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultRoute53AsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsXmlProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultRoute53AsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Associates an Amazon VPC with a private hosted zone.
     * </p>
     * <important>
     * <p>
     * To perform the association, the VPC and the private hosted zone must already exist. You can't convert a public
     * hosted zone into a private hosted zone.
     * </p>
     * </important> <note>
     * <p>
     * If you want to associate a VPC that was created by using one AWS account with a private hosted zone that was
     * created by using a different account, the AWS account that created the private hosted zone must first submit a
     * <code>CreateVPCAssociationAuthorization</code> request. Then the account that created the VPC must submit an
     * <code>AssociateVPCWithHostedZone</code> request.
     * </p>
     * </note>
     *
     * @param associateVpcWithHostedZoneRequest
     *        A complex type that contains information about the request to associate a VPC with a private hosted zone.
     * @return A Java Future containing the result of the AssociateVPCWithHostedZone operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>NotAuthorizedException Associating the specified VPC with the specified hosted zone has not been
     *         authorized.</li>
     *         <li>InvalidVpcIdException The VPC ID that you specified either isn't a valid ID or the current account is
     *         not authorized to access this VPC.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>PublicZoneVpcAssociationException You're trying to associate a VPC with a public hosted zone. Amazon
     *         Route 53 doesn't support associating a VPC with a public hosted zone.</li>
     *         <li>ConflictingDomainExistsException The cause of this error depends on whether you're trying to create a
     *         public or a private hosted zone:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Public hosted zone:</b> Two hosted zones that have the same name or that have a parent/child
     *         relationship (example.com and test.example.com) can't have any common name servers. You tried to create a
     *         hosted zone that has the same name as an existing hosted zone or that's the parent or child of an
     *         existing hosted zone, and you specified a delegation set that shares one or more name servers with the
     *         existing hosted zone. For more information, see <a>CreateReusableDelegationSet</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Private hosted zone:</b> You specified an Amazon VPC that you're already using for another hosted
     *         zone, and the domain that you specified for one of the hosted zones is a subdomain of the domain that you
     *         specified for the other hosted zone. For example, you can't use the same Amazon VPC for the hosted zones
     *         for example.com and test.example.com.
     *         </p>
     *         </li></li>
     *         <li>LimitsExceededException This operation can't be completed either because the current account has
     *         reached the limit on reusable delegation sets that it can create or because you've reached the limit on
     *         the number of Amazon VPCs that you can associate with a private hosted zone. To get the current limit on
     *         the number of reusable delegation sets, see <a>GetAccountLimit</a>. To get the current limit on the
     *         number of Amazon VPCs that you can associate with a private hosted zone, see <a>GetHostedZoneLimit</a>.
     *         To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the AWS
     *         Support Center.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.AssociateVPCWithHostedZone
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/AssociateVPCWithHostedZone"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateVpcWithHostedZoneResponse> associateVPCWithHostedZone(
            AssociateVpcWithHostedZoneRequest associateVpcWithHostedZoneRequest) {
        try {

            HttpResponseHandler<AssociateVpcWithHostedZoneResponse> responseHandler = protocolFactory.createResponseHandler(
                    AssociateVpcWithHostedZoneResponse::builder,
                    new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateVpcWithHostedZoneRequest, AssociateVpcWithHostedZoneResponse>()
                            .withOperationName("AssociateVPCWithHostedZone")
                            .withMarshaller(new AssociateVpcWithHostedZoneRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(associateVpcWithHostedZoneRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates, changes, or deletes a resource record set, which contains authoritative DNS information for a specified
     * domain name or subdomain name. For example, you can use <code>ChangeResourceRecordSets</code> to create a
     * resource record set that routes traffic for test.example.com to a web server that has an IP address of
     * 192.0.2.44.
     * </p>
     * <p>
     * <b>Change Batches and Transactional Changes</b>
     * </p>
     * <p>
     * The request body must include a document with a <code>ChangeResourceRecordSetsRequest</code> element. The request
     * body contains a list of change items, known as a change batch. Change batches are considered transactional
     * changes. When using the Amazon Route 53 API to change resource record sets, Route 53 either makes all or none of
     * the changes in a change batch request. This ensures that Route 53 never partially implements the intended changes
     * to the resource record sets in a hosted zone.
     * </p>
     * <p>
     * For example, a change batch request that deletes the <code>CNAME</code> record for www.example.com and creates an
     * alias resource record set for www.example.com. Route 53 deletes the first resource record set and creates the
     * second resource record set in a single operation. If either the <code>DELETE</code> or the <code>CREATE</code>
     * action fails, then both changes (plus any other changes in the batch) fail, and the original <code>CNAME</code>
     * record continues to exist.
     * </p>
     * <important>
     * <p>
     * Due to the nature of transactional changes, you can't delete the same resource record set more than once in a
     * single change batch. If you attempt to delete the same change batch more than once, Route 53 returns an
     * <code>InvalidChangeBatch</code> error.
     * </p>
     * </important>
     * <p>
     * <b>Traffic Flow</b>
     * </p>
     * <p>
     * To create resource record sets for complex routing configurations, use either the traffic flow visual editor in
     * the Route 53 console or the API actions for traffic policies and traffic policy instances. Save the configuration
     * as a traffic policy, then associate the traffic policy with one or more domain names (such as example.com) or
     * subdomain names (such as www.example.com), in the same hosted zone or in multiple hosted zones. You can roll back
     * the updates if the new configuration isn't performing as expected. For more information, see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/traffic-flow.html">Using Traffic Flow to Route DNS
     * Traffic</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * <b>Create, Delete, and Upsert</b>
     * </p>
     * <p>
     * Use <code>ChangeResourceRecordsSetsRequest</code> to perform the following actions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE</code>: Creates a resource record set that has the specified values.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE</code>: Deletes an existing resource record set that has the specified values.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPSERT</code>: If a resource record set does not already exist, AWS creates it. If a resource set does
     * exist, Route 53 updates it with the values in the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Syntaxes for Creating, Updating, and Deleting Resource Record Sets</b>
     * </p>
     * <p>
     * The syntax for a request depends on the type of resource record set that you want to create, delete, or update,
     * such as weighted, alias, or failover. The XML elements in your request must appear in the order listed in the
     * syntax.
     * </p>
     * <p>
     * For an example for each type of resource record set, see "Examples."
     * </p>
     * <p>
     * Don't refer to the syntax in the "Parameter Syntax" section, which includes all of the elements for every kind of
     * resource record set that you can create, delete, or update by using <code>ChangeResourceRecordSets</code>.
     * </p>
     * <p>
     * <b>Change Propagation to Route 53 DNS Servers</b>
     * </p>
     * <p>
     * When you submit a <code>ChangeResourceRecordSets</code> request, Route 53 propagates your changes to all of the
     * Route 53 authoritative DNS servers. While your changes are propagating, <code>GetChange</code> returns a status
     * of <code>PENDING</code>. When propagation is complete, <code>GetChange</code> returns a status of
     * <code>INSYNC</code>. Changes generally propagate to all Route 53 name servers within 60 seconds. For more
     * information, see <a>GetChange</a>.
     * </p>
     * <p>
     * <b>Limits on ChangeResourceRecordSets Requests</b>
     * </p>
     * <p>
     * For information about the limits on a <code>ChangeResourceRecordSets</code> request, see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the <i>Amazon
     * Route 53 Developer Guide</i>.
     * </p>
     *
     * @param changeResourceRecordSetsRequest
     *        A complex type that contains change information for the resource record set.
     * @return A Java Future containing the result of the ChangeResourceRecordSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>NoSuchHealthCheckException No health check exists with the specified ID.</li>
     *         <li>InvalidChangeBatchException This exception contains a list of messages that might contain one or more
     *         error messages. Each error message indicates one error in the change batch.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>PriorRequestNotCompleteException If Amazon Route 53 can't process a request before the next request
     *         arrives, it will reject subsequent requests for the same hosted zone and return an
     *         <code>HTTP 400 error</code> (<code>Bad request</code>). If Route 53 returns this error repeatedly for the
     *         same request, we recommend that you wait, in intervals of increasing duration, before you try the request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ChangeResourceRecordSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ChangeResourceRecordSets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ChangeResourceRecordSetsResponse> changeResourceRecordSets(
            ChangeResourceRecordSetsRequest changeResourceRecordSetsRequest) {
        try {

            HttpResponseHandler<ChangeResourceRecordSetsResponse> responseHandler = protocolFactory.createResponseHandler(
                    ChangeResourceRecordSetsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<ChangeResourceRecordSetsRequest, ChangeResourceRecordSetsResponse>()
                            .withOperationName("ChangeResourceRecordSets")
                            .withMarshaller(new ChangeResourceRecordSetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(changeResourceRecordSetsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds, edits, or deletes tags for a health check or a hosted zone.
     * </p>
     * <p>
     * For information about using tags for cost allocation, see <a
     * href="http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation
     * Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
     * </p>
     *
     * @param changeTagsForResourceRequest
     *        A complex type that contains information about the tags that you want to add, edit, or delete.
     * @return A Java Future containing the result of the ChangeTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchHealthCheckException No health check exists with the specified ID.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>PriorRequestNotCompleteException If Amazon Route 53 can't process a request before the next request
     *         arrives, it will reject subsequent requests for the same hosted zone and return an
     *         <code>HTTP 400 error</code> (<code>Bad request</code>). If Route 53 returns this error repeatedly for the
     *         same request, we recommend that you wait, in intervals of increasing duration, before you try the request
     *         again.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ChangeTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ChangeTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ChangeTagsForResourceResponse> changeTagsForResource(
            ChangeTagsForResourceRequest changeTagsForResourceRequest) {
        try {

            HttpResponseHandler<ChangeTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    ChangeTagsForResourceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<ChangeTagsForResourceRequest, ChangeTagsForResourceResponse>()
                    .withOperationName("ChangeTagsForResource")
                    .withMarshaller(new ChangeTagsForResourceRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(changeTagsForResourceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new health check.
     * </p>
     * <p>
     * For information about adding health checks to resource record sets, see <a>ResourceRecordSet&#36HealthCheckId</a>
     * in <a>ChangeResourceRecordSets</a>.
     * </p>
     * <p>
     * <b>ELB Load Balancers</b>
     * </p>
     * <p>
     * If you're registering EC2 instances with an Elastic Load Balancing (ELB) load balancer, do not create Amazon
     * Route 53 health checks for the EC2 instances. When you register an EC2 instance with a load balancer, you
     * configure settings for an ELB health check, which performs a similar function to a Route 53 health check.
     * </p>
     * <p>
     * <b>Private Hosted Zones</b>
     * </p>
     * <p>
     * You can associate health checks with failover resource record sets in a private hosted zone. Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Route 53 health checkers are outside the VPC. To check the health of an endpoint within a VPC by IP address, you
     * must assign a public IP address to the instance in the VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can configure a health checker to check the health of an external resource that the instance relies on, such
     * as a database server.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can create a CloudWatch metric, associate an alarm with the metric, and then create a health check that is
     * based on the state of the alarm. For example, you might create a CloudWatch metric that checks the status of the
     * Amazon EC2 <code>StatusCheckFailed</code> metric, add an alarm to the metric, and then create a health check that
     * is based on the state of the alarm. For information about creating CloudWatch metrics and alarms by using the
     * CloudWatch console, see the <a
     * href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/WhatIsCloudWatch.html">Amazon CloudWatch
     * User Guide</a>.
     * </p>
     * </li>
     * </ul>
     *
     * @param createHealthCheckRequest
     *        A complex type that contains the health check request information.
     * @return A Java Future containing the result of the CreateHealthCheck operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyHealthChecksException This health check can't be created because the current account has
     *         reached the limit on the number of active health checks.</p>
     *         <p>
     *         For information about default limits, see <a
     *         href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the
     *         <i>Amazon Route 53 Developer Guide</i>.
     *         </p>
     *         <p>
     *         For information about how to get the current limit for an account, see <a>GetAccountLimit</a>. To request
     *         a higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the AWS Support
     *         Center.
     *         </p>
     *         <p>
     *         You have reached the maximum number of active health checks for an AWS account. To request a higher
     *         limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the AWS Support Center.</li>
     *         <li>HealthCheckAlreadyExistsException The health check you're attempting to create already exists. Amazon
     *         Route 53 returns this error when you submit a request that has the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The same value for <code>CallerReference</code> as an existing health check, and one or more values that
     *         differ from the existing health check that has the same caller reference.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The same value for <code>CallerReference</code> as a health check that you created and later deleted,
     *         regardless of the other settings in the request.
     *         </p>
     *         </li></li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.CreateHealthCheck
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateHealthCheck" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateHealthCheckResponse> createHealthCheck(CreateHealthCheckRequest createHealthCheckRequest) {
        try {

            HttpResponseHandler<CreateHealthCheckResponse> responseHandler = protocolFactory.createResponseHandler(
                    CreateHealthCheckResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<CreateHealthCheckRequest, CreateHealthCheckResponse>()
                    .withOperationName("CreateHealthCheck")
                    .withMarshaller(new CreateHealthCheckRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createHealthCheckRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new public or private hosted zone. You create records in a public hosted zone to define how you want to
     * route traffic on the internet for a domain, such as example.com, and its subdomains (apex.example.com,
     * acme.example.com). You create records in a private hosted zone to define how you want to route traffic for a
     * domain and its subdomains within one or more Amazon Virtual Private Clouds (Amazon VPCs).
     * </p>
     * <important>
     * <p>
     * You can't convert a public hosted zone to a private hosted zone or vice versa. Instead, you must create a new
     * hosted zone with the same name and create new resource record sets.
     * </p>
     * </important>
     * <p>
     * For more information about charges for hosted zones, see <a href="http://aws.amazon.com/route53/pricing/">Amazon
     * Route 53 Pricing</a>.
     * </p>
     * <p>
     * Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can't create a hosted zone for a top-level domain (TLD) such as .com.
     * </p>
     * </li>
     * <li>
     * <p>
     * For public hosted zones, Amazon Route 53 automatically creates a default SOA record and four NS records for the
     * zone. For more information about SOA and NS records, see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/SOA-NSrecords.html">NS and SOA Records that Route
     * 53 Creates for a Hosted Zone</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * If you want to use the same name servers for multiple public hosted zones, you can optionally associate a
     * reusable delegation set with the hosted zone. See the <code>DelegationSetId</code> element.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your domain is registered with a registrar other than Route 53, you must update the name servers with your
     * registrar to make Route 53 the DNS service for the domain. For more information, see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/MigratingDNS.html">Migrating DNS Service for an
     * Existing Domain to Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When you submit a <code>CreateHostedZone</code> request, the initial status of the hosted zone is
     * <code>PENDING</code>. For public hosted zones, this means that the NS and SOA records are not yet available on
     * all Route 53 DNS servers. When the NS and SOA records are available, the status of the zone changes to
     * <code>INSYNC</code>.
     * </p>
     *
     * @param createHostedZoneRequest
     *        A complex type that contains information about the request to create a public or private hosted zone.
     * @return A Java Future containing the result of the CreateHostedZone operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDomainNameException The specified domain name is not valid.</li>
     *         <li>HostedZoneAlreadyExistsException The hosted zone you're trying to create already exists. Amazon Route
     *         53 returns this error when a hosted zone has already been created with the specified
     *         <code>CallerReference</code>.</li>
     *         <li>TooManyHostedZonesException This operation can't be completed either because the current account has
     *         reached the limit on the number of hosted zones or because you've reached the limit on the number of
     *         hosted zones that can be associated with a reusable delegation set.</p>
     *         <p>
     *         For information about default limits, see <a
     *         href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the
     *         <i>Amazon Route 53 Developer Guide</i>.
     *         </p>
     *         <p>
     *         To get the current limit on hosted zones that can be created by an account, see <a>GetAccountLimit</a>.
     *         </p>
     *         <p>
     *         To get the current limit on hosted zones that can be associated with a reusable delegation set, see
     *         <a>GetReusableDelegationSetLimit</a>.
     *         </p>
     *         <p>
     *         To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the AWS
     *         Support Center.</li>
     *         <li>InvalidVpcIdException The VPC ID that you specified either isn't a valid ID or the current account is
     *         not authorized to access this VPC.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>DelegationSetNotAvailableException You can create a hosted zone that has the same name as an existing
     *         hosted zone (example.com is common), but there is a limit to the number of hosted zones that have the
     *         same name. If you get this error, Amazon Route 53 has reached that limit. If you own the domain name and
     *         Route 53 generates this error, contact Customer Support.</li>
     *         <li>ConflictingDomainExistsException The cause of this error depends on whether you're trying to create a
     *         public or a private hosted zone:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Public hosted zone:</b> Two hosted zones that have the same name or that have a parent/child
     *         relationship (example.com and test.example.com) can't have any common name servers. You tried to create a
     *         hosted zone that has the same name as an existing hosted zone or that's the parent or child of an
     *         existing hosted zone, and you specified a delegation set that shares one or more name servers with the
     *         existing hosted zone. For more information, see <a>CreateReusableDelegationSet</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Private hosted zone:</b> You specified an Amazon VPC that you're already using for another hosted
     *         zone, and the domain that you specified for one of the hosted zones is a subdomain of the domain that you
     *         specified for the other hosted zone. For example, you can't use the same Amazon VPC for the hosted zones
     *         for example.com and test.example.com.
     *         </p>
     *         </li></li>
     *         <li>NoSuchDelegationSetException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>DelegationSetNotReusableException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.CreateHostedZone
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateHostedZone" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateHostedZoneResponse> createHostedZone(CreateHostedZoneRequest createHostedZoneRequest) {
        try {

            HttpResponseHandler<CreateHostedZoneResponse> responseHandler = protocolFactory.createResponseHandler(
                    CreateHostedZoneResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<CreateHostedZoneRequest, CreateHostedZoneResponse>()
                    .withOperationName("CreateHostedZone").withMarshaller(new CreateHostedZoneRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(createHostedZoneRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a configuration for DNS query logging. After you create a query logging configuration, Amazon Route 53
     * begins to publish log data to an Amazon CloudWatch Logs log group.
     * </p>
     * <p>
     * DNS query logs contain information about the queries that Route 53 receives for a specified public hosted zone,
     * such as the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Route 53 edge location that responded to the DNS query
     * </p>
     * </li>
     * <li>
     * <p>
     * Domain or subdomain that was requested
     * </p>
     * </li>
     * <li>
     * <p>
     * DNS record type, such as A or AAAA
     * </p>
     * </li>
     * <li>
     * <p>
     * DNS response code, such as <code>NoError</code> or <code>ServFail</code>
     * </p>
     * </li>
     * </ul>
     * <dl>
     * <dt>Log Group and Resource Policy</dt>
     * <dd>
     * <p>
     * Before you create a query logging configuration, perform the following operations.
     * </p>
     * <note>
     * <p>
     * If you create a query logging configuration using the Route 53 console, Route 53 performs these operations
     * automatically.
     * </p>
     * </note>
     * <ol>
     * <li>
     * <p>
     * Create a CloudWatch Logs log group, and make note of the ARN, which you specify when you create a query logging
     * configuration. Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must create the log group in the us-east-1 region.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must use the same AWS account to create the log group and the hosted zone that you want to configure query
     * logging for.
     * </p>
     * </li>
     * <li>
     * <p>
     * When you create log groups for query logging, we recommend that you use a consistent prefix, for example:
     * </p>
     * <p>
     * <code>/aws/route53/<i>hosted zone name</i> </code>
     * </p>
     * <p>
     * In the next step, you'll create a resource policy, which controls access to one or more log groups and the
     * associated AWS resources, such as Route 53 hosted zones. There's a limit on the number of resource policies that
     * you can create, so we recommend that you use a consistent prefix so you can use the same resource policy for all
     * the log groups that you create for query logging.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Create a CloudWatch Logs resource policy, and give it the permissions that Route 53 needs to create log streams
     * and to send query logs to log streams. For the value of <code>Resource</code>, specify the ARN for the log group
     * that you created in the previous step. To use the same resource policy for all the CloudWatch Logs log groups
     * that you created for query logging configurations, replace the hosted zone name with <code>*</code>, for example:
     * </p>
     * <p>
     * <code>arn:aws:logs:us-east-1:123412341234:log-group:/aws/route53/*</code>
     * </p>
     * <note>
     * <p>
     * You can't use the CloudWatch console to create or edit a resource policy. You must use the CloudWatch API, one of
     * the AWS SDKs, or the AWS CLI.
     * </p>
     * </note></li>
     * </ol>
     * </dd>
     * <dt>Log Streams and Edge Locations</dt>
     * <dd>
     * <p>
     * When Route 53 finishes creating the configuration for DNS query logging, it does the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Creates a log stream for an edge location the first time that the edge location responds to DNS queries for the
     * specified hosted zone. That log stream is used to log all queries that Route 53 responds to for that edge
     * location.
     * </p>
     * </li>
     * <li>
     * <p>
     * Begins to send query logs to the applicable log stream.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The name of each log stream is in the following format:
     * </p>
     * <p>
     * <code> <i>hosted zone ID</i>/<i>edge location code</i> </code>
     * </p>
     * <p>
     * The edge location code is a three-letter code and an arbitrarily assigned number, for example, DFW3. The
     * three-letter code typically corresponds with the International Air Transport Association airport code for an
     * airport near the edge location. (These abbreviations might change in the future.) For a list of edge locations,
     * see "The Route 53 Global Network" on the <a href="http://aws.amazon.com/route53/details/">Route 53 Product
     * Details</a> page.
     * </p>
     * </dd>
     * <dt>Queries That Are Logged</dt>
     * <dd>
     * <p>
     * Query logs contain only the queries that DNS resolvers forward to Route 53. If a DNS resolver has already cached
     * the response to a query (such as the IP address for a load balancer for example.com), the resolver will continue
     * to return the cached response. It doesn't forward another query to Route 53 until the TTL for the corresponding
     * resource record set expires. Depending on how many DNS queries are submitted for a resource record set, and
     * depending on the TTL for that resource record set, query logs might contain information about only one query out
     * of every several thousand queries that are submitted to DNS. For more information about how DNS works, see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/welcome-dns-service.html">Routing Internet Traffic
     * to Your Website or Web Application</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * </dd>
     * <dt>Log File Format</dt>
     * <dd>
     * <p>
     * For a list of the values in each query log and the format of each value, see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html">Logging DNS Queries</a> in the
     * <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * </dd>
     * <dt>Pricing</dt>
     * <dd>
     * <p>
     * For information about charges for query logs, see <a href="http://aws.amazon.com/cloudwatch/pricing/">Amazon
     * CloudWatch Pricing</a>.
     * </p>
     * </dd>
     * <dt>How to Stop Logging</dt>
     * <dd>
     * <p>
     * If you want Route 53 to stop sending query logs to CloudWatch Logs, delete the query logging configuration. For
     * more information, see <a>DeleteQueryLoggingConfig</a>.
     * </p>
     * </dd>
     * </dl>
     *
     * @param createQueryLoggingConfigRequest
     * @return A Java Future containing the result of the CreateQueryLoggingConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>NoSuchCloudWatchLogsLogGroupException There is no CloudWatch Logs log group with the specified ARN.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>QueryLoggingConfigAlreadyExistsException You can create only one query logging configuration for a
     *         hosted zone, and a query logging configuration already exists for this hosted zone.</li>
     *         <li>InsufficientCloudWatchLogsResourcePolicyException Amazon Route 53 doesn't have the permissions
     *         required to create log streams and send query logs to log streams. Possible causes include the
     *         following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         There is no resource policy that specifies the log group ARN in the value for <code>Resource</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The resource policy that includes the log group ARN in the value for <code>Resource</code> doesn't have
     *         the necessary permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The resource policy hasn't finished propagating yet.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.CreateQueryLoggingConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateQueryLoggingConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateQueryLoggingConfigResponse> createQueryLoggingConfig(
            CreateQueryLoggingConfigRequest createQueryLoggingConfigRequest) {
        try {

            HttpResponseHandler<CreateQueryLoggingConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    CreateQueryLoggingConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<CreateQueryLoggingConfigRequest, CreateQueryLoggingConfigResponse>()
                            .withOperationName("CreateQueryLoggingConfig")
                            .withMarshaller(new CreateQueryLoggingConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createQueryLoggingConfigRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a delegation set (a group of four name servers) that can be reused by multiple hosted zones. If a hosted
     * zoned ID is specified, <code>CreateReusableDelegationSet</code> marks the delegation set associated with that
     * zone as reusable.
     * </p>
     * <note>
     * <p>
     * You can't associate a reusable delegation set with a private hosted zone.
     * </p>
     * </note>
     * <p>
     * For information about using a reusable delegation set to configure white label name servers, see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/white-label-name-servers.html">Configuring White
     * Label Name Servers</a>.
     * </p>
     * <p>
     * The process for migrating existing hosted zones to use a reusable delegation set is comparable to the process for
     * configuring white label name servers. You need to perform the following steps:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Create a reusable delegation set.
     * </p>
     * </li>
     * <li>
     * <p>
     * Recreate hosted zones, and reduce the TTL to 60 seconds or less.
     * </p>
     * </li>
     * <li>
     * <p>
     * Recreate resource record sets in the new hosted zones.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change the registrar's name servers to use the name servers for the new hosted zones.
     * </p>
     * </li>
     * <li>
     * <p>
     * Monitor traffic for the website or application.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change TTLs back to their original values.
     * </p>
     * </li>
     * </ol>
     * <p>
     * If you want to migrate existing hosted zones to use a reusable delegation set, the existing hosted zones can't
     * use any of the name servers that are assigned to the reusable delegation set. If one or more hosted zones do use
     * one or more name servers that are assigned to the reusable delegation set, you can do one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For small numbers of hosted zones—up to a few hundred—it's relatively easy to create reusable delegation sets
     * until you get one that has four name servers that don't overlap with any of the name servers in your hosted
     * zones.
     * </p>
     * </li>
     * <li>
     * <p>
     * For larger numbers of hosted zones, the easiest solution is to use more than one reusable delegation set.
     * </p>
     * </li>
     * <li>
     * <p>
     * For larger numbers of hosted zones, you can also migrate hosted zones that have overlapping name servers to
     * hosted zones that don't have overlapping name servers, then migrate the hosted zones again to use the reusable
     * delegation set.
     * </p>
     * </li>
     * </ul>
     *
     * @param createReusableDelegationSetRequest
     * @return A Java Future containing the result of the CreateReusableDelegationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DelegationSetAlreadyCreatedException A delegation set with the same owner and caller reference
     *         combination has already been created.</li>
     *         <li>LimitsExceededException This operation can't be completed either because the current account has
     *         reached the limit on reusable delegation sets that it can create or because you've reached the limit on
     *         the number of Amazon VPCs that you can associate with a private hosted zone. To get the current limit on
     *         the number of reusable delegation sets, see <a>GetAccountLimit</a>. To get the current limit on the
     *         number of Amazon VPCs that you can associate with a private hosted zone, see <a>GetHostedZoneLimit</a>.
     *         To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the AWS
     *         Support Center.</li>
     *         <li>HostedZoneNotFoundException The specified HostedZone can't be found.</li>
     *         <li>InvalidArgumentException Parameter name is invalid.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>DelegationSetNotAvailableException You can create a hosted zone that has the same name as an existing
     *         hosted zone (example.com is common), but there is a limit to the number of hosted zones that have the
     *         same name. If you get this error, Amazon Route 53 has reached that limit. If you own the domain name and
     *         Route 53 generates this error, contact Customer Support.</li>
     *         <li>DelegationSetAlreadyReusableException The specified delegation set has already been marked as
     *         reusable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.CreateReusableDelegationSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateReusableDelegationSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateReusableDelegationSetResponse> createReusableDelegationSet(
            CreateReusableDelegationSetRequest createReusableDelegationSetRequest) {
        try {

            HttpResponseHandler<CreateReusableDelegationSetResponse> responseHandler = protocolFactory.createResponseHandler(
                    CreateReusableDelegationSetResponse::builder,
                    new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<CreateReusableDelegationSetRequest, CreateReusableDelegationSetResponse>()
                            .withOperationName("CreateReusableDelegationSet")
                            .withMarshaller(new CreateReusableDelegationSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createReusableDelegationSetRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a traffic policy, which you use to create multiple DNS resource record sets for one domain name (such as
     * example.com) or one subdomain name (such as www.example.com).
     * </p>
     *
     * @param createTrafficPolicyRequest
     *        A complex type that contains information about the traffic policy that you want to create.
     * @return A Java Future containing the result of the CreateTrafficPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>TooManyTrafficPoliciesException This traffic policy can't be created because the current account has
     *         reached the limit on the number of traffic policies.</p>
     *         <p>
     *         For information about default limits, see <a
     *         href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the
     *         <i>Amazon Route 53 Developer Guide</i>.
     *         </p>
     *         <p>
     *         To get the current limit for an account, see <a>GetAccountLimit</a>.
     *         </p>
     *         <p>
     *         To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the AWS
     *         Support Center.</li>
     *         <li>TrafficPolicyAlreadyExistsException A traffic policy that has the same value for <code>Name</code>
     *         already exists.</li>
     *         <li>InvalidTrafficPolicyDocumentException The format of the traffic policy document that you specified in
     *         the <code>Document</code> element is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.CreateTrafficPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateTrafficPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTrafficPolicyResponse> createTrafficPolicy(
            CreateTrafficPolicyRequest createTrafficPolicyRequest) {
        try {

            HttpResponseHandler<CreateTrafficPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    CreateTrafficPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<CreateTrafficPolicyRequest, CreateTrafficPolicyResponse>()
                    .withOperationName("CreateTrafficPolicy")
                    .withMarshaller(new CreateTrafficPolicyRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(createTrafficPolicyRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates resource record sets in a specified hosted zone based on the settings in a specified traffic policy
     * version. In addition, <code>CreateTrafficPolicyInstance</code> associates the resource record sets with a
     * specified domain name (such as example.com) or subdomain name (such as www.example.com). Amazon Route 53 responds
     * to DNS queries for the domain or subdomain name by using the resource record sets that
     * <code>CreateTrafficPolicyInstance</code> created.
     * </p>
     *
     * @param createTrafficPolicyInstanceRequest
     *        A complex type that contains information about the resource record sets that you want to create based on a
     *        specified traffic policy.
     * @return A Java Future containing the result of the CreateTrafficPolicyInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>TooManyTrafficPolicyInstancesException This traffic policy instance can't be created because the
     *         current account has reached the limit on the number of traffic policy instances.</p>
     *         <p>
     *         For information about default limits, see <a
     *         href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the
     *         <i>Amazon Route 53 Developer Guide</i>.
     *         </p>
     *         <p>
     *         For information about how to get the current limit for an account, see <a>GetAccountLimit</a>.
     *         </p>
     *         <p>
     *         To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the AWS
     *         Support Center.</li>
     *         <li>NoSuchTrafficPolicyException No traffic policy exists with the specified ID.</li>
     *         <li>TrafficPolicyInstanceAlreadyExistsException There is already a traffic policy instance with the
     *         specified ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.CreateTrafficPolicyInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateTrafficPolicyInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTrafficPolicyInstanceResponse> createTrafficPolicyInstance(
            CreateTrafficPolicyInstanceRequest createTrafficPolicyInstanceRequest) {
        try {

            HttpResponseHandler<CreateTrafficPolicyInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    CreateTrafficPolicyInstanceResponse::builder,
                    new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<CreateTrafficPolicyInstanceRequest, CreateTrafficPolicyInstanceResponse>()
                            .withOperationName("CreateTrafficPolicyInstance")
                            .withMarshaller(new CreateTrafficPolicyInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createTrafficPolicyInstanceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new version of an existing traffic policy. When you create a new version of a traffic policy, you
     * specify the ID of the traffic policy that you want to update and a JSON-formatted document that describes the new
     * version. You use traffic policies to create multiple DNS resource record sets for one domain name (such as
     * example.com) or one subdomain name (such as www.example.com). You can create a maximum of 1000 versions of a
     * traffic policy. If you reach the limit and need to create another version, you'll need to start a new traffic
     * policy.
     * </p>
     *
     * @param createTrafficPolicyVersionRequest
     *        A complex type that contains information about the traffic policy that you want to create a new version
     *        for.
     * @return A Java Future containing the result of the CreateTrafficPolicyVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchTrafficPolicyException No traffic policy exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>TooManyTrafficPolicyVersionsForCurrentPolicyException This traffic policy version can't be created
     *         because you've reached the limit of 1000 on the number of versions that you can create for the current
     *         traffic policy.</p>
     *         <p>
     *         To create more traffic policy versions, you can use <a>GetTrafficPolicy</a> to get the traffic policy
     *         document for a specified traffic policy version, and then use <a>CreateTrafficPolicy</a> to create a new
     *         traffic policy using the traffic policy document.</li>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>InvalidTrafficPolicyDocumentException The format of the traffic policy document that you specified in
     *         the <code>Document</code> element is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.CreateTrafficPolicyVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateTrafficPolicyVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTrafficPolicyVersionResponse> createTrafficPolicyVersion(
            CreateTrafficPolicyVersionRequest createTrafficPolicyVersionRequest) {
        try {

            HttpResponseHandler<CreateTrafficPolicyVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    CreateTrafficPolicyVersionResponse::builder,
                    new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<CreateTrafficPolicyVersionRequest, CreateTrafficPolicyVersionResponse>()
                            .withOperationName("CreateTrafficPolicyVersion")
                            .withMarshaller(new CreateTrafficPolicyVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createTrafficPolicyVersionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Authorizes the AWS account that created a specified VPC to submit an <code>AssociateVPCWithHostedZone</code>
     * request to associate the VPC with a specified hosted zone that was created by a different account. To submit a
     * <code>CreateVPCAssociationAuthorization</code> request, you must use the account that created the hosted zone.
     * After you authorize the association, use the account that created the VPC to submit an
     * <code>AssociateVPCWithHostedZone</code> request.
     * </p>
     * <note>
     * <p>
     * If you want to associate multiple VPCs that you created by using one account with a hosted zone that you created
     * by using a different account, you must submit one authorization request for each VPC.
     * </p>
     * </note>
     *
     * @param createVpcAssociationAuthorizationRequest
     *        A complex type that contains information about the request to authorize associating a VPC with your
     *        private hosted zone. Authorization is only required when a private hosted zone and a VPC were created by
     *        using different accounts.
     * @return A Java Future containing the result of the CreateVPCAssociationAuthorization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>TooManyVpcAssociationAuthorizationsException You've created the maximum number of authorizations that
     *         can be created for the specified hosted zone. To authorize another VPC to be associated with the hosted
     *         zone, submit a <code>DeleteVPCAssociationAuthorization</code> request to remove an existing
     *         authorization. To get a list of existing authorizations, submit a
     *         <code>ListVPCAssociationAuthorizations</code> request.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidVpcIdException The VPC ID that you specified either isn't a valid ID or the current account is
     *         not authorized to access this VPC.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.CreateVPCAssociationAuthorization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateVPCAssociationAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVpcAssociationAuthorizationResponse> createVPCAssociationAuthorization(
            CreateVpcAssociationAuthorizationRequest createVpcAssociationAuthorizationRequest) {
        try {

            HttpResponseHandler<CreateVpcAssociationAuthorizationResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateVpcAssociationAuthorizationResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<CreateVpcAssociationAuthorizationRequest, CreateVpcAssociationAuthorizationResponse>()
                            .withOperationName("CreateVPCAssociationAuthorization")
                            .withMarshaller(new CreateVpcAssociationAuthorizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createVpcAssociationAuthorizationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a health check.
     * </p>
     * <important>
     * <p>
     * Amazon Route 53 does not prevent you from deleting a health check even if the health check is associated with one
     * or more resource record sets. If you delete a health check and you don't update the associated resource record
     * sets, the future status of the health check can't be predicted and may change. This will affect the routing of
     * DNS queries for your DNS failover configuration. For more information, see <a href=
     * "http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/health-checks-creating-deleting.html#health-checks-deleting.html"
     * >Replacing and Deleting Health Checks</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * </important>
     *
     * @param deleteHealthCheckRequest
     *        This action deletes a health check.
     * @return A Java Future containing the result of the DeleteHealthCheck operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHealthCheckException No health check exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.DeleteHealthCheck
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteHealthCheck" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteHealthCheckResponse> deleteHealthCheck(DeleteHealthCheckRequest deleteHealthCheckRequest) {
        try {

            HttpResponseHandler<DeleteHealthCheckResponse> responseHandler = protocolFactory.createResponseHandler(
                    DeleteHealthCheckResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DeleteHealthCheckRequest, DeleteHealthCheckResponse>()
                    .withOperationName("DeleteHealthCheck")
                    .withMarshaller(new DeleteHealthCheckRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteHealthCheckRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a hosted zone.
     * </p>
     * <important>
     * <p>
     * If the name servers for the hosted zone are associated with a domain and if you want to make the domain
     * unavailable on the Internet, we recommend that you delete the name servers from the domain to prevent future DNS
     * queries from possibly being misrouted. If the domain is registered with Amazon Route 53, see
     * <code>UpdateDomainNameservers</code>. If the domain is registered with another registrar, use the method provided
     * by the registrar to delete name servers for the domain.
     * </p>
     * <p>
     * Some domain registries don't allow you to remove all of the name servers for a domain. If the registry for your
     * domain requires one or more name servers, we recommend that you delete the hosted zone only if you transfer DNS
     * service to another service provider, and you replace the name servers for the domain with name servers from the
     * new provider.
     * </p>
     * </important>
     * <p>
     * You can delete a hosted zone only if it contains only the default SOA record and NS resource record sets. If the
     * hosted zone contains other resource record sets, you must delete them before you can delete the hosted zone. If
     * you try to delete a hosted zone that contains other resource record sets, the request fails, and Route 53 returns
     * a <code>HostedZoneNotEmpty</code> error. For information about deleting records from your hosted zone, see
     * <a>ChangeResourceRecordSets</a>.
     * </p>
     * <p>
     * To verify that the hosted zone has been deleted, do one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>GetHostedZone</code> action to request information about the hosted zone.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>ListHostedZones</code> action to get a list of the hosted zones associated with the current AWS
     * account.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteHostedZoneRequest
     *        A request to delete a hosted zone.
     * @return A Java Future containing the result of the DeleteHostedZone operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>HostedZoneNotEmptyException The hosted zone contains resource records that are not SOA or NS records.
     *         </li>
     *         <li>PriorRequestNotCompleteException If Amazon Route 53 can't process a request before the next request
     *         arrives, it will reject subsequent requests for the same hosted zone and return an
     *         <code>HTTP 400 error</code> (<code>Bad request</code>). If Route 53 returns this error repeatedly for the
     *         same request, we recommend that you wait, in intervals of increasing duration, before you try the request
     *         again.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>InvalidDomainNameException The specified domain name is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.DeleteHostedZone
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteHostedZone" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteHostedZoneResponse> deleteHostedZone(DeleteHostedZoneRequest deleteHostedZoneRequest) {
        try {

            HttpResponseHandler<DeleteHostedZoneResponse> responseHandler = protocolFactory.createResponseHandler(
                    DeleteHostedZoneResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DeleteHostedZoneRequest, DeleteHostedZoneResponse>()
                    .withOperationName("DeleteHostedZone").withMarshaller(new DeleteHostedZoneRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(deleteHostedZoneRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a configuration for DNS query logging. If you delete a configuration, Amazon Route 53 stops sending query
     * logs to CloudWatch Logs. Route 53 doesn't delete any logs that are already in CloudWatch Logs.
     * </p>
     * <p>
     * For more information about DNS query logs, see <a>CreateQueryLoggingConfig</a>.
     * </p>
     *
     * @param deleteQueryLoggingConfigRequest
     * @return A Java Future containing the result of the DeleteQueryLoggingConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>NoSuchQueryLoggingConfigException There is no DNS query logging configuration with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.DeleteQueryLoggingConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteQueryLoggingConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteQueryLoggingConfigResponse> deleteQueryLoggingConfig(
            DeleteQueryLoggingConfigRequest deleteQueryLoggingConfigRequest) {
        try {

            HttpResponseHandler<DeleteQueryLoggingConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    DeleteQueryLoggingConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteQueryLoggingConfigRequest, DeleteQueryLoggingConfigResponse>()
                            .withOperationName("DeleteQueryLoggingConfig")
                            .withMarshaller(new DeleteQueryLoggingConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteQueryLoggingConfigRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a reusable delegation set.
     * </p>
     * <important>
     * <p>
     * You can delete a reusable delegation set only if it isn't associated with any hosted zones.
     * </p>
     * </important>
     * <p>
     * To verify that the reusable delegation set is not associated with any hosted zones, submit a
     * <a>GetReusableDelegationSet</a> request and specify the ID of the reusable delegation set that you want to
     * delete.
     * </p>
     *
     * @param deleteReusableDelegationSetRequest
     *        A request to delete a reusable delegation set.
     * @return A Java Future containing the result of the DeleteReusableDelegationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchDelegationSetException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>DelegationSetInUseException The specified delegation contains associated hosted zones which must be
     *         deleted before the reusable delegation set can be deleted.</li>
     *         <li>DelegationSetNotReusableException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.DeleteReusableDelegationSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteReusableDelegationSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteReusableDelegationSetResponse> deleteReusableDelegationSet(
            DeleteReusableDelegationSetRequest deleteReusableDelegationSetRequest) {
        try {

            HttpResponseHandler<DeleteReusableDelegationSetResponse> responseHandler = protocolFactory.createResponseHandler(
                    DeleteReusableDelegationSetResponse::builder,
                    new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteReusableDelegationSetRequest, DeleteReusableDelegationSetResponse>()
                            .withOperationName("DeleteReusableDelegationSet")
                            .withMarshaller(new DeleteReusableDelegationSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteReusableDelegationSetRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a traffic policy.
     * </p>
     *
     * @param deleteTrafficPolicyRequest
     *        A request to delete a specified traffic policy version.
     * @return A Java Future containing the result of the DeleteTrafficPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchTrafficPolicyException No traffic policy exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>TrafficPolicyInUseException One or more traffic policy instances were created by using the specified
     *         traffic policy.</li>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.DeleteTrafficPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteTrafficPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTrafficPolicyResponse> deleteTrafficPolicy(
            DeleteTrafficPolicyRequest deleteTrafficPolicyRequest) {
        try {

            HttpResponseHandler<DeleteTrafficPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    DeleteTrafficPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DeleteTrafficPolicyRequest, DeleteTrafficPolicyResponse>()
                    .withOperationName("DeleteTrafficPolicy")
                    .withMarshaller(new DeleteTrafficPolicyRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(deleteTrafficPolicyRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a traffic policy instance and all of the resource record sets that Amazon Route 53 created when you
     * created the instance.
     * </p>
     * <note>
     * <p>
     * In the Route 53 console, traffic policy instances are known as policy records.
     * </p>
     * </note>
     *
     * @param deleteTrafficPolicyInstanceRequest
     *        A request to delete a specified traffic policy instance.
     * @return A Java Future containing the result of the DeleteTrafficPolicyInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchTrafficPolicyInstanceException No traffic policy instance exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>PriorRequestNotCompleteException If Amazon Route 53 can't process a request before the next request
     *         arrives, it will reject subsequent requests for the same hosted zone and return an
     *         <code>HTTP 400 error</code> (<code>Bad request</code>). If Route 53 returns this error repeatedly for the
     *         same request, we recommend that you wait, in intervals of increasing duration, before you try the request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.DeleteTrafficPolicyInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteTrafficPolicyInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTrafficPolicyInstanceResponse> deleteTrafficPolicyInstance(
            DeleteTrafficPolicyInstanceRequest deleteTrafficPolicyInstanceRequest) {
        try {

            HttpResponseHandler<DeleteTrafficPolicyInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    DeleteTrafficPolicyInstanceResponse::builder,
                    new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteTrafficPolicyInstanceRequest, DeleteTrafficPolicyInstanceResponse>()
                            .withOperationName("DeleteTrafficPolicyInstance")
                            .withMarshaller(new DeleteTrafficPolicyInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteTrafficPolicyInstanceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes authorization to submit an <code>AssociateVPCWithHostedZone</code> request to associate a specified VPC
     * with a hosted zone that was created by a different account. You must use the account that created the hosted zone
     * to submit a <code>DeleteVPCAssociationAuthorization</code> request.
     * </p>
     * <important>
     * <p>
     * Sending this request only prevents the AWS account that created the VPC from associating the VPC with the Amazon
     * Route 53 hosted zone in the future. If the VPC is already associated with the hosted zone,
     * <code>DeleteVPCAssociationAuthorization</code> won't disassociate the VPC from the hosted zone. If you want to
     * delete an existing association, use <code>DisassociateVPCFromHostedZone</code>.
     * </p>
     * </important>
     *
     * @param deleteVpcAssociationAuthorizationRequest
     *        A complex type that contains information about the request to remove authorization to associate a VPC that
     *        was created by one AWS account with a hosted zone that was created with a different AWS account.
     * @return A Java Future containing the result of the DeleteVPCAssociationAuthorization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>VpcAssociationAuthorizationNotFoundException The VPC that you specified is not authorized to be
     *         associated with the hosted zone.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidVpcIdException The VPC ID that you specified either isn't a valid ID or the current account is
     *         not authorized to access this VPC.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.DeleteVPCAssociationAuthorization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteVPCAssociationAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVpcAssociationAuthorizationResponse> deleteVPCAssociationAuthorization(
            DeleteVpcAssociationAuthorizationRequest deleteVpcAssociationAuthorizationRequest) {
        try {

            HttpResponseHandler<DeleteVpcAssociationAuthorizationResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteVpcAssociationAuthorizationResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteVpcAssociationAuthorizationRequest, DeleteVpcAssociationAuthorizationResponse>()
                            .withOperationName("DeleteVPCAssociationAuthorization")
                            .withMarshaller(new DeleteVpcAssociationAuthorizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteVpcAssociationAuthorizationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a VPC from a Amazon Route 53 private hosted zone. Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can't disassociate the last VPC from a private hosted zone.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't convert a private hosted zone into a public hosted zone.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can submit a <code>DisassociateVPCFromHostedZone</code> request using either the account that created the
     * hosted zone or the account that created the VPC.
     * </p>
     * </li>
     * </ul>
     *
     * @param disassociateVpcFromHostedZoneRequest
     *        A complex type that contains information about the VPC that you want to disassociate from a specified
     *        private hosted zone.
     * @return A Java Future containing the result of the DisassociateVPCFromHostedZone operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidVpcIdException The VPC ID that you specified either isn't a valid ID or the current account is
     *         not authorized to access this VPC.</li>
     *         <li>VpcAssociationNotFoundException The specified VPC and hosted zone are not currently associated.</li>
     *         <li>LastVpcAssociationException The VPC that you're trying to disassociate from the private hosted zone
     *         is the last VPC that is associated with the hosted zone. Amazon Route 53 doesn't support disassociating
     *         the last VPC from a hosted zone.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.DisassociateVPCFromHostedZone
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DisassociateVPCFromHostedZone"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateVpcFromHostedZoneResponse> disassociateVPCFromHostedZone(
            DisassociateVpcFromHostedZoneRequest disassociateVpcFromHostedZoneRequest) {
        try {

            HttpResponseHandler<DisassociateVpcFromHostedZoneResponse> responseHandler = protocolFactory.createResponseHandler(
                    DisassociateVpcFromHostedZoneResponse::builder,
                    new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateVpcFromHostedZoneRequest, DisassociateVpcFromHostedZoneResponse>()
                            .withOperationName("DisassociateVPCFromHostedZone")
                            .withMarshaller(new DisassociateVpcFromHostedZoneRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(disassociateVpcFromHostedZoneRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the specified limit for the current account, for example, the maximum number of health checks that you can
     * create using the account.
     * </p>
     * <p>
     * For the default limit, see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the <i>Amazon
     * Route 53 Developer Guide</i>. To request a higher limit, <a href=
     * "https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&amp;limitType=service-code-route53"
     * >open a case</a>.
     * </p>
     *
     * @param getAccountLimitRequest
     *        A complex type that contains information about the request to create a hosted zone.
     * @return A Java Future containing the result of the GetAccountLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetAccountLimit
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetAccountLimit" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetAccountLimitResponse> getAccountLimit(GetAccountLimitRequest getAccountLimitRequest) {
        try {

            HttpResponseHandler<GetAccountLimitResponse> responseHandler = protocolFactory.createResponseHandler(
                    GetAccountLimitResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<GetAccountLimitRequest, GetAccountLimitResponse>()
                    .withOperationName("GetAccountLimit").withMarshaller(new GetAccountLimitRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(getAccountLimitRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the current status of a change batch request. The status is one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> indicates that the changes in this request have not propagated to all Amazon Route 53 DNS
     * servers. This is the initial status of all change batch requests.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSYNC</code> indicates that the changes have propagated to all Route 53 DNS servers.
     * </p>
     * </li>
     * </ul>
     *
     * @param getChangeRequest
     *        The input for a GetChange request.
     * @return A Java Future containing the result of the GetChange operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchChangeException A change with the specified change ID does not exist.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetChange
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetChange" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetChangeResponse> getChange(GetChangeRequest getChangeRequest) {
        try {

            HttpResponseHandler<GetChangeResponse> responseHandler = protocolFactory.createResponseHandler(
                    GetChangeResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<GetChangeRequest, GetChangeResponse>()
                    .withOperationName("GetChange").withMarshaller(new GetChangeRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(getChangeRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <important>
     * <p>
     * <code>GetCheckerIpRanges</code> still works, but we recommend that you download ip-ranges.json, which includes IP
     * address ranges for all AWS services. For more information, see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/route-53-ip-addresses.html">IP Address Ranges of
     * Amazon Route 53 Servers</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * </important>
     *
     * @param getCheckerIpRangesRequest
     * @return A Java Future containing the result of the GetCheckerIpRanges operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetCheckerIpRanges
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetCheckerIpRanges" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetCheckerIpRangesResponse> getCheckerIpRanges(GetCheckerIpRangesRequest getCheckerIpRangesRequest) {
        try {

            HttpResponseHandler<GetCheckerIpRangesResponse> responseHandler = protocolFactory.createResponseHandler(
                    GetCheckerIpRangesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<GetCheckerIpRangesRequest, GetCheckerIpRangesResponse>()
                    .withOperationName("GetCheckerIpRanges")
                    .withMarshaller(new GetCheckerIpRangesRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(getCheckerIpRangesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about whether a specified geographic location is supported for Amazon Route 53 geolocation
     * resource record sets.
     * </p>
     * <p>
     * Use the following syntax to determine whether a continent is supported for geolocation:
     * </p>
     * <p>
     * <code>GET /2013-04-01/geolocation?continentcode=<i>two-letter abbreviation for a continent</i> </code>
     * </p>
     * <p>
     * Use the following syntax to determine whether a country is supported for geolocation:
     * </p>
     * <p>
     * <code>GET /2013-04-01/geolocation?countrycode=<i>two-character country code</i> </code>
     * </p>
     * <p>
     * Use the following syntax to determine whether a subdivision of a country is supported for geolocation:
     * </p>
     * <p>
     * <code>GET /2013-04-01/geolocation?countrycode=<i>two-character country code</i>&amp;subdivisioncode=<i>subdivision code</i> </code>
     * </p>
     *
     * @param getGeoLocationRequest
     *        A request for information about whether a specified geographic location is supported for Amazon Route 53
     *        geolocation resource record sets.
     * @return A Java Future containing the result of the GetGeoLocation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchGeoLocationException Amazon Route 53 doesn't support the specified geographic location.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetGeoLocation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetGeoLocation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetGeoLocationResponse> getGeoLocation(GetGeoLocationRequest getGeoLocationRequest) {
        try {

            HttpResponseHandler<GetGeoLocationResponse> responseHandler = protocolFactory.createResponseHandler(
                    GetGeoLocationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<GetGeoLocationRequest, GetGeoLocationResponse>()
                    .withOperationName("GetGeoLocation").withMarshaller(new GetGeoLocationRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(getGeoLocationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a specified health check.
     * </p>
     *
     * @param getHealthCheckRequest
     *        A request to get information about a specified health check.
     * @return A Java Future containing the result of the GetHealthCheck operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHealthCheckException No health check exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>IncompatibleVersionException The resource you're trying to access is unsupported on this Amazon Route
     *         53 endpoint.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetHealthCheck
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHealthCheck" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetHealthCheckResponse> getHealthCheck(GetHealthCheckRequest getHealthCheckRequest) {
        try {

            HttpResponseHandler<GetHealthCheckResponse> responseHandler = protocolFactory.createResponseHandler(
                    GetHealthCheckResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<GetHealthCheckRequest, GetHealthCheckResponse>()
                    .withOperationName("GetHealthCheck").withMarshaller(new GetHealthCheckRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(getHealthCheckRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the number of health checks that are associated with the current AWS account.
     * </p>
     *
     * @param getHealthCheckCountRequest
     *        A request for the number of health checks that are associated with the current AWS account.
     * @return A Java Future containing the result of the GetHealthCheckCount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetHealthCheckCount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHealthCheckCount" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetHealthCheckCountResponse> getHealthCheckCount(
            GetHealthCheckCountRequest getHealthCheckCountRequest) {
        try {

            HttpResponseHandler<GetHealthCheckCountResponse> responseHandler = protocolFactory.createResponseHandler(
                    GetHealthCheckCountResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<GetHealthCheckCountRequest, GetHealthCheckCountResponse>()
                    .withOperationName("GetHealthCheckCount")
                    .withMarshaller(new GetHealthCheckCountRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(getHealthCheckCountRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the reason that a specified health check failed most recently.
     * </p>
     *
     * @param getHealthCheckLastFailureReasonRequest
     *        A request for the reason that a health check failed most recently.
     * @return A Java Future containing the result of the GetHealthCheckLastFailureReason operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHealthCheckException No health check exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetHealthCheckLastFailureReason
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHealthCheckLastFailureReason"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetHealthCheckLastFailureReasonResponse> getHealthCheckLastFailureReason(
            GetHealthCheckLastFailureReasonRequest getHealthCheckLastFailureReasonRequest) {
        try {

            HttpResponseHandler<GetHealthCheckLastFailureReasonResponse> responseHandler = protocolFactory.createResponseHandler(
                    GetHealthCheckLastFailureReasonResponse::builder,
                    new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<GetHealthCheckLastFailureReasonRequest, GetHealthCheckLastFailureReasonResponse>()
                            .withOperationName("GetHealthCheckLastFailureReason")
                            .withMarshaller(new GetHealthCheckLastFailureReasonRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getHealthCheckLastFailureReasonRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets status of a specified health check.
     * </p>
     *
     * @param getHealthCheckStatusRequest
     *        A request to get the status for a health check.
     * @return A Java Future containing the result of the GetHealthCheckStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHealthCheckException No health check exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetHealthCheckStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHealthCheckStatus" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetHealthCheckStatusResponse> getHealthCheckStatus(
            GetHealthCheckStatusRequest getHealthCheckStatusRequest) {
        try {

            HttpResponseHandler<GetHealthCheckStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    GetHealthCheckStatusResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<GetHealthCheckStatusRequest, GetHealthCheckStatusResponse>()
                    .withOperationName("GetHealthCheckStatus")
                    .withMarshaller(new GetHealthCheckStatusRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(getHealthCheckStatusRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a specified hosted zone including the four name servers assigned to the hosted zone.
     * </p>
     *
     * @param getHostedZoneRequest
     *        A request to get information about a specified hosted zone.
     * @return A Java Future containing the result of the GetHostedZone operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetHostedZone
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHostedZone" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetHostedZoneResponse> getHostedZone(GetHostedZoneRequest getHostedZoneRequest) {
        try {

            HttpResponseHandler<GetHostedZoneResponse> responseHandler = protocolFactory.createResponseHandler(
                    GetHostedZoneResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<GetHostedZoneRequest, GetHostedZoneResponse>()
                    .withOperationName("GetHostedZone").withMarshaller(new GetHostedZoneRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(getHostedZoneRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the number of hosted zones that are associated with the current AWS account.
     * </p>
     *
     * @param getHostedZoneCountRequest
     *        A request to retrieve a count of all the hosted zones that are associated with the current AWS account.
     * @return A Java Future containing the result of the GetHostedZoneCount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetHostedZoneCount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHostedZoneCount" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetHostedZoneCountResponse> getHostedZoneCount(GetHostedZoneCountRequest getHostedZoneCountRequest) {
        try {

            HttpResponseHandler<GetHostedZoneCountResponse> responseHandler = protocolFactory.createResponseHandler(
                    GetHostedZoneCountResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<GetHostedZoneCountRequest, GetHostedZoneCountResponse>()
                    .withOperationName("GetHostedZoneCount")
                    .withMarshaller(new GetHostedZoneCountRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(getHostedZoneCountRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the specified limit for a specified hosted zone, for example, the maximum number of records that you can
     * create in the hosted zone.
     * </p>
     * <p>
     * For the default limit, see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the <i>Amazon
     * Route 53 Developer Guide</i>. To request a higher limit, <a href=
     * "https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&amp;limitType=service-code-route53"
     * >open a case</a>.
     * </p>
     *
     * @param getHostedZoneLimitRequest
     *        A complex type that contains information about the request to create a hosted zone.
     * @return A Java Future containing the result of the GetHostedZoneLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>HostedZoneNotPrivateException The specified hosted zone is a public hosted zone, not a private hosted
     *         zone.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetHostedZoneLimit
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHostedZoneLimit" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetHostedZoneLimitResponse> getHostedZoneLimit(GetHostedZoneLimitRequest getHostedZoneLimitRequest) {
        try {

            HttpResponseHandler<GetHostedZoneLimitResponse> responseHandler = protocolFactory.createResponseHandler(
                    GetHostedZoneLimitResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<GetHostedZoneLimitRequest, GetHostedZoneLimitResponse>()
                    .withOperationName("GetHostedZoneLimit")
                    .withMarshaller(new GetHostedZoneLimitRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(getHostedZoneLimitRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a specified configuration for DNS query logging.
     * </p>
     * <p>
     * For more information about DNS query logs, see <a>CreateQueryLoggingConfig</a> and <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html">Logging DNS Queries</a>.
     * </p>
     *
     * @param getQueryLoggingConfigRequest
     * @return A Java Future containing the result of the GetQueryLoggingConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchQueryLoggingConfigException There is no DNS query logging configuration with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetQueryLoggingConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetQueryLoggingConfig" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetQueryLoggingConfigResponse> getQueryLoggingConfig(
            GetQueryLoggingConfigRequest getQueryLoggingConfigRequest) {
        try {

            HttpResponseHandler<GetQueryLoggingConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    GetQueryLoggingConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<GetQueryLoggingConfigRequest, GetQueryLoggingConfigResponse>()
                    .withOperationName("GetQueryLoggingConfig")
                    .withMarshaller(new GetQueryLoggingConfigRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(getQueryLoggingConfigRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about a specified reusable delegation set, including the four name servers that are
     * assigned to the delegation set.
     * </p>
     *
     * @param getReusableDelegationSetRequest
     *        A request to get information about a specified reusable delegation set.
     * @return A Java Future containing the result of the GetReusableDelegationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchDelegationSetException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>DelegationSetNotReusableException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetReusableDelegationSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetReusableDelegationSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetReusableDelegationSetResponse> getReusableDelegationSet(
            GetReusableDelegationSetRequest getReusableDelegationSetRequest) {
        try {

            HttpResponseHandler<GetReusableDelegationSetResponse> responseHandler = protocolFactory.createResponseHandler(
                    GetReusableDelegationSetResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<GetReusableDelegationSetRequest, GetReusableDelegationSetResponse>()
                            .withOperationName("GetReusableDelegationSet")
                            .withMarshaller(new GetReusableDelegationSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getReusableDelegationSetRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the maximum number of hosted zones that you can associate with the specified reusable delegation set.
     * </p>
     * <p>
     * For the default limit, see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the <i>Amazon
     * Route 53 Developer Guide</i>. To request a higher limit, <a href=
     * "https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&amp;limitType=service-code-route53"
     * >open a case</a>.
     * </p>
     *
     * @param getReusableDelegationSetLimitRequest
     *        A complex type that contains information about the request to create a hosted zone.
     * @return A Java Future containing the result of the GetReusableDelegationSetLimit operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchDelegationSetException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetReusableDelegationSetLimit
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetReusableDelegationSetLimit"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetReusableDelegationSetLimitResponse> getReusableDelegationSetLimit(
            GetReusableDelegationSetLimitRequest getReusableDelegationSetLimitRequest) {
        try {

            HttpResponseHandler<GetReusableDelegationSetLimitResponse> responseHandler = protocolFactory.createResponseHandler(
                    GetReusableDelegationSetLimitResponse::builder,
                    new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<GetReusableDelegationSetLimitRequest, GetReusableDelegationSetLimitResponse>()
                            .withOperationName("GetReusableDelegationSetLimit")
                            .withMarshaller(new GetReusableDelegationSetLimitRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getReusableDelegationSetLimitRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a specific traffic policy version.
     * </p>
     *
     * @param getTrafficPolicyRequest
     *        Gets information about a specific traffic policy version.
     * @return A Java Future containing the result of the GetTrafficPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchTrafficPolicyException No traffic policy exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetTrafficPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetTrafficPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetTrafficPolicyResponse> getTrafficPolicy(GetTrafficPolicyRequest getTrafficPolicyRequest) {
        try {

            HttpResponseHandler<GetTrafficPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    GetTrafficPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<GetTrafficPolicyRequest, GetTrafficPolicyResponse>()
                    .withOperationName("GetTrafficPolicy").withMarshaller(new GetTrafficPolicyRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(getTrafficPolicyRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a specified traffic policy instance.
     * </p>
     * <note>
     * <p>
     * After you submit a <code>CreateTrafficPolicyInstance</code> or an <code>UpdateTrafficPolicyInstance</code>
     * request, there's a brief delay while Amazon Route 53 creates the resource record sets that are specified in the
     * traffic policy definition. For more information, see the <code>State</code> response element.
     * </p>
     * </note> <note>
     * <p>
     * In the Route 53 console, traffic policy instances are known as policy records.
     * </p>
     * </note>
     *
     * @param getTrafficPolicyInstanceRequest
     *        Gets information about a specified traffic policy instance.
     * @return A Java Future containing the result of the GetTrafficPolicyInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchTrafficPolicyInstanceException No traffic policy instance exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetTrafficPolicyInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetTrafficPolicyInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetTrafficPolicyInstanceResponse> getTrafficPolicyInstance(
            GetTrafficPolicyInstanceRequest getTrafficPolicyInstanceRequest) {
        try {

            HttpResponseHandler<GetTrafficPolicyInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    GetTrafficPolicyInstanceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<GetTrafficPolicyInstanceRequest, GetTrafficPolicyInstanceResponse>()
                            .withOperationName("GetTrafficPolicyInstance")
                            .withMarshaller(new GetTrafficPolicyInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getTrafficPolicyInstanceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the number of traffic policy instances that are associated with the current AWS account.
     * </p>
     *
     * @param getTrafficPolicyInstanceCountRequest
     *        Request to get the number of traffic policy instances that are associated with the current AWS account.
     * @return A Java Future containing the result of the GetTrafficPolicyInstanceCount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.GetTrafficPolicyInstanceCount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetTrafficPolicyInstanceCount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetTrafficPolicyInstanceCountResponse> getTrafficPolicyInstanceCount(
            GetTrafficPolicyInstanceCountRequest getTrafficPolicyInstanceCountRequest) {
        try {

            HttpResponseHandler<GetTrafficPolicyInstanceCountResponse> responseHandler = protocolFactory.createResponseHandler(
                    GetTrafficPolicyInstanceCountResponse::builder,
                    new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<GetTrafficPolicyInstanceCountRequest, GetTrafficPolicyInstanceCountResponse>()
                            .withOperationName("GetTrafficPolicyInstanceCount")
                            .withMarshaller(new GetTrafficPolicyInstanceCountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getTrafficPolicyInstanceCountRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of supported geographic locations.
     * </p>
     * <p>
     * Countries are listed first, and continents are listed last. If Amazon Route 53 supports subdivisions for a
     * country (for example, states or provinces), the subdivisions for that country are listed in alphabetical order
     * immediately after the corresponding country.
     * </p>
     *
     * @param listGeoLocationsRequest
     *        A request to get a list of geographic locations that Amazon Route 53 supports for geolocation resource
     *        record sets.
     * @return A Java Future containing the result of the ListGeoLocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListGeoLocations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListGeoLocations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListGeoLocationsResponse> listGeoLocations(ListGeoLocationsRequest listGeoLocationsRequest) {
        try {

            HttpResponseHandler<ListGeoLocationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    ListGeoLocationsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<ListGeoLocationsRequest, ListGeoLocationsResponse>()
                    .withOperationName("ListGeoLocations").withMarshaller(new ListGeoLocationsRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(listGeoLocationsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieve a list of the health checks that are associated with the current AWS account.
     * </p>
     *
     * @param listHealthChecksRequest
     *        A request to retrieve a list of the health checks that are associated with the current AWS account.
     * @return A Java Future containing the result of the ListHealthChecks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>IncompatibleVersionException The resource you're trying to access is unsupported on this Amazon Route
     *         53 endpoint.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListHealthChecks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHealthChecks" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListHealthChecksResponse> listHealthChecks(ListHealthChecksRequest listHealthChecksRequest) {
        try {

            HttpResponseHandler<ListHealthChecksResponse> responseHandler = protocolFactory.createResponseHandler(
                    ListHealthChecksResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<ListHealthChecksRequest, ListHealthChecksResponse>()
                    .withOperationName("ListHealthChecks").withMarshaller(new ListHealthChecksRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(listHealthChecksRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieve a list of the health checks that are associated with the current AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listHealthChecks(software.amazon.awssdk.services.route53.model.ListHealthChecksRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListHealthChecksPublisher publisher = client.listHealthChecksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListHealthChecksPublisher publisher = client.listHealthChecksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53.model.ListHealthChecksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53.model.ListHealthChecksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHealthChecks(software.amazon.awssdk.services.route53.model.ListHealthChecksRequest)} operation.</b>
     * </p>
     *
     * @param listHealthChecksRequest
     *        A request to retrieve a list of the health checks that are associated with the current AWS account.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>IncompatibleVersionException The resource you're trying to access is unsupported on this Amazon Route
     *         53 endpoint.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListHealthChecks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHealthChecks" target="_top">AWS API
     *      Documentation</a>
     */
    public ListHealthChecksPublisher listHealthChecksPaginator(ListHealthChecksRequest listHealthChecksRequest) {
        return new ListHealthChecksPublisher(this, applyPaginatorUserAgent(listHealthChecksRequest));
    }

    /**
     * <p>
     * Retrieves a list of the public and private hosted zones that are associated with the current AWS account. The
     * response includes a <code>HostedZones</code> child element for each hosted zone.
     * </p>
     * <p>
     * Amazon Route 53 returns a maximum of 100 items in each response. If you have a lot of hosted zones, you can use
     * the <code>maxitems</code> parameter to list them in groups of up to 100.
     * </p>
     *
     * @param listHostedZonesRequest
     *        A request to retrieve a list of the public and private hosted zones that are associated with the current
     *        AWS account.
     * @return A Java Future containing the result of the ListHostedZones operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchDelegationSetException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>DelegationSetNotReusableException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListHostedZones
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHostedZones" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListHostedZonesResponse> listHostedZones(ListHostedZonesRequest listHostedZonesRequest) {
        try {

            HttpResponseHandler<ListHostedZonesResponse> responseHandler = protocolFactory.createResponseHandler(
                    ListHostedZonesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<ListHostedZonesRequest, ListHostedZonesResponse>()
                    .withOperationName("ListHostedZones").withMarshaller(new ListHostedZonesRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(listHostedZonesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of your hosted zones in lexicographic order. The response includes a <code>HostedZones</code>
     * child element for each hosted zone created by the current AWS account.
     * </p>
     * <p>
     * <code>ListHostedZonesByName</code> sorts hosted zones by name with the labels reversed. For example:
     * </p>
     * <p>
     * <code>com.example.www.</code>
     * </p>
     * <p>
     * Note the trailing dot, which can change the sort order in some circumstances.
     * </p>
     * <p>
     * If the domain name includes escape characters or Punycode, <code>ListHostedZonesByName</code> alphabetizes the
     * domain name using the escaped or Punycoded value, which is the format that Amazon Route 53 saves in its database.
     * For example, to create a hosted zone for exämple.com, you specify ex\344mple.com for the domain name.
     * <code>ListHostedZonesByName</code> alphabetizes it as:
     * </p>
     * <p>
     * <code>com.ex\344mple.</code>
     * </p>
     * <p>
     * The labels are reversed and alphabetized using the escaped value. For more information about valid domain name
     * formats, including internationalized domain names, see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html">DNS Domain Name Format</a>
     * in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * Route 53 returns up to 100 items in each response. If you have a lot of hosted zones, use the
     * <code>MaxItems</code> parameter to list them in groups of up to 100. The response includes values that help
     * navigate from one group of <code>MaxItems</code> hosted zones to the next:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>DNSName</code> and <code>HostedZoneId</code> elements in the response contain the values, if any,
     * specified for the <code>dnsname</code> and <code>hostedzoneid</code> parameters in the request that produced the
     * current response.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>MaxItems</code> element in the response contains the value, if any, that you specified for the
     * <code>maxitems</code> parameter in the request that produced the current response.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the value of <code>IsTruncated</code> in the response is true, there are more hosted zones associated with the
     * current AWS account.
     * </p>
     * <p>
     * If <code>IsTruncated</code> is false, this response includes the last hosted zone that is associated with the
     * current account. The <code>NextDNSName</code> element and <code>NextHostedZoneId</code> elements are omitted from
     * the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>NextDNSName</code> and <code>NextHostedZoneId</code> elements in the response contain the domain name
     * and the hosted zone ID of the next hosted zone that is associated with the current AWS account. If you want to
     * list more hosted zones, make another call to <code>ListHostedZonesByName</code>, and specify the value of
     * <code>NextDNSName</code> and <code>NextHostedZoneId</code> in the <code>dnsname</code> and
     * <code>hostedzoneid</code> parameters, respectively.
     * </p>
     * </li>
     * </ul>
     *
     * @param listHostedZonesByNameRequest
     *        Retrieves a list of the public and private hosted zones that are associated with the current AWS account
     *        in ASCII order by domain name.
     * @return A Java Future containing the result of the ListHostedZonesByName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>InvalidDomainNameException The specified domain name is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListHostedZonesByName
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHostedZonesByName" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListHostedZonesByNameResponse> listHostedZonesByName(
            ListHostedZonesByNameRequest listHostedZonesByNameRequest) {
        try {

            HttpResponseHandler<ListHostedZonesByNameResponse> responseHandler = protocolFactory.createResponseHandler(
                    ListHostedZonesByNameResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<ListHostedZonesByNameRequest, ListHostedZonesByNameResponse>()
                    .withOperationName("ListHostedZonesByName")
                    .withMarshaller(new ListHostedZonesByNameRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(listHostedZonesByNameRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of the public and private hosted zones that are associated with the current AWS account. The
     * response includes a <code>HostedZones</code> child element for each hosted zone.
     * </p>
     * <p>
     * Amazon Route 53 returns a maximum of 100 items in each response. If you have a lot of hosted zones, you can use
     * the <code>maxitems</code> parameter to list them in groups of up to 100.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listHostedZones(software.amazon.awssdk.services.route53.model.ListHostedZonesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListHostedZonesPublisher publisher = client.listHostedZonesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListHostedZonesPublisher publisher = client.listHostedZonesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53.model.ListHostedZonesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53.model.ListHostedZonesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHostedZones(software.amazon.awssdk.services.route53.model.ListHostedZonesRequest)} operation.</b>
     * </p>
     *
     * @param listHostedZonesRequest
     *        A request to retrieve a list of the public and private hosted zones that are associated with the current
     *        AWS account.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchDelegationSetException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>DelegationSetNotReusableException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListHostedZones
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHostedZones" target="_top">AWS API
     *      Documentation</a>
     */
    public ListHostedZonesPublisher listHostedZonesPaginator(ListHostedZonesRequest listHostedZonesRequest) {
        return new ListHostedZonesPublisher(this, applyPaginatorUserAgent(listHostedZonesRequest));
    }

    /**
     * <p>
     * Lists the configurations for DNS query logging that are associated with the current AWS account or the
     * configuration that is associated with a specified hosted zone.
     * </p>
     * <p>
     * For more information about DNS query logs, see <a>CreateQueryLoggingConfig</a>. Additional information, including
     * the format of DNS query logs, appears in <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html">Logging DNS Queries</a> in the
     * <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     *
     * @param listQueryLoggingConfigsRequest
     * @return A Java Future containing the result of the ListQueryLoggingConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>InvalidPaginationTokenException The value that you specified to get the second or subsequent page of
     *         results is invalid.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListQueryLoggingConfigs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListQueryLoggingConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListQueryLoggingConfigsResponse> listQueryLoggingConfigs(
            ListQueryLoggingConfigsRequest listQueryLoggingConfigsRequest) {
        try {

            HttpResponseHandler<ListQueryLoggingConfigsResponse> responseHandler = protocolFactory.createResponseHandler(
                    ListQueryLoggingConfigsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<ListQueryLoggingConfigsRequest, ListQueryLoggingConfigsResponse>()
                            .withOperationName("ListQueryLoggingConfigs")
                            .withMarshaller(new ListQueryLoggingConfigsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listQueryLoggingConfigsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the resource record sets in a specified hosted zone.
     * </p>
     * <p>
     * <code>ListResourceRecordSets</code> returns up to 100 resource record sets at a time in ASCII order, beginning at
     * a position specified by the <code>name</code> and <code>type</code> elements.
     * </p>
     * <p>
     * <b>Sort order</b>
     * </p>
     * <p>
     * <code>ListResourceRecordSets</code> sorts results first by DNS name with the labels reversed, for example:
     * </p>
     * <p>
     * <code>com.example.www.</code>
     * </p>
     * <p>
     * Note the trailing dot, which can change the sort order when the record name contains characters that appear
     * before <code>.</code> (decimal 46) in the ASCII table. These characters include the following:
     * <code>! " # &#36 % &amp; ' ( ) * + , -</code>
     * </p>
     * <p>
     * When multiple records have the same DNS name, <code>ListResourceRecordSets</code> sorts results by the record
     * type.
     * </p>
     * <p>
     * <b>Specifying where to start listing records</b>
     * </p>
     * <p>
     * You can use the name and type elements to specify the resource record set that the list begins with:
     * </p>
     * <dl>
     * <dt>If you do not specify Name or Type</dt>
     * <dd>
     * <p>
     * The results begin with the first resource record set that the hosted zone contains.
     * </p>
     * </dd>
     * <dt>If you specify Name but not Type</dt>
     * <dd>
     * <p>
     * The results begin with the first resource record set in the list whose name is greater than or equal to
     * <code>Name</code>.
     * </p>
     * </dd>
     * <dt>If you specify Type but not Name</dt>
     * <dd>
     * <p>
     * Amazon Route 53 returns the <code>InvalidInput</code> error.
     * </p>
     * </dd>
     * <dt>If you specify both Name and Type</dt>
     * <dd>
     * <p>
     * The results begin with the first resource record set in the list whose name is greater than or equal to
     * <code>Name</code>, and whose type is greater than or equal to <code>Type</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * <b>Resource record sets that are PENDING</b>
     * </p>
     * <p>
     * This action returns the most current version of the records. This includes records that are <code>PENDING</code>,
     * and that are not yet available on all Route 53 DNS servers.
     * </p>
     * <p>
     * <b>Changing resource record sets</b>
     * </p>
     * <p>
     * To ensure that you get an accurate listing of the resource record sets for a hosted zone at a point in time, do
     * not submit a <code>ChangeResourceRecordSets</code> request while you're paging through the results of a
     * <code>ListResourceRecordSets</code> request. If you do, some pages may display results without the latest changes
     * while other pages display results with the latest changes.
     * </p>
     * <p>
     * <b>Displaying the next page of results</b>
     * </p>
     * <p>
     * If a <code>ListResourceRecordSets</code> command returns more than one page of results, the value of
     * <code>IsTruncated</code> is <code>true</code>. To display the next page of results, get the values of
     * <code>NextRecordName</code>, <code>NextRecordType</code>, and <code>NextRecordIdentifier</code> (if any) from the
     * response. Then submit another <code>ListResourceRecordSets</code> request, and specify those values for
     * <code>StartRecordName</code>, <code>StartRecordType</code>, and <code>StartRecordIdentifier</code>.
     * </p>
     *
     * @param listResourceRecordSetsRequest
     *        A request for the resource record sets that are associated with a specified hosted zone.
     * @return A Java Future containing the result of the ListResourceRecordSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListResourceRecordSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListResourceRecordSets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListResourceRecordSetsResponse> listResourceRecordSets(
            ListResourceRecordSetsRequest listResourceRecordSetsRequest) {
        try {

            HttpResponseHandler<ListResourceRecordSetsResponse> responseHandler = protocolFactory.createResponseHandler(
                    ListResourceRecordSetsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<ListResourceRecordSetsRequest, ListResourceRecordSetsResponse>()
                            .withOperationName("ListResourceRecordSets")
                            .withMarshaller(new ListResourceRecordSetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listResourceRecordSetsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the resource record sets in a specified hosted zone.
     * </p>
     * <p>
     * <code>ListResourceRecordSets</code> returns up to 100 resource record sets at a time in ASCII order, beginning at
     * a position specified by the <code>name</code> and <code>type</code> elements.
     * </p>
     * <p>
     * <b>Sort order</b>
     * </p>
     * <p>
     * <code>ListResourceRecordSets</code> sorts results first by DNS name with the labels reversed, for example:
     * </p>
     * <p>
     * <code>com.example.www.</code>
     * </p>
     * <p>
     * Note the trailing dot, which can change the sort order when the record name contains characters that appear
     * before <code>.</code> (decimal 46) in the ASCII table. These characters include the following:
     * <code>! " # &#36 % &amp; ' ( ) * + , -</code>
     * </p>
     * <p>
     * When multiple records have the same DNS name, <code>ListResourceRecordSets</code> sorts results by the record
     * type.
     * </p>
     * <p>
     * <b>Specifying where to start listing records</b>
     * </p>
     * <p>
     * You can use the name and type elements to specify the resource record set that the list begins with:
     * </p>
     * <dl>
     * <dt>If you do not specify Name or Type</dt>
     * <dd>
     * <p>
     * The results begin with the first resource record set that the hosted zone contains.
     * </p>
     * </dd>
     * <dt>If you specify Name but not Type</dt>
     * <dd>
     * <p>
     * The results begin with the first resource record set in the list whose name is greater than or equal to
     * <code>Name</code>.
     * </p>
     * </dd>
     * <dt>If you specify Type but not Name</dt>
     * <dd>
     * <p>
     * Amazon Route 53 returns the <code>InvalidInput</code> error.
     * </p>
     * </dd>
     * <dt>If you specify both Name and Type</dt>
     * <dd>
     * <p>
     * The results begin with the first resource record set in the list whose name is greater than or equal to
     * <code>Name</code>, and whose type is greater than or equal to <code>Type</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * <b>Resource record sets that are PENDING</b>
     * </p>
     * <p>
     * This action returns the most current version of the records. This includes records that are <code>PENDING</code>,
     * and that are not yet available on all Route 53 DNS servers.
     * </p>
     * <p>
     * <b>Changing resource record sets</b>
     * </p>
     * <p>
     * To ensure that you get an accurate listing of the resource record sets for a hosted zone at a point in time, do
     * not submit a <code>ChangeResourceRecordSets</code> request while you're paging through the results of a
     * <code>ListResourceRecordSets</code> request. If you do, some pages may display results without the latest changes
     * while other pages display results with the latest changes.
     * </p>
     * <p>
     * <b>Displaying the next page of results</b>
     * </p>
     * <p>
     * If a <code>ListResourceRecordSets</code> command returns more than one page of results, the value of
     * <code>IsTruncated</code> is <code>true</code>. To display the next page of results, get the values of
     * <code>NextRecordName</code>, <code>NextRecordType</code>, and <code>NextRecordIdentifier</code> (if any) from the
     * response. Then submit another <code>ListResourceRecordSets</code> request, and specify those values for
     * <code>StartRecordName</code>, <code>StartRecordType</code>, and <code>StartRecordIdentifier</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceRecordSets(software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListResourceRecordSetsPublisher publisher = client.listResourceRecordSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53.paginators.ListResourceRecordSetsPublisher publisher = client.listResourceRecordSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53.model.ListResourceRecordSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53.model.ListResourceRecordSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceRecordSets(software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceRecordSetsRequest
     *        A request for the resource record sets that are associated with a specified hosted zone.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListResourceRecordSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListResourceRecordSets" target="_top">AWS
     *      API Documentation</a>
     */
    public ListResourceRecordSetsPublisher listResourceRecordSetsPaginator(
            ListResourceRecordSetsRequest listResourceRecordSetsRequest) {
        return new ListResourceRecordSetsPublisher(this, applyPaginatorUserAgent(listResourceRecordSetsRequest));
    }

    /**
     * <p>
     * Retrieves a list of the reusable delegation sets that are associated with the current AWS account.
     * </p>
     *
     * @param listReusableDelegationSetsRequest
     *        A request to get a list of the reusable delegation sets that are associated with the current AWS account.
     * @return A Java Future containing the result of the ListReusableDelegationSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListReusableDelegationSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListReusableDelegationSets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListReusableDelegationSetsResponse> listReusableDelegationSets(
            ListReusableDelegationSetsRequest listReusableDelegationSetsRequest) {
        try {

            HttpResponseHandler<ListReusableDelegationSetsResponse> responseHandler = protocolFactory.createResponseHandler(
                    ListReusableDelegationSetsResponse::builder,
                    new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<ListReusableDelegationSetsRequest, ListReusableDelegationSetsResponse>()
                            .withOperationName("ListReusableDelegationSets")
                            .withMarshaller(new ListReusableDelegationSetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listReusableDelegationSetsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists tags for one health check or hosted zone.
     * </p>
     * <p>
     * For information about using tags for cost allocation, see <a
     * href="http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation
     * Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A complex type containing information about a request for a list of the tags that are associated with an
     *        individual resource.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchHealthCheckException No health check exists with the specified ID.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>PriorRequestNotCompleteException If Amazon Route 53 can't process a request before the next request
     *         arrives, it will reject subsequent requests for the same hosted zone and return an
     *         <code>HTTP 400 error</code> (<code>Bad request</code>). If Route 53 returns this error repeatedly for the
     *         same request, we recommend that you wait, in intervals of increasing duration, before you try the request
     *         again.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        try {

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    ListTagsForResourceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource")
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(listTagsForResourceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists tags for up to 10 health checks or hosted zones.
     * </p>
     * <p>
     * For information about using tags for cost allocation, see <a
     * href="http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation
     * Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
     * </p>
     *
     * @param listTagsForResourcesRequest
     *        A complex type that contains information about the health checks or hosted zones for which you want to
     *        list tags.
     * @return A Java Future containing the result of the ListTagsForResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchHealthCheckException No health check exists with the specified ID.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>PriorRequestNotCompleteException If Amazon Route 53 can't process a request before the next request
     *         arrives, it will reject subsequent requests for the same hosted zone and return an
     *         <code>HTTP 400 error</code> (<code>Bad request</code>). If Route 53 returns this error repeatedly for the
     *         same request, we recommend that you wait, in intervals of increasing duration, before you try the request
     *         again.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListTagsForResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTagsForResources" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourcesResponse> listTagsForResources(
            ListTagsForResourcesRequest listTagsForResourcesRequest) {
        try {

            HttpResponseHandler<ListTagsForResourcesResponse> responseHandler = protocolFactory.createResponseHandler(
                    ListTagsForResourcesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourcesRequest, ListTagsForResourcesResponse>()
                    .withOperationName("ListTagsForResources")
                    .withMarshaller(new ListTagsForResourcesRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(listTagsForResourcesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the latest version for every traffic policy that is associated with the current AWS
     * account. Policies are listed in the order that they were created in.
     * </p>
     *
     * @param listTrafficPoliciesRequest
     *        A complex type that contains the information about the request to list the traffic policies that are
     *        associated with the current AWS account.
     * @return A Java Future containing the result of the ListTrafficPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListTrafficPolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTrafficPoliciesResponse> listTrafficPolicies(
            ListTrafficPoliciesRequest listTrafficPoliciesRequest) {
        try {

            HttpResponseHandler<ListTrafficPoliciesResponse> responseHandler = protocolFactory.createResponseHandler(
                    ListTrafficPoliciesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<ListTrafficPoliciesRequest, ListTrafficPoliciesResponse>()
                    .withOperationName("ListTrafficPolicies")
                    .withMarshaller(new ListTrafficPoliciesRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(listTrafficPoliciesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the traffic policy instances that you created by using the current AWS account.
     * </p>
     * <note>
     * <p>
     * After you submit an <code>UpdateTrafficPolicyInstance</code> request, there's a brief delay while Amazon Route 53
     * creates the resource record sets that are specified in the traffic policy definition. For more information, see
     * the <code>State</code> response element.
     * </p>
     * </note>
     * <p>
     * Route 53 returns a maximum of 100 items in each response. If you have a lot of traffic policy instances, you can
     * use the <code>MaxItems</code> parameter to list them in groups of up to 100.
     * </p>
     *
     * @param listTrafficPolicyInstancesRequest
     *        A request to get information about the traffic policy instances that you created by using the current AWS
     *        account.
     * @return A Java Future containing the result of the ListTrafficPolicyInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchTrafficPolicyInstanceException No traffic policy instance exists with the specified ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListTrafficPolicyInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicyInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTrafficPolicyInstancesResponse> listTrafficPolicyInstances(
            ListTrafficPolicyInstancesRequest listTrafficPolicyInstancesRequest) {
        try {

            HttpResponseHandler<ListTrafficPolicyInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                    ListTrafficPolicyInstancesResponse::builder,
                    new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<ListTrafficPolicyInstancesRequest, ListTrafficPolicyInstancesResponse>()
                            .withOperationName("ListTrafficPolicyInstances")
                            .withMarshaller(new ListTrafficPolicyInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listTrafficPolicyInstancesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the traffic policy instances that you created in a specified hosted zone.
     * </p>
     * <note>
     * <p>
     * After you submit a <code>CreateTrafficPolicyInstance</code> or an <code>UpdateTrafficPolicyInstance</code>
     * request, there's a brief delay while Amazon Route 53 creates the resource record sets that are specified in the
     * traffic policy definition. For more information, see the <code>State</code> response element.
     * </p>
     * </note>
     * <p>
     * Route 53 returns a maximum of 100 items in each response. If you have a lot of traffic policy instances, you can
     * use the <code>MaxItems</code> parameter to list them in groups of up to 100.
     * </p>
     *
     * @param listTrafficPolicyInstancesByHostedZoneRequest
     *        A request for the traffic policy instances that you created in a specified hosted zone.
     * @return A Java Future containing the result of the ListTrafficPolicyInstancesByHostedZone operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchTrafficPolicyInstanceException No traffic policy instance exists with the specified ID.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListTrafficPolicyInstancesByHostedZone
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicyInstancesByHostedZone"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTrafficPolicyInstancesByHostedZoneResponse> listTrafficPolicyInstancesByHostedZone(
            ListTrafficPolicyInstancesByHostedZoneRequest listTrafficPolicyInstancesByHostedZoneRequest) {
        try {

            HttpResponseHandler<ListTrafficPolicyInstancesByHostedZoneResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListTrafficPolicyInstancesByHostedZoneResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<ListTrafficPolicyInstancesByHostedZoneRequest, ListTrafficPolicyInstancesByHostedZoneResponse>()
                            .withOperationName("ListTrafficPolicyInstancesByHostedZone")
                            .withMarshaller(new ListTrafficPolicyInstancesByHostedZoneRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listTrafficPolicyInstancesByHostedZoneRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the traffic policy instances that you created by using a specify traffic policy version.
     * </p>
     * <note>
     * <p>
     * After you submit a <code>CreateTrafficPolicyInstance</code> or an <code>UpdateTrafficPolicyInstance</code>
     * request, there's a brief delay while Amazon Route 53 creates the resource record sets that are specified in the
     * traffic policy definition. For more information, see the <code>State</code> response element.
     * </p>
     * </note>
     * <p>
     * Route 53 returns a maximum of 100 items in each response. If you have a lot of traffic policy instances, you can
     * use the <code>MaxItems</code> parameter to list them in groups of up to 100.
     * </p>
     *
     * @param listTrafficPolicyInstancesByPolicyRequest
     *        A complex type that contains the information about the request to list your traffic policy instances.
     * @return A Java Future containing the result of the ListTrafficPolicyInstancesByPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchTrafficPolicyInstanceException No traffic policy instance exists with the specified ID.</li>
     *         <li>NoSuchTrafficPolicyException No traffic policy exists with the specified ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListTrafficPolicyInstancesByPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicyInstancesByPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTrafficPolicyInstancesByPolicyResponse> listTrafficPolicyInstancesByPolicy(
            ListTrafficPolicyInstancesByPolicyRequest listTrafficPolicyInstancesByPolicyRequest) {
        try {

            HttpResponseHandler<ListTrafficPolicyInstancesByPolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListTrafficPolicyInstancesByPolicyResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<ListTrafficPolicyInstancesByPolicyRequest, ListTrafficPolicyInstancesByPolicyResponse>()
                            .withOperationName("ListTrafficPolicyInstancesByPolicy")
                            .withMarshaller(new ListTrafficPolicyInstancesByPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listTrafficPolicyInstancesByPolicyRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about all of the versions for a specified traffic policy.
     * </p>
     * <p>
     * Traffic policy versions are listed in numerical order by <code>VersionNumber</code>.
     * </p>
     *
     * @param listTrafficPolicyVersionsRequest
     *        A complex type that contains the information about the request to list your traffic policies.
     * @return A Java Future containing the result of the ListTrafficPolicyVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchTrafficPolicyException No traffic policy exists with the specified ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListTrafficPolicyVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicyVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTrafficPolicyVersionsResponse> listTrafficPolicyVersions(
            ListTrafficPolicyVersionsRequest listTrafficPolicyVersionsRequest) {
        try {

            HttpResponseHandler<ListTrafficPolicyVersionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListTrafficPolicyVersionsResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<ListTrafficPolicyVersionsRequest, ListTrafficPolicyVersionsResponse>()
                            .withOperationName("ListTrafficPolicyVersions")
                            .withMarshaller(new ListTrafficPolicyVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listTrafficPolicyVersionsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of the VPCs that were created by other accounts and that can be associated with a specified hosted
     * zone because you've submitted one or more <code>CreateVPCAssociationAuthorization</code> requests.
     * </p>
     * <p>
     * The response includes a <code>VPCs</code> element with a <code>VPC</code> child element for each VPC that can be
     * associated with the hosted zone.
     * </p>
     *
     * @param listVpcAssociationAuthorizationsRequest
     *        A complex type that contains information about that can be associated with your hosted zone.
     * @return A Java Future containing the result of the ListVPCAssociationAuthorizations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>InvalidPaginationTokenException The value that you specified to get the second or subsequent page of
     *         results is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.ListVPCAssociationAuthorizations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListVPCAssociationAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListVpcAssociationAuthorizationsResponse> listVPCAssociationAuthorizations(
            ListVpcAssociationAuthorizationsRequest listVpcAssociationAuthorizationsRequest) {
        try {

            HttpResponseHandler<ListVpcAssociationAuthorizationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListVpcAssociationAuthorizationsResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<ListVpcAssociationAuthorizationsRequest, ListVpcAssociationAuthorizationsResponse>()
                            .withOperationName("ListVPCAssociationAuthorizations")
                            .withMarshaller(new ListVpcAssociationAuthorizationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listVpcAssociationAuthorizationsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the value that Amazon Route 53 returns in response to a DNS request for a specified record name and type.
     * You can optionally specify the IP address of a DNS resolver, an EDNS0 client subnet IP address, and a subnet
     * mask.
     * </p>
     *
     * @param testDnsAnswerRequest
     *        Gets the value that Amazon Route 53 returns in response to a DNS request for a specified record name and
     *        type. You can optionally specify the IP address of a DNS resolver, an EDNS0 client subnet IP address, and
     *        a subnet mask.
     * @return A Java Future containing the result of the TestDNSAnswer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.TestDNSAnswer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/TestDNSAnswer" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TestDnsAnswerResponse> testDNSAnswer(TestDnsAnswerRequest testDnsAnswerRequest) {
        try {

            HttpResponseHandler<TestDnsAnswerResponse> responseHandler = protocolFactory.createResponseHandler(
                    TestDnsAnswerResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<TestDnsAnswerRequest, TestDnsAnswerResponse>()
                    .withOperationName("TestDNSAnswer").withMarshaller(new TestDnsAnswerRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(testDnsAnswerRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing health check. Note that some values can't be updated.
     * </p>
     * <p>
     * For more information about updating health checks, see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/health-checks-creating-deleting.html">Creating,
     * Updating, and Deleting Health Checks</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     *
     * @param updateHealthCheckRequest
     *        A complex type that contains information about a request to update a health check.
     * @return A Java Future containing the result of the UpdateHealthCheck operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHealthCheckException No health check exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>HealthCheckVersionMismatchException The value of <code>HealthCheckVersion</code> in the request
     *         doesn't match the value of <code>HealthCheckVersion</code> in the health check.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.UpdateHealthCheck
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/UpdateHealthCheck" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateHealthCheckResponse> updateHealthCheck(UpdateHealthCheckRequest updateHealthCheckRequest) {
        try {

            HttpResponseHandler<UpdateHealthCheckResponse> responseHandler = protocolFactory.createResponseHandler(
                    UpdateHealthCheckResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<UpdateHealthCheckRequest, UpdateHealthCheckResponse>()
                    .withOperationName("UpdateHealthCheck")
                    .withMarshaller(new UpdateHealthCheckRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateHealthCheckRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the comment for a specified hosted zone.
     * </p>
     *
     * @param updateHostedZoneCommentRequest
     *        A request to update the comment for a hosted zone.
     * @return A Java Future containing the result of the UpdateHostedZoneComment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.UpdateHostedZoneComment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/UpdateHostedZoneComment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateHostedZoneCommentResponse> updateHostedZoneComment(
            UpdateHostedZoneCommentRequest updateHostedZoneCommentRequest) {
        try {

            HttpResponseHandler<UpdateHostedZoneCommentResponse> responseHandler = protocolFactory.createResponseHandler(
                    UpdateHostedZoneCommentResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateHostedZoneCommentRequest, UpdateHostedZoneCommentResponse>()
                            .withOperationName("UpdateHostedZoneComment")
                            .withMarshaller(new UpdateHostedZoneCommentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateHostedZoneCommentRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the comment for a specified traffic policy version.
     * </p>
     *
     * @param updateTrafficPolicyCommentRequest
     *        A complex type that contains information about the traffic policy that you want to update the comment for.
     * @return A Java Future containing the result of the UpdateTrafficPolicyComment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchTrafficPolicyException No traffic policy exists with the specified ID.</li>
     *         <li>ConcurrentModificationException Another user submitted a request to create, update, or delete the
     *         object at the same time that you did. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.UpdateTrafficPolicyComment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/UpdateTrafficPolicyComment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateTrafficPolicyCommentResponse> updateTrafficPolicyComment(
            UpdateTrafficPolicyCommentRequest updateTrafficPolicyCommentRequest) {
        try {

            HttpResponseHandler<UpdateTrafficPolicyCommentResponse> responseHandler = protocolFactory.createResponseHandler(
                    UpdateTrafficPolicyCommentResponse::builder,
                    new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateTrafficPolicyCommentRequest, UpdateTrafficPolicyCommentResponse>()
                            .withOperationName("UpdateTrafficPolicyComment")
                            .withMarshaller(new UpdateTrafficPolicyCommentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateTrafficPolicyCommentRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the resource record sets in a specified hosted zone that were created based on the settings in a
     * specified traffic policy version.
     * </p>
     * <p>
     * When you update a traffic policy instance, Amazon Route 53 continues to respond to DNS queries for the root
     * resource record set name (such as example.com) while it replaces one group of resource record sets with another.
     * Route 53 performs the following operations:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Route 53 creates a new group of resource record sets based on the specified traffic policy. This is true
     * regardless of how significant the differences are between the existing resource record sets and the new resource
     * record sets.
     * </p>
     * </li>
     * <li>
     * <p>
     * When all of the new resource record sets have been created, Route 53 starts to respond to DNS queries for the
     * root resource record set name (such as example.com) by using the new resource record sets.
     * </p>
     * </li>
     * <li>
     * <p>
     * Route 53 deletes the old group of resource record sets that are associated with the root resource record set
     * name.
     * </p>
     * </li>
     * </ol>
     *
     * @param updateTrafficPolicyInstanceRequest
     *        A complex type that contains information about the resource record sets that you want to update based on a
     *        specified traffic policy instance.
     * @return A Java Future containing the result of the UpdateTrafficPolicyInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchTrafficPolicyException No traffic policy exists with the specified ID.</li>
     *         <li>NoSuchTrafficPolicyInstanceException No traffic policy instance exists with the specified ID.</li>
     *         <li>PriorRequestNotCompleteException If Amazon Route 53 can't process a request before the next request
     *         arrives, it will reject subsequent requests for the same hosted zone and return an
     *         <code>HTTP 400 error</code> (<code>Bad request</code>). If Route 53 returns this error repeatedly for the
     *         same request, we recommend that you wait, in intervals of increasing duration, before you try the request
     *         again.</li>
     *         <li>ConflictingTypesException You tried to update a traffic policy instance by using a traffic policy
     *         version that has a different DNS type than the current type for the instance. You specified the type in
     *         the JSON document in the <code>CreateTrafficPolicy</code> or <code>CreateTrafficPolicyVersion</code>
     *         request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Route53AsyncClient.UpdateTrafficPolicyInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/UpdateTrafficPolicyInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateTrafficPolicyInstanceResponse> updateTrafficPolicyInstance(
            UpdateTrafficPolicyInstanceRequest updateTrafficPolicyInstanceRequest) {
        try {

            HttpResponseHandler<UpdateTrafficPolicyInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    UpdateTrafficPolicyInstanceResponse::builder,
                    new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateTrafficPolicyInstanceRequest, UpdateTrafficPolicyInstanceResponse>()
                            .withOperationName("UpdateTrafficPolicyInstance")
                            .withMarshaller(new UpdateTrafficPolicyInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateTrafficPolicyInstanceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private AwsXmlProtocolFactory init() {
        return AwsXmlProtocolFactory
                .builder()
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConcurrentModification")
                                .exceptionBuilderSupplier(ConcurrentModificationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTrafficPolicyVersionsForCurrentPolicy")
                                .exceptionBuilderSupplier(TooManyTrafficPolicyVersionsForCurrentPolicyException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IncompatibleVersion")
                                .exceptionBuilderSupplier(IncompatibleVersionException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("VPCAssociationAuthorizationNotFound")
                                .exceptionBuilderSupplier(VpcAssociationAuthorizationNotFoundException::builder)
                                .httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchTrafficPolicy")
                                .exceptionBuilderSupplier(NoSuchTrafficPolicyException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTrafficPolicies")
                                .exceptionBuilderSupplier(TooManyTrafficPoliciesException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DelegationSetAlreadyCreated")
                                .exceptionBuilderSupplier(DelegationSetAlreadyCreatedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchHostedZone")
                                .exceptionBuilderSupplier(NoSuchHostedZoneException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("QueryLoggingConfigAlreadyExists")
                                .exceptionBuilderSupplier(QueryLoggingConfigAlreadyExistsException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("HostedZoneNotPrivate")
                                .exceptionBuilderSupplier(HostedZoneNotPrivateException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchGeoLocation")
                                .exceptionBuilderSupplier(NoSuchGeoLocationException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientCloudWatchLogsResourcePolicy")
                                .exceptionBuilderSupplier(InsufficientCloudWatchLogsResourcePolicyException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("HealthCheckVersionMismatch")
                                .exceptionBuilderSupplier(HealthCheckVersionMismatchException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PublicZoneVPCAssociation")
                                .exceptionBuilderSupplier(PublicZoneVpcAssociationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("HealthCheckAlreadyExists")
                                .exceptionBuilderSupplier(HealthCheckAlreadyExistsException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchDelegationSet")
                                .exceptionBuilderSupplier(NoSuchDelegationSetException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotAuthorizedException")
                                .exceptionBuilderSupplier(NotAuthorizedException::builder).httpStatusCode(401).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("VPCAssociationNotFound")
                                .exceptionBuilderSupplier(VpcAssociationNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyVPCAssociationAuthorizations")
                                .exceptionBuilderSupplier(TooManyVpcAssociationAuthorizationsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidVPCId")
                                .exceptionBuilderSupplier(InvalidVpcIdException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTrafficPolicyInstances")
                                .exceptionBuilderSupplier(TooManyTrafficPolicyInstancesException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPaginationToken")
                                .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DelegationSetNotAvailable")
                                .exceptionBuilderSupplier(DelegationSetNotAvailableException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchTrafficPolicyInstance")
                                .exceptionBuilderSupplier(NoSuchTrafficPolicyInstanceException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("HostedZoneNotEmpty")
                                .exceptionBuilderSupplier(HostedZoneNotEmptyException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDomainName")
                                .exceptionBuilderSupplier(InvalidDomainNameException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyHealthChecks")
                                .exceptionBuilderSupplier(TooManyHealthChecksException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidChangeBatch")
                                .exceptionBuilderSupplier(InvalidChangeBatchException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("HostedZoneAlreadyExists")
                                .exceptionBuilderSupplier(HostedZoneAlreadyExistsException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTrafficPolicyDocument")
                                .exceptionBuilderSupplier(InvalidTrafficPolicyDocumentException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TrafficPolicyAlreadyExists")
                                .exceptionBuilderSupplier(TrafficPolicyAlreadyExistsException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DelegationSetAlreadyReusable")
                                .exceptionBuilderSupplier(DelegationSetAlreadyReusableException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TrafficPolicyInUse")
                                .exceptionBuilderSupplier(TrafficPolicyInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyHostedZones")
                                .exceptionBuilderSupplier(TooManyHostedZonesException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TrafficPolicyInstanceAlreadyExists")
                                .exceptionBuilderSupplier(TrafficPolicyInstanceAlreadyExistsException::builder)
                                .httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchChange")
                                .exceptionBuilderSupplier(NoSuchChangeException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictingTypes")
                                .exceptionBuilderSupplier(ConflictingTypesException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DelegationSetNotReusable")
                                .exceptionBuilderSupplier(DelegationSetNotReusableException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PriorRequestNotComplete")
                                .exceptionBuilderSupplier(PriorRequestNotCompleteException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("HostedZoneNotFound")
                                .exceptionBuilderSupplier(HostedZoneNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidArgument")
                                .exceptionBuilderSupplier(InvalidArgumentException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidInput")
                                .exceptionBuilderSupplier(InvalidInputException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictingDomainExists")
                                .exceptionBuilderSupplier(ConflictingDomainExistsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DelegationSetInUse")
                                .exceptionBuilderSupplier(DelegationSetInUseException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchQueryLoggingConfig")
                                .exceptionBuilderSupplier(NoSuchQueryLoggingConfigException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchHealthCheck")
                                .exceptionBuilderSupplier(NoSuchHealthCheckException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LastVPCAssociation")
                                .exceptionBuilderSupplier(LastVpcAssociationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchCloudWatchLogsLogGroup")
                                .exceptionBuilderSupplier(NoSuchCloudWatchLogsLogGroupException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitsExceeded")
                                .exceptionBuilderSupplier(LimitsExceededException::builder).build())
                .clientConfiguration(clientConfiguration).defaultServiceExceptionSupplier(Route53Exception::builder).build();
    }

    private <T extends Route53Request> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }
}
