/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the request to create a hosted zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetReusableDelegationSetLimitRequest extends Route53Request implements
        ToCopyableBuilder<GetReusableDelegationSetLimitRequest.Builder, GetReusableDelegationSetLimitRequest> {
    private static final SdkField<String> TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(GetReusableDelegationSetLimitRequest::typeAsString))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Type").unmarshallLocationName("Type")
                    .build()).build();

    private static final SdkField<String> DELEGATION_SET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(GetReusableDelegationSetLimitRequest::delegationSetId))
            .setter(setter(Builder::delegationSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            DELEGATION_SET_ID_FIELD));

    private final String type;

    private final String delegationSetId;

    private GetReusableDelegationSetLimitRequest(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.delegationSetId = builder.delegationSetId;
    }

    /**
     * <p>
     * Specify <code>MAX_ZONES_BY_REUSABLE_DELEGATION_SET</code> to get the maximum number of hosted zones that you can
     * associate with the specified reusable delegation set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ReusableDelegationSetLimitType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return Specify <code>MAX_ZONES_BY_REUSABLE_DELEGATION_SET</code> to get the maximum number of hosted zones that
     *         you can associate with the specified reusable delegation set.
     * @see ReusableDelegationSetLimitType
     */
    public ReusableDelegationSetLimitType type() {
        return ReusableDelegationSetLimitType.fromValue(type);
    }

    /**
     * <p>
     * Specify <code>MAX_ZONES_BY_REUSABLE_DELEGATION_SET</code> to get the maximum number of hosted zones that you can
     * associate with the specified reusable delegation set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ReusableDelegationSetLimitType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return Specify <code>MAX_ZONES_BY_REUSABLE_DELEGATION_SET</code> to get the maximum number of hosted zones that
     *         you can associate with the specified reusable delegation set.
     * @see ReusableDelegationSetLimitType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The ID of the delegation set that you want to get the limit for.
     * </p>
     * 
     * @return The ID of the delegation set that you want to get the limit for.
     */
    public String delegationSetId() {
        return delegationSetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(delegationSetId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReusableDelegationSetLimitRequest)) {
            return false;
        }
        GetReusableDelegationSetLimitRequest other = (GetReusableDelegationSetLimitRequest) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(delegationSetId(), other.delegationSetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetReusableDelegationSetLimitRequest").add("Type", typeAsString())
                .add("DelegationSetId", delegationSetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "DelegationSetId":
            return Optional.ofNullable(clazz.cast(delegationSetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReusableDelegationSetLimitRequest, T> g) {
        return obj -> g.apply((GetReusableDelegationSetLimitRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Request.Builder, SdkPojo,
            CopyableBuilder<Builder, GetReusableDelegationSetLimitRequest> {
        /**
         * <p>
         * Specify <code>MAX_ZONES_BY_REUSABLE_DELEGATION_SET</code> to get the maximum number of hosted zones that you
         * can associate with the specified reusable delegation set.
         * </p>
         * 
         * @param type
         *        Specify <code>MAX_ZONES_BY_REUSABLE_DELEGATION_SET</code> to get the maximum number of hosted zones
         *        that you can associate with the specified reusable delegation set.
         * @see ReusableDelegationSetLimitType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReusableDelegationSetLimitType
         */
        Builder type(String type);

        /**
         * <p>
         * Specify <code>MAX_ZONES_BY_REUSABLE_DELEGATION_SET</code> to get the maximum number of hosted zones that you
         * can associate with the specified reusable delegation set.
         * </p>
         * 
         * @param type
         *        Specify <code>MAX_ZONES_BY_REUSABLE_DELEGATION_SET</code> to get the maximum number of hosted zones
         *        that you can associate with the specified reusable delegation set.
         * @see ReusableDelegationSetLimitType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReusableDelegationSetLimitType
         */
        Builder type(ReusableDelegationSetLimitType type);

        /**
         * <p>
         * The ID of the delegation set that you want to get the limit for.
         * </p>
         * 
         * @param delegationSetId
         *        The ID of the delegation set that you want to get the limit for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegationSetId(String delegationSetId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String type;

        private String delegationSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReusableDelegationSetLimitRequest model) {
            super(model);
            type(model.type);
            delegationSetId(model.delegationSetId);
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ReusableDelegationSetLimitType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getDelegationSetId() {
            return delegationSetId;
        }

        @Override
        public final Builder delegationSetId(String delegationSetId) {
            this.delegationSetId = delegationSetId;
            return this;
        }

        public final void setDelegationSetId(String delegationSetId) {
            this.delegationSetId = delegationSetId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetReusableDelegationSetLimitRequest build() {
            return new GetReusableDelegationSetLimitRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
