/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response to the <code>UpdateHostedZoneComment</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateHostedZoneCommentResponse extends Route53Response implements
        ToCopyableBuilder<UpdateHostedZoneCommentResponse.Builder, UpdateHostedZoneCommentResponse> {
    private static final SdkField<HostedZone> HOSTED_ZONE_FIELD = SdkField
            .<HostedZone> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateHostedZoneCommentResponse::hostedZone))
            .setter(setter(Builder::hostedZone))
            .constructor(HostedZone::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZone")
                    .unmarshallLocationName("HostedZone").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONE_FIELD));

    private final HostedZone hostedZone;

    private UpdateHostedZoneCommentResponse(BuilderImpl builder) {
        super(builder);
        this.hostedZone = builder.hostedZone;
    }

    /**
     * <p>
     * A complex type that contains the response to the <code>UpdateHostedZoneComment</code> request.
     * </p>
     * 
     * @return A complex type that contains the response to the <code>UpdateHostedZoneComment</code> request.
     */
    public HostedZone hostedZone() {
        return hostedZone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostedZone());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateHostedZoneCommentResponse)) {
            return false;
        }
        UpdateHostedZoneCommentResponse other = (UpdateHostedZoneCommentResponse) obj;
        return Objects.equals(hostedZone(), other.hostedZone());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateHostedZoneCommentResponse").add("HostedZone", hostedZone()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostedZone":
            return Optional.ofNullable(clazz.cast(hostedZone()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateHostedZoneCommentResponse, T> g) {
        return obj -> g.apply((UpdateHostedZoneCommentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo, CopyableBuilder<Builder, UpdateHostedZoneCommentResponse> {
        /**
         * <p>
         * A complex type that contains the response to the <code>UpdateHostedZoneComment</code> request.
         * </p>
         * 
         * @param hostedZone
         *        A complex type that contains the response to the <code>UpdateHostedZoneComment</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZone(HostedZone hostedZone);

        /**
         * <p>
         * A complex type that contains the response to the <code>UpdateHostedZoneComment</code> request.
         * </p>
         * This is a convenience that creates an instance of the {@link HostedZone.Builder} avoiding the need to create
         * one manually via {@link HostedZone#builder()}.
         *
         * When the {@link Consumer} completes, {@link HostedZone.Builder#build()} is called immediately and its result
         * is passed to {@link #hostedZone(HostedZone)}.
         * 
         * @param hostedZone
         *        a consumer that will call methods on {@link HostedZone.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hostedZone(HostedZone)
         */
        default Builder hostedZone(Consumer<HostedZone.Builder> hostedZone) {
            return hostedZone(HostedZone.builder().applyMutation(hostedZone).build());
        }
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private HostedZone hostedZone;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateHostedZoneCommentResponse model) {
            super(model);
            hostedZone(model.hostedZone);
        }

        public final HostedZone.Builder getHostedZone() {
            return hostedZone != null ? hostedZone.toBuilder() : null;
        }

        @Override
        public final Builder hostedZone(HostedZone hostedZone) {
            this.hostedZone = hostedZone;
            return this;
        }

        public final void setHostedZone(HostedZone.BuilderImpl hostedZone) {
            this.hostedZone = hostedZone != null ? hostedZone.build() : null;
        }

        @Override
        public UpdateHostedZoneCommentResponse build() {
            return new UpdateHostedZoneCommentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
