/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to get the status for a health check.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetHealthCheckStatusRequest extends Route53Request implements
        ToCopyableBuilder<GetHealthCheckStatusRequest.Builder, GetHealthCheckStatusRequest> {
    private static final SdkField<String> HEALTH_CHECK_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(GetHealthCheckStatusRequest::healthCheckId))
            .setter(setter(Builder::healthCheckId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("HealthCheckId")
                    .unmarshallLocationName("HealthCheckId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEALTH_CHECK_ID_FIELD));

    private final String healthCheckId;

    private GetHealthCheckStatusRequest(BuilderImpl builder) {
        super(builder);
        this.healthCheckId = builder.healthCheckId;
    }

    /**
     * <p>
     * The ID for the health check that you want the current status for. When you created the health check,
     * <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.
     * </p>
     * <note>
     * <p>
     * If you want to check the status of a calculated health check, you must use the Amazon Route 53 console or the
     * CloudWatch console. You can't use <code>GetHealthCheckStatus</code> to get the status of a calculated health
     * check.
     * </p>
     * </note>
     * 
     * @return The ID for the health check that you want the current status for. When you created the health check,
     *         <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code>
     *         element.</p> <note>
     *         <p>
     *         If you want to check the status of a calculated health check, you must use the Amazon Route 53 console or
     *         the CloudWatch console. You can't use <code>GetHealthCheckStatus</code> to get the status of a calculated
     *         health check.
     *         </p>
     */
    public String healthCheckId() {
        return healthCheckId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHealthCheckStatusRequest)) {
            return false;
        }
        GetHealthCheckStatusRequest other = (GetHealthCheckStatusRequest) obj;
        return Objects.equals(healthCheckId(), other.healthCheckId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetHealthCheckStatusRequest").add("HealthCheckId", healthCheckId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HealthCheckId":
            return Optional.ofNullable(clazz.cast(healthCheckId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetHealthCheckStatusRequest, T> g) {
        return obj -> g.apply((GetHealthCheckStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Request.Builder, SdkPojo, CopyableBuilder<Builder, GetHealthCheckStatusRequest> {
        /**
         * <p>
         * The ID for the health check that you want the current status for. When you created the health check,
         * <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.
         * </p>
         * <note>
         * <p>
         * If you want to check the status of a calculated health check, you must use the Amazon Route 53 console or the
         * CloudWatch console. You can't use <code>GetHealthCheckStatus</code> to get the status of a calculated health
         * check.
         * </p>
         * </note>
         * 
         * @param healthCheckId
         *        The ID for the health check that you want the current status for. When you created the health check,
         *        <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code>
         *        element.</p> <note>
         *        <p>
         *        If you want to check the status of a calculated health check, you must use the Amazon Route 53 console
         *        or the CloudWatch console. You can't use <code>GetHealthCheckStatus</code> to get the status of a
         *        calculated health check.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckId(String healthCheckId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String healthCheckId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHealthCheckStatusRequest model) {
            super(model);
            healthCheckId(model.healthCheckId);
        }

        public final String getHealthCheckId() {
            return healthCheckId;
        }

        @Override
        public final Builder healthCheckId(String healthCheckId) {
            this.healthCheckId = healthCheckId;
            return this;
        }

        public final void setHealthCheckId(String healthCheckId) {
            this.healthCheckId = healthCheckId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetHealthCheckStatusRequest build() {
            return new GetHealthCheckStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
