/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the tags that you want to add, edit, or delete.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChangeTagsForResourceRequest extends Route53Request implements
        ToCopyableBuilder<ChangeTagsForResourceRequest.Builder, ChangeTagsForResourceRequest> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ChangeTagsForResourceRequest::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ResourceType")
                    .unmarshallLocationName("ResourceType").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ChangeTagsForResourceRequest::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ResourceId")
                    .unmarshallLocationName("ResourceId").build()).build();

    private static final SdkField<List<Tag>> ADD_TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(ChangeTagsForResourceRequest::addTags))
            .setter(setter(Builder::addTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddTags")
                    .unmarshallLocationName("AddTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").unmarshallLocationName("Tag").build()).build()).build())
            .build();

    private static final SdkField<List<String>> REMOVE_TAG_KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ChangeTagsForResourceRequest::removeTagKeys))
            .setter(setter(Builder::removeTagKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveTagKeys")
                    .unmarshallLocationName("RemoveTagKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Key")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Key").unmarshallLocationName("Key").build()).build()).build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD,
            RESOURCE_ID_FIELD, ADD_TAGS_FIELD, REMOVE_TAG_KEYS_FIELD));

    private final String resourceType;

    private final String resourceId;

    private final List<Tag> addTags;

    private final List<String> removeTagKeys;

    private ChangeTagsForResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.addTags = builder.addTags;
        this.removeTagKeys = builder.removeTagKeys;
    }

    /**
     * <p>
     * The type of the resource.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The resource type for health checks is <code>healthcheck</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The resource type for hosted zones is <code>hostedzone</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link TagResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of the resource.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The resource type for health checks is <code>healthcheck</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The resource type for hosted zones is <code>hostedzone</code>.
     *         </p>
     *         </li>
     * @see TagResourceType
     */
    public TagResourceType resourceType() {
        return TagResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of the resource.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The resource type for health checks is <code>healthcheck</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The resource type for hosted zones is <code>hostedzone</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link TagResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of the resource.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The resource type for health checks is <code>healthcheck</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The resource type for hosted zones is <code>hostedzone</code>.
     *         </p>
     *         </li>
     * @see TagResourceType
     */
    public String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The ID of the resource for which you want to add, change, or delete tags.
     * </p>
     * 
     * @return The ID of the resource for which you want to add, change, or delete tags.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * A complex type that contains a list of the tags that you want to add to the specified health check or hosted zone
     * and/or the tags that you want to edit <code>Value</code> for.
     * </p>
     * <p>
     * You can add a maximum of 10 tags to a health check or a hosted zone.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A complex type that contains a list of the tags that you want to add to the specified health check or
     *         hosted zone and/or the tags that you want to edit <code>Value</code> for.</p>
     *         <p>
     *         You can add a maximum of 10 tags to a health check or a hosted zone.
     */
    public List<Tag> addTags() {
        return addTags;
    }

    /**
     * <p>
     * A complex type that contains a list of the tags that you want to delete from the specified health check or hosted
     * zone. You can specify up to 10 keys.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A complex type that contains a list of the tags that you want to delete from the specified health check
     *         or hosted zone. You can specify up to 10 keys.
     */
    public List<String> removeTagKeys() {
        return removeTagKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(addTags());
        hashCode = 31 * hashCode + Objects.hashCode(removeTagKeys());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeTagsForResourceRequest)) {
            return false;
        }
        ChangeTagsForResourceRequest other = (ChangeTagsForResourceRequest) obj;
        return Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(resourceId(), other.resourceId()) && Objects.equals(addTags(), other.addTags())
                && Objects.equals(removeTagKeys(), other.removeTagKeys());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ChangeTagsForResourceRequest").add("ResourceType", resourceTypeAsString())
                .add("ResourceId", resourceId()).add("AddTags", addTags()).add("RemoveTagKeys", removeTagKeys()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "AddTags":
            return Optional.ofNullable(clazz.cast(addTags()));
        case "RemoveTagKeys":
            return Optional.ofNullable(clazz.cast(removeTagKeys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChangeTagsForResourceRequest, T> g) {
        return obj -> g.apply((ChangeTagsForResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Request.Builder, SdkPojo, CopyableBuilder<Builder, ChangeTagsForResourceRequest> {
        /**
         * <p>
         * The type of the resource.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The resource type for health checks is <code>healthcheck</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The resource type for hosted zones is <code>hostedzone</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceType
         *        The type of the resource.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The resource type for health checks is <code>healthcheck</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The resource type for hosted zones is <code>hostedzone</code>.
         *        </p>
         *        </li>
         * @see TagResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TagResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of the resource.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The resource type for health checks is <code>healthcheck</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The resource type for hosted zones is <code>hostedzone</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceType
         *        The type of the resource.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The resource type for health checks is <code>healthcheck</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The resource type for hosted zones is <code>hostedzone</code>.
         *        </p>
         *        </li>
         * @see TagResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TagResourceType
         */
        Builder resourceType(TagResourceType resourceType);

        /**
         * <p>
         * The ID of the resource for which you want to add, change, or delete tags.
         * </p>
         * 
         * @param resourceId
         *        The ID of the resource for which you want to add, change, or delete tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * A complex type that contains a list of the tags that you want to add to the specified health check or hosted
         * zone and/or the tags that you want to edit <code>Value</code> for.
         * </p>
         * <p>
         * You can add a maximum of 10 tags to a health check or a hosted zone.
         * </p>
         * 
         * @param addTags
         *        A complex type that contains a list of the tags that you want to add to the specified health check or
         *        hosted zone and/or the tags that you want to edit <code>Value</code> for.</p>
         *        <p>
         *        You can add a maximum of 10 tags to a health check or a hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addTags(Collection<Tag> addTags);

        /**
         * <p>
         * A complex type that contains a list of the tags that you want to add to the specified health check or hosted
         * zone and/or the tags that you want to edit <code>Value</code> for.
         * </p>
         * <p>
         * You can add a maximum of 10 tags to a health check or a hosted zone.
         * </p>
         * 
         * @param addTags
         *        A complex type that contains a list of the tags that you want to add to the specified health check or
         *        hosted zone and/or the tags that you want to edit <code>Value</code> for.</p>
         *        <p>
         *        You can add a maximum of 10 tags to a health check or a hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addTags(Tag... addTags);

        /**
         * <p>
         * A complex type that contains a list of the tags that you want to add to the specified health check or hosted
         * zone and/or the tags that you want to edit <code>Value</code> for.
         * </p>
         * <p>
         * You can add a maximum of 10 tags to a health check or a hosted zone.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #addTags(List<Tag>)}.
         * 
         * @param addTags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addTags(List<Tag>)
         */
        Builder addTags(Consumer<Tag.Builder>... addTags);

        /**
         * <p>
         * A complex type that contains a list of the tags that you want to delete from the specified health check or
         * hosted zone. You can specify up to 10 keys.
         * </p>
         * 
         * @param removeTagKeys
         *        A complex type that contains a list of the tags that you want to delete from the specified health
         *        check or hosted zone. You can specify up to 10 keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeTagKeys(Collection<String> removeTagKeys);

        /**
         * <p>
         * A complex type that contains a list of the tags that you want to delete from the specified health check or
         * hosted zone. You can specify up to 10 keys.
         * </p>
         * 
         * @param removeTagKeys
         *        A complex type that contains a list of the tags that you want to delete from the specified health
         *        check or hosted zone. You can specify up to 10 keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeTagKeys(String... removeTagKeys);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String resourceType;

        private String resourceId;

        private List<Tag> addTags = DefaultSdkAutoConstructList.getInstance();

        private List<String> removeTagKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeTagsForResourceRequest model) {
            super(model);
            resourceType(model.resourceType);
            resourceId(model.resourceId);
            addTags(model.addTags);
            removeTagKeys(model.removeTagKeys);
        }

        public final String getResourceTypeAsString() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(TagResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final Collection<Tag.Builder> getAddTags() {
            return addTags != null ? addTags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder addTags(Collection<Tag> addTags) {
            this.addTags = TagListCopier.copy(addTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addTags(Tag... addTags) {
            addTags(Arrays.asList(addTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addTags(Consumer<Tag.Builder>... addTags) {
            addTags(Stream.of(addTags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAddTags(Collection<Tag.BuilderImpl> addTags) {
            this.addTags = TagListCopier.copyFromBuilder(addTags);
        }

        public final Collection<String> getRemoveTagKeys() {
            return removeTagKeys;
        }

        @Override
        public final Builder removeTagKeys(Collection<String> removeTagKeys) {
            this.removeTagKeys = TagKeyListCopier.copy(removeTagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeTagKeys(String... removeTagKeys) {
            removeTagKeys(Arrays.asList(removeTagKeys));
            return this;
        }

        public final void setRemoveTagKeys(Collection<String> removeTagKeys) {
            this.removeTagKeys = TagKeyListCopier.copy(removeTagKeys);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ChangeTagsForResourceRequest build() {
            return new ChangeTagsForResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
