/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the last failure reason as reported by one Amazon Route 53 health checker.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HealthCheckObservation implements SdkPojo, Serializable,
        ToCopyableBuilder<HealthCheckObservation.Builder, HealthCheckObservation> {
    private static final SdkField<String> REGION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(HealthCheckObservation::regionAsString))
            .setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region")
                    .unmarshallLocationName("Region").build()).build();

    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(HealthCheckObservation::ipAddress))
            .setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPAddress")
                    .unmarshallLocationName("IPAddress").build()).build();

    private static final SdkField<StatusReport> STATUS_REPORT_FIELD = SdkField
            .<StatusReport> builder(MarshallingType.SDK_POJO)
            .getter(getter(HealthCheckObservation::statusReport))
            .setter(setter(Builder::statusReport))
            .constructor(StatusReport::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReport")
                    .unmarshallLocationName("StatusReport").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD,
            IP_ADDRESS_FIELD, STATUS_REPORT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String region;

    private final String ipAddress;

    private final StatusReport statusReport;

    private HealthCheckObservation(BuilderImpl builder) {
        this.region = builder.region;
        this.ipAddress = builder.ipAddress;
        this.statusReport = builder.statusReport;
    }

    /**
     * <p>
     * The region of the Amazon Route 53 health checker that provided the status in <code>StatusReport</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #region} will
     * return {@link HealthCheckRegion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #regionAsString}.
     * </p>
     * 
     * @return The region of the Amazon Route 53 health checker that provided the status in <code>StatusReport</code>.
     * @see HealthCheckRegion
     */
    public HealthCheckRegion region() {
        return HealthCheckRegion.fromValue(region);
    }

    /**
     * <p>
     * The region of the Amazon Route 53 health checker that provided the status in <code>StatusReport</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #region} will
     * return {@link HealthCheckRegion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #regionAsString}.
     * </p>
     * 
     * @return The region of the Amazon Route 53 health checker that provided the status in <code>StatusReport</code>.
     * @see HealthCheckRegion
     */
    public String regionAsString() {
        return region;
    }

    /**
     * <p>
     * The IP address of the Amazon Route 53 health checker that provided the failure reason in
     * <code>StatusReport</code>.
     * </p>
     * 
     * @return The IP address of the Amazon Route 53 health checker that provided the failure reason in
     *         <code>StatusReport</code>.
     */
    public String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * A complex type that contains the last failure reason as reported by one Amazon Route 53 health checker and the
     * time of the failed health check.
     * </p>
     * 
     * @return A complex type that contains the last failure reason as reported by one Amazon Route 53 health checker
     *         and the time of the failed health check.
     */
    public StatusReport statusReport() {
        return statusReport;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(regionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(statusReport());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheckObservation)) {
            return false;
        }
        HealthCheckObservation other = (HealthCheckObservation) obj;
        return Objects.equals(regionAsString(), other.regionAsString()) && Objects.equals(ipAddress(), other.ipAddress())
                && Objects.equals(statusReport(), other.statusReport());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HealthCheckObservation").add("Region", regionAsString()).add("IPAddress", ipAddress())
                .add("StatusReport", statusReport()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Region":
            return Optional.ofNullable(clazz.cast(regionAsString()));
        case "IPAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        case "StatusReport":
            return Optional.ofNullable(clazz.cast(statusReport()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HealthCheckObservation, T> g) {
        return obj -> g.apply((HealthCheckObservation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HealthCheckObservation> {
        /**
         * <p>
         * The region of the Amazon Route 53 health checker that provided the status in <code>StatusReport</code>.
         * </p>
         * 
         * @param region
         *        The region of the Amazon Route 53 health checker that provided the status in <code>StatusReport</code>
         *        .
         * @see HealthCheckRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HealthCheckRegion
         */
        Builder region(String region);

        /**
         * <p>
         * The region of the Amazon Route 53 health checker that provided the status in <code>StatusReport</code>.
         * </p>
         * 
         * @param region
         *        The region of the Amazon Route 53 health checker that provided the status in <code>StatusReport</code>
         *        .
         * @see HealthCheckRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HealthCheckRegion
         */
        Builder region(HealthCheckRegion region);

        /**
         * <p>
         * The IP address of the Amazon Route 53 health checker that provided the failure reason in
         * <code>StatusReport</code>.
         * </p>
         * 
         * @param ipAddress
         *        The IP address of the Amazon Route 53 health checker that provided the failure reason in
         *        <code>StatusReport</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * A complex type that contains the last failure reason as reported by one Amazon Route 53 health checker and
         * the time of the failed health check.
         * </p>
         * 
         * @param statusReport
         *        A complex type that contains the last failure reason as reported by one Amazon Route 53 health checker
         *        and the time of the failed health check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReport(StatusReport statusReport);

        /**
         * <p>
         * A complex type that contains the last failure reason as reported by one Amazon Route 53 health checker and
         * the time of the failed health check.
         * </p>
         * This is a convenience that creates an instance of the {@link StatusReport.Builder} avoiding the need to
         * create one manually via {@link StatusReport#builder()}.
         *
         * When the {@link Consumer} completes, {@link StatusReport.Builder#build()} is called immediately and its
         * result is passed to {@link #statusReport(StatusReport)}.
         * 
         * @param statusReport
         *        a consumer that will call methods on {@link StatusReport.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusReport(StatusReport)
         */
        default Builder statusReport(Consumer<StatusReport.Builder> statusReport) {
            return statusReport(StatusReport.builder().applyMutation(statusReport).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String region;

        private String ipAddress;

        private StatusReport statusReport;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheckObservation model) {
            region(model.region);
            ipAddress(model.ipAddress);
            statusReport(model.statusReport);
        }

        public final String getRegionAsString() {
            return region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        public final Builder region(HealthCheckRegion region) {
            this.region(region.toString());
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final StatusReport.Builder getStatusReport() {
            return statusReport != null ? statusReport.toBuilder() : null;
        }

        @Override
        public final Builder statusReport(StatusReport statusReport) {
            this.statusReport = statusReport;
            return this;
        }

        public final void setStatusReport(StatusReport.BuilderImpl statusReport) {
            this.statusReport = statusReport != null ? statusReport.build() : null;
        }

        @Override
        public HealthCheckObservation build() {
            return new HealthCheckObservation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
