/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the latest version of one traffic policy that is associated with the
 * current AWS account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrafficPolicySummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TrafficPolicySummary.Builder, TrafficPolicySummary> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TrafficPolicySummary::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TrafficPolicySummary::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TrafficPolicySummary::typeAsString))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type")
                    .unmarshallLocationName("Type").build()).build();

    private static final SdkField<Integer> LATEST_VERSION_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(TrafficPolicySummary::latestVersion))
            .setter(setter(Builder::latestVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersion")
                    .unmarshallLocationName("LatestVersion").build()).build();

    private static final SdkField<Integer> TRAFFIC_POLICY_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(TrafficPolicySummary::trafficPolicyCount))
            .setter(setter(Builder::trafficPolicyCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyCount")
                    .unmarshallLocationName("TrafficPolicyCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            TYPE_FIELD, LATEST_VERSION_FIELD, TRAFFIC_POLICY_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String type;

    private final Integer latestVersion;

    private final Integer trafficPolicyCount;

    private TrafficPolicySummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.type = builder.type;
        this.latestVersion = builder.latestVersion;
        this.trafficPolicyCount = builder.trafficPolicyCount;
    }

    /**
     * <p>
     * The ID that Amazon Route 53 assigned to the traffic policy when you created it.
     * </p>
     * 
     * @return The ID that Amazon Route 53 assigned to the traffic policy when you created it.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The name that you specified for the traffic policy when you created it.
     * </p>
     * 
     * @return The name that you specified for the traffic policy when you created it.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The DNS type of the resource record sets that Amazon Route 53 creates when you use a traffic policy to create a
     * traffic policy instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RRType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The DNS type of the resource record sets that Amazon Route 53 creates when you use a traffic policy to
     *         create a traffic policy instance.
     * @see RRType
     */
    public RRType type() {
        return RRType.fromValue(type);
    }

    /**
     * <p>
     * The DNS type of the resource record sets that Amazon Route 53 creates when you use a traffic policy to create a
     * traffic policy instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RRType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The DNS type of the resource record sets that Amazon Route 53 creates when you use a traffic policy to
     *         create a traffic policy instance.
     * @see RRType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The version number of the latest version of the traffic policy.
     * </p>
     * 
     * @return The version number of the latest version of the traffic policy.
     */
    public Integer latestVersion() {
        return latestVersion;
    }

    /**
     * <p>
     * The number of traffic policies that are associated with the current AWS account.
     * </p>
     * 
     * @return The number of traffic policies that are associated with the current AWS account.
     */
    public Integer trafficPolicyCount() {
        return trafficPolicyCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficPolicySummary)) {
            return false;
        }
        TrafficPolicySummary other = (TrafficPolicySummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(latestVersion(), other.latestVersion())
                && Objects.equals(trafficPolicyCount(), other.trafficPolicyCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TrafficPolicySummary").add("Id", id()).add("Name", name()).add("Type", typeAsString())
                .add("LatestVersion", latestVersion()).add("TrafficPolicyCount", trafficPolicyCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "LatestVersion":
            return Optional.ofNullable(clazz.cast(latestVersion()));
        case "TrafficPolicyCount":
            return Optional.ofNullable(clazz.cast(trafficPolicyCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrafficPolicySummary, T> g) {
        return obj -> g.apply((TrafficPolicySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrafficPolicySummary> {
        /**
         * <p>
         * The ID that Amazon Route 53 assigned to the traffic policy when you created it.
         * </p>
         * 
         * @param id
         *        The ID that Amazon Route 53 assigned to the traffic policy when you created it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name that you specified for the traffic policy when you created it.
         * </p>
         * 
         * @param name
         *        The name that you specified for the traffic policy when you created it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The DNS type of the resource record sets that Amazon Route 53 creates when you use a traffic policy to create
         * a traffic policy instance.
         * </p>
         * 
         * @param type
         *        The DNS type of the resource record sets that Amazon Route 53 creates when you use a traffic policy to
         *        create a traffic policy instance.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder type(String type);

        /**
         * <p>
         * The DNS type of the resource record sets that Amazon Route 53 creates when you use a traffic policy to create
         * a traffic policy instance.
         * </p>
         * 
         * @param type
         *        The DNS type of the resource record sets that Amazon Route 53 creates when you use a traffic policy to
         *        create a traffic policy instance.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder type(RRType type);

        /**
         * <p>
         * The version number of the latest version of the traffic policy.
         * </p>
         * 
         * @param latestVersion
         *        The version number of the latest version of the traffic policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersion(Integer latestVersion);

        /**
         * <p>
         * The number of traffic policies that are associated with the current AWS account.
         * </p>
         * 
         * @param trafficPolicyCount
         *        The number of traffic policies that are associated with the current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyCount(Integer trafficPolicyCount);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String type;

        private Integer latestVersion;

        private Integer trafficPolicyCount;

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficPolicySummary model) {
            id(model.id);
            name(model.name);
            type(model.type);
            latestVersion(model.latestVersion);
            trafficPolicyCount(model.trafficPolicyCount);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RRType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Integer getLatestVersion() {
            return latestVersion;
        }

        @Override
        public final Builder latestVersion(Integer latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public final void setLatestVersion(Integer latestVersion) {
            this.latestVersion = latestVersion;
        }

        public final Integer getTrafficPolicyCount() {
            return trafficPolicyCount;
        }

        @Override
        public final Builder trafficPolicyCount(Integer trafficPolicyCount) {
            this.trafficPolicyCount = trafficPolicyCount;
            return this;
        }

        public final void setTrafficPolicyCount(Integer trafficPolicyCount) {
            this.trafficPolicyCount = trafficPolicyCount;
        }

        @Override
        public TrafficPolicySummary build() {
            return new TrafficPolicySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
